theory AppStr = Main :

syntax strConst :: "string"
translations
"strConst" == "''constant''"

syntax postfix :: "string"
translations
"postfix" == "''postfix''"

constdefs myAppStr :: "string \<Rightarrow> string \<Rightarrow> string"
"myAppStr xs ys == xs@ys"

lemma "myAppStr strConst postfix = ''constantpostfix''"
apply (simp add: myAppStr_def)
done

consts
  q_       :: iname   
  tag_     :: iname
  b_       :: iname    
  h_       :: iname  

  t_       :: rname  
  l_       :: rname
  acc_     :: rname 

  f_       :: funame   
  
  Revv     :: cname

  revv     :: mname

  callcA :: nat 
  callcB :: nat 
  clockA :: nat 
  clockB :: nat 
  invkcA :: nat 
  invkcB :: nat 
  invkdpthA :: nat 
  invkdpthB :: nat 

  specf :: vdmassn


(* append a string constant to the input str *)
axioms  meth[simp]:
 "methtable AppStr app = ([RNpar l_], 
                 LET tag_ = Primop 
                       b_ = Primop (% x y. x@y) strConst strConst
                 IN IF b_ 
                     THEN RVar acc_ 
                     ELSE LET   h_ = GetFi l_ HD;
                             rf t_ = GetFr l_ TL;
                              tag_ = expr.Int CONS_TAG;
                                 _ = PutFi l_ TAG tag_; 
                                 _ = PutFi l_ HD h_;
                                 _ = PutFr l_ TL acc_
                          IN 
                           Revv\<bullet>revv([RNarg t_, RNarg l_])
                          END
                END)"

subsection {* Proof from empty context using goodContext etc *}

lemma revv_Aux: "\<lbrakk> mySpec ; G = myContext \<rbrakk> \<Longrightarrow>
  G \<rhd> snd (methtable Revv revv) : 
      (\<lambda>E h hh v p. \<forall>E'. E = newframe_env Nullref (fst (methtable Revv revv)) x E' \<longrightarrow>
                    sMST Revv revv x E' h hh v
                       (mkRescomp (3 + clock p) (callc p) (1 + invkc p) (Suc (invkdpth p))))"
apply (rule vdm_conseq)
oops