theory testVCG1 = TreeVCG:
ML_setup {*
  val basicsimpset_tac = simp_tac HOL_basic_ss
  fun sym_basicsimp i = FIRST [CHANGED (simp_tac HOL_basic_ss i), rtac add_commute i]

  fun localsimp_tac ctxt i = simp_tac (Simplifier.get_local_simpset ctxt) i
  fun localsimp_tac_thms ctxt thms = 
     simp_tac ((Simplifier.get_local_simpset ctxt) addsimps thms)
  fun simpset_tac_thms t i = simp_tac (HOL_basic_ss addsimps ([fst_conv,snd_conv]@t)) i

  fun repeat 0 tac = all_tac
    | repeat n tac = tac THEN (repeat (n-1) tac)

  val mrg_int = thm "MRG_Int"
  val mrg_ivar = thm "MRG_IVar"
  val mrg_rvar = thm "MRG_RVar"
  val mrg_prim = thm "MRG_Prim"
  val mrg_rprim = thm "MRG_RPrim"
  val mrg_nulllist = thm "MRG_NullList"
  val mrg_nullres = thm "MRG_NullRes"
  val mrg_nulltree = thm "MRG_NullTree"
  val mrg_makelist = thm "MRG_MakeList"
  val mrg_maketree = thm "MRG_MakeTree"
  val mrg_makeresult = thm "MRG_MakeResultSome"
  val mrg_invstat = thm "MRG_InvStat"
  val mrg_letv = thm "MRG_Letv"
  val mrg_leti = thm "MRG_Leti"
  val mrg_letr = thm "MRG_Letr"
  val mrg_listmatch = thm "MRG_ListMatch"
  val mrg_listmatchd = thm "MRG_ListMatchD"
  val mrg_treematch = thm "MRG_TreeMatch"
  val mrg_treematchd = thm "MRG_TreeMatchD"
  val mrg_resultmatch = thm "MRG_ResultMatch"
  val mrg_resultmatchd = thm "MRG_ResultMatchD"
  val mrg_if = thm "MRG_If"
  val mrg_weak = thm "MRG_Weak"

  val mrg_call = thm "MRG_Call"
  val mrg_domcallnil = thm "DOM_CallNIL"
  val mrg_domcallcons = thm "DOM_CallCONS"

  val rena_nil = thm "RENA_NIL"
  val rena_in = thm "RENA_IN"
  val rena_rn = thm "RENA_RN"

  val mrg_sound = thm "MRG_sound"

  fun getr_tac ctxt i = localsimp_tac ctxt i
  fun getr_clar_tac ctxt i = EVERY [localsimp_tac ctxt i, clarify_tac HOL_cs i]
  fun getr_fast ctxt i = FIRST [SOLVE (getr_tac ctxt i), EVERY [getr_tac ctxt i, fast_tac (claset()) i]]

  fun bsf i = FIRST [SOLVE (basicsimpset_tac i), EVERY [basicsimpset_tac i, fast_tac (claset()) i]]
  fun lsf ctxt i = FIRST [SOLVE (localsimp_tac ctxt i), EVERY [localsimp_tac ctxt i, fast_tac (claset()) i]]

  fun type_tac i = basicsimpset_tac i
  fun context_tac ctxt thms i = localsimp_tac_thms ctxt thms i

  fun stop ctxt thms i = all_tac

  fun ast i = asm_simp_tac (simpset()) i 

  fun ast_thms thms i = 
     asm_simp_tac ((simpset()) addsimps thms) i

  fun ast_fast i =
         SELECT_GOAL (FIRST[SOLVE (ast i),
                            EVERY [ast i,fast_tac (claset()) i]]) i
  fun ast_thms_fast thms i = 
         SELECT_GOAL (FIRST[SOLVE (ast_thms thms i), 
                            EVERY [ast_thms thms i,fast_tac (claset()) i]]) i

  fun RENA_tac i state = state |> 
    FIRST [EVERY [rtac rena_in i, RENA_tac i],
           EVERY [rtac rena_rn i, RENA_tac i],
           rtac rena_nil i]

  fun leaf_tac ctxt (thms  as (d_defs,m_defs,f_defs,c_defs)) i =
   FIRST [EVERY [rtac mrg_int i, localsimp_tac ctxt i],
          EVERY [rtac mrg_ivar i, localsimp_tac ctxt i],
          EVERY [rtac mrg_rvar i, getr_tac ctxt i, localsimp_tac ctxt i],
          EVERY [rtac mrg_prim i, localsimp_tac ctxt i],
          EVERY [rtac mrg_rprim i, repeat 2 (getr_tac ctxt i), localsimp_tac ctxt i],
          EVERY [rtac mrg_nulllist i, localsimp_tac ctxt i],
          EVERY [rtac mrg_nullres i, localsimp_tac ctxt i],
          EVERY [rtac mrg_nulltree i, localsimp_tac ctxt i],
          EVERY [rtac mrg_maketree i, getr_tac ctxt i, getr_tac ctxt i,
                 localsimp_tac ctxt i, localsimp_tac ctxt i],
          EVERY [rtac mrg_makelist i, getr_tac ctxt i, localsimp_tac ctxt i],
          EVERY [rtac mrg_makeresult i, getr_tac ctxt i, localsimp_tac ctxt i],
          EVERY [rtac mrg_invstat i,
                 localsimp_tac_thms ctxt c_defs i, 
                 localsimp_tac_thms ctxt m_defs i, 
                 ast_thms m_defs i,
                 ast i,
                 ast_thms_fast m_defs i, ast_fast i, 
                 repeat 2 (localsimp_tac_thms ctxt [thm "DOM_def"] i),
                 repeat 2 (localsimp_tac ctxt i),
                 ast_thms m_defs i,
                 RENA_tac i,
                 localsimp_tac ctxt i]
         ]
  fun let_tac ctxt thms rectac i = 
      FIRST [EVERY [rtac mrg_letv i, leaf_tac ctxt thms i, rectac i, bsf i],
             EVERY [rtac mrg_leti i, leaf_tac ctxt thms i, rectac i, bsf i],
             EVERY [rtac mrg_letr i, rectac i, leaf_tac ctxt thms i, bsf i, bsf i]]

  fun match_tac ctxt rectac i = 
    FIRST [EVERY [rtac mrg_listmatchd i, getr_fast ctxt i, basicsimpset_tac i, bsf i, rectac i, bsf i],
           EVERY [rtac mrg_resultmatchd i, getr_fast ctxt i, basicsimpset_tac i, bsf i, rectac i, bsf i],
           EVERY [rtac mrg_treematchd i, (getr_fast ctxt i), basicsimpset_tac i, bsf i, rectac i, bsf i],
           EVERY [rtac mrg_listmatch i, (getr_fast ctxt i), basicsimpset_tac i, rectac i, bsf i],
           EVERY [rtac mrg_resultmatch i, (getr_fast ctxt i), basicsimpset_tac i, rectac i, bsf i],
           EVERY [rtac mrg_treematch i, (getr_fast ctxt i), basicsimpset_tac i, bsf i, bsf i, rectac i, bsf i]]
             

  fun call_tac ctxt thms tac i =
   EVERY [rtac mrg_call i, 
	  localsimp_tac_thms ctxt thms i,
          tac i]

     (* here: solve a subgoal of the same form, then simplify with MFS_defs to expand method body
        in other subgoals (for each of the dominators?)
	We want to do this to maintain invariant for VCG.
        asm_localsimp_tac_thms ctxt thms 2
     *)
  fun asm_localsimp_tac ctxt = asm_simp_tac (Simplifier.get_local_simpset ctxt)
  fun funsimp_tac_thms t = simp_tac (HOL_basic_ss addsimps (snd_conv :: t))
  (* rec_tac : ctxt \<rightarrow> thms \<rightarrow> int \<rightarrow> tactic \<rightarrow> tactic \<rightarrow> int \<rightarrow> tactic*)
  fun dom_tac ctxt thms rec_tac tac2 i =
    let fun domcall n state = state |> 
       ((((rtac mrg_domcallcons i) THEN domcall (n+1))
	 ORELSE
	 (EVERY 
	  ([(rtac mrg_domcallnil i),
	    asm_localsimp_tac ctxt i,
	   (* asm_localsimp_tac_thms ctxt thms i,*)
	    funsimp_tac_thms thms i,
            rtac mrg_sound i,
	    rec_tac i] @
	   (map tac2 (rev (i upto (i+n-1)))))))
	 ORELSE
	 (* solve for a merge point by projecting on the context, 
	    solving a set-equality subgoal *)
	 (EVERY
	  [rtac conjI i,  (* leaves subgoal of form ?U = X *)
           localsimp_tac_thms ctxt thms i,
	   rtac disjI1 i,
	   localsimp_tac_thms ctxt thms i]))
      in domcall 0 end

  fun if_tac rec_tacTHEN rec_tacELSE i =
   EVERY [rtac mrg_if i,
          rec_tacTHEN i,
	  rec_tacELSE i]

  fun w_tac ctxt thms tac i = 
    EVERY
      [TRY(localsimp_tac_thms ctxt thms i),  (* expand SPEC, methtable *)
       rtac mrg_sound i,
       rtac mrg_weak i,
       tac i,
       fast_tac (claset()) i]

  fun w_tac_mrg ctxt thms tac i = 
    EVERY
      [TRY(localsimp_tac_thms ctxt thms i),  (* expand SPEC, methtable *)
       rtac mrg_weak i,
       tac i,
       fast_tac (claset()) i]

  fun main_stop ctxt (thms  as (d_defs,m_defs,f_defs,c_defs)) i state = state |> 
    FIRST [if_tac (stop ctxt thms) (stop ctxt thms) i,
           match_tac ctxt (stop ctxt thms) i,
           let_tac ctxt thms (stop ctxt thms) i,
           call_tac ctxt d_defs (stop ctxt thms) i,
           dom_tac ctxt f_defs (stop ctxt thms) (w_tac ctxt f_defs (stop ctxt thms)) i,
           leaf_tac ctxt thms i]

   fun main_tac ctxt (thms  as (d_defs,m_defs,f_defs,c_defs)) i state = state |> 
    FIRST [if_tac (main_tac ctxt thms) (main_tac ctxt thms) i,
           match_tac ctxt (main_tac ctxt thms) i,
           let_tac ctxt thms (main_tac ctxt thms) i,
           call_tac ctxt d_defs (main_tac ctxt thms) i,
           dom_tac ctxt f_defs (main_tac ctxt thms) (w_tac ctxt f_defs (main_tac ctxt thms)) i,
           leaf_tac ctxt thms i]
*}

method_setup AST_THMS = {* Method.thms_ctxt_args (fn thms => fn ctxt => 
  Method.METHOD (fn facts => (ast_thms thms 1)))*}
  "Method for asm_simp_tac"
method_setup AST_THMS_FAST = {* Method.thms_ctxt_args (fn thms => fn ctxt => 
  Method.METHOD (fn facts => (ast_thms_fast thms 1)))*}
  "Method for asm_simp_tac"
method_setup LEAF = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => leaf_tac ctxt ([],[],[],[]) 1))*}
  "Method for leaf rules"
method_setup BS = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => basicsimpset_tac 1))*}
  "Method for basic simpset"
method_setup BSF = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => bsf 1))*}
  "Method for basic simpset + fast"
method_setup SB = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => sym_basicsimp 1))*}
  "Method for symmetric basic simpset"
method_setup GT = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => getr_tac ctxt 1))*}
  "Method for GETr"
method_setup GTC = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => getr_clar_tac ctxt 1))*}
  "Method for GETr with clarify"
method_setup GTF = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => getr_fast ctxt 1))*}
  "Method for GETr with fast"
method_setup STT = {* Method.thms_ctxt_args (fn thms => fn ctxt => 
  Method.METHOD (fn facts => simpset_tac_thms thms 1))*}
  "Method for basic simpset"
method_setup LS = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => localsimp_tac ctxt 1))*}
  "Method for local simpset"
method_setup LSF = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => lsf ctxt 1))*}
  "Method for local simpset + fast"
method_setup LSTT = {* Method.thms_ctxt_args (fn thms => fn ctxt => 
  Method.METHOD (fn facts => localsimp_tac_thms ctxt thms 1))*}
  "Method for local_simpset_thms"
method_setup LET = {* Method.thms_ctxt_args (fn t => fn ctxt => 
  Method.METHOD (fn facts => let_tac ctxt ([],[],t,[]) (stop ctxt ([],[],[],[])) 1))*}
  "Method for local_simpset_thms"
method_setup MATCH = {* Method.thms_ctxt_args (fn t => fn ctxt => 
  Method.METHOD (fn facts => match_tac ctxt (stop ctxt ([],[],[],[])) 1))*}
  "Method for matches"
method_setup SBS = {* Method.thms_ctxt_args (fn thms => fn ctxt => 
  Method.METHOD (fn facts => (sym_basicsimp 1)))*}
  "Method for symbasicsimp"
method_setup ASM_LOC = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => 
    asm_simp_tac (Simplifier.get_local_simpset ctxt) 1))*}
"asm_local_simpset"
method_setup MS = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => main_stop ctxt ([],[],pdefs,[]) 1)) *}
  "main Method with stop continuation, simplification with args" 
method_setup M = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => main_tac ctxt ([],[],pdefs,[]) 1)) *}
  "main Method: simplification with args" 
 
method_setup W = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => w_tac ctxt ([]) (main_tac ctxt ([],[],pdefs,[])) 1)) *}
  "parametric Method for starting: use weakening, simplification with args, fast" 
method_setup WS = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => w_tac ctxt ([]) (main_stop ctxt ([],[],pdefs,[])) 1)) *}
  "parametric Method for starting: use weakening, simplification with args, fast"
method_setup W_MRG = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => w_tac_mrg ctxt ([]) (main_tac ctxt ([],[],pdefs,[])) 1)) *}
  "parametric MRG_Method for starting: use weakening, simplification with args, fast" 
method_setup WS_MRG = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => w_tac ctxt ([]) (main_stop ctxt ([],[],pdefs,[])) 1)) *}
  "parametric MRG_Method for starting: use weakening, simplification with args, fast"



lemma "\<lbrakk>t \<noteq> l\<rbrakk>
       \<Longrightarrow> (G, LET h = l\<bullet>V0; rf t = l\<diamondsuit>R1 IN RVar t END, {l}, m, [(l,ListET kN kC)], ListET kN kC, m+kC):MRG"
by W_MRG
(*apply (rule MRG_Weak)
 (&apply (tactic {*w_tac [] (main_stop ([], [], [], [])) ctxt 1*})&)
  apply M
by fast*)

lemma "\<lbrakk>t \<noteq> l\<rbrakk>
       \<Longrightarrow> (G, LET h = l\<bullet>V0; rf t = l\<diamondsuit>R1; _ = DIAM\<bullet>Free ([RNarg l]) IN RVar t END,
           {l}, m, [(l,ListET kN kC)], ListET kN kC, kC+m+1):MRG"
by W_MRG

lemma "\<lbrakk>t \<noteq> l\<rbrakk>
       \<Longrightarrow> (G, LET h = l\<bullet>V0; rf t = l\<diamondsuit>R1 IN RVar t END, {l}, n, [(l,ResultET kN TT kS)], TT, n+kS):MRG"
by W_MRG

lemma "\<lbrakk>t \<noteq> l\<rbrakk>
      \<Longrightarrow> (G, LET h = l\<bullet>V0; rf t = l\<diamondsuit>R1; _ = DIAM\<bullet>Free ([RNarg l]) IN RVar t END, 
          {l}, n, [(l,ResultET kN TT kS)], TT, kS+n+1):MRG"
by W_MRG

lemma "\<lbrakk>right \<noteq> left; left \<noteq> t\<rbrakk>
               \<Longrightarrow> (G, LET cont = t\<bullet>V0; rf left = t\<diamondsuit>R1; rf right = t\<diamondsuit>R2 IN RVar left END,
                    {t}, n, [(t,TreeET kL kN)], TreeET kL kN, kN+n):MRG"
by W_MRG

lemma "\<lbrakk>right \<noteq> left; left \<noteq> t; right \<noteq> t; kL = kLL\<rbrakk>
        \<Longrightarrow> (G, LET cont = t\<bullet>V0; rf left = t\<diamondsuit>R1; rf right = t\<diamondsuit>R2; _ = DIAM\<bullet>Free ([RNarg t]) IN RVar right END,
             {t}, n, [(t,TreeET kL kN)], ?T, 1+kN+n):MRG"
by W_MRG 

lemma "(G, LET _ = expr.Int 5 IN expr.Int 7 END, ?U, n, C, IntET, n):MRG"
(*expr.Int 5 is not of type UnitET -- need to exercise with emthod call*)
oops

lemma "(G, LET k = expr.Int 5 IN NULL LLL END, ?U, n, C, ListET 0 kC, n):MRG"
by W_MRG

lemma "(G, LET rf p = NULL TTT IN expr.Int 77 END, {}, ?n, C, IntET, k):MRG"
by W_MRG

lemma " (G, expr.Int i,{}, 4, (x,T)#C, IntET, 4):MRG"
by W_MRG 
lemma "(G, expr.IVar x,{}, 4, (y,T)#C, IntET, 4):MRG"
by W_MRG 
syntax x::rname y::rname z::rname
translations
 "x" == "RN(''x'')"
 "y" == "RN(''y'')"
 "z" == "RN(''z'')"

lemma "\<lbrakk>fst (methtable c M) = [RNpar x, INpar h, RNpar y];
               SPEC M = \<lbrace>{y,x}, 3, [(y,T1),(x,T2)]  \<ggreater> T, 7\<rbrace>\<rbrakk>
            \<Longrightarrow> ({(c\<bullet>M([RNarg y, INarg hh, RNarg z]), sMST c M [RNarg y, INarg hh, RNarg z])}, c\<bullet>M([RNarg y, INarg hh, RNarg z]), {z, y}, 5, [(x,T1),(z,T1),(y,T2)], T, 9):MRG"
by W_MRG 

lemma "\<lbrakk>fst (methtable c M) = [];
        SPEC M = \<lbrace>{}, n, []  \<ggreater> UnitET, m\<rbrace>\<rbrakk> \<Longrightarrow> ({(c\<bullet>M([]), sMST c M [])}, LET _ = c\<bullet>M([]) IN expr.Int 7 END, {}, n, C, IntET, m):MRG"
by W_MRG

lemma "\<lbrakk>fst (methtable c M) = [];
        SPEC M = \<lbrace>{}, n, []  \<ggreater> IntET, m\<rbrace>\<rbrakk> \<Longrightarrow> ({(c\<bullet>M([]), sMST c M [])}, 
        LET h = c\<bullet>M([]) IN expr.Int 7 END, {}, n, C, IntET, m):MRG"
by W_MRG 

lemma "\<lbrakk>fst (methtable c M) = [];
        SPEC M = \<lbrace>{}, n, []  \<ggreater> (ResultET kN T kS), m\<rbrace>\<rbrakk> \<Longrightarrow> ({(c\<bullet>M([]), sMST c M [])}, 
        LET rf x = c\<bullet>M([]) IN expr.Int 7 END, {}, n, C, IntET, m):MRG"
by W_MRG

lemma "\<lbrakk>fst (methtable c M) = [];
        SPEC M = \<lbrace>{}, n, []  \<ggreater> ListET kN kC, m\<rbrace>\<rbrakk> \<Longrightarrow> ({(c\<bullet>M([]), sMST c M [])}, 
        LET rf x = c\<bullet>M([]) IN expr.Int 7 END, {}, n, C, IntET, m):MRG"
by W_MRG


lemma "(G, expr.RVar x,{x}, 4, (y,S)#(x,T)#C, T, 4):MRG" 
by W_MRG 
lemma "(G, Primop f a b, {}, n, [], IntET, n):MRG"
by W_MRG
lemma "(G, RPrimop f x y, {x,y}, n, [(z,T),(y,T1),(x,T2)], IntET, n):MRG"
by W_MRG
lemma "(G, Null LLL, {}, m, C, ListET 0 kC, m):MRG"
by W_MRG
lemma "(G, Null RRR, {}, m, C, ResultET 0 TT kS, m):MRG"
by W_MRG
lemma "(G, Null TTT, {}, m, C, TreeET 0 kN, m):MRG"
by W_MRG
lemma "(G, DIAM\<bullet>Make_IID ([VALarg (IVal 5), INarg h, RNarg y]), {y}, Suc (m + kC), [(z,T),(y,ListET kN kC)], ListET kN kC, m):MRG"
by W_MRG

lemma "\<lbrakk>y\<noteq>z; n=(Suc m + kN)\<rbrakk> \<Longrightarrow>
               (G, DIAM\<bullet>Make_IIDD ([VALarg (IVal 3), INarg h, RNarg y, RNarg z]), {y,z}, n, [(y, TreeET kL kN),(z, TreeET kL kN)], TreeET kL kN, m):MRG"
by W_MRG
lemma "\<lbrakk>GETr C y = Some (TreeET kL kN); n=(Suc m + kS)\<rbrakk> \<Longrightarrow>
                     (G, DIAM\<bullet>Make_IID ([VALarg (IVal 1), INarg h, RNarg y]), {y}, n, C, 
                      ResultET kN (TreeET kL kN) kS, m):MRG"
by W_MRG 
end
(*

method_setup S = {* Method.thms_ctxt_args (fn thms => fn ctxt => 
  Method.METHOD (fn facts => (ast 1)))*}
  "Method for asm_simp_tac"
method_setup SF = {* Method.thms_ctxt_args (fn thms => fn ctxt => 
  Method.METHOD (fn facts => (ast_fast 1)))*}
  "Method for asm_simp_tac"
method_setup LEAF = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => leaf_tac ctxt [] 1))*}
  "Method for leaf rules"
method_setup BS = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => basicsimpset_tac 1))*}
  "Method for basic simpset"
method_setup BSF = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => bsf 1))*}
  "Method for basic simpset + fast"
method_setup SB = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => sym_basicsimp 1))*}
  "Method for symmetric basic simpset"
method_setup LS = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => localsimp_tac ctxt 1))*}
  "Method for local simpset"
method_setup LSF = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => lsf ctxt 1))*}
  "Method for local simpset + fast"
method_setup GT = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => getr_tac ctxt 1))*}
  "Method for GETr"
method_setup GTC = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => getr_clar_tac ctxt 1))*}
  "Method for GETr with clarify"
method_setup GTF = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => getr_fast ctxt 1))*}
  "Method for GETr with fast"
method_setup STT = {* Method.thms_ctxt_args (fn thms => fn ctxt => 
  Method.METHOD (fn facts => simpset_tac_thms thms 1))*}
  "Method for basic simpset"
method_setup LSTT = {* Method.thms_ctxt_args (fn thms => fn ctxt => 
  Method.METHOD (fn facts => localsimp_tac_thms ctxt thms 1))*}
  "Method for local_simpset_thms"
method_setup LET = {* Method.thms_ctxt_args (fn thms => fn ctxt => 
  Method.METHOD (fn facts => let_tac ctxt thms (stop ctxt thms) 1))*}
  "Method for local_simpset_thms"
method_setup MATCH = {* Method.thms_ctxt_args (fn thms => fn ctxt => 
  Method.METHOD (fn facts => match_tac ctxt (stop ctxt thms) 1))*}
  "Method for matches"

method_setup MS = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => main_stop ctxt ([], [], pdefs, []) 1)) *}
  "main Method with stop continuation, simplification with args" 
method_setup M = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => main_tac ctxt ([], [], pdefs, []) 1)) *}
  "main Method: simplification with args" 

method_setup WS = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => w_tac ctxt [] (main_stop ctxt ([], [], pdefs, [])) 1)) *}
  "parametric Method for starting: use weakening, stop, simplification with args, fast" 

method_setup W = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => w_tac ctxt [] (main_tac ctxt ([], [], pdefs, [])) 1)) *}
  "parametric Method for starting: use weakening, simplification with args, fast" 

(*method_setup W = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => w_tac ctxt (thms "meth_defs") (main_tac (thms "dmp_defs", thms "meth_defs", pdefs, thms "ctxt_def")) ctxt 1)) *}
  "parametric Method for starting: use weakening, simplification with args, fast" 
*)
*)
