(*<*)
theory DAss_rulesT2 = DAssT2:
(*>*)

subsection {*Derived rules*}
consts restr :: "Context \<Rightarrow> rname list \<Rightarrow> Context"
(*primrec 
"restr C [] = emptyfinmap"
"restr C (h#t) = (case GETr C h of None \<Rightarrow> restr C t | Some T \<Rightarrow> (restr C t)(h\<mapsto>\<^sub>fT))"*)
primrec 
"restr C [] = []"
"restr C (h#t) = (case GETr C h of None \<Rightarrow> restr C t | Some T \<Rightarrow> (h,T)#(restr C t))"

lemma RestrNotIn[rule_format]: "x \<notin> set S \<Longrightarrow> (\<forall> C . GETr (restr C S) x = None)"
(*by (induct S, simp add: GETr_def, clarify, case_tac "GETr C a", (simp add: GETr_def FMAPlookup1)+)*)
by (induct S, simp , clarify, case_tac "GETr C a", (simp add: FMAPlookup1)+)

lemmas GETr_def = ivarRupdTriv (*trick so that GETr_def is defined*)

lemma RestrIn[rule_format]: "x:set S \<Longrightarrow> (\<forall> C . GETr C x = GETr (restr C S) x)"
(*<*)
apply (induct S) apply (simp add: GETr_def)
apply (case_tac "x=a")
(*x=a*)
apply clarify
  apply (case_tac "GETr C x")
  (*GETr C x = None*)
    apply (case_tac "x: set list")
    apply clarsimp 
    apply (subgoal_tac "GETr (restr C (x # list)) x = GETr (restr C list) x")
    apply (subgoal_tac "GETr (restr C list) x = None", clarsimp, erule RestrNotIn) 
    apply clarsimp
  (*GETr C x = Some aa*)
    apply (simp add: GETr_def)
(*x \<noteq>a*)
apply clarify
  apply (subgoal_tac "\<forall>C. GETr C x = GETr (restr C list) x ") prefer 2 apply simp
  apply (erule_tac x=C in allE) 
  apply (erule thin_rl)
  apply (subgoal_tac "GETr (restr C list) x = GETr (restr C (a # list)) x", clarsimp)
  apply (case_tac "GETr C a")
  apply (simp add: GETr_def FMAPlookup1)+
done
(*>*)

consts ParList2RnameList:: "PARAMTYPE \<Rightarrow> rname list"
primrec
"ParList2RnameList [] = []"
"ParList2RnameList (h # t) = (case h of 
                                (INpar x) \<Rightarrow> (ParList2RnameList t)
                              | (RNpar x) \<Rightarrow> x#(ParList2RnameList t))"

lemma PL2RL_p1:"y \<in> set (ParList2RnameList pars) \<Longrightarrow> RNpar y : set pars"
by (induct pars, auto, case_tac a, auto)

consts ArgList2RnameList:: "ARGTYPE \<Rightarrow> rname list"
primrec
"ArgList2RnameList [] = []"
"ArgList2RnameList (h # t) = (case h of 
                                (INarg x) \<Rightarrow> (ArgList2RnameList t)
                              | (RNarg x) \<Rightarrow> x#(ArgList2RnameList t)
                              | (VALarg v) \<Rightarrow> (ArgList2RnameList t))"

lemma AL2RL_p1:"y \<in> set (ArgList2RnameList args) \<Longrightarrow> RNarg y : set args"
by (induct args, auto, case_tac a, auto)

(*<*)

(*Auxiliary rules using DAssComplex*)

lemma DAssC_monotone_in_U:
"\<lbrakk>\<lbrace>U, n, C \<guillemotright> T, m\<rbrace> E h hh v p; U \<subseteq> UU\<rbrakk> \<Longrightarrow> \<lbrace>UU, n, C \<guillemotright> T, m\<rbrace> E h hh v p"
apply (simp add: DAssComplex_def,clarsimp)
apply (subgoal_tac "(\<exists> n1 n2 . (E, h, U, C, n1) \<in> ContextSize \<and> (E, h, UU-U, C, n2) \<in> ContextSize \<and> n1 + n2 = CS)",clarsimp)
prefer 2 apply (erule ContextSize_SPLIT,fast,fast) 
apply (erule_tac x=q in allE, erule_tac x=n1 in allE, erule_tac x=F in allE)
apply (erule impE, safe)
apply (rule_tac x=N in exI,simp)
apply (rule, erule regionsExist_antimonotone, assumption)
apply (rule, erule regionsDistinct_antimonotone, assumption)
apply (erule distinctFrom_antimonotone, assumption)
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (erule modified_monotone,assumption) 
apply (erule Bounded_monotone, simp, simp,simp)
apply (erule Bounded_monotone, simp, simp,simp)
done

lemma DA_C_Weak: "\<lbrakk>G \<rhd> e : \<lbrace> U , n , C \<guillemotright> T , m\<rbrace>; U \<subseteq> UU\<rbrakk> \<Longrightarrow> G \<rhd> e : \<lbrace>UU, n, C \<guillemotright> T, m\<rbrace>"
by (erule vdm_conseq, clarsimp, erule DAssC_monotone_in_U,fast) 

lemma DAssC_Contexts_same_on_U:
"\<lbrakk>\<lbrace>U, n, C \<guillemotright> T, m\<rbrace> E h hh v p; \<forall> x. x:U \<longrightarrow> GETr D x = GETr C x\<rbrakk> \<Longrightarrow> \<lbrace>U, n, D \<guillemotright> T, m\<rbrace> E h hh v p"
apply (simp add: DAssComplex_def, safe)
apply (erule_tac x=q in allE, erule_tac x=CS in allE, erule_tac x=F in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (erule regionsExist2, assumption)
apply (erule regionsDistinct2, assumption)
apply (erule distinctFrom2, assumption)
apply (erule ContextSize2,fast)
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (erule modified2, assumption)
apply (erule Bounded2, fastsimp)+
done

lemma DA_C_Contexts_same_on_U:
"\<lbrakk>G \<rhd> e: \<lbrace>U, n, C \<guillemotright> T, m\<rbrace>; \<forall> x. x:U \<longrightarrow> GETr D x = GETr C x\<rbrakk> \<Longrightarrow> G \<rhd> e: \<lbrace>U, n, D \<guillemotright> T, m\<rbrace>"
by (erule vdm_conseq, clarsimp, erule DAssC_Contexts_same_on_U, assumption)

lemma DAssC_Generalise:
 "\<lbrakk>\<lbrace>U, n, C \<guillemotright> T, m\<rbrace> E h hh v p;  n \<le> nn; mm \<le> m; U \<subseteq> UU\<rbrakk>  \<Longrightarrow> \<lbrace>UU, nn, C \<guillemotright> T, mm\<rbrace> E h hh v p"
apply (simp add: DAssComplex_def, clarsimp)
apply (subgoal_tac "(\<exists> n1 n2 . (E, h, U, C, n1) \<in> ContextSize \<and> (E, h, UU-U, C, n2) \<in> ContextSize \<and> n1 + n2 = CS)",clarsimp)
prefer 2 apply (erule ContextSize_SPLIT,fast,fast) 
apply (erule_tac x=q in allE, erule_tac x=n1 in allE, erule_tac x=F in allE)
apply (erule impE, safe)
apply (rule_tac x=N in exI,simp)
apply (rule, erule regionsExist_antimonotone, assumption)
apply (rule, erule regionsDistinct_antimonotone, assumption)
apply (erule distinctFrom_antimonotone, assumption)
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (erule modified_monotone,assumption) 
apply (erule Bounded_monotone, simp, simp,simp)
apply (erule Bounded_monotone, simp, simp,simp)
apply simp
done

lemma DA_C_Generalise: 
"\<lbrakk>G \<rhd> e:\<lbrace>U, n, C \<guillemotright> T, m\<rbrace>; n \<le> nn; mm \<le> m; U \<subseteq> UU\<rbrakk>
 \<Longrightarrow> G \<rhd> e: \<lbrace>UU, nn, C \<guillemotright> T, mm\<rbrace>"
by (erule vdm_conseq, clarsimp, erule DAssC_Generalise, assumption+)

lemma DAssC_Const: "\<lbrakk>\<lbrace>U, n, G \<guillemotright> T, m\<rbrace> E h hh v p; nn = n + k; mm = m + k\<rbrakk> \<Longrightarrow> \<lbrace>U, nn, G \<guillemotright> T, mm\<rbrace> E h hh v p"
apply (simp add: DAssComplex_def, clarsimp)
apply (erule_tac x="q+k" in allE, erule_tac x=CS in allE, erule_tac x=F in allE, clarsimp)
apply (erule impE,safe) apply(rule_tac x=N in exI, simp)
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, clarsimp)
done

lemma DA_C_Const: "\<lbrakk>G \<rhd> e: \<lbrace>U, n, C \<guillemotright> T, m\<rbrace>; nn = n + k; mm = m + k\<rbrakk> \<Longrightarrow> G \<rhd> e: \<lbrace>U, nn, C \<guillemotright> T, mm\<rbrace>"
by (erule vdm_conseq, insert DAssC_Const, fast)

lemma DAssC_PConst0: "\<lbrace>U, n, G \<guillemotright> T, m\<rbrace> E h hh v p = \<lbrace>U, n, G \<guillemotright> T, m\<rbrace> E h hh v pp"
by (simp add: DAssComplex_def)

lemma DAssC_PConst: "\<lbrace>U, n, G \<guillemotright> T, m\<rbrace> E h hh v p \<Longrightarrow> \<lbrace>U, n, G \<guillemotright> T, m\<rbrace> E h hh v pp"
by (simp add: DAssComplex_def)

lemma DA_C_NullTree: "\<lbrakk>n=m+kL\<rbrakk> \<Longrightarrow> G \<rhd> (Null TTT): \<lbrace>{}, n, C \<guillemotright> TreeET kL kN, m\<rbrace>"
apply (rule vdm_conseq, rule vdm_null)
apply (simp add: DAssComplex_def,clarsimp)
apply (rule_tac x="{}" in exI, rule_tac x=kL in exI, rule_tac x="N" in exI, rule_tac x=F in exI, safe)
apply (rule regTree) apply (rule mTREE_LEAF) apply simp
apply (rule modified_Sameheap)
apply (rule Bounded_Empty)
apply (rule Bounded_SameF)
apply simp
done

lemma DA_C_NullList: "\<lbrakk>n=m+kN\<rbrakk> \<Longrightarrow> G \<rhd> (Null LLL): \<lbrace>{}, n, C \<guillemotright> ListET kN kC, m\<rbrace>"
apply (rule vdm_conseq, rule vdm_null)
apply (simp add: DAssComplex_def,clarsimp)
apply (rule_tac x="{}" in exI, rule_tac x=kN in exI, rule_tac x="N" in exI, rule_tac x=F in exI, safe)
apply (rule regList) apply (rule mLIST_NIL) apply simp
apply (rule modified_Sameheap)
apply (rule Bounded_Empty)
apply (rule Bounded_SameF)
apply simp
done

lemma DA_C_NullRes: "\<lbrakk>n=m+kN\<rbrakk> \<Longrightarrow> GG \<rhd> (Null RRR): \<lbrace>{}, n, G \<guillemotright> ResultET kN TT kS, m\<rbrace>"
apply (rule vdm_conseq, rule vdm_null)
apply (simp add: DAssComplex_def,clarsimp)
apply (rule_tac x="{}" in exI, rule_tac x=kN in exI, rule_tac x="N" in exI, rule_tac x=F in exI, safe)
apply (rule regResultNONE, simp, simp)
apply (rule modified_Sameheap)
apply (rule Bounded_Empty)
apply (rule Bounded_SameF)
apply simp
done
lemma DA_C_Null: "\<lbrakk>T \<notin> {UnitET, IntET}; n = k+m; 
                   \<forall> kL kN. T = TreeET kL kN \<longrightarrow> (k = kL \<and> XXX=TTT);
                   \<forall> kN TT kS. T = ResultET kN TT kS \<longrightarrow> (k=kN \<and> XXX= RRR);
                   \<forall> kN kC. T = ListET kN kC \<longrightarrow> (k=kN \<and> XXX=LLL)\<rbrakk> \<Longrightarrow> GG \<rhd> Null XXX: \<lbrace>{}, n, G \<guillemotright> T, m\<rbrace>"
apply (case_tac T, simp_all)
apply (rule DA_C_NullList, simp)
apply (rule DA_C_NullTree, simp)
apply (rule DA_C_NullRes, simp)
done

lemma DA_C_Int: "\<lbrakk>T = IntET\<rbrakk> \<Longrightarrow> GG \<rhd> expr.Int i: \<lbrace>{}, n, G \<guillemotright> T, n\<rbrace>"
apply (rule vdm_conseq, rule vdm_int)
apply (simp add: DAssComplex_def,clarsimp)
apply (rule_tac x="{}" in exI, rule_tac x=0 in exI, rule_tac x="N" in exI, rule_tac x=F in exI, safe) 
apply (rule regInt)
apply (rule modified_Sameheap)
apply (rule Bounded_Empty)
apply (rule Bounded_SameF)
apply simp
done

lemma DA_C_IVar: "\<lbrakk>T = IntET\<rbrakk> \<Longrightarrow> GG \<rhd> IVar x: \<lbrace>{}, n, G \<guillemotright> T, n\<rbrace>"
apply (rule vdm_conseq, rule vdm_ivar, clarsimp)
apply (simp add: DAssComplex_def, clarsimp)
apply (rule_tac x="{}" in exI, rule_tac x=0 in exI, rule_tac x="N" in exI, rule_tac x=F in exI, safe) 
apply (rule regInt)
apply (rule modified_Sameheap)
apply (rule Bounded_Empty)
apply (rule Bounded_SameF)
apply simp
done

lemma DA_C_RVar: "\<lbrakk>GETr G x = Some T\<rbrakk> \<Longrightarrow> GG \<rhd> RVar x: \<lbrace>{x}, n, G \<guillemotright> T, n\<rbrace>"
apply (rule vdm_conseq, rule vdm_rvar)
apply (simp add: DAssComplex_def, safe)
apply (subgoal_tac "\<exists> R S . (RVal (E\<lfloor>x\<rfloor>),h,Some T,R,S):reg", safe) prefer 2 apply (erule regionsExist_Lookup, simp, assumption)
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=N in exI, rule_tac x=F in exI, safe)
apply (rule modified_Sameheap)
apply (erule distinctFrom_Lookup)
  apply(subgoal_tac "(RVal (renv E x), h, GETr G x, R, S) \<in> reg", assumption, clarsimp, simp,assumption, assumption)
apply (erule Bounded_lookup) apply (subgoal_tac "x:{x}", assumption, simp) 
  apply (subgoal_tac "(RVal (renv E x), h, GETr G x, R, S) \<in> reg",assumption,clarsimp)
apply (rule Bounded_SameF) 
apply (subgoal_tac "S \<le> CS", clarsimp)
apply (erule ContextSize_contains_region)
apply (subgoal_tac "x:{x}", assumption, simp)
apply (simp add: GETr_def)
done

lemma DA_C_Prim: "\<lbrakk>T = IntET\<rbrakk> \<Longrightarrow> GG \<rhd> Primop f x y: \<lbrace>{}, n, G \<guillemotright> T, n\<rbrace>"
apply (rule vdm_conseq, rule vdm_prim, simp add: DAssComplex_def, safe)
apply (rule_tac x="{}" in exI, rule_tac x="0" in exI, rule_tac x=N in exI, rule_tac x=F in exI, safe)
apply (rule regInt)
apply (rule modified_Sameheap)
apply (rule Bounded_Empty)
apply (rule Bounded_SameF)
apply simp
done

lemma DA_C_Rprim:
"\<lbrakk>x: DOM G; y:DOM G; T = IntET\<rbrakk> \<Longrightarrow> GG \<rhd> RPrimop f x y: \<lbrace>{}, n, G \<guillemotright> T, n\<rbrace>"
apply (rule vdm_conseq, rule vdm_rprim, simp add: DAssComplex_def, safe)
apply (rule_tac x="{}" in exI, rule_tac x="0" in exI, rule_tac x=N in exI, rule_tac x=F in exI, safe)
apply (rule regInt)
apply (rule modified_Sameheap)
apply (rule Bounded_Empty)
apply (rule Bounded_SameF)
apply simp
done

lemma DA_C_Let_Int:
  "\<lbrakk>G \<rhd> e : \<lbrace>U, n, C \<guillemotright> T, m\<rbrace>\<rbrakk> \<Longrightarrow> G \<rhd> (LET z = expr.Int i IN e END): \<lbrace>U, n, C \<guillemotright> T, m\<rbrace>"
apply (rule vdm_conseq, rule vdm_leti, rule vdm_int)
apply assumption
apply (clarsimp)
apply (simp add: DAssComplex_def, safe)
apply (erule_tac x=q in allE, erule_tac x=CS in allE, erule_tac x=F in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (erule regionsExist1,fast, simp,simp,rule, simp) 
apply (erule regionsDistinct1, fast, simp, simp, rule, simp)
apply (erule distinctFrom1,fast, simp, simp, rule, simp)
apply (erule ContextSizePreserved, simp)
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (erule modified1, fast, simp, rule, simp)
apply (erule Bounded1,  fast, rule, simp)
apply (erule Bounded1, fast, rule, simp)
done

lemma DA_C_Let_Prim:
  "\<lbrakk>G \<rhd> e : \<lbrace>U, n, C \<guillemotright> T, m\<rbrace>\<rbrakk> \<Longrightarrow> G \<rhd> (LET z = Primop f x y IN e END): \<lbrace>U, n, C \<guillemotright> T, m\<rbrace>"
apply (rule vdm_conseq, rule vdm_leti, rule vdm_prim)
apply assumption
apply (clarsimp)
apply (simp add: DAssComplex_def, safe)
apply (erule_tac x=q in allE, erule_tac x=CS in allE, erule_tac x=F in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (erule regionsExist1,fast, simp,simp,rule, simp) 
apply (erule regionsDistinct1, fast, simp, simp, rule, simp)
apply (erule distinctFrom1,fast, simp, simp, rule, simp)
apply (erule ContextSizePreserved, simp)
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (erule modified1, fast, simp, rule, simp)
apply (erule Bounded1,  fast, rule, simp)
apply (erule Bounded1, fast, rule, simp)
done

lemma DA_C_Let_RPrim:
  "\<lbrakk>G \<rhd> e : \<lbrace>U, n, C \<guillemotright> T, m\<rbrace>; x : DOM C; y : DOM C
   \<rbrakk> \<Longrightarrow> G \<rhd> (LET z = RPrimop f x y IN e END): \<lbrace>{x,y} \<union> U, n, C \<guillemotright> T, m\<rbrace>"
apply (rule vdm_conseq, rule vdm_leti, rule vdm_rprim)
apply assumption
apply (clarsimp)
apply (simp add: DAssComplex_def, safe)
apply (subgoal_tac "\<exists> n1 n2 . (E, h, U, C, n1) \<in> ContextSize \<and> (E, h, (insert x (insert y U)) - U, C, n2) \<in> ContextSize \<and> n1 + n2 = CS", clarsimp)
prefer 2 apply (erule ContextSize_SPLIT, fast, fast)
apply (erule_tac x=q in allE, erule_tac x=n1 in allE,erule_tac x=F in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (rule regionsExist1) apply (erule regionsExist_antimonotone,fast) apply(fast, simp,rule, simp) 
apply (rule regionsDistinct1) apply(erule regionsDistinct_antimonotone) apply(fast, simp, simp,rule, simp)
apply (rule distinctFrom1) apply(erule distinctFrom_antimonotone) apply(fast, fast, simp, rule, simp)
apply (erule ContextSizePreserved) apply simp
apply simp
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (rule modified1) apply(erule modified_monotone) apply(fast, fast, simp, rule, simp)
apply (rule Bounded1) apply(erule Bounded_monotone) apply(simp, simp, fast, fast, rule, simp)
apply (rule Bounded1) apply (rotate_tac -3) apply(erule Bounded_monotone) apply(simp, simp, fast, fast, rule, simp)
done
lemma DA_C_Let_rprim:
  "\<lbrakk>G \<rhd> e : \<lbrace>U, n, C \<guillemotright> T, m\<rbrace>; x : DOM C; y : DOM C; UU = ({x,y} \<union> U)
   \<rbrakk> \<Longrightarrow> G \<rhd> (LET z = RPrimop f x y IN e END): \<lbrace>UU, n, C \<guillemotright> T, m\<rbrace>"
by (rule vdm_conseq, erule DA_C_Let_RPrim,auto)

lemma reg_h_h1_letv:
"\<lbrakk>U1 \<inter> U2 = {}; regionsExist (U1 \<union> U2) C h E; regionsDistinct (U1 \<union> U2) C h E;
  distinctFrom (U1 \<union> U2) C h E F; modified F U1 C h E h1; x:DOM C; x:U2;
 (RVal E\<lfloor>x\<rfloor>, h, GETr C x, R, S) \<in> reg\<rbrakk>
 \<Longrightarrow> (RVal E\<lfloor>x\<rfloor>, h1, GETr C x, R, S) \<in> reg"
apply (rule reg_Preserved, assumption)
apply (simp add: modified_def, erule_tac x=l in allE, erule impE, safe)
apply (simp add: distinctFrom_def)
apply (erule_tac x=x in allE,clarsimp,fast) 
apply (erule reg_region_in_heap1, assumption)
apply (subgoal_tac "x \<noteq> z")
apply (simp add: regionsDistinct_def,fast)
apply fast
done

lemma reg_h1_h_letv:
"\<lbrakk>U1 \<inter> U2 = {}; regionsExist (U1 \<union> U2) C h E; regionsDistinct (U1 \<union> U2) C h E;
  distinctFrom (U1 \<union> U2) C h E F; modified F U1 C h E h1; x:DOM C; x:U2;
  (RVal E\<lfloor>x\<rfloor>, h1, GETr C x, R, S) \<in> reg\<rbrakk>
 \<Longrightarrow> (RVal E\<lfloor>x\<rfloor>, h, GETr C x, R, S) \<in> reg"
apply (subgoal_tac "\<exists> RR SS . (RVal E\<lfloor>x\<rfloor>, h, GETr C x, RR, SS) \<in> reg", clarsimp)
apply (subgoal_tac "(RVal (renv E x), h1, GETr C x, RR, SS) \<in> reg")
apply (subgoal_tac "R=RR \<and> S=SS", clarsimp)
apply (erule reg_Unique, assumption)
apply (erule reg_h_h1_letv, assumption+)
apply (simp add: regionsExist_def)
done

lemma regEx_Letv:
"\<lbrakk>U1 \<inter> U2 = {}; regionsExist (U1 \<union> U2) C h E; regionsDistinct (U1 \<union> U2) C h E; 
  distinctFrom (U1 \<union> U2) C h E F; modified F U1 C h E h1; \<forall> x . x:U2 \<longrightarrow> renv EE = renv E\<rbrakk>
 \<Longrightarrow> regionsExist U2 C h1 EE"
apply (simp (no_asm) add: regionsExist_def, clarsimp)
apply (erule impE,fast)
apply (subgoal_tac "\<exists>Rx Sx. (RVal (renv E x), h, GETr C x, Rx, Sx) \<in> reg", clarsimp)
apply (rule_tac x=Rx in exI, rule_tac x=Sx in exI)
apply (erule reg_h_h1_letv, assumption+)
apply (simp add: regionsExist_def)
done

lemma regsDist_Letv:
"\<lbrakk>U1 \<inter> U2 = {}; regionsExist (U1 \<union> U2) C h E; regionsDistinct (U1 \<union> U2) C h E;
  distinctFrom (U1 \<union> U2) C h E F; modified F U1 C h E h1; \<forall> x . x:U2 \<longrightarrow> renv EE = renv E\<rbrakk>
 \<Longrightarrow> regionsDistinct U2 C h1 EE"
apply (simp (no_asm) add: regionsDistinct_def, clarsimp)
apply (erule impE,fast)
apply (subgoal_tac "(RVal (renv E x), h, GETr C x, Rx, Sx) \<in> reg")
apply (subgoal_tac "(RVal (renv E xx), h, GETr C xx, Rxx, Sxx) \<in> reg")
apply (simp add: regionsDistinct_def,fast)
apply (erule reg_h1_h_letv, assumption+, simp)
apply (erule reg_h1_h_letv, assumption+, simp)
done

lemma distFr_Letv:
"\<lbrakk>U1 \<inter> U2 = {}; regionsExist (U1 \<union> U2) C h E; regionsDistinct (U1 \<union> U2) C h E;
  distinctFrom (U1 \<union> U2) C h E F; modified F U1 C h E h1;
  Bounded FF F U1 C h E; \<forall> x . x:U2 \<longrightarrow> renv EE = renv E\<rbrakk>
 \<Longrightarrow> distinctFrom U2 C h1 EE FF"
apply (simp (no_asm)add: distinctFrom_def, clarsimp)
apply (erule impE,fast)
apply (simp add: Bounded_def)
apply (subgoal_tac "Rx \<inter> (F \<union> {l. \<exists>z. z \<in> U1 \<and> z \<in> DOM C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)})={}")
apply fast
apply (subgoal_tac "(RVal (renv E x), h, GETr C x, Rx, Sx) \<in> reg")
apply (subgoal_tac "Rx \<inter> F \<subseteq> {}")
apply (subgoal_tac "Rx \<inter> {l. \<exists>z. z \<in> U1 \<and> z \<in> DOM C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)} \<subseteq>  {}",fast)
apply (rule, clarsimp)
apply (subgoal_tac "x \<noteq> z", simp add: regionsDistinct_def) apply fast
apply fast
apply (simp add: distinctFrom_def,fast)
apply (erule reg_h1_h_letv, assumption+)
done

lemma mod_Letv:
"\<lbrakk>U1 \<inter> U2 = {}; regionsExist (U1 \<union> U2) C h E; regionsDistinct (U1 \<union> U2) C h E; 
  distinctFrom (U1 \<union> U2) C h E F; modified F U1 C h E h1;
  Bounded FF F U1 C h E; modified FF U2 C h1 EE hh; \<forall> x . x:(U1 \<union> U2) \<longrightarrow> renv EE = renv E\<rbrakk>
 \<Longrightarrow> modified F (U1 \<union> U2) C h E hh"
apply (simp add: modified_def, clarsimp)
apply (subgoal_tac "modified F U1 C h E h1")
prefer 2 apply (simp add: modified_def)
apply (erule_tac x=l in allE, erule impE,clarsimp) apply fast
apply (erule SameOHTransitive)
apply (erule_tac x=l in allE, erule impE) apply rule
apply (simp add: Bounded_def)
apply (subgoal_tac "l \<notin> {l. \<exists>z. z \<in> U1 \<and> z \<in> DOM C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}",fast)
apply clarsimp
apply fast
apply rule apply (simp add: modified_def) apply (erule_tac x=l in allE, erule impE,fast) apply (simp add: sameOH_def)
  apply (simp add: fmap_lookup_def fmap_dom_def dom_def)
apply clarsimp
apply (subgoal_tac "(RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg",fast)
apply (erule reg_h1_h_letv, assumption+)
apply fast
done

lemma Bnd_Letv:
"\<lbrakk>U1 \<inter> U2 = {}; regionsExist (U1 \<union> U2) C h E; regionsDistinct (U1 \<union> U2) C h E; 
  distinctFrom (U1 \<union> U2) C h E F; modified F U1 C h E h1; Bounded FF F U1 C h E;
  Bounded Ra FF U2 C h1 EE; \<forall> x . x:(U1 \<union> U2) \<longrightarrow> renv EE = renv E\<rbrakk>
 \<Longrightarrow> Bounded Ra F (U1 \<union> U2) C h E"
apply (simp add: Bounded_def)
apply (rule, rule)
apply (rotate_tac -3, erule_tac x=l in allE, erule impE,simp, erule disjE)
apply (erule_tac x=l in allE, erule impE, assumption)
apply (erule disjE, simp)
apply (rule disjI2, clarsimp)
apply fast
apply (rule disjI2, clarsimp)
apply (subgoal_tac "(RVal (renv E x), h, GETr C x, Rx, Sx) \<in> reg",fast)
apply (erule reg_h1_h_letv, assumption+)
done

lemma DA_C_Letv:
      "\<lbrakk>G \<rhd> e : \<lbrace>U1, n, C \<guillemotright> T1, m\<rbrace>; G \<rhd> ee : \<lbrace>U2, m, C \<guillemotright> T2, k\<rbrace>;
        T1 = UnitET; U1 \<inter> U2 = {}\<rbrakk>
     \<Longrightarrow> G \<rhd> (LET _ = e IN ee END): \<lbrace>U1 \<union> U2, n, C \<guillemotright> T2, k\<rbrace>"
apply (rule vdm_conseq,erule vdm_letv, assumption)
apply (erule thin_rl, erule thin_rl, clarsimp)
apply (simp add: DAssComplex_def, safe)
apply (subgoal_tac "(\<exists> n1 n2 . (E, h, U1, C, n1) \<in> ContextSize \<and> (E, h, U2, C, n2) \<in> ContextSize \<and> n1 + n2 = CS)", clarsimp)
prefer 2 apply (erule ContextSize_SPLIT, simp, assumption)
apply (erule_tac x="n2+q" in allE, erule_tac x=n1 in allE, erule_tac x=F in allE, erule impE, clarsimp)
apply (rule_tac x=N in exI, clarsimp)
  apply(rotate_tac 1, erule thin_rl,safe)
  apply (erule regionsExist_antimonotone,fast)
  apply (erule regionsDistinct_antimonotone,fast)
  apply (erule distinctFrom_antimonotone,fast)
  
  apply (erule_tac x=q in allE, erule_tac x=n2 in allE,erule_tac x=FF in allE, erule impE, clarsimp)
  apply (rule_tac x=M in exI, safe)
  apply (erule regEx_Letv, assumption+,simp)
  apply (erule regsDist_Letv, assumption+, simp)
  apply (erule distFr_Letv, assumption+, simp)

  apply (rule SizePreserved_h_h1)
  apply (erule ContextSizePreserved,fastsimp) apply (simp add: modified_def)
  apply (erule_tac x=l in allE, erule impE)
  (*1*) apply rule apply (simp add: distinctFrom_def) apply (subgoal_tac "x:DOM C",fast) apply (erule reg_DOM)
  (*2*) apply (rule, subgoal_tac "l:Dom h", simp add: dom_def) apply(erule reg_region_in_heap1, assumption) 
      apply (simp add: regionsDistinct_def,clarsimp) 
      apply (subgoal_tac "z \<noteq> x")
      apply (subgoal_tac "x:DOM C",fast) apply (erule reg_DOM)
      apply fast
  apply simp
  apply (erule reg.elims, clarsimp+)

  apply (rule_tac x=Ra in exI, rule_tac x=Sa in exI, rule_tac x=Ma in exI, rule_tac x=FFa in exI, safe)
  apply (erule mod_Letv,assumption+,simp) 
  apply (erule Bnd_Letv, assumption+,simp)
  apply (erule Bnd_Letv, assumption+,simp) 
done
lemma DA_C_letv:
      "\<lbrakk>G \<rhd> e : \<lbrace>U1, n, C \<guillemotright> T1, m\<rbrace>;
        G \<rhd> ee : \<lbrace>U2, m, C \<guillemotright> T2, k\<rbrace>; T1 = UnitET;
        U1 \<inter> U2 = {}; UU=(U1 \<union> U2)\<rbrakk>
     \<Longrightarrow> G \<rhd> (LET _ = e IN ee END): \<lbrace>UU, n, C \<guillemotright> T2, k\<rbrace>"
by (rule vdm_conseq, rule DA_C_Letv, auto)

lemma DA_C_Leti:
      "\<lbrakk>G \<rhd> e : \<lbrace>U1, n, C \<guillemotright> T1, m\<rbrace>;
        G \<rhd> ee : \<lbrace>U2, m, C \<guillemotright> T2, k\<rbrace> ;
        U1 \<inter> U2 = {}; T1 = IntET\<rbrakk>
     \<Longrightarrow> G \<rhd> (LET x = e IN ee END): \<lbrace>U1 \<union> U2, n, C \<guillemotright> T2, k\<rbrace>"
apply (rule vdm_conseq,erule vdm_leti, assumption)
apply (erule thin_rl, erule thin_rl, clarsimp)
apply (simp add: DAssComplex_def, safe)
apply (subgoal_tac "(\<exists> n1 n2 . (E, h, U1, C, n1) \<in> ContextSize \<and> (E, h, U2, C, n2) \<in> ContextSize \<and> n1 + n2 = CS)", clarsimp)
prefer 2 apply (erule ContextSize_SPLIT, simp, assumption)
apply (erule_tac x="n2+q" in allE, erule_tac x=n1 in allE, erule_tac x=F in allE, erule impE, clarsimp)
apply (rule_tac x=N in exI, clarsimp)
  apply(rotate_tac 1, erule thin_rl,safe)
  apply (erule regionsExist_antimonotone,fast)
  apply (erule regionsDistinct_antimonotone,fast)
  apply (erule distinctFrom_antimonotone,fast)
  
  apply (erule_tac x=q in allE, erule_tac x=n2 in allE,erule_tac x=FF in allE, erule impE, clarsimp)
  apply (rule_tac x=M in exI, safe)
  apply (erule regEx_Letv, assumption+,clarsimp,rule, simp)
  apply (erule regsDist_Letv, assumption+,clarsimp,rule, simp)
  apply (erule distFr_Letv, assumption+,clarsimp,rule, simp)

  apply (rule SizePreserved_h_h1)
  apply (erule ContextSizePreserved,fastsimp) apply (simp add: modified_def)
  apply (erule_tac x=l in allE, erule impE)
  (*1*) apply rule apply (simp add: distinctFrom_def) apply (subgoal_tac "x:DOM C",fast) apply (erule reg_DOM)
  (*2*) apply (rule, subgoal_tac "l:Dom h", simp add: dom_def) apply(erule reg_region_in_heap1, assumption) 
      apply (simp add: regionsDistinct_def,clarsimp) 
      apply (subgoal_tac "z \<noteq> x")
      apply (subgoal_tac "x:DOM C",fast) apply (erule reg_DOM)
      apply fast
  apply simp
  apply (erule reg.elims, clarsimp+)

  apply (rule_tac x=Ra in exI, rule_tac x=Sa in exI, rule_tac x=Ma in exI, rule_tac x=FFa in exI, safe)
  apply (erule mod_Letv,assumption+,safe, (rule, simp)+) 
  apply (erule Bnd_Letv, assumption+,safe, (rule, simp)+)
  apply (erule Bnd_Letv, assumption+,safe, (rule, simp)+) 
done
lemma DA_C_leti:
      "\<lbrakk>G \<rhd> e : \<lbrace>U1, n, C \<guillemotright> T1, m\<rbrace>;
        G \<rhd> ee : \<lbrace>U2, m, C \<guillemotright> T2, k\<rbrace>;
        U1 \<inter> U2 = {}; T1 = IntET; UU=(U1 \<union> U2)\<rbrakk>
     \<Longrightarrow> G \<rhd> (LET x = e IN ee END): \<lbrace>UU, n, C \<guillemotright> T2, k\<rbrace>"
by (rule vdm_conseq, rule DA_C_Leti, auto)

lemma regEx_Letr:
"\<lbrakk>U1 \<inter> (U2 - {x}) = {}; regionsExist (U1 \<union> (U2 - {x})) C h E; regionsDistinct (U1 \<union> (U2 - {x})) C h E;
          distinctFrom (U1 \<union> (U2 - {x})) C h E F; modified F U1 C h E h1; (RVal r, h1, Some T1, R, S) \<in> reg\<rbrakk>
 \<Longrightarrow> regionsExist U2 ((x,T1)#C) h1 E\<lfloor>x:=r\<rfloor>"
apply (simp (no_asm) add: regionsExist_def, clarsimp)
apply (case_tac "xa=x",simp add: GETr_def,fast)
apply clarsimp
apply (subgoal_tac "xa : DOM C")
apply (subgoal_tac "GETr ((x,T1) # C) xa = GETr C xa", clarsimp)
apply (subgoal_tac "\<exists>Rx Sx. (RVal (renv E xa), h, GETr C xa, Rx, Sx) \<in> reg", clarsimp)
apply (rule_tac x=Rx in exI, rule_tac x=Sx in exI)
apply (erule reg_h_h1_letv, assumption+)
apply fast
apply assumption
apply (simp add: regionsExist_def)
apply simp 
apply (simp add: DOM_def)
done

lemma regsDist_Letr:
"\<lbrakk>U1 \<inter> (U2 - {x}) = {}; regionsExist (U1 \<union> (U2 - {x})) C h E; regionsDistinct (U1 \<union> (U2 - {x})) C h E;
  distinctFrom (U1 \<union> (U2 - {x})) C h E F; (RVal r, h1, Some T1, R, S) \<in> reg; modified F U1 C h E h1;
  R \<inter> FF = {}; Bounded R F U1 C h E\<rbrakk>
 \<Longrightarrow> regionsDistinct U2 ((x,T1)#C) h1 E\<lfloor>x:=r\<rfloor>"
apply (simp add: regionsDistinct_def, clarsimp)
apply (subgoal_tac " regionsDistinct (U1 \<union> (U2 - {x})) C h E")
prefer 2 apply (simp add: regionsDistinct_def)
apply (case_tac "xa = x", clarsimp)
(*xa=x*)
  apply (case_tac "xx=x")
  (*xx=x*) apply clarsimp
  (*xx\<noteq>x*) apply (subgoal_tac "GETr ((x,T1)#C) xx = GETr C xx", clarsimp)
    apply (subgoal_tac "xx:DOM C")
    apply (subgoal_tac "R=Rx \<and> S=Sx", clarsimp)
    apply (simp add: Bounded_def, rule, rule)
    apply (subgoal_tac "(RVal (renv E xx), h, GETr C xx, Rxx, Sxx) \<in> reg")
    prefer 2 apply(erule reg_h1_h_letv, assumption+, fast, assumption+)
    apply (erule_tac x=xa in allE, erule impE,clarsimp)
    apply (erule disjE)
    (*1*) apply (rotate_tac 2, erule thin_rl, simp add: distinctFrom_def)
          apply (erule_tac x=xx in allE, erule impE, clarsimp) apply fast
    (*2*) apply clarsimp apply (subgoal_tac "xx \<noteq> xaa")
          apply (erule_tac x=xaa in allE, erule_tac x=xx in allE)
          apply (erule_tac x=Rx in allE, erule_tac x=Rxx in allE, erule impE, clarsimp) apply fast 
          apply fast apply (rotate_tac 2, erule thin_rl, fast)
    apply simp 
    apply (erule reg_Unique) apply (simp add: GETr_def)
    apply (erule reg_DOM)
    apply (rule GETr_Update1, fast)
(* xa \<noteq> x*)
  apply clarsimp
  apply (subgoal_tac "GETr ((x,T1)#C) xa = GETr C xa", clarsimp)
  prefer 2 apply simp
  (*apply (subgoal_tac "xa:DOM C")
    prefer 2 apply (simp add: DOM_def)*)
  apply (case_tac "xx=x")
    (* xx=x*)
    apply clarsimp
    apply (subgoal_tac "xa:DOM C")
    prefer 2 apply (simp add: DOM_def)
    apply (subgoal_tac "R=Rxx \<and> S=Sxx", clarsimp)
    apply (simp add: Bounded_def, rule, rule)
    apply (subgoal_tac "(RVal (renv E xa), h, GETr C xa, Rx, Sx) \<in> reg")
    prefer 2 apply(erule reg_h1_h_letv, assumption+) apply(fast, assumption+)
    apply (erule_tac x=xaa in allE, erule impE,clarsimp)
    apply (erule disjE)
    (*1*) apply (rotate_tac 2, erule thin_rl, simp add: distinctFrom_def)
          apply (erule_tac x=xa in allE, erule impE, clarsimp) apply fast
    (*2*) apply clarsimp apply (subgoal_tac "xa \<noteq> xb")
          apply (erule_tac x=xa in allE, erule_tac x=xb in allE)
          apply (erule_tac x=Rx in allE, erule_tac x=Rxa in allE, erule impE, clarsimp) apply fast 
          apply fast apply (rotate_tac 2, erule thin_rl, fast)
    apply simp 
    apply (erule reg_Unique) apply (simp add: GETr_def)
    (* xx \<noteq> x*)
    apply clarsimp
    apply (subgoal_tac "xx:DOM C")
    prefer 2 apply (simp add: DOM_def)
    apply (subgoal_tac "xa:DOM C")
    prefer 2 apply (simp add: DOM_def)
    apply (subgoal_tac "GETr ((x,T1)#C) xx = GETr C xx", clarsimp)
    prefer 2 apply simp 
    apply (erule_tac x=xa in allE, erule_tac x=xx in allE)
    apply (erule_tac x=Rx in allE, erule_tac x=Rxx in allE, erule impE, clarsimp)
    apply (rule, rule) apply (erule  reg_h1_h_letv, assumption+) apply(fast, assumption)
    apply (rule) apply (erule  reg_h1_h_letv, assumption+, fast, assumption)
    apply simp
done

lemma distFrom_Letr:
"\<lbrakk>U1 \<inter> (U2 - {x}) = {};regionsExist (U1 \<union> (U2 - {x})) C h E; regionsDistinct (U1 \<union> (U2 - {x})) C h E;
          distinctFrom (U1 \<union> (U2 - {x})) C h E F; (RVal r, h1, Some (T1), R, S) \<in> reg; modified F U1 C h E h1;
          R \<inter> FF = {}; Bounded R F U1 C h E; Bounded FF F U1 C h E\<rbrakk>
       \<Longrightarrow> distinctFrom U2 ((x,T1)#C) h1 E\<lfloor>x:=r\<rfloor> FF"
apply (simp add: distinctFrom_def, clarsimp)
apply (subgoal_tac "distinctFrom (U1 \<union> (U2 - {x})) C h E F")
prefer 2 apply (simp add: distinctFrom_def)
apply (case_tac "xa=x", clarsimp)
(*xa=x*)
    apply (subgoal_tac "R=Rx \<and> S=Sx", clarsimp)
    apply (erule reg_Unique) apply (simp add: GETr_def)
(*xa\<noteq>x*)
    apply clarsimp
    apply (subgoal_tac "xa:DOM C")
    prefer 2 apply (simp add: DOM_def)
    apply (subgoal_tac "(RVal (renv E xa), h, GETr C xa, Rx, Sx) \<in> reg")
    prefer 2 apply(erule reg_h1_h_letv, assumption+)
             apply fast
             apply assumption
    apply (subgoal_tac "\<forall>l. l \<in> FF \<longrightarrow> l \<in> F \<or> (\<exists>x. x \<in> U1 \<and> x \<in> DOM C \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E x), h, GETr C x, Rx, Sx) \<in> reg) \<and> l \<in> Rx))")
    prefer 2 apply (simp add: Bounded_def)
    apply (subgoal_tac "Rx \<inter> (F \<union> {l. \<exists>z. z \<in> U1 \<and> z \<in> DOM C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}) = {}", fast)
    apply (subgoal_tac "Rx \<inter> F = {}
           \<and> Rx \<inter> {l. \<exists>z. z \<in> U1 \<and> z \<in> DOM C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)} = {}",fast)
    apply rule
    (*1*) apply (erule_tac x=xa in allE, erule impE,clarsimp)
          apply fast
    (*2*) apply (rule,rule, clarsimp)
          apply (subgoal_tac "xa\<noteq>z")
          apply (simp add: regionsDistinct_def) 
          apply (erule_tac x=xa in allE, erule_tac x=z in allE, erule_tac x=Rx in allE, erule_tac x=Rz in allE, erule impE,clarsimp)
          apply (rule, fast) apply (rule,fast,fast)
          apply fast
          apply fast
done

lemma mod_Letr:
"\<lbrakk>U1 \<inter> (U2-{x}) = {}; regionsExist (U1 \<union> (U2-{x})) C h E; regionsDistinct (U1 \<union> (U2-{x})) C h E; 
  modified F U1 C h E h1; distinctFrom (U1 \<union> (U2-{x})) C h E F; Bounded FF F U1 C h E;
  modified FF U2 ((x,T1)#C) h1 E\<lfloor>x:=r\<rfloor> hh; 
  (RVal r, h1, Some (T1), R, S) \<in> reg; Bounded R F U1 C h E\<rbrakk>
 \<Longrightarrow> modified F (U1 \<union> (U2-{x})) C h E hh"
apply (simp add: modified_def, clarsimp)
apply (subgoal_tac "modified F U1 C h E h1")
prefer 2 apply (simp add: modified_def)
apply (subgoal_tac "modified FF U2 ((x,T1)#C) h1 E\<lfloor>x:=r\<rfloor> hh")
prefer 2 apply (simp add: modified_def)
apply (erule_tac x=l in allE, erule impE,clarsimp) apply (rotate_tac -6, erule_tac x=z in allE) apply fast
apply (erule SameOHTransitive)
apply (erule_tac x=l in allE, erule impE) apply rule
apply (subgoal_tac "\<forall>l. l \<in> FF \<longrightarrow> l \<in> F \<or> (\<exists>x. x \<in> U1 \<and> x \<in> DOM C \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E x), h, GETr C x, Rx, Sx) \<in> reg) \<and> l \<in> Rx))")
prefer 2 apply (simp add: Bounded_def)
apply (rotate_tac 5, erule thin_rl)
apply (subgoal_tac "l \<notin> {l. \<exists>z. z \<in> U1 \<and> z \<in> DOM C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}", fast)
apply clarsimp
apply fast
apply (rule, simp add: modified_def) apply (erule_tac x=l in allE, erule impE, fastsimp) apply (simp add: sameOH_def) apply (simp add: fmap_dom_def fmap_lookup_def dom_def) 
  apply clarsimp
apply (case_tac "z = x", clarsimp)
(*z=x*) apply (subgoal_tac "R=Rz \<and> S=Sz", clarsimp)
  apply (simp add: Bounded_def)
  apply (erule_tac x=l in allE, clarsimp)
  apply fast
  apply (erule reg_Unique) apply (simp add: GETr_def)
(* z \<noteq> x*) 
  apply clarsimp
  apply (subgoal_tac "z : DOM C")
  apply (erule_tac x=z in allE, erule_tac x=Rz in allE, erule impE, clarsimp)
  apply (subgoal_tac "(RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg",fast)
  apply (erule reg_h1_h_letv, assumption+)
  apply fast
  apply assumption 
  apply fast
  apply (simp add: DOM_def)
apply assumption
apply fast
done

lemma Bnd_Letr:
"\<lbrakk>U1 \<inter> (U2 - {x}) = {};  regionsExist (U1 \<union> (U2 - {x})) C h E; regionsDistinct (U1 \<union> (U2 - {x})) C h E;
          distinctFrom (U1 \<union> (U2 - {x})) C h E F; (RVal r, h1, Some (T1), R, S) \<in> reg; modified F U1 C h E h1;
          R \<inter> FF = {}; Bounded R F U1 C h E; Bounded FF F U1 C h E; 
           modified FF U2 ((x,T1)#C) h1 E\<lfloor>x:=r\<rfloor> hh;
          Bounded Ra FF U2 ((x,T1)#C) h1 E\<lfloor>x:=r\<rfloor>\<rbrakk>
       \<Longrightarrow> Bounded Ra F (U1 \<union> (U2 - {x})) C h E"
apply (simp add: Bounded_def)
apply (rule, rule)
apply (rotate_tac -2, erule_tac x=l in allE, erule impE,simp, erule disjE)
apply (subgoal_tac "l : F \<union> {l. \<exists>z. z \<in> U1 \<and> z \<in> DOM C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}")
prefer 2 apply fast
apply (subgoal_tac "l : F \<or> l: {l. \<exists>z. z \<in> U1 \<and> z \<in> DOM C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}")
prefer 2 apply fast
apply (erule disjE, simp)
apply (subgoal_tac "\<exists>xa. (xa \<in> U1 \<or> xa \<in> U2 \<and> xa \<noteq> x) \<and> xa \<in> DOM C \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E xa), h, GETr C xa, Rx, Sx) \<in> reg) \<and> l \<in> Rx)", simp)
apply clarsimp
apply (rotate_tac 8, erule thin_rl)
apply fast
apply (erule exE, (erule conjE)+)+ apply (erule exE)
apply (case_tac "xa=x")
(*xa=x*)
  apply (subgoal_tac "R=Rx \<and> S=Sx")
  apply (erule_tac x=l in allE, erule impE, clarsimp)
  apply (erule disjE, simp)
  apply (subgoal_tac "\<exists>xa. (xa \<in> U1 \<or> xa \<in> U2 \<and> xa \<noteq> x) \<and> xa \<in> DOM C \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E xa), h, GETr C xa, Rx, Sx) \<in> reg) \<and> l \<in> Rx)", simp)
  apply clarsimp apply fast
  apply (erule reg_Unique) apply (simp add: GETr_def)
(*xa\<noteq>x*)
apply (subgoal_tac "\<exists>xa. (xa \<in> U1 \<or> xa \<in> U2 \<and> xa \<noteq> x) \<and> xa \<in> DOM C \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E xa), h, GETr C xa, Rx, Sx) \<in> reg) \<and> l \<in> Rx)", simp)
apply clarsimp
apply (subgoal_tac "xa : DOM C")
apply (rotate_tac 8, erule thin_rl)
apply (subgoal_tac "(RVal (renv E xa), h, GETr C xa, Rx, Sx) \<in> reg",fast)
apply (erule reg_h1_h_letv, assumption+)
apply fast
apply assumption
apply (simp add: DOM_def)
done

lemma DA_C_Letr:
     "\<lbrakk> G \<rhd> e : \<lbrace>U1, n, C \<guillemotright> T1, m\<rbrace>;
        G \<rhd> ee : \<lbrace>U2, m, (x,T1)#C \<guillemotright> T2, k\<rbrace>;
        U1 \<inter> (U2-{x}) = {}; T1 \<notin> {IntET, UnitET}\<rbrakk>
     \<Longrightarrow> G \<rhd> (LET rf x = e IN ee END): \<lbrace>U1 \<union> (U2-{x}), n, C \<guillemotright> T2, k\<rbrace>"
apply (rule vdm_conseq,erule vdm_letr, assumption)
apply (erule thin_rl, erule thin_rl, clarsimp)
apply (simp add: DAssComplex_def, safe)
apply (subgoal_tac "(\<exists> n1 n2 . (E, h, U1, C, n1) \<in> ContextSize \<and> (E, h, U2 - {x}, C, n2) \<in> ContextSize \<and> n1 + n2 = CS)", clarsimp)
prefer 2 apply (erule ContextSize_SPLIT, simp, assumption)
apply (erule_tac x="n2+q" in allE, erule_tac x=n1 in allE, erule_tac x=F in allE, erule impE, clarsimp)
apply (rule_tac x=N in exI, clarsimp)
  apply(rotate_tac 1, erule thin_rl,safe)
  apply (erule regionsExist_antimonotone,fast)
  apply (erule regionsDistinct_antimonotone,fast)
  apply (erule distinctFrom_antimonotone,fast)

  apply (case_tac "x:U2")
  (*x:U2*) apply (erule_tac x=q in allE, erule_tac x="n2+S" in allE,erule_tac x=FF in allE, erule impE, clarsimp)
    apply (rule_tac x=M in exI, safe)
      apply (erule regEx_Letr, assumption+)
      apply (erule regsDist_Letr, assumption+)
      apply (erule distFrom_Letr, assumption+)
      apply (erule ContextSizeCONS, simp add: GETr_def) apply (rule SizePreserved_h_h1)
          apply(erule ContextSizePreservedU) apply simp apply simp
          apply (simp add: modified_def) apply (subgoal_tac "modified F U1 C h E h1") prefer 2 apply (simp add: modified_def)
            apply (erule_tac x=l in allE, erule impE)
            apply (rule, simp add: distinctFrom_def) apply (erule_tac x=xa in allE, erule impE)
              apply (rule, rule disjI2, simp) apply (erule reg_DOM,fast)  
(*              apply (erule_tac x=Ra in allE, erule impE) 
              apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fT1)) xa = GETr C xa ", fastsimp) apply (rule GETr_Update1,fast)
            apply fast*)
          apply (rule, rule reg_region_in_heap1) apply (erule reg_h_h1_letv, assumption+)
            apply (subgoal_tac "xa:DOM C", assumption) (*apply (subgoal_tac "xa:DOM (C(x\<mapsto>\<^sub>fT1))", erule DOM_Update1,fast) *) apply (erule reg_DOM)
            apply fast 
(*            apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fT1)) xa = GETr C xa ", simp) apply (rule GETr_Update1,fast)*)
            apply assumption+
            apply clarsimp apply (simp add: regionsDistinct_def) 
              apply (erule_tac x=xa in allE, erule_tac x=z in allE, erule_tac x=Ra in allE, erule_tac x=Rz in allE, erule impE, clarsimp)
(*               apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fT1)) xa = GETr C xa ",clarsimp)*)
               apply (rule, erule reg_DOM) 
               apply (rule,fast)
               apply fastsimp
(*               apply (rule GETr_Update1,fast)*)
            apply fast apply simp 
        apply simp apply simp
  apply (rule_tac x=Ra in exI, rule_tac x=Sa in exI, rule_tac x=Ma in exI, rule_tac x=FFa in exI, safe)
  apply (erule mod_Letr) prefer 3 apply assumption prefer 5 apply assumption prefer 6 apply assumption+
  apply (erule Bnd_Letr, assumption+)
  apply (erule Bnd_Letr, assumption+)
  apply simp
  (*x\<notin>U2*) apply (erule_tac x="S+q" in allE, erule_tac x=n2 in allE,erule_tac x=FF in allE, erule impE, clarsimp)
    apply (rule_tac x=M in exI, safe)
      apply (rule regEx_Letr) apply (subgoal_tac "(U2 - {x}) = U2", clarsimp, assumption,fast) apply (subgoal_tac "(U2 - {x}) = U2", clarsimp,fast)+
      apply (rule regsDist_Letr) apply (subgoal_tac "(U2 - {x}) = U2", clarsimp, assumption,fast) apply (subgoal_tac "(U2 - {x}) = U2", clarsimp,fast)+
      apply (rule distFrom_Letr) apply (subgoal_tac "(U2 - {x}) = U2", clarsimp, assumption,fast) apply (subgoal_tac "(U2 - {x}) = U2", clarsimp,fast)+
      apply (rule SizePreserved_h_h1)
          apply(erule ContextSizePreservedU) apply (subgoal_tac "xa \<noteq> x", fastsimp,fast )
(*          apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fT1)) xa = GETr C xa ", simp) apply (rule GETr_Update1,fast)*)
          apply (subgoal_tac "xa \<noteq> x", simp) apply fast
          apply (subgoal_tac "xa \<noteq> x") prefer 2 apply fast
          apply (simp add: modified_def) apply (subgoal_tac "modified F U1 C h E h1") prefer 2 apply (simp add: modified_def)
            apply (erule_tac x=l in allE, erule impE)
            apply (rule, simp add: distinctFrom_def) apply (erule_tac x=xa in allE, erule impE)
              apply (rule, rule disjI2, simp) (*apply (rule DOM_Update1)*) apply (erule reg_DOM,fast) 
(*              apply (erule_tac x=Ra in allE, erule impE) 
              apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fT1)) xa = GETr C xa ", fastsimp) apply (rule GETr_Update1,fast)
            apply fast*)
          apply (rule, rule reg_region_in_heap1) apply (erule reg_h_h1_letv, assumption+)
(*            apply (subgoal_tac "xa:DOM C", assumption) apply (subgoal_tac "xa:DOM (C(x\<mapsto>\<^sub>fT1))", erule DOM_Update1,fast)*) apply (erule reg_DOM)
            apply assumption
(*            apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fT1)) xa = GETr C xa ", simp) apply (rule GETr_Update1,fast)*)
            apply assumption+
            apply clarsimp apply (simp add: regionsDistinct_def) 
              apply (erule_tac x=xa in allE, erule_tac x=z in allE, erule_tac x=Ra in allE, erule_tac x=Rz in allE, erule impE, clarsimp)
(*               apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fT1)) xa = GETr C xa ",clarsimp)*)
               apply (rule, erule reg_DOM) 
               apply (rule,fast)
               apply fastsimp
(*               apply (rule GETr_Update1,fast)*)
            apply fast apply simp 
        apply simp
  apply (rule_tac x=Ra in exI, rule_tac x=Sa in exI, rule_tac x=Ma in exI, rule_tac x=FFa in exI, safe)
  apply (subgoal_tac "modified F (U1 \<union> (U2-{x})) C h E hh",fastsimp)
  apply (rule mod_Letr,fast) apply (subgoal_tac "(U2 - {x}) = U2", clarsimp,fast)
       apply (subgoal_tac "(U2 - {x}) = U2", clarsimp,fast) apply assumption
       apply (subgoal_tac "(U2 - {x}) = U2", clarsimp,fast) prefer 2 apply assumption+
  apply (subgoal_tac "Bounded Ra F (U1 \<union> (U2-{x})) C h E",fastsimp) 
    apply(rule Bnd_Letr,fast) apply (subgoal_tac "(U2 - {x}) = U2", clarsimp,fast)
       apply (subgoal_tac "(U2 - {x}) = U2", clarsimp,fast)
       apply (subgoal_tac "(U2 - {x}) = U2", clarsimp,fast) prefer 2 apply assumption+
  apply (subgoal_tac "Bounded FFa F (U1 \<union> (U2-{x})) C h E",fastsimp) 
    apply(rule Bnd_Letr,fast) apply (subgoal_tac "(U2 - {x}) = U2", clarsimp,fast)
       apply (subgoal_tac "(U2 - {x}) = U2", clarsimp,fast)
       apply (subgoal_tac "(U2 - {x}) = U2", clarsimp,fast) prefer 2 apply assumption+
apply simp
apply simp
done

lemma DA_C_letr:
     "\<lbrakk> G \<rhd> e : \<lbrace>U1, n, C \<guillemotright> T1, m\<rbrace> ;
        G \<rhd> ee : \<lbrace>U2, m, ((x,T1)#C) \<guillemotright> T2, k\<rbrace>;
        U1 \<inter> (U2-{x}) = {}; T1 \<notin> {IntET, UnitET} ;UU=(U1 \<union> (U2-{x}))\<rbrakk>
     \<Longrightarrow> G \<rhd> (LET rf x = e IN ee END): \<lbrace>UU, n, C \<guillemotright> T2, k\<rbrace>"
by (rule vdm_conseq, rule DA_C_Letr, auto)

lemma DA_C_If: 
     "\<lbrakk>G \<rhd> e1 : \<lbrace>U1, n, C \<guillemotright> T, m\<rbrace>; G \<rhd> e2 : \<lbrace>U2, n, C \<guillemotright> T, m\<rbrace>\<rbrakk>
     \<Longrightarrow> G \<rhd> (IF b THEN e1 ELSE e2): \<lbrace>U1 \<union> U2, n, C \<guillemotright> T, m\<rbrace>"
apply (rule vdm_conseq, erule vdm_if, assumption, erule thin_rl, erule thin_rl, clarsimp)
apply (rule DAssC_PConst, erule disjE)
apply clarsimp 
apply (erule DAssC_monotone_in_U,fast)
apply clarsimp 
apply (erule DAssC_monotone_in_U,fast)
done
lemma DA_C_if: 
     "\<lbrakk> G \<rhd> e1 : \<lbrace>U1, n, C \<guillemotright> T, m\<rbrace>; G \<rhd> e2 : \<lbrace>U2, n, C \<guillemotright> T, m\<rbrace>;UU=(U1 \<union> U2)\<rbrakk>
     \<Longrightarrow> G \<rhd> (IF b THEN e1 ELSE e2): \<lbrace>UU, n, C \<guillemotright> T, m\<rbrace>"
by (rule vdm_conseq, rule DA_C_If, auto)

lemma DA_C_Call0:
"\<lbrakk>(G \<union> {(CALL f, \<lambda> E h hh v p . \<exists> pp. tkcall pp = p \<and> \<lbrace>U, n, C \<guillemotright> T, m\<rbrace> E h hh v pp)}) \<rhd> 
   snd(funtable f) : \<lbrace>U, n, C \<guillemotright> T, m\<rbrace>\<rbrakk> \<Longrightarrow>
 G \<rhd> (CALL f) : \<lbrace>U, n, C \<guillemotright> T, m\<rbrace>"
apply (rule vdm_conseq)
apply (erule Call1)
apply clarsimp
apply (erule DAssC_PConst) 
done

lemma DA_C_Call:
"\<lbrakk>(G \<union> {(CALL f, \<lbrace>U, n, C \<guillemotright> T, m\<rbrace>)}) \<rhd> snd(funtable f) : \<lbrace>U, n, C \<guillemotright> T, m\<rbrace>\<rbrakk> \<Longrightarrow>
           G \<rhd> (CALL f) : \<lbrace>U, n, C \<guillemotright> T, m\<rbrace>"
apply (rule vdm_conseq)
apply (rule vdm_call)
apply (rule vdm_conseq)
apply (subgoal_tac "(G \<union> {(CALL f, \<lbrace>U, n, C \<guillemotright> T, m\<rbrace>)}) = ({(CALL f, \<lambda>u ua ub uc ud. \<lbrace>U, n, C \<guillemotright> T, m\<rbrace> u ua ub uc ud)} \<union> G)",clarsimp)
apply assumption
apply simp
apply clarsimp apply (erule DAssC_PConst)
apply clarsimp 
done

lemma DA_C_Call2:
"\<lbrakk>G \<rhd> snd(funtable f) : \<lbrace>U, n, C \<guillemotright> T, m\<rbrace>\<rbrakk> \<Longrightarrow> G \<rhd> (CALL f) : \<lbrace>U, n, C \<guillemotright> T, m\<rbrace>"
by (rule DA_C_Call, erule CtxtWeak)

lemma DA_C_CutCall:
  "\<lbrakk>rnl = ParList2RnameList (fst(funtable f));
    (CALL f, \<lbrace>U, n, (restr C rnl) \<guillemotright>  T, m\<rbrace>) : G; 
    \<forall> x. x:U \<longrightarrow> GETr C x = GETr (restr C rnl) x\<rbrakk>
 \<Longrightarrow> G \<rhd> (CALL f): \<lbrace>U, n, C \<guillemotright> T, m\<rbrace>"
by(rule DA_C_Contexts_same_on_U, erule vdm_ax, simp)


subsection{*Method invocation with argument renaming*}
lemma DA_C_Invs:
"\<lbrakk>({(c\<bullet>mn(args), \<lbrace>U, n, C \<guillemotright> T, m\<rbrace>)} \<union> G) \<rhd> (snd (methtable c mn)) :  
    (\<lambda> E h hh v p  . \<forall> E'. (Nullref, fst (methtable c mn), args, E',E):FRAME  \<longrightarrow> 
                     (\<lbrace>U, n, C \<guillemotright> T, m\<rbrace> E' h hh v (\<langle>3 0 1 1\<rangle> \<oplus> p) )) \<rbrakk> \<Longrightarrow>
   G \<rhd> (c\<bullet>mn(args)) : \<lbrace>U, n, C \<guillemotright> T, m\<rbrace>" 
by (rule vdm_conseq, erule vdm_invokestatic, clarsimp)

consts RENA::"(ARGTYPE \<times> PARAMTYPE \<times> ((rname \<times> rname) list)) set"
inductive RENA intros
RENA_NIL: "([], [], []):RENA"
RENA_IN: "(args, pars, f):RENA \<Longrightarrow> ((INarg x) # args, (INpar y) # pars, f):RENA"
RENA_RN: "\<lbrakk>(args, pars, f):RENA\<rbrakk>\<Longrightarrow> ((RNarg x) # args, (RNpar y) # pars, (x,y)#f):RENA"

lemma REN_property1[rule_format]:
"\<lbrakk>(A, P, f) \<in> RENA\<rbrakk> \<Longrightarrow> distinct (ArgList2RnameList A) \<longrightarrow>
 RenameCond1 (set (ArgList2RnameList A)) f (set (ParList2RnameList P))"
apply (erule RENA.induct)
apply (simp add: RenameCond1_def)
apply (simp add: RenameCond1_def)
apply (simp add: RenameCond1_def, clarsimp)
apply (erule_tac x=xa in allE, clarsimp)
done

lemma REN_property2[rule_format]:
"\<lbrakk>(A, P, f) \<in> RENA\<rbrakk> \<Longrightarrow> distinct ((ArgList2RnameList A)) \<longrightarrow>
 RenameCond2 (set (ArgList2RnameList A)) f (set (ParList2RnameList P))"
apply (simp add: RenameCond2_def)
apply (erule RENA.induct)
apply simp
apply simp
apply clarsimp
apply (rule, clarsimp)
apply (rule_tac x=x in exI, clarsimp)
apply clarsimp
apply (erule_tac x=ya in allE, clarsimp)
apply (rule_tac x=xa in exI, clarsimp)
done

lemma REN_property4a:
"\<lbrakk>(A, P, f) \<in> RENA\<rbrakk> \<Longrightarrow> distinct P \<longrightarrow> (\<forall> x y . lookup f x = Some y \<longrightarrow> x:set (ArgList2RnameList A) \<and> y :set (ParList2RnameList P))"
apply (erule RENA.induct)
apply simp
apply simp
apply clarsimp
done

lemma REN_property4[rule_format]:
"\<lbrakk>(A, P, f) \<in> RENA\<rbrakk> \<Longrightarrow> distinct P \<longrightarrow>
 RenameCond4 (set (ArgList2RnameList A)) f (set (ParList2RnameList P))"
apply (simp add: RenameCond4_def)
apply (erule RENA.induct)
apply simp
apply simp
apply clarsimp
apply (case_tac "x1=x", clarsimp)
(*1*) apply (case_tac "x2=x")
  (*1*) apply clarsimp
  (*2*) apply clarsimp
    apply (subgoal_tac "lookup f x2 = Some y")
    prefer 2 apply (simp)
    apply (drule REN_property4a, erule impE, simp) 
    apply (rotate_tac -1, erule_tac x=x2 in allE, rotate_tac -1,erule_tac x=y in allE, erule impE, simp)
    apply (erule conjE)
    apply (drule PL2RL_p1, simp)
(*2*) apply clarsimp apply (case_tac "x1=x")
  (*1*) apply clarsimp
  (*2*) apply (drule REN_property4a, clarsimp) 
        apply (rotate_tac -1, erule_tac x=x1 in allE, rotate_tac -1,erule_tac x=y in allE, clarsimp)
        apply (drule PL2RL_p1, simp)
done

lemma REN_Env[rule_format]:
"(ARGS, PARS,f):RENA \<Longrightarrow> distinct PARS \<longrightarrow> distinct (ArgList2RnameList ARGS) \<longrightarrow> (\<forall> E EE. (Nullref,PARS,ARGS,E,EE):FRAME \<longrightarrow>
(\<forall> x y . (lookup f x = Some y) \<longrightarrow> E\<lfloor>x\<rfloor> = EE\<lfloor>y\<rfloor>))"
apply (erule RENA.induct)
apply simp
apply clarsimp 
  apply (erule FRAME.elims, simp_all)
apply clarsimp
  apply (erule FRAME.elims, simp_all, clarsimp)
  apply (erule_tac x=Ea in allE)
  apply (erule_tac x=EEa in allE, simp) 
  apply (erule_tac x=xa in allE, simp)
  apply (subgoal_tac "\<exists> z . lookup f xa = Some z", clarsimp)
  prefer 2 apply (simp)
  apply (drule REN_property4a, simp)
  apply (erule_tac x=xa in allE, clarsimp)
  apply (drule PL2RL_p1)
    apply (subgoal_tac "yb \<noteq> xb", simp)
    apply fast 
done

lemma REN_FRAME[rule_format]:
"(ARGS, PARS,f):RENA \<Longrightarrow> distinct PARS \<longrightarrow> distinct (ArgList2RnameList ARGS) \<longrightarrow> (\<forall> E . \<exists> EE. (Nullref,PARS,ARGS,E,EE):FRAME)"
apply (erule RENA.induct)
apply clarsimp 
  apply rule apply (rule FRAME_NIL)
apply clarsimp
  apply (erule_tac x=E in allE, clarsimp) apply (rule, erule FRAME_IN)  apply simp
apply clarsimp
  apply (erule_tac x=E in allE, clarsimp) apply (rule, erule FRAME_RN)  apply simp
done

lemma AdaptRename:
"\<lbrakk>\<lbrace>UU, n, C  \<ggreater> T, m\<rbrace> EE h hh v p;
        distinct P;
        distinct (ArgList2RnameList L);
        (L, P ,f):RENA;
        U = set (ArgList2RnameList L); U \<subseteq> DOM G;
        UU = set (ParList2RnameList P); UU \<subseteq> DOM C;
        \<forall> x y . ((lookup f x = Some y) \<longrightarrow> E\<lfloor>x\<rfloor> = EE\<lfloor>y\<rfloor>);
        \<forall> x y . ((lookup f x = Some y) \<longrightarrow> (GETr G x = GETr C y))\<rbrakk> \<Longrightarrow>
       \<lbrace>U , n , G \<ggreater> T, m \<rbrace> E h hh v p"
apply (erule DAss_Rename)
apply assumption+
apply (simp, erule REN_property1, assumption)
apply (simp, erule REN_property2, assumption)
prefer 2 apply (simp, erule REN_property4, assumption) 
apply (simp add: RenameCond3_def, clarsimp)
apply (frule REN_property4a, clarsimp)
done

subsubsection{*Diamond class rules*}
lemma DA_C_Free: "\<lbrakk>GETr C x = Some T; m=n+1; T \<notin> {IntET, UnitET}\<rbrakk> \<Longrightarrow> G \<rhd> (DIAM\<bullet>Free([RNarg x])) : \<lbrace>{x}, n, C \<guillemotright> UnitET, m\<rbrace>"
apply (rule vdm_invokestatic)
apply (simp add: Meth_Free)
apply (rule vdm_conseq) 
apply (rule vdm_letr, rule vdm_getstat)
apply (rule vdm_letv, rule vdm_putfr)
apply (rule vdm_putstat)
apply (subgoal_tac "x: DOM C")
prefer 2 apply (erule GETrSome_DOM)
apply (simp add: DAssComplex_def, clarsimp)
apply (subgoal_tac "E'\<lfloor>x\<rfloor> = Ref a")
prefer 2 apply (erule FRAME.elims, simp_all) (*apply (simp add: newframe_env_def evalARGS_def self_def)*)
apply (rule_tac x="{}" in exI, rule_tac x=0 in exI)
apply (rule_tac x="Suc N" in exI, rule_tac x="F \<union> {a}" in exI, safe)
apply (subgoal_tac "a \<notin> F")
prefer 2 apply (simp add: distinctFrom_def) apply (simp add: regionsExist_def, clarsimp)
  apply (erule_tac x=Rx in allE, erule impE, fast)
  apply (subgoal_tac "a:Rx", fast) apply (erule Ref_reg, assumption)
apply (simp add: freelist_def)
  apply (subgoal_tac "(Suc N, Ref a, F \<union> {a}, h
           \<lparr>rheap := (rheap h)(DOLLAR_N := (rheap h DOLLAR_N)(a := h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>)),
              sheap := (sheap h)(DIAM := (sheap h DIAM)(DOLLAR_F := Ref a))\<rparr>)
          \<in> FL", simp)
  apply (rule FL_SUC)
  apply simp apply (rule Class_is_DIAM, assumption+) 
  apply simp apply (erule FL_UpdateOutside, assumption)  
  apply (rule regUnit)
apply (simp add: modified_def, clarsimp)
  apply (simp add: sameOH_def)
  apply (simp add: regionsExist_def, clarsimp)
  apply (erule_tac x=Rx in allE, erule impE, fast)
  apply (subgoal_tac "a: Rx", fast) apply (erule Ref_reg, assumption)
apply (simp add: Bounded_def)
apply (simp add: Bounded_def)
  apply (rule disjI2)
  apply (simp add: regionsExist_def, clarsimp)
  apply (rule_tac x=Rx in exI, rule, fast)
  apply (erule Ref_reg, assumption)
apply simp
done
lemma DA_C_free: "\<lbrakk>GETr C x = Some T; U={x}; m=n+1; T \<notin> {IntET, UnitET}\<rbrakk> \<Longrightarrow> G \<rhd> (DIAM\<bullet>Free ([RNarg x])) : \<lbrace>U, n, C \<guillemotright> UnitET, m\<rbrace>"
by (rule vdm_conseq,rule DA_C_Free, auto)
(*>*)

subsubsection {*Rules for freelist management*}
lemma DA_Free: "\<lbrakk>GETr C x = Some T; m=n+1; T \<notin> {IntET, UnitET}\<rbrakk> \<Longrightarrow> G \<rhd> (DIAM\<bullet>Free([RNarg x])) : \<lbrace>{x}, n, C \<ggreater> UnitET, m\<rbrace>"
(*<*) by (rule DA_Eq2, rule DA_C_Free)
lemma DA_free: "\<lbrakk>GETr C x = Some T; U={x}; m=n+1; T \<notin> {IntET, UnitET}\<rbrakk> \<Longrightarrow> G \<rhd> (DIAM\<bullet>Free ([RNarg x])) : \<lbrace>U, n, C \<ggreater> UnitET, m\<rbrace>"
by (rule DA_Eq2, rule DA_C_free)
(*>*)

lemma DA_Free1:
"G \<rhd>  (DIAM\<bullet>Free([RNarg t])) : 
   (\<lambda> E h hh v p . \<exists> a . E\<lfloor>t\<rfloor> = Ref a \<and>
                          hh = h\<lparr>rheap := (rheap h)(DOLLAR_N := (rheap h DOLLAR_N)(a := h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>)),
                                 sheap := (sheap h)(DIAM := (sheap h DIAM)(DOLLAR_F := Ref a))\<rparr> \<and> 
                          v = arbitrary \<and> p = (mkRescomp 12 0 1 (Suc 0)))"
(*<*)
apply (rule vdm_invokestatic)
apply (simp, rule CtxtWeakSingleton)
apply (simp add: Meth_Free) 
apply (rule vdm_conseq, rule vdm_letr, rule vdm_getstat)
apply (rule vdm_letv, rule vdm_putfr, rule vdm_putstat)
apply clarsimp
apply (erule FRAME.elims, simp_all)
(*apply (simp add: self_def newframe_env_def evalARGS_def)*)
done
(*>*)

lemma DA_Alloc:
"G \<rhd>  (DIAM\<bullet>Alloc([])) : 
    (\<lambda> E h hh v p . (h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace> = Nullref \<longrightarrow>
                      hh = \<lparr>oheap = oheap h(freshloc (Dom h)\<mapsto>\<^sub>fDIAM), iheap = iheap h, rheap = rheap h, sheap = sheap h\<rparr> \<and> 
                      v = RVal (Ref (freshloc (Dom h)))) \<and> 
                    (h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace> \<noteq> Nullref \<longrightarrow> 
                      (\<exists> h1 r. (\<exists>a. h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace> = Ref a \<and> h1 = h \<and> r = h\<lfloor>a\<diamondsuit>DOLLAR_N\<rfloor>) \<and>
                                hh = h1\<lparr>sheap := (sheap h1)(DIAM := (sheap h1 DIAM)(DOLLAR_F := r))\<rparr> \<and>
                                v = RVal h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>)))"
(*<*)
apply (rule vdm_invokestatic)
apply (simp add: Meth_Alloc)
apply (rule CtxtWeakSingleton)
apply (rule vdm_conseq, rule vdm_letr, rule vdm_getstat)
apply (rule vdm_leti,rule vdm_rprim)
apply (rule vdm_if, rule vdm_new)
apply (rule Call1, simp add: Fun_AllocQ)
apply (rule CtxtWeakSingleton)
apply (rule vdm_letr, rule vdm_getfr)
apply (rule vdm_letv, rule vdm_putstat, rule vdm_rvar)
apply clarsimp 
(*apply (simp only: newObj_def newframe_env_def evalARGS_def) apply (simp add:self_def) apply clarsimp*)
apply (simp only: newObj_def) apply clarsimp 
done
(*>*)


lemma DA_Fill_DIID:
"G \<rhd>  (DIAM\<bullet>Fill_DIID([RNarg x_, INarg tag_, INarg v0_, RNarg r1_])) : 
  (\<lambda> E h hh v p . (\<forall> a . E\<lfloor>x_\<rfloor> = Ref a \<longrightarrow> 
              hh=(h\<lparr>iheap := (iheap h)(DOLLAR := (iheap h DOLLAR)(a := ienv E tag_)),
                    iheap := (iheap h)(DOLLAR := (iheap h DOLLAR)(a := ienv E tag_),
                         V0 := (iheap h V0)(a := ienv E v0_)),
                    rheap := (rheap h)(R1 := (rheap h R1)(a := renv E r1_))\<rparr>) \<and> 
             v = (RVal (Ref a))))"
apply (rule vdm_invokestatic)
apply (simp add: Meth_Fill_DIID)
apply (rule CtxtWeakSingleton)
apply (rule vdm_conseq)
apply (rule vdm_letv, rule vdm_putfi)
apply (rule vdm_letv, rule vdm_putfi)
apply (rule vdm_letv, rule vdm_putfr)
apply (rule vdm_rvar,clarsimp)
apply (erule FRAME.elims, simp_all) apply clarsimp
apply (erule FRAME.elims, simp_all) apply clarsimp
apply (erule FRAME.elims, simp_all) apply clarsimp
apply (erule FRAME.elims, simp_all) apply clarsimp
done

lemma DA_Fill_DIIDD:
"G \<rhd>  (DIAM\<bullet>Fill_DIIDD([RNarg x_, INarg tag_, INarg v0_, RNarg r1_, RNarg r2_])) : 
       (\<lambda> E h hh v p . \<forall> a . (E\<lfloor>x_\<rfloor> = Ref a \<longrightarrow>  hh=(h\<lparr>iheap := (iheap h)
                      (DOLLAR := (iheap h DOLLAR)
                         (a := ienv E tag_)),
                      iheap := (iheap h)
                        (DOLLAR := (iheap h DOLLAR)
                           (a := ienv E tag_),
                         V0 := (iheap h V0)
                           (a := ienv E v0_)),
                      rheap := ((rheap h)
                        (R1 := (rheap h R1)
                           (a := renv E r1_)))
                        (R2 := (rheap h R2)
                           (a := renv E r2_))\<rparr>) \<and>  v = (RVal (Ref a))))"
apply (rule vdm_invokestatic)
apply (simp add: Meth_Fill_DIIDD)
apply (rule CtxtWeakSingleton)
apply (rule vdm_conseq)
apply (rule vdm_letv, rule vdm_putfi)
apply (rule vdm_letv, rule vdm_putfi)
apply (rule vdm_letv, rule vdm_putfr)
apply (rule vdm_letv, rule vdm_putfr)
apply (rule vdm_rvar,clarsimp)
apply (erule FRAME.elims, simp_all) apply clarsimp
apply (erule FRAME.elims, simp_all) apply clarsimp
apply (erule FRAME.elims, simp_all) apply clarsimp
apply (erule FRAME.elims, simp_all) apply clarsimp
apply (erule FRAME.elims, simp_all) apply clarsimp
done

(*<*)
end
(*>*)
