Require Arith.
Require cgAbSyn.
Require cgSyntax.
Require cgEval.
Require StoreLemmas.
Require Ring.
Require ArithRing.
Require cgLoops.

Fixpoint sumSpec [n:nat] : nat :=
  Cases n of O     => (O)
           | (S m) => (plus n (sumSpec m))
          end.

Definition blocks :=
  (cons (bb#0,[- if v#0 < 1 then bb#2 else bb#1 -])
  (cons (bb#1,[- v#1 := v#1 + v#0; v#0 := v#0 - 1; goto bb#0 -])
  (cons (bb#2,[- return v#1 -])
  emptyBBs))).
Definition main := [- v#1 := 0; goto bb#0 -].

Definition sum_invariant : nat -> storepredicate :=
 [n:nat;s:store]
 (EX x | (EX y | (Instore s v#0 x)/\(Instore s v#1 y)/\(sumSpec n)=(plus (sumSpec x) y))).

Lemma sum_correct :
 (n:nat;gs:globalstate;mt:MethTable)(evalMethod mt (blocks,main) gs (cons (v#0,n) emptyStore) (resultis [m:nat]m=(sumSpec n))).
Intros. Unfold main.
evalAssign '(0). evalGoto.
EApply decr_loop with loopvar:=v#0 body_lbl:=bb#1 test_lbl:=bb#0 exit_lbl:=bb#2 inv:=(sum_invariant n); Intros.

(* Pre-conditions *)
FindInBBTable. FindInBBTable. FindInBBTable. FindInStore.
Exists n. Exists (0). SplitMany. FindInStore. FindInStore. Auto with arith.

(* Loop step *)
OpenRecord H0. evalAssign '(plus x0 x). evalBinop 'x0 'x.
Apply H1.
  FindInStore.
  Exists n0. Exists (plus x0 x). SplitMany.
    FindInStore. FindInStore.
    Rewrite H5. Rewrite (storeLookupDet ???? H2 H). Simpl. Ring. Simpl. Apply (f_equal nat). Ring.

(* Loop exit *)
OpenRecord H0. evalReturn x0.
Rewrite H4. Rewrite (storeLookupDet ???? H1 H). Simpl. Unfold resultis. Reflexivity.
Save.
