Require cgAbSyn.
Require cgSyntax.
Require cgEval.
Require Arith.
Require StoreLemmas.
Require Wf_nat.
Require LtFacts.
Require Omega.

Section Sqrt_Method.

Hypothesis mt : MethTable.
Hypothesis gs : globalstate.

Definition sqrt := [n,r:nat](le (mult r r) n)/\(lt n (mult (S r) (S r))).

Definition sqrt_blocks :=
 (cons (bb#0, [- v#2 := 1 + v#1; v#2 := v#2 * v#2; if v#0 < v#2 then bb#2 else bb#1 -])
 (cons (bb#1, [- v#1 := 1 + v#1; goto bb#0 -])
 (cons (bb#2, [- return v#1 -])
 emptyBBs))).
Definition sqrt_main := [- v#1 := 0; goto bb#0 -].

Lemma sqrt_correct : (s:store;n:nat)(Instore s v#0 n)->(evalMethod mt (sqrt_blocks, sqrt_main) gs s (resultis (sqrt n))).
Intros. Unfold sqrt_main. evalAssign '(0). evalGoto.
Refine [r:=(0)]?. LetTac s':=(update s v#1 r).
Assert inv : (Instore s' v#0 n)/\(Instore s' v#1 r)/\(le (mult r r) n). SplitMany; (Unfold s'; FindInStore) Orelse Auto with arith.
Generalize r gs s' inv. Clear r gs s' inv.
Intro r. Apply (inductionP_ltof1 nat (minus n)) with a:=r; Intros; OpenRecord inv.

evalAssign '(S x). evalBinop '(1) 'x. 
evalAssign '(mult (S x) (S x)). evalBinop '(S x) '(S x).
Elim (lt_ge_dec n (mult (S x) (S x))); Intros.

evalIf1. evalBinop 'n '(mult (S x) (S x)).
evalReturn 'x. Split; Assumption.

evalIf0. evalBinop 'n '(mult (S x) (S x)).
evalAssign '(S x). evalBinop '(1) 'x.
evalGoto.
Apply (H0 (S x)).
Unfold ltof. Assert (le (S x) n). Apply le_sqr. Assumption. Omega.
SplitMany. FindInStore. FindInStore. Assumption. 
Save.

End Sqrt_Method.
