Require cgAbSyn.
Require cgSyntax.
Require cgEval.
Require Arith.
Require Wf_nat.
Require StoreLemmas.
Require Ring.
Require ArithRing.
Require cgpDivide.

Section GcdMethod.

Hypothesis mt : MethTable.
Hypothesis have_remainder : (InMethTable mt m#0 remainder_method).
Hypothesis gs : globalstate.

Definition gcd_blocks :=
 (cons (bb#0, [- v#2 := (invoke m#0 (cons (var v#0) (cons (var v#1) (nil synVal))));
                 if v#2 = 0 then bb#2 else bb#1 -])
 (cons (bb#1, [- v#0 := v#1; v#1 := v#2; goto bb#0 -])
 (cons (bb#2, [- return v#1 -])
 emptyBBs))).
Definition gcd_main := [- goto bb#0 -].
Definition gcd_method := (gcd_blocks, gcd_main).

Definition divides : nat->nat->Prop := [a,b](EX k | (mult a k)=b).
Definition cd : nat->nat->nat->Prop := [a,b,g](divides g a)/\(divides g b).
Definition gcd : nat->nat->nat->Prop := [a,b,g](cd a b g)/\(g':nat)(cd a b g')->(ge g g').

Lemma rem_O : (a,b:nat)(remainder a b O)->(divides b a).
Intros. OpenRecord H. Exists x. Rewrite H1. Ring. 
Save.

Lemma divides_a_a : (a:nat)(divides a a).
Intros. Exists (1). Auto with arith.
Save.

Lemma divides_gcd : (a,b:nat)(gt b O)->(divides b a)->(gcd a b b).
Intros.
Split.
Split. Assumption. Apply divides_a_a.
Intros.
OpenRecord H1. OpenRecord H3. Clear H0 H2.
Elim (O_or_S x); Intros.
OpenRecord a0. Rewrite <- H1. Rewrite <- p. Rewrite mult_sym. Simpl. Auto with arith.
Rewrite <- H1 in H. Rewrite <- b0 in H. Rewrite mult_sym in H. Simpl in H. Absurd (gt (0) (0)); Auto with arith.
Save.

Lemma rem_cd_1 : (a,b,r:nat)(remainder a b r)->(g:nat)(cd a b g)->(cd b r g).
Intros. OpenRecord H0. Split.
Assumption.
OpenRecord H. OpenRecord H1. OpenRecord H2.
Exists (minus x0 (mult x x1)).
Rewrite mult_sym.
Rewrite mult_minus_distr.
Symmetry.
Apply plus_minus.
Rewrite mult_sym.
Rewrite H.
Rewrite H3.
Rewrite <- H0.
Ring.
Save.

Lemma rem_cd_2 : (a,b,r:nat)(remainder a b r)->(g:nat)(cd b r g)->(cd a b g).
Intros. OpenRecord H0.
Split.
OpenRecord H. OpenRecord H2. OpenRecord H1.
Rewrite <- H in H3. Rewrite <- H0 in H3.
Exists (plus (mult x x1) x0). Rewrite H3. Ring.
Assumption.
Save.

Lemma rem_gcd_1 : (a,b,r:nat)(remainder a b r)->(g:nat)(gcd a b g)->(gcd b r g).
Intros. OpenRecord H0. Split; Intros.
  Apply rem_cd_1 with a:=a; Assumption.
  Apply H2. Apply rem_cd_2 with r:=r; Assumption.
Save.

Lemma rem_gcd_2 : (a,b,r:nat)(remainder a b r)->(g:nat)(gcd b r g)->(gcd a b g).
Intros. OpenRecord H0. Split; Intros.
  Apply rem_cd_2 with r:=r; Assumption.
  Apply H2. Apply rem_cd_1 with a:=a; Assumption.
Save.

Hypothesis s : store.
Hypothesis i,j : nat.
Hypothesis have_i : (Instore s v#0 i).
Hypothesis have_j : (Instore s v#1 j).
Hypothesis gt_i_j : (gt i j).
Hypothesis gt_j_O : (gt j O).

Lemma gcd_correct : (evalMethod mt (gcd_blocks, gcd_main) gs s (resultis (gcd i j))).
Intros. Unfold gcd_main. evalGoto.
Generalize j gs s have_i have_j gt_i_j gt_j_O. Clear j gs s have_i have_j gt_i_j gt_j_O. Apply (lt_wf_ind i); Intros.
evalInvoke_2 'have_remainder 's0 'n 'j0 'remainder_correct. Assumption.
Generalize H0. Clear H0. Case n0; Intros.

evalIf1. evalBinop '(0) '(0). evalReturn 'j0. Unfold resultis. Apply divides_gcd. Assumption. Apply rem_O. Apply H0.

evalIf0. evalBinop '(S n1) '(0). evalAssign 'j0.  evalAssign '(S n1). evalGoto.
Apply strengthen with P:=(resultis (gcd j0 (S n1))). Unfold resultis. Intros. Apply rem_gcd_2 with r:=(S n1); Assumption.
Apply H. Auto with arith. FindInStore. FindInStore. OpenRecord H0. Assumption. Auto with arith.
Save.

End GcdMethod.
