Require cgAbSyn.
Require cgSyntax.
Require cgEval.
Require Arith.
Require StoreLemmas.
Require Omega.

Section FactorialRec_Method.

Hypothesis mt : MethTable.

Definition factorial_blocks :=
 (cons (bb#0, [- v#1 := v#0 - 1; v#1 := (invoke m#0 (cons (var v#1) (nil synVal))); v#0 := v#0 * v#1; return v#0 -])
 (cons (bb#1, [- return 1 -])
 emptyBBs)).
Definition factorial_main := [- if v#0 = 0 then bb#1 else bb#0 -].
Definition factorial_method := (factorial_blocks, factorial_main).

Hypothesis have_fac : (InMethTable mt m#0 factorial_method).
Hypothesis gs : globalstate.

Fixpoint factSpec [n:nat] : nat :=
 Cases n of O => (1) | (S n) => (mult (S n) (factSpec n)) end.

Lemma factorial_rec_correct :
 (n:nat;s:store)(Instore s v#0 n)->
 (evalMethod mt (factorial_blocks, factorial_main) gs s (resultis [m:nat]m=(factSpec n))).
Intro n. Generalize gs. Unfold factorial_main. Induction n; Intros.
evalIf1. evalBinop '(0) '(0). evalReturn '(1). Unfold resultis. Reflexivity. 

evalIf0. evalBinop '(S n) '(0). evalAssign 'n. evalBinop '(S n) '(1).
EApply evalStepAssignInvoke.
  Apply have_fac.
  Simpl. Reflexivity. 
  Apply Hrecn. FindInStore.
Intros.
evalAssign '(mult (S n) n0). evalBinop '(S n) 'n0.
evalReturn '(mult (S n) n0). Rewrite H0. Unfold resultis. Reflexivity. 
Save.

Lemma factorial_rec_time :
 (n:nat;s:store)(Instore s v#0 n)->
 (evalMethod mt (factorial_blocks, factorial_main) gs s [gs',_](diffticks gs gs')=(plus (3) (mult (11) n))).
Intro n. Generalize gs. Unfold factorial_main. Induction n; Intros.

evalIf1. evalBinop '(0) '(0). evalReturn '(1). NormTicks. Omega.

evalIf0. evalBinop '(S n) '(0). evalAssign 'n. evalBinop '(S n) '(1).
EApply evalStepAssignInvoke.
  Apply have_fac.
  Simpl. Reflexivity. 
  Apply Hrecn. FindInStore. 
Intros.
  evalAssign '(mult (S n) n0). evalBinop '(S n) 'n0. evalReturn '(mult (S n) n0). 
  NormTicks. Simpl in H0. NormTicksIn H0. Omega.
Save.

End FactorialRec_Method.

