Require cgAbSyn.
Require cgSyntax.
Require cgEval.
Require Arith.
Require ArithRing.
Require StoreLemmas.
Require cgLoops.
Require Omega.

Section Factorial_Method.

Hypothesis mt : MethTable.
Hypothesis gs : globalstate.
Hypothesis n : nat.
Hypothesis s : store.
Hypothesis have_n : (Instore s v#0 n).

Fixpoint factSpec [n:nat] : nat :=
 Cases n of O => (1) | (S n) => (mult (S n) (factSpec n)) end.

Definition blocks:=
 (cons (bb#0, [- if v#0 = 0 then bb#2 else bb#1 -])
 (cons (bb#1, [- v#1 := v#1 * v#0; v#0 := v#0 - 1; goto bb#0 -])
 (cons (bb#2, [- return v#1 -])
 emptyBBs))).
Definition main := [- v#1 := 1; goto bb#0 -].

Lemma fact_correct : (evalMethod mt (blocks,main) gs s (resultis [m:nat]m=(factSpec n))).
Unfold main. evalAssign '(1). evalGoto.
Refine [r:=n]?. Refine [y:=(1)]?. LetTac s':=(update s v#1 (1)).
Assert inv : (Instore s' v#0 r)/\(Instore s' v#1 y)/\(factSpec n)=(mult (factSpec r) y).
SplitMany. Unfold s'; FindInStore. Unfold s'; FindInStore. Auto with arith.
Generalize r y s' gs inv. Clear r y s' gs inv. Induction r; Intros; OpenRecord inv.

(* n = 0 *)
evalIf1. evalBinop '(0) '(0). 
evalReturn y. Unfold resultis. Rewrite H2. Auto with arith.

(* n > 0 *)
evalIf0. evalBinop '(S n0) '(0). 
evalAssign '(mult y (S n0)). evalBinop 'y '(S n0).
evalAssign 'n0. evalBinop '(S n0) '(1). 
evalGoto. EApply H. SplitMany. FindInStore. FindInStore. Rewrite H3. Ring. Simpl. Ring.
Save.

Lemma fact_time : (evalMethod mt (blocks,main) gs s [gs',r](diffticks gs gs')=(plus (5) (mult (10) n))).
Intros. Unfold main. evalAssign '(1). evalGoto.
Refine ([n':=n]?).
LetTac s':=(update s v#1 (1)).
Assert (Instore s' v#0 n'). Unfold s'. FindInStore.
Assert (EX q | (Instore s' v#1 q)). Exists (1). Unfold s'. FindInStore.
NormTicks. Simpl. LetTac gs':=(addticks (2) gs).
Apply strengthen with P:=[gs'0;_:nat](diffticks gs' gs'0)=(plus (3) (mult (10) n)).
  Intros. Unfold gs' in H1. NormTicksIn H1. Omega.
Generalize gs' s' H H0. Clear gs' s' H H0. Induction n'; Intros; OpenRecord H0.

evalIf1. evalBinop '(0) '(0). evalReturn 'x. NormTicks. Omega.

evalIf0. evalBinop '(S n') '(0). evalAssign '(mult x (S n')). evalBinop 'x '(S n').
evalAssign 'n'. evalBinop '(S n') '(1). evalGoto. 
NormTicks. Simpl. LetTac gs'':=(addticks (10) gs').
Apply strengthen with P:=[gs'0;_:nat](diffticks gs'' gs'0)=(plus (3) (mult (10) n')). 
  Intros. Unfold gs'' in H0. NormTicksIn H0. NormTicks. Omega. 
Apply Hrecn'. FindInStore. Exists (mult x (S n')). FindInStore.
Save.

(*
Definition lift1 := [A,B:Set;f:A->B;x:(option A)]Cases x of None => (None B)
                                                          | (Some x) => (Some B (f x))
                                                         end.

Lemma lift1_l1 : (A,B:Set;b:B;f:A->B;aopt:(option A))(lift1 A B f aopt)=(Some B b)->(EX a | aopt=(Some A a)).
Intros. 
Elim (elim_option ? aopt); Intros.
Rewrite a in H. Simpl in H. Discriminate H.
Assumption.
Save.
Lemma lift1_l2 : (A,B:Set;b:B;f:A->B;a:A)(lift1 A B f (Some A a))=(Some B (f a)).
Intros. Simpl. Reflexivity.
Save.

Lemma lift_l : (A,B:Set;f:A->A->B;aopt,aopt':(option A))(EX b | (lift A B f aopt aopt')=(Some B b))->(EX a | aopt=(Some A a))/\(EX a | aopt'=(Some A a)).
Intros.
OpenRecord H.
Elim (elim_option ? aopt); Intros. 
Rewrite a in H0. Simpl in H0. Discriminate H0.
Elim (elim_option ? aopt'); Intros.
Rewrite a in H0. OpenRecord b. Rewrite H in H0. Simpl in H0. Discriminate H0.
Split; Assumption.
Save.
Lemma lift_l1 : (A,B:Set;f:A->A->B;aopt:(option A);a:A)(EX b | (lift A B f aopt (Some A a))=(Some B b))->(EX y | aopt=(Some A y)).
Intros.
Elim (elim_option ? aopt); Intros. 
OpenRecord H.
Rewrite a0 in H0. Simpl in H0. Discriminate H0.
Assumption.
Save.
Lemma lift_l2 : (A,B:Set;f:A->A->B;aopt:(option A);a:A)(EX b | (lift A B f (Some A a) aopt)=(Some B b))->(EX y | aopt=(Some A y)).
Intros.
Elim (elim_option ? aopt); Intros. 
OpenRecord H.
Rewrite a0 in H0. Simpl in H0. Discriminate H0.
Assumption.
Save.
Lemma lift_l3 : (A,B:Set;f:A->A->B;aopt,aopt':(option A))(EX a | aopt=(Some A a))->(EX a | aopt'=(Some A a))->(EX b | (lift A B f aopt aopt')=(Some B b)).
Intros. 
OpenRecord H. OpenRecord H0. 
Exists (f x x0). Rewrite H1. Rewrite H. Reflexivity. 
Save.
Lemma lift_l4 : (A,B:Set;f:A->A->B;aopt:(option A);a:A)(EX a | aopt=(Some A a))->(EX b | (lift A B f aopt (Some A a))=(Some B b)).
Intros. 
OpenRecord H. 
Exists (f x a). Rewrite H0. Reflexivity. 
Save.
Lemma lift_l5 : (A,B:Set;f:A->A->B;aopt:(option A);a:A)(EX a | aopt=(Some A a))->(EX b | (lift A B f (Some A a) aopt)=(Some B b)).
Intros. 
OpenRecord H. 
Exists (f a x). Rewrite H0. Reflexivity. 
Save.
Lemma lift_l6 : (A,B:Set;f:A->A->B;aopt,aopt':(option A))(EX y | aopt'=(Some A y))->(EX b | (lift A B f aopt aopt')=(Some B b))->(EX y | aopt=(Some A y)).
Intros.
Elim (elim_option ? aopt); Intros. 
OpenRecord H.
OpenRecord H0.
Rewrite a in H. Simpl in H. Discriminate H.
Assumption.
Save.
Lemma lift_l7 : (A,B:Set;f:A->A->B;aopt,aopt':(option A))(EX y | aopt=(Some A y))->(EX b | (lift A B f aopt aopt')=(Some B b))->(EX y | aopt'=(Some A y)).
Intros.
Elim (elim_option ? aopt'); Intros. 
OpenRecord H.
OpenRecord H0.
Rewrite a in H. Simpl in H. Rewrite H1 in H. Discriminate H.
Assumption.
Save.

Lemma l_eq_l : (A:Set;a,a':(option A))(l_eq ? a a')->(EX y | a=(Some A y))/\(EX y | a'=(Some A y)).
Intros.
Elim (elim_option ? a); Intros. 
Rewrite a0 in H. Contradiction. 
Elim (elim_option ? a'); Intros.
Rewrite a0 in H. OpenRecord b. Rewrite H0 in H. Contradiction.
Split; Assumption.
Save.
Hints Resolve l_eq_l.
Lemma l_eq_l1 : (A:Set;a:(option A);a':A)(l_eq A a (Some A a'))->(EX y | a=(Some A y)).
Intros.
Elim (elim_option ? a); Intros. Rewrite a0 in H. Contradiction. 
Assumption.
Save.
Lemma l_eq_l2 : (A:Set;a:(option A);a':A)(l_eq A (Some A a') a)->(EX y | a=(Some A y)).
Intros.
Elim (elim_option ? a); Intros. Rewrite a0 in H. Contradiction. 
Assumption.
Save.
Definition l_eq_l1_nat := (l_eq_l1 nat).
Definition l_eq_l2_nat := (l_eq_l2 nat).
Hints Resolve l_eq_l1_nat l_eq_l2_nat lift_l lift1_l1 lift_l1 lift_l2 lift1_l2 lift_l3 lift_l4 lift_l5 lift_l7 lift_l6.

Require LtFacts.
Require Sumbool.
Require EqNat.

Lemma fact_correct_2 : (triple mt nat blocks [z;gs;s](get s v#0)=(Some nat z) main [z;gs;n]n=(factSpec z)).
Unfold main.
EApply Hassign. 
EApply Hgoto with P:=[z:nat;gs:globalstate;s:store](get s v#0)=(Some nat z)/\(get s v#1)=(Some nat (1)). FindInBBTable.
EApply Hconsequence_pre.
EApply Hrec with R:=[s,s':globalstate*store](lt_option (get (Snd s) v#0) (get (Snd s') v#0))
                 P:=[z:nat;gs:globalstate;s:store](l_eq ? (Some ? (factSpec z)) (l_semBinop synTimes (lift1 ?? factSpec (get s v#0)) (get s v#1))).
Apply wf_r_3. Intros.
EApply Hif2 with Q:=[z:nat;gs:globalstate;s:store;n:nat](l_eq ? (Some nat n) (l_semBinop synEq (get s v#0) (Some nat (0))))/\(l_eq ? (Some ? (factSpec z)) (l_semBinop synTimes (lift1 ?? factSpec (get s v#0)) (get s v#1)))/\s=s'.
FindInBBTable. FindInBBTable.
EApply Hconsequence_pre. EApply Hreturn.
Intros. Simpl. OpenRecord H0. Unfold l_semBinop in H1. Unfold l_semBinop in H3.
Assert (EX y | (Some nat (1))=(Some nat y))/\(EX y | (lift nat nat (semBinOp synEq) (get s0 v#0) (Some nat (0)))=(Some nat y)).
Apply (l_eq_l ??? H1). Elim H0; Intros. 
Assert (EX y | (get s0 v#0)=(Some nat y)). Apply (lift_l1 ????? H5).

EAuto. 
Assert (EX y | (get s0 v#0)=(Some nat y)). EAuto. OpenRecord H0. Rewrite H2 in H3. Simpl in H3.
Assert (EX y | (get s0 v#1)=(Some nat y)). EAuto. EApply lift_l2. EApply lift_l7. 2: EApply l_eq_l2_nat. Simpl. Apply H3. 
OpenRecord H0. Rewrite H5 in H3. Rewrite H2 in H1. Simpl in H1.
Rewrite H5. Simpl. Rewrite H3. Assert x=(0). Auto. Rewrite H0. Simpl. Rewrite <- plus_n_O. Reflexivity. 

EApply Hassign. EApply Hassign. 
EApply Hgoto with P:=[z:nat; gs:globalstate; s:store](l_eq nat (Some nat (factSpec z)) (l_semBinop synTimes (lift1 nat nat factSpec (get s v#0)) (get s v#1)))/\(lt_option (get s v#0) (get s' v#0)).
FindInBBTable.
Apply H.

EApply Hbinop. 
EApply Hexpconsequence_pre. EApply Hbinop. 
Intros. OpenRecord H0.
Rewrite <- H4.
Assert (EX y | (get s0 v#0)=(Some nat y)). Unfold l_semBinop in H1. EAuto.
Assert (EX y | (get s0 v#1)=(Some nat y)). 
Elim (elim_option ? (get s0 v#0)); Intros. Rewrite a in H3. Contradiction. OpenRecord b.
Rewrite H0 in H3. 
Elim (elim_option ? (get s0 v#1)); Intros. Rewrite a in H3. Contradiction. OpenRecord b.
Rewrite H2 in H3. Rewrite H0 in H1. Simpl in H3. Simpl in H1.
Simpl. Rewrite H0. Rewrite H2. Simpl. 
Assert ~x=(0). Auto. 
Split. 
Rewrite H3. Elim (O_or_S x); Intros. OpenRecord a. Rewrite <- p. Simpl. Rewrite <- minus_n_O. Ring. Simpl. Ring.
                                     Absurd x=(0). Assumption. Symmetry. Assumption.
Omega.

EApply Hexpconsequence_pre. EApply Hbinop.
Intros.
OpenRecord H0.
Elim (elim_option ? (get s0 v#0)); Intros; Elim (elim_option ? (get s0 v#1)); Intros. 
Rewrite a in H1. Rewrite a0 in H1. Contradiction. 
Rewrite a in H1. OpenRecord b. Rewrite H0 in H1. Contradiction. 
Rewrite a in H1. OpenRecord b. Rewrite H0 in H1. Contradiction.
OpenRecord b. OpenRecord b0.
Simpl. Rewrite H0. Rewrite H2. Simpl. 
SplitMany. Reflexivity. Rewrite H0 in H1. Rewrite H2 in H1. Simpl in H1. Assumption.
Assumption. 
Elim (sumbool_of_bool (beq_nat x (0))); Intros. Rewrite a. Auto. Rewrite b. Auto.

Intros. Simpl. OpenRecord H. Rewrite H0. Rewrite H1. Simpl. Rewrite mult_n_1. Reflexivity. 

EApply Hexpconsequence_pre. EApply Hconst.
Intros. Simpl. Auto.
Save.

Lemma instore_get : (s:store;v:Var;x:nat)(Instore s v x)->(get s v)=(Some nat x).
Intros. Apply lookup_find_store. Apply H.
Save.
Hints Resolve instore_get.

Lemma fact_correct_3 : (triple mt nat blocks [z;gs;s](Instore s v#0 z) main [z;gs;n]n=(factSpec z)).
Unfold main.
EApply Hassign.
EApply Hgoto with P:=[z:nat;gs:globalstate;s:store](Instore s v#0 z)/\(Instore s v#1 (1)). FindInBBTable.
EApply Hconsequence_pre. 
EApply Hrec with R:=[s,s':globalstate*store](lt_option (get (Snd s) v#0) (get (Snd s') v#0))
                 P:=[z:nat;gs:globalstate;s:store](EX x | (EX y | (factSpec z)=(mult (factSpec x) y)/\(Instore s v#0 x)/\(Instore s v#1 y))).
Apply wf_r_3. Intros.
EApply Hif2 with Q:=[z:nat;gs:globalstate;s:store;n:nat](EX x | (EX y | (Instore s v#0 x)/\(Instore s v#1 y)/\n=(semBinOp synEq x (0))/\(factSpec z)=(mult (factSpec x) y)))/\s=s'.
FindInBBTable. FindInBBTable.
EApply Hconsequence_pre. EApply Hreturn.
Intros. Simpl. OpenRecord H0. Unfold get. Rewrite (lookup_find_store ??? H1). Simpl. 
Assert x=(0). Auto. Rewrite H6. Rewrite H0. Simpl. Rewrite <- plus_n_O. Reflexivity. 

EApply Hassign. EApply Hassign.
EApply Hgoto with P:=[z:nat;gs:globalstate;s:store](EX x | (EX y | (factSpec z)=(mult (factSpec x) y)/\(Instore s v#0 x)/\(Instore s v#1 y)))/\(lt_option (get s v#0) (get s' v#0)).
FindInBBTable.
Apply H.

EApply Hbinop.
EApply Hexpconsequence_pre. EApply Hbinop. 
Intros. OpenRecord H0. Assert ~x=(0). Auto.
Exists x0. Exists x. Split. Exists x. Exists (1). SplitMany. Exists (minus x (1)). Exists (mult x0 x). SplitMany. 
Elim (O_or_S x); Intros. OpenRecord a. Rewrite H6. Rewrite <- p. Simpl. Rewrite <- minus_n_O. Ring. Simpl. Ring.
                         Absurd x=(0); Auto.
FindInStore. FindInStore.
Rewrite <- H2. Unfold get. Rewrite (lookup_find_store ??? H3). Simpl. Omega.
Simpl. Auto. Reflexivity. Simpl. Auto.

EApply Hexpconsequence_pre. EApply Hbinop.
Intros. OpenRecord H0.
Exists x. Exists (0). SplitMany. Exists x. Exists x0. SplitMany.
Assumption. Assumption. Reflexivity. Assumption. Assumption. Simpl.
Elim (sumbool_of_bool (beq_nat x (0))); Intros. Rewrite a. Tauto. Rewrite b. Tauto.
Simpl. Auto. Reflexivity.

Intros. OpenRecord H. Exists z. Exists (1). SplitMany. Auto with arith. Assumption. Assumption.

EApply Hexpconsequence_pre. EApply Hconst. Intros. Split; FindInStore. 
Save.
*)
(*
Definition factorial_invariant : nat -> store -> Prop :=
 [n:nat;s:store]
 (EX x | (EX y | (Instore s v#0 x)/\(Instore s v#1 y)/\(factSpec n)=(mult (factSpec x) y))).

Lemma fact_correct :
 (n:nat;s:store)(Instore s v#0 n)->(evalMethod mt (blocks,main) gs s (resultis [m:nat]m=(factSpec n))).
Intros. Unfold main. evalAssign '(1). evalGoto.
LetTac I:=(factorial_invariant n). LetTac A:=(resultis [m:nat]m=(factSpec n)). LetTac s':=(update s v#1 (1)).
Assert have_v0 : (Instore s' v#0 n). Unfold s'. FindInStore.
Assert inv : (I s'). Exists n. Exists (1). SplitMany. FindInStore. Unfold s'. FindInStore. Auto with arith.
Generalize Dependent s'. Generalize n gs. Induction n0; Intros; OpenRecord inv.

(* n = 0 *)
evalIf1. evalBinop '(0) '(1). 
evalReturn x0. Unfold A. Unfold resultis. Rewrite H3. Rewrite (storeLookupDet ???? H0 have_v0). Auto with arith.

(* n > 0 *)
evalIf0. evalBinop '(S n1) '(1). 
evalAssign '(mult x0 (S n1)). evalBinop 'x0 '(S n1). 
evalAssign 'n1. evalBinop '(S n1) '(1). 
evalGoto.
Apply H0.
FindInStore.
Exists n1. Exists (mult x0 (S n1)). SplitMany. FindInStore. FindInStore.
Rewrite H4. Rewrite (storeLookupDet ???? H1 have_v0). Ring. Simpl. Ring.
Save.
*)
(*
Lemma fact_correct2 :
 (n:nat)(evalMethod mt (blocks,main) gs (cons (v#0,n) emptyStore) (resultis [m:nat]m=(factSpec n))).
Intros. Unfold main. evalAssign '(1). evalGoto.
EApply decr_loop with loopvar:=v#0 body_lbl:=bb#1 test_lbl:=bb#0 exit_lbl:=bb#2 inv:=(factorial_invariant n); Intros.

(* Pre-conditions *)
FindInBBTable. FindInBBTable. FindInBBTable. FindInStore.
Exists n. Exists (1). SplitMany. FindInStore. FindInStore. Auto with arith.

(* Loop step *)
OpenRecord H0. evalAssign '(mult x0 x). evalBinop 'x0 'x.
Apply H1.
  FindInStore.
  Exists n0. Exists (mult x0 x). SplitMany.
    FindInStore. FindInStore. Rewrite H5; Rewrite (storeLookupDet ???? H2 H); Ring; Simpl; Ring.

(* Loop exit *)
OpenRecord H0.
evalReturn x0. Rewrite H4. Rewrite (storeLookupDet ???? H1 H). Unfold resultis. Auto with arith. 
Save.
*)
End Factorial_Method.