Require cgAbSyn.
Require cgSyntax.
Require cgEval.
Require Arith.
Require LtFacts.
Require Wf_nat.
Require StoreLemmas.
Require Omega.

Section Remainder_Method.

Hypothesis mt : MethTable.
Hypothesis n,m : nat.
Hypothesis gtm : (gt m O).
Hypothesis s : store.
Hypothesis have_n : (Instore s v#0 n).
Hypothesis have_m : (Instore s v#1 m).
Hypothesis gs : globalstate.

Definition blocks:=
 (cons (bb#0, [- if v#0 < v#1 then bb#2 else bb#1 -])
 (cons (bb#1, [- v#0 := v#0 - v#1; goto bb#0 -])
 (cons (bb#2, [- return v#0 -])
 emptyBBs))).
Definition main := [- goto bb#0 -].
Definition remainder_method : method := (blocks, main).

Definition remainder := [r:nat](EX q | n=(plus (mult q m) r)/\(gt m r)).

Lemma remainder_correct : (evalMethod mt (blocks, main) gs s (resultis remainder)).
Unfold main. evalGoto.
Refine [r:=n]?.
Assert inv : (EX q | n=(plus (mult q m) r)). Exists O. Trivial.
Assert have_r : (Instore s v#0 r). FindInStore.
Generalize r gs s have_m have_r inv. Clear r gs s have_n have_m have_r inv.
Intro r. Apply (lt_wf_ind r). Intros.
Elim (lt_ge_dec n0 m); Intros; OpenRecord inv.

evalIf1. evalBinop 'n0 'm. evalReturn n0. Exists x. Split. Assumption. Assumption.

evalIf0. evalBinop 'n0 'm. evalAssign '(minus n0 m). evalBinop 'n0 'm. evalGoto.
Apply H with m0:=(minus n0 m). Auto with arith. FindInStore. FindInStore. Exists (S x). Simpl. Omega.
Save.

(*
Definition invariant : store->Prop :=
 [s:store](EX q | (EX r | (Instore s v#0 r)/\n=(plus (mult q m) r))).

Lemma remainder_correct : (evalMethod mt (blocks, main) gs s (resultis remainder)).
Unfold main. evalGoto.
Assert inv : (invariant s). Exists O. Exists n. Split; Trivial.
Generalize gs s have_n have_m inv. Apply (lt_wf_ind n). Intros.
Elim (lt_ge_dec n0 m); Intros; OpenRecord inv0.

evalIf1. evalBinop 'n0 'm. evalReturn n0.
Exists x. Split. Rewrite (storeLookupDet ???? have_n0 H0). Assumption. Assumption.

evalIf0. evalBinop 'n0 'm. evalAssign '(minus n0 m). evalBinop 'n0 'm. evalGoto.
Apply H with m0:=(minus n0 m).
  Auto with arith. FindInStore. FindInStore.
  Exists (S x). Exists (minus n0 m). Split.
  FindInStore. Rewrite (storeLookupDet ???? H0 have_n0) in H2. Simpl. Omega.
Save.
*)

End Remainder_Method.

Section Quotient_Method.

Hypothesis mt : MethTable.

(* TODO *)

End Quotient_Method.