Require cgAbSyn.
Require Arith.

(*************************************************************)
(* Nice grammar for entering programs *)
Grammar cg value : constr :=
  val_num [ nat:number($n) ]         -> [(const $n)]
| val_var [ "v" "#" nat:number($n) ] -> [(var (mkVar $n))]
| val_c   [ "#" "(" constr:constr($c) ")" ]  -> [(const $c)]
| val_v   [ "&" "(" constr:constr($c) ")" ]  -> [(var $c)].

Grammar cg exp : constr :=
  exp_plus  [ value($a) "+" value($b) ] -> [(binop synPlus $a $b)]
| exp_lt    [ value($a) "<" value($b) ] -> [(binop synLt $a $b)]
| exp_eq    [ value($a) "=" value($b) ] -> [(binop synEq $a $b)]
| exp_minus [ value($a) "-" value($b) ] -> [(binop synMinus $a $b)]
| exp_times [ value($a) "*" value($b) ] -> [(binop synTimes $a $b)]
| exp_val   [ value($a) ]               -> [(value $a)]
| exp_c     [ constr:constr($c) ]       -> [$c].

Grammar cg prog : constr :=
  prog_goto   [ "goto" constr:constr($c) ]                     -> [(goto $c)]
| prog_assign [ constr:constr($v) ":=" exp($e) ";" prog($c) ]  -> [(assign $v $e $c)]
| prog_cond   [ "if" exp($c) "then" constr:constr($t) "else" constr:constr($e) ] -> [(cond $c $t $e)]
| prog_return [ "return" value($c) ]                           -> [(return $c)].
(*
  prog_stop   [ "stop" constr:constr($c) ]                     -> [(stop $c)]
| prog_cond   [ "if" exp($c) "then" jump($t) "else" jump($e) ] -> [(cond $c $t $e)]
| prog_assign [ constr:constr($v) ":=" exp($e) ";" prog($c) ]  -> [(assign $v $e $c)]
| prog_goto   [ "goto" constr:constr($c) ]                     -> [(jump (goto $c))]
| prog_ir     [ "ireturn" constr:constr($c) ]                  -> [(jump (ireturn $c))]
| prog_c      [ constr:constr($c) ]                            -> [$c].*)

Grammar constr constr0 :=
  cg_in_com [ "[-" cg:prog($c) "-]" ] -> [$c].

(*************************************************************)
(* pretty printing rules for programs *)
Syntax constr level  0: PsynPlus  [(synPlus)]  -> ["+"] | PsynEq   [(synEq)]     -> ["="]
                      | PsynLt    [(synLt)]    -> ["<"] | PsynMinus [(synMinus)] -> ["-"]
                      | PsynTimes [(synTimes)] -> ["*"].

Syntax constr level  0: PsynValvar    [(var $v)] -> ["&""("$v")"]
                      | PsynValvar'   [(var (mkVar $n))] -> ["v#" $n]
                      | PsynValconst  [(const $n)] -> ["#""("$n")"].

Syntax constr level  0: PsynExpval   [(value $v)] -> [$v]
                      | PsynExpbinop [(binop $op $v1 $v2)] -> [$v1 " " $op " " $v2].

Syntax constr level  0:
  PsynBBassign_inside [ << (PROG <<(assign $v $e $c)>>) >> ]      -> [$v " := " $e "; " (PROG $c)]
| PsynBBcond_inside   [ << (PROG <<(cond $e $j1 $j2)>>) >> ]      -> ["if "$e" then "$j1" else "$j2]
| PsynBBgoto_inside   [ << (PROG <<(goto $j)>>) >> ]              -> ["goto "$j]
| PsynBBret_inside    [ << (PROG <<(return $j)>>) >> ]            -> ["return "$j]
| Psvar_inside          [ << (PROG ($VAR $i)) >> ]                  -> [$i]
| Psconst_inside        [ << (PROG (CONST $c)) >> ]                 -> [(CONST $c)]
| Psmutind_inside       [ << (PROG (MUTIND $i $n)) >> ]             -> [(MUTIND $i $n)]
| Psmutconstruct_inside [ << (PROG (MUTCONSTRUCT $c1 $c2 $c3)) >> ] -> [(MUTCONSTRUCT $c1 $c2 $c3)]
| PsynBBassign        [(assign $v $e $c)] -> ["[- "$v " := " $e "; "(PROG $c)" -]"]
| PsynBBreturn        [(return $n)]       -> ["[- ""return "$n" -]"]
| PsynBBcond          [(cond $e $j1 $j2)] -> ["[- ""if "$e" then "$j1" else "$j2" -]"]
| PsynBBgoto          [(goto $j)]         -> ["[- ""goto "$j" -]"].
