Require Arith.
Require StoreLemmas.
Require cgAbSyn.
Require cgEval.

Definition dec_and_loop := [x:Var;test_lbl:BBname]
                           (assign x (binop synMinus (var x) (const (1)))
                              (goto test_lbl)).

Definition for_test := [lc:Var;body_lbl:BBname;cont_lbl:BBname]
                       (cond (binop synLt (var lc) (const (1)))
                            cont_lbl body_lbl).

Definition storepredicate := store->Prop.

Lemma decr_loop :
 (gs:globalstate;mt:MethTable;res:resultprop;b:BBTable;test_lbl,body_lbl,exit_lbl:BBname
  ;loopvar:Var
  ;body:synStm;exit:synStm
  ;inv:storepredicate)
 (InBBTable b test_lbl (for_test loopvar body_lbl exit_lbl))->
 (InBBTable b body_lbl body)->
 (InBBTable b exit_lbl exit)->
 (n:nat;s:store)
 (Instore s loopvar n)->(inv s)->
 ((n:nat;s:store;gs:globalstate)
   (Instore s loopvar (S n))->(inv s)->
   ((s':store;gs':globalstate)
     (Instore s' loopvar (S n))->(inv (update s' loopvar n))->
     (evalMethod mt (b, dec_and_loop loopvar test_lbl) gs' s' res))->
   (evalMethod mt (b,body) gs s res))
    ->
 ((s:store;gs:globalstate)(Instore s loopvar (0))->(inv s)->(evalMethod mt (b,exit) gs s res))
    ->
 (evalMethod mt (b, for_test loopvar body_lbl exit_lbl) gs s res).
Intros gs mt res b test_lbl body_lbl exit_lbl loopvar body exit inv. 
Intros have_test have_body have_exit n s n_in_s init_inv step_case base_case.
Generalize gs s n_in_s init_inv. Clear gs s n_in_s init_inv.

Induction n; Intros; Unfold for_test.

(* Base case *)
evalIf1' have_exit. evalBinop '(0) '(1). Apply base_case; Assumption.

(* Step case *)
evalIf0' have_body. evalBinop '(S n) '(1). Apply (step_case n s (addtick (addticks (2) gs)) n_in_s init_inv).

Intros. Unfold dec_and_loop.
evalAssign 'n. evalBinop '(S n) '(1). Auto with arith. evalGoto' have_test.
Apply Hrecn. FindInStore. Assumption.
Save.
