Require cgAbSyn.
Require cgSyntax.
Require cgEval.
Require Arith.
Require StoreLemmas.
Require LtFacts.
Require Wf.

(* Some auxillary defns and lemmas *)
Require EqNat.
Require Sumbool.
Require BoolEq.

Definition lift_pred := [A:Set;Q:A->Prop;a:(option A)]Cases a of None => False
                                                               | (Some a) => (Q a)
                                                              end.
Definition defined := [s:store;v:Var](lift_pred nat [_:nat]True (get s v)).
Definition lift : (A,B:Set)(A->A->B)->(option A)->(option A)->(option B)
 := [A;B;f;x;y]Cases x y of None     _        => (None B)
                          | _        None     => (None B)
                          | (Some x) (Some y) => (Some B (f x y))
                         end.
Definition l_semBinop := [op:synBinOp](lift ?? (semBinOp op)).

Lemma elim_option : (A:Set;x:(option A)){x=(None A)}+{EX y | x=(Some A y)}.
Intros. 
Elim x; Intros. 
Right. Exists a. Reflexivity. 
Left. Reflexivity.
Save.

Definition l_eq : (A:Set)(option A)->(option A)->Prop
  := [A;a;b]Cases a b of None _    => False
                       | _    None => False
                       | (Some a) (Some b) => a=b
                      end.

Lemma beq_nat_if_1 : (x,y:nat)(1)=(if (beq_nat x y) then (1) else (0))->x=y.
Intros.
Elim (sumbool_of_bool (beq_nat x y)); Intros.
Apply beq_nat_eq. Symmetry. Assumption.
Rewrite b in H. Discriminate H.
Save.
Hints Resolve beq_nat_if_1.

Lemma beq_nat_if_0 : (x,y:nat)(0)=(if (beq_nat x y) then (1) else (0))->~x=y.
Intros.
Elim (sumbool_of_bool (beq_nat x y)); Intros.
Rewrite a in H. Discriminate H.
Apply beq_false_not_eq with beq:=beq_nat. Apply beq_nat_refl. Symmetry. Assumption.
Save.
Hints Resolve beq_nat_if_0.

Lemma defined_update : (s:store;n:nat;v:Var)(defined (update s v n) v).
Intros. Unfold defined. Unfold update. Unfold update_al. Simpl. Rewrite beq_Var_eq.  Simpl. Trivial. Reflexivity. 
Save.
Hints Resolve defined_update.

Lemma exists_defined : (v:Var;s:store;n:nat)(get s v)=(Some nat n)->(defined s v).
Intros. Unfold defined. Rewrite H. Exact I.
Save.

Lemma defined_exists : (v:Var;s:store)(defined s v)->(EX n | (get s v)=(Some nat n)).
Intros. 
Unfold defined in H.
Elim (elim_option nat (get s v)); Intros.
Rewrite a in H. Contradiction. 
Assumption.
Save.

(* The Hoare Logic *)
Section HoareLogic.

Hypothesis mt : MethTable.

Definition preassertion := [A:Set]A -> globalstate -> store -> Prop.
Definition postassertion := [A:Set]A -> globalstate -> nat -> Prop.
Definition postexpassertion := [A:Set]A -> globalstate -> store -> nat -> Prop.

Definition triple := [A:Set;bt:BBTable;P:(preassertion A);e:synStm;Q:(postassertion A)]
                     (z:A;gs:globalstate;s:store)(P z gs s)->(evalMethod mt (bt, e) gs s (Q z)).

Definition exptriple := [A:Set;P:(preassertion A);e:synExp;Q:(postexpassertion A)]
                        (z:A;gs:globalstate;s:store)(P z gs s)->(evalExpBigPred mt gs s e [gs;n](Q z gs s n)).

Hypothesis A : Set.
Hypothesis bt : BBTable.

Lemma Hgoto : (P:(preassertion A);Q:(postassertion A);lbl:BBname;c:synStm)
              (InBBTable bt lbl c) -> (triple ? bt P c Q) ->
              (triple ? bt ([a;gs;s](P a (addticks (1) gs) s)) (goto lbl) Q).
Unfold triple. Intros. evalGoto' H. Apply H0. Assumption.
Save.

Lemma expstrengthen : (e:synExp;s:store;P,Q:resultprop;gs:globalstate)
  ((x:nat;gs':globalstate)(P gs' x)->(Q gs' x))->(evalExpBigPred mt gs s e P)->(evalExpBigPred mt gs s e Q).
Intros. Induction H0.
EApply evalExpPredFinal. Apply H. Apply H0. 
EApply evalExpPredStep. Apply H0. Apply HrecH0. Apply H.
Save.

Lemma Hexpconsequence :
 (P,P':(preassertion A);Q,Q':(postexpassertion A);e:synExp)
 ((z:A;gs:globalstate;s:store)(P' z gs s)->(P z gs s))->
 ((z:A;gs:globalstate;s:store;n:nat)(Q z gs s n)->(Q' z gs s n))->
 (exptriple ? P e Q) -> (exptriple ? P' e Q').
Unfold exptriple. Intros. 
Apply expstrengthen with P:=[gs0:globalstate; n:nat](Q z gs0 s n). Intros. Apply H0. Assumption.
Apply H1. Apply H. Assumption.
Save.

Lemma Hexpconsequence_post :
 (P:(preassertion A);Q,Q':(postexpassertion A);e:synExp)
 (exptriple ? P e Q) ->
 ((z:A;gs:globalstate;s:store;n:nat)(Q z gs s n)->(Q' z gs s n))->
 (exptriple ? P e Q').
Unfold exptriple. Intros. 
Apply expstrengthen with P:=[gs0:globalstate; n:nat](Q z gs0 s n). Intros. Apply H0. Assumption.
Apply H. Assumption.
Save.

Lemma Hconsequence :
 (P,P':(preassertion A);Q,Q':(postassertion A);stm:synStm)
 (triple ? bt P stm Q) ->
 ((z:A;gs:globalstate;s:store)(P' z gs s)->(P z gs s))->
 ((z:A;gs:globalstate;n:nat)(Q z gs n)->(Q' z gs n))->
 (triple ? bt P' stm Q').
Unfold triple. Intros. 
Apply strengthen with P:=(Q z). Intros. Apply H1. Assumption.
Apply H. Apply H0. Assumption.
Save.

Lemma Hconsequence_post :
 (P:(preassertion A);Q,Q':(postassertion A);stm:synStm)
 (triple ? bt P stm Q) ->
 ((z:A;gs:globalstate;n:nat)(Q z gs n)->(Q' z gs n))->
 (triple ? bt P stm Q').
Unfold triple. Intros. 
Apply strengthen with P:=(Q z). Intros. Apply H0. Assumption.
Apply H. Assumption.
Save.

Lemma Hconsequence_pre :
 (P,P':(preassertion A);Q:(postassertion A);stm:synStm)
 (triple ? bt P stm Q) ->
 ((z:A;gs:globalstate;s:store)(P' z gs s)->(P z gs s))->
 (triple ? bt P' stm Q).
Unfold triple. Intros. 
Apply H. Apply H0. Assumption.
Save.

Lemma evalStepsAssign :
  (pred,pred':resultprop;s:store;blocks:BBTable;e:synExp;x:Var;cont:synStm;gs:globalstate)
  (evalExpBigPred mt gs s e pred')->
  ((gs:globalstate;n:nat)(pred' gs n)->(evalMethod mt (blocks, assign x (value (const n)) cont) gs s pred))->
  (evalMethod mt (blocks, assign x e cont) gs s pred).
Intros.
Induction H.
Apply H0. Apply H.
EApply evalStep. Apply evalAssign'. Apply H.
Apply HrecH. Apply H0.
Save.

Lemma Hassign : (P,R:(preassertion A);Q:(postassertion A);stm:synStm;e:synExp;v:Var)
                (triple ? bt R stm Q)->
                (exptriple ? P e [z;gs;s;n](R z (addticks (1) gs) (update s v n)))->
                (triple ? bt P (assign v e stm) Q).
Unfold triple. Unfold exptriple. Intros. 
Apply evalStepsAssign with pred':=[gs0:globalstate; n:nat](R z (addticks (1) gs0) (update s v n)).
Apply H0. Assumption. 
Intros. EApply evalStep. Apply evalAssign. Apply H. Apply H2.
Save.

Lemma Hexpconsequence_pre :
 (P,P':(preassertion A);Q:(postexpassertion A);e:synExp)
 (exptriple ? P e Q) ->
 ((z:A;gs:globalstate;s:store)(P' z gs s)->(P z gs s))->
 (exptriple ? P' e Q).
Unfold exptriple. Auto. 
Save.

Lemma Hbinop : (Q:(postexpassertion A);op:synBinOp;v1,v2:synVal)
 (exptriple ? [z;gs;s](lift_pred nat (Q z (addticks (2) gs) s) (l_semBinop op (evalVal s v1) (evalVal s v2)))
   (binop op v1 v2) Q).
Unfold exptriple. Intros. 
Elim (elim_option nat (evalVal s v1)); Intro.
Rewrite a in H. Simpl in H. Contradiction.
Elim (elim_option nat (evalVal s v2)); Intro.
OpenRecord b. Rewrite a in H. Rewrite H0 in H. Simpl in H. Contradiction.
OpenRecord b. OpenRecord b0. Rewrite H0 in H. Rewrite H1 in H. Simpl in H. 
EApply evalExpPredStep. Apply evalBinop. 
Apply H0. Apply H1.
Apply evalExpPredFinal. Apply H.
Save.

Lemma Hvar : (Q:(postexpassertion A);v:Var)
             (exptriple ? [z;gs;s](lift_pred ? (Q z (addticks (1) gs) s) (get s v)) (value (var v)) Q).
Unfold exptriple. Intros.
Elim (elim_option ? (get s v)); Intro. Rewrite a in H. Contradiction. 
OpenRecord b. Rewrite H0 in H. Simpl in H. 
EApply evalExpPredStep. Apply evalVar. Apply (find_lookup_store ??? H0). 
Apply evalExpPredFinal. Apply H.
Save.

Lemma Hconst : (Q:(postexpassertion A);n:nat)(exptriple A [z;gs;s](Q z gs s n) (value (const n)) Q).
Unfold exptriple. Intros. Apply evalExpPredFinal. Assumption.
Save.

Lemma Hreturn : (v:synVal;Q:(postassertion A))(triple A bt [z;gs;s](lift_pred ? (Q z gs) (evalVal s v)) (return v) Q).
Unfold triple. Intros. 
Elim (elim_option ? (evalVal s v)); Intro.
Rewrite a in H. Contradiction. 
OpenRecord b. Rewrite H0 in H. Simpl in H. 
EApply evalFinal.  Apply H0. Apply H. 
Save.

Lemma evalInvokeMethod : (m:Mname;s,s':store;pred:resultprop;gs:globalstate;meth:method;args:(list synVal))
 (InMethTable mt m meth)->
 (mkStore s (0) args)=(Some store s')->(evalMethod mt meth (addticks (1) gs) s' pred)->
 (evalExpBigPred mt gs s (invoke m args) pred).
Intros.
EApply evalExpPredStep. Apply evalInvoke with meth:=meth. Apply H. Apply H0.
Clear H H0. Induction H1. Simpl.
EApply evalExpPredStep. Apply evalExecuteFinal. Apply H. Apply evalExpPredFinal. Apply H0.
EApply evalExpPredStep. Apply evalExecuteStep. Apply H. Apply HrecH1. 
Save.

Lemma Hinvoke : (Q:(postassertion A);mname:Mname;args:(list synVal);P:(preassertion A);bt':BBTable;main:synStm)
                (InMethTable mt mname (bt',main))->(triple ? bt' P main Q)->
                (exptriple ? [z;gs;s](EX s' | (mkStore s (0) args)=(Some store s')/\(P z (addticks (1) gs) s')) (invoke mname args) [z;gs;s;n](Q z gs n)).
Unfold exptriple. Unfold triple. Intros.
OpenRecord H1.
EApply evalInvokeMethod. Apply H. Apply H3.
Apply strengthen with P:=(Q z). Auto. 
Apply H0. Apply H4.
Save.

Lemma evalStepsIf : (pred,pred':resultprop;s:store;blocks:BBTable;e:synExp;lbl1,lbl2:BBname;gs:globalstate)
  (evalExpBigPred mt gs s e pred')->
  ((gs:globalstate;n:nat)(pred' gs n)->(evalMethod mt (blocks, cond (value (const n)) lbl1 lbl2) gs s pred))->
  (evalMethod mt (blocks, cond e lbl1 lbl2) gs s pred).
Intros. Induction H.
Apply H0. Assumption.
EApply evalStep. Apply evalIf. Apply H. Apply HrecH. Apply H0.
Save.

Lemma Hif : (P:(preassertion A);Q:(postexpassertion A);R:(postassertion A);lbl1,lbl2:BBname;stm1,stm2:synStm;e:synExp)
             (InBBTable bt lbl1 stm1)->(InBBTable bt lbl2 stm2)->
             (triple ? bt [z;gs;s](Q z gs s (1)) stm1 R)->
             (triple ? bt [z;gs;s](Q z gs s (0)) stm2 R)->
             (exptriple ? P e [z;gs;s;n](Q z (addticks (1) gs) s n)/\(n=(0)\/n=(1)))->
             (triple ? bt P (cond e lbl1 lbl2) R).
Unfold exptriple. Unfold triple. Intros. 
EApply evalStepsIf. Apply H3 with gs:=gs z:=z. Assumption.
Intros. Simpl in H5.
OpenRecord H5. Induction H7; Rewrite H5; Rewrite H5 in H6.
EApply evalStepIf0. Apply evalExpFinal. Apply H0. Apply H2. Assumption.
EApply evalStepIf1. Apply evalExpFinal. Apply H. Apply H1. Assumption.
Save.

Definition staterel := (globalstate*store)->(globalstate*store)->Prop.

Lemma Hrec : (P:(preassertion A);Q:(postassertion A);stm:synStm;R:staterel)
             (well_founded ? R) ->
             ((gs':globalstate;s':store)(triple ? bt [z;gs;s](P z gs s)/\(R (gs,s) (gs',s')) stm Q)
	      ->(triple ? bt [z;gs;s](P z gs s)/\gs=gs'/\s=s' stm Q))->
	     (triple ? bt P stm Q).
Unfold triple. Intros P Q stm R wf rec z gs s.
LetTac s':=(gs,s). Replace gs with (Fst s');[Idtac|Reflexivity]. Replace s with (Snd s');[Idtac|Reflexivity].
Generalize s' z. Clear s' z. Intro.
Apply well_founded_ind with R:=R A:=(globalstate*store) a:=s'.
Apply wf.
Intros. Apply rec with s':=(Snd x) gs':=(Fst x).
Intros. Apply H with y:=(gs0,s0). Replace x with (Fst x, Snd x). Apply (proj2 ?? H1). Induction x. Reflexivity. 
Apply (proj1 ?? H1).
Split. Assumption. Split; Reflexivity. 
Save.

Lemma Hfalse : (P:(preassertion A);Q:(postassertion A);stm:synStm)
               ((z:A;gs:globalstate;s:store)(P z gs s)->False)->
               (triple ? bt P stm Q).
Unfold triple. Intros. ElimType False. EApply H. Apply H0.
Save.

End HoareLogic.

Lemma test1 : (triple emptyMethT nat emptyBBs [z;gs;s]True [- v#0 := 1; return v#0 -] [z;gs;n]n=(1)).
EApply Hassign. Apply Hreturn.
EApply Hexpconsequence_pre. EApply Hconst. 
Intros. Simpl. Reflexivity. 
Save.

Lemma test2 : (triple emptyMethT nat emptyBBs [z;gs;s]True [- v#0 := 1; v#1 := 1 + v#0; return v#1 -] [z;gs;n]n=(2)).
EApply Hassign. EApply Hassign. EApply Hreturn.
Apply Hbinop. EApply Hexpconsequence_pre. Apply Hconst. 
Intros. Simpl. Reflexivity. 
Save.

Definition test_blocks :=
  (cons (bb#0, [- return 1 -])
  (cons (bb#1, [- return 2 -])
  emptyBBs)).
Definition test_main := [- if v#0 = 1 then bb#0 else bb#1 -].

Lemma test3 : (triple emptyMethT nat test_blocks [z;gs;s](get s v#0)=(Some nat (1)) test_main [z;gs;n]n=(1)).
Unfold test_main.
EApply Hif with Q:=[_:nat;_:globalstate;_:store;n:nat]n=(1). FindInBBTable. FindInBBTable. 
EApply Hconsequence_pre. EApply Hreturn. Simpl. Reflexivity. 
EApply Hfalse. Intros. Discriminate H.
EApply Hexpconsequence_pre. Apply Hbinop.
Intros. Simpl. Rewrite H. Simpl. Tauto. 
Save.

Lemma test4 : (triple emptyMethT nat test_blocks [z;gs;s](get s v#0)=(Some nat (3)) test_main [z;gs;n]n=(2)).
Unfold test_main.
EApply Hif with Q:=[_:nat;_:globalstate;_:store;n]n=(0). FindInBBTable. FindInBBTable.
EApply Hfalse. Intros. Discriminate H.
EApply Hconsequence_pre. EApply Hreturn. Simpl. Reflexivity. 
EApply Hexpconsequence_pre. Apply Hbinop. Intros. Simpl. Rewrite H. Simpl. Tauto.
Save.

Definition counter_blocks :=
  (cons (bb#0, [- if v#0 = 0 then bb#1 else bb#2 -])
  (cons (bb#1, [- return v#0 -])
  (cons (bb#2, [- v#0 := v#0 - 1; goto bb#0 -])
  emptyBBs))).

Require Omega.
Require Wellfounded.
Require Wf_nat.

Definition lt_option : (option nat)->(option nat)->Prop :=
  [n,m]Cases n of None => False
                | (Some x) => Cases m of None => False
                                       | (Some y) => (lt x y)
                                      end
               end.

Lemma wf_r : (well_founded nat lt).
Unfold well_founded. Intros. Induction a; Apply Acc_intro; Intro.
Intros. Inversion H. 
Inversion Hreca.
Elim (eq_nat_dec y a); Intros.
  Rewrite a0. Assumption.
  Elim (le_lt_or_eq ?? H1); Intros.
    Apply H. Auto with arith.
    Inversion H2. ElimType False. Exact (b H4).
Save.

Lemma wf_lt_option : (well_founded (option nat) lt_option).
Unfold well_founded. Intros.
Induction a. Induction a; Apply Acc_intro; Intros.
Induction y; Simpl in H; [ Absurd (lt a O); Auto with arith | Contradiction ]. 
Inversion Hreca.
Induction y; Simpl in H.
Elim (eq_nat_dec a0 a); Intros.
  Rewrite a1. Assumption.
  Elim (le_lt_or_eq ?? H); Intros.
    Apply H0. Simpl. Auto with arith.
    Inversion H2. ElimType False. Exact (b H4).
Contradiction.
Apply Acc_intro. Intros. Induction y; Simpl in H; Contradiction.
Save.

Lemma wf_lt_option_eval : (well_founded ? [s,s':globalstate*store](lt_option (evalVal (Snd s) (var v#0)) (evalVal (Snd s') (var v#0)))).
Apply wf_inverse_image with f:=[s:globalstate*store](evalVal (Snd s) (var v#0)).
Apply wf_lt_option.
Save.

Lemma test5 : (triple emptyMethT nat counter_blocks [z;gs;s](defined s v#0) [- goto bb#0 -] [z;gs;n]n=(0)).
EApply Hgoto with P:=[z:nat;gs:globalstate;s:store](defined s v#0). FindInBBTable.
EApply Hrec with R:=[s,s':globalstate*store](lt_option (get (Snd s) v#0) (get (Snd s') v#0)). Apply wf_lt_option_eval. Intros.
EApply Hif with Q:=[z:nat;gs:globalstate;s:store;n:nat](l_eq ? (Some nat n) (l_semBinop synEq (get s v#0) (Some nat O)))/\
                                                        (get s v#0)=(get s' v#0). FindInBBTable. FindInBBTable.
EApply Hconsequence_pre. EApply Hreturn. 
  Intros. OpenRecord H0. 
  Elim (elim_option ? (get s v#0)); Intro. Rewrite a in H1. Contradiction. OpenRecord b.
  Simpl. Rewrite H0. Rewrite H0 in H1. Simpl. Auto. 
EApply Hassign. 
EApply Hgoto with P:=[z:nat;gs:globalstate;s:store](defined s v#0)/\(lt_option (get s v#0) (get s' v#0)). FindInBBTable. 
Apply H.

EApply Hexpconsequence_pre. EApply Hbinop.
Intros. OpenRecord H0. 
Elim (elim_option ? (get s v#0)); Intros. Rewrite a in H1. Contradiction. OpenRecord b.
Rewrite <- H2. Simpl. Rewrite H0. Simpl. 
Split. Auto. Assert ~x=(0). Rewrite H0 in H1. Auto. Omega.

EApply Hexpconsequence_pre. EApply Hbinop. 
Intros. OpenRecord H0. Assert (EX n | (get s v#0)=(Some nat n)). Apply (defined_exists ?? H1). OpenRecord H0. Simpl. Rewrite H2. Simpl. 
SplitMany. Reflexivity. 
  Rewrite <- H2. Rewrite H4. Reflexivity. 
  Elim (O_or_S x); Intros; [ Left; OpenRecord a; Rewrite <- p; Reflexivity | Right; Rewrite <- b; Reflexivity ].
Save.
