Require StoreLemmas.
Require cgAbSyn.
Require cgEval.
Require Arith.

Section Determinacy.

Hypothesis mt : MethTable.
Hypothesis t : BBTable.

Scheme eval_exp_stm_ind := Induction for evalExp Sort Prop
with eval_stm_exp_ind := Induction for evalStm Sort Prop.

Lemma Mname_eq_dec : (m1,m2:Mname){m1=m2}+{~m1=m2}.
Decide Equality. Apply eq_nat_dec.
Save.

Definition fullstate := ((store * synStm) * globalstate).
Definition MethTLookupDet := (lookupDet Mname method Mname_eq_dec).

Lemma evalStmDet : (s,s0:fullstate)(evalStm mt t s s0)->(s1:fullstate)(evalStm mt t s s1)->s0 = s1.
Intros s s0 H.
Apply eval_stm_exp_ind with e:=H P:=[s;p;p0;e1:(evalExp mt s p p0)](p1:(globalstate*synExp))(evalExp mt s p p1)->p0=p1; Intros.
Inversion H0. Rewrite (storeLookupDet ???? i H5). Reflexivity.
Inversion H0. Rewrite e in H7. Rewrite e0 in H8. Inversion H7. Inversion H8. Reflexivity.
Inversion H0. Rewrite e in H7. Inversion H7. Rewrite (MethTLookupDet ???? i H6). Reflexivity. 
Inversion H0. Rewrite e in H7. Inversion H7. Reflexivity.
Inversion H7. Inversion H1. Rewrite <- H7 in e. Inversion e. 
              Assert ((s'', stm''),gs')=((s''0, stm''0), gs'0). Apply H0. Assumption. Inversion H9. Reflexivity.
Inversion H0. Rewrite (BBTableLookupDet ???? i H6). Reflexivity.
Inversion H0. Rewrite (BBTableLookupDet ???? i H7). Reflexivity. Inversion H8. 
Inversion H0. Rewrite (BBTableLookupDet ???? i H7). Reflexivity. Inversion H8.
Inversion H1. Rewrite <- H5 in e0. Inversion e0. Rewrite <- H5 in e0. Inversion e0.
              Assert (gs',e')=(gs'0,e'0). Apply H0. Assumption. Inversion H10. Reflexivity.
Inversion H1. Assert (gs',e')=(gs'0,e'0). Apply H0. Assumption. Inversion H10. Reflexivity. 
              Rewrite <- H6 in e0. Inversion e0.
Inversion H0. Inversion H8. Reflexivity. 
Save.

End Determinacy.

(*************************************************************)
(* Proof of determinacy of the evaluation                    *)
(*Lemma evalValDet : (s:store;v:synVal;r1,r2:nat)
                   (evalVal s v r1) -> (evalVal s v r2) -> r1 = r2.
Intros.
Induction H.
Inversion H0.
Trivial.
Inversion H0.
Apply (storeLookupDet s x0 c r2); Rewrite H1; Assumption.
Save.*)

(*
Lemma evalExpDet : (s:store;e:synExp;r1,r2:nat)
                   (evalExp s e r1) -> (evalExp s e r2) -> r1 = r2.
Intros.
Induction H; Inversion H0.
Rewrite H3 in H. Inversion H. Reflexivity.
Assert n1=n0.
Rewrite H7 in H. Inversion H. Reflexivity.
Assert n2=n3.
Rewrite H8 in H1. Inversion H1. Reflexivity. 
Rewrite H9. Rewrite H10. Reflexivity.
Save.

Lemma evalStmDet : (t:BBTable;s,s',s'':(store * synStm))
                   (evalStm t s s') -> (evalStm t s s'') -> s' = s''.
Intros.
Induction H; Inversion H0.

(* goto *)
Rewrite (BBTableLookupDet bt lbl target target0 H H5). Reflexivity.

(* If0 - If0 *)
Rewrite (BBTableLookupDet bt lbl2 target target0 H1 H9). Reflexivity.

(* If0 - If1 *)
Absurd O=(S O).
Discriminate. Apply (evalExpDet s e O (S O) H H8).

(* If1 - If0 *)
Absurd (S O)=O.
Discriminate. Apply (evalExpDet s e (S O) O H H8).

(* If1 - If1 *)
Rewrite (BBTableLookupDet bt lbl1 target target0 H1 H9). Reflexivity.

(* assign *)
Rewrite (evalExpDet s e n n0 H H7). Reflexivity.
Save.
*)
(*
Lemma determinism : (m:method;s:store;r1,r2:nat)
                    (evalMethod m s r1) -> (evalMethod m s r2) ->
                    r1 = r2.
Intros.
Induction H.
Inversion H0.
Reflexivity.

Inversion H2.

Apply HrecH.
Inversion H0.
Rewrite <- H4 in H.
Inversion H.
Assert (s',bl')=(s'0,bl'0).
Apply (evalBBDet bt (s,bl) ?? H H4).
Inversion H8.
Assumption.
Save.
*)
