Require PolyList.
Require StoreLemmas.

(*************************************************************)
(* Definition of the abstract syntax *)
Inductive synVal : Set :=
   var : Var->synVal
 | const : nat->synVal.

Inductive synBinOp : Set :=
   synEq : synBinOp | synLt : synBinOp
 | synPlus : synBinOp | synMinus : synBinOp
 | synTimes : synBinOp.

Inductive synExp : Set :=
   value   : synVal->synExp
 | binop   : synBinOp->synVal->synVal->synExp
 | invoke  : Mname->(list synVal)->synExp
 | execute : (assoclist BBname synStm)->store->synStm->synExp

with synStm : Set :=
   goto   : BBname -> synStm
 | assign : Var -> synExp -> synStm -> synStm
 | cond   : synExp -> BBname -> BBname -> synStm
 | return : synVal -> synStm.

(*************************************************************)
(*Definition of the basic block tables *)
Definition BBTable := (assoclist BBname synStm).
Definition InBBTable := (lookup BBname synStm).
Definition emptyBBs := (empty BBname synStm).

Definition method := BBTable * synStm.

Tactic Definition FindInBBTable :=
  Assumption
  Orelse
  Apply (find_lookup BBname synStm BBname_eqdec beq_BBname beq_BBname_eq beq_BBname_neq); Simpl; Reflexivity.

Definition BBTableLookupDet := (lookupDet BBname synStm BBname_eqdec).

(* Definition of (static) method tables *)
Definition MethTable := (assoclist Mname method).
Definition InMethTable := (lookup Mname method).
Definition emptyMethT := (empty Mname method).
