Require Export AssocList.
Require EqNat.
Require Bool.
Require Arith.

(* Definition of the set of variable names *)
Inductive Var : Set := mkVar : nat->Var.
Grammar constr constr1 :=
  grailVar [ "v" "#" nat:number($a) ] -> [(mkVar $a)].
Syntax constr level 0: Pvar [(mkVar $n)] -> ["v" "#" $n].

(* Definition of the set of basic block names *)
Inductive BBname : Set := mkBBname : nat->BBname.
Grammar constr constr1 :=
  grailBBname [ "bb" "#" nat:number($a) ] -> [(mkBBname $a)].
Syntax constr level 0: Pbbname [(mkBBname $n)] -> ["bb" "#" $n].

(* Set of static method names *)
Inductive Mname : Set := mkMname : nat->Mname.
Grammar constr constr1 :=
  grailMname [ "m" "#" nat:number($a) ] -> [(mkMname $a)].
Syntax constr level 0: PMname [(mkMname $n)] -> ["m" "#" $n].

Definition Var_eqdec : (v1,v2:Var){v1=v2}+{~v1=v2}.
Decide Equality. Apply eq_nat_dec.
Defined.

Definition BBname_eqdec : (v1,v2:BBname){v1=v2}+{~v1=v2}.
Decide Equality. Apply eq_nat_dec.
Defined.

Definition beq_Var : Var->Var->bool :=
  [x1,x2]Cases x1 x2 of (mkVar n1) (mkVar n2) => (beq_nat n1 n2) end.

Definition beq_BBname : BBname->BBname->bool :=
  [x1,x2]Cases x1 x2 of (mkBBname n1) (mkBBname n2) => (beq_nat n1 n2) end.

Lemma beq_Var_eq : (x1,x2:Var)x1=x2->(beq_Var x1 x2)=true.
Intros. Rewrite H. Induction x2; Simpl. Symmetry. Apply beq_nat_refl.
Save.

Lemma beq_Var_neq : (x1,x2:Var)~x1=x2->(beq_Var x1 x2)=false.
Intros.
Compare (beq_Var x1 x2) true; Intros.
Absurd x1=x2. Assumption.
Induction x1; Induction x2.
Simpl in e. Apply (f_equal nat). Apply beq_nat_eq. Auto.
Apply (not_true_is_false ? n).
Save.

Lemma beq_BBname_eq : (x1,x2:BBname)x1=x2->(beq_BBname x1 x2)=true.
Intros. Rewrite H. Induction x2; Simpl. Symmetry. Apply beq_nat_refl.
Save.

Lemma beq_BBname_neq : (x1,x2:BBname)~x1=x2->(beq_BBname x1 x2)=false.
Intros.
Compare (beq_BBname x1 x2) true; Intros.
Absurd x1=x2. Assumption.
Induction x1; Induction x2.
Simpl in e. Apply (f_equal nat). Apply beq_nat_eq. Auto.
Apply (not_true_is_false ? n).
Save.

(*************************************************************)
Definition up_ins :=
 (update_lookup Var nat (*Var_eqdec beq_Var beq_Var_eq beq_Var_neq*)).

Definition instore_update :=
 (lookup_update Var nat (*Var_eqdec beq_Var beq_Var_eq beq_Var_neq*)).

Definition find_lookup_store :=
 (find_lookup Var nat Var_eqdec beq_Var beq_Var_eq beq_Var_neq).

Definition lookup_find_store :=
 (lookup_find Var nat Var_eqdec beq_Var beq_Var_eq beq_Var_neq).

Recursive Tactic Definition FindInStore :=
  Assumption
  Orelse
  (Apply find_lookup_store; Simpl; Reflexivity)
  Orelse
  Apply instore_update
  Orelse
  (Apply up_ins; [ Discriminate | FindInStore ]).

Definition store := (assoclist Var nat).
Definition Instore := (lookup Var nat).
Definition emptyStore := (empty Var nat).
Definition update:=(update_al Var nat (*beq_Var*)).
Definition storeLookupDet := (lookupDet Var nat Var_eqdec).
