Require Arith.
Require Wf_nat.

Fixpoint blt_nat [n:nat] : nat->bool :=
  [m:nat]Cases n m of O     O     => false
                    | (S n) O     => false
                    | O     (S m) => true
                    | (S n) (S m) => (blt_nat n m)
                   end.

Lemma blt_nat_lt : (n,m:nat)(lt n m)->(blt_nat n m)=true.
Intros n. 
Induction n; Intros.
Induction m; [ Absurd (lt (0) (0)); Auto with arith | Auto ].
Elim (O_or_S m); Intros.
  Inversion_clear a. Rewrite <- H0. Simpl. Apply Hrecn.
    Rewrite <- H0 in H. Auto with arith.
  Rewrite <- b in H. Absurd (lt (S n) (0)); Auto with arith.
Save.

Lemma blt_nat_ge : (n,m:nat)(ge n m)->(blt_nat n m)=false.
Intros n.
Induction n; Intros.
Induction m; [ Auto | Absurd (ge (0) (S m)); Unfold ge; Auto with arith ].
Elim (O_or_S m); Intros.
  Inversion_clear a. Rewrite <- H0. Simpl. Apply Hrecn.
    Rewrite <- H0 in H. Auto with arith.
  Rewrite <- b. Simpl. Reflexivity.
Save.

Lemma lt_ge_dec : (n,m:nat){(lt n m)}+{(ge n m)}.
Intros.
Elim (le_gt_dec m n); Intros.
Right. Auto with arith.
Left. Auto with arith.
Save.

Lemma lt_blt_nat : (n,m:nat)(blt_nat n m)=true->(lt n m).
Intros.
Elim (lt_ge_dec n m); Intros.
Assumption.
Rewrite blt_nat_ge in H. Discriminate H. Assumption.
Save.

Lemma inductionP_ltof1 : (A:Set; f:(A->nat); P:(A->Prop))
        ((x:A)((y:A)(ltof A f y x)->(P y))->(P x))->(a:A)(P a).
Intros A f P F; Cut (n:nat)(a:A)(lt (f a) n)->(P a).
Intros H a; Apply (H (S (f a))); Auto with arith.
NewInduction n.
Intros; Absurd (lt (f a) O); Auto with arith.
Intros a ltSma.
Apply F.
Unfold ltof; Intros b ltfafb.
Apply IHn.
Apply lt_le_trans with (f a); Auto with arith.
Save.

Lemma sqr_O : (x:nat)(mult x x)=O->x=O.
Intros.
Induction x; Simpl in H.
Assumption.
Discriminate H.
Save.

Lemma le_sqr : (n,x:nat)(le (mult x x) n)->(le x n).
Intros.
Induction n.
Rewrite (sqr_O x). Constructor 1.
Rewrite (le_n_O_eq (mult x x)); [ Reflexivity | Assumption ].
Inversion H.
Elim (mult_O_le) with m:=x n:=x; Intros.
Rewrite H0 in H1. Simpl in H1. Discriminate H1.
Assumption.
Apply (le_S ?? (Hrecn H1)).
Save.

