Section AssocList.

Require Bool.

Hypothesis A : Set.
Hypothesis B : Set.
Hypothesis A_deceq:(x,y:A){x=y}+{~x=y}.

Require Export PolyList.

Definition assoclist := (list (A * B)).
Definition empty := (nil (A * B)).

Fixpoint lookup [l:assoclist] : A -> B -> Prop :=
  [v,n]Cases l of nil => False
                | (cons (v',n') tl) =>
                  ((v=v' /\ n=n') \/ (~v=v' /\ (lookup tl v n)))
                end.

(*************************************************************)
(* Proof that lookup in an association list is deterministic *)
Lemma lookupDet : (s:assoclist;v:A;r1,r2:B)
                  (lookup s v r1) -> (lookup s v r2) -> r1 = r2.
Intros.
Induction s.

(* Base case *)
Simpl in H.
Contradiction.

(* step case *)
Induction a.
Elim (A_deceq a v); Intros; Inversion H.
Inversion H0.
Transitivity b.
Exact (proj2 ? ? H1).
Symmetry. Exact (proj2 ? ? H2).
Absurd v=a.
Exact (proj1 ? ? H2).
Symmetry. Assumption.
Absurd v=a.
Exact (proj1 ? ? H1).
Symmetry. Assumption.

Absurd a=v.
Assumption.
Symmetry. Exact (proj1 ? ? H1).

Inversion H0.
Absurd a=v.
Assumption.
Symmetry. Exact (proj1 ? ? H2).

Fold lookup in H1.
Fold lookup in H2.
Exact (Hrecs (proj2 ? ? H1) (proj2 ? ? H2)).
Save.
(*
Definition beq_A : A->A->bool :=
 [x,y]Cases (A_deceq x y) of (left _) => true
                           | (right _) => false
                          end.

Require Eqdep_dec.

Lemma blah :(x:A)(p:x=x)(p==(refl_equal A x)).
Intros.
Apply K_dec_set with P:=[p:x=x]p==(refl_equal A x).
Assumption.
Reflexivity.
Save.

Lemma bloo : (x:A)(A_deceq x x)=(left ?? (refl_equal A x)).
Intros.
Elim (A_deceq x x).
Intros.
Rewrite (blah x a).
Reflexivity.
Intros.
Absurd x=x; Auto.
Save.

Lemma beq_A_refl : (x:A)(beq_A x x)=true.
Intros.
Compute.
Rewrite bloo.
Reflexivity.
Save.

Lemma beq_A_eq : (x1,x2:A)x1=x2->(beq_A x1 x2)=true.
Intros.
Rewrite H.
Apply beq_A_refl.
Save.

*)

Hypothesis beq_A : A->A->bool.
Hypothesis beq_A_eq  : (x1,x2:A)x1=x2->(beq_A x1 x2)=true.
Hypothesis beq_A_neq : (x1,x2:A)~x1=x2->(beq_A x1 x2)=false.

Local beq_A_refl : (x:A)(beq_A x x)=true.
Intros. Apply beq_A_eq. Reflexivity.
Save.

Local beq_A_sym : (x1,x2:A)(beq_A x1 x2)=(beq_A x2 x1).
Intros.
Elim (A_deceq x1 x2); Intros.
Rewrite a. Reflexivity.
Rewrite (beq_A_neq x1 x2 b).
Rewrite (beq_A_neq x2 x1 (sym_not_eq ??? b)).
Reflexivity.
Save.

Definition update_al := [s:assoclist;k:A;d:B](cons (k,d) s).
(*
Fixpoint update_al [s:assoclist] : A -> B -> assoclist :=
 [a;b]Cases s of nil => (cons (a,b) empty)
               | (cons (a',b') tl) =>
                         if (beq_A a a') then (cons (a',b) tl)
                                         else (cons (a',b') (update_al tl a b))
              end.

Lemma update_comm_cons :
 (s:assoclist;x1,x2:A;n1,n2:B)
 (~x1=x2)->
 (update_al (cons (x1,n1) s) x2 n2)=(cons (x1,n1) (update_al s x2 n2)).
Intros.
Simpl.
Rewrite beq_A_sym.
Rewrite beq_A_neq; Trivial.
Save.
*)
Lemma update_lookup : (s:assoclist;x1,x2:A;n1,n2:B)
 (~x1=x2)->(lookup s x1 n1)->(lookup (update_al s x2 n2) x1 n1).
(*
Intros.
Induction s.
Absurd (lookup empty x1 n1); Compute; Auto.

Induction a.
Elim (A_deceq a x2); Intros.
Rewrite a0.
Simpl.
Rewrite beq_A_refl.
Induction H0.
Absurd x1=x2. Assumption. Rewrite <- a0. Tauto.
Unfold lookup. Right. Split. Assumption. Exact (proj2 ?? H0).

Rewrite update_comm_cons.
Elim (A_deceq x1 a); Intros.
Rewrite a0. Rewrite a0 in H0.
Unfold lookup in H0. Simpl. Tauto.
Induction H0.
Absurd x1=a; Tauto.
Simpl. Right. Split. Assumption. Apply (Hrecs (proj2 ?? H0)).
Assumption.*)
Intros. Simpl. 
Right. Tauto. 
Save.

Lemma lookup_update : (s:assoclist;x:A;n:B)(lookup (update_al s x n) x n).
(*
Intros.
Induction s.
Simpl. Auto.
Induction a.
Elim (A_deceq x a); Intros; Simpl.
Rewrite a0. Rewrite beq_A_refl.
Compute. Auto.
Rewrite (beq_A_neq x a b0).
Compute. Right. Split. Exact b0.
Assumption.
*)
Intros. Simpl. Left. Split; Reflexivity. 
Save.

Fixpoint find [s:assoclist] : A -> (option B) :=
  [x]Cases s of nil             => (None B)
              | (cons (a,b) xs) => if (beq_A x a) then (Some B b)
                                                  else (find xs x)
             end.

Lemma find_lookup : (s:assoclist;x:A;n:B)
                         (find s x)=(Some B n)->(lookup s x n).
Intros.
Induction s.
Simpl in H. Discriminate H.
Induction a.
Elim (A_deceq x a); Intros.
Assert n=b. Rewrite a0 in H. Simpl in H. Rewrite beq_A_refl in H.
            Inversion H. Reflexivity.
Rewrite a0. Rewrite H0. Simpl. Auto.

Simpl.
Right. Split. Assumption.
Apply Hrecs. Simpl in H. Rewrite beq_A_neq in H. Assumption.
Assumption.
Save.

Lemma lookup_find : (s:assoclist;x:A;n:B)
                    (lookup s x n)->(find s x)=(Some B n).
Intros.
Induction s.
Induction H.
Induction a.
Elim (A_deceq x a); Intros.
Assert n=b. Rewrite a0 in H. Simpl in H. Tauto.
Rewrite a0. Rewrite H0.
Simpl. Rewrite beq_A_refl. Reflexivity.

Simpl. Rewrite beq_A_neq.
Apply Hrecs. 
Simpl in H. Induction H. Absurd x=a; Tauto. Tauto.
Assumption.
Save.

(*
Lemma update_al_comm :
 (s:assoclist;x1,x2,x3:A;n1,n2,n3:B)
  ~x1=x2->
 (lookup (update_al (update_al s x1 n1) x2 n2) x3 n3)->
 (lookup (update_al (update_al s x2 n2) x1 n1) x3 n3).
Intros.
Induction s.
Simpl. Rewrite (beq_A_neq ? ? H).
Simpl in H0. Rewrite beq_A_sym in H0. Rewrite (beq_A_neq ? ? H) in H0. 
Induction H0; Unfold lookup.
Right. Split. Rewrite (proj1 ?? H0). Assumption. Left. Assumption.
Left. Induction H0. Induction H1. Assumption. Induction H1. Induction H2.

Induction a.
Elim (A_deceq x1 a); Elim (A_deceq a x2); Intros.
Absurd x1=x2. Assumption. Transitivity a; Auto.

Rewrite a0. Rewrite update_comm_cons. Simpl. Rewrite beq_A_refl.
Rewrite a0 in H0. Simpl in H0. Rewrite beq_A_refl in H0. Rewrite update_comm_cons in H0.
Assumption. Assumption. Assumption.

Rewrite a0. Simpl. Rewrite beq_A_refl. 
Rewrite a0 in H0. Simpl in H0. Rewrite (beq_A_neq ?? H) in H0. Simpl in H0.
Rewrite beq_A_refl in H0. Rewrite <- update_comm_cons in H0.
Assumption. Apply sym_not_eq. Assumption.

Rewrite update_comm_cons. Rewrite update_comm_cons.
Rewrite update_comm_cons in H0. Rewrite update_comm_cons in H0.
Induction H0.
Simpl. Left. Exact H0.
Induction H0.
Simpl. Right. Split. Assumption.
Apply Hrecs. Assumption.
Assumption.
Apply (sym_not_eq ? ? ? b1).
Apply (sym_not_eq ? ? ? b1).
Assumption.
Save.
*)

End AssocList.

