(*
  Machine generated. Edit at your own risk 
  Reproduce with the following
 --lang=sml
 *)
(* 
 *
 * COPYRIGHT (c) 1997, 1998 by Princeton University. 
 * See COPYRIGHT file for details
 *
 * Author: Daniel C. Wang
 *
 *)

structure PklWord8 =
    struct
	structure IO = BinIO
	structure W8 = Word8
	structure W8V = Word8Vector
	structure Word = Word8

	type T = Word.word

	val c_0 = Word.fromInt 0
	val c_1 = Word.fromInt 1
	val c_128 = Word.fromInt 128
	val c_63 = Word.fromInt 63
	    
	val w8tow = Word.fromLargeWord o W8.toLargeWord
	val wtow8 = W8.fromLargeWord o Word.toLargeWord
	    
	fun write x s =
	    let
		fun set_continue x = W8.orb(x,0wx80)
		fun loop x =
		    if Word.>(x,c_63) then
			(IO.output1(s,set_continue(wtow8 x));
			loop(Word.>>(x,0w7)))
		    else IO.output1(s,wtow8 x)
	    in
		loop x
	    end

	fun read s =
	    let
		fun is_continue_bit_set (x) =
		    not(W8.andb(x,0wx80) = 0wx0)
		fun is_neg_bit_set (x) =  not(W8.andb(x,0wx40) = 0wx0)
		fun nibble x = (w8tow(W8.andb(x,0wx7f)))
		fun mask_neg (x) =  (W8.andb(x,0wx3f))
		fun loop(x,acc,shift) =
		    if(is_continue_bit_set x) then
			loop(Option.valOf (IO.input1 s),
			     Word.orb(acc,Word.<<(nibble x,shift)),
			     shift+0w7)
		    else
			let
			    val v = w8tow (mask_neg x)
			    val acc =
				Word.orb(acc,Word.<<(v,shift))
			in
			    if (is_neg_bit_set x) then
				(TextIO.output(TextIO.stdErr,
				"Ignoring sign bit on unsigned read\n");
				 acc)
			    else
				acc
			end			    
		val ret = loop(Option.valOf(IO.input1 s),c_0,0w0)
	    in
		ret
	    end	
    end


