(* Careful: this file is shared by Camelot and gdf via symbolic links.
   The master copy is progs/Grail/gdf/src/ToyGrailAbsyn.sml *)
open GrailAbsyn;
(* open ToyClassTable; *)
open GrailUtils;

exception gdfError of string;
exception toyError of string;


(* # will be replaced with class name of the .gr file
   & will be replaced with the short type of the param types, II for int -> int -> ? *)

val global_mnames =     ["#_dia_0'make","#_dia_0'fill","#_dia_0'alloc","#_dia_0'free"]
val global_cnames =     ["#_dia_0"]
val global_ifldnames =  ["f0","DOLLAR"]
val global_rfldnames =  ["f1","f2","f3","f4"]

(*
val global_translations = [("#_dia_0","DIAM"),
                           ("#_dia_0'_", "DOLLAR"),
                           ("#_dia_0'make","Make&"),
			   ("#_dia_0'fill","Fill&"),
			   ("#_dia_0'alloc","Alloc"),
			   ("#_dia_0'free","Free"),
			   ("#_dia_0'f0","F0"),
			   ("#_dia_0'f1","F1"),
			   ("#_dia_0'f2","F2"),
			   ("#_dia_0'f3","F3"),
			   ("#_dia_0'f4","F4")]
val global_translations_10 = [("#_dia_0","DIAM"),
                           ("#_dia_0'_", "DOLLAR"),
                           ("#_dia_0'make","Make&"),
			   ("#_dia_0'fill","Fill&"),
			   ("#_dia_0'alloc","Alloc"),
			   ("#_dia_0'free","Free"),
			   ("#_dia_0'f0","F1"),
			   ("#_dia_0'f1","F0"),
			   ("#_dia_0'f2","F2"),
			   ("#_dia_0'f3","F3"),
			   ("#_dia_0'f4","F4")]
val global_translations_20 = [("#_dia_0","DIAM"),
                           ("#_dia_0'_", "DOLLAR"),
                           ("#_dia_0'make","Make&"),
			   ("#_dia_0'fill","Fill&"),
			   ("#_dia_0'alloc","Alloc"),
			   ("#_dia_0'free","Free"),
			   ("#_dia_0'V0","F0"),
			   ("#_dia_0'R1","F1"),
			   ("#_dia_0'f2","F2"),
			   ("#_dia_0'f3","F3"),
			   ("#_dia_0'f4","F4")]
val global_translations_30 = [("#_dia_0","DIAM"),
                           ("#_dia_0'_", "DOLLAR"),
                           ("#_dia_0'make","Make&"),
			   ("#_dia_0'fill","Fill&"),
			   ("#_dia_0'alloc","Alloc"),
			   ("#_dia_0'free","Free"),
			   ("#_dia_0'V0","V2"),
			   ("#_dia_0'V1","V1"),
			   ("#_dia_0'V2","V0"),
			   ("#_dia_0'R0","R1"),
			   ("#_dia_0'R1","R2"),
			   ("#_dia_0'R2","R3"),
			   ("#_dia_0'R3","R4")]
val global_translations_40 = [("#_dia_0","DIAM"),
                           ("#_dia_0'_", "DOLLAR"),
                           ("#_dia_0'make","Make&"),
			   ("#_dia_0'fill","Fill&"),
			   ("#_dia_0'alloc","Alloc"),
			   ("#_dia_0'free","Free"),
			   ("#_dia_0'V0","V1"),
			   ("#_dia_0'V1","V0"),
			   ("#_dia_0'V2","V0"),
			   ("#_dia_0'R0","R1"),
			   ("#_dia_0'R1","R0"),
			   ("#_dia_0'R2","R2"),
			   ("#_dia_0'R3","R3")]
val global_translations_default = [("#_dia_0","DIAM"),
                           ("#_dia_0'_", "DOLLAR"),
                           ("#_dia_0'make","Make&"),
			   ("#_dia_0'fill","Fill&"),
			   ("#_dia_0'alloc","Alloc"),
			   ("#_dia_0'free","Free"),
			   ("#_dia_0'V0","V0"),
			   ("#_dia_0'V1","V1"),
			   ("#_dia_0'V2","V2"),
			   ("#_dia_0'R0","R0"),
			   ("#_dia_0'R1","R1"),
			   ("#_dia_0'R2","R2"),
			   ("#_dia_0'R3","R3")]
*)

val global_global_translations = [("#_dia_0","DIAM"),
                           ("#_dia_0'_", "DOLLAR"),
                           ("#_dia_0'make","Make&"),
			   ("#_dia_0'fill","Fill&"),
			   ("#_dia_0'alloc","Alloc"),
			   ("#_dia_0'free","Free")]

(* alist mapping predefined classes to their methods *)
(* val method_alist = [("DIAM", ["Make&","Fill&","Alloc","Free"])] *)


(* this is the data layout used in TREELIST.thy; 
    must match dia_0.V0 to corresponding fieldname in here *)
(* Layout used for SLACK image *)
(*
val layout_TREELIST = SOME [("ilist", [("Nil", 0, []),
                                       ("Cons", 1, [("V0","int"),("R1","ilist")])]),
                            ("itree", [("Leaf", 0, []),
                                       ("Node", 5, [("V0","int"),("R1","itree"),("R2","itree")])]),
                            ("iresult", [("None", 0, []),
                                         ("Some", 3, [("V0", "int"),("R1","itree")])])]
*)

(* Layout used for NULLTP image *)
val layout_TREELIST = SOME [("ilist", [("Nil", 0, []),
                                       ("Cons", 5, [("V0","int"),("R1","ilist")])]),
                            ("itree", [("Leaf", 0, []),
                                       ("Node", 3, [("V0","int"),("R1","itree"),("R2","itree")])]),
                            ("iresult", [("None", 0, []),
                                         ("Some", 1, [("V0", "int"),("R1","itree")])])]

val null_tags_TREELIST =  [("ilist", "LLL"), ("itree", "TTT"), ("iresult", "RRR")]

(* copied from gf; terrible! *)
type 'a substitution = ('a * 'a) list
type layout_substitution = string substitution * int substitution * string substitution
type constructors = string * int * (string * string) list

(* filled by gf *)
val global_subst = ref (([], [],[]): layout_substitution)

val ignore_mnames = ["<init>"]
val mycname = ref "NONAME"

val isaTagOfTy =[("cname","CN"),("mname","MN"),("funame","FN"),("iname","In"),("rname","RN"),
                 ("ifldname","If"),("rfldname","Rf")]

val VERB_NONE       = (0: int)
val VERB_MIN        = (1: int)
val VERB_NAMES      = (3: int)
val VERB_TRANSLATE  = (5: int)
val VERB_MAX        = (9: int)

val verbose_level: int ref = ref VERB_NONE

(* print messages depending on verbosity level *)
fun printVerb n s = if n<=(!verbose_level)
                      then TextIO.print s
                      else ()


(* HWL: a cmdline flag set in either gf.sml or gdf.sml, or Camelot.sml *)
val shut_up = ref false
(* HWL: these are set in Diamond.sml by compiler, or read as pragmas from certificate *)
val data_layout = ref "00"
val tag_offset = ref 0

(* a table of string constants, and the counter for the next free table entry *)
val str_map: (int * string) list ref
           = ref []
val str_counter: int ref
               = ref 1

(* a mapping of (qualified) variable names to unqualified names; used after assignment of indices to short names has finished *)

val zz_map: (string * string) list ref
	= ref []  (* (variablename, int *)


(* a mapping of (qualified) variable names to indices, needed to make the unqualified
   variable name unique *)

val z_map: (string * int) list ref
	= ref []  (* (variablename, int *)

(* a mapping of (unqualified) variable names to counters, used to get indices for z_map *)
val c_map: (string * int ref) list ref
	= ref []  (* (variablename, int *)

val nam_counter: int ref
    = ref 1

fun int2b64 n = 
  let
    fun int2b64' n = let
                       val x = n div 64
                       val y = n mod 64
                     in
                       if x=0
                         then [y]
                         else y::(int2b64' x)
                     end
  in
    List.revAppend((int2b64' n),[])
  end

fun b64digit n = if n < 10 then chr(48+n) else
                if n < 36 then chr(65-10+n) else
                if n < 62 then chr(97-36+n) else
                if n = 62 then chr(32) else
                if n = 63 then chr(95) else
		raise gdfError ("b64digit: digit is >= 64 :" ^ (Int.toString n) ^"\n")

(* short name corresponding to counter n; does hashing to get short as possible string *)
fun short_nam n = GrailUtils.strReverse (String.concat (List.map (Char.toString o b64digit) (int2b64 n)))

fun apply_subst subst tg =
  let
    val z = GrailUtils.lookup tg subst
  in 
    case z of
       NONE => tg
     | SOME tg' => tg' 
  end

fun apply_ty_subst (subst,_,_) ty = apply_subst subst ty

fun apply_tag_subst (_,subst,_) tg = let 
                                     val z = apply_subst subst tg 
                                   in (* TextIO.print ("|| "^(Int.toString tg)^" => "^(Int.toString z)^"\n") ;*) 
                                     z 
                                   end

fun apply_field_subst (_,_,subst) fld = apply_subst subst fld

fun pointToPrime x =
    if (x= #".")
    then  #"'"
    else x

(* s/strCONST'/strCONST_/ ; NB: unqualified name!!*)
fun str_bonzo h = let
               val ts = splitBy #"'" h
               val n = (length ts)
              in
               if n<2
                 then h
                 else
                   case (nth (ts,1)) of 
		      "intCONST" => (join #"'" (List.take (ts,(n-3))))^"intCONST_"^(List.last ts)
		    | "strCONST" => (join #"'" (List.take (ts,(n-3))))^"strCONST_"^(List.last ts)
		    | _ => h
              end		 

(* the unqualified name, i.e. name without class and method prefix;
   internally we always use the fully qualified name;
   to emit qualified names, use the identity function here *)

fun unqual_name' pp_fix h = (* h *)
                    let
                       (* Grail vars should be distinct from Isabelle vars:
                          add a pp_fix to every var name *)
                       val h0' = ((substrAfterToken #"'") o str_bonzo)  h 
                       val h' = if Char.isAlpha(String.sub(h0',0)) (* leading char must be alpha *)
                                		 then h0'
				  		 else "X"^h0'    
                       (* get counter value for the short name *)
                       val m  = (case lookup h' (!c_map) of
				    (* new short name: add counter *)
                                    NONE => (c_map := (!c_map) @ [(h',ref 0)] ; 0)
				    (* old short name: inc counter *)
				    | (SOME cRef) => (cRef := !cRef + 1  ; !cRef))
                       (* check whether the full name has an index already, otw pick one *)
                       val x = lookup h (!z_map)
                       val post_fix = case x of  
					  NONE => (z_map := (!z_map) @ [(h, m)] ; if m=0 then "" else  "_"^(Int.toString m))
					| (SOME n) => if n=0 then "" else "_"^(Int.toString n)
                       val h0 = h'^post_fix^pp_fix
                       (* record full-,short-name pair in zz_map *)
                       val x9 = lookup h (!zz_map)
                       val _ = case x9 of  
				   NONE => (printVerb VERB_MAX ("unqual_name: adding to zz_map: |"^h^"| = |"^h0^"|\n"); 
                                            zz_map := (!zz_map) @ [(h,h0)])
                                 | (SOME h9) => if (h9=h0)
                                                  then () (* ok *)
                                                  else printVerb VERB_MAX ("unqual_name: booo "^h9^" "^h0)
                    in
                      h0
                    end

fun unqual_name_maybe cn h = if (cn = "DIAM") (* no trailing _ for Free etc *)
                          then unqual_name' "" h
                          else unqual_name' "_" h

fun unqual_name h = let
                       val pp_fix = "_"
                    in
                       unqual_name' pp_fix h
		    end


fun lookup_short_name h = let
                        val z = GrailUtils.lookup (h) (!zz_map) 
                        val h0z = case z of 
                                     NONE => "___" (* GrailUtils.exit "lookup_short_name: no full name " ^ h ^" in zz_map" *)
                                   | (SOME s) => s 
                      in
                       h0z
                      end

(* convert a function, variable, method name to an Isabelle name *)
fun isa_name x = String.map (fn c => (case c of 
                                             #"." => #"'"
                                          |  #":" => #"_"
                                          |  #"$" => #"_"
                                          |  #"?" => #"_"
                                          |  c' => c'))
                         x



(* handling of string constants ------------------------------ *)

(* string constants are encoded as RVars with value of constant encoded in name *)
fun intToName iconst = "intCONST'"^(Int.toString iconst)

(* ToDo: replace this with a proper pair of en/decoding functions *)
(* old version, trying to encode string in the name; bad idea!
fun stringToName sconst = "strCONST'"^(String.map (fn c => 
                                                      if ord(c)<48 orelse ord(c)>122
                                                       then #"_"
                                                       else case c of
                                                         #" "  => #"_"
                                                       | #"\\"  => #"_"
                                                       | #"`"  => #"_"
                                                       | #"^"  => #"_"
                                                       | #"["  => #"_"
                                                       | #"]"  => #"_"
                                                       | #"<"  => #"_"
                                                       | #">"  => #"_"
                                                       | #"="  => #"_"
                                                       | #"?"  => #"_"
                                                       | #"@"  => #"_"
                                                       | #":"  => #"_"
                                                       | #";"  => #"_"
                                                       | #"."  => #"_"
                                                       | c' => c') sconst)^"_"
*)

(* n is the table entry for this string *)
fun stringToName n = "strCONST'"^(Int.toString n)

(* NB: nameToSting o stringToName = id *)
fun nameToString const_name = let 
                                val s = String.substring(const_name, 9, (String.size const_name)-9)
                              in 
                                s
                              end

(* add to table only *)
fun add_string_to_table' s = let 
                               val _ = str_map := (!str_map) @ [(!str_counter, s)] 
                               val _ = printVerb VERB_NAMES ("Recorded string " ^s^" as strConst_"^(Int.toString (!str_counter))^"\n") 
                               val _ = str_counter := !str_counter+1
                             in
                               () (* YUCK! *)
                             end

(* add to table and return its name *)
fun add_string_to_table s = let 
                              val n = !str_counter
                              val _ = add_string_to_table' s
                            in
                              stringToName n
                            end

fun lookup_string_from_table n = let 
                                   val s' = GrailUtils.lookup n (!str_map)
                                   val s  = case s' of
                                              NONE => ""
                                            | SOME str => str
                                   val _  = printVerb VERB_NAMES ("Look up of index " ^(Int.toString n)^" from string tablle gives: "^(if (s'=NONE) then "NOTHING" else s)^"\n")
							  
                                 in 
                                   s
				 end

fun printStringConstants thy n = 
  if (n>=(!str_counter))
    then ()
    else let
            val _ = PrlF thy ("    " ^ stringToName n ^ " :: rname")
         in
          printStringConstants thy (n+1)
         end

fun printStringTranslations thy n = 
  if (n>=(!str_counter))
    then ()
    else let
            val _ = PrlF thy ("    \"" ^ stringToName n ^ "\" == \"(RN ''"^ (str_bonzo (stringToName n)) ^"_'')\"")
         in
          printStringTranslations thy (n+1)
         end

(*
fun qaHleS () = case !data_layout of
                   "01" => global_translations
                 | "10" => global_translations_10
                 | "20" => global_translations_20
                 | "30" => global_translations_30
                 | "40" => global_translations_40
                 | _    => global_translations_default
*)

(* Version with data-layout-unification *)
fun tr name = let 
                val g0 = map (fn (k,v) => ((!mycname)^String.extract(k,1,NONE), v)) global_global_translations
                val g1 = map (fn (k,v) => ((!mycname)^"_dia_0'"^k, v)) (thd3 (!global_subst))
              in
               case lookup name g0 of
                 NONE => let 
                         in
                          case lookup name g1 of
                            NONE => name
                          | SOME name' => name'
                         end
               | SOME name' => name'
              end

(* Old 
fun tr name = let val translations = map (fn (k,v) => ((!mycname)^String.extract(k,1,NONE), v)) (qaHleS ())
              in
               case lookup name translations of
                 NONE => name
               | SOME name' => name'
              end
*)

fun encode_syntax printCert layout offset thy = (printCert,layout,offset,thy)

fun decode_syntax (printCert,layout,offset,thy) = (printCert,layout,offset,thy)
(*
fun decode_syntax thySyntax' =
 let 
     val printCert  = (thySyntax' div 100)>0
     val dataLayout = (thySyntax' mod 100) div 10
     val thySyntax  = thySyntax' mod 10
 in
   (printCert,dataLayout,tagOffset,thySyntax)
 end
*)

fun ty2char BYTEty       = "b"     
  | ty2char CHARty       = "c"
  | ty2char DOUBLEty     = "d"
  | ty2char FLOATty      = "f"
  | ty2char INTty        = "I"
  | ty2char LONGty       = "l"
  | ty2char SHORTty      = "s" 
  | ty2char BOOLEANty    = "b"
  | ty2char (REFty _)    = "D"
  | ty2char (ARRAYty _)  = "a"


(* a fct type encode as e.g. I(ID) for int -> ref -> int *)
fun getShortFunType (SOME rty) tys = (ty2char rty)^"("^concat (map ty2char tys)^")"
  | getShortFunType NONE tys = "_("^concat (map ty2char tys)^")"

(* was in ToyClassTable.sml *)
fun  getFlds "IntBoxed" = (["IntBoxed'number"], [], [])
    | getFlds "PairToy" = (["PairToy'lesser"], ["PairToy'greater"], [])
    | getFlds "ListToy" = (["ListToy'head"], ["ListToy'tail"], [])
    | getFlds "IntListPair" = (["IntListPair'number"], ["IntListPair'list"], [])
    | getFlds _ = ([], [], ["fail'class'name"]) 

datatype 'a ToyClassDef = ToyCDEF of cname list * mname list * ifldname list * rfldname list * 
                                 funame list * exprname list * iname list * rname list *
                                 failname list * ('a ToyExpression) list *
                                 (mname * paramlist) list

and 'a ToyExpression = 
       Null_ of string * string option 
     | Int_ of int
     | String_ of string
     | IVar of iname
     | RVar of rname
     | ToyPrimOp of ToyBinOp * iname * iname
     | ToyRPrimOp of ToyRBinOp * rname * rname
     | IsNull of rname
     | New_ of cname * (ifldname * iname) list * (rfldname * rname) list
     | GetFi of rname * ifldname
     | GetFr of rname * rfldname
     | PutFi of rname * ifldname * iname
     | PutFr of rname * rfldname * rname
     | GetStat of cname * rfldname
     | PutStat of cname * rfldname * rname
     | Invoke of rname * mname * rname
     | InvokeStatic of cname * mname * arglist  (* or:  (Args list) *)
     | InvokeVirtual of rname * mname * arglist  (* or:  (Args list) *)
     | Leti of iname * 'a ToyExpression * 'a ToyExpression
     | Letr of rname * 'a ToyExpression * 'a ToyExpression
     | Letv of 'a ToyExpression * 'a ToyExpression
     | Ifg of iname * 'a ToyExpression * 'a ToyExpression
     | Call of funame
     | Ill_Expr of string

(*
and Args = INarg of iname | RNarg of rname | VALarg of int
*)

and ToyBinOp = ADDopToy | SUBopToy | MULopToy | DIVopToy | MODopToy | 
                EQtestToy | LtestToy | LEtestToy| GtestToy | GEtestToy | NEtestToy 

and ToyRBinOp =  REQtestToy | RUndeftestToy
 
and ToyTy = IntTy | RefTy | FailTy

withtype iname = string
        and rname = string  
        and cname = string
        and ifldname = string
        and rfldname = string
        and mname = string  
        and funame = string
        and exprname = string
        and arglist = string
        and paramlist = string
        and failname = string;


val prseparator =  ref 0;
val testcounter = ref 0;


fun testToToy EQtest = EQtestToy
  | testToToy NEtest = NEtestToy
  | testToToy Ltest  = LtestToy
  | testToToy LEtest = LEtestToy
  | testToToy Gtest  = GtestToy
  | testToToy GEtest = GEtestToy

fun rTestToToy EQtest = REQtestToy
   | rTestToToy _ = RUndeftestToy

fun binOpToToy ADDop = ADDopToy
  | binOpToToy SUBop = SUBopToy
  | binOpToToy MULop = MULopToy
  | binOpToToy DIVop = DIVopToy
  | binOpToToy MODop = MODopToy
  | binOpToToy _ = raise toyError "UNIMPLEMENTED BINop"
fun toyBinOpToString EQtestToy = "(%  x y . if y=x then (1::int) else (0::int))"
  | toyBinOpToString NEtestToy = "(%  x y . if y=x then (0::int) else (1::int))"
  | toyBinOpToString LtestToy  = "(%  x y . if x<y then (1::int) else (0::int))"
  | toyBinOpToString LEtestToy = "(%  x y . if y<x then (0::int) else (1::int))"
  | toyBinOpToString GtestToy  = "(%  x y . if y<x then (1::int) else (0::int))"
  | toyBinOpToString GEtestToy = "(%  x y . if x<y then (0::int) else (1::int))"
  | toyBinOpToString ADDopToy = "(%  x y . (x + y))"
  | toyBinOpToString SUBopToy = "(%  x y . (x - y))"
  | toyBinOpToString MULopToy = "(%  x y . (x * y))"
  | toyBinOpToString DIVopToy = "(%  x y . (x div y))"
  | toyBinOpToString MODopToy = "(%  x y . (x mod y))"

fun toyRBinOpToString REQtestToy = "(%  x y . if y=x then (1::int) else (0::int))"
  | toyRBinOpToString _ = "Wrong Reference Test"

fun  typeFromGrailTy INTty = IntTy
   | typeFromGrailTy (REFty _) = RefTy
   | typeFromGrailTy BOOLEANty = IntTy 
   | typeFromGrailTy _  = FailTy

fun typeFromGrailRTy rty =
    case rty of 
        NONE => IntTy
      | SOME INTty => IntTy     
      | SOME (REFty _ ) => RefTy
      | SOME BOOLEANty => IntTy 
      | SOME  _    => FailTy

(* translate list of pars to list of args, e.g. [INpar x] becomes [INarg x] *)
fun par2arg_list_HACK par_str =
  let
    (* strip leading [ and trailing ] *)
    val par_str' = String.substring(par_str,1,(String.size par_str)-2) 
    (* split into words *)		   
    val xs = splitBy #" " par_str'
    fun tag_par2arg tag = if ((String.sub(tag,0)) = #"I")
                            then "INarg"
                            else "RNarg"
    fun iter (tag::name::xs) = (tag_par2arg tag)::name::(iter xs)
      | iter   [] = []
      | iter   _ = raise gdfError "iter: list of odd length"
  in 
    "["^(join #" " (iter xs))^"]"
  end
   
fun dump_constants xs = List.filter (fn x => ((String.size x)<9) orelse (not (String.substring(x, 0, 9)="intCONST'") andalso not (String.substring(x, 0, 9)="strCONST'"))) xs

fun addElemToList elem l = 
     if not (is_elem elem l)
     then elem::l
     else l

fun  addLists [] l = l
   | addLists (h::t) l =
     addElemToList h (addLists t l)


fun mergeVectorsLists (l1, l2, l3, l4, l5, l6, l7, l8) (m1, m2, m3, m4, m5, m6, m7, m8) =
    (addLists l1 m1,
     addLists l2 m2,
     addLists l3 m3,
     addLists l4 m4,
     addLists l5 m5,
     addLists l6 m6,
     addLists l7 m7,
     addLists l8 m8)

fun initList [] = []
  | initList (h::[])= []
  | initList (h1::(h2::t)) = h1 :: (initList (h2::t)) 

fun prefixToList str [] = []
  | prefixToList str (h::t) =
    ((str^h) :: (prefixToList str t))


fun printGrailPROG thy (classdef as CDEF (_, cname, _, _, _, _,layout)) thySyntax =
   (
    (*+ TextIO.print ("Munging class "^cname^" with the following data layout: "^(case layout of NONE => " (EMPTY LAYOUT) " | SOME (xs) => " (layout with "^(Int.toString (length xs))^" constructors) "));
    prLayout layout; +*)
    printToyPROG thy cname (translateGrailPROG classdef) thySyntax 
   )

(* kwxm:  Grail classdefs now have superclass & interfaces *)

and translateGrailPROG (CDEF(flags, cname, _, _, fdefs, mdefs,_)) = 
                                        (* ^  ^  kwxm: cdefs now have superclass & interfaces *)
   (printVerb VERB_MAX ("|"^(isa_name cname)^"|");
    mycname := isa_name cname ;
    let 
        val (iflds, rflds, flnames) = getThisFldNames cname fdefs
        val (ToyCDEF(cnames, mnames, ifldnames, rfldnames, funames, 
                     exprnames, inames, rnames, failnames, exprs, meth_param_map)) =
                getListsFromMthds (isa_name cname) mdefs 
    in  ToyCDEF(addElemToList cname cnames, 
                mnames, 
                addLists iflds ifldnames, 
                addLists rflds rfldnames,
                funames, exprnames, inames, rnames, 
                addLists flnames failnames, 
                exprs, meth_param_map)
   end
   )

and getListsFromMthds cname [] =  ToyCDEF([], [], [], [], [], [], [], [], [], [], [])
  | getListsFromMthds cname (h::t) = 
    let val (ToyCDEF(hcnames, hmnames, hifldnames, hrfldnames, hfunames, 
               hexprnames, hinames, hrnames, hfailnames, hexprs, meth_param_map)) = 
           getListsFromMethod cname h
        val ToyCDEF(tcnames, tmnames, tifldnames, trfldnames, tfunames, 
                    texprnames, tinames, trnames, tfailnames, texprs, meth_param_map') =
            getListsFromMthds cname t
    in ToyCDEF(
              (* Stuff that may be shared by the methods inside the class *)
               addLists hcnames tcnames,        
               addLists hmnames tmnames,

              (* Field names are already prefixed by the name of a holding class *)
               addLists hifldnames tifldnames,        
               addLists hrfldnames trfldnames,

              (* The names below are prefixed by class and method names  *)
              (* For instance, clname'metname'myname  *)
               hfunames @ tfunames,        
               hexprnames @ texprnames,
               hinames @ tinames,        
               hrnames @ trnames,
               hfailnames @ tfailnames,        
               hexprs @ texprs,
               meth_param_map @ meth_param_map')
                             
    end

and getThisFldNames cname [] = ([], [], [])
| getThisFldNames cname ((FDEF(flags, ty, name))::t) =
  let val (ifldnames, rfldnames, failnames) = getThisFldNames cname t
  in case ty of
         INTty     => (addElemToList (cname^"'"^(isa_name name)) ifldnames, rfldnames, failnames)
       | (REFty _) => (ifldnames, addElemToList (cname^"'"^(isa_name name)) rfldnames, failnames)
       | _         => (ifldnames, rfldnames, addElemToList (cname^"'"^(isa_name name)) failnames)
  end

and getListsFromMethod cname (MDEF(flags, rty, name, params, mbody)) =
    (
    testcounter:=0;
    let 
        (* The first run of the compiler : getting all the names,
           not prefixed so far *)
        val ((cnames, mnames, ifldnames, rfldnames, funames, inames, rnames, failnames), param_str, fun_param_map) =
            getNamesFromMethod cname name params mbody
    in (testcounter:=0; 
        let 
       (* the second run of the compiler : translation *)
        val fullmname = cname^"'"^(isa_name name)
        val (exprnames, exprs) = getExprsFromMethod  (dump_constants inames) (dump_constants rnames) (fullmname^"'") mbody
        in ToyCDEF(cnames, 
                   addElemToList fullmname mnames, 
                   ifldnames, rfldnames, 
                   prefixToList  (fullmname^"'") funames, 
                   prefixToList  (fullmname^"'") exprnames, 
                   prefixToList  (fullmname^"'") inames, 
                   prefixToList  (fullmname^"'") rnames, 
                   prefixToList  (fullmname^"'") failnames, 
                   exprs, [(fullmname, param_str)] @ fun_param_map )
        end
       )
    end
    )

and getNamesFromMethod cname mname params (MBODY(letdecs, fundecs, result)) =
    let val (inames, rnames, failnames, param_str) = getNamesFromParams cname mname params 
        val (vecs, fun_param_map) = getNamesFromMBody cname mname inames rnames failnames letdecs fundecs result
    in  (vecs, "["^param_str^"]", fun_param_map)
    end

and getNamesFromParams cname mname [] = ([], [], [], "") (* last elem is paramlist in isabelle notation *)
|   getNamesFromParams cname mname ((ty,va)::t) =
    let val (inames, rnames, failnames, str)  = getNamesFromParams cname mname t
    in case ty of
         INTty  => ((isa_name va) :: inames, rnames, failnames, 
                    ("INpar "^(unqual_name (cname^"'"^(isa_name mname)^"'"^(isa_name va)))^(if (str="") then "" else ", ")^str))
       | (REFty _) => (inames, (isa_name va) :: rnames, failnames,
                    ("RNpar "^(unqual_name (cname^"'"^(isa_name mname)^"'"^(isa_name va)))^(if (str="") then "" else ", ")^str))
       (* HACK: treat array in param list as ref and forget about its name *)
       | (ARRAYty _) => (inames, (isa_name va) :: rnames, failnames,
                    ("RNpar "^(unqual_name (cname^"'"^(isa_name mname)^"'"^(isa_name va)))^(if (str="") then "" else ", ")^str))
       | _         => (inames, rnames, (isa_name va) :: failnames, 
                    ("FAIL"^(if (str="") then "" else ", ")^str))
    end

and getNamesFromMBody cname mname inames rnames failnames letdecs fundecs result =
    let val (fnames, fargs, fletdecs, fresults) = splitFundecs cname mname fundecs
    in let val (cnameslet, mnameslet, ifldnameslet, rfldnameslet, funameslet, inameslet, rnameslet, failnameslet) = 
                  getNamesFromLetdecs inames rnames (letdecs @ fletdecs)
    in let val resultsnames = getNamesFromResults inameslet rnameslet ([result] @ fresults)
          in (mergeVectorsLists

                (cnameslet, mnameslet, ifldnameslet, rfldnameslet, 
                addLists fnames funameslet, 
                inameslet, rnameslet, 
                addLists failnames failnameslet)

                resultsnames
              ,
                GrailUtils.zipWith (fn (x,y) => let 
                                     val x' =  cname^"'"^(isa_name mname)^"'"^x
                                     val y' = "["^y^"]"
                                   in 
                                     (x',y') 
                                   end) fnames fargs) (* returns a map of fnames to args *)
          end
       end
   end

(* so far function args are ignored *)
(* but they must be declared somewhere in the method, 
so there is no need to scan the list of parameters *)

(* unzip over a list of FDECs *)
and splitFundecs cname mname [] = ([], [], [], [])
|  splitFundecs cname mname ((FDEC(fname, args, FUNbody(letdecs, result))) :: t) = 
   let val (tfnames, targ_str, tletdecs, tresults) = splitFundecs cname mname t
       val (_, _, _, arg_str) = getNamesFromParams cname mname args
   in ((isa_name fname)::tfnames, arg_str::targ_str, letdecs @ tletdecs, result::tresults)
   end

and getNamesFromLetdecs inames rnames [] = 
              ([], [], [], [], [], inames, rnames, [])
 |  getNamesFromLetdecs inames rnames (h::t) =
    let val (cn, mn, ifldn, rfldn, fnn, inn, rn, failn) = getNamesFromLetdecs inames rnames (initList (h::t))
    in  let val vl = getNamesFromLetDec inn rn (List.last (h::t))  
        in mergeVectorsLists (cn, mn, ifldn, rfldn, fnn, inn, rn, failn) vl
        end
    end
    

and  getNamesFromLetDec inames rnames  (VALdec(id, p)) =
     let val ty = typeFromPrimOp inames rnames p
         val (cn, mn, ifldn, rfldn, fnn, inn, rn, failn) = getNamesFromPrimOp inames rnames p
     in case ty of
          IntTy => (cn, mn, ifldn, rfldn, fnn, addElemToList (isa_name id) inn, rn, failn)
        | RefTy => (cn, mn, ifldn, rfldn, fnn, inn, addElemToList (isa_name id) rn, failn)
        | _ => (cn, mn, ifldn, rfldn, fnn, inn, rn, addElemToList (isa_name id) failn)
     end  
 
(* Void dec can be only due to "putfield" *)
(* No new identifier appears, the names must be obtained from "putfield" arguments *)
|  getNamesFromLetDec inames rnames  (VOIDdec p) =
        getNamesFromPrimOp inames rnames p

and getNamesFromArgList typs xs = foldr (fn (x,y) => mergeVectorsLists x y) ([], [], [], [], [], [], [] , []) (map getNameFromArg (ListPair.zip(typs, xs)))

and getNameFromArg (ty,(VARval vn)) = (case ty of
                                          INTty => ([], [], [], [], [], [isa_name vn], [] , [])
                                        | (REFty _) => ([], [], [], [], [], [], [isa_name vn] , [])
                                        (* HACK: ignore arrays; used as args to main *)
                                        | (ARRAYty _) => ([], [], [], [], [], [], [] , []) 
                                        | _     => ([], [], [], [], [], [], [] , [isa_name vn]))
  | getNameFromArg (ty,(STRINGval s)) =    (printVerb VERB_NAMES ("Getting name from arglist: |"^(s)^"|\n");
                                            ([], [], [], [], [], [], [], [])) (* HWLstrHACK *)
  | getNameFromArg (ty,(INTval i))    = ([], [], [], [], [], [], [] , [])
  | getNameFromArg (ty,_)             = ([], [], [], [], [], [], [] , [])

and  getNamesFromPrimOp ideclared rdeclared (VALop p) = getNamesFromNonOperand ideclared rdeclared p

  | getNamesFromPrimOp ideclared rdeclared (BINop(b, v, w)) = 
    let val lv  = getNamesFromOperand ideclared rdeclared v
        val lw  = getNamesFromOperand ideclared rdeclared w
    in mergeVectorsLists lv lw
    end 

 
  | getNamesFromPrimOp ideclared rdeclared (NEWop(MDESC(rty, name, typs), l)) = 
    let val (inames, rnames, failnames) = getNamesFromListOperand ideclared rdeclared l
        val (iflds, rflds, failns)  = getFlds name
    in ([name], [], iflds, rflds, [], inames, rnames, failnames)
    end 

(* so far only one ref parameter is supported *)   
  | getNamesFromPrimOp ideclared rdeclared (INVOKEVIRTUALop(var, MDESC(rty, name, typs) , (VARval(vname)::[]))) = 
    if (is_elem var rdeclared)
    then if (is_elem vname rdeclared)
         then let val cname = (substrBeforeToken #"." name)
                  val mname = isa_name name
                  (* the operands are already listed *)
               in (cname::[], mname::[], [], [], [], [], [] , [])
               end
         else ([], [], [], [], [], [], [] , vname :: [])
    else ([], [], [], [], [], [], [] , var::[])

  | getNamesFromPrimOp ideclared rdeclared (INVOKESTATICop(MDESC(rty, name, typs) , args)) = (* (VARval(vname)::[]))) = *)
    let
      val arg_names = getNamesFromArgList typs args
        (* if (is_elem vname rdeclared) then let *)
      val cname = (substrBeforeToken #"." name)
      val mname = isa_name name (* (String.map pointToPrime name) *)
               (* the operands are already listed *)
    in mergeVectorsLists
         (if (is_elem cname (map (fn k => (!mycname)^String.extract(k,1,NONE)) global_cnames)) 
            then [] 
            else cname::[], 
          if (is_elem mname (map (fn k => (!mycname)^String.extract(k,1,NONE)) global_mnames)) 
            then [] 
            else mname::[], 
          [], [], [], [], [] , [])
         arg_names
    end
  | getNamesFromPrimOp ideclared rdeclared (GETFIELDop(v, (FDESC(ty, name )))) = 
    if (is_elem v rdeclared)
    then let val cname = (substrBeforeToken #"." name)
             val fname = isa_name name (* (String.map pointToPrime name) *)
         in   case ty of
         	INTty => (cname::[], [], fname::[], [], [], [], [] , [])
         	| (REFty _) => (cname::[], [], [], fname::[], [], [], [] , [])
         	| _ => (cname::[], [], [], [], [], [], [] , fname::[])
         end
    else ([], [], [], [], [], [], [] , v::[])

  | getNamesFromPrimOp ideclared rdeclared (PUTFIELDop(v, (FDESC(ty, name )), w)) = 
    if (is_elem v rdeclared)
    then let val lw= getNamesFromOperand ideclared rdeclared w
             val cname = (substrBeforeToken #"." name)
             val fname = isa_name name (* (String.map pointToPrime name) *)
         in 
         case ty of
         INTty => mergeVectorsLists lw (cname::[], [], fname::[], [], [], [], [] , [])
         | (REFty _) => mergeVectorsLists lw (cname::[], [], [], fname::[], [], [], [] , [])
         | _ => mergeVectorsLists lw (cname::[], [], [], [], [], [], [] , fname::[])
         end
    else ([], [], [], [], [], [], [] , v::[])

  | getNamesFromPrimOp ideclared rdeclared (GETSTATICop (FDESC(ty, name ))) = 
    (* if (is_elem v rdeclared) *)
         let val cname = (substrBeforeToken #"." name)
             val fname = isa_name name (* (String.map pointToPrime name) *)
         in   case ty of
         	INTty => (cname::[], [], fname::[], [], [], [], [] , [])
         	| (REFty _) => (cname::[], [], [], fname::[], [], [], [] , [])
         	| _ => (printVerb VERB_NAMES ("getNamesFromPrimOp (GETSTATICop ...  does it with " ^ fname);
                        (cname::[], [], [], [], [], [], [] , fname::[]))
         end
    (* else ([], [], [], [], [], [], [] , v::[]) *)

  | getNamesFromPrimOp ideclared rdeclared (PUTSTATICop (FDESC(ty, name ), w)) = 
    (* if (is_elem v rdeclared) *)
         let val lw = getNamesFromOperand ideclared rdeclared w
             val cname = (substrBeforeToken #"." name)
             val fname = isa_name name (* (String.map pointToPrime name) *)
         in 
         case ty of
         INTty => mergeVectorsLists lw (cname::[], [], fname::[], [], [], [], [] , [])
         | (REFty _) => (printVerb VERB_MAX ("r["^fname^"]") ; 
                          mergeVectorsLists lw (cname::[], [], [], fname::[], [], [], [] , []))
         | _ => (printVerb VERB_NAMES ("getNamesFromPrimOp (PUTSTATICop ...  does it with " ^ fname); 
                 mergeVectorsLists lw (cname::[], [], [], [], [], [], [] , fname::[]))
         end
    (* else  ([], [], [], [], [], [], [] , v::[]) *)

  | getNamesFromPrimOp ideclared rdeclared   _ = ([], [], [], [], [], [], [] , [])


and getNamesFromListOperand ideclared rdeclared [] = ([], [], [])
   |getNamesFromListOperand ideclared rdeclared (h::t) =
    let val (cn, mn, fnn, ifldn, rfldn, inn, rn, failn) = getNamesFromOperand ideclared rdeclared h
        val (innt, rnt, failnt) = getNamesFromListOperand ideclared rdeclared t
    in (addLists inn innt, addLists rn rnt, addLists failn failnt)
    end

(* Values no taking part in binops are either constants (then now new name appears) *)
(* or variables, declared above. Therefore, no new names appear. *)
(* only STRINGval needs to be recorded - as a r-val for now *)
and getNamesFromNonOperand ideclared rdeclared (INTval iconst) = ([], [], [], [], [], [], [], [])  (* ["c'"^(Int.toString iconst)], [], []) *)
 |  getNamesFromNonOperand ideclared rdeclared (NULLval _) = ([], [], [], [], [], [], [], [])  (* ["Null'GenVar"] , [])  HWLnukeGen *)
 |  getNamesFromNonOperand ideclared rdeclared (STRINGval s) = ([], [], [], [], [], [], [] , []) (* (stringToName s) HWLstrHACK *)
 |  getNamesFromNonOperand ideclared rdeclared _  = ([], [], [], [], [], [], [] , [])


and getNamesFromOperand ideclared rdeclared (INTval iconst) = ([], [], [], [], [], [intToName iconst], [], [])
 |  getNamesFromOperand ideclared rdeclared (VARval vname) = 
    let val ty = typeFromVar ideclared rdeclared vname
    in if (ty=FailTy)
       then (* type error *)
            ([], [], [], [], [], [], [] , [isa_name vname])
       else (* the variable is already declared *)
            ([], [], [], [], [], [], [] , [])
    end
 |  getNamesFromOperand ideclared rdeclared (NULLval _) = ([], [], [], [], [], [], [] , [])  (* ["Null'GenVar"] , []) HWLnukeGen *)
 |  getNamesFromOperand ideclared rdeclared (STRINGval s) = ([], [], [], [], [], [], [] , []) (* (stringToName s) HWLstrHACK *)
 |  getNamesFromOperand ideclared rdeclared _  = ([], [], [], [], [], [], [] , [])

and getNamesFromResults ideclared rdeclared [] = ([], [], [], [], [], [], [] , [])
 | getNamesFromResults  ideclared rdeclared (h::t) =
   mergeVectorsLists (getNamesFromResult ideclared rdeclared h) (getNamesFromResults ideclared rdeclared t)


and getNamesFromResult ideclared rdeclared (PRIMres p) =   getNamesFromPrimRes ideclared rdeclared p
 |  getNamesFromResult ideclared rdeclared (CHOICEres (v, tst, w, p1, p2)) =
    (testcounter := 1+(!testcounter); 
    let val newtest = "q_"^(Int.toString(!testcounter))
        val lv = getNamesFromOperand ideclared rdeclared v
        val lw = getNamesFromOperand ideclared rdeclared w
        val lp1 =  getNamesFromPrimRes ideclared rdeclared p1
        val lp2 =  getNamesFromPrimRes ideclared rdeclared p2     
    in mergeVectorsLists ([], [], [], [], [], [newtest], [], [])
            (mergeVectorsLists lv (mergeVectorsLists lw (mergeVectorsLists lp1 lp2))) 
    end
    )
  | getNamesFromResult _ _ _  = raise gdfError "getNamesFromResult: no matching case"

 

and getNamesFromPrimRes ideclared rdeclared (OPres p) = getNamesFromPrimOp ideclared rdeclared p
  | getNamesFromPrimRes ideclared rdeclared (VOIDres) = ([], [], [], [], [], [], [] , [])
  | getNamesFromPrimRes ideclared rdeclared (FUNres (name, args)) = ([], [], [], [], [isa_name name], [], [], [])


and getExprsFromMethod inames rnames prefix (MBODY(letdecs, fundecs, result)) = 
      getExprsFromNamedLetDecs inames rnames prefix (("", letdecs, result) ::  (makeNamedLetDecsList fundecs))

and makeNamedLetDecsList [] = []
 |  makeNamedLetDecsList ((FDEC(fname, args, (FUNbody(letdecs, result)))):: t) =
        (((isa_name fname), letdecs, result) :: (makeNamedLetDecsList t))

and  getExprsFromNamedLetDecs inames rnames prefix []  = ([], [])
  |  getExprsFromNamedLetDecs inames0 rnames0 prefix ((name, letdecs, result) :: t) = 
     let 
      (* rerun getNames.. for the fun body, to make sure new inCONSTs etc are not 
         lifted out of the function; would be better to use inames rnames inputs! *)
      val (cnames, mnames, ifldnames, rfldnames, funames, inames, rnames, failnames) = 
                  getNamesFromLetdecs inames0 rnames0 (letdecs)
      (* AHHHHHHHHHHHHHHHHHHHHHHHH! need to memorise and reset testcounter if we
         run getNameFromResult, if we run it several times: it increases the counter *)
      val bonzo = !testcounter
      val (cnames1, mnames1, ifldnames1, rfldnames1, funames1, inames1, rnames1, failnames1) = 
             getNamesFromResult inames0 rnames0 result
      val _ = testcounter := bonzo
      val newexpr = translateLetExprConsts (inames@inames1@rnames@rnames1) (inames) (rnames) prefix letdecs result
      val (exprnamest, exprst) = getExprsFromNamedLetDecs (dump_constants (inames@inames1)) (dump_constants (rnames@rnames1)) prefix t
     in (((isa_name name)^"Body")::exprnamest, newexpr :: exprst)
     end

(* We start let-decs with declaration of all the integer constants,
  appearing in the code ! *)
(* The first argument is the list of integer names,
   which we check on the presence of constants ... *) 
and translateLetExprConsts [] inames rnames prefix letdecs result = 
       translateLetExprNull inames rnames prefix letdecs result
 | translateLetExprConsts (h::t) inames rnames prefix letdecs result =
  (printVerb VERB_TRANSLATE ("translateLetExprConsts of |"^h^"|\n") ; 
   if (String.size h >9)
   then if (String.substring(h, 0, 9)="intCONST'")  (* add int const to Let-expr *)
    	then 	let val x = Int.fromString (String.substring(h, 9, (String.size h)-9))
         	in  case x of 
               		(SOME i) => Leti(prefix^h, Int_(i), translateLetExprConsts t inames rnames prefix letdecs result) 
              		| NONE => Ill_Expr ("Leti: Error in lifting i-val constant"^(h))
         	end
(* We assume that we have an RVar for each string constant that appears in the code
   We shouldn't allocate them with NEW here, since this changes heap consumption.
   Axioms need to be inserted to make sure these RVars acutally exist.

        else if (String.substring(h, 0, 9)="strCONST'") (* add str const to Let-expr *)
    	       then let val x = String.substring(h, 9, (String.size h)-9) (*nameToString h*)
         	    in  
                     Letr(prefix^h, String_(x), translateLetExprConsts t inames rnames prefix letdecs result) 
                    end
*)
        else translateLetExprConsts t inames rnames prefix letdecs result
    else translateLetExprConsts t inames rnames prefix letdecs result)

(* Now we need to check if Null'GenVar appears in the list of rnames *)
(* If yes, then we need to declare it *)
and translateLetExprNull inames rnames prefix letdecs result = 
if (is_elem "Null'GenVar" rnames)
     then  Letr(prefix^"Null'GenVar", 
                         Null_("LLL",SOME("LLL")), translateLetExpr inames rnames prefix letdecs result)
     else (translateLetExpr inames rnames prefix letdecs result) 

and translateLetExpr inames rnames prefix [] result =translateResult inames rnames prefix result
  | translateLetExpr inames rnames prefix ((VALdec(id, p))::t) result = 
       translateFlLetExpr inames rnames prefix (isa_name id) p t result
  | translateLetExpr inames rnames prefix ((VOIDdec p)::t) result = 
    case p of  
         (VALop  v) => (printVerb VERB_TRANSLATE "Bad RHS in VOIDdec: (VALop  v)\n" ;
                        translateFlLetExpr  inames rnames  prefix "fail'name" p t result   )
       | (BINop  (b , v , v')) => (printVerb VERB_TRANSLATE "Bad RHS in VOIDdec: (BINop  (b , v , v))\n" ;
                                   translateFlLetExpr  inames rnames  prefix "fail'name" p t result   )
       | (CHECKCASTop  (str , x)) => (printVerb VERB_TRANSLATE "Bad RHS in VOIDdec: (CHECKCASTop  (str , x))\n" ; 
                                      translateFlLetExpr  inames rnames  prefix "fail'name" p t result   )
       | (INSTANCEop  (str , x)) => (printVerb VERB_TRANSLATE "Bad RHS in VOIDdec: (INSTANCEop  (str , x))\n" ; 
                                     translateFlLetExpr  inames rnames  prefix "fail'name" p t result   )
       | (INVOKESTATICop  (md , vs)) => 
	  (printVerb VERB_MAX ("BONZO: INVOKESTATIC of "^(case md of (MDESC(rty, name, typs)) => name)) ; 
               (Letv ((translatePrimOp inames rnames  prefix (INVOKESTATICop  (md , vs)))                   ,
                     (translateLetExpr inames rnames prefix t result))))
       | (INVOKESPECIALop  (x , md , vs)) => 
               translatePrimOp inames rnames  prefix (INVOKESPECIALop  (x , md , vs))

       | (INVOKEVIRTUALop  (x , md , vs)) => (printVerb VERB_TRANSLATE "Bad RHS in VOIDdec: (INVOKEVIRTUALop  (x , md , v list))\n" ;
                                              translateFlLetExpr  inames rnames  prefix "fail'name" p t result   )
       | (INVOKEINTERFACEop  (x , md , vs)) => (printVerb VERB_TRANSLATE "Bad RHS in VOIDdec: (INVOKEINTERFACEop  (x , md , v list))\n" ; 
                                                translateFlLetExpr  inames rnames  prefix "fail'name" p t result   )
       | (GETFIELDop  (x , fd)) => (printVerb VERB_TRANSLATE "Bad RHS in VOIDdec: (GETFIELDop  (x , fd))\n" ; 
                                    translateFlLetExpr  inames rnames  prefix "fail'name" p t result   )
       | (PUTFIELDop(v,(FDESC(ty, name )) , w)) => (printVerb VERB_TRANSLATE "Bad RHS in VOIDdec: (PUTFIELDop  (v , fd , w))\n" ; 
               translateFlLetExpr  inames rnames  prefix (translateOperand inames rnames false "" "" w) p t result )
       | (GETSTATICop  fd) => (printVerb VERB_TRANSLATE "Bad RHS in VOIDdec: (GETSTATICop  fd)\n" ; 
                               translateFlLetExpr  inames rnames  prefix "fail'name" p t result   )
       | (PUTSTATICop((FDESC(ty, name )) , w)) => (printVerb VERB_TRANSLATE "Bad RHS in VOIDdec: (PUTSTATICop  (fd , v))\n" ; 
               translateFlLetExpr  inames rnames  prefix (translateOperand inames rnames false "" "" w) p t result) 
       | (NEWop  (m , vs)) => (printVerb VERB_TRANSLATE "Bad RHS in VOIDdec: (NEWop  (m , vs))\n" ; 
                               translateFlLetExpr  inames rnames  prefix "fail'name" p t result   )
       | (MAKEop  (v , v')) => (printVerb VERB_TRANSLATE "Bad RHS in VOIDdec: (MAKEop  (v , v))\n" ; 
                                translateFlLetExpr  inames rnames  prefix "fail'name" p t result   )
       | (GETop  (v , v')) => (printVerb VERB_TRANSLATE "Bad RHS in VOIDdec: (GETop  (v , v))\n" ; 
                               translateFlLetExpr  inames rnames  prefix "fail'name" p t result   )
       | (SETop  (v , v' , v'')) => (printVerb VERB_TRANSLATE "Bad RHS in VOIDdec: (SETop  (v , v , v))\n" ; 
                                     translateFlLetExpr  inames rnames  prefix "fail'name" p t result   )
       | (LENGTHop  v) => (printVerb VERB_TRANSLATE "Bad RHS in VOIDdec: (LENGTHop  v)\n" ; 
                           translateFlLetExpr  inames rnames  prefix "fail'name" p t result   )
       | (EMPTYop  (v , ty)) => (printVerb VERB_TRANSLATE "Bad RHS in VOIDdec: (EMPTYop  (v , Ty))\n" ;  
                                 translateFlLetExpr  inames rnames  prefix "fail'name" p t result   )
       | (FTOIop  v) => (printVerb VERB_TRANSLATE "Bad RHS in VOIDdec: (FTOIop  v)\n" ; 
                         translateFlLetExpr  inames rnames  prefix "fail'name" p t result   )
       | (ITOFop  v) => (printVerb VERB_TRANSLATE "Bad RHS in VOIDdec: (ITOFop  v)\n" ; 
                         translateFlLetExpr  inames rnames  prefix "fail'name" p t result   )

(*
       | _ => translateFlLetExpr  inames rnames  prefix "fail'name" p t result   
*)      


and translateFlLetExpr inames rnames prefix id p t result =
    	if (is_elem id inames)
    	then  Leti(prefix^id, translatePrimOp inames rnames prefix p, 
		   translateLetExpr inames rnames prefix t result)
    	else if (is_elem id rnames)
 	     then  Letr(prefix^id, translatePrimOp inames rnames prefix p, 
			translateLetExpr inames rnames prefix t result)
             else (printVerb VERB_TRANSLATE ("translateFlLetExpr (with "^(id)^")") ; 
                   Ill_Expr ("Letr: Error in lifting r-val constant "^id))


and translateResult ideclared rdeclared prefix (PRIMres p) = translatePrimRes ideclared rdeclared prefix p
  | translateResult ideclared rdeclared prefix (CHOICEres (v, tst, w, p1, p2)) =
    (
    testcounter := 1+(!testcounter);
    let val newtest = prefix^"q_"^(Int.toString(!testcounter))
        val vname = translateOperand ideclared rdeclared false "" prefix v
        val wname = translateOperand ideclared rdeclared false "" prefix w
        val translatedif = 
             Ifg(newtest, 
                 translatePrimRes ideclared rdeclared prefix p1 , 
                 translatePrimRes ideclared rdeclared prefix p2)
    in case v of 
        (NULLval _) => Leti(newtest, IsNull wname, (* ToyRPrimOp(rTestToToy(tst), vname, wname), *)
                            translatedif)  
      | _  => case w of 
              (NULLval _) => Leti(newtest, IsNull vname, (* ToyRPrimOp(rTestToToy(tst), vname, wname), *)
                                  translatedif)
      | _ => Leti(newtest, ToyPrimOp(testToToy(tst), vname, wname), translatedif)
    end
    )
  | translateResult _ _ _ _ = raise gdfError "translateResult: no matching case"

and translatePrimRes ideclared rdeclared prefix (OPres p) = translatePrimOp ideclared rdeclared prefix p 
(* HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK: 
  Faking translation of length to process full .gr programs *)
  | translatePrimRes ideclared rdeclared prefix (VOIDres) = (printVerb VERB_TRANSLATE "tranlsatePrimRes: translating VOIDres as Null"  ;  Null_("LLL",SOME("LLL")) )
  | translatePrimRes ideclared rdeclared prefix (FUNres (name, args)) = Call (prefix^(isa_name name))

and typeFromPrimOp ideclared rdeclared (VALop (INTval iconst)) = IntTy
  | typeFromPrimOp ideclared rdeclared (VALop (VARval vname))= typeFromVar ideclared rdeclared vname
  | typeFromPrimOp ideclared rdeclared (VALop (NULLval _ ))=  RefTy
  | typeFromPrimOp ideclared rdeclared (VALop (STRINGval _ ))=  RefTy
  | typeFromPrimOp ideclared rdeclared (BINop(b, v, w)) = IntTy
  | typeFromPrimOp ideclared rdeclared (NEWop(m,v)) = RefTy
  | typeFromPrimOp ideclared rdeclared (INVOKEVIRTUALop(var, MDESC(rty, name, typs) , params)) = typeFromGrailRTy rty
  | typeFromPrimOp ideclared rdeclared (INVOKESTATICop(MDESC(rty, name, typs) , params)) = typeFromGrailRTy rty
  | typeFromPrimOp ideclared rdeclared (GETFIELDop(v, (FDESC(ty, name )))) = typeFromGrailTy ty
  | typeFromPrimOp ideclared rdeclared (PUTFIELDop(v, (FDESC(ty, name )), w)) = typeFromGrailTy ty
  | typeFromPrimOp ideclared rdeclared (GETSTATICop(FDESC(ty, name ))) = RefTy (* typeFromGrailTy ty*)
  | typeFromPrimOp ideclared rdeclared (PUTSTATICop(FDESC(ty, name ), w)) = RefTy (*typeFromGrailTy ty*)

  | typeFromPrimOp ideclared rdeclared (MAKEop v)   = FailTy
   (* HACK: only array we have for now is array of strings passed to main *)
  | typeFromPrimOp ideclared rdeclared (GETop v)    = RefTy
  | typeFromPrimOp ideclared rdeclared (SETop v)    = FailTy
  | typeFromPrimOp ideclared rdeclared (LENGTHop v) = IntTy
  | typeFromPrimOp ideclared rdeclared (EMPTYop v)  = FailTy
  | typeFromPrimOp ideclared rdeclared (FTOIop v)   = IntTy
  | typeFromPrimOp ideclared rdeclared (ITOFop v)   = FailTy 

  | typeFromPrimOp ideclared rdeclared   _ = FailTy

and typeFromVar ideclared rdeclared vname =
     if (is_elem vname ideclared)
     then IntTy
     else if (is_elem vname rdeclared)
          then RefTy
          else FailTy

and translatePrimOp ideclared rdeclared prefix (VALop v) = translateNonOperand ideclared rdeclared prefix v
  | translatePrimOp ideclared rdeclared prefix (BINop(b, v, w)) =
    ToyPrimOp(binOpToToy(b),
              translateOperand ideclared rdeclared false "iname" prefix v,
              translateOperand ideclared rdeclared false "iname" prefix w)


(* so far only one refernce parameter is supported *)
  | translatePrimOp ideclared rdeclared prefix (INVOKEVIRTUALop(var, MDESC(rty, name, typs) , args)) =  (* (h :: []))) =  *)
        Invoke(prefix^(isa_name var), isa_name name, 
               translateOperands ideclared rdeclared typs prefix args)

  | translatePrimOp ideclared rdeclared prefix (INVOKESTATICop(MDESC(rty, name, typs) , args)) =  (* (h :: []))) = *)
    let val cname = (substrBeforeToken #"." name)
        val short_ftype = getShortFunType rty typs
        val mn = if (cname = "DIAM") (* HWL: take predefined methods as are *)
                   then name
                   else tr (isa_name name)
        val mn' = if (String.substring(mn,(String.size mn)-1,1) = (str #"&"))
              	    then ((String.substring(mn,0,(String.size mn)-1))^"_"^
                          (String.substring(short_ftype,2,(String.size short_ftype)-3)))
              	    else mn   
    in InvokeStatic(isa_name cname, mn', (* isa_name name,  *)
                    translateOperands ideclared rdeclared typs prefix args)
    end
      
  | translatePrimOp ideclared rdeclared prefix (INVOKESPECIALop(v, MDESC(rty, name, typs) , args)) =  (* (h :: []))) = *)
    InvokeVirtual(isa_name v, isa_name name,
                     translateOperands ideclared rdeclared typs prefix args)
      
  | translatePrimOp ideclared rdeclared prefix (GETFIELDop(v, (FDESC(ty, name )))) = 
    (case ty of
             INTty  => GetFi(prefix^(isa_name v), isa_name name) (* (String.map pointToPrime (name)))  *)
           | (REFty _) => GetFr(prefix^(isa_name v), isa_name name) (* (String.map pointToPrime (name)))*)
           | _     => Ill_Expr "GetFi/r: Mis-typed field"
      )

  | translatePrimOp ideclared rdeclared prefix (PUTFIELDop(v,(FDESC(ty, name )) , w)) = 
    let val wname = translateOperand ideclared rdeclared false "" prefix w 
    in case ty of
         INTty       => PutFi(prefix^(isa_name v), isa_name name, (isa_name wname))
       | (REFty _ ) => PutFr(prefix^(isa_name v), isa_name name, (isa_name wname))
       | _  => Ill_Expr "PutFi/r: Mis-typed field"
    end
   

  | translatePrimOp ideclared rdeclared prefix (GETSTATICop(FDESC(ty, name ))) = 
    let val cname =  !mycname  (* (substrBeforeToken #"." name) *)
    in case ty of
             INTty  => GetStat(cname, isa_name name)
           | (REFty _) => GetStat(cname, isa_name name)
           | _     => (printVerb VERB_TRANSLATE ("translatePrimOp (GETSTATICop ...  failed with " ^ name) ;
                       Ill_Expr "GetStaticFi/r: Mis-typed field")
    end

  | translatePrimOp ideclared rdeclared prefix (PUTSTATICop(FDESC(ty, name ) , w)) = 
    let val wname = translateOperand ideclared rdeclared false "" prefix w 
        val cname = !mycname (*  (substrBeforeToken #"." name)  *)
    in case ty of
         INTty      => PutStat(isa_name cname, isa_name name, (isa_name wname))
       | (REFty _ ) => PutStat(isa_name cname, isa_name name, (isa_name wname))
       | _  => (printVerb VERB_TRANSLATE ("translatePrimOp (PUTSTATICop ...  failed with " ^ name) ;
                Ill_Expr "PutStaticFi/r: Mis-typed field")
    end 

  | translatePrimOp  ideclared rdeclared prefix (NEWop(MDESC(rty, name, typs),l)) = 
      let val (iflds, rflds, failns)  = getFlds name
          val (inames, rnames, failnames) = splitListNames ideclared rdeclared prefix typs l 
      in  New_(name, ListPair.zip(iflds, inames), ListPair.zip(rflds, rnames))
      end

  | translatePrimOp ideclared rdeclared prefix (MAKEop v) = (printVerb VERB_TRANSLATE "Unknown lang item in translatePrimOP: (MAKEop v)" ; 
                                                             Ill_Expr "Make: Arrays not supported")
(* HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK HACK: 
  Faking translation of length to process full .gr programs *)
  | translatePrimOp ideclared rdeclared prefix (GETop v) = ( Null_("LLL",SOME("LLL")) )
  | translatePrimOp ideclared rdeclared prefix (SETop v) = (printVerb VERB_TRANSLATE "Unknown lang item in translatePrimOP: (SETop v)" ; Ill_Expr "Set: Arrays not supported")
  | translatePrimOp ideclared rdeclared prefix (LENGTHop v) = (Int_ 0 )
  | translatePrimOp ideclared rdeclared prefix (EMPTYop v) = (printVerb VERB_TRANSLATE "Unknown lang item in translatePrimOP: (EMPTYop v)" ; Ill_Expr "Empty: Arrays not supported")
  | translatePrimOp ideclared rdeclared prefix (FTOIop v) = (printVerb VERB_TRANSLATE "Unknown lang item in translatePrimOP: (FTOIop v)" ; Ill_Expr "FTOI: Floats not supported")
  | translatePrimOp ideclared rdeclared prefix (ITOFop v) = (printVerb VERB_TRANSLATE "Unknown lang item in translatePrimOP: (ITOFop v)" ; Ill_Expr "ITOF: Floats not supported")

  | translatePrimOp ideclared rdeclared prefix (CHECKCASTop (str, v)) = (printVerb VERB_TRANSLATE "Unknown lang item in translatePrimOP: CHECKCASTop (str, v)" ; Ill_Expr "Checkcast: Casts not supported")
  | translatePrimOp ideclared rdeclared prefix (INSTANCEop (str,v)) = (printVerb VERB_TRANSLATE "Unknown lang item in translatePrimOP: INSTANCEop (str,v)" ; Ill_Expr "Instance: Casts not supported")

  | translatePrimOp ideclared rdeclared prefix   _ = (printVerb VERB_TRANSLATE "Unknown lang item in translatePrimOP" ; Ill_Expr "Unknown lang item in translatePrimOP")

(*   | translatePrimOp _ _ _ _ = raise gdfError "translatePrimOp: no matching case" *)

(* A non-operand value must be an expression *)
and translateNonOperand ideclared rdeclared prefix (INTval iconst) = Int_ iconst
  | translateNonOperand ideclared rdeclared prefix (VARval vname) = 
       let val ty = typeFromVar ideclared rdeclared vname
       in case ty of 
          IntTy => IVar (prefix^vname)
        | RefTy => RVar (prefix^vname)
        | _     => (printVerb VERB_TRANSLATE "translateNonOperand: Ill_Expr" ; Ill_Expr "translateNonOperand: Ill_Expr")
       end
   | translateNonOperand ideclared rdeclared prefix (NULLval s )  = Null_ s
   | translateNonOperand ideclared rdeclared prefix (STRINGval s) = String_ (add_string_to_table s)
   | translateNonOperand ideclared rdeclared prefix  _            = Ill_Expr "translateNonOperand: Ill_Expr"

(* HWL added
and translateArg (INarg x)  = "INarg x"
  | translateArg (RNarg x)  = "RNarg x"
  | translateArg (VALarg x) = "VALarg x"
*)
(*
and stringFromType IntTy = "iname"
  | stringFromType RefTy = "rname"
  | stringFromType FailTy  = ""
*)
and stringFromType BYTEty   = "FailTy"
  | stringFromType CHARty   = "FailTy"
  | stringFromType DOUBLEty = "FailTy"
  | stringFromType FLOATty  = "FailTy"
  | stringFromType INTty    = "iname"
  | stringFromType LONGty   = "FailTy"
  | stringFromType SHORTty  = "FailTy"
  | stringFromType BOOLEANty  = "iname"
  | stringFromType (REFty _) = "rname"
  | stringFromType (ARRAYty _) = "FailTy"

(* HWL added *)
and translateOperands'  ideclared rdeclared atylist prefix  = 
    let 
       val xs = map (fn (arg,typ) => translateOperand ideclared rdeclared true (stringFromType typ) prefix arg) atylist
    in 
       "[" ^ (foldr (fn (x,xs) => (if (xs="") then x else (x^", "^xs))) "" xs) ^ "]"
    end

and translateOperands  ideclared rdeclared typlist prefix arglist  = 
    translateOperands'  ideclared rdeclared (ListPair.zip(arglist, typlist)) prefix 

(* an operand value must be a name or an integer value; other values need to be names *)
and translateOperand  ideclared rdeclared print_type typ prefix (INTval iconst)  = 
    if print_type
      then ("VALarg (IVal "^(Int.toString (apply_tag_subst (!global_subst) iconst))^")") (* HWL: added type in arg list! *) (* (if (iconst>(!tag_offset)) then iconst-(!tag_offset) else iconst) *)
      else (prefix^(intToName iconst))

| translateOperand ideclared rdeclared print_type  typ prefix (VARval vname) = 
  if (typ="") 
  then prefix^(isa_name vname)
  else let val ty = typeFromVar ideclared rdeclared vname
       in case ty of 
          	IntTy => if (typ="iname")
                   then  if print_type
                           then "INarg "^(unqual_name (prefix^(isa_name vname)))    (* HWL: added type in arg list! but unqualified name now *)
                           else prefix^(isa_name vname)
                   else (prefix^"fail'"^(isa_name vname))
        	| RefTy => if (typ="rname")
                   then if print_type
                           then "RNarg "^(unqual_name (prefix^(isa_name vname)))   (* HWL: added type in arg list! but unqualified name now *)
                           else prefix^(isa_name vname)
                   else (prefix^"fail'"^(isa_name vname))
        	| _ => (prefix^"fail'"^(isa_name vname))
      end
| translateOperand ideclared rdeclared print_type typ prefix (NULLval s )  = 
  if print_type
    then "RNarg "^(unqual_name (prefix^"Null'GenVar"))
    else prefix^"Null'GenVar"
| translateOperand ideclared rdeclared print_type typ prefix (STRINGval s )  =
  if print_type
    then "RNarg "^(unqual_name (prefix^(add_string_to_table s))) (* (unqual_name (prefix^(stringToName s))) *)
    else (unqual_name (prefix^(add_string_to_table s)))          (* (unqual_name (prefix^(stringToName s))) *)
| translateOperand ideclared rdeclared print_type typ prefix  _ = if print_type 
                                                                   then "RNarg "^(unqual_name (prefix^"fail'operand" ))
                                                                   else prefix^"fail'operand" 


and splitListNames ideclared rdeclared prefix [] [] = ([], [], [])
  | splitListNames ideclared rdeclared prefix (htype::ttype) (hvalue::tvalue) =
    let val (inamest, rnamest, failnamest) = splitListNames ideclared rdeclared prefix ttype tvalue
        val newname = translateOperand  ideclared rdeclared false "" prefix hvalue
    in case htype of 
         INTty => (newname ::inamest, rnamest, failnamest)
         | (REFty _) => (inamest, newname :: rnamest, failnamest)
         | _ => (inamest, rnamest,  newname :: failnamest)
    end
  | splitListNames ideclared rdeclared prefix _ _ = ([], [], [])

(* ----------------------------------------------------------------------- *)
(* ------ PRINTING TO ISABELLE THEORY ------------------------------------ *)

and printToyPROG  thy toycname (ToyCDEF(cnames, mnames, ifldnames, rfldnames, funames, 
                               exprnames, inames, rnames, failnames, exprs, meth_param_map)) (printCertC,data_layout,tagOffset,thySyntax,tFlavour)  =
    (
     (* Values of generateThy
	1 : default (default assigned below)
	2 : ToyGrail
	3 : BytecodeLogic *)
    let 
	(* val default = 3(*bcl*) *)
        (* val (printCertC,dataLayout,tagOffset,thySyntax) = decode_syntax thySyntax *)
	(* val () = data_layout := (Int.toString (10*dataLayout))  *)
	val () = tag_offset := tagOffset
        val () = printVerb VERB_MIN ("\nData layout: "^(Int.toString data_layout))
        val () = printVerb VERB_MIN ("\nTag Offset: "^(Int.toString (!tag_offset)))
(*		 
	val _ = TextIO.print (" thySyntax= " ^ Int.toString thySyntax ^
                       "  printCerC= " ^ Bool.toString printCertC ^
                       "  dataLayout= " ^ Int.toString dataLayout ^
                       "  thySyntax= " ^ Int.toString thySyntax)
*)
    in
	case thySyntax of

(********************************)
(* SYNTAX FOR TOYGRAIL THY FILE *)
(********************************)
	    2(*toy*)=>(
	    PrlF thy "(* This file was automatically generated by gdf *)\n";
	    PrF thy ("theory "^toycname^" = ToyHLderived :\n");
	    PrlF thy "\nconstdefs\nupperbound :: nat\n\"upperbound == 0\""; 
	    PrlF thy ("\nlocale "^toycname^"_example = \n"); 
	    PrF thy "fixes  ";
	    prseparator := 0;
	    printNames thySyntax thy "cname" cnames;
	    printNames thySyntax thy "\"'a expr\"" exprnames;
	    printNames thySyntax thy "mname" mnames;
	    printNames thySyntax thy "funame" funames;
	    printNames thySyntax thy "ifldname" ifldnames;
	    printNames thySyntax thy "rfldname" rfldnames;
	    printNames thySyntax thy "iname" inames;
	    printNames thySyntax thy "rname" rnames;

	    if not (List.null failnames)
	    then PrlF thy "The following names caused type checking error:"
	    else ();
	    printNames thySyntax thy "failname" failnames;
   
	    PrlF thy ("\ndefines");
	    printExps thy exprnames exprs thySyntax; 

	    PrF thy "\n\nassumes";
	    prseparator := 0;
	    printMap  thy "m" mnames thySyntax;
	    printMap  thy "f" funames thySyntax;

(*LENB11/12/2004: Commented this out since it results in richtypes being of type string
	    case resource_predicates of 
		NONE => ()
	      | SOME rp => (
			    PrlF thy "\n\n\n(* ------- Resource predicates ------- *)\n";
			    PrlF thy rp
			    );
	    printLemma thy toycname mnames rnames;
*)

	    PrlF thy "\n\nend")


(*************************************)
(* SYNTAX FOR BYTECODELOGIC THY FILE *)
(*************************************)
	  | 3(*bcl*)=>(
	    PrlF thy ("(* This file was automatically generated by gdf at " ^ (Stardate.stardate ()) ^ "*)\n");
	    PrF thy ("theory "^toycname^" = DAss_rulesU + NILList :\n"); (* should pick logic version and ADT module based on the PRAGMA in the Camelot source code *)
	    prseparator := 0;

	    PrF thy ("consts");
	    printNames thySyntax thy "cname" (map isa_name cnames); (* isa_name should be done earlier *)
	    printNames thySyntax thy "expr" exprnames;
	    printNames thySyntax thy "mname" mnames;
	    printNames thySyntax thy "funame" funames;
	    printNames thySyntax thy "ifldname" ifldnames;
	    printNames thySyntax thy "rfldname" rfldnames;
	    printNames thySyntax thy "iname" inames;
	    printNames thySyntax thy "rname" rnames;

            PrlF thy ("\naxioms fun_distinct:");
            PrlF thy ("\"distinct[" ^ (foldr (fn (x,xs) => (if (xs="") then x else (x^", "^xs))) "" funames) ^ "]\"");

            PrlF thy ("\naxioms ifld_distinct:");
            PrlF thy ("\"distinct[" ^ (foldr (fn (x,xs) => (if (xs="") then x else (x^", "^xs))) "" ifldnames) ^ "]\"");

            PrlF thy ("\naxioms rfld_distinct:");
            PrlF thy ("\"distinct[" ^ (foldr (fn (x,xs) => (if (xs="") then x else (x^", "^xs))) "" rfldnames) ^ "]\"");

            PrlF thy ("\naxioms iname_distinct:");
            PrlF thy ("\"distinct[" ^ (foldr (fn (x,xs) => (if (xs="") then x else (x^", "^xs))) "" inames) ^ "]\"");

            PrlF thy ("\naxioms rname_distinct:");
            PrlF thy ("\"distinct[" ^ (foldr (fn (x,xs) => (if (xs="") then x else (x^", "^xs))) "" rnames) ^ "]\"");

	    PrlF thy ("\nlemmas all_distinct = fun_distinct  ifld_distinct rfld_distinct iname_distinct rname_distinct");

	    if not (List.null failnames)
	    then PrlF thy "The following names caused type checking error:"
	    else ();
	    printNames thySyntax thy "failname" failnames;

            (* not needed if bodies are expanded; preferred 
            PrlF thy "\n(*\n";
	    PrlF thy "\ndefs";
	    printExps thy exprnames exprs thySyntax; 

	    printMap  thy "m" mnames thySyntax;

	    printMap  thy "f" funames thySyntax;

            PrlF thy "\n*)\n";
	    *)
(*             PrlF thy "\n--- DEBUG DEBUG DEBUG DEBUG DEBUG DEBUG DEBUG DEBUG \n"; *)
(* 	    printAlist thy (ListPair.zip (exprnames,exprs)) ; *)
(*             PrlF thy "\n+++ DEBUG DEBUG DEBUG DEBUG DEBUG DEBUG DEBUG DEBUG \n"; *)

	    printMapExpandBodies  thy "m" meth_param_map mnames exprnames exprs thySyntax;

	    printMapExpandBodies  thy "f" meth_param_map funames exprnames exprs thySyntax;

(*LENB11/12/2004: Commented this out since it results in richtypes being of type string
	    case resource_predicates of 
		NONE => ()
	      | SOME rp => (
			    PrlF thy "\n\n\n(* ------- Resource predicates ------- *)\n";
			    PrlF thy rp
			    );
	    printLemma thy toycname mnames rnames;
	    *)

	    PrlF thy "\n\nend")


	  | 4(*dal*)=>(
	    PrlF thy ("(* This file was automatically generated by gdf at " ^ (Stardate.stardate ()) ^ "*)\n");
	    PrlF thy ("(* Logic version used: dal *)\n");
	    PrlF thy ("(* Data layout: " ^ (Int.toString data_layout) ^ " *)\n");
	    prseparator := 0;

	    PrF thy ("theory "^toycname^" = DAss_rulesU + NILList :\n"); (* should pick logic version and ADT module based on the PRAGMA in the Camelot source code *)

	    PrF thy ("\nsyntax");
	    printNames thySyntax thy "cname" (map isa_name cnames); (* isa_name should be done earlier *)
	    printNames thySyntax thy "expr" exprnames;
	    printNames thySyntax thy "mname" mnames;
	    printNames thySyntax thy "funame" funames;
            (*
	    printNames thySyntax thy "ifldname" ifldnames;
	    printNames thySyntax thy "rfldname" rfldnames;
            *)
	    printNames thySyntax thy "iname" inames;
	    printNames thySyntax thy "rname" rnames;

	    PrF thy ("\n\ntranslations");
	    printTranslations thySyntax thy "cname" (map isa_name cnames);
	    printTranslations thySyntax thy "mname" mnames;
	    printTranslations thySyntax thy "funame" funames;
            (*
	    printTranslations thySyntax thy "ifldname" ifldnames;
	    printTranslations thySyntax thy "rfldname" rfldnames;
            *)
	    printTranslations thySyntax thy "iname" inames;
	    printTranslations thySyntax thy "rname" rnames;


	    if not (List.null failnames)
	    then PrlF thy "The following names caused type checking error:"
	    else ();
	    printNames thySyntax thy "failname" failnames;

	    printMapExpandBodies  thy "m" meth_param_map mnames exprnames exprs thySyntax;

	    printMapExpandBodies  thy "f" meth_param_map funames exprnames exprs thySyntax;

(*LENB11/12/2004: Commented this out since it results in richtypes being of type string
	    case resource_predicates of 
		NONE => ()
	      | SOME rp => (
			    PrlF thy "\n\n\n(* ------- Resource predicates ------- *)\n";
			    PrlF thy rp
			    );
	    printLemma thy toycname mnames rnames;
	    *)

	    PrlF thy "\n\nend")

	  | 5(*vcg*)=>(
	    PrlF thy ("(* This file was automatically generated by gdf at " ^ (Stardate.stardate ()) ^ "*)\n");
	    PrlF thy ("(* Logic version used: vcg *)\n");
	    PrlF thy ("(* Data layout: " ^ (Int.toString data_layout) ^ " *)\n");
	    PrlF thy ("(* Tag offset: " ^ (Int.toString tagOffset) ^ " *)\n");
	    prseparator := 0;

	    PrF thy ("theory "^toycname^" = SlackVCG :\n"); (* should pick logic version and ADT module based on the PRAGMA in the Camelot source code *)

	    PrF thy ("\nsyntax");
	    printNames thySyntax thy "cname" (map isa_name cnames); (* isa_name should be done earlier *)
	    printNames thySyntax thy "expr" exprnames;
	    printNames thySyntax thy "mname" mnames;
	    printNames thySyntax thy "funame" funames;
            (*
	    printNames thySyntax thy "ifldname" ifldnames;
	    printNames thySyntax thy "rfldname" rfldnames;
            *)
	    printNames thySyntax thy "iname" inames;
	    printNames thySyntax thy "rname" rnames;
	    printStringConstants thy 1;

	    PrF thy ("\n\ntranslations");
	    printTranslations thySyntax thy "cname" (map isa_name cnames);
	    printTranslations thySyntax thy "mname" mnames;
	    printTranslations thySyntax thy "funame" funames;
            (*
	    printTranslations thySyntax thy "ifldname" ifldnames;
	    printTranslations thySyntax thy "rfldname" rfldnames;
            *)
	    printTranslations thySyntax thy "iname" inames;
	    printTranslations thySyntax thy "rname" rnames;
	    printStringTranslations thy 1;


	    if not (List.null failnames)
	    then PrlF thy "The following names caused type checking error:"
	    else ();
	    printNames thySyntax thy "failname" failnames;

	    printVersioning thy toycname;

	    (* Debugging only 
            PrlF thy "(* DUMP of functions in meth_param_map";
            dump_meth_param_map_full thy "f" meth_param_map funames;
            PrlF thy "*)";

            PrlF thy "(* DUMP of methods in meth_param_map";
            dump_meth_param_map_full thy "m" meth_param_map funames;
            PrlF thy "*)";
	    *)

	    printMapExpandBodies  thy "m" meth_param_map mnames exprnames exprs thySyntax;

	    printMapExpandBodies  thy "f" meth_param_map funames exprnames exprs thySyntax;

(*LENB11/12/2004: Commented this out since it results in richtypes being of type string
	    case resource_predicates of 
		NONE => ()
	      | SOME rp => (
			    PrlF thy "\n\n\n(* ------- Resource predicates ------- *)\n";
			    PrlF thy rp
			    );

	    printLemma thy toycname mnames rnames; 
*)

	    (if true orelse not printCertC (* now all certgen is done in CertGen[PC] *)
              then ()
              else (let
		      val className = toycname
                      val thyCert = TextIO.openOut (className^"Certificate23.thy")
                      val () = PrlF thyCert ("theory "^className^"Certificate23 = "^className^"Certificate1:")
                      val () = PrlF thyCert ("\nsection {* Certificate2: Correctness lemmas *}\n")
                      val () = PrlF thyCert ("method_setup Wp = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => Method.METHOD (fn facts => w_tac (thms \"meth_defs\") (l_tac6 (thms \"dmp_defs\", thms \"meth_defs\", pdefs, thms \"ctxt_def\")) ctxt 1)) *}\n \"parametric Method for starting: use weakening, simplification with args, fast\"\n");
                      val () = printCorrectnessLemmas thyCert toycname mnames rnames;
                      val () = PrlF thyCert ("\nlemmas MethodbodiesCorrect =  "^
                      (concat (map (fn mn => 
                                      if (is_elem (substrAfterToken #"'" mn) ignore_mnames) 
                                        then ""
                                        else (unqual_name mn)^"_Correct ") 
                                    mnames))^"\n")

                      val () = PrlF thyCert ("\nsection {* Certificate3: goodContext proof *}\n")
                      val () = PrlF thyCert ("\nlemma triv: \"\\<lbrakk>x:S; S=S1; x:S1 \\<longrightarrow> P\\<rbrakk>\\<Longrightarrow> P\" by simp\nlemma Context_good: \"goodContext FST vMST sMST Context\"\napply (simp only: goodContext_def)\napply (intro strip)\napply (rule disjI2)+\napply (erule triv, simp add: ctxt_def,safe)\nby (simp add: sMST_def, intro strip, rule vdm_conseq,\n rule MethodbodiesCorrect,intro strip,simp add: SPEC_def , erule DAss_PConst)+\n")
                      (* need proper way to extract `main' method to certify
                      val () = printLemma thyCert toycname (List.last mnames) (case (lookup (List.last mnames) meth_param_map) of NONE => "(* ERROR: no arg for "^(List.last mnames)^" recorded *)" | (SOME arg) => arg)
                      *)

                      val () = PrlF thyCert ("end")

		      val () = TextIO.closeOut thyCert
		    in
		     ()
		    end));

	    PrlF thy "\n\nend")

	  | 6(*mrg*)=>(
	    PrlF thy ("(* This file was automatically generated by gdf at " ^ (Stardate.stardate ()) ^ "*)\n");
	    PrlF thy ("(* Logic version used: MRG *)\n");
	    PrlF thy ("(* Data layout and tag offset extracted from metadata and not hardcoded *)\n");
	    prseparator := 0;

	    PrF thy ("theory "^toycname^" = TreeVCG:\n"); (* should pick logic version and ADT module based on the PRAGMA in the Camelot source code *)

	    PrF thy ("\nsyntax");
	    printNames thySyntax thy "cname" (map isa_name cnames); (* isa_name should be done earlier *)
	    printNames thySyntax thy "expr" exprnames;
	    printNames thySyntax thy "mname" mnames;
	    printNames thySyntax thy "funame" funames;
            (*
	    printNames thySyntax thy "ifldname" ifldnames;
	    printNames thySyntax thy "rfldname" rfldnames;
            *)
	    printNames thySyntax thy "iname" inames;
	    printNames thySyntax thy "rname" rnames;
	    printStringConstants thy 1;

	    PrF thy ("\n\ntranslations");
	    printTranslations thySyntax thy "cname" (map isa_name cnames);
	    printTranslations thySyntax thy "mname" mnames;
	    printTranslations thySyntax thy "funame" funames;
            (*
	    printTranslations thySyntax thy "ifldname" ifldnames;
	    printTranslations thySyntax thy "rfldname" rfldnames;
            *)
	    printTranslations thySyntax thy "iname" inames;
	    printTranslations thySyntax thy "rname" rnames;
	    printStringTranslations thy 1;


	    if not (List.null failnames)
	    then PrlF thy "The following names caused type checking error:"
	    else ();
	    printNames thySyntax thy "failname" failnames;

	    printVersioning thy toycname;

	    (* Debugging only 
            PrlF thy "(* DUMP of functions in meth_param_map";
            dump_meth_param_map_full thy "f" meth_param_map funames;
            PrlF thy "*)";

            PrlF thy "(* DUMP of methods in meth_param_map";
            dump_meth_param_map_full thy "m" meth_param_map funames;
            PrlF thy "*)";
	    *)

	    printMapExpandBodies  thy "m" meth_param_map mnames exprnames exprs thySyntax;

	    printMapExpandBodies  thy "f" meth_param_map funames exprnames exprs thySyntax;
	    PrlF thy "\n\nend")

(************************************)
(* UNRECOGNISED SYNTAX FOR THY FILE *)
(************************************)
	  | x => raise (gdfError("Not a recognised logic ("^Int.toString x^")\n"))

    end
    )

and printNames thySyntax thy ty [] = ()
  | printNames thySyntax thy ty (h::t) = 
    (if ((is_elem (substrAfterToken #"'" h) ignore_mnames) orelse
         (* check whether last but one in an expr decl is to be ignored *) 
	 ((ty = "expr") andalso 
 	  (List.length (splitBy #"'" h) > 1) andalso
 	  (is_elem (List.nth ((splitBy #"'" h),((List.length (splitBy #"'" h))-2))) ignore_mnames))) 
       then printNames thySyntax thy ty t  (* ignore this mname *)
       else (if (!prseparator>0) then
	       case thySyntax of
	           2(*toy*)=>PrF thy "and    "
	         | 3(*bcl*)=>PrF thy "      "
	         | 4(*dal*)=>PrF thy "      "
	         | 5(*vcg*)=>PrF thy "      "
	         | 6(*mrg*)=>PrF thy "      "
	         | _ => ()
     	     else prseparator :=1;
     	     PrlF thy ((if (ty = "cname" (*orelse ty = "mname" orelse ty = "funame"*)) then h else (unqual_name h))^" :: "^ty);
     	     printNames thySyntax thy ty t
           )
    )

(* syntax translations; for dal only; similar to printNames *)
and printTranslations thySyntax thy ty [] = ()
  | printTranslations thySyntax thy ty (h::t) = let
     val _ = 
      if ((is_elem (substrAfterToken #"'" h) ignore_mnames) orelse
         (* check whether last but one in an expr decl is to be ignored *) 
	 ((ty = "expr") andalso 
 	  (List.length (splitBy #"'" h) > 1) andalso
 	  (is_elem (List.nth ((splitBy #"'" h),((List.length (splitBy #"'" h))-2))) ignore_mnames))) 
       then printTranslations thySyntax thy ty t  (* ignore this mname *)
       else (if (!prseparator>0) then
	       case thySyntax of
	           2(*toy*)=>PrF thy "and    "
	         | 3(*bcl*)=>PrF thy "      "
	         | 4(*dal*)=>PrF thy "      "
	         | 5(*vcg*)=>PrF thy "      "
	         | 6(*mrg*)=>PrF thy "      "
	         | _ => ()
     	     else prseparator :=1;
             (case lookup ty isaTagOfTy of
                 SOME theTag => PrlF thy ("\""^(if (ty = "cname" (*orelse ty = "mname" orelse ty = "funame"*)) then h else (unqual_name h))^"\" == \"("^theTag^" ''"^(nam_counter:=(!nam_counter)+1;short_nam (!nam_counter))^"_'') \" (*"^h^"*)")(* HWL: chop off class and variable names *)
               | NONE => ()))
     	val _ = printTranslations thySyntax thy ty t
       in
         () (* YUCK *)
       end

and printMap thy ty [] _ = ()
  | printMap thy ty (h::t) thySyntax =
    let val () = printMapElement thy ty h thySyntax
    in printMap thy ty t thySyntax
    end

and printMapExpandBodies thy ty meth_param_map [] es exprs _ = ()
  | printMapExpandBodies thy ty meth_param_map (h::t) es exprs thySyntax =
    if (not (is_elem (substrAfterToken #"'" h) ignore_mnames))
      then let val () = printMapElementExpandBodies thy ty meth_param_map h es exprs thySyntax
	   in printMapExpandBodies thy ty meth_param_map t es exprs thySyntax
	   end
      else printMapExpandBodies thy ty meth_param_map t es exprs thySyntax

and printMapElement thy ty elem thySyntax =
    ( case thySyntax of
	  2(*toy*) => 
	  ( if (!prseparator > 0)
	    then PrF thy "\n and   "
	    else (prseparator:=1;
		  PrF thy "\n       "
		 );
	    (case ty of 
		 "f" => PrF thy (elem^"_fnbdy: \"funtable  "^elem^" = "^elem^"Body\"")
               | "m" => let val clname = substrBeforeToken #"'" elem
			in PrF thy (elem^"_mtbdy: \"methtable "^clname^"  "^elem^" = "^elem^"Body\"")
			end
               |  _  =>  PrlF thy "WRONG CALL OF PRINTMAP FUNCTION"
	    )
	  )
	| 3(*bcl*) =>
	  ( PrlF thy "\n";
	    case ty of
		"f" => ( PrlF thy ("axioms Fun_"^elem^":\n\"funtable "^elem^" = "^elem^"Body\"");
			 PrlF thy ("lemma \"funtable "^elem^" = "^elem^"Body\"\nby (simp add: Fun_"^elem^")\n")
		       )
	      | "m" => ( let val clname = substrBeforeToken #"'" elem
			 in if (clname = !mycname)
                             then
			     (
                             PrlF thy ("axioms Meth_"^elem^":\n\"methtable "^clname^" "^elem^" = "^elem^"Body\"");
			     PrlF thy ("lemma \"methtable "^clname^" "^elem^" = "^elem^"Body\"\nby (simp add: Meth_"^elem^")\n")
                             )
                             else () (* ignore it, if it comes from another class *)
			 end
		       )
	      | _ => PrlF thy "WRONG CALL OF PRINTMAP FUNCTION"
	  )
	| 4(*dal*) =>
	  ( PrlF thy "\n";
	    case ty of
		"f" => ( PrlF thy ("axioms Fun_"^elem^":\n\"funtable "^elem^" = "^elem^"Body\"");
			 PrlF thy ("lemma \"funtable "^elem^" = "^elem^"Body\"\nby (simp add: Fun_"^elem^")\n")
		       )
	      | "m" => ( let val clname = substrBeforeToken #"'" elem
			 in if (clname = !mycname)
                             then
			     (
                             PrlF thy ("axioms Meth_"^elem^":\n\"methtable "^clname^" "^elem^" = "^elem^"Body\"");
			     PrlF thy ("lemma \"methtable "^clname^" "^elem^" = "^elem^"Body\"\nby (simp add: Meth_"^elem^")\n")
                             )
                             else () (* ignore it, if it comes from another class *)
			 end
		       )
	      | _ => PrlF thy "WRONG CALL OF PRINTMAP FUNCTION"
	  )
	| _ => ()
    ) 

and printMapElementExpandBodies thy ty meth_param_map elem es exprs thySyntax =
    case thySyntax of
	  2(*toy*) => let
	   val _ = if (!prseparator > 0)
	    	      then PrF thy "\n and   "
	    	      else (prseparator:=1;
	    	      	    PrF thy "\n       "
		           );
	   val _ = case ty of 
		 "f" => PrF thy (elem^"_fnbdy: \"funtable  "^elem^" = "^elem^"Body\"")
               | "m" => let val clname = substrBeforeToken #"'" elem
			in PrF thy (elem^"_mtbdy: \"methtable "^clname^"  "^elem^" = "^elem^"Body\"")
			end
               |  _  =>  raise gdfError "printMapElementExpandBodies: printed thingy neither function nor method"
         in
          () (* YUCK *)
         end
	| 3(*bcl*) => let
	    val _ =  PrlF thy "\n";
	    val _ =  
             case ty of
		"f" => ( PrlF thy ("axioms Fun_"^elem^"[simp]:\n\"funtable "^elem^" = ");
                         let val x = lookup (elem^"Body") (ListPair.zip (es,exprs)) 
                         in (case x of NONE => () | (SOME x') => printFlatExp thy x') end;
                         PrlF thy "\""
                       )
	      | "m" => ( let val clname = substrBeforeToken #"'" elem
			 in if (clname = !mycname)
                             then
			    (
			     PrlF thy ("axioms Meth_"^elem^"[simp]:\n\"methtable "^clname^" "^elem^" = ");

                             let val x = lookup elem meth_param_map
                             in (case x of NONE => () | (SOME x') => PrlF thy ("("^x'^",")) end;

                             let val x = lookup (elem^"'Body") (ListPair.zip (es,exprs)) 
                             in (case x of NONE => () | (SOME x') => printFlatExp thy x') end;
                             PrlF thy ")\""
                            )
                             else () (* ignore it, if it comes from another class *)
			     
			 end
		       )
               |  _  =>  raise gdfError "printMapElementExpandBodies: printed thingy neither function nor method"
            in
             () (* YUCK *)
            end
	| 4(*dal*) => let
	  val _ = PrlF thy "\n";
	  val _ = 
            case ty of
		"f" => ( PrlF thy ("axioms Fun_"^elem^":\n\"funtable "^elem^" = ");
                         let val x = lookup (elem^"Body") (ListPair.zip (es,exprs)) 
                         in (case x of NONE => () | (SOME x') => printFlatExp thy x') end;
                         PrlF thy "\""
                       )
	      | "m" => ( let val clname = substrBeforeToken #"'" elem
			 in if (clname = !mycname)
                             then
			    (
			     PrlF thy ("axioms Meth_"^elem^":\n\"methtable "^clname^" "^elem^" = ");

                             let val x = lookup elem meth_param_map
                             in (case x of NONE => () | (SOME x') => PrlF thy ("("^x'^",")) end;

                             let val x = lookup (elem^"'Body") (ListPair.zip (es,exprs)) 
                             in (case x of NONE => () | (SOME x') => printFlatExp thy x') end;
                             PrlF thy ")\""
                            )
                             else () (* ignore it, if it comes from another class *)
			     
			 end
		       )
               |  _  =>  raise gdfError "printMapElementExpandBodies: printed thingy neither function nor method"
          in
            () (* YUCK *)
          end
	| 5(*vcg*) => (* same as dal but with arguments for funtable too *)
	  let
	    val _ =  PrlF thy "\n"
	    val _ = 
             case ty of
		"f" => ( PrlF thy ("axioms Fun_"^elem^":\n\"funtable "^elem^" = \n");

                         let val x = lookup elem meth_param_map
                         in (case x of NONE => () | (SOME x') => PrlF thy ("("^x'^",")) end;
			 (* HACK: empty param list for all funtabs; unused anyway *)
			 (* PrlF thy ("([],"); *)

                         let val x = lookup (elem^"Body") (ListPair.zip (es,exprs)) 
                         in (case x of NONE => () | (SOME x') => printFlatExp thy x') end;
                         PrlF thy ")\""
                       )
	      | "m" => ( let val clname = substrBeforeToken #"'" elem
			 in if (clname = !mycname)
                             then
			    (
			     PrlF thy ("axioms Meth_"^elem^":\n\"methtable "^clname^" "^elem^" = \n");

                             let val x = lookup elem meth_param_map
                             in (case x of NONE => () | (SOME x') => PrlF thy ("("^x'^",")) end;

                             let val x = lookup (elem^"'Body") (ListPair.zip (es,exprs)) 
                             in (case x of NONE => () | (SOME x') => printFlatExp thy x') end;
                             PrlF thy ")\""
                            )
                             else () (* ignore it, if it comes from another class *)
			     
			 end
		       )
               |  _  =>  raise gdfError "printMapElementExpandBodies: printed thingy neither function nor method"
         in
          () (* YUCK *)
         end
	| 6(*mrg*) => let   (* exactly the same as vcg *)
	    val _ = 
             case ty of
		"f" => let
		         val el = unqual_name elem
	                 val _ = PrlF thy "\n"
                         val _ = PrlF thy ("axioms Fun_"^el^":\n\"funtable "^el^" = \n")

                         val x = lookup elem meth_param_map
                         val _ = case x of NONE => () | (SOME x') => PrlF thy ("("^x'^",")
			 (* HACK: empty param list for all funtabs; unused anyway *)
			 (* PrlF thy ("([],"); *)

                         val x = lookup (elem^"Body") (ListPair.zip (es,exprs)) 
                         val _ = case x of NONE => () | (SOME x') => printFlatExp thy x'
                         val _ = PrlF thy ")\""
                       in
                        () (* YUCK *)
		       end
	      | "m" => let
		         val el = unqual_name elem
                         val clname = substrBeforeToken #"'" elem
			 val _ = if (clname = !mycname)
                                   then
				     let 
				       val _ = PrlF thy ("axioms Meth_"^el^":\n\"methtable "^clname^" "^el^" = \n")

                                       val x = lookup elem meth_param_map
                                       val _ = case x of NONE => () | (SOME x') => PrlF thy ("("^x'^",")

                                       val x = lookup (elem^"'Body") (ListPair.zip (es,exprs)) 
                                       val _ = case x of NONE => () | (SOME x') => printFlatExp thy x'
                                       val _ = PrlF thy ")\""
                       		     in
                       		      () (* YUCK *)
		       		     end            
                                   else
                                     () (* ignore it, if it comes from another class *)
                       in
                        () (* YUCK *)
		       end
               |  _  =>  raise gdfError "printMapElementExpandBodies: printed thingy neither function nor method"
             in
               () (* YUCK *)
             end
      | _ => raise gdfError ("printMapElementExpandBodies: unknown thy syntax :" ^ (Int.toString thySyntax) ^ "\n")
	  

and dump_meth_param_map thy ty meth_param_map [] = ()
  | dump_meth_param_map thy ty meth_param_map (f::fs) =
    let 
      val () = dump_meth_param_map_elem thy ty meth_param_map f
    in 
      dump_meth_param_map thy ty meth_param_map fs
    end

and dump_meth_param_map_elem thy ty meth_param_map elem =
	  ( PrlF thy "\n";
	    case ty of
		"f" => ( PrlF thy (" "^elem^" -> ");

                         let val x = lookup elem meth_param_map
                         in (case x of NONE => () | (SOME x') => PrlF thy ("("^x'^",")) end;
			 (* HACK: empty param list for all funtabs; unused anyway *)
			 PrlF thy ("\n")
                       )
	      | "m" => ( let val clname = substrBeforeToken #"'" elem
			 in if (clname = !mycname)
                             then
			    (
			     PrlF thy (" "^elem^" -> ");

                             let val x = lookup elem meth_param_map
                             in (case x of NONE => () | (SOME x') => PrlF thy ("("^x'^",")) end;
			     (* HACK: empty param list for all funtabs; unused anyway *)
			     PrlF thy ("\n")
                            )
                             else () (* ignore it, if it comes from another class *)
			     
			 end
		       )
	      | _ => PrlF thy "WRONG CALL OF PRINTMAP FUNCTION"
	  )

and dump_meth_param_map_full thy ty [] x = ()
  | dump_meth_param_map_full thy ty (m::ms) x =
    let 
      val () = dump_meth_param_map_full_elem thy ty m x
    in 
      dump_meth_param_map_full thy ty ms x
    end

and dump_meth_param_map_full_elem thy ty elem x =
	  ( PrlF thy "\n";
	    case ty of
		  "f" => (case elem of
                         (f,args) =>  PrlF thy ("F "^f^" -> "^args))
		| "m" => (case elem of
                         (f,args) => PrlF thy ("M "^f^" -> "^args) )
	      | _ => PrlF thy "WRONG CALL OF PRINTMAP FUNCTION"
	  )

and printExps thy [] [] _ = ()
  | printExps thy (h1::t1) [] _ = PrlF thy "ILL FORMED EXPRESSION LIST"
  | printExps thy [] (h2::t2) _ = PrlF thy  "ILL FORMED EXPRESSION LIST"
  | printExps thy (h1::t1) (h2::t2) thySyntax = 
    (
     case thySyntax of
	 2(*toy*) => (
	   PrlF thy ("\""^h1^" ==");
	   printFlatExp thy h2;
	   if (List.null t1)
	   then PrlF thy ("\"")
	   else PrF thy ("\n\"\nand    ");
	   printExps thy t1 t2 thySyntax
	 )
       | 3(*bcl*) => (
	   let val h1'' = (String.substring (h1, 0, (String.size(h1) - 4)))
	       val h1' = (if (false)
			  then (String.substring (h1'', 0, (String.size(h1'')-1)))
			  else h1'') in
	       PrlF thy (h1^": \""^h1^" == ");
	       printFlatExp thy h2;
	       PrlF thy ("\"\n");
	       (*
		PrlF thy ("\"\n\naxioms Fun_"^h1'^":");
		PrlF thy ("\"funtable "^h1'^" = "^h1^"\"\n");
		PrlF thy ("lemma \"funtable "^h1'^" = "^h1^"\"\n by (simp add: Fun_"^h1'^")\n");
		*)
	       printExps thy t1 t2 thySyntax
	   end
	 )
       | _ => ()
    )


and printFlatExp thy (Null_(s1,s2)) = PrF thy ("(expr.Null (*"^s1^"*) "^( 
                                       case s2 of
                                         NONE => "???"
                                       | SOME z => "(*"^z^"*) "^(apply_subst null_tags_TREELIST (apply_subst (fst3 (!global_subst)) z)))^") ")
  | printFlatExp thy (String_(sconst)) =  PrF thy ("RVar "^sconst)  (* (stringToName sconst)) HWLstrHACK *)
  | printFlatExp thy (Int_(iconst)) =  PrF thy ("expr.Int "^(Int.toString(iconst)))
  | printFlatExp thy (IVar(name)) =  PrF thy ("IVar "^(unqual_name name))
  | printFlatExp thy (RVar(name)) =  PrF thy ("RVar "^(unqual_name name))
  | printFlatExp thy (ToyPrimOp(p, name1, name2)) =  
     PrF thy ("Primop "^(toyBinOpToString p)^" "^(unqual_name name1)^" "^(unqual_name name2))
  | printFlatExp thy (ToyRPrimOp(p, name1, name2)) =  
     PrF thy ("RPrimop "^(toyRBinOpToString p)^" "^(unqual_name name1)^" "^(unqual_name name2))
  | printFlatExp thy (IsNull r) =  
     PrF thy ("RPrimop (%  x y . if x=Nullref then (1::int) else (0::int)) "^(unqual_name r)^" "^(unqual_name r))
  | printFlatExp thy (New_(name, ipairlist, rpairlist)) =  
         PrF thy ("NEW <"^(unqual_name name)^"> ( \n["^(pairListToString ipairlist)^"\n],\n["^(pairListToString rpairlist)^"\n]\n)")
  | printFlatExp thy (GetFi(name1, name2)) =  PrF thy ("GetFi "^(unqual_name name1)^" "^(tr name2))
  | printFlatExp thy (GetFr(name1, name2)) =  PrF thy ("GetFr "^(unqual_name name1)^" "^(tr name2))
  | printFlatExp thy (PutFi(name1, name2, name3)) =  PrF thy ("PutFi "^(unqual_name name1)^" "^(tr name2)^" "^(unqual_name name3))
  | printFlatExp thy (PutFr(name1, name2, name3)) =  PrF thy ("PutFr "^(unqual_name name1)^" "^(tr name2)^" "^(unqual_name name3))
  | printFlatExp thy (GetStat(name1, name2)) =  PrF thy ("GetStat "^(unqual_name name1)^" "^(tr name2))
  | printFlatExp thy (PutStat(name1, name2, name3)) =  PrF thy ("PutStat "^(unqual_name name1)^" "^(tr name2)^" "^(unqual_name name3))
  | printFlatExp thy (Invoke(name1, name2, name3)) =   PrF thy ("Invoke "^(tr name1)^" "^(unqual_name_maybe (tr name1) (tr name2))^" "^name3)
  | printFlatExp thy (InvokeStatic(name1, name2, name3)) =   PrF thy ("InvokeStatic "^(tr name1)^" "^(unqual_name_maybe (tr name1) (tr name2))^" "^name3) 
  | printFlatExp thy  (Leti(name, expr1, expr2)) = 
     (
      PrF thy ("LET "^(unqual_name name)^" = ");
      printFlatExp thy expr1;
      PrlF thy "\nIN";
      printFlatExp thy  expr2;
      PrF thy "\nEND"
     )
  | printFlatExp thy  (Letr(name, expr1, expr2)) = 
     (
      PrF thy ("LET rf "^(unqual_name name)^" = ");
      printFlatExp thy expr1;
      PrlF thy "\nIN";
      printFlatExp thy  expr2;
      PrF thy "\nEND"
     )
  | printFlatExp thy  (Letv(expr1, expr2)) = 
     (
      PrF thy ("LET   _ = ");
      printFlatExp thy expr1;
      PrlF thy "\nIN";
      printFlatExp thy  expr2;
      PrF thy "\nEND"
     )
  | printFlatExp thy  (Ifg(name, expr1, expr2)) =
     (
      PrF thy ("\nIF "^(unqual_name name)^" THEN ");
      printFlatExp thy expr1;
      PrF thy "\nELSE ";
      printFlatExp thy  expr2;
      PrF thy "\n"
     )
  | printFlatExp thy  (Call(name)) = 
    (PrF thy ("CALL "^(unqual_name name))
    )
  | printFlatExp thy  (Ill_Expr s)     =  PrF thy ("printFlatExp says: Ill-formed expression saying "^s)
  | printFlatExp thy _ =  raise toyError "printFlatExpr: Unknown expr"

and pairListToString [] = ""
  | pairListToString ((fldname, varname)::t)=
    "\n("^fldname^", "^varname^")"^(pairListToString t)

and printCorrectnessLemmas thy cname (mn::mns) (arg::args) =
  let  
     val lemma_name = (unqual_name mn)^"_Correct"
  in
   ((if (is_elem (substrAfterToken #"'" mn) ignore_mnames)
     then ()
     else 
       ( PrlF thy ("\n\n\nlemma "^(lemma_name)^": ");
	 PrlF thy (" \"Context \\<rhd> snd (methtable "^cname^" "^mn^") : SPEC "^mn^"\"");
	 PrlF thy (" by (Wp "^(unqual_name mn)^"pdefs)\n") ) (* HACK warning: unqual_name  adds a _ to mn, too (should add it only to vars); luckily _ is the separator btw mn and "pdefs" anyway *)
     );
     printCorrectnessLemmas thy cname mns args
    )
  end
 |  printCorrectnessLemmas thy cname [] [] = () (* OK, we re done *)
 |  printCorrectnessLemmas thy cname [] _ =  (* mismatching list lengths *)
    PrlF thy "(* printCorrectnessLemmas: mismatching list lengths for methods and their arguments *)"
 |  printCorrectnessLemmas thy cname _  [] = (* mismatching list lengths *)
    PrlF thy "(* printCorrectnessLemmas: mismatching list lengths for methods and their arguments *)"

and printLemma thy cname mn par =
  (
     PrlF thy ("theorem T_"^cname^": \"\\<rhd> "^(cname)^"\\<bullet>"^mn^"("^(par2arg_list_HACK par)^")  : sMST "^(cname)^" "^mn^" "^(par2arg_list_HACK par)^"\"");
     PrlF thy (" by (fastsimp intro: Context_good GCInvs simp: ctxt_def)\n")
  )

and printVersioning thy cname = 
  PrlF thy ("\nconstdefs CERT_prg_name :: \"string\"\n\"CERT_prg_name == ''"^cname^"''\"\n")

(*
and printCertSec2 thy cname mnames args =
 (PrlF thy ("method_setup Wp = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => Method.METHOD (fn facts => w_tac (thms \"meth_defs\") (l_tac6 (thms \"dmp_defs\", thms \"meth_defs\", pdefs, thms \"ctxt_def\")) ctxt 1)) *}\n \"parametric Method for starting: use weakening, simplification with args, fast\"\n\n");
 printLemma thy cname mnames args;
 printLemma2 thy cname mnames args;
 )
*)

(*
and printLemma thy cname  (hmname :: tmanmes) (hrname :: trnames) =
   ( PrlF thy ("\n\n\nlemma (in "^cname^"_example)");
     PrlF thy "\"\\<Turnstile> {(z,s). card (fmap_dom (oheap s)) = z}";
     PrlF thy ("(InvokeStatic "^cname^" "^hmname^" "^hrname^")");
     PrlF thy "{(z,s,v). card (fmap_dom (oheap s)) = z + upperbound}\""
  )
 |  printLemma thy cname _ _ =
    PrlF thy "Wrong method invocation: cannot generate lemma"
*)

(* and printAlist thy [] = PrlF thy "" *)
(*   | printAlist thy ((x,y)::ys) = (PrlF thy ("\n"^x^" -> "); printFlatExp thy y; printAlist thy ys) *)

