(* write_hints extracts minimal information from a Camelot program
into a file which may be sent as a proof hint from which mkTHY can
generate a suitable theorem about the Grail version of the program and
its proof in Isabelle.  *)

(*     val output_hints : Absyn.Program -> string -> unit
 *)

structure ProofHints =
struct

open Camelot_absyn_ASDL

fun output_hints (PROG (typeDecLs, valDecs, classDefs, funBlocks)) out_filename =
    let
	fun f (_, FUNdef (funcNm, _, _, (l, exp))) =
	    case exp of
		ASSERTexp (_, conds, guars) => FUNASSNS (funcNm, conds, guars)
	      | _ => FUNASSNS (funcNm, [], [])
	val fas = List.concat (map (fn FUNblock l => map f l) funBlocks)
	val h = BinIO.openOut out_filename
	val _ = Camelot_absyn_ASDLUtil.write_hints (HINTS (typeDecLs, fas)) h
	val _ = BinIO.closeOut h
    in () end

end
