(* Time-stamp: <Sun Jul 31 2005 22:48:24 Stardate: [-29]4329.33 hwloidl> *)
(* $Id: Predicate.sml,v 4.0.2.3 2005/07/31 22:06:07 a1hloidl Exp $ *)
(* Given a list of rich types from the Hofmann-Jost analysis,  generate
   an Isabelle predicate describing them.  Return this as a large string
   which will be passed to Compile.compile and ultimately to ToyGrailNormsyn
   for inclusion in the theory file. *)

(* This is currently incomplete,  but works for simple examples. *)



(* Lennart's example,  for guidance *)
(* DAss {l_,acc_} 0
(emptyfinmap(l_ \<mapsto>\<^sub>f(ListET 1))
(acc_ \<mapsto>\<^sub>f(ListET 0)))
(ListET 0) 0"
*)

open Absyn_ASDL

(* copied from Perv.sml; ToDo: define there and import --  HWL *)
val camelotlib_funs = ["free", "diamond_info", "nullString","print_int","print_float","print_string","print_char","print_newline","print_int_newline","print_float_newline","print_string_newline","print_char_newline","int_of_string","string_of_int","string_of_char","float_of_string","string_of_float","string_length","append_string","same_string","string_compare","substring","getc","open_input","close_input","read_line","read_char","eof","sleep","isnullobj","date"]

(* HWL: HACK: initUC_HACK picks the right flavour of ltac, based on the datatype we find in the functions type  *)
val global_v = ref 0
val thy_syntax = ref 0
val tactic_flavour = ref 0
val DEFAULT_THY_SYNTAX = 6
val DEFAULT_TACTIC_FLAVOUR = 4
val report_types = ref false

fun heapFree (RICH_CONty _) = true
  | heapFree _ = false

(* Intertwine list of argument names with arrow type, discarding heap-free args *)

fun mungeArrow (v::vs) (RICH_ARROWty (t1,t2)) =
    if heapFree t1 then (v,t1)::(mungeArrow vs t2)
    else (mungeArrow vs t2)
  | mungeArrow [] (RICH_ARROWty _) = Util.exit "Eek!"
  | mungeArrow [] rt = [("",rt)]  (* return type *)
  | mungeArrow _ _ = Util.exit "NO! NO!"

fun initUC s =
    let val l = String.explode s
    in case l of h::t => implode ((Char.toUpper h)::t)
	       | [] => Util.exit "empty type name in initUC"
    end

(* version for SLACK image *)
fun initUC_HACK_SLACK tname =
	     if ((((String.size tname)>=4) andalso ((String.substring (tname,0,4)="list") orelse (String.substring (tname,0,4)="List"))) orelse
                 ((String.size tname)>4) andalso ((String.substring (tname,1,4)="list") orelse  (String.substring (tname,1,4)="List")))
		 (* HWL HACK: turn every kind of list into IlistET *)
               then ((* TextIO.print "BONZO detected a list\n" ; *) global_v := 1; "Ilist")
             else
	     if ((((String.size tname)>=4) andalso ((String.substring (tname,0,4)="tree") orelse (String.substring (tname,0,4)="Tree"))) orelse
                 ((String.size tname)>4) andalso ((String.substring (tname,1,4)="tree") orelse  (String.substring (tname,1,4)="Tree")))
		 (* HWL HACK: turn every kind of list into IlistET *)
               then ((* TextIO.print "BONZO detected a tree\n" ; *) global_v := 3; "Itree")
               else initUC tname

(* version for NULLTP image; ToDo: use typename substitution out of metadata *)
fun initUC_HACK_MRG tname =
	     if ((((String.size tname)>=4) andalso ((String.substring (tname,0,4)="list") orelse (String.substring (tname,0,4)="List"))) orelse
                 ((String.size tname)>4) andalso ((String.substring (tname,1,4)="list") orelse  (String.substring (tname,1,4)="List")))
		 (* HWL HACK: turn every kind of list into IlistET *)
               then ((* TextIO.print "BONZO detected a list\n" ; *) global_v := 1; "List")
             else
	     if ((((String.size tname)>=4) andalso ((String.substring (tname,0,4)="tree") orelse (String.substring (tname,0,4)="Tree"))) orelse
                 ((String.size tname)>4) andalso ((String.substring (tname,1,4)="tree") orelse  (String.substring (tname,1,4)="Tree")))
		 (* HWL HACK: turn every kind of list into IlistET *)
               then ((* TextIO.print "BONZO detected a tree\n" ; *) global_v := 3; "Tree")
             else
	     if ((((String.size tname)>=6) andalso ((String.substring (tname,0,6)="result") orelse (String.substring (tname,0,6)="Result"))) orelse
                 ((String.size tname)>6) andalso ((String.substring (tname,1,6)="result") orelse  (String.substring (tname,1,6)="Result")))
		 (* HWL HACK: turn every kind of list into IlistET *)
               then ((* TextIO.print "BONZO detected a tree\n" ; *) global_v := 5; "Result")
               else initUC tname

fun initUC_HACK tname = 
  if ((!thy_syntax)=5)
    then initUC_HACK_SLACK tname
    else initUC_HACK_MRG tname

val spacesToStr = Util.listToString
	          (fn RICH_CON(name,_,space) => Int.toString space) " "
(*	          (fn RICH_CON(name,_,space) => "[" ^ name ^ "]" ^ Int.toString space) " " *)

(* user-defined types show up as stringET; need some translation to match format of
   known types as used in the underlying logic  *)
(*
fun makeUserTypeSpec t =  
  let
    val t' = initUC_HACK "List"
  in
    case t of 
       "Result" => "(" ^ (t') ^ "ET 0 0)\n"
     | _ => "(" ^ (t') ^ "ET 0 0)\n"
  end
*)

fun showRichTy t =
  let
    val str = 
    case t of
	RICH_INTty => "IntET\n"
      | RICH_CHARty => "CharET\n"
      | RICH_BOOLty => "BoolET\n"
      | RICH_FLOATty => "FloatET\n"
      | RICH_STRINGty => "(" ^ (initUC_HACK "List") ^ "ET 0 0)\n"
      | RICH_UNITty => "UnitET\n"
      | RICH_TVARty s => "'" ^ s
      | RICH_ARRAYty _ => "? arrayET\n"
      | RICH_PRODUCTty _ => "? productET\n"
      | RICH_ARROWty (t1, t2) => showRichTy t1 ^ " -> " ^ showRichTy t2 (* Util.exit "Surprise arrow" *)
      |  RICH_CONty (targs, tname, constructors) => "CON (["^(GrailUtils.join #" " (map showRichTy targs))^"], "^tname^", "^(spacesToStr constructors)^")\n"
      | RICH_DIAMONDty _ => "<>"
      | RICH_OBJECTty _ => "Object!"
      | RICH_SELFty => "Self?"
  in
    str
  end

fun shuffle_constructors constructors = 
     case List.last constructors of
        RICH_CON(name,_,space) => if space=0  
                                    then rev constructors
                                    else constructors

fun makeTypeSpec t =
    case t of
	RICH_INTty => "IntET\n"
      | RICH_CHARty => "CharET\n"
      | RICH_BOOLty => "BoolET\n"
      | RICH_FLOATty => "FloatET\n"
      | RICH_STRINGty => "(" ^ (initUC_HACK "List") ^ "ET 0 0)\n"
      | RICH_UNITty => "UnitET\n"
      | RICH_TVARty s => "'" ^ s
      | RICH_ARRAYty _ => "? arrayET\n"
      | RICH_PRODUCTty _ => "? productET\n"
      | RICH_ARROWty (t1, t2) => makeTypeSpec t1 ^ " -> " ^ makeTypeSpec t2 (* Util.exit "Surprise arrow" *)
      | RICH_CONty (targs, tname, constructors) =>
	let in case constructors of
	    [] => Util.exit "plume"
	  | _ => let
		   val nm = initUC_HACK tname
                   (* val _  = TextIO.print (showRichTy t) *)
                   (* 0-valued constructor must be first *)
                   (*  HACK2 reverse annotations *)			    
                   val constructors' = shuffle_constructors constructors
                   (* val _ = TextIO.print ("constructors: "^(spacesToStr constructors)^"\tshuffled constructors: "^(spacesToStr constructors')^"\n")  *)
                   val args = if (nm="Result")
                                then spacesToStr (List.take (constructors,1)) ^ " (TreeET 0 0) " ^ spacesToStr (rev (List.drop (constructors,1)))
                                else spacesToStr constructors'
                 in
 	           "(" ^ nm ^ "ET " ^ args ^ ")"
                 end
(* 	       "(" ^ (initUC_HACK tname) ^ "ET " ^ spacesToStr constructors ^ ")" *) (* HACK of Iresult -- HWL *)
        end
      | RICH_DIAMONDty _ => "<>"
      | RICH_OBJECTty _ => "Object!"
      | RICH_SELFty => "Self?"



fun makeArgSpec basename fname (argname, ty) first_entry =
    case ty of
	RICH_CONty (_, tname, constructors) =>
	let in
	    case constructors of
		[] => Util.exit "Multiple plurality mismatch"  (* Clearly this shouldn't occur *)
	      | _ =>
		let
		    val tname' = (initUC_HACK tname) ^ "ET"
                    val separator = if ((!thy_syntax)=5) 
                                      then ""
                                      else (if first_entry then "" else ",")
                    val mapop = if ((!thy_syntax)=5) 
                                      then " \\<mapsto>\\<^sub>f("
                                      else " , "
                    val h0 = basename ^ "'" ^ fname ^ "'" ^ argname  (* full name *)
                    val h0z = (*-ToyGrailAbsyn.lookup_short_name-*) h0     (* short name *)
		    val p = separator^"(" ^ h0z (* ToyGrailAbsyn.unqual_name (z) *)
                             ^ "(*" ^ h0 ^ "*)" (*--*)
                             ^ mapop ^ tname' ^ " " ^ spacesToStr (shuffle_constructors constructors) ^ ")"

		in
		    p
		end
	end
      | _ => Util.exit "Expected datatype in makeArgSpec"


val slash = "\\"
val newline = "\n"

fun makeResultSpec (_, ty) = "] " ^ slash ^ "<ggreater> " ^ (makeTypeSpec ty)



fun makeArrowSpec basename fname [] _ = ""
  | makeArrowSpec basename fname [(argname,ty)] _ = makeResultSpec(argname, ty) (* result *)
  | makeArrowSpec basename fname ((argname, ty)::T) first_entry =
     (makeArgSpec basename fname (argname, ty) first_entry)^(makeArrowSpec basename fname T false)


fun makeSpec basename fundefs (Absyn_ASDL.RICH_VALDEC(fname, stk_in, ty, stk_out)) =
    let
	fun varName_ Normsyn.UNITvar = "()_"
	  | varName_ (Normsyn.VAR(id, _)) = id

	fun getFunArgNames f  =
	    let
		fun find f [] = Util.exit ("can't find function " ^ f)
		  | find f ((Normsyn.FUNdef((name,_),args,_,_,_))::t) =
		    if f = name then map varName_ args
		    else find f t
	    in
		find f fundefs
	    end


	val args = mungeArrow (getFunArgNames fname) ty
	val usedArgs =
	    let
		val t = map #1 args
	    in
                List.take (t, List.length t -1)
	    end


        (* version for SLACK image *)		
	val pred_SLACK = (*"\"F_" ^ fname ^ "_Spec == *) slash ^ "<lbrace> {"
		   ^ Util.listToString (fn x =>  (basename ^ "'" ^ fname ^ "'" ^ x) ^ "(*" ^ basename ^ "'" ^ fname ^ "'" ^ x ^ "*)") ", " usedArgs
		   ^ ("}, " ^ Int.toString stk_in)
		   ^", (emptyfinmap"
		   ^ makeArrowSpec basename fname args true
		   ^ ", "
		   ^ Int.toString stk_out
		   ^ slash ^ "<rbrace>\n"
        (* version for NULLTP image *)		
	val pred_MRG = (*"\"F_" ^ fname ^ "_Spec == *) slash ^ "<lbrace> {"
		   ^ Util.listToString (fn x => (basename ^ "'" ^ fname ^ "'" ^ x) ^ "(*" ^ basename ^ "'" ^ fname ^ "'" ^ x ^ "*)") ", " usedArgs
		   ^ ("}, " ^ Int.toString stk_in)
		   ^", ["
		   ^ makeArrowSpec basename fname args true
		   ^ ", "
		   ^ Int.toString stk_out
		   ^ slash ^ "<rbrace>\n"
    in
      if ((!thy_syntax)=5)
         then (fname,pred_SLACK)
         else (fname,pred_MRG)
    end

fun nuke_libfuns l = GrailUtils.list_diff_with
                  (fn (x,y) => case x of
                                  (Absyn_ASDL.RICH_VALDEC(fname, stk_in, ty, stk_out)) => fname=y )
                  l camelotlib_funs

fun makePredicates basename funs l =
 List.foldr (fn (h,z) => let val (name,entry) = makeSpec basename funs h
                         in Binarymap.insert (z, name, entry)
                         end)
            (Binarymap.mkDict (String.compare))
            (nuke_libfuns l)

(* optionally add logic-level types in comments to certificate *)
fun reportTypes basename funs l =
 if (!report_types = true)
  then String.concat
 (List.map (fn Absyn_ASDL.RICH_VALDEC(fname, stk_in, ty, stk_out) => "(*" ^ fname ^ " :: " ^ (global_v := 1; makeTypeSpec ty) ^ "*)\n" ^ "ML {* val global_v_" ^ fname ^ " = " ^ Int.toString (!global_v) ^ " *}\n\n") l)
  else ""

(*fun makePredicates funs l =
    case l of [] => ""
	    | h::t => (makeSpec funs h) ^ "\n" ^ (makePredicates funs t)*)


(* Old code,  maybe useful

fun makeConSpecs tname args constrs =
    case (args, constrs) of
	(a::args', c::constrs') => (makeArgSpec tname a c) ^ "\n"
      (* Here we're throwing away the Nil constructor,  which is
         fortuitously at the front of the list *)
      | ([], c) => makeResultSpec tname c
      | _ => Util.exit "Length mismatch in makeConSpecs"

fun makeTypeSpec argnames t =
    case t of
	RICH_INTty => "intET\n"
      | RICH_CHARty => "charET\n"
      | RICH_BOOLty => "boolET\n"
      | RICH_FLOATty => "floatET\n"
      | RICH_STRINGty => "stringET\n"
      | RICH_UNITty => "unitET\n"
      | RICH_TVARty s => "'" ^ s
      | RICH_ARRAYty _ => "? arrayET\n"
      | RICH_PRODUCTty _ => "? productET\n"
      | RICH_ARROWty (t1, t2) => Util.exit "Surprise arrow"
      | RICH_CONty (targs, tname, constructors) =>
	makeConSpecs tname argnames constructors
      | RICH_DIAMONDty _ => "<>"
      | RICH_OBJECTty _ => "Object!"
      | RICH_SELFty => "Self?"

*)
