val required = ()  (* To circumvent mosmldep limitation *)

(* Types replicated from Absyn.  Note that some of the datatypes are polymorphic. *)

type 'u Name            = 'u Absyn.Name
type Assn               = Absyn.Assn

datatype Ty             = datatype Absyn.Ty
datatype HeapUsage      = datatype Absyn.HeapUsage
datatype TypeCon        = datatype Absyn.TypeCon
datatype TypeDec        = datatype Absyn.TypeDec
datatype FunAssns       = datatype Absyn.FunAssns
datatype Hints          = datatype Absyn.Hints
datatype UnaryOperator  = datatype Absyn.UnaryOperator
datatype BinaryOperator = datatype Absyn.BinaryOperator
datatype MatchDiam      = datatype Absyn.MatchDiam
datatype OOMatchPat     = datatype Absyn.OOMatchPat
datatype External       = datatype Absyn.External
datatype Instance       = datatype Absyn.Instance
datatype ValDec         = datatype Absyn.ValDec
datatype VarTy          = datatype Absyn.VarTy

datatype 'u Value =
	 VARval of string * External * 'u
       | CHARval of int * 'u
       | INTval of int * 'u
       | FLOATval of real * 'u
       | STRINGval of string * 'u
       | BOOLval of bool *'u
       | UNITval of 'u
       | NULLval of 'u Name
       (* LAMvals are lifted before we get here *)

and 'u Exp =
          VALexp of 'u Value * 'u
        | UNARYexp of UnaryOperator * 'u Value * 'u
        | BINexp of BinaryOperator * 'u Value * 'u Value * 'u
        | APPexp of 'u Name * 'u Value list * External * 'u
        | CONexp of 'u Name * 'u Value list * 'u Name option * 'u
(*	| TUPLEexp of 'u Value list*)
        | INVOKEexp of 'u Name *'u Name * 'u Value list * 'u
        | NEWexp of 'u Name * 'u Value list * 'u
        | GETexp of 'u Name * 'u Name * 'u
        | SGETexp of 'u Name * 'u
        | UPDATEexp of 'u Name * 'u Value * 'u
        | SUPERMAKERexp of 'u Value list * 'u
        (* Following expressions can contain proper subexpressions *)
        | LETexp of 'u Name * 'u Exp * 'u Exp * 'u
        | IFexp of 'u Test * 'u Exp * 'u Exp * 'u
        | MATCHexp of 'u Name * 'u MatchRule list * 'u
        | TYPEDexp of 'u Exp * Ty * 'u
        | COERCEexp of 'u Exp * Ty * 'u
        | ASSERTexp of 'u Exp * Assn list * Assn list * 'u

     and 'u Test = TEST of BinaryOperator * 'u Value * 'u Value * 'u

     and 'u MatchRule =
          MATCHrule of 'u Name * 'u Name list * 'u MatchDiam * 'u Exp * 'u
        | OOMATCHrule of 'u OOMatchPat * 'u Exp * 'u

     and 'u FunDef =
         FUNdef of 'u Name * VarTy list * Instance * 'u Exp * 'u

     and 'u FunBlock =
	 FUNblock of 'u FunDef list

     and 'u ClassDef =
        CLASSdef of
	'u Name *           (* Class name *)
        'u Name option *    (* Superclass *)
        'u Name list *      (* Interfaces *)
        'u ValDec list *    (* Fields *)
        'u FunDef list      (* Methods *)

    and 'u Program =
          PROG of 'u TypeDec list * 'u ValDec list
		  * 'u ClassDef list * 'u FunBlock list


type monoInfo = Absyn.monoInfo
type phiInfo =  Absyn.phiInfo

datatype Annotation = datatype Absyn.Annotation
val nowhere = Absyn.nowhere

fun getLoc u =
    case u of
	LOC l => l
      | MONO (_,u) => getLoc u
      | PHI (_,u) => getLoc u

