(* kwxm:  Names like Lib_atol1_a confuse Steffen's parser *)
(* Standard library datatypes *)
(* Could possibly tidy this up once we have stuff
   for translating back to asdl absyn *)

local
    open Absyn Asyntfn
in

fun addDatatypes oldDatatypes =
    let
        val datatypes = [
            TYPEdec([("'a", nowhere)],
		    ("list",nowhere),
                    [
                     TYPEcon(("Nil$",nowhere),
			     ([], nowhere),
			     NOHEAP,
			     nowhere),
		     TYPEcon(("Cons$",nowhere),
                             ([mkTvar "'a",
                              CONty ([mkTvar "'a"], "list")], nowhere),
			     HEAP,
			     nowhere)
		    ],
		    nowhere),
	     TYPEdec([("'a", nowhere)],
		     ("option",nowhere),
                     [
		      TYPEcon(("NONE",nowhere), ([],nowhere), NOHEAP, nowhere),
		      TYPEcon(("SOME",nowhere), ([mkTvar "'a"], nowhere), HEAP, nowhere)
		     ],
		     nowhere)
	]
    in
        datatypes@oldDatatypes
    end

fun addVals vals = vals

(* "Adaptor functions" consisting of main function together with funs to
   convert string array to string list; main does the conversion and then calls start *)

fun adaptors () =
    let
	val n = Absyn.nowhere
	fun locVal s = VALexp (VARval (s, LOCAL, n), n)
	fun builtinVal s = VALexp (VARval (s, BUILTIN, n), n)

        (* let atol1 a j m = if j=m then [] else (get a j) :: (atol1 a (j+1) m) *)

	val atol1 = FUNdef(("atol1$",nowhere),
			   [VAR ("lib_atol1_a", NONE),
			    VAR ("lib_atol1_j", NONE),
			    VAR ("lib_atol1_m", NONE)],
			   STATIC,
                           IFexp(BINexp(EQUALSop,
					locVal "lib_atol1_j",
					locVal "lib_atol1_m", n),
				 CONexp(("Nil$",nowhere), [], NONE, n),
				 CONexp(("Cons$",nowhere),
					[APPexp (
					 builtinVal "get",
					 [locVal "lib_atol1_a",
					  locVal "lib_atol1_j"],
					 BUILTIN, n),

					 APPexp(locVal "atol1$",
						[locVal "lib_atol1_a",
						 BINexp(PLUSop,
							locVal "lib_atol1_j",
							VALexp(INTval (1,n), n),n),
						 locVal "lib_atol1_m"],
						GLOBAL, n)
					],
					NONE,
					n
				       ),
				 n),
			  n)

       (* let atol a = atol1 a 0 (arraylength a) *)

	val atol = FUNdef(("atol$",nowhere),
			  [VAR("lib_atol_a", NONE)],
			  STATIC,
			  APPexp(
			    locVal "atol1$",
			    [locVal "lib_atol_a",
			     VALexp(INTval (0,n), n),
			     APPexp(
			      builtinVal "arraylength",
			      [locVal "lib_atol_a"],
			      BUILTIN,
			      n)
			    ],
			    GLOBAL,
			    n),
			  n)

        (* let main args = start (atol args) *)

	val main = FUNdef(
		   ("main",nowhere),
		   [VAR("lib_main_args", NONE)],
		   STATIC,
		   APPexp(
		     locVal "start",
                     [APPexp(
		        locVal "atol$",
			[locVal "lib_main_args"],
			GLOBAL,
			n)
		     ],
		     GLOBAL,
		     n),
		   n)


	val () = Perv.markUsed "get"
	val () = Perv.markUsed "arraylength"
        (* Tell perv to export type info for these fns *)
    in
	[FUNblock [atol1], FUNblock [atol], FUNblock [main]]
    end

fun addFuns fblocks =
   (* If the user's defined a function called "start" then insert
      a "main" function (unless there's already one) *)
       let
	   fun existsFun fname = List.exists
				     (fn FUNblock l =>
					 (List.exists (fn Absyn.FUNdef((name,_),_,_,_,_) =>
							  name = fname ) l)) fblocks
       in
	    if existsFun "start"
	    then if existsFun "main" then
		     fblocks (* Util.exit ("both \"main\" and \"start\" are defined")*)
		 else
		     fblocks@adaptors()
	    else fblocks
	end


fun addStandard (PROG(datatypes, vals, classes, funs)) =
    PROG(addDatatypes datatypes, addVals vals, classes, addFuns funs)

end

