local open Obj Lexing in


open Parser;

exception LexicalError of string * int * int (* (message, loc1, loc2) *)

fun lexerError lexbuf s =
    raise LexicalError (s, getLexemeStart lexbuf, getLexemeEnd lexbuf);

val commentStart = ref 0;  (* Start of outermost comment being scanned *)

fun commentNotClosed lexbuf =
    raise LexicalError ("Comment not terminated",
		   !commentStart, getLexemeEnd lexbuf);

val commentDepth = ref 0;  (* Current comment nesting *)

fun getString lexbuf =
     let
	val s = getLexeme lexbuf
     in case String.fromString s of
         SOME _ => quoteval s (* return the unconverted string:  we're only checking for errors *)
       | NONE => lexerError lexbuf "Badly-formed string literal"
     end

exception noSuchWord
val keyword_table: (string,token) Polyhash.hash_table
       = Polyhash.mkTable(Polyhash.hash, op=) (64, noSuchWord)

(* Scan keywords as identifiers and use this function to distinguish them. *)

val () =
   List.app (fn (str,tok) => Polyhash.insert keyword_table (str, tok))
 [
 ( "int",       INT ),
 ( "bool",      BOOL ),
 ( "char",      CHAR ),
 ( "float",     FLOAT ),
 ( "string",    STRING ),
 ( "type",      TYPE ),
 ( "array",     ARRAY ),
 ( "begin",     BEGIN ),
 ( "end",       END ),
 ( "if",        IF ),
 ( "then",      THEN ),
 ( "else",      ELSE ),
 ( "match",     MATCH ),
 ( "with",      WITH ),
 ( "let",       LET ),
 ( "rec",       REC ),
 ( "in",        IN ),
 ( "val",       VAL ),
 ( "fun",       FUN ),
 ( "of",        OF ),
 ( "and",       AND ),
 ( "end",       END ),
 ( "unit",      UNITT ),
 ( "true",      TRUE ),
 ( "false",     FALSE ),
 ( "not",       NOT ),
 ( "mod",       MOD ),
 ( "lnot",      LNOT ),
 ( "land",      LAND ),
 ( "lor",       LOR ),
 ( "lxor",      LXOR ),
 ( "lsl",       LSL ),
 ( "lsr",       LSR ),
 ( "asr",       ASR ),
 ( "new",       NEW ),
 ( "class",     CLASS ),
 ( "classtype", CLASSTYPE ),
 ( "object",    OBJECT ),
 ( "method",    METHOD ),
 ( "field",     FIELD ),
 ( "virtual",   VIRTUAL ),
 ( "inherit",   INHERIT ),
 ( "implement", IMPLEMENT),
 ( "is",        IS ),
 ( "null",      NULL ),
 ( "isnull",    ISNULL ),
 ( "super",     SUPER),
 ( "maker",     MAKER)
]

fun mkKeyword lexbuf =
  let val s = getLexeme lexbuf in
    Polyhash.find keyword_table s
    handle noSuchWord => ident s
  end

fun action_63 lexbuf = (
 lexerError lexbuf "Illegal symbol in input" )
and action_62 lexbuf = (
 EOF )
and action_61 lexbuf = (
 USCORE )
and action_60 lexbuf = (
 CARET )
and action_59 lexbuf = (
 AMPAMP )
and action_58 lexbuf = (
 ATSIGN )
and action_57 lexbuf = (
 BANG )
and action_56 lexbuf = (
 COERCE )
and action_55 lexbuf = (
 CONS )
and action_54 lexbuf = (
 COLON )
and action_53 lexbuf = (
 BARBAR )
and action_52 lexbuf = (
 BAR )
and action_51 lexbuf = (
 GTEQ )
and action_50 lexbuf = (
 GREATER )
and action_49 lexbuf = (
 WARROW )
and action_48 lexbuf = (
 EQUALS )
and action_47 lexbuf = (
 DOT )
and action_46 lexbuf = (
 BANG )
and action_45 lexbuf = (
 HASH )
and action_44 lexbuf = (
 SEMI )
and action_43 lexbuf = (
 COMMA )
and action_42 lexbuf = (
 RBRACE )
and action_41 lexbuf = (
 LBRACE )
and action_40 lexbuf = (
 RSQ )
and action_39 lexbuf = (
 LSQ )
and action_38 lexbuf = (
 RPAREN )
and action_37 lexbuf = (
 UNIT )
and action_36 lexbuf = (
 LPAREN )
and action_35 lexbuf = (
 DiscardRestOfLine lexbuf; Token lexbuf )
and action_34 lexbuf = (
 SLASHDOT )
and action_33 lexbuf = (
 SLASH )
and action_32 lexbuf = (
 STARDOT )
and action_31 lexbuf = (
 STAR )
and action_30 lexbuf = (
 ARROW )
and action_29 lexbuf = (
 MINUSDOT )
and action_28 lexbuf = (
 MINUS )
and action_27 lexbuf = (
 PLUSDOT )
and action_26 lexbuf = (
 PLUS )
and action_25 lexbuf = (
 LEQ )
and action_24 lexbuf = (
 LESS )
and action_23 lexbuf = (
 DIAMOND )
and action_22 lexbuf = (
 UPDATE )
and action_21 lexbuf = (
 lexerError lexbuf "Unmatched comment delimeter" )
and action_20 lexbuf = (
 commentStart := getLexemeStart lexbuf;
                          commentDepth := 1;
                          SkipComment lexbuf; Token lexbuf )
and action_19 lexbuf = (
 charval (getLexeme lexbuf) )
and action_18 lexbuf = (
 charval (getLexeme lexbuf) )
and action_17 lexbuf = (
 charval (getLexeme lexbuf) )
and action_16 lexbuf = (
 getString lexbuf )
and action_15 lexbuf = (
 TyVar (getLexeme lexbuf) )
and action_14 lexbuf = (
 ExtId (getLexeme lexbuf) )
and action_13 lexbuf = (
 ConId (getLexeme lexbuf) )
and action_12 lexbuf = (
 case Real.fromString (getLexeme lexbuf) of
                               NONE   => lexerError lexbuf "internal error (Real.fromString)"
			     | SOME i => floatval i
	  )
and action_11 lexbuf = (
 case Int.fromString (getLexeme lexbuf) of
			    NONE   => lexerError lexbuf "internal error (Int.fromString)"
                          | SOME i => intval i
			)
and action_10 lexbuf = (
 mkKeyword lexbuf )
and action_9 lexbuf = (
 mkKeyword lexbuf )
and action_8 lexbuf = (
 mkKeyword lexbuf )
and action_7 lexbuf = (
 mkKeyword lexbuf )
and action_6 lexbuf = (
 Token lexbuf )
and action_5 lexbuf = (
 SkipComment lexbuf )
and action_4 lexbuf = (
 commentNotClosed lexbuf )
and action_3 lexbuf = (
 commentDepth := !commentDepth + 1;
                          SkipComment lexbuf )
and action_2 lexbuf = (
 commentDepth := !commentDepth - 1;
                          if !commentDepth = 0 then ()
                          else SkipComment lexbuf
                        )
and action_1 lexbuf = (
 DiscardRestOfLine lexbuf )
and action_0 lexbuf = (
 () )
and state_0 lexbuf = (
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"\n" => action_0 lexbuf
 |  #"\^@" => action_0 lexbuf
 |  _ => action_1 lexbuf
 end)
and state_1 lexbuf = (
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"*" => state_101 lexbuf
 |  #"(" => state_100 lexbuf
 |  #"\^Z" => action_4 lexbuf
 |  #"\^@" => action_4 lexbuf
 |  _ => action_5 lexbuf
 end)
and state_2 lexbuf = (
 let val currChar = getNextChar lexbuf in
 if currChar >= #"a" andalso currChar <= #"z" then  state_32 lexbuf
 else if currChar >= #"A" andalso currChar <= #"Z" then  state_27 lexbuf
 else if currChar >= #"0" andalso currChar <= #"9" then  state_19 lexbuf
 else case currChar of
    #"\n" => action_6 lexbuf
 |  #"\t" => action_6 lexbuf
 |  #"\r" => action_6 lexbuf
 |  #" " => action_6 lexbuf
 |  #"}" => action_42 lexbuf
 |  #"|" => state_34 lexbuf
 |  #"{" => action_41 lexbuf
 |  #"_" => state_31 lexbuf
 |  #"^" => action_60 lexbuf
 |  #"]" => action_40 lexbuf
 |  #"[" => action_39 lexbuf
 |  #"@" => action_58 lexbuf
 |  #"?" => state_25 lexbuf
 |  #">" => state_24 lexbuf
 |  #"=" => state_23 lexbuf
 |  #"<" => state_22 lexbuf
 |  #";" => action_44 lexbuf
 |  #":" => state_20 lexbuf
 |  #"/" => state_18 lexbuf
 |  #"." => action_47 lexbuf
 |  #"-" => state_16 lexbuf
 |  #"," => action_43 lexbuf
 |  #"+" => state_14 lexbuf
 |  #"*" => state_13 lexbuf
 |  #")" => action_38 lexbuf
 |  #"(" => state_11 lexbuf
 |  #"'" => state_10 lexbuf
 |  #"&" => state_9 lexbuf
 |  #"#" => action_45 lexbuf
 |  #"\"" => state_7 lexbuf
 |  #"!" => action_46 lexbuf
 |  #"\^@" => action_62 lexbuf
 |  _ => action_63 lexbuf
 end)
and state_7 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_63);
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"\\" => state_95 lexbuf
 |  #"\"" => action_16 lexbuf
 |  #"\^@" => backtrack lexbuf
 |  _ => state_93 lexbuf
 end)
and state_9 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_63);
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"&" => action_59 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_10 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_63);
 let val currChar = getNextChar lexbuf in
 if currChar >= #"A" andalso currChar <= #"Z" then  state_81 lexbuf
 else if currChar >= #"a" andalso currChar <= #"z" then  state_81 lexbuf
 else case currChar of
    #"\\" => state_82 lexbuf
 |  #"\^@" => backtrack lexbuf
 |  _ => state_80 lexbuf
 end)
and state_11 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_36);
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"*" => action_20 lexbuf
 |  #")" => action_37 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_13 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_31);
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"." => action_32 lexbuf
 |  #")" => action_21 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_14 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_26);
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"." => action_27 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_16 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_28);
 let val currChar = getNextChar lexbuf in
 case currChar of
    #">" => action_30 lexbuf
 |  #"." => action_29 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_18 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_33);
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"/" => action_35 lexbuf
 |  #"." => action_34 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_19 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_11);
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_66 lexbuf
 else case currChar of
    #"." => state_65 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_20 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_54);
 let val currChar = getNextChar lexbuf in
 case currChar of
    #">" => action_56 lexbuf
 |  #":" => action_55 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_22 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_24);
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"i" => state_52 lexbuf
 |  #"c" => state_51 lexbuf
 |  #">" => action_23 lexbuf
 |  #"=" => action_25 lexbuf
 |  #"-" => action_22 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_23 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_48);
 let val currChar = getNextChar lexbuf in
 case currChar of
    #">" => action_49 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_24 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_50);
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"=" => action_51 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_25 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_7);
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_37 lexbuf
 else if currChar >= #"A" andalso currChar <= #"Z" then  state_37 lexbuf
 else if currChar >= #"a" andalso currChar <= #"z" then  state_37 lexbuf
 else case currChar of
    #"%" => state_37 lexbuf
 |  #"$" => state_37 lexbuf
 |  #"_" => state_37 lexbuf
 |  #"'" => state_38 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_27 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_13);
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_45 lexbuf
 else if currChar >= #"A" andalso currChar <= #"Z" then  state_45 lexbuf
 else if currChar >= #"a" andalso currChar <= #"z" then  state_45 lexbuf
 else case currChar of
    #"_" => state_45 lexbuf
 |  #"." => state_39 lexbuf
 |  #"'" => state_44 lexbuf
 |  #"$" => state_43 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_31 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_61);
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_41 lexbuf
 else if currChar >= #"A" andalso currChar <= #"Z" then  state_41 lexbuf
 else if currChar >= #"a" andalso currChar <= #"z" then  state_41 lexbuf
 else case currChar of
    #"%" => state_41 lexbuf
 |  #"$" => state_41 lexbuf
 |  #"_" => state_41 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_32 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_7);
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_40 lexbuf
 else if currChar >= #"A" andalso currChar <= #"Z" then  state_40 lexbuf
 else if currChar >= #"a" andalso currChar <= #"z" then  state_40 lexbuf
 else case currChar of
    #"_" => state_40 lexbuf
 |  #"%" => state_37 lexbuf
 |  #"$" => state_37 lexbuf
 |  #"." => state_39 lexbuf
 |  #"'" => state_38 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_34 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_52);
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"|" => action_53 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_37 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_7);
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_37 lexbuf
 else if currChar >= #"A" andalso currChar <= #"Z" then  state_37 lexbuf
 else if currChar >= #"a" andalso currChar <= #"z" then  state_37 lexbuf
 else case currChar of
    #"%" => state_37 lexbuf
 |  #"$" => state_37 lexbuf
 |  #"_" => state_37 lexbuf
 |  #"'" => state_38 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_38 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_7);
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"'" => state_38 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_39 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_14);
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_39 lexbuf
 else if currChar >= #"A" andalso currChar <= #"Z" then  state_39 lexbuf
 else if currChar >= #"a" andalso currChar <= #"z" then  state_39 lexbuf
 else case currChar of
    #"." => state_39 lexbuf
 |  #"_" => state_39 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_40 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_7);
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_40 lexbuf
 else if currChar >= #"A" andalso currChar <= #"Z" then  state_40 lexbuf
 else if currChar >= #"a" andalso currChar <= #"z" then  state_40 lexbuf
 else case currChar of
    #"_" => state_40 lexbuf
 |  #"%" => state_37 lexbuf
 |  #"$" => state_37 lexbuf
 |  #"." => state_39 lexbuf
 |  #"'" => state_38 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_41 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_8);
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_41 lexbuf
 else if currChar >= #"A" andalso currChar <= #"Z" then  state_41 lexbuf
 else if currChar >= #"a" andalso currChar <= #"z" then  state_41 lexbuf
 else case currChar of
    #"%" => state_41 lexbuf
 |  #"$" => state_41 lexbuf
 |  #"_" => state_41 lexbuf
 |  #"'" => state_42 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_42 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_8);
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"'" => state_42 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_43 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_13);
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_43 lexbuf
 else if currChar >= #"A" andalso currChar <= #"Z" then  state_43 lexbuf
 else if currChar >= #"a" andalso currChar <= #"z" then  state_43 lexbuf
 else case currChar of
    #"$" => state_43 lexbuf
 |  #"_" => state_43 lexbuf
 |  #"'" => state_44 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_44 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_13);
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"'" => state_44 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_45 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_13);
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_45 lexbuf
 else if currChar >= #"A" andalso currChar <= #"Z" then  state_45 lexbuf
 else if currChar >= #"a" andalso currChar <= #"z" then  state_45 lexbuf
 else case currChar of
    #"_" => state_45 lexbuf
 |  #"." => state_39 lexbuf
 |  #"'" => state_44 lexbuf
 |  #"$" => state_43 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_51 lexbuf = (
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"l" => state_57 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_52 lexbuf = (
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"n" => state_53 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_53 lexbuf = (
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"i" => state_54 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_54 lexbuf = (
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"t" => state_55 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_55 lexbuf = (
 let val currChar = getNextChar lexbuf in
 case currChar of
    #">" => action_9 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_57 lexbuf = (
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"i" => state_58 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_58 lexbuf = (
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"n" => state_59 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_59 lexbuf = (
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"i" => state_60 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_60 lexbuf = (
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"t" => state_61 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_61 lexbuf = (
 let val currChar = getNextChar lexbuf in
 case currChar of
    #">" => action_10 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_65 lexbuf = (
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_67 lexbuf
 else backtrack lexbuf
 end)
and state_66 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_11);
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_66 lexbuf
 else case currChar of
    #"." => state_65 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_67 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_12);
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_67 lexbuf
 else case currChar of
    #"E" => state_68 lexbuf
 |  #"e" => state_68 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_68 lexbuf = (
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_70 lexbuf
 else case currChar of
    #"-" => state_69 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_69 lexbuf = (
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_70 lexbuf
 else backtrack lexbuf
 end)
and state_70 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_12);
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_70 lexbuf
 else backtrack lexbuf
 end)
and state_80 lexbuf = (
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"'" => action_17 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_81 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_15);
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_91 lexbuf
 else if currChar >= #"A" andalso currChar <= #"Z" then  state_91 lexbuf
 else if currChar >= #"a" andalso currChar <= #"z" then  state_91 lexbuf
 else case currChar of
    #"." => state_91 lexbuf
 |  #"_" => state_91 lexbuf
 |  #"'" => action_17 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_82 lexbuf = (
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_85 lexbuf
 else case currChar of
    #"'" => state_84 lexbuf
 |  #"\^@" => backtrack lexbuf
 |  _ => state_83 lexbuf
 end)
and state_83 lexbuf = (
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"'" => action_18 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_84 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_17);
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"'" => action_18 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_85 lexbuf = (
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_87 lexbuf
 else case currChar of
    #"'" => action_18 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_87 lexbuf = (
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_88 lexbuf
 else backtrack lexbuf
 end)
and state_88 lexbuf = (
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"'" => action_19 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_91 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_15);
 let val currChar = getNextChar lexbuf in
 if currChar >= #"0" andalso currChar <= #"9" then  state_91 lexbuf
 else if currChar >= #"A" andalso currChar <= #"Z" then  state_91 lexbuf
 else if currChar >= #"a" andalso currChar <= #"z" then  state_91 lexbuf
 else case currChar of
    #"." => state_91 lexbuf
 |  #"_" => state_91 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_93 lexbuf = (
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"\\" => state_95 lexbuf
 |  #"\"" => action_16 lexbuf
 |  #"\^@" => backtrack lexbuf
 |  _ => state_93 lexbuf
 end)
and state_95 lexbuf = (
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"\\" => state_95 lexbuf
 |  #"\"" => state_96 lexbuf
 |  #"\^@" => backtrack lexbuf
 |  _ => state_93 lexbuf
 end)
and state_96 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_16);
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"\\" => state_95 lexbuf
 |  #"\"" => action_16 lexbuf
 |  #"\^@" => backtrack lexbuf
 |  _ => state_93 lexbuf
 end)
and state_100 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_5);
 let val currChar = getNextChar lexbuf in
 case currChar of
    #"*" => action_3 lexbuf
 |  _ => backtrack lexbuf
 end)
and state_101 lexbuf = (
 setLexLastPos lexbuf (getLexCurrPos lexbuf);
 setLexLastAction lexbuf (magic action_5);
 let val currChar = getNextChar lexbuf in
 case currChar of
    #")" => action_2 lexbuf
 |  _ => backtrack lexbuf
 end)
and Token lexbuf =
  (setLexLastAction lexbuf (magic dummyAction);
   setLexStartPos lexbuf (getLexCurrPos lexbuf);
   state_2 lexbuf)

and SkipComment lexbuf =
  (setLexLastAction lexbuf (magic dummyAction);
   setLexStartPos lexbuf (getLexCurrPos lexbuf);
   state_1 lexbuf)

and DiscardRestOfLine lexbuf =
  (setLexLastAction lexbuf (magic dummyAction);
   setLexStartPos lexbuf (getLexCurrPos lexbuf);
   state_0 lexbuf)

(* The following checks type consistency of actions *)
val _ = fn _ => [action_63, action_62, action_61, action_60, action_59, action_58, action_57, action_56, action_55, action_54, action_53, action_52, action_51, action_50, action_49, action_48, action_47, action_46, action_45, action_44, action_43, action_42, action_41, action_40, action_39, action_38, action_37, action_36, action_35, action_34, action_33, action_32, action_31, action_30, action_29, action_28, action_27, action_26, action_25, action_24, action_23, action_22, action_21, action_20, action_19, action_18, action_17, action_16, action_15, action_14, action_13, action_12, action_11, action_10, action_9, action_8, action_7, action_6];
val _ = fn _ => [action_5, action_4, action_3, action_2];
val _ = fn _ => [action_1, action_0];

end
