exception utilsError of string;

fun is_elem x xs = List.exists (fn y => x=y) xs

fun is_elem_with f x xs = List.exists (fn y => f(x,y)) xs

fun zipWith f [] [] = []
  | zipWith f (x::xs) (y::ys) = (f (x,y))::(zipWith f xs ys)
  | zipWith f _ _ = raise utilsError "zipWith: lists not of same length"

fun lookup x [] = NONE
  | lookup x ((y,z)::ys) = if (x=y) then SOME z else lookup x ys

fun splitBy x xs = String.tokens (fn c => c=x) xs;

fun substrAfterToken x xs =
    List.last (splitBy x xs);

fun substrBeforeToken x xs =
    List.hd (splitBy x xs);

(* perl-style join of a list *)
fun join c xs = foldr (fn (x,s) => x^(str c)^s) "" xs

fun list_diff xs ys = List.filter (fn x => not (is_elem x ys)) xs

fun list_diff_with f xs ys = List.filter (fn x => not (is_elem_with f x ys)) xs

fun zip ([],[]) = [] 
  | zip (h1::t1,h2::t2) = (h1,h2) :: (zip (t1,t2))
  | zip _  = raise utilsError "zip: lists not of same length"

fun fst (x,y) = x
fun snd (x,y) = y
fun fst3 (x,_,_) = x
fun snd3 (_,y,_) = y
fun thd3 (_,_,z) = z
fun id x = x

(*stolen from Camelot/src/Util.sml*)
fun listToString toString separator l =
case l of [] => ""
        | [h] => toString h
        | h::t => (toString h) ^ separator ^ (listToString toString separator t)

(* same as Util.makeFullFilename; need here to be standalone *)
fun makeFullFilename dir base ext =
    Path.joinDirFile
       {dir=dir,
	file=Path.joinBaseExt {base=base, ext=SOME ext}}

fun basename f = List.last (String.tokens (fn c => ( c = #"/")) f)

fun strReverse s = String.implode (List.revAppend((String.explode s),[]))

(* replace all occurences of s1 in str by s2 *)
fun strReplace s1 s2 str =
 let
   val m1 = String.size s1
   val m2 = String.size s2
   fun rep0 str n = let
                      val m  = String.size str
                      (* val _ = TextIO.print (".. " ^ (Int.toString n) ^ " ")  *)
                    in
                     if n+m1>=m
                       then str
                       else if (String.substring(str,n,m1)=s1)
                             then rep0 (String.concat[String.substring(str,0,n),s2,String.extract(str,n+m1,NONE)]) (n+m2)
                             else rep0 str (n+1)
                    end
                 in
                  rep0 str 0
                 end
(*
fun print s =
    if not (flagSet SILENT) then
	TextIO.print s
else ()
*)


