(* kwxm, 30th May 2004:  added lots of stuff for Grail cases.
   Didn't think too carefully.  See all occurences of CASEres *)

local
    structure G = GrailAbsyn
    val () = GrailAbsyn.required
in

datatype ClassDef = CDEF of
	 Classdecl.class_access_flag list
	 * string
	 * string option
	 * string list
	 * G.FieldDef list
	 * MethodDef list
	 * G.layout list option
     and MethodDef = MDEF of
	 Classdecl.method_access_flag list
	 * G.RTy
	 * string
	 * (G.Ty*G.Var) list
	 * MethodBody
     and MethodBody = MBODY of LetDec list * FunDec list * Result
     and FunDec = FDEC of string * (G.Ty*G.Var) list * FunBody
     and FunBody = FUNbody
         of LetDec list * Result
     and Liveness =
         LIVE of G.Var list * G.Var list
withtype LetDec = G.LetDec * Liveness
     and Result = G.Result * Liveness


local
  val debug = ref false
in
fun setDebug value = debug := value
fun debugPrint s =
	  if (!debug) then TextIO.print s
	  else ()
fun debugging () = !debug
end

(*
fun debugPrint _ = () (* Let's suppress the output altogether for now *)
*)

exception flowError of string;

fun prPair (xx, yy) =
    (app (fn x => debugPrint (" "^x)) xx;
     debugPrint "  ||  ";
     app (fn x => debugPrint (" "^x)) yy;
     debugPrint "\n";
     (xx,yy))

fun id x = x

fun prEqs (LIVE(ii,oo)) =
    let
        val is = if ii = [] then "" else
                 " {in: "
                 ^ (Util.listToString id ", " ii)
                 ^ "} "
        val os = if oo = [] then "" else
                 " {out: "
                 ^ (Util.listToString id ", " oo)
                 ^ "} "
    in
        debugPrint (is ^ os)
    end


local
    open GrailAbsyn
in

exception dataflowError of string

local  (* Stolen from Compile.sml *)
    fun tysEqual x y =
	x = y
	orelse (x = INTty andalso y = BOOLEANty)
        orelse (y = INTty andalso x = BOOLEANty)
in
fun tysUnequal x y =
    let
    in
	not (tysEqual x y)
    end
fun rtysEqual (SOME x) (SOME y) = tysEqual x y
  | rtysEqual NONE NONE = true
  | rtysEqual _ _ = false
fun rtysUnequal x y = not (rtysEqual x y)
end (* stolen *)

type ident = string;
fun pr x = ();
fun prl x = ();
val methodReturnType: RTy ref = ref NONE




        (*************************************)
        (*           Typechecking            *)
        (*************************************)

local

(* More or less copied from GrailAbsyn.  This is only used
   in a single call to getMethodVarTypes later *)

(* Can't we just use the Grail version on the input? *)

        (*************************************)
        (*    Local variables and labels     *)
        (*************************************)



local  (* stuff for Grail local vars *)
    val class = ref (REFty "")
    val vartypes: (ident * Ty) list ref
	    = ref []

fun lookup  v (ref l) =
    let fun
        lookup' v [] = NONE
      | lookup' v ((w,p)::tail) = if v=w then SOME p else lookup' v tail
    in
        lookup' v l
    end

fun find v h =
    case lookup v h of
        NONE => raise dataflowError ("Can't find variable/function " ^ v)
      | SOME p => p

in

fun resetVarInfo() = vartypes := []
fun setClass c = class := (REFty c)
fun lookupVar v =
    if v = "this" then SOME (!class)
    else lookup v vartypes

fun findVar v = find v vartypes
fun getVarTys () = !vartypes

fun saveType (ty, v) =
	  case lookupVar v of
	      SOME t1 =>
		    if tysUnequal ty t1 then
		        raise dataflowError ( "Trying to reuse variable "
				              ^ v ^ " (of type " ^ tyToString t1
				              ^ ") with new type " ^ tyToString ty)
		    else ()
	    | NONE =>
		    let
		        val _ = pr ("Declaring " ^ v ^ "\n")
		    in
		        vartypes := (v, ty)::(!vartypes)
		    end

fun dumpLocals () =
	  let
	      val l = !vartypes
	      fun dl [] n = ()
	        | dl ((name,_)::t) n =
		        (BasicIO.print ((Int.toString n) ^ ": " ^ name ^"\n");
		         dl t (n-1))
	  in dl l (List.length l - 1)
	  end

end  (* stuff for Grail local vars *)


local (* stuff about Grail function names *)

    val fnames: ident list ref = ref []

    fun member x [] = false
      | member x (h::t) = if x=h then true else member x t
in
fun resetFunInfo() = fnames := []
fun marked fname = member fname (!fnames)
fun mark fname = if not (marked fname) then fnames := fname:: (!fnames)
	 	             else raise dataflowError ( "Trying to re-mark function " ^ fname )
fun numMarkedFuns() = length (!fnames)
end (* stuff about Grail function names *)


(* ---- Finding types ---- *)

fun typeOfVar v =
    case lookupVar v of
	NONE => raise dataflowError ("Don't know type of variable " ^ v)
      | SOME t => t

fun typeOfValue w =
    case w of
	VARval v      => typeOfVar v
      | BYTEval _     => BYTEty
      | SHORTval _    => SHORTty
      | INTval _      => INTty
      | LONGval _     => LONGty
      | CHARval _     => CHARty
      | FLOATval _    => FLOATty
      | DOUBLEval _   => DOUBLEty
      | STRINGval _   => REFty "java.lang.String"
      | NULLval (t,_) => REFty t

fun typeOfPrimop p =
    case p of
	VALop v => SOME(typeOfValue v)
      | BINop(oper,v,w) =>
	let val t1 = typeOfValue v
	    val t2 = typeOfValue w
	in
	    if t1=INTty andalso t2=INTty
	    then SOME(INTty)
	    else if t1=FLOATty andalso t2=FLOATty
	    then SOME(FLOATty)
	    else
	        raise dataflowError ("Arithmetic operator applied to non-numeric/mixed types")
	end
      | NEWop (MDESC(_,s,_),_)                 => SOME (REFty s)
      | CHECKCASTop (s,_)                      => SOME (REFty s)
      | INSTANCEop  _                          => SOME INTty
      | GETFIELDop (_,FDESC (ty,_))            => SOME ty
      | GETSTATICop (FDESC (ty,_))             => SOME ty
      | INVOKEVIRTUALop (_,MDESC(rty,_,_),_)   => rty
      | INVOKEINTERFACEop (_,MDESC(rty,_,_),_) => rty
      | INVOKESPECIALop (_,MDESC(rty,_,_),_)   => rty
      | INVOKESTATICop (MDESC(rty,_,_),_)      => rty
      | PUTFIELDop _                           => NONE
      | PUTSTATICop _                          => NONE
      | MAKEop (a,_) => raise dataflowError "The make operation is not allowed yet"
                                            (* SOME(ARRAYty(typeOfValue(a))) *)
      | GETop (aa,_) =>
	(
	 case typeOfValue(aa) of
	     ARRAYty(ty) => SOME(ty)
	   | _ => (raise dataflowError ("First argument of get must be of array type"))
	)
      | SETop (aa,_,_) => NONE
      | LENGTHop _     => SOME INTty
      | EMPTYop(v,t)   => SOME (ARRAYty t)
      | FTOIop _       => SOME INTty
      | ITOFop _       => SOME FLOATty


fun typeOfFunCall f args = !methodReturnType (* FIX THIS (also below); kwxm *)

fun typeOfPrimRes (OPres p) = typeOfPrimop p
  | typeOfPrimRes VOIDres = NONE
  | typeOfPrimRes (FUNres _ ) = !methodReturnType (* Crude *)

fun numeric INTty = true
  | numeric FLOATty = true
  | numeric _ = false

fun typeOfResult r =
    case r of
	PRIMres p => typeOfPrimRes p
      | CHOICEres (v,tst,w, p1,p2) =>
	let val t = typeOfValue v
	    val t' = typeOfValue w
	    val () = if tysUnequal t t'
		     then raise dataflowError "Test arguments have different types"
		     else ()
	    val () = case tst of
	                 EQtest => ()
	               | NEtest => ()
	               | _ => if not (numeric t)
		              then raise dataflowError "Numerical test applied to non-numerical values"
		              else ()
	    val t1 = typeOfPrimRes p1
	    val t2 = typeOfPrimRes p2

	in
	    if rtysUnequal t1 t2
	    then raise dataflowError ("Test branches have different types")
	    else t1
	end
      | CASEres (v, low, high, cases) =>
	let in case cases of
		   [] => raise dataflowError "No cases in case statement"
		 | ((_, fname, args)::rest) =>
		   let
		       val t0 = typeOfFunCall fname args
		       fun ok (_,f,a) =
			   let val t1 = typeOfFunCall f a
			   in if t1 = t0 then ()
			      else raise dataflowError "cases have incomaptible return types"
			   end
		       val () = app ok rest
		   in
		       t0
	       end
	end

fun findTypesForLetDecs l fname =
    let
        fun findTypesFor1 (VOIDdec _) = ()
          | findTypesFor1 (VALdec (v,p)) =
	          let in case typeOfPrimop p of
	                     NONE => raise dataflowError
                                   ("You're trying to assign a void value to the variable "
				    ^ v
				    ^ " in function "
				    ^ fname)
	                   | SOME ty => saveType (ty, v)
	          end
    in
	app findTypesFor1 l
    end


fun findTypesForPrimRes p funs =
    case p of FUNres (fname, _) => findTypesForFuns fname funs
            | _ => ()

and findTypesForFuns fname funs =
    if marked fname then ()  (* Back up *)
    else
        let
	    fun findFun fname [] = raise dataflowError ("Can't find function " ^ fname )
              | findFun fname ((h as FDEC(name,_,_))::t) =
			          if name = fname then h
			          else findFun fname t
            val () = mark fname
            val (FDEC(_,_,fbody)) = findFun fname funs
        in
	          findTypesForFunBody fbody funs fname
        end


and findTypesForFunBody (fbody as FUNbody(letdecs, result)) funs fname =
    let
       val () = findTypesForLetDecs letdecs fname
    in
        case result of PRIMres p => findTypesForPrimRes p funs
                     | CHOICEres (_,_,_, p, q) =>
		       (findTypesForPrimRes p funs; findTypesForPrimRes q funs)
		     | CASEres (_,_,_,cases) =>
		       app (fn (_,fname,_) => findTypesForFuns fname funs) cases
    end


fun findTypesForMethodBody (mbody as MBODY(letdecs, funs, result)) mname =
    let
        val () = findTypesForLetDecs letdecs mname
        val () = case result of
		     PRIMres p => findTypesForPrimRes p funs
                   | CHOICEres (_,_,_, p, q) =>
		     (findTypesForPrimRes p funs; findTypesForPrimRes q funs)
		     | CASEres (_,_,_,cases) =>
		       app (fn (_,fname,_) => findTypesForFuns fname funs) cases
    in
        if length funs <> numMarkedFuns()
	      then raise dataflowError ("Strange - there are some unvisited functions")
	      else ()
    end


in

fun getMethodVarTypes cname (mdef as MDEF (_, _, mname, args, mbody)) =
    let
	val () = resetVarInfo ()
	val () = resetFunInfo ()
	val () = setClass cname
	val () = app saveType args
	val () = findTypesForMethodBody mbody mname
    in
	getVarTys ()
    end

end (* local (typechecking) *)

end (* local open GrailAbsyn *)



(* Initialise liveness equations, translating AST *)

local
 fun Result r = (r, LIVE([],[]))
 fun LetDec d = (d, LIVE([],[]))
 fun FunBody (G.FUNbody(lets,res)) = FUNbody(map LetDec lets, Result res)
 fun FunDec (G.FDEC(name, args, fbody)) = FDEC(name,args, FunBody fbody)
 fun MethodBody (G.MBODY(lets, funs,r)) =
     MBODY(map LetDec lets, map FunDec funs, Result r)
 fun MethodDef (G.MDEF(f,r,s,args,mbody)) = MDEF(f,r,s,args,MethodBody mbody)
in
 fun annotateClassDef (G.CDEF(f,s,sup,intf,fields,meths,layout)) = CDEF(f,s,sup,intf,fields,map MethodDef meths, layout)
end


(* Translate AST back, throw liveness equations away *)

local
 fun GResult (r,_) = r
 fun GLetDec (d,_) = d
 fun GFunBody (FUNbody(lets,res)) =
     G.FUNbody(map GLetDec lets, GResult res)
 fun GFunDec (FDEC(name, args, fbody)) =
     G.FDEC(name,args, GFunBody fbody)
in
 fun unannotateMethodBody (MBODY(lets, funs,r)) =
     G.MBODY(map GLetDec lets, map GFunDec funs, GResult r)
 fun unannotateMethodDef (MDEF(f,r,s,args,mbody)) =
     G.MDEF(f,r,s,args,unannotateMethodBody mbody)
 fun unannotateClassDef (CDEF(f,s,sup,intfs,fields,meths,layout)) =
     G.CDEF(f,s,sup,intfs,fields,map unannotateMethodDef meths,layout)
end


fun insertMap (map, f, pair) = Binarymap.insert(map,f,pair)
fun peekMap (map, f) = Binarymap.peek(map,f)
fun findMap (map,f) = Binarymap.find(map,f)

(* Ordered list insertion/append *)
fun insert (x, (h::t)) =
    if x < h then x::h::t
    else if x = h then h::t
    else h::(insert(x,t))
  | insert (x, []) = [x]
fun append a l = foldl insert l a
fun concapp [] l = l
  | concapp (h::t) l = concapp t (append h l)

(* uXXX: liveness computation. u=use, from variable use.             *)
(* We infer variables types at the same time, as temporaries need    *)
(* this. Produces a mapping from method names to type/variable lists *)

local (* for uClassDef *)

local (* for uFunBody *)

    (* use*: Calculate the variables used by a result/primop *)

    fun useValue v acc =
	case v of
	    G.VARval x => x::acc
          | _ => acc

    fun useValue' (v, acc) = useValue v acc  (* for folding *)

    fun usePrimOp p acc =
	case p of
	    G.VALop v => useValue v acc
          | G.BINop(_,v,v') => useValue v (useValue v' acc)
          | G.NEWop(_, vs) => foldr useValue' acc vs
          | G.CHECKCASTop(_,var) => var::acc
          | G.INSTANCEop(_,var) => var::acc
          | G.INVOKESTATICop(_,vs) => foldr useValue' acc vs
          | G.INVOKEVIRTUALop(v,_,vs) => v::(foldr useValue' acc vs)
          | G.INVOKEINTERFACEop(v,_,vs) => v::(foldr useValue' acc vs)
          | G.INVOKESPECIALop(v,_,vs) => v::(foldr useValue' acc vs)
          | G.GETFIELDop(v,_) => v::acc
          | G.PUTFIELDop(v,_,v') => v::(useValue v' acc)
          | G.GETSTATICop _ => acc
          | G.PUTSTATICop(_, v) => useValue v acc
          | G.MAKEop(v,v') => useValue v (useValue v' acc)
          | G.GETop(v,v') => useValue v (useValue v' acc)
          | G.SETop(v,v1,v2) => (useValue v (useValue v1 (useValue v2 acc)))
          | G.LENGTHop v => useValue v acc
          | G.EMPTYop(v,_) => useValue v acc
          | G.FTOIop v  => useValue v acc
          | G.ITOFop v => useValue v acc

    fun usePrimRes r acc =
	case r of
	    G.OPres p => usePrimOp p acc
          | G.VOIDres => acc
          | G.FUNres(f, vars) => acc (* Yes, acc. *)

    fun useRes r acc =
	case r of
	    G.PRIMres p              => usePrimRes p acc
          | G.CHOICEres(v,t,v',p,p') => useValue v (useValue v' (usePrimRes p (usePrimRes p' acc)))
	  | G.CASEres(v,l,h,cases)   => v::acc (* ??? *) (* kwxm *)  (* FIX THIS *)

        (* iter: Do an actual iteration of liveness computation for a   *)
        (* function body. First argument is *reversed* list of valdecs, *)
        (* accumulator ends up with *non-reversed* list of valdecs with *)
        (* updated dataflow equations                                   *)

    fun getLiveVars [] _ acc = acc
      | getLiveVars ((d,_)::t) ins acc =
	let in
	case d of
	    G.VALdec(v,p) =>
	    let
		val ins' = append (usePrimOp p []) (List.filter (fn x=>x<>v) ins)
	    in
		getLiveVars t ins' ((d,LIVE(ins',ins))::acc)
	    end
	  | G.VOIDdec p =>
	    let
		val ins' = append (usePrimOp p []) ins
	    in
		getLiveVars t ins' ((d,LIVE(ins',ins))::acc)
	    end
	end

    (* Alter the variables used in function calls, *)
    (* as they're really just annotations *)

    fun alterPrim oo p =
	case p of
	    G.FUNres(f,vars) => G.FUNres(f,oo)
          | _ => p

    fun alterResult [o1] (G.PRIMres pres, e) = (G.PRIMres(alterPrim o1 pres), e)
      | alterResult [o1, o2] (G.CHOICEres(v,t,v',pres,pres'),e) =
        (G.CHOICEres(v,t,v',alterPrim o1 pres, alterPrim o2 pres'),e)
      | alterResult os (G.CASEres (v,l,h,cases),e) =
	(G.CASEres (v,l,h,ListPair.map (fn (oo,(n,fname,_)) => (n,fname,oo)) (os,cases)),e)
      | alterResult _ _ = raise dataflowError "Length mismatch in alterResult"
        (* could also get mismatch in CASEres case (but don't) *)

in

fun uFunBody (FUNbody(lets, (result, _))) funEqMap =
    let
        fun lookupFun f = findMap(funEqMap,f)
            handle NotFound => ([],[]) (* not entered yet *)

        (* Now calculate live-in and live-out for the result *)

        fun outs (G.FUNres(f,_)) = #1 (lookupFun f)
          | outs _ = []

        val routs_list =
            case result of
                G.PRIMres res => [outs res]
              | G.CHOICEres (_,_,_, res, res') => [outs res, outs res']
	      | G.CASEres(_,_,_,cases) => map (fn (_,f,_) => #1 (lookupFun f)) cases

        val routs = concapp routs_list [] (* does the order matter ? *)
        val rins = append (useRes result []) routs
        val r' = (alterResult routs_list)
                     (result, LIVE(rins, routs))
                     (* live-in and live-out for the body *)
        val lets' = getLiveVars (rev lets) rins []
                      (* A function's live-in is that of the first valdec or the result *)
        val ins = case lets' of
                      [] => rins
                    | (_,LIVE(ii,oo))::_ => ii
    in
        (FUNbody(lets', r'), (ins, routs))
    end

end (* local for uFunBody *)

fun uFunDecs ((FDEC(f,args,body)::rest)) acc change funEqMap tys0 =
    let
        val tys' = tys0 @ args
        fun addtype n =
            case List.find (fn (ty,v) => v=n) (tys') of
                SOME (ty,v) => (ty, n)
              | NONE => (G.INTty, n)
        val (ins, outs) = case peekMap(funEqMap,f) of
                              SOME x => x
                            | NONE => ([],[])
        val _ = (debugPrint ("["^f^"]>>"); prPair (ins,outs))
        val (body, (ins', outs')) = uFunBody body funEqMap
        val fdec = FDEC(f, map addtype ins',body)
        val funEqMap' = insertMap(funEqMap, f, (ins', outs'))
        val () = debugPrint ("["^f ^ "]::" ^"ins: "^
                             (Int.toString (length ins)) ^ "; ins': " ^
                             (Int.toString (length ins'))
                             ^ "; outs: " ^ (Int.toString (length outs))
                             ^ "; outs': " ^ (Int.toString (length outs'))
                             ^ "\n")
    in
        if not change andalso length ins = length ins'
           andalso length outs = length outs'
        then uFunDecs rest (fdec::acc) false funEqMap' tys'
        else (debugPrint "Change detected\n";
              uFunDecs rest (fdec::acc) true funEqMap' tys')
    end
  | uFunDecs [] [] _ funEqMap tys =
    (debugPrint "Method with no functions\n"; ([],[]))
  | uFunDecs [] acc true funEqMap tys =
    (debugPrint "Finished iteration\n";
     uFunDecs (rev acc) [] false funEqMap tys)
  | uFunDecs [] acc false funEqMap tys =
    (debugPrint "Finished last iteration\n"; (rev acc, tys))

  (* The lets and result of the method are made into a dummy function, which *)
  (* is later extracted. This is a natural mapping, and avoids duplication.  *)

fun uMethodBody (MBODY(lets,funs,r)) tys =
    let
        val funEqMap = Binarymap.mkDict String.compare

        val fdec = FDEC("_",[],FUNbody(lets,r))

        val (funs',tys') = uFunDecs (fdec::funs) [] false funEqMap tys
        val (lets',r', funs') =
            case funs' of ((FDEC("_", _, FUNbody(lets',r')))::t) =>
                          (lets', r', t)
                        | _ => raise flowError "Lost dummy function"
    in
        (MBODY(lets', funs', r'), tys')
    end

fun uMethodDef (MDEF(f,ty,s,args,mbody)) =
    let
        val (mbody', args') = uMethodBody mbody args
    in
        (MDEF(f,ty,s,args,mbody'), args')  (* args or args' in MDEF? *)
    end

in

fun uClassDef (CDEF(f,s,sup,intfs,fields,meths,layout)) =
    let
        val mdef_tys = map uMethodDef meths
        val mdefs = map #1 mdef_tys
        val tymap = map (fn (MDEF(_,_,mname,_,_), tys) => (mname, tys))
                        mdef_tys
    in
        (CDEF(f,s,sup,intfs,fields,mdefs,layout), tymap)
    end

end

fun colour (n::select) interf coloured colouring (tys: (string * G.Ty) list) =
    let
        fun getcol w = case List.find (fn (x,_)=>x=w) colouring of
                           SOME (x,c) => c
                         | NONE => ~1 (* Not used, check coloured first *)
        fun swap (a, b) = (if a < b then (a, b) else (b, a))
        fun interferes x y = Binaryset.member(interf, swap (x,y))

        fun adj n w = interferes n w orelse
                      case List.find (fn (x, _) => x=n) tys of
                          SOME (_,ty) =>
                          List.exists (fn (y, ty') => y=w andalso tysUnequal ty ty') tys
                        | NONE => false
        fun getbad (w::ws) =
            if adj n w then
                (getcol w)::(getbad ws)
            else
                getbad ws
          | getbad [] = []

        val bad = getbad coloured

        fun gencol n =
            if Util.member n bad then
                gencol (n+1)
            else
                n

        val c = gencol 0
    in
        colour select interf (n::coloured) ((n,c)::colouring) tys
    end
  | colour [] interf coloured colouring tys = colouring

fun allocate (MDEF(flags,rty,mname,m_args,mbody)) interf tys =
    let
        val vars = map #1 tys
        fun pre (h::t) n = (h,n) :: pre t (n+1)
          | pre [] n = []
	val argnames = map #2 m_args
        val precolourings = pre argnames 0
        val colourings = colour vars interf argnames precolourings tys

        val () = app (fn (n,c) => debugPrint
                                      (n ^"="^(Int.toString c)^" "))
                     colourings
        val () = debugPrint "\n"
    in
        (colourings, precolourings)
    end

fun rename tr pre cname (MDEF(f,ty,s,m_args,mbody)) tys (* string -> Ty *) =
    let
    fun getTy var = if var = "this" then
                        G.REFty cname
                    else case List.find (fn (x,_) => x=var) tys of
                             SOME (_,ty) => ty
                           | NONE => raise flowError ("Type for variable "^var^" not found")

    fun renameVar x =
        case List.find (fn (a,_) => a=x) tr of
            SOME (_,c) =>
            (
	     case List.find (fn (_,c') => c=c') pre of
                 SOME (y,_) => y
               | NONE => G.tyPrefix (getTy x) ^ Int.toString c
	    )
          | NONE => x (* FIX: is this an error? *)

    fun renameValue (G.VARval v) = G.VARval(renameVar v)
      | renameValue x = x


    fun renameEqs (LIVE(ii,oo)) = LIVE(map renameVar ii, map renameVar oo)

    fun renamePrim p =
	case p of
	    G.VALop v                       => G.VALop(renameValue v)
          | G.BINop(oper,v,v')              => G.BINop(oper, renameValue v, renameValue v')
          | G.NEWop(mdesc,vs)               => G.NEWop(mdesc, map renameValue vs)
          | G.CHECKCASTop(x,v)              => G.CHECKCASTop(x,renameVar v)
          | G.INSTANCEop(x,v)               => G.INSTANCEop(x, renameVar v)
          | G.INVOKESTATICop(mdesc,vs)      => G.INVOKESTATICop(mdesc, map renameValue vs)
          | G.INVOKEVIRTUALop(v,mdesc,vs)   => G.INVOKEVIRTUALop(renameVar v, mdesc, map renameValue vs)
          | G.INVOKEINTERFACEop(v,mdesc,vs) => G.INVOKEINTERFACEop(renameVar v, mdesc, map renameValue vs)
          | G.INVOKESPECIALop(v,mdesc,vs)   => G.INVOKESPECIALop(renameVar v, mdesc, map renameValue vs)
          | G.GETFIELDop(v,fld)             => G.GETFIELDop(renameVar v, fld)
          | G.PUTFIELDop(v,fld,v')          => G.PUTFIELDop(renameVar v, fld, renameValue v')
          | G.GETSTATICop fdesc             => G.GETSTATICop fdesc
          | G.PUTSTATICop(fdesc, v)         => G.PUTSTATICop(fdesc, renameValue v)
          | G.MAKEop(v,v')                  => G.MAKEop(renameValue v, renameValue v')
          | G.GETop(v,v')                   => G.GETop(renameValue v, renameValue v')
          | G.SETop(v,v',v'')               => G.SETop(renameValue v, renameValue v', renameValue v'')
          | G.LENGTHop v                    => G.LENGTHop(renameValue v)
          | G.EMPTYop(v,ty)                 => G.EMPTYop(renameValue v, ty)
          | G.FTOIop v                      => G.FTOIop(renameValue v)
          | G.ITOFop v                      => G.ITOFop(renameValue v)

    fun renameLet (d,eq) =
	case d of
	    G.VALdec(x,oper) =>
            let
		val x = renameVar x
		val oper' = renamePrim oper
            in
		if oper' = G.VALop(G.VARval(x))
		then NONE (* FIX: what's happening here? *)
		else SOME (G.VALdec(x,oper'),renameEqs eq)
            end
	  | G.VOIDdec oper =>  SOME (G.VOIDdec(renamePrim oper), renameEqs eq)

    fun renamePres p =
	case p of
	    G.OPres oper => G.OPres(renamePrim oper)
	  | G.VOIDres => G.VOIDres
	  | G.FUNres(f,vs) => G.FUNres(f, map renameVar vs)

    fun renameCase (n,f,vs) = (n, f, map renameVar vs)

    fun renameRes (r,eqs) =
	case r of
	    G.PRIMres pres =>
	      (G.PRIMres(renamePres pres),renameEqs eqs)
	  | G.CHOICEres(v,t,v',pres,pres') =>
              (G.CHOICEres(renameValue v, t, renameValue v',
                      renamePres pres, renamePres pres'), renameEqs eqs)
	  | G.CASEres(v,l,h,cases) =>
              (G.CASEres(renameVar v, l, h,
                    map renameCase cases), renameEqs eqs)

    fun renameFunBody (FUNbody(lets, res)) =
        FUNbody(List.mapPartial renameLet lets, renameRes res)

    fun renameFun (FDEC(f,args,body)) =
        let
            val args' = map (fn (_,x) => (getTy x, renameVar x)) args
        in
            FDEC(f,args',renameFunBody body)
        end

    fun renameMBody (MBODY(lets,funs,r)) =
        MBODY(List.mapPartial renameLet lets,
              map renameFun funs, renameRes r)

    fun renameArgs args =
        let
            val args' = map (fn (_,x) => (getTy x, renameVar x)) args
        in
	    args'
        end
    in
        MDEF(f,ty,s,renameArgs m_args,renameMBody mbody)
    end


local (* interference *)

fun union a b = Binaryset.union(a,b)
infix 1 U
fun a U b = Binaryset.union(a,b)
fun compare ((a,b), (c,d)) =
    if a=c then String.compare (b,d)
    else String.compare (a,c)
fun swap (a, b) = (if a < b then (a, b) else (b, a))
fun add s ys = Binaryset.addList(s, (map swap ys))
fun empty () = Binaryset.empty compare


fun pairs l = (* lower triangular part of l*l *)
    let fun f x m =
	    map (fn y => (x,y)) m
	fun g l S =
	    case l of [] => S
		    | h::t =>
			  g t (add S (f h t))
    in
	g l (empty ())
    end



(* UNDERSTAND WHAT THE NEXT FUNCTION'S DOING *)

fun interfereEqs0 x y (LIVE(ii,oo)) =  (* BE CAREFUL HERE *)
    let  (* HAD replaced x::ii with ii for some reason (all of them) *)
        val xs = List.filter (fn z=>z<>y) (x::oo)    (* AND HERE *)
    in
	pairs xs
    end

fun interfereEqs1 x (LIVE(ii,oo)) = pairs (x::oo)

fun interfereEqs2  (LIVE(ii,oo)) = pairs oo

(* DOES THIS EVER MAKE ANY DIFFERENCE ??? *)


fun interfereLets l =
    case l of
	[] => empty ()
      | (d, eqs)::t =>
	let (*
	    val () = G.prLetDec d
	    val () = print "\n"
	     *)
	in
	    case d of
		G.VALdec(x, G.VALop(G.VARval y)) => (interfereEqs0 x y eqs) U (interfereLets t)
	      | G.VALdec (x,_) => (interfereEqs1 x eqs) U (interfereLets t)
	      | G.VOIDdec _ =>  (interfereEqs2 eqs) U (interfereLets t)
	end

fun interfereRes (_, eqs) = interfereEqs2 eqs

fun interfereFun (FDEC(f,args,FUNbody(lets,r))) =
    (interfereRes r) U (interfereLets lets)

fun interfereFuns (f::fs) =
        interfereFun f U interfereFuns fs
  | interfereFuns [] = empty ()


fun interfereArgs args = (* all args interfere with each other *)
    pairs (map #2 args)

fun interfereMBody args (MBODY(lets,funs,r)) =
    interfereArgs args
    U interfereLets lets
    U interfereFuns funs
    U interfereRes r


fun interfereMethodDef (MDEF(_,_,f,args,mbody)) =
    let
        val interf = interfereMBody args mbody
    in
        debugPrint ("Interfrence for " ^ f ^ ":: ");
        Binaryset.app (fn (x,y) => debugPrint ("("^x^","^y^") ")) interf;
        debugPrint "\n";
        (f,interf)
    end


in

fun interfereClassDef (CDEF(_,_,_,_,_,meths,_)) = map interfereMethodDef meths

end (* interference *)


 (*----------------- Printing abstract syntax -----------------*)

 (* Same as for Grail,  except that we print equations as well *)

local

fun prResult (r,eqs) = (G.prResult r; prEqs eqs)
fun prLetDec (d, eqs) = (G.prLetDec d; prEqs eqs)
fun prFunBody (FUNbody(letdecs, result)) =
    if letdecs = nil then prResult result
    else
        (G.nl "let";
         G.incIndent();
         app prLetDec letdecs;
         G.decIndent();
         G.nl "in";
         prResult result;
         G.nl "end"
        )

fun prFunDec (FDEC (fname, params, fbody)) =
    (
     G.Prl "";
     G.nl("fun " ^ fname );
     G.prTyVarVec params;
     G.Pr " =";
     prFunBody fbody
    )

fun prMethodBody (MBODY(letDecs, funDecs, result)) =
    (
     G.nl "let";
     G.incIndent();
     app prLetDec letDecs;
     app prFunDec funDecs;
     G.decIndent();
     G.nl "in";
     prResult result;
     G.nl "end\n"
    )

fun prMethodDef (MDEF(flags, rty, name, params, mbody)) =
    (
     G.nl "method ";
     app G.prMflag flags;
     G.prRTy rty;
     G.Pr (" " ^ name ^ " ");
     G.prTyVarVec params;
     G.Pr " =";
     prMethodBody mbody
    )
in

fun prClassDef (CDEF (flags, cname, sup, intfs, fdefs, mdefs,_)) =
    (
     app G.prCflag flags;
     G.Pr ("class " ^ cname ^ " {");
     G.incIndent();
     app G.prFieldDef fdefs;
     app prMethodDef mdefs;
     G.decIndent();
     G.Prl "}"
    )

end


(*---------------- Interface functions ----------------*)

local
fun allocRenameMdef cname intf tymap
                    (mdef as (MDEF(flags, rty, mname, args, mbody))) =
    let
        val tys = getMethodVarTypes cname (unannotateMethodDef mdef)
        (* FIX: could use the original mdef instead of converting /both/ ways! *)
        val interf =
            case List.find (fn (m,_) => m=mname) intf of
                SOME (_,x) => x
              | NONE => raise flowError ("Interference graph not found for " ^ mname)
	val vars = map #1 tys
        val () = debugPrint("vars: " ^
                            (String.concat (map (fn f =>  (f ^ " ")) vars)) ^
                            "\n")
        val (alloc, pres) = allocate mdef interf tys
    in
        rename alloc pres cname mdef tys
    end

fun allocRename intf tymap (CDEF(flags,cname,sup,intfs,fields,meths,layout)) =
    CDEF(flags,cname,sup,intfs,fields,map (allocRenameMdef cname intf tymap) meths, layout)

in

fun consolidate cdef  =
    let
        val cdef1 = annotateClassDef cdef
        val (cdef2, tymap) = uClassDef cdef1  (* AST with liveness annotations *)
        val intf = interfereClassDef cdef2
        val cdef3 = allocRename intf tymap cdef2
        val res = unannotateClassDef cdef3
	val () = if debugging ()
		 then
		     let  val (cdef4, tymap) = uClassDef cdef3
		     in
			 (prClassDef cdef2; prClassDef cdef3; prClassDef cdef4)
		     end
		 else ()
    in
        res
    end
end

end (* local structure ... *)



(*

(*
fun pairs (x::xs) ys acc =
    let val () =
	    debugPrint ("adding pairs: {" ^ Util.listToString id ", " (x::xs) ^ "} & {"
			^ Util.listToString id ", " ys ^ "}\n")
    in
	pairs xs ys (add acc (List.mapPartial
				  (fn y => if x = y then NONE else SOME (x,y))
                              ys))
    end
  | pairs [] _ acc = acc
*)

(*
(* UNDERSTAND WHAT THE NEXT FUNCTION'S DOING *)

fun interfereEqs0 x y (LIVE(ii,oo)) =  (* BE CAREFUL HERE *)
    let  (* HAD replaced x::ii with ii for some reason (all of them) *)
        val xs = List.filter (fn z=>z<>y) (x::ii)    (* AND HERE *)
    in
	pairs xs
    end



fun interfereEqs1 x (LIVE(ii,oo)) =
    let
	val i = diff ii oo
	val () = print ("Live-in: " ^ Util.listToString id ", " ii ^ "\n")
	val () = print ("Live-out: " ^ Util.listToString id ", " oo ^ "\n")
	val () = print ("Diff: " ^ Util.listToString id ", " i ^ "\n")
    in
	pairs (x::i)
    end

(* DOES THIS CREATE EXTRA PAIRS??? *)
(* Maybe,  but "add" canonicalises them so it's ok *)
(* but perhaps we could do a triangular thing to make the pairs *)

fun interfereEqs2  (LIVE(ii,oo)) =
    let
	val i = diff ii oo
    in
	pairs ii
    end

fun interfereLets l =
    case l of
	[] => empty ()
      | (d, eqs)::t =>
	let
	    val () = G.prLetDec d
	    val () = print "\n"
	in
	    case d of
		G.VALdec(x, G.VALop(G.VARval y)) => (interfereEqs0 x y eqs) U (interfereLets t)
	      | G.VALdec (x,_) => (interfereEqs1 x eqs) U (interfereLets t)
	      | G.VOIDdec _ =>  (interfereEqs2 eqs) U (interfereLets t)
	end
*)

*)
