import java.io.*;
import java.lang.Exception;

public class Camelotlib {
    private static void error (String s) { 
	System.out.println ("Camelot error: " + s); 
	System.exit(0);
    }

    public static String nullString () { return null; }

    public static void print_int    (int n)    { System.out.print (n); }
    public static void print_float  (float f)  { System.out.print (f); }
    public static void print_string (String s) { System.out.print (s); }
    public static void print_char (int n) { System.out.print ((char) n); }

    public static void print_newline () { System.out.println (); }
    public static void print_int_newline    (int n)    { System.out.println (n); }
    public static void print_float_newline  (float f)  { System.out.println (f); }
    public static void print_string_newline (String s) { System.out.println (s); }
    public static void print_char_newline (int n) { System.out.println ((char) n); }

    public static int int_of_string (String s) { 
	try {
	    return Integer.parseInt(s); 
	}
	catch (Exception e) {
	    error ("invalid integer (" + s + ")");
	}
	return 0; // never get here
    }

    public static float float_of_string (String s) {
	try {
	    return Float.parseFloat(s); 
	}
	catch (Exception e) {
	    error ("invalid float (" + s + ")");
	}
	return 0; // never get here
    }

    public static String string_of_char (int c) { return new Character((char) c).toString(); }
    public static String string_of_int (int n) { return Integer.toString(n); }
    public static String string_of_float (float f) { return Float.toString(f); }

    public static int string_length (String s) { return s.length(); }
    public static String append_string (String a, String b) { return a+b; }
    public static boolean same_string (String a, String b) { return a.equals(b); }
    public static int string_compare (String a, String b) { return a.compareTo(b); }

    public static String substring (String s, int start, int len) {
	String t = "";
	try {
	    t = s.substring (start, start+len); 
	}
	catch (IndexOutOfBoundsException e) {
	    error ("index out of bounds in (substring \"" + s + "\" " + start + " " + len + ")");
	}
	return t;
    }
    public static int getc (String s, int j) { 
	int i = 0;
	try {
	    i = (int)(s.charAt(j));
	}
	catch (StringIndexOutOfBoundsException e) {
	    error ("index out of bounds in (getc \"" + s + "\" " + j +")");
	}
	return i;
    }


    /****  File handling ****/

    private static boolean fileOpen = false;   // Is there an open input file?
    private static String fileName = "";       // What's it called?
    private static BufferedReader inFile = null;

    public static void open_input (String s) {
	if (fileOpen) {
	    error ("cannot open file '" + s + "' because file '" + fileName + "' is already open");
	} else {
	    try {
		inFile = new BufferedReader (new FileReader (s));
		// inFile = new BufferedReader (new InputStreamReader(System.in));
	    } 
 	    catch (FileNotFoundException e) { error ("file '" + s + "' not found"); }
	    
	    fileOpen = true;
	    fileName = s;
	}
	   
    }


    public static boolean eof () {
	if (!fileOpen) error ("eof: no input file open");
	try {
	    return (!inFile.ready ());  // Might not be eof if buffering hasn't caught up
	}
	catch (IOException e) { error ("IO error during eof()"); }
	return true;
    }

    /* Most of the Java I/O classes which provide readLine don't seem to give
       you any way of checking when you've reached the end of the file;  you 
       just read a line and see if it's null (or a character and see if it's -1).
       This is inconvenient for Camelot since we can't handle null and we can't
       raise an exception.  For the present I'm using a call to ready() on
       a BufferedReader.  This may return false before we've got to the end of 
       the file (for instance,  when System.in is waiting for a new line).
       However,  the alternative seems to be to do your own buffering;  this
       is messy (especially if you're interleaving read_char and read_line), 
       and uses memory in a nontransparent way.  I've decided to stick with 
       the present soloutino for the time being and sacrifice the ability to
       read from standard input. */


    public static String read_line () {
	if (!fileOpen) error ("read_line: no input file open");
	if (eof()) error ("end of file " + fileName);
	try {
	    return inFile.readLine();
	} 
	catch (IOException e) { error ("IO error during read_line()"); }
	return "";
    }

    public static int read_char () {
	if (!fileOpen) error ("read_char: no file open");
	if (eof()) error ("end of file " + fileName);
	try {
	    return inFile.read();
	} 
	catch (IOException e) { error ("IO error during read_char()"); }
	return '\000';
    }

   public static void close_input () {
	if (!fileOpen) {
	    error ("close_input(): no file open");
	} else {
	    try {
		inFile.close();
	    }
	    catch (IOException e) { error ("IO error during close_file()"); }
	    fileOpen = false;
	    fileName = "";
	}

    }

    /* NW: Don't seem to be able to use java.lang.System.currentTimeMillis(); workaround */
    public static String date () {
        java.text.DateFormat df = new java.text.SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        return df.format(new java.util.Date(System.currentTimeMillis()));
    }

    /* NW: whatever happend to isnull? Was I going to implement that? Gah. 
       1. I don't remember if that was meant to do what this does, or was
          meant to cover datatypes in fields
       2. I don't know why such a heavy-handed implementation was going to 
          be necessary.
    */
    public static boolean isnullobj (Object o) {
        return o == null;
    }    

    /* Stephen's sleep method for threads */

    public static void sleep(int milliseconds) {
        try {
            java.lang.Thread.currentThread().sleep(milliseconds);
        } catch (InterruptedException e) {
        }
    }
}
