val required = ()  (* To circumvent mosmldep limitation *)

type 'u Name = string * 'u
type Assn = Assertions_ASDL.assn

type tyVar = {name: string, eq: bool ref, ord: bool ref}

(* Comparisons are now overloaded;  the refs above are used
   to mark type variables for equality and order.  String
   comparisons are converted into library calls during
   monomorphisation. *)

datatype Ty =
         INTty
       | CHARty
       | BOOLty
       | FLOATty
       | STRINGty
       | UNITty
       | TVARty of tyVar
       | ARRAYty of Ty
       | PRODUCTty of Ty list
       | ARROWty of Ty * Ty
       | CONty of Ty list * string
       | DIAMONDty of string
       | OBJECTty of string

datatype HeapUsage =
         HEAP
       | NOHEAP

datatype 'u TypeCon =
         TYPEcon of 'u Name * (Ty list * 'u) * HeapUsage * 'u

datatype 'u TypeDec =
         TYPEdec of 'u Name list * 'u Name * 'u TypeCon list * 'u

datatype 'u FunAssns =
         FUNASSNS of 'u Name * Assn list * Assn list

datatype 'u Hints =
         HINTS of 'u TypeDec list * 'u FunAssns list

datatype UnaryOperator =
         NOTop
       | ISNULLop

datatype BinaryOperator =
         PLUSop  | MINUSop  | TIMESop  | DIVop | MODop
       | LANDop  | LORop    | LXORop   | LSLop | LSRop  | ASRop
       | LESSop  | LEQop    | EQUALSop
       | FPLUSop | FMINUSop | FTIMESop | FDIVop
       | CONCATop   (* String concatenation ^ *)

datatype 'u MatchDiam =
         NOWHERE
       | SOMEWHERE of 'u Name
       | DISPOSE

datatype 'u OOMatchPat =
         CLASSpat of 'u Name * 'u Name
       | ANYCLASSpat

datatype External =
	 LOCAL
       | GLOBAL
       | BUILTIN
       | EXTERN

datatype Instance =
         INSTANCE
       | STATIC

datatype 'u ValDec =
         VALdec of 'u Name * Ty * Instance
       | CLASSdec of 'u Name * 'u Name option * 'u Name list * 'u ValDec list

datatype VarTy =
	 UNITvar
       | VAR of string *  Ty option

datatype 'u Value =
	 VARval of string * External * 'u
       | CHARval of int * 'u
       | INTval of int * 'u
       | FLOATval of real * 'u
       | STRINGval of string * 'u
       | BOOLval of bool *'u
       | UNITval of 'u
       | NULLval of 'u Name

and 'u Exp =
          VALexp of 'u Value * 'u
        | UNARYexp of UnaryOperator *  'u Exp * 'u
        | BINexp of BinaryOperator * 'u Exp * 'u Exp * 'u
        | IFexp of 'u Exp * 'u Exp * 'u Exp * 'u
        | MATCHexp of 'u Exp * 'u MatchRule list * 'u
        | LETexp of 'u Name * 'u Exp * 'u Exp * 'u
        | APPexp of 'u Exp * 'u Exp list * External * 'u
        | CONexp of 'u Name * 'u Exp list * 'u Name option * 'u
(*	| TUPLEexp of 'u Exp list*)
        | TYPEDexp of 'u Exp * Ty * 'u
        | COERCEexp of 'u Exp * Ty * 'u
        | INVOKEexp of 'u Exp * 'u Name * 'u Exp list * 'u
        | NEWexp of 'u Name * 'u Exp list * 'u
        | GETexp of 'u Exp * 'u Name * 'u
        | SGETexp of 'u Name * 'u
        | UPDATEexp of 'u Name * 'u Exp * 'u
        | SUPERMAKERexp of 'u Exp list * 'u
        | ASSERTexp of 'u Exp * Assn list * Assn list * 'u
        | LAMexp of VarTy list * 'u Exp * 'u

    and 'u MatchRule =
          MATCHrule of 'u Name * 'u Name list * 'u MatchDiam * 'u Exp * 'u
        | OOMATCHrule of 'u OOMatchPat * 'u Exp * 'u

datatype 'u FunDef =
         FUNdef of 'u Name * VarTy list * Instance * 'u Exp * 'u

datatype 'u FunBlock =
	 FUNblock of 'u FunDef list

datatype 'u ClassDef =
         CLASSdef of
	 'u Name *           (* Class name *)
         'u Name option *    (* Superclass *)
         'u Name list *      (* Interfaces *)
         'u ValDec list *    (* Fields *)
         'u FunDef list      (* Methods *)
(* Prevously contained args and superArgs,  but these seemed to be unused *)

datatype 'u Program =
         PROG of 'u TypeDec list * 'u ValDec list
		 * 'u ClassDef list * 'u FunBlock list

type monoInfo = string * (string * Ty) list
type phiInfo = string * Ty

datatype Annotation =
	 LOC of Loc.Location
       | MONO of monoInfo * Annotation
       | PHI of phiInfo * Annotation

val nowhere = LOC Loc.nilLocation


(* NOTES on syntax for expressions *)
(*

  All of the expression classes contain one or more polymorphic
  entries of type 'u.  This is used to contain stuff like locations
  and annotations required for monomorphisation etc.  Presumably we
  have to discard this information if we want to use ASDL.  This
  might cause problems if we need to report errors at some stage
  after we've got syntax back from LFD inference.


  VALexp (v, _) is a value expression (ie, constant or variable name)

  UNARYexp (oper, e, _) is a unary operator applied to the expression e

  BINexp (oper, e1, e2, _) is a binary operator applied to the expressions e1 and e2

  IFexp (e, e1, e2, _) is "if e then e1 else e2"

  MATCHexp (e, [r1, r2, ...], _) is "match e with r1 -> ... | r2 -> ... | ..."

  LETexp (n, e, e', _) is "let n = e in e'"

  APPexp (e, [e1, e2, ...], ext, _) is the function application
   "e  e1 e2 ...".  ext is a marker saying whether the function represented by e
   is a Camelot function or a Java method.

  CONexp (c, [e1, e2, ...], d, _) is a constructor application "c(e1, e2, ...)"
   d represents a diamond annotation.

  TYPEDexp (e, t,_) is an expression with a type annotation supplied by the programmer,
   eg "1+(x:int)".  Mostly used for type constraints in argument lists.

  COERCEexp (e, t, _) corresponds to "e :> t" for OO typecasting.

  INVOKEexp (e, s, [e1, e2, ...], _) corresponds to method
   invocation "e#s e1 e2 ..."

  NEWexp (s, [e1, e2, ...], _) is "new s (e1, e2, ...)" where s is a classname.

  GETexp (e, s, _) is instance field access: e is the classname,
   s is the field name.

  SGETexp (s,_) is static filed access (like java.math.BigInteger.ONE)

  UPDATEexp (s, e, _) is instance field update: "s <- e".  This
   doesn't seem to correspond to what's in the O'Camelot paper: in the
   paper you say "object#field <- value" whereas the compiler only
   allows you to say "ident <- value" and compiles it into a putfield
   operation on the appropriate field of the current class ("this").
   Presumably if you want to update a field of some other class X then
   you have to equip X with a "set" method to do the updating (as
   required by good OO practice).

  ASSERTexp (e, l1, l2, _) was added by Michal for some reason,  but we
   don't use it anywhere.  These are currently discarded during code
   emission.

*)
