import java.io.*;
import java.lang.Exception;

public class Camelotlib {
    private static void error (String s) { 
	System.err.println(s);
	System.exit(0);
    }


    public static int int_of_string (String s) { 
	try {
	    return Integer.parseInt(s); 
	}
	catch (Exception e) {
	    error ("Bad int");
	}
	return 0; // never get here
    }


    public static String nullString () { return null; }

    public static void print_int    (int n)    { System.out.print (n); }
    public static void print_string (String s) { System.out.print (s); }
    public static void print_char (int n) { System.out.print ((char) n); }

    public static void print_newline () { System.out.println (); }
    public static void print_int_newline    (int n)    { System.out.println (n); }
    public static void print_string_newline (String s) { System.out.println (s); }
    public static void print_char_newline (int n) { System.out.println ((char) n); }

    public static String string_of_char (int c) { return new Character((char) c).toString(); }
    public static String string_of_int (int n) { return Integer.toString(n); }

    public static int string_length (String s) { return s.length(); }
    public static String append_string (String a, String b) { return a+b; }
    public static boolean same_string (String a, String b) { return a.equals(b); }
    public static int string_compare (String a, String b) { return a.compareTo(b); }

    public static String substring (String s, int start, int len) {
	String t = "";
	try {
	    t = s.substring (start, start+len); 
	}
	catch (IndexOutOfBoundsException e) {
	    error ("index out of bounds in (substring \"" + s + "\" " + start + " " + len + ")");
	}
	return t;
    }
    public static int getc (String s, int j) { 
	int i = 0;
	try {
	    i = (int)(s.charAt(j));
	}
	catch (StringIndexOutOfBoundsException e) {
	    error ("index out of bounds in (getc \"" + s + "\" " + j +")");
	}
	return i;
    }

}
