fun icmp (a:int) (b:int) = a<=b
fun scmp (a:string) (b:string) = a<=b

fun insert n l cmp = 
  case l of [] => n::[]
             | (h::t) => if cmp n h then n::h::t
                       else h::(insert n t cmp)
fun sort l cmp = 
  case l of [] => []
             | h::t => insert h (sort t cmp) cmp

fun print_ilist l
 = let 
     fun f [] = ""
       | f (h::t) = if length t = 0 then Int.toString h
		    else (Int.toString h) ^ ", " ^ (f t)
 in
     print ("[" ^ (f l) ^ "]\n")
 end

fun print_slist l
 = let 
     fun f [] = ""
       | f (h::t) = if length t = 0 then h
		    else h ^ ", " ^ (f t)
 in
     print ("[" ^ (f l) ^ "]\n")
 end

val toIntList = map (valOf o Int.fromString)

fun f l = case l of [] => ()
		  | h::t => if h = "-n"
			    then print_ilist (sort (toIntList t) icmp)
			    else print_slist (sort l scmp)
