header {*Application: functions over trees and lists*}
(*<*)
theory mTreeList = Comb:
(*>*)
text {*The Camelot code
       \begin{verbatim}
         type itree = Leaf of int | Node of itree * itree
         type ilist = Nil | Cons of int * ilist
       \end{verbatim}
results in class \verb|TreeList$dia_0| where we have (amongst other tings):
\begin{verbatim}
   method static public TreeList$dia_0 alloc () =
   let val freelist = getstatic <TreeList$dia_0 TreeList$dia_0.$f>
      fun q(TreeList$dia_0 freelist) =
      let val tl = getfield freelist <TreeList$dia_0 TreeList$dia_0.$n>
          val () = putstatic <TreeList$dia_0 TreeList$dia_0.$f> tl
      in freelist
      end
   in if freelist = null[TreeList$dia_0] then new <TreeList$dia_0()> ()
      else q(freelist)
   end

   method static public void free (TreeList$dia_0 node) =
   let val freelist = getstatic <TreeList$dia_0 TreeList$dia_0.$f>
       val () = putfield node <TreeList$dia_0 TreeList$dia_0.$n> freelist
       val () = putstatic <TreeList$dia_0 TreeList$dia_0.$f> node
   in () end

   method public static TreeList$dia_0 make (int tag) =
     let val ?x = invokestatic <TreeList$dia_0 TreeList$dia_0.alloc ()> ()
     in invokestatic <TreeList$dia_0 TreeList$dia_0.fill (TreeList$dia_0, int)> (?x, tag)
     end

   method public static TreeList$dia_0 make (int tag, int v0, TreeList$dia_0 v1) =
     let val ?x = invokestatic <TreeList$dia_0 TreeList$dia_0.alloc ()> ()
     in invokestatic <TreeList$dia_0 TreeList$dia_0.fill (TreeList$dia_0, int, int, TreeList$dia_0)> (?x, tag, v0, v1)
     end

   method public static TreeList$dia_0 fill (TreeList$dia_0 ?x, int tag) =
     let val () = putfield ?x <int TreeList$dia_0.$> tag
     in ?x end

   method public static TreeList$dia_0 fill (TreeList$dia_0 ?x, int tag, int v0, TreeList$dia_0 v1) =
     let val () = putfield ?x <int TreeList$dia_0.$> tag
         val () = putfield ?x <int TreeList$dia_0.f0> v0
         val () = putfield ?x <TreeList$dia_0 TreeList$dia_0.f1> v1
     in ?x
     end
\end{verbatim}
       should result in the following definitions and lemmas.*}

syntax DIAM :: cname
       DOLLAR_F :: rfldname
       DOLLAR_N :: rfldname
       DOLLAR :: ifldname
       F0 :: ifldname
       F1 :: rfldname
       F2 :: rfldname

       Make_I    :: mname
       Make_IID  :: mname
       Fill_DI   :: mname
       Fill_DIID :: mname

       Alloc :: mname
       freelist :: rname
       alloc_b :: iname
       Alloc_q :: funame
       alloc_tl :: rname

       tag_ :: iname
       x_   :: rname 
       v0_  :: iname  
       v1_  :: rname 

translations
 "DIAM" == "(CN ''dia_0'') "
 "DOLLAR_F" == "(RFN ''$f'')"
 "DOLLAR_N" == "(RFN ''$n'')"
 "DOLLAR" == "(IFN ''$'')"
 "F0" == "(IFN ''f0'')"
 "F1" == "(RFN ''f1'')"
 "F2" == "(RFN ''f2'')"

 "Make_I" == "(MN ''Make_I'')"
 "Make_IID" == "(MN ''Make_IID'')"
 "Fill_DI" == "(MN ''Fill_DI'')"
 "Fill_DIID" == "(MN ''Fill_DIID'')"

 "tag_" == "(In ''tag'') "
 "x_" == "(RN ''?x'') "
 "v0_" == "(In ''v0'') "
 "v1_" == "(RN ''v1'') "

 "Alloc " == "(MN ''alloc'')"
 "freelist " == "(RN ''freelist'')"
 "alloc_b " == "(In ''b'')"
 "Alloc_q " == "(FN ''q'')"
 "alloc_tl " == "(RN ''tl'')"

axioms Meth_Make_I:
"methtable DIAM Make_I = ([INpar tag_], LET rf x_ = DIAM\<bullet>Alloc([])
                                        IN DIAM\<bullet>Fill_DI ([RNarg x_, INarg tag_]) END)"

axioms Meth_Make_IID:
"methtable DIAM Make_IID = ([INpar tag_, INpar v0_, RNpar v1_],
                            LET rf x_ = DIAM\<bullet>Alloc([])
                            IN DIAM\<bullet>Fill_DIID ([RNarg x_, INarg tag_, INarg v0_, RNarg v1_]) END)"

axioms Meth_Fill_DI:
"methtable DIAM Fill_DI = ([RNpar x_, INpar tag_],
                           LET _ = PutFi x_ DOLLAR tag_
                           IN RVar x_ END)"

axioms Meth_Fill_DIID:
"methtable DIAM Fill_DIID = ([RNpar x_, INpar tag_, INpar v0_, RNpar v1_],
                             LET _ = PutFi x_ DOLLAR tag_;
                                 _ = PutFi x_ F0 v0_;
                                 _ = PutFr x_ F1 v1_
                             IN RVar x_ END)"

axioms Meth_Alloc:
"methtable DIAM Alloc = ([], LET rf freelist = DIAM\<struct>DOLLAR_F;
                                 alloc_b = RPrimop (\<lambda> x y . if x = Nullref then 1 else 0) freelist freelist
                             IN IF alloc_b THEN NEW <DIAM> ([],[]) ELSE CALL Alloc_q END)"
(*Isabelle problem: why must we not use the pretty GetStat/PutStat syntax in the lemma 
  ''Illegal reference to implicit structure #1''??*)
lemma 
"methtable DIAM Alloc = ([], LET rf freelist = GetStat DIAM DOLLAR_F;
                                           alloc_b = RPrimop (\<lambda> x y . if x = Nullref then 1 else 0) freelist freelist
                                   IN IF alloc_b THEN NEW <DIAM> ([],[]) ELSE CALL Alloc_q END)"
by (simp add: Meth_Alloc)

axioms Fun_AllocQ:
"funtable Alloc_q = LET rf alloc_tl = freelist\<diamondsuit>DOLLAR_N;
                             _ = DIAM\<struct>DOLLAR_F := alloc_tl
                    IN RVar freelist END"
lemma "funtable Alloc_q = LET rf alloc_tl = freelist\<diamondsuit>DOLLAR_N;
                             _ = DIAM\<struct>DOLLAR_F := alloc_tl
                    IN RVar freelist END"
by (simp add: Fun_AllocQ)

subsection {*The list representation predicate*}
consts mList::"(nat \<times> locn \<times> (locn set) \<times> heap) set"
inductive mList intros
mListNIL:"\<lbrakk>h@@a = Some DIAM; h<a\<bullet>DOLLAR> = 2\<rbrakk> \<Longrightarrow> (0,a,{a},h) : mList"
mListCONS:"\<lbrakk>h@@a = Some DIAM; h<a\<bullet>DOLLAR> \<noteq> 2; h\<lfloor>a\<diamondsuit>F1\<rfloor> = Ref aa; a \<notin> X; (n,aa,X,h):mList\<rbrakk>
          \<Longrightarrow> (Suc n, a, X \<union> {a}, h): mList"

lemma mListSameOH[rule_format]:
"(n,a,X,h) \<in> mList \<Longrightarrow> (\<forall> hh. sameOH X h hh \<longrightarrow> (n,a,X,hh) \<in> mList)"
apply (erule mList.induct, safe)
apply (rule mListNIL)
apply (simp add: sameOH_def)
apply (simp add: sameOH_def)
apply (rule mListCONS)
apply ( simp add: sameOH_def)
apply ( simp add: sameOH_def)
apply ( simp add: sameOH_def)
apply simp
apply simp
apply (subgoal_tac "sameOH X h hh", simp)
apply ( simp add: sameOH_def)
done

lemma mListSame:
"\<lbrakk>(n,a,X,h) \<in> mList; same X h hh\<rbrakk> \<Longrightarrow> (n,a,X,hh) \<in> mList"
by (erule mListSameOH, simp add: same_def)

lemma mListDom: "\<lbrakk>(n, a, X, h) \<in> mList\<rbrakk> \<Longrightarrow>  X \<subseteq> Dom h"
by (erule mList.induct, simp_all add:fmap_lookup_def fmap_dom_def dom_def)

lemma mListFresh: "(L, a, X, h) \<in> mList \<Longrightarrow> freshloc (Dom h) \<notin> X"
by (subgoal_tac "X \<subseteq> Dom h", fastsimp, erule mListDom)

lemma mListSameFresh: "(n, a, X, h) \<in> mList
       \<Longrightarrow> same X h
           \<lparr>oheap = oheap h(freshloc (Dom h)\<mapsto>\<^sub>fDIAM),
            iheap = (iheap h)
                    (DOLLAR := (iheap h DOLLAR)(freshloc (Dom h) := U),
                     F0 := (iheap h F0)(freshloc (Dom h) := Y)),
            rheap = (rheap h)(F1 := (rheap h F1)(freshloc (Dom h) := Z)),
            sheap = sheap h\<rparr>"
apply (erule mList.induct)
apply (simp add: same_def sameOH_def)
apply (subgoal_tac "a \<noteq> freshloc (Dom h)", clarsimp) apply (simp add: FMAPlookup1)
  apply (subgoal_tac "a : Dom h")
  apply fastsimp
  apply (simp add: fmap_lookup_def fmap_dom_def dom_def)
apply (simp add: same_def sameOH_def)
apply (subgoal_tac "a \<noteq> freshloc (Dom h)", clarsimp) apply (erule_tac x=a in allE, clarsimp)
  apply (simp add: FMAPlookup1) 
  apply (subgoal_tac "a : Dom h")
  apply fastsimp
  apply (simp add: fmap_lookup_def fmap_dom_def dom_def)
done

lemma mListExtend:
"\<lbrakk>(n, a, Y, h) \<in> mList; l \<notin> Dom h\<rbrakk> \<Longrightarrow>
  (Suc n, l, Y \<union> {l}, \<lparr>oheap = oheap h(l\<mapsto>\<^sub>fDIAM), 
                       iheap = (iheap h)(DOLLAR := (iheap h DOLLAR)(l := 1),
                                         F0 := (iheap h F0)(l := i)),
                       rheap = (rheap h)(F1 := (rheap h F1)(l := Ref a)),
                       sheap = sheap h\<rparr>) : mList"
apply (subgoal_tac "l \<noteq> a")
apply (erule mList.elims)
apply (rule mListCONS, safe)
apply (simp add: FMAPlookup1)
apply (clarsimp) 
apply simp
apply (rule mListNIL) 
apply (simp add: FMAPlookup1) apply clarsimp
apply (subgoal_tac "X \<subseteq> Dom h") prefer 2 apply (erule mListDom)
apply (rule mListCONS, safe)
apply (simp add: FMAPlookup1)
apply (clarsimp)
apply simp
apply (fast)  
apply (rule mListCONS) 
apply (simp add: FMAPlookup1) 
apply clarsimp 
apply simp
apply simp
apply (rule mListSameOH, assumption)
apply (simp add: sameOH_def) apply clarsimp apply (simp add: FMAPlookup1)
apply fast
apply (subgoal_tac "a:Y") 
apply (insert mListDom) apply fast
apply (erule mList.elims, simp_all)
done
(* If we define the fields as consts, the previous lemma should be as follows:
lemma mListExtend:
"\<lbrakk>(n, a, Y, h) \<in> mList; l \<notin> Dom h; F0 \<noteq> DOLLAR\<rbrakk> \<Longrightarrow>
  (Suc n, l, Y \<union> {l}, \<lparr>oheap = oheap h(l\<mapsto>\<^sub>fDIAM), 
                       iheap = (iheap h)(DOLLAR := (iheap h DOLLAR)(l := 1),
                                         F0 := (iheap h F0)(l := i)),
                       rheap = (rheap h)(F1 := (rheap h F1)(l := Ref a)),
                       sheap = sheap h\<rparr>) : mList"
apply (subgoal_tac "l \<noteq> a")
apply (erule mList.elims)
apply (rule mListCONS, safe)
apply (simp add: FMAPlookup1)
apply (clarsimp) 
apply simp
apply (rule mListNIL) 
apply (simp add: FMAPlookup1) apply clarsimp
apply (subgoal_tac "X \<subseteq> Dom h") prefer 2 apply (erule mListDom)
apply (rule mListCONS, safe)
apply (simp add: FMAPlookup1)
apply (clarsimp)
apply simp
apply (fast)  
apply (rule mListCONS) 
apply (simp add: FMAPlookup1) 
apply clarsimp 
apply simp
apply simp
apply (rule mListSame, assumption)
apply (simp add: same_def) apply clarsimp apply (simp add: FMAPlookup1)
apply fast
apply (subgoal_tac "a:Y") 
apply (insert mListDom) apply fast
apply (erule mList.elims, simp_all)
done
*)

lemma SameExtend1:"\<lbrakk>l \<notin> X\<rbrakk> \<Longrightarrow> same X h \<lparr>oheap = (oheap h)(l\<mapsto>\<^sub>fC),
                                         iheap = (iheap h)(DOLLAR := (iheap h DOLLAR)(l := i1),
                                                           F0 := (iheap h F0)(l := i2)),
                                         rheap = (rheap h)(F1 := (rheap h F1)(l := r)),
                                         sheap = sheap h\<rparr>"
by (simp add: same_def sameOH_def FMAPlookup1)

lemma DomExtend1: 
"\<lbrakk>l \<notin> Dom h \<rbrakk> \<Longrightarrow>
   Dom h \<subseteq> Dom \<lparr>oheap = oheap h(l\<mapsto>\<^sub>fC),
                iheap = (iheap h)(DOLLAR := (iheap h DOLLAR)(l := i1), F0 := (iheap h F0)(l := i2)),
                rheap = (rheap h)(F1 := (rheap h F1)(l := r)),
                sheap = sheap h\<rparr>"
by fastsimp

lemma SameExtend2:"\<lbrakk>l \<notin> X\<rbrakk> \<Longrightarrow> same X h \<lparr>oheap = oheap h(l\<mapsto>\<^sub>fC),
                                         iheap = (iheap h)(DOLLAR := (iheap h DOLLAR)(l := i)),
                                         rheap = rheap h,
                                         sheap = sheap h\<rparr>"
by (simp add: same_def sameOH_def FMAPlookup1)

lemma DomExtend2: "\<lbrakk>l \<notin> Dom h \<rbrakk> \<Longrightarrow>
                   Dom h \<subseteq> Dom \<lparr>oheap = oheap h(l\<mapsto>\<^sub>fC),
                                iheap = (iheap h)(DOLLAR := (iheap h DOLLAR)(l := i)),
                                rheap = rheap h,
                                sheap = sheap h\<rparr>"
by fastsimp

subsection {*The tree representation predicate*}
consts mTree::"(nat \<times> locn \<times> (locn set) \<times> heap) set"
inductive mTree intros
mTreeLEAF:"\<lbrakk>h@@a = Some DIAM; h<a\<bullet>DOLLAR> = 0\<rbrakk> \<Longrightarrow> (0,a,{a},h) : mTree"
mTreeNODE:"\<lbrakk>h@@a = Some DIAM; h<a\<bullet>DOLLAR> \<noteq> 0; 
            h\<lfloor>a\<diamondsuit>F1\<rfloor> = Ref a1; (n,a1,X1,h):mTree; 
            h\<lfloor>a\<diamondsuit>F2\<rfloor> = Ref a2; (n,a2,X2,h):mTree;
            X1 \<inter> X2 = {}; a \<notin> X1 \<union> X2 \<rbrakk>
          \<Longrightarrow> (Suc n, a, X1 \<union> X2 \<union> {a}, h): mTree"

lemma mTreeSameOH[rule_format]:
"(n,a,X,h) \<in> mTree \<Longrightarrow> (\<forall> hh. sameOH X h hh \<longrightarrow> (n,a,X,hh) \<in> mTree)"
apply (erule mTree.induct, safe)
apply (rule mTreeLEAF)
apply (simp add: sameOH_def)
apply (simp add: sameOH_def)
apply (rule mTreeNODE)
apply ( simp add: sameOH_def)
apply ( simp add: sameOH_def)
apply ( simp add: sameOH_def)
apply (subgoal_tac "sameOH X1 h hh", simp)
apply ( simp add: sameOH_def)
apply ( simp add: sameOH_def)
apply (subgoal_tac "sameOH X2 h hh", simp)
apply ( simp add: sameOH_def)
apply simp
apply simp
done

lemma mTreeSame:
"\<lbrakk>(n,a,X,h) \<in> mTree; same X h hh\<rbrakk> \<Longrightarrow> (n,a,X,hh) \<in> mTree"
by (erule mTreeSameOH, simp add: same_def)
lemma mTreeDomAux:"(L,r,X,h) : mTree \<Longrightarrow> (\<forall> x. x \<in> X  \<longrightarrow> x \<in> Dom h)"
 apply (erule mTree.induct) 
 apply clarify
 apply (simp add: fmap_lookup_def fmap_dom_def dom_def)
 apply (simp add: fmap_lookup_def fmap_dom_def dom_def)
done

lemma mTreeDom: "\<lbrakk>(L, r, X, h) \<in> mTree\<rbrakk> \<Longrightarrow>  X \<subseteq> Dom h"
by (insert mTreeDomAux, auto)

lemma mTreeFresh: "(L, a, X, h) \<in> mTree \<Longrightarrow> freshloc (Dom h) \<notin> X"
by (subgoal_tac "X \<subseteq> fmap_dom (oheap h)", fastsimp, erule mTreeDom)

subsection {*The freelist representation predicate*}
consts FL::"(nat \<times> ref \<times> (locn set) \<times> heap) set"
inductive FL intros
FL_NIL: "(0, Nullref, {},h) : FL"
FL_SUC: "\<lbrakk>h@@a = Some DIAM; a \<notin> X; (n, h\<lfloor>a\<diamondsuit>DOLLAR_N\<rfloor>,X,h):FL\<rbrakk>
        \<Longrightarrow> (Suc n, Ref a,  X \<union> {a}, h) : FL"

lemma FL_SameOH[rule_format]:
"(n,r,X,h) \<in> FL \<Longrightarrow> (\<forall> hh. sameOH X h hh \<longrightarrow> (n,r,X,hh) \<in> FL)"
apply (erule FL.induct, safe)
apply (rule FL_NIL)
apply (rule FL_SUC)
apply (simp_all add: sameOH_def)
done

lemma FL_Same[rule_format]:
"\<lbrakk>(n,r,X,h) \<in> FL; same X h hh\<rbrakk> \<Longrightarrow> (n,r,X,hh) \<in> FL"
by (erule FL_SameOH, simp add: same_def)

lemma FL_Dom: "\<lbrakk>(n, r, X, h) \<in> FL\<rbrakk> \<Longrightarrow>  X \<subseteq> Dom h"
by (erule FL.induct, simp_all add:fmap_lookup_def fmap_dom_def dom_def)

lemma FL_Fresh: "(L, r, X, h) \<in> FL \<Longrightarrow> freshloc (Dom h) \<notin> X"
by (subgoal_tac "X \<subseteq> Dom h", fastsimp, erule FL_Dom)

lemma FL_SameOHFresh: 
"(n, r, X, h) \<in> FL
       \<Longrightarrow> sameOH X h
           \<lparr>oheap = oheap h(freshloc (Dom h)\<mapsto>\<^sub>fDIAM),
            iheap = (iheap h)
                    (DOLLAR := (iheap h DOLLAR)(freshloc (Dom h) := U),
                     F0 := (iheap h F0)(freshloc (Dom h) := Y)),
            rheap = (rheap h)(F1 := (rheap h F1)(freshloc (Dom h) := Z)),
            sheap = ZZ\<rparr>"
apply (erule FL.induct)
apply (simp add: sameOH_def)
apply (simp add: sameOH_def)
apply (subgoal_tac "a \<noteq> freshloc (Dom h)", simp add: FMAPlookup1)
  apply (subgoal_tac "a : Dom h")
  apply (subgoal_tac "freshloc (Dom h) \<notin> Dom h", fast)
  apply (rule FreshlocDom)
  apply (simp add: fmap_lookup_def fmap_dom_def dom_def)
done

lemma FL_SameFresh: 
"(n, r, X, h) \<in> FL
       \<Longrightarrow> same X h
           \<lparr>oheap = oheap h(freshloc (Dom h)\<mapsto>\<^sub>fDIAM),
            iheap = (iheap h)
                    (DOLLAR := (iheap h DOLLAR)(freshloc (Dom h) := U),
                     F0 := (iheap h F0)(freshloc (Dom h) := Y)),
            rheap = (rheap h)(F1 := (rheap h F1)(freshloc (Dom h) := Z)),
            sheap = sheap h\<rparr>"
by (simp add: same_def, erule  FL_SameOHFresh)


subsection {*Verification of the @{text fill} methods*}
text {*We now prove that the bodies of the standard methods satisfy their
       specifications -- the fill methods in any contexts, the make
       methods in contexts which contain entries for the appropriate fill methods.*}
constdefs fill_DI_Spec::bool
"fill_DI_Spec \<equiv> 
(MS DIAM Fill_DI = 
  (\<lambda> args E h hh v p. (\<forall> l_x i_tag. evalARGS E args =[RVal (Ref l_x), IVal i_tag] \<longrightarrow>
                                     (v = RVal (Ref l_x) \<and> same ((Dom h)-{l_x}) h hh \<and> 
                                      iUpd Same (constVE (RVal (Ref l_x))) DOLLAR (constVE (IVal i_tag)) E h hh))))"

constdefs fill_DIID_Spec::bool
"fill_DIID_Spec \<equiv> 
(MS DIAM Fill_DIID = 
  (\<lambda> args E h hh v p. (\<forall> l_x i_tag i_v0 r_v1. evalARGS E args = [RVal (Ref l_x), IVal i_tag, IVal i_v0, RVal r_v1] \<longrightarrow>
                                              (v = RVal (Ref l_x) \<and> same ((Dom h)-{l_x}) h hh \<and> 
                                               rUpd (iUpd (iUpd Same (constVE (RVal (Ref l_x))) DOLLAR (constVE (IVal i_tag)))
                                                          (constVE (RVal (Ref l_x)))
                                                          F0 
                                                          (constVE (IVal i_v0)))
                                                    (constVE (RVal (Ref l_x)))
                                                    F1 
                                                   (constVE (RVal r_v1)) E h hh))))"

text {*In fact the second clauses of both conclusions are implied by the third ones:*}
lemma "iUpd Same (constVE (RVal (Ref l_x))) DOLLAR (constVE (IVal i_tag)) E h hh
       \<longrightarrow> same ((Dom h)-{l_x}) h hh"
by (simp add: predicates same_def sameOH_def)

lemma "rUpd (iUpd (iUpd Same (constVE (RVal (Ref l_x))) DOLLAR (constVE (IVal i_tag)))
                  (constVE (RVal (Ref l_x))) F0 (constVE (IVal i_v0)))
            (constVE (RVal (Ref l_x))) F1 (constVE (RVal r_v1)) E h hh \<longrightarrow>
       same ((Dom h)-{l_x}) h hh"
by (simp add: predicates same_def sameOH_def)

lemma Fill_DI_Aux:
"fill_DI_Spec \<Longrightarrow> 
  G \<rhd> snd (methtable DIAM Fill_DI) : 
      (\<lambda>E h hh v p. \<forall>E'. E = newframe_env Nullref (fst (methtable DIAM Fill_DI)) x E' \<longrightarrow>
                         MS DIAM Fill_DI x E' h hh v
                            (mkRescomp (3 + clock p) (callc p) (1 + invkc p) (Suc (invkdpth p))))"
apply (simp add:  Meth_Fill_DI)
apply (rule vdm_conseq)
apply (rule vdmC_basics)+
apply (simp add: fill_DI_Spec_def newframe_env_def evalARGS_def, clarsimp)
apply (erule thin_rl) 
apply (erule letElims, simp add: valExpr_predicates)
apply (erule primElims, simp add: predicates)
apply (simp add: same_def sameOH_def)
apply clarsimp
done

lemma Fill_DIID_Aux:
"fill_DIID_Spec \<Longrightarrow> 
  G \<rhd> snd (methtable DIAM Fill_DIID) : 
      (\<lambda>E h hh v p. \<forall>E'. E = newframe_env Nullref (fst (methtable DIAM Fill_DIID)) x E' \<longrightarrow>
                         MS DIAM Fill_DIID x E' h hh v
                            (mkRescomp (3 + clock p) (callc p) (1 + invkc p) (Suc (invkdpth p))))"
apply (simp add:  Meth_Fill_DIID)
apply (rule vdm_conseq)
apply (rule vdmC_basics)+
apply (simp add: fill_DIID_Spec_def newframe_env_def evalARGS_def, clarsimp)
apply (erule thin_rl) 
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule primElims, simp add: predicates)
apply (simp add: same_def sameOH_def)
apply clarsimp
done

subsection {*Verification of @{text alloc}*}
constdefs alloc_Spec::bool
"alloc_Spec \<equiv> 
(MS DIAM Alloc =
  (\<lambda> args E h hh v p. 
     (\<forall> n X. args =[] \<and> (n, h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, X, h) : FL \<longrightarrow>
             ((n = 0 \<longrightarrow> (\<exists> l . v = RVal (Ref l) \<and> extendHE Same DIAM l [] [] E h hh)) \<and>
              (\<forall> nn . n = Suc nn \<longrightarrow> (\<exists> l . v = RVal (Ref l) \<and> Ref l = h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace> \<and>
                                            hh = h\<lbrace>DIAM\<struct>DOLLAR_F := h\<lfloor>l\<diamondsuit>DOLLAR_N\<rfloor>\<rbrace>))))))"

lemma Alloc_Aux:
"alloc_Spec \<Longrightarrow> 
  G \<rhd> snd (methtable DIAM Alloc) : 
      (\<lambda>E h hh v p. \<forall>E'. E = newframe_env Nullref (fst (methtable DIAM Alloc)) x E' \<longrightarrow>
                         MS DIAM Alloc x E' h hh v
                            (mkRescomp (3 + clock p) (callc p) (1 + invkc p) (Suc (invkdpth p))))"
apply (simp add: Meth_Alloc)
apply (rule vdm_conseq)
apply (rule vdmC_basics)+
apply (rule Call1,simp add:Fun_AllocQ)
apply (rule vdmC_basics)+
apply (simp add: alloc_Spec_def newframe_env_def evalARGS_def, clarsimp)
apply (erule thin_rl) 
apply safe
(* Case FL_NIL*)
  apply (erule FL.elims, simp_all, clarsimp)
  apply (erule letElims, simp add: valExpr_predicates)
  apply (erule letElims, simp add: valExpr_predicates, simp add: valExpr_predicates)
  apply (erule letElims, simp add: predicates)
  (* then *)
  apply clarsimp
  defer 1
  (* else *)
  apply (clarsimp)
(* Case FL_SUC*)
apply (erule FL.elims, simp_all, clarsimp)
apply (erule letElims, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates, simp add: valExpr_predicates)
apply (erule letElims, simp add: valExpr_predicates, clarsimp)
apply (erule letElims, simp add: valExpr_predicates) 
apply (erule letElims, simp add: valExpr_predicates)
apply (erule primElims, simp add: predicates)
txt {*end of extended VCG -- only 1 side condition left*}
apply (simp add: newObj_def)
done

text {*Here is a more explicit (but equivalent) specification:*}
constdefs AllocSpec2::"ARGTYPE \<Rightarrow> vdmassn"
"AllocSpec2 \<equiv> 
 (\<lambda> args E h hh v p. (\<forall> n X. args =[] \<and> (n, h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, X, h) : FL \<longrightarrow>
                            ((n = 0 \<longrightarrow> (\<exists> l . v = RVal (Ref l) \<and> same (Dom h) h hh \<and> 
                                                extendHE Same DIAM l [] [] E h hh \<and>
                                                (n, hh\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, X, hh) : FL)) \<and>
                             (\<forall> nn . n = Suc nn \<longrightarrow> (\<exists> l . v = RVal (Ref l) \<and> Ref l = h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace> \<and>
                                                             hh = h\<lbrace>DIAM\<struct>DOLLAR_F := h\<lfloor>l\<diamondsuit>DOLLAR_N\<rfloor>\<rbrace> \<and> 
                                                             (nn,hh\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, X - {l}, hh) : FL)))))"
lemma
"alloc_Spec \<Longrightarrow>
 (G \<rhd> (DIAM\<bullet>Alloc(x)) : (MS DIAM Alloc x)) = (G \<rhd> (DIAM\<bullet>Alloc(x)) : (AllocSpec2 x))"
apply rule    
apply (rule vdm_conseq, assumption)
apply clarsimp
apply (simp add: alloc_Spec_def AllocSpec2_def)
apply (erule thin_rl)
apply clarsimp
apply (erule_tac x=n in allE)
apply (erule impE, rule, assumption, rule,clarsimp)
apply (subgoal_tac "same (Dom h) h hh", simp)
apply (subgoal_tac "hh\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace> = h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>", simp)
apply (rule FL_Same, assumption)
apply (erule SameSubset)
apply (erule FL_Dom)
apply (simp add: same_def)
apply (simp add: predicates newObj_def same_def sameOH_def, clarsimp)
apply (subgoal_tac "la \<noteq> freshloc (Dom h)")
apply (simp add: FMAPlookup1)
apply (subgoal_tac "freshloc (Dom h) \<notin> Dom h", fast)
apply (rule FreshlocDom)
apply clarsimp
apply (rule_tac x=l in exI, simp)
apply (erule FL.elims, simp_all, clarsimp)
apply (rule FL_SameOH, assumption)
apply (simp add: sameOH_def)

apply (rule vdm_conseq, assumption)
apply clarsimp
apply (simp add: alloc_Spec_def AllocSpec2_def)
apply (erule thin_rl)
apply clarsimp
apply (erule_tac x=n in allE, erule_tac x=X in allE, safe)
apply clarsimp
apply (erule FL.elims, simp_all, clarsimp)
apply clarsimp
apply (erule FL.elims, simp_all, clarsimp)
done

subsection {*Verification of @{text free}*}
syntax Free :: mname
       node_ :: rname
translations
"Free" == "(MN ''free'')"
"node_" == "(RN ''node'')"

axioms Meth_Free:
"methtable DIAM Free = ([RNpar node_], LET rf freelist = DIAM\<struct>DOLLAR_F;
                                                     _ = PutFr node_ DOLLAR_N freelist
                                       IN DIAM\<struct>DOLLAR_F:=node_ END)"
(*Isabelle problem: why must we not use the pretty GetStat/PutStat syntax in the lemma
  ''Illegal reference to implicit structure #1''??*)
lemma "methtable DIAM Free = ([RNpar node_], LET rf freelist = GetStat DIAM DOLLAR_F;
                                                           _ = PutFr node_ DOLLAR_N freelist
                                             IN PutStat DIAM DOLLAR_F node_ END)"
by (simp add: Meth_Free)

constdefs free_Spec::bool
"free_Spec \<equiv> 
(MS DIAM Free =
  (\<lambda> args E h hh v p. 
     (\<forall> l. evalARGS E args = [RVal (Ref l)] \<longrightarrow>
              (v = arbitrary \<and> hh = (h\<lfloor>l\<diamondsuit>DOLLAR_N:=h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>\<rfloor>)\<lbrace>DIAM\<struct>DOLLAR_F := Ref l\<rbrace>))))"
lemma Free_Aux:
"free_Spec \<Longrightarrow> 
  G \<rhd> snd (methtable DIAM Free) : 
      (\<lambda>E h hh v p. \<forall>E'. E = newframe_env Nullref (fst (methtable DIAM Free)) x E' \<longrightarrow>
                         MS DIAM Free x E' h hh v
                            (mkRescomp (3 + clock p) (callc p) (1 + invkc p) (Suc (invkdpth p))))"
apply (simp add: Meth_Free)
apply (rule vdm_conseq)
apply (rule vdmC_basics)+
apply (simp add: free_Spec_def newframe_env_def evalARGS_def, clarsimp)
apply (erule thin_rl) 
  apply (erule letElims, simp add: valExpr_predicates)
  apply (erule letElims, simp add: valExpr_predicates, simp add: predicates)
done

text {*Again we also give a more explicit specification (but equivalent) specifrication:*}
constdefs FreeSpec2::"ARGTYPE \<Rightarrow> vdmassn"
"FreeSpec2 == (\<lambda> args E h hh v p. 
     (\<forall> l n X. (evalARGS E args = [RVal (Ref l)]  \<longrightarrow>
                 (v = arbitrary \<and> hh = (h\<lfloor>l\<diamondsuit>DOLLAR_N:=h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>\<rfloor>)\<lbrace>DIAM\<struct>DOLLAR_F:=(Ref l)\<rbrace> \<and>
                  (l \<notin> X \<and> h@@l = Some DIAM \<and> (n,h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>,X,h) : FL \<longrightarrow>
                   sameOH ((Dom h)-{l}) h hh \<and> (Suc n,hh\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>,X \<union>{l},hh) : FL)))))"
lemma
"free_Spec \<Longrightarrow>
 (G \<rhd> (DIAM\<bullet>Free(x)) : (MS DIAM Free x)) = (G \<rhd> (DIAM\<bullet>Free(x)) : (FreeSpec2 x))"
apply rule
apply (rule vdm_conseq, assumption)
apply clarsimp
apply (simp add: FreeSpec2_def free_Spec_def)
apply (erule thin_rl)
apply safe
apply (simp add: sameOH_def)
apply (subgoal_tac "(Suc n, Ref l, X \<union> {l}, h
           \<lparr>rheap := (rheap h)(DOLLAR_N := (rheap h DOLLAR_N)(l := h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>)), sheap := (sheap h)(DIAM := (sheap h DIAM)(DOLLAR_F := Ref l))\<rparr>)
          \<in> FL", simp)
apply (rule FL_SUC)
apply simp
apply simp
apply (subgoal_tac "(h\<lparr>rheap := (rheap h)(DOLLAR_N := (rheap h DOLLAR_N)(l := h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>)),
                   sheap := (sheap h)(DIAM := (sheap h DIAM)(DOLLAR_F := Ref l))\<rparr>)\<lfloor>l\<diamondsuit>DOLLAR_N\<rfloor> = h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>", simp)
apply (erule FL_SameOH)
apply (simp add: sameOH_def)
apply simp

apply (rule vdm_conseq, assumption)
apply clarsimp
apply (simp add: FreeSpec2_def free_Spec_def)
apply fast
done

subsection {*Verification of the @{text make} methods*}
constdefs make_I_Spec::bool
"make_I_Spec \<equiv> 
(MS DIAM Make_I = 
  (\<lambda> args E h hh v p. 
      (\<forall> i_tag n X. ((evalARGS E args =[IVal i_tag] \<and> (n, h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, X, h) : FL) \<longrightarrow>
                     ((n = 0 \<longrightarrow> (\<exists> l . v = RVal (Ref l) \<and> 
                                        iUpd (extendHE Same DIAM l [] []) 
                                             (constVE (RVal (Ref l))) DOLLAR (constVE (IVal i_tag)) E h hh)) \<and> 
                      (\<forall> nn . n = Suc nn \<longrightarrow> (\<exists> l . v = RVal (Ref l) \<and> Ref l = h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace> \<and>
                                                    iUpd (sUpd Same DIAM DOLLAR_F (rdotVE (constVE (RVal (Ref l))) DOLLAR_N)) 
                                                         (constVE (RVal (Ref l))) DOLLAR (constVE (IVal i_tag)) E h hh)))))))"
constdefs make_IID_Spec::bool
"make_IID_Spec \<equiv> 
(MS DIAM Make_IID = 
  (\<lambda> args E h hh v p. 
     (\<forall> i_tag i_v0 r_v1 n X. 
         ((evalARGS E args =[IVal i_tag, IVal i_v0, RVal r_v1] \<and> (n, h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, X, h) : FL) \<longrightarrow>
          ((n = 0 \<longrightarrow> (\<exists> l . v = RVal (Ref l) \<and>
                             rUpd (iUpd (iUpd (extendHE Same DIAM l [] [])
                                              (constVE (RVal (Ref l))) DOLLAR (constVE (IVal i_tag)))
                                        (constVE (RVal (Ref l))) F0 (constVE (IVal i_v0)))
                                  (constVE (RVal (Ref l))) F1 (constVE (RVal r_v1)) E h hh)) \<and> 
           (\<forall> nn . n = Suc nn \<longrightarrow> (\<exists> l . v = RVal (Ref l) \<and> Ref l = h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace> \<and> 
                                         rUpd (iUpd (iUpd (sUpd Same DIAM DOLLAR_F (rdotVE (constVE (RVal (Ref l))) DOLLAR_N)) 
                                                           (constVE (RVal (Ref l))) DOLLAR (constVE (IVal i_tag)))
                                                     (constVE (RVal (Ref l))) F0 (constVE (IVal i_v0)))
                                               (constVE (RVal (Ref l))) F1 (constVE (RVal r_v1)) E h hh)))))))"

text {*Again we give some more explicit specifications and prove them equivalent.*}
constdefs MakeI_Spec2::"ARGTYPE \<Rightarrow> vdmassn"
"MakeI_Spec2 \<equiv> 
  (\<lambda> args E h hh v p. 
      (\<forall> i_tag n X. ((evalARGS E args =[IVal i_tag] \<and> (n, h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, X, h) : FL) \<longrightarrow>
                     ((n = 0 \<longrightarrow> (\<exists> l . v = RVal (Ref l) \<and> same (Dom h) h hh \<and> l \<notin> X \<and> 
                                        (n, hh\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, X, hh) : FL \<and> Dom hh = Dom h \<union> {l} \<and> 
                                        iUpd (extendHE Same DIAM l [] [])
                                             (constVE (RVal (Ref l))) DOLLAR (constVE (IVal i_tag)) E h hh)) \<and> 
                      (\<forall> nn . n = Suc nn \<longrightarrow> (\<exists> l . v = RVal (Ref l) \<and> Ref l = h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace> \<and> l:X \<and> 
                                                    sameOH ((Dom h) - {l}) h hh \<and> 
                                                    (nn, hh\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, X - {l}, hh) : FL \<and> Dom hh = Dom h \<and> 
                                                    iUpd (sUpd Same DIAM DOLLAR_F (rdotVE (constVE (RVal (Ref l))) DOLLAR_N)) 
                                                         (constVE (RVal (Ref l))) DOLLAR (constVE (IVal i_tag)) E h hh))))))"

lemma MakeI_SpecSpec2:
"make_I_Spec \<Longrightarrow>
       (G \<rhd> (DIAM\<bullet>Make_I(x)) : (MS DIAM Make_I x)) = (G \<rhd> (DIAM\<bullet>Make_I(x)) : (MakeI_Spec2 x))"
apply rule    
apply (rule vdm_conseq, assumption)
apply clarsimp
apply (simp add: make_I_Spec_def MakeI_Spec2_def)
apply (erule thin_rl, erule thin_rl)
apply clarsimp
apply (erule_tac x=n in allE)
apply (simp add: predicates newObj_def)
apply (erule impE, rule, assumption, rule, clarsimp)
(* case n=0 *)
apply (subgoal_tac "X \<subseteq> Dom h")
prefer 2 apply (erule FL_Dom)
apply (subgoal_tac "same (Dom h) h
           \<lparr>oheap = oheap h(freshloc (Dom h)\<mapsto>\<^sub>fDIAM), iheap = (iheap h)(DOLLAR := (iheap h DOLLAR)(freshloc (Dom h) := i_tag)),
              rheap = rheap h, sheap = sheap h\<rparr>", simp)
  apply (insert FreshlocDom, rule, fast)
  apply (rule FL_Same, assumption)
  apply (erule SameSubset, assumption)
  apply (simp add: same_def sameOH_def FMAPlookup1)
(* case n > 0 *)
apply clarsimp
apply (rule_tac x=l in exI, clarsimp)
apply (erule FL.elims, simp_all, clarsimp)
apply (subgoal_tac "sameOH (Dom ha - {a}) ha
           (ha\<lparr>sheap := (sheap ha)(DIAM := (sheap ha DIAM)(DOLLAR_F := ha\<lfloor>a\<diamondsuit>DOLLAR_N\<rfloor>)),
                 iheap := (iheap ha)(DOLLAR := (iheap ha DOLLAR)(a := i_tag))\<rparr>)", simp)
  apply (rule FL_SameOH, assumption)
  apply (erule SameOHSubset)
  apply (insert FL_Dom, fast)
  apply (simp add: sameOH_def)

apply (rule vdm_conseq, assumption)
apply clarsimp
apply (simp add: make_I_Spec_def MakeI_Spec2_def)
apply (erule thin_rl, erule thin_rl)
apply clarsimp
apply (erule_tac x=n in allE, erule_tac x=X in allE, safe)
apply clarsimp
apply (erule FL.elims, simp_all, auto)
done

constdefs MakeIID_Spec2::"ARGTYPE \<Rightarrow> vdmassn"
"MakeIID_Spec2 \<equiv> 
  (\<lambda> args E h hh v p. 
      (\<forall> i_tag i_v0 r_v1 n X.
          ((evalARGS E args =[IVal i_tag, IVal i_v0, RVal r_v1] \<and> (n, h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, X, h) : FL) \<longrightarrow>
           ((n = 0 \<longrightarrow> (\<exists> l . v = RVal (Ref l) \<and> same (Dom h) h hh \<and> l \<notin> X \<and> 
                                  (n, hh\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, X, hh) : FL \<and> Dom hh = Dom h \<union> {l} \<and>
                              rUpd (iUpd (iUpd (extendHE Same DIAM l [] [])
                                              (constVE (RVal (Ref l))) DOLLAR (constVE (IVal i_tag)))
                                        (constVE (RVal (Ref l))) F0 (constVE (IVal i_v0)))
                                  (constVE (RVal (Ref l))) F1 (constVE (RVal r_v1)) E h hh)) \<and> 
            (\<forall> nn . n = Suc nn \<longrightarrow> (\<exists> l . v = RVal (Ref l) \<and> Ref l = h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace> \<and> l:X \<and> 
                                          sameOH ((Dom h) - {l}) h hh \<and> Dom h = Dom hh \<and> 
                                          (nn, hh\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, X - {l}, hh) : FL \<and> Dom hh = Dom h \<and> 
                                          rUpd (iUpd (iUpd (sUpd Same DIAM DOLLAR_F (rdotVE (constVE (RVal (Ref l))) DOLLAR_N)) 
                                                           (constVE (RVal (Ref l))) DOLLAR (constVE (IVal i_tag)))
                                                     (constVE (RVal (Ref l))) F0 (constVE (IVal i_v0)))
                                               (constVE (RVal (Ref l))) F1 (constVE (RVal r_v1)) E h hh))))))"

lemma MakeIID_SpecSpec2:
"make_IID_Spec \<Longrightarrow>
       (G \<rhd> (DIAM\<bullet>Make_IID(x)) : (MS DIAM Make_IID x)) = (G \<rhd> (DIAM\<bullet>Make_IID(x)) : (MakeIID_Spec2 x))"
apply rule    
apply (rule vdm_conseq, assumption)
apply clarsimp
apply (simp add: make_IID_Spec_def MakeIID_Spec2_def)
apply (erule thin_rl, erule thin_rl)
apply clarsimp
apply (erule_tac x=n in allE)
apply (simp add: predicates newObj_def)
apply (erule impE, rule, assumption, rule, clarsimp)
(* case n=0 *)
apply (subgoal_tac "X \<subseteq> Dom h")
prefer 2 apply (erule FL_Dom)
apply (subgoal_tac "same (Dom h) h
           \<lparr>oheap = oheap h(freshloc (Dom h)\<mapsto>\<^sub>fDIAM),
              iheap = (iheap h)(DOLLAR := (iheap h DOLLAR)(freshloc (Dom h) := i_tag), F0 := (iheap h F0)(freshloc (Dom h) := i_v0)),
              rheap = (rheap h)(F1 := (rheap h F1)(freshloc (Dom h) := r_v1)), sheap = sheap h\<rparr>", simp)
  apply (insert FreshlocDom, rule, fast)
  apply (rule FL_Same, assumption)
  apply (erule SameSubset, assumption)
  apply (simp add: same_def sameOH_def FMAPlookup1)
(* case n > 0 *)
apply clarsimp
apply (rule_tac x=l in exI, clarsimp)
apply (erule FL.elims, simp_all, clarsimp)
apply (subgoal_tac "sameOH (Dom ha - {a}) ha
           (ha\<lparr>sheap := (sheap ha)(DIAM := (sheap ha DIAM)(DOLLAR_F := ha\<lfloor>a\<diamondsuit>DOLLAR_N\<rfloor>)),
                 iheap := (iheap ha)(DOLLAR := (iheap ha DOLLAR)(a := i_tag)),
                 iheap := (iheap ha)(DOLLAR := (iheap ha DOLLAR)(a := i_tag), F0 := (iheap ha F0)(a := i_v0)),
                 rheap := (rheap ha)(F1 := (rheap ha F1)(a := r_v1))\<rparr>)", simp)
  apply (rule FL_SameOH, assumption)
  apply (erule SameOHSubset)
  apply (insert FL_Dom, fast)
  apply (simp add: sameOH_def)

apply (rule vdm_conseq, assumption)
apply clarsimp
apply (simp add: make_IID_Spec_def MakeIID_Spec2_def)
apply (erule thin_rl, erule thin_rl)
apply clarsimp
apply (erule_tac x=n in allE, erule_tac x=X in allE, safe)
apply (erule_tac x=nn in allE, safe)
apply (rule_tac x=l in exI, safe)
apply clarsimp
apply (erule_tac x=nn in allE, safe)
done

lemma Make_I_Aux: 
"\<lbrakk>fill_DI_Spec; make_I_Spec; alloc_Spec;
  (DIAM\<bullet>Fill_DI ([RNarg x_, INarg tag_]),
                         MS DIAM Fill_DI [RNarg x_, INarg tag_]) : G;
  (DIAM\<bullet>Alloc([]), MS DIAM Alloc []) : G\<rbrakk>
\<Longrightarrow> G \<rhd> snd (methtable DIAM Make_I) :
        (\<lambda>E h hh v p. \<forall>E'. E = newframe_env Nullref (fst (methtable DIAM Make_I)) x E' \<longrightarrow>
                           MS DIAM Make_I x E' h hh v
                              (mkRescomp (3 + clock p) (callc p) (1 + invkc p) (Suc (invkdpth p))))" 
apply (simp add:  Meth_Make_I)
apply (rule vdm_conseq)
apply (rule vdmC_basics)+
apply (rule vdm_ax, assumption)
apply (rule vdm_ax, assumption)
apply (simp add: make_I_Spec_def fill_DI_Spec_def alloc_Spec_def newframe_env_def evalARGS_def, clarsimp)
apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl) 
apply (simp add: letrComb_def, clarsimp)
apply (erule_tac x=n in allE, erule impE, rule, assumption, safe)
(* 4 goals*)
apply (erule_tac x=l in allE, clarsimp)
apply (simp add: predicates, clarsimp)
(* 3 goals*)
apply (erule_tac x=l in allE, clarsimp)
apply (simp add: predicates newObj_def, clarsimp)
(* 2 goals*)
apply (erule_tac x=la in allE, clarsimp)
apply (simp add: predicates newObj_def, clarsimp)
(* 1 goal*)
apply (erule_tac x=la in allE, clarsimp)
apply (simp add: predicates newObj_def, clarsimp)
done

lemma Make_IID_Aux: 
"\<lbrakk>fill_DIID_Spec; make_IID_Spec; alloc_Spec;
  (DIAM\<bullet>Fill_DIID ([RNarg x_, INarg tag_, INarg v0_, RNarg v1_]),
                         MS DIAM Fill_DIID [RNarg x_, INarg tag_, INarg v0_, RNarg v1_]) : G;
  (DIAM\<bullet>Alloc([]), MS DIAM Alloc []) : G\<rbrakk>
\<Longrightarrow>  G \<rhd> snd (methtable DIAM Make_IID) :
      (\<lambda>E h hh v p. \<forall>E'. E = newframe_env Nullref (fst (methtable DIAM Make_IID)) x E' \<longrightarrow>
                         MS DIAM Make_IID x E' h hh v
                            (mkRescomp (3 + clock p) (callc p) (1 + invkc p) (Suc (invkdpth p))))" 
apply (simp add:  Meth_Make_IID)
apply (rule vdm_conseq)
apply (rule vdmC_basics)+
apply (rule vdm_ax, assumption)
apply (rule vdm_ax, assumption)
apply (simp add: make_IID_Spec_def fill_DIID_Spec_def alloc_Spec_def newframe_env_def evalARGS_def, clarsimp)
apply (erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl) 
apply (simp add: letrComb_def, clarsimp)
apply (erule_tac x=n in allE, erule impE, rule, assumption, safe)
(* 4 goals*)
apply (erule_tac x=l in allE, clarsimp)
apply (simp add: predicates, clarsimp)
(* 3 goals*)
apply (erule_tac x=l in allE, clarsimp)
apply (simp add: predicates newObj_def, clarsimp)
(* 2 goals*)
apply (erule_tac x=la in allE, clarsimp)
apply (simp add: predicates newObj_def, clarsimp)
apply simp
(* 1 goal*)
apply (erule_tac x=la in allE, clarsimp)
apply (simp add: predicates newObj_def, clarsimp)
done

(*<*)
end
(*>*)
