header {*Derived axiomatic rules*}
(*<*)
theory VDMderivedPC = VDMpc: 
(*>*)

text {*
 In this section we define several useful rules, that are derived from the core 
 program logic. 
*}

subsection{*An alternative call rule*}
lemma Call1:
"\<lbrakk>(G \<union> {(CALL f, \<lambda> E h hh v p . \<exists> p'. tkcall p' = p \<and> P E h hh v p')}) \<rhd> (funtable f) : P\<rbrakk> \<Longrightarrow>
           G \<rhd> (CALL f) : (\<lambda> E h hh v p. \<exists> p'. tkcall p' = p \<and> P E h hh v p')"
(*<*)
apply (rule vdm_call)
apply clarsimp
apply (subgoal_tac "P = (\<lambda> E h hh v p.
                         \<exists> p'. (clock p' = clock p \<and> callc p' = callc p \<and>
                                invkc p' = invkc p \<and> invkdpth p' = invkdpth p \<and> 
                                P E h hh v p'))", simp)
apply (rule, rule, rule, rule, rule)
apply auto
apply (subgoal_tac "p' = p", simp+)
done
(*>*)

subsection {* Weakening lemmas for contexts *}
lemma CtxtWeak: "G \<rhd> e : P \<Longrightarrow> (G \<union> D) \<rhd> e : P"
(*<*)
apply (erule vdm_proof.induct)
apply (fast intro!: vdm_proof.intros)+
apply (rule vdm_if, simp, simp)
apply (rule vdm_leti,assumption+)
apply (rule vdm_letr, assumption+)
apply (rule vdm_letv, assumption+)
apply (rule vdm_call, simp)
apply (rule vdm_invokestatic, simp)
apply (rule vdm_invoke, simp)
apply (rule vdm_ax,simp)
apply (rule vdm_conseq, auto)
done
(*>*)

lemma CtxtWeakSingleton: "G \<rhd> e : P \<Longrightarrow> (insert (ee, Q) G) \<rhd> e : P"
(*<*)by (insert CtxtWeak [of G e P "{(ee,Q)}"], simp)(*>*)

subsection {* Cut rules *}
lemma CutAux: 
  "(DD \<rhd> e : Q \<Longrightarrow>
  (\<forall> G ee P D . (DD = (insert (ee, P) D) \<longrightarrow> (G \<rhd> ee :P) \<longrightarrow> (G \<subseteq> D) \<longrightarrow> D \<rhd> e:Q)))"
(*<*)
apply (erule vdm_proof.induct)
apply clarify
apply (fast intro: vdm_null)
apply (fast intro: vdm_int)
apply (fast intro: vdm_ivar)
apply (fast intro: vdm_rvar)
apply (fast intro: vdm_prim)
apply (fast intro: vdm_rprim)
apply (fast intro: vdm_getfi)
apply (fast intro: vdm_getfr)
apply (fast intro: vdm_putfi)
apply (fast intro: vdm_putfr)
apply (fast intro: vdm_getstat)
apply (fast intro: vdm_putstat)
apply (fast intro: vdm_new)
(*case vdm_if*)
apply clarsimp
apply (erule_tac x=Ga in allE, erule_tac x=Ga in allE)
apply (erule_tac x=ee in allE, erule_tac x=ee in allE)
apply (erule_tac x=P in allE, erule_tac x=P in allE)
apply (erule_tac x=D in allE, erule_tac x=D in allE)
apply (insert vdm_if, simp)
(*case vdm_leti*)
apply clarsimp apply (rotate_tac 4) apply(erule thin_rl)
apply (erule_tac x=Ga in allE, erule_tac x=Ga in allE)
apply (erule_tac x=ee in allE, erule_tac x=ee in allE)
apply (erule_tac x=P in allE, erule_tac x=P in allE)
apply (erule_tac x=D in allE, erule_tac x=D in allE)
apply (insert vdm_leti, simp)
(*case vdm_letr*)
apply clarsimp apply (rotate_tac 4) apply(erule thin_rl, erule thin_rl)
apply (erule_tac x=Ga in allE, erule_tac x=Ga in allE)
apply (erule_tac x=ee in allE, erule_tac x=ee in allE)
apply (erule_tac x=P in allE, erule_tac x=P in allE)
apply (erule_tac x=D in allE, erule_tac x=D in allE)
apply (insert vdm_letr, simp)
(*case vdm_letv*)
apply clarsimp apply (rotate_tac 4) apply(erule thin_rl, erule thin_rl, erule thin_rl)
apply (erule_tac x=Ga in allE, erule_tac x=Ga in allE)
apply (erule_tac x=ee in allE, erule_tac x=ee in allE)
apply (erule_tac x=P in allE, erule_tac x=P in allE)
apply (erule_tac x=D in allE, erule_tac x=D in allE)
apply (insert vdm_letv, simp)
(*case vdm_call*)
apply clarsimp apply (rotate_tac 2) apply(erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (rule vdm_call)
apply (erule_tac x = Ga in allE, erule_tac x = ee in allE, erule_tac x = Pa in allE,
       erule_tac x="(insert (CALL f, P) D)" in allE, fastsimp) 
(* case vdm_invokestatic*)
apply clarsimp apply (rotate_tac 2) apply(erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (rule vdm_invokestatic)
apply clarsimp
apply (erule_tac x = Ga in allE, erule_tac x = ee in allE, erule_tac x = Pa in allE,
       erule_tac x="(insert (C\<bullet>mn(args), P) D)" in allE, fastsimp) 
(* case vdm_invoke *)
apply clarsimp apply (rotate_tac 1) apply(erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (rule vdm_invoke)
apply clarsimp
apply (erule_tac x = "C" in allE, clarsimp)
apply (erule_tac x = Ga in allE, erule_tac x = ee in allE, erule_tac x = Pa in allE,
       erule_tac x="(insert (x\<diamondsuit>mn(args), P) D)" in allE, fastsimp) 
(*Case vdm_ax*)
apply clarsimp apply (rotate_tac 1) apply(erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply (erule disjE)
apply clarsimp
apply (subgoal_tac "(Ga \<union> D) \<rhd>  ee : Pa")
apply (subgoal_tac "D = (Ga \<union> D)", simp, fast)
apply (simp add: CtxtWeak)
apply (rule vdm_ax, simp)
(*Case vdm_conseq*)
apply (rotate_tac 3) apply(erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply clarsimp
apply (subgoal_tac "D \<rhd>  e : P") 
apply (erule vdm_conseq) apply assumption 
apply (rotate_tac -3) apply (erule thin_rl) apply (erule allE)+
   apply (erule impE, simp)+ apply simp
done
(*>*)

(*<*)
lemma CCutAux: 
"(DD \<rhd> e : Q \<Longrightarrow>
(\<forall> G f P D . (DD = (insert (Call f, P) D) \<longrightarrow> (G \<rhd> Call f :P) \<longrightarrow> (G \<subseteq> D) \<longrightarrow> D \<rhd> e:Q)))"
by (drule CutAux , simp)

lemma InvStat_CutAux: 
"(DD \<rhd> e : Q) \<Longrightarrow>
(\<forall> G C mn y P D . ((DD = (insert (C\<bullet>mn(y), P) D)) \<longrightarrow> (G \<rhd> (C\<bullet>mn(y)) : P) \<longrightarrow> (G \<subseteq> D) \<longrightarrow> (D \<rhd> e : Q)))"
by (drule CutAux , simp)

lemma Inv_CutAux: 
"(DD \<rhd> e : Q) \<Longrightarrow>
(\<forall> G C mn P D . ((DD = (insert (x\<diamondsuit>mn(y), P) D)) \<longrightarrow> (G \<rhd> (x\<diamondsuit>mn(y)) : P) \<longrightarrow> (G \<subseteq> D) \<longrightarrow> (D \<rhd> e : Q)))"
by (drule CutAux , simp)
(*>*)

lemma CCut:"\<lbrakk> (insert (ee, P) D) \<rhd> e: Q; G \<rhd> ee : P; G \<subseteq> D\<rbrakk> \<Longrightarrow> D \<rhd> e:Q"
(*<*)by (drule CutAux , simp)(*>*)

lemma cut:"\<lbrakk> G \<rhd> ee : P ; (insert (ee, P) G) \<rhd> e : Q \<rbrakk> \<Longrightarrow> G \<rhd> e : Q"
(*<*)by (drule CutAux , simp)(*>*)

text {* The predicates contextProvable G D is true if all entries in G are provable from D.*}
constdefs contextProvable::" vdmcontext \<Rightarrow>  vdmcontext \<Rightarrow> bool"
"contextProvable G D == (\<forall> e Q . (e, Q) : G \<longrightarrow> D \<rhd> e : Q)"
(*<*)
lemma cut2Aux:
"\<forall> G D . (finite G \<longrightarrow> D \<subseteq> G \<longrightarrow> (G-D, n) : cardR \<longrightarrow>
          (\<forall> e P. (G \<rhd> e : P \<longrightarrow> (contextProvable G D) \<longrightarrow> D \<rhd> e : P)))"
apply (induct n)
apply clarsimp
apply (subgoal_tac "G = D", simp) apply (erule cardR.elims) apply fast apply simp
apply clarsimp
apply (erule_tac x=G in allE)
apply (erule impE, assumption)
apply (subgoal_tac "\<exists> ee P DDD . G - D = {(ee,P)} \<union> DDD \<and> (ee,P) \<notin> DDD \<and> (DDD,n) : cardR")
apply (erule exE)+
apply (erule conjE)+
apply (erule_tac x="D \<union> {(ee,Pa)}" in allE)
apply (erule impE)
apply rule
apply (subgoal_tac "x:D \<or> x : {(ee,Pa)}")
apply (erule disjE, fast)
apply simp
apply (subgoal_tac "(ee, Pa) \<in> G - D", fast)
apply (subgoal_tac "(ee, Pa) \<in> insert (ee, Pa) DDD", simp)
apply fast
apply fast
apply (erule impE)
defer 1
apply (erule_tac x=e in allE, erule_tac x=P in allE)
apply clarify
apply (erule impE)
apply (simp add: contextProvable_def)
apply (insert CtxtWeak)
apply (rule, clarsimp)
apply (erule_tac x=ea in allE, erule_tac x=Q in allE)
apply (erule impE, assumption)
apply (subgoal_tac "(D \<union> {(ee,Pa)}) \<rhd>  ea : Q ")
apply (subgoal_tac "D \<union> {(ee,Pa)} = insert (ee, Pa) D", simp)
apply simp
apply (erule_tac thin_rl, erule_tac thin_rl, erule_tac thin_rl, erule_tac thin_rl, erule_tac thin_rl, erule_tac thin_rl)
apply (rotate_tac 2)
apply fast
(* end of the proof of contextprovable G - \<dots>*)
apply (rotate_tac -1, erule thin_rl)
apply (rule CCut)
apply (subgoal_tac "insert (ee, Pa) D \<rhd>  e : P", assumption)
apply (subgoal_tac "D \<union> {(ee,Pa)} = insert (ee, Pa) D", simp)
apply simp
apply (subgoal_tac "D \<rhd>  ee : Pa", assumption)
apply (subgoal_tac "(ee,Pa) \<in> G")
apply (simp add: contextProvable_def)
apply (subgoal_tac "(ee, Pa) \<in> G - D", fast)
apply (subgoal_tac "(ee, Pa) \<in> {(ee, Pa)} \<union> DDD", simp)
apply fast
apply simp
apply (rotate_tac 3, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
defer 1
apply (subgoal_tac "G - (D \<union> {(ee, Pa)}) = DDD", simp)
apply (rotate_tac 3) apply (erule thin_rl, erule thin_rl)apply (rotate_tac 3) apply (erule thin_rl)
apply rule
apply rule 
apply blast
apply rule
apply blast
  apply (erule cardR.elims, simp, clarsimp)
  apply (rule_tac x=a in exI, rule_tac x=b in exI, rule_tac x=A in exI, simp)
done
(*>*)

lemma cut2:"\<lbrakk>finite G; G \<rhd> e : P; D \<subseteq> G; contextProvable G D\<rbrakk> \<Longrightarrow> D \<rhd> e : P"
(*<*)
by (subgoal_tac "\<exists> n. (G-D, n):cardR", clarsimp,
    simp add: cut2Aux finite_imp_cardR,
    simp add: finite_imp_cardR)
(*>*)

subsection {* Specification tables and good contexts*}
text {*
 We require that method and function specifications are collected in the following tables.
*}

consts
  spectable  :: "funame \<Rightarrow> vdmassn"          -- {* specifications of functions *}
  (*Mspectable :: "cname \<Rightarrow> mname \<Rightarrow> vdmassn"  -- {* specifications of methods *}*)
  MS :: "cname \<Rightarrow> mname \<Rightarrow> ARGTYPE \<Rightarrow> vdmassn"

text {* 
 We define what it means for a context to be consistent with the above tables.
*}

constdefs goodContext::" vdmcontext \<Rightarrow> bool"
"goodContext G == (\<forall> e P . (e,P) : G \<longrightarrow> 
                        (\<exists> f . e = Call f \<and> P = spectable f \<and> G \<rhd> funtable f: (\<lambda> E h hh v p . P E h hh v (tkcall p))) \<or> 
                        (\<exists> A c mn y . e = A\<diamondsuit>mn(y) \<and> (P = MS c mn y) \<and> 
                                                   (\<forall> x C d . G \<rhd> (snd (methtable C mn)): 
                                                       (\<lambda> E h hh v p . \<forall> E'. classOf E' h A C \<and> 
                                                                             E = newframe_env (E'\<lfloor>A\<rfloor>) (fst (methtable C mn)) x (E') \<longrightarrow>  
                                                                  MS d mn x E' h hh v (\<langle>5 0 1 1\<rangle> \<oplus> p)))) \<or> 
                        (\<exists> C mn y. e = C\<bullet>mn(y) \<and> P = MS C mn y \<and> 
                                    ( \<forall> x . G \<rhd> (snd (methtable C mn)): 
                                            (\<lambda> E h hh v p. (\<forall> E'. E = newframe_env Nullref (fst (methtable C mn)) x (E') \<longrightarrow> 
                                                          MS C mn x E' h hh v (\<langle>3 0 1 1\<rangle> \<oplus> p))))))"

text {*This property is preserved when elements are deleted from G.*}
lemma goodContext_preserved: "\<lbrakk>goodContext G; (e,Q):G\<rbrakk> \<Longrightarrow> goodContext (G - {(e,Q)})"
(*<*)
apply (simp add: goodContext_def, (rule allI)+, rule)
apply (subgoal_tac "(G - {(e,Q)}) \<rhd> e:Q")(*now use the subgoal (G - {(e,Q)}) \<rhd> e:Q to prove the goal*)
apply (subgoal_tac "G = insert (e, Q) (G - {(e, Q)})") prefer 2 apply fast
apply (erule_tac x=ea in allE, erule_tac x=P in allE)
apply (erule impE, simp)
apply (erule disjE)
(*case call*)
apply (rule disjI1, clarify)
apply (rule_tac x=f in exI, clarsimp)
apply (rule cut, assumption, simp)
apply (erule disjE)
(*case invoke*)
apply (rule disjI2, rule disjI1, clarify)
apply (rule_tac x=A in exI, rule_tac x=c in exI, rule_tac x=mn in exI, rule_tac x=y in exI, clarsimp)
apply (erule_tac x=x in allE)
apply (erule_tac x=C in allE)
apply (erule_tac x=d in allE)
apply (rule cut, assumption, simp)
(*case invokestatic*)
apply (rule disjI2, rule disjI2, clarify)
apply (rule_tac x=C in exI, rule_tac x=mn in exI, rule_tac x=y in exI, clarsimp)
apply (rule cut, assumption, simp)
(* now prove the subgoal (G - {(e, Q)}) \<rhd>  e : Q *)
  apply (erule_tac x=e in allE, erule_tac x=Q in allE, simp)
  apply (erule disjE, clarify)
  (*case call*)
  apply (rule vdm_call)
  apply (subgoal_tac "G = ({(CALL f, spectable f)} \<union> (G - {(CALL f, spectable f)}))", simp)
  apply fast
  apply (erule disjE, clarify)
  (* case invoke *)
  apply (rule vdm_invoke)
  apply clarsimp
  apply (subgoal_tac "G = insert (A\<diamondsuit>mn(y), MS c mn y) G", simp)
  apply fast
  (* case invokestatic *)
  apply clarsimp
  apply (rule vdm_invokestatic) 
  apply (subgoal_tac "G = ({(C\<bullet>mn(y), MS C mn y)} \<union> (G - {(C\<bullet>mn(y), MS C mn y)}))", simp)
  apply fast
done
(*>*)

subsection {* Mutual recursion *}
(*<*)
lemma MUTREClemma: 
"\<forall> G . ((finite G \<and> card G = n \<and> goodContext G \<and> (e,P) : G) \<longrightarrow> \<rhd> e:P)"
apply (induct n)
(*case n=0*)
apply clarsimp
(*Case n>0*)
apply clarsimp
apply (case_tac "G = {(e,P)}")
apply clarsimp
apply (erule_tac x="{(e,P)}" in allE)
apply (clarsimp, simp add:goodContext_def)
apply (erule disjE, clarsimp)
apply (rule vdm_call, clarsimp)
apply (erule disjE, clarsimp)
apply (rule vdm_invoke, clarsimp)
apply clarsimp
apply (rule vdm_invokestatic, clarsimp)
(*Case G has more entries than (e,P)*) 
apply (subgoal_tac "\<exists> ee Q . (ee,Q) \<noteq> (e,P) \<and> (ee,Q) : G")
prefer 2
apply (rotate_tac 2)
apply ( erule thin_rl)
apply (rotate_tac 1)
apply (erule thin_rl)
apply fastsimp
(* use the fact that there is another pair (ee,Q):G*)
apply clarsimp
apply (subgoal_tac "(G - {(ee,Q)}) \<rhd> ee: Q")
apply (erule_tac x="G - {(ee, Q)}" in allE)
apply (rotate_tac -1) apply (erule impE) apply (simp add: goodContext_preserved)
apply (subgoal_tac "card (G - {(ee, Q)}) = n", simp)
apply (simp add: card_Diff_singleton) 
(*the proof for (G - {(ee, Q)}) \<rhd>  ee : Q *)
apply (rotate_tac -4) apply (erule thin_rl)
apply (simp add: goodContext_def)
apply (erule_tac x=ee in allE, erule_tac x=Q in allE, simp)
apply (erule disjE, clarsimp)
  (*case call*)
    apply (rule vdm_call)
    apply (subgoal_tac "({(CALL f, spectable f)} \<union> (G - {(CALL f, spectable f)})) = G", simp)
    apply fast
  apply (erule disjE, clarsimp)
  (*case invoke*)
    apply (rule vdm_invoke, clarsimp)
    apply (erule_tac x=y in allE)
    apply (subgoal_tac "insert (A\<diamondsuit>mn(y), MS c mn y) G = G", simp)
    apply fast
  (*case invokestatic*)
    apply clarsimp
    apply (rule vdm_invokestatic)
    apply (subgoal_tac "({(C\<bullet>mn(y), MS C mn y)} \<union> (G - {(C\<bullet>mn(y), MS C mn y)})) = G", simp)
    apply fast
done
(*>*)

text {* The rule for proving properties over mutually recursive functions/methods is proven by
 induction on the size of $G$.*}

theorem MUTREC:
"\<lbrakk> finite G; card G = n; goodContext G; (e,P) : G \<rbrakk> \<Longrightarrow> \<rhd> e:P"
(*<*)by (insert MUTREClemma [of n e P], fast)(*>*)
(*<*)

subsection {*Adaptation*}

lemma goodAdaptInvs: "\<lbrakk> (c\<bullet>m(y), MS c m y) : G; goodContext G\<rbrakk> \<Longrightarrow> G \<rhd> (c\<bullet>m(z)) : MS c m z"
by (rule vdm_invokestatic, simp, rule CtxtWeakSingleton, simp add: goodContext_def,fastsimp)

lemma goodAdaptInvv: "\<lbrakk> (A\<diamondsuit>m(y), MS c m y) : G; goodContext G\<rbrakk> \<Longrightarrow> G \<rhd> (A\<diamondsuit>m(z)) : MS c m z"
by (rule vdm_invoke, clarsimp, rule CtxtWeakSingleton, simp add: goodContext_def, fastsimp)

text {* The following adaptation rule is more useful than the above since 
        the context decreases -- in the end we will want to prove specifications 
        in the empty context!*}
lemma AdaptInvs[rule_format]: 
"\<lbrakk>goodContext G; (c\<bullet>m(y), MS c m y) : G\<rbrakk> \<Longrightarrow> (G - {(c\<bullet>m(y), MS c m y)}) \<rhd> (c\<bullet>m(z)) : MS c m z"
(*<*)
apply (subgoal_tac "goodContext (G \<union> {(c\<bullet>m(z), MS c m z)})")
apply (rule vdm_invokestatic)
apply (case_tac "y=z")
(*case y=z*)
apply (subgoal_tac "G = ({(c\<bullet>m(z), MS c m z)} \<union> (G - {(c\<bullet>m(y), MS c m y)}))", simp)
  prefer 2 apply fast
  apply (simp add: goodContext_def)
  apply (erule_tac x="c\<bullet>m(z)" in allE, erule_tac x="MS c m z" in allE, clarsimp)
apply (rule cut)
apply (subgoal_tac "({(c\<bullet>m(z), MS c m z)} \<union> (G - {(c\<bullet>m(y), MS c m y)})) \<rhd>  (c\<bullet>m(y)) : MS c m y", assumption)
prefer 2 apply (erule thin_rl, simp add: goodContext_def) 
         apply (erule_tac x="c\<bullet>m(y)" in allE, erule_tac x="MS c m y" in allE, clarsimp)
         apply (erule_tac x=z in allE)
         apply (subgoal_tac "insert (c\<bullet>m(y), MS c m y) (insert (c\<bullet>m(z), MS c m z) (G -{(c\<bullet>m(y), MS c m y)})) =
                             insert (c\<bullet>m(z), MS c m z) G", clarsimp)
         apply fast
apply (rule vdm_invokestatic)
apply (subgoal_tac "({(c\<bullet>m(y), MS c m y)} \<union> ({(c\<bullet>m(z), MS c m z)} \<union> (G - {(c\<bullet>m(y), MS c m y)}))) =
                    {(c\<bullet>m(z), MS c m z)} \<union> G", simp) prefer 2 apply fast 
apply (erule thin_rl, simp add: goodContext_def)
apply (subgoal_tac "insert (c\<bullet>m(y), MS c m y) ({(c\<bullet>m(z), MS c m z)} \<union> (G - {(c\<bullet>m(y), MS c m y)}))=
                    {(c\<bullet>m(z), MS c m z)} \<union> G", simp) prefer 2 apply fast 
apply fastsimp
(*last goal*)
apply (simp add: goodContext_def,clarsimp)
apply (rule, clarsimp)
(*2 goals*)
(*1*)
  apply (erule_tac x="c\<bullet>m(y)" in allE, erule_tac x="MS c m y" in allE, clarsimp)
  apply (erule_tac x=x in allE)
  apply (erule CtxtWeakSingleton)
(*2*)
apply rule
apply (erule_tac x=e in allE, erule_tac x=P in allE, erule impE, simp)
apply (erule disjE)
(*a*) apply (erule exE, (erule conjE)+) apply (rule disjI1) apply (rule_tac x=f in exI, simp)
  apply (erule CtxtWeakSingleton)
apply (erule disjE)
(*b*) apply ((erule exE)+, (erule conjE)+) apply (rule disjI2, rule disjI1) 
  apply (rule_tac x=A in exI, rule_tac x=ca in exI, rule_tac x=mn in exI, rule_tac x=ya in exI, clarsimp)
  apply (erule_tac x=x in allE, erule_tac x=C in allE, erule_tac x=d in allE)
  apply (erule CtxtWeakSingleton)
(*c*) apply ((erule exE)+, (erule conjE)+) apply (rule disjI2, rule disjI2) 
  apply (rule_tac x=C in exI, rule_tac x=mn in exI, rule_tac x=ya in exI, clarsimp)
  apply (erule_tac x=x in allE)
  apply (erule CtxtWeakSingleton)
done
(*>*)

lemma AdaptInvv[rule_format]: 
"\<lbrakk>goodContext G; (A\<diamondsuit>m(y), MS c m y) : G\<rbrakk> \<Longrightarrow> (G - {(A\<diamondsuit>m(y), MS c m y)}) \<rhd> (A\<diamondsuit>m(z)) : MS c m z"
(*<*)
apply (subgoal_tac "goodContext (G \<union> {(A\<diamondsuit>m(z), MS c m z)})")
apply (rule vdm_invoke)
apply (case_tac "y=z")
(*case y=z*)
apply (subgoal_tac "G = ({(A\<diamondsuit>m(z), MS c m z)} \<union> (G - {(A\<diamondsuit>m(y), MS c m y)}))", simp)
  prefer 2 apply fast
  apply (simp add: goodContext_def)
  apply (erule_tac x="A\<diamondsuit>m(z)" in allE, erule_tac x="MS c m z" in allE, clarsimp)
(*case y \<noteq> z*)
apply (rule, rule cut)
apply (subgoal_tac "({(A\<diamondsuit>m(z), MS c m z)} \<union> (G - {(A\<diamondsuit>m(y), MS c m y)})) \<rhd>  (A\<diamondsuit>m(y)) : MS c m y", assumption)
prefer 2 apply (erule thin_rl, simp add: goodContext_def) 
         apply (erule_tac x="A\<diamondsuit>m(y)" in allE, erule_tac x="MS c m y" in allE, clarsimp)
         apply (erule_tac x=z in allE, erule_tac x=C in allE, erule_tac x=c in allE)
         apply (subgoal_tac "insert (A\<diamondsuit>m(y), MS ca m y)
               (insert (A\<diamondsuit>m(z), MS c m z)
                 (G - {(A\<diamondsuit>m(y),
                        MS ca m y)})) = insert (A\<diamondsuit>m(z), MS c m z) G", clarsimp)
         apply fast
apply (rule vdm_invoke)
apply (subgoal_tac "({(A\<diamondsuit>m(y), MS c m y)} \<union> ({(A\<diamondsuit>m(z), MS c m z)} \<union> (G - {(A\<diamondsuit>m(y), MS c m y)}))) =
                    {(A\<diamondsuit>m(z), MS c m z)} \<union> G", simp) prefer 2 apply fast 
apply (erule thin_rl, simp add: goodContext_def)
apply (subgoal_tac "insert (A\<diamondsuit>m(y), MS c m y) ({(A\<diamondsuit>m(z), MS c m z)} \<union> (G - {(A\<diamondsuit>m(y), MS c m y)}))=
                    {(A\<diamondsuit>m(z), MS c m z)} \<union> G", simp) prefer 2 apply fast
apply fastsimp 
(*last goal*)
apply (simp add: goodContext_def,clarsimp)
apply (rule, clarsimp)
(*2 goals*)
(*1*)
  apply (rule, rule_tac x=c in exI, clarsimp)
  apply clarsimp
  apply (erule_tac x="A\<diamondsuit>m(y)" in allE, erule_tac x="MS c m y" in allE, clarsimp)
  apply (erule_tac x=x in allE, erule_tac x=C in allE, erule_tac x=d in allE)
  apply (erule CtxtWeakSingleton)
(*2*)
apply rule
apply (erule_tac x=e in allE, erule_tac x=P in allE, erule impE, simp)
apply (erule disjE)
(*a*) apply (erule exE, (erule conjE)+) apply (rule disjI1) apply (rule_tac x=f in exI, simp)
  apply (erule CtxtWeakSingleton)
apply (erule disjE)
(*b*) apply ((erule exE)+, (erule conjE)+) apply (rule disjI2, rule disjI1) 
  apply (rule_tac x=Aa in exI, rule_tac x=ca in exI, rule_tac x=mn in exI, rule_tac x=ya in exI, clarsimp)
  apply (erule_tac x=x in allE, erule_tac x=C in allE, erule_tac x=d in allE)
  apply (erule CtxtWeakSingleton)
(*c*) apply ((erule exE)+, (erule conjE)+) apply (rule disjI2, rule disjI2) 
  apply (rule_tac x=C in exI, rule_tac x=mn in exI, rule_tac x=ya in exI, clarsimp)
  apply (erule_tac x=x in allE)
  apply (erule CtxtWeakSingleton)
done

lemma GoodContextCut: 
"\<lbrakk>goodContext G; (e,P) : G; D = G - {(e,P)}\<rbrakk> \<Longrightarrow> goodContext D"
(*<*)by (insert goodContext_preserved, fast)(*>*)

lemma EmptyProofInvs: "\<lbrakk>goodContext {(c\<bullet>m(y), MS c m y)}\<rbrakk> \<Longrightarrow>  \<rhd> (c\<bullet>m(z)) : MS c m z"
(*<*)by (subgoal_tac "({(c\<bullet>m(y), MS c m y)} - {(c\<bullet>m(y), MS c m y)}) \<rhd> (c\<bullet>m(z)) : MS c m z", 
     simp, erule AdaptInvs, simp)(*>*)
lemma EmptyProofInvv: "\<lbrakk>goodContext {(A\<diamondsuit>m(y), MS c m y)}\<rbrakk> \<Longrightarrow>  \<rhd> (A\<diamondsuit>m(z)) : MS c m z"
(*<*)by (subgoal_tac "({(A\<diamondsuit>m(y), MS c m y)} - {(A\<diamondsuit>m(y), MS c m y)}) \<rhd> (A\<diamondsuit>m(z)) : MS c m z", 
     simp, erule AdaptInvv, simp)(*>*)

lemma setUnique: "\<lbrakk>x \<in> A; \<not> (\<exists> y . y \<in> A - {x})\<rbrakk> \<Longrightarrow> A = {x}" by fast

lemma GCInvs_aux:"\<forall> G c m y. (G,n):cardR \<longrightarrow> goodContext G \<longrightarrow> 
                  (c\<bullet>m(y), MS c m y) : G \<longrightarrow> goodContext {(c\<bullet>m(y), MS c m y)}"
apply (induct n, safe)
apply (erule cardR.elims, simp, simp)
apply (case_tac "\<exists> e P. (e,P) : G - {(c\<bullet>m(y), MS c m y)}", (erule exE)+)
  apply (erule_tac x="G - {(e,P)}" in allE)
  apply (erule_tac x=c in allE, erule_tac x=m in allE, erule_tac x=y in allE)
  apply (erule impE)
    apply (erule cardR_determ_aux1, simp, simp)
  apply (erule impE) apply (erule GoodContextCut) prefer 2 apply simp apply fast
  apply (erule impE) apply fast apply assumption
apply (erule thin_rl)
apply (subgoal_tac "G = {(c\<bullet>m(y), MS c m y)}", simp)
apply (erule setUnique, fast)
done

lemma GCInvv_aux:"\<forall> G A c m y. (G,n):cardR \<longrightarrow> goodContext G \<longrightarrow> 
                  (A\<diamondsuit>m(y), MS c m y) : G \<longrightarrow> goodContext {(A\<diamondsuit>m(y), MS c m y)}"
apply (induct n, safe)
apply (erule cardR.elims, simp, simp)
apply (case_tac "\<exists> e P . (e,P) : G - {(A\<diamondsuit>m(y), MS c m y)}", (erule exE)+)
  apply (erule_tac x="G - {(e,P)}" in allE)
  apply (erule_tac x=A in allE, erule_tac x=c in allE, erule_tac x=m in allE, erule_tac x=y in allE)
  apply (erule impE)
    apply (erule cardR_determ_aux1, simp, simp)
  apply (erule impE) apply (erule GoodContextCut) prefer 2 apply simp apply fast
  apply (erule impE) apply fastsimp apply assumption
apply (erule thin_rl)
apply (subgoal_tac "G = {(A\<diamondsuit>m(y), MS c m y)}", simp) 
apply (erule setUnique,fast)
done

lemma GCInvs: "\<lbrakk>goodContext G; finite G; (c\<bullet>m(y), MS c m y) : G\<rbrakk> \<Longrightarrow> \<rhd> (c\<bullet>m(z)) : MS c m z"
apply (rule EmptyProofInvs)
apply (subgoal_tac "\<exists> n. (G,n):cardR", safe)
apply (insert GCInvs_aux, fast)
apply (erule finite_imp_cardR)
done

lemma GCInvv: "\<lbrakk>goodContext G; finite G; (A\<diamondsuit>m(y), MS c m y) : G\<rbrakk> \<Longrightarrow> \<rhd> (A\<diamondsuit>m(z)) : MS c m z"
apply (rule EmptyProofInvv)
apply (subgoal_tac "\<exists> n. (G,n):cardR", safe)
apply (insert GCInvv_aux, fast)
apply (erule finite_imp_cardR)
done
text {*The proof involves the cut rule, the weakening lemma and the 
       VDM rules for static and virtual method invocation.*}


end
(*>*)
