header {*Completeness of axiomatic semantics*}
(*<*)
theory VDMCompletePC = VDMderivedPC:
(*>*)

subsection {* Strongest specifications *}

text {* The semantic definition of strongest VDM specification
        correponds to the weakest hoare pre-condition, which 
        is simply the set of states which ensure the post-condition.*}

constdefs
 SSpec    :: " expr \<Rightarrow> vdmassn"
 "SSpec \<equiv> (\<lambda> e E h hh v p. (E \<turnstile> h,e \<Down> hh,v,p))"

text {* Strongest specifications are valid and imply any other valid assertions.*}
lemma SSpec_valid: "\<Turnstile> e: SSpec e"
(*<*)by (simp add: vdm_valid_def SSpec_def)(*>*)

lemma SSpec_strong: "( \<Turnstile> e : P) \<Longrightarrow> (\<forall> E h hh v p . (SSpec e E h hh v p \<longrightarrow> P E h hh v p))"
(*<*)by (simp add: vdm_valid_def SSpec_def)(*>*)

(*Needs inclusion of theory VDMSoundRecPC,thy
lemma VDM_proof_SSpec: "\<rhd> e : P \<Longrightarrow> (\<forall> E h hh v p . (SSpec e E h hh v p \<longrightarrow> P E h hh v p))"
apply (subgoal_tac "\<Turnstile> e : P")
apply (rule SSpec_strong, simp)
apply (insert vdm_sound) apply fastsimp
done
*)

text {* The overall proof idea for the completeness proof follows \cite{HofmannScript} 
        and \cite{nipkow02:HoareRec}): 

    \verb+(1)SSpec_lemma -(2)-> completeAux -(3)-> vdm_complete+

    with the following proof ideas in the 3 steps of the proof:

    \begin{enumerate}
     \item induction over expr; use vdm\_ax in Call case 
     \item induction over expr; use vdm\_call and SSpec\_lemma in Call case
     \item  use vdm\_conseq and completeAux
    \end{enumerate}
*}

text {* The following lemma relates function and method calls to 
        the corresponding specifications *}
lemma SSpec_lemma: 
"\<lbrakk>\<forall> f . G \<rhd> (Call f) : SSpec (Call f);
  \<forall> C mn y. G \<rhd> (C\<bullet>mn(y)) : SSpec (C\<bullet>mn(y));
  \<forall> x mn y. G \<rhd> (x\<diamondsuit>mn(y)) : SSpec (x\<diamondsuit>mn(y))\<rbrakk>
 \<Longrightarrow> G \<rhd> e : (SSpec e)"
(*<*)
apply (simp add: SSpec_def sem_def)
apply (induct e)
apply (simp_all) (*  NB: Call and invoke cases disappear already! *)
(* Int *)
apply (rule vdm_conseq, rule vdm_int, clarsimp)
apply (rule_tac x=1 in exI, rule semInt)
(*IVar*)
apply (rule vdm_conseq, rule vdm_ivar, clarsimp)
apply (rule_tac x=1 in exI, rule semIVar)
(*Primop*)
apply (rule vdm_conseq, rule vdm_prim, clarsimp)
apply (rule_tac x=1 in exI, rule semPrimop)
(*Null*)
apply (rule vdm_conseq, rule vdm_null, clarsimp)
apply (rule_tac x=1 in exI, rule semNull)
(*RVar*)
apply (rule vdm_conseq, rule vdm_rvar, clarsimp)
apply (rule_tac x=1 in exI, rule semRVar)
(*RPrimop*)
apply (rule vdm_conseq, rule vdm_rprim, clarsimp)
apply (rule_tac x=1 in exI, rule semRPrimop)
(*New*)
apply (rule vdm_conseq, rule vdm_new, clarsimp)
apply (rule_tac x=1 in exI, rule semNew, simp)
(*Getfi*)
apply (rule vdm_conseq, rule vdm_getfi, clarsimp)
apply (rule_tac x=1 in exI, rule semGetfi, simp)
(*Getfr*)
apply (rule vdm_conseq, rule vdm_getfr, clarsimp)
apply (rule_tac x=1 in exI, rule semGetfr, simp)
(*Putfi*)
apply (rule vdm_conseq, rule vdm_putfi, clarify)
apply (rule_tac x=1 in exI, rule semPutfi, fastsimp)
(*Putfr*)
apply (rule vdm_conseq, rule vdm_putfr, clarify)
apply (rule_tac x=1 in exI, rule semPutfr, simp)
(*Getstat*)
apply (rule vdm_conseq, rule vdm_getstat, clarsimp)
apply (rule_tac x=1 in exI, rule semGetstat)
(*Putstat*)
apply (rule vdm_conseq, rule vdm_putstat, clarify)
apply (rule_tac x=1 in exI, rule semPutstat)
(*Leti*)
apply (rule vdm_conseq, rule vdm_leti, fast, fast, clarsimp)
apply (rule_tac x="(max n na) + 1" in exI, insert semLeti, fastsimp)
(* Letr*)
apply (rotate_tac -1)
apply (erule thin_rl)
apply (rule vdm_conseq, rule vdm_letr, fast, fast, clarsimp)
apply (rule_tac x="(max n na) + 1" in exI, insert semLetr, fastsimp)
(* Letv*)
apply (rotate_tac -2)
apply (erule thin_rl)
apply (erule thin_rl)
apply (rule vdm_conseq, rule vdm_letv, fast, fast, clarsimp)
apply (rule_tac x="(max n na)" in exI, insert semLetv, fastsimp)
(*If*)
apply (rotate_tac -3)
apply (erule thin_rl)
apply (erule thin_rl)
apply (erule thin_rl)
apply (rule vdm_conseq, rule vdm_if, fast, fast, clarsimp)
apply (erule disjE, clarsimp)
apply (rule_tac x="n+1" in exI, insert semIf_True, fastsimp)
apply clarsimp
apply (rule_tac x="n+1" in exI, insert semIf_False, fastsimp)
done
(*>*)

subsection {* Specification contexts *}

text {*
 We now build the context to be used in the completeness proof. It has to 
 contain exactly the strongest specifications.
*}

constdefs strongContext:: "vdmcontext"
"strongContext == {(e,P) . \<exists> f. (e = (Call f) \<and> P = SSpec e)} \<union> 
                  {(e,P) . \<exists> C mn y. (e = (C\<bullet>mn(y)) \<and> P = SSpec e)} \<union> 
                  {(e,P) . \<exists> x mn y. (e = (x\<diamondsuit>mn(y)) \<and> P = SSpec e)}"

constdefs strongSpec::"vdmcontext \<Rightarrow> bool"
"strongSpec G == (\<forall> e P . (e,P): G \<longrightarrow> 
                  ((\<forall> f. e = Call f \<longrightarrow> spectable f = SSpec e) \<and> 
                   (\<forall> C mn y. e = C\<bullet>mn(y) \<longrightarrow> Mspectable C mn = SSpec e) \<and> 
                   (\<forall> x mn y. e = x\<diamondsuit>mn(y) \<longrightarrow> (\<exists> E h C . classOf E h x C \<and> Mspectable C mn = SSpec e))))"

text {* We next show that the strongSpec property applies consitency.
        First som auxiliary lemmas for function calls and method invocations.*}
lemma StrongspecConsistent_CaseCall:
"strongSpec strongContext \<Longrightarrow> 
 strongContext \<rhd>  (funtable f) : (\<lambda> E h hh v p. SSpec (CALL f) E h hh v (tkcall p))"
(*<*)
apply (subgoal_tac "strongContext \<rhd> (funtable f) : SSpec (funtable f)")
apply (subgoal_tac "SSpec (funtable f) = (\<lambda> E h hh v p. SSpec (CALL f) E h hh v (tkcall p))", simp)
(*proof of the set equality*)
  apply (simp add: SSpec_def sem_def)
  apply (rule, rule, rule, rule, rule, rule)
  (*inclusion \<subseteq> *)
  apply (clarsimp, rule_tac x="n + 1" in exI, insert semCall, fastsimp)
  (*inclusion \<supseteq> *)
  apply (clarsimp, erule semn.elims, simp_all, clarsimp)
  apply (rule_tac x="na" in exI)
  apply (subgoal_tac "pa=p", simp, simp)
(*proof of strongContext \<rhd>  funtable f : SSpec (funtable f)*)
apply (rule SSpec_lemma)
apply (clarsimp, rule vdm_ax)
apply (simp add: strongSpec_def strongContext_def)
apply (clarsimp, rule vdm_ax)
apply (simp add: strongSpec_def strongContext_def)
apply (clarsimp, rule vdm_ax)
apply (simp add: strongSpec_def strongContext_def)
done
(*>*)

lemma StrongspecConsistent_CaseInvStatic: 
"\<lbrakk>strongSpec strongContext ; (C\<bullet>mn(y), SSpec (C\<bullet>mn(y))) \<in> strongContext\<rbrakk> \<Longrightarrow>
 strongContext \<rhd>  (snd(methtable C mn)) : 
  (\<lambda> E h hh v p. \<forall> E'. E = newframe_env Nullref (fst (methtable C mn)) y E' \<longrightarrow>
                       SSpec (C\<bullet>mn(y)) E' h hh v (\<langle>(3 + clock p) (callc p) (1 + invkc p) (Suc (invkdpth p))\<rangle>))"
(*<*)
apply (subgoal_tac "strongContext \<rhd> (snd (methtable C mn)) : SSpec (snd (methtable C mn))")
prefer 2 apply (rule SSpec_lemma)
  apply (clarsimp, rule vdm_ax)
  apply (simp add: strongSpec_def strongContext_def)
  apply (clarsimp, rule vdm_ax)
  apply (simp add: strongSpec_def strongContext_def)
  apply (clarsimp, rule vdm_ax)
  apply (simp add: strongSpec_def strongContext_def)
apply (rule vdm_conseq, assumption)
apply (simp add: SSpec_def sem_def, rule)
apply (clarsimp, rule_tac x="n + 1" in exI, insert semInvokeStatic, fastsimp)
done
(*>*)

lemma StrongspecConsistent_CaseInvoke:
"\<lbrakk>strongSpec strongContext; ((x\<diamondsuit>mn(y)), SSpec (x\<diamondsuit>mn(y))) \<in> strongContext\<rbrakk> \<Longrightarrow> 
 strongContext \<rhd> (snd (methtable C mn)) : 
 (\<lambda> E h hh v p. \<forall> E'. (classOf E' h x C) \<and> E = newframe_env E'\<lfloor>x\<rfloor> (fst (methtable C mn)) y E' \<longrightarrow>
                       SSpec (x\<diamondsuit>mn(y)) E' h hh v (\<langle>(5 + clock p) (callc p) (1 + invkc p) (Suc (invkdpth p))\<rangle>))"
(*<*)
apply (subgoal_tac "strongContext \<rhd> (snd(methtable C mn)) : SSpec (snd(methtable C mn))")
prefer 2 apply (rule SSpec_lemma)
  apply (clarsimp, rule vdm_ax)
  apply (simp add: strongSpec_def strongContext_def)
  apply (clarsimp, rule vdm_ax)
  apply (simp add: strongSpec_def strongContext_def)
  apply (clarsimp, rule vdm_ax)
  apply (simp add: strongSpec_def strongContext_def)
apply (rule vdm_conseq, assumption)
apply (simp add: SSpec_def sem_def, rule)
apply (simp add: classOf_def)
apply (clarsimp, rule_tac x="n + 1" in exI, insert semInvoke, fastsimp)
done
(*>*)

text {*Now the main claim*}
lemma StrongspecConsistent: "strongSpec strongContext \<Longrightarrow> consistent strongContext"
(*<*)
apply (simp add: consistent_def)
apply (rule allI)+
apply rule
apply (subgoal_tac "(\<exists>f. e = CALL f) \<and> P = SSpec e \<or> (\<exists>C mn y. e = C\<bullet>mn(y)) \<and> P = SSpec e \<or> (\<exists>x mn y. e = x\<diamondsuit>mn(y)) \<and> P = SSpec e")
prefer 2 apply (simp add: strongContext_def)
apply (erule disjE, rule disjI1, clarsimp)
   apply rule apply (simp add: strongSpec_def) apply fastsimp 
   apply (subgoal_tac "strongContext \<rhd>  funtable f : 
                       (\<lambda> E h hh v p. SSpec (CALL f) E h hh v (\<langle>1 1 0 0\<rangle> \<smile> p))", simp)
   apply (erule StrongspecConsistent_CaseCall)
apply (erule disjE, rule disjI2, rule disjI2, clarsimp) apply rule apply (simp add: strongSpec_def) 
   apply fastsimp apply (fastsimp intro: StrongspecConsistent_CaseInvStatic)
apply (rule disjI2, rule disjI1, clarsimp) apply rule apply (simp add: strongSpec_def) 
   apply (erule_tac x="x\<diamondsuit>mn(y)" in allE, clarsimp)
   apply (erule impE, fast) apply clarsimp
   apply (subgoal_tac "SSpec (x\<diamondsuit>mn(y)) = Mspectable C mn", fast) apply simp 
   apply clarsimp
   apply (erule StrongspecConsistent_CaseInvoke, assumption)
done
(*>*)

subsection {* Proof of completeness *}

text {*
 We can now prove our main completeness theorem.
*}

lemma completeAux: "\<lbrakk>consistent strongContext; finite strongContext\<rbrakk> \<Longrightarrow> {} \<rhd> e: SSpec e"
(*<*)
apply (rule cut2)
apply assumption
defer 1
apply clarsimp
apply (simp add: strongContext_def)
apply (simp add: contextProvable_def strongContext_def)
apply clarsimp
apply (rule conjI, clarsimp)
(*Case call*)
apply (rule MUTREC)
prefer 3
apply assumption
apply (simp add: strongContext_def)
apply (simp add: strongContext_def)
apply simp
apply (rule conjI, clarsimp)
(*Case invokestatic*)
apply (rule MUTREC)
prefer 3
apply assumption
apply (simp add: strongContext_def)
apply (simp add: strongContext_def)
apply simp
apply (clarsimp)
(*Case invoke*)
apply (rule MUTREC)
prefer 3
apply assumption
apply (simp add: strongContext_def)
apply (simp add: strongContext_def)
apply simp
(*now the goal strongContext \<rhd>  e : SSpec e*)
apply (rule SSpec_lemma)
apply (clarsimp, rule vdm_ax, simp add: strongContext_def)+
done
(*>*)

theorem vdm_complete: "\<lbrakk>strongSpec strongContext; finite strongContext\<rbrakk> \<Longrightarrow> \<Turnstile> e : P \<Longrightarrow> \<rhd> e : P"
(*<*)
apply (subgoal_tac "consistent strongContext")
  apply (rule vdm_conseq)
  apply (rule completeAux)
  apply assumption
  apply assumption
  apply (erule SSpec_strong)
apply (erule StrongspecConsistent)
done
(*>*)
(*<*)
end
(*>*)
