theory Twice = DAss_rulesU:

(*DAssAdaptU currently not needed (will  contain the proof of the ADAPT lemma below*)

subsection{*Insertion into list*)Reverse function with free*}

text {* Camelot code:
\begin{verbatim}
type ilist = !Nil | Cons of int * ilist
let twice l = match l with Nil -> Nil | Cons(h,t)@_ -> Cons(h,Cons(h,twice t))
\end{verbatim}

Grail code:
\begin{verbatim}
method static public InsSort$dia_0 twice (InsSort$dia_0 l) =
  let fun f:twice(InsSort$dia_0 l) =
         if l = null[InsSort$dia_0] then f:0() else f:1(l)

      fun f:1(InsSort$dia_0 l) =
      let val v3 = getfield l <int InsSort$dia_0.f1>
          val v2 = getfield l <InsSort$dia_0 InsSort$dia_0.f0>
          val () = invokestatic <void InsSort$dia_0.free (InsSort$dia_0)> (l)
          val v1 = invokestatic <InsSort$dia_0 InsSort.twice (InsSort$dia_0)> (v2)
          val l = invokestatic <InsSort$dia_0 InsSort$dia_0.make (int, int, InsSort$dia_0)> (1, v3, v1)
      in invokestatic <InsSort$dia_0 InsSort$dia_0.make (int, int, InsSort$dia_0)> (1, v3, l)
      end

      fun f:0() = null[InsSort$dia_0]
   in f:twice(l)
   end
\end{verbatim}
*}

syntax b_    :: iname
       v3_   :: iname
       v2_   :: rname
       v1_   :: rname
       l_    :: rname 

       fTwice :: funame
       fzeroTwice :: funame
       foneTwice :: funame
       Twice :: mname

translations
 "b_" == "(In ''b'') "
 "v3_" == "(In ''v3'') "
 "v2_" == "(RN ''v2'') "
 "v1_" == "(RN ''v1'') "
 "l_" == "(RN ''l'') "
 "fTwice" == "(FN ''fTwice'') "
 "fzeroTwice" == "(FN ''f_zeroTwice'')"
 "foneTwice" == "(FN ''f_oneTwice'')"
 "Twice" == "(MN ''Twice'')"

axioms Meth_Twice: 
"methtable DIAM Twice = ([RNpar l_], CALL fTwice)"
lemma "methtable DIAM Twice = ([RNpar l_], CALL fTwice)" by (simp add: Meth_Twice)

axioms Fun_fTwice:
"funtable fTwice = LET b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) l_ l_
                    IN IF b_ THEN CALL fzeroTwice ELSE CALL foneTwice END"
lemma "funtable fTwice = LET b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) l_ l_
                    IN IF b_ THEN CALL fzeroTwice ELSE CALL foneTwice END"
by (simp add: Fun_fTwice)

(*I am chtwiceing here - null is not the correct value*)

axioms Fun_fzeroTwice:
"funtable fzeroTwice = Null"
lemma  "funtable fzeroTwice = Null"
by (simp add: Fun_fzeroTwice)

axioms Fun_foneTwice:
"funtable foneTwice =
       LET v3_ = GetFi l_ F0;
        rf v2_ = GetFr l_ F1;
             _ = DIAM\<bullet>Free ([RNarg l_]);
        rf v1_ = DIAM\<bullet>Twice ([RNarg v2_]);
        rf l_ = DIAM\<bullet>Make_IID ([VALarg (IVal 1), INarg v3_, RNarg v1_])
       IN DIAM\<bullet>Make_IID ([VALarg (IVal 1), INarg v3_, RNarg l_]) END"
lemma "funtable foneTwice =
       LET v3_ = GetFi l_ F0;
        rf v2_ = GetFr l_ F1;
             _ = DIAM\<bullet>Free ([RNarg l_]);
        rf v1_ = DIAM\<bullet>Twice ([RNarg v2_]);
        rf l_ = DIAM\<bullet>Make_IID ([VALarg (IVal 1), INarg v3_, RNarg v1_])
       IN DIAM\<bullet>Make_IID ([VALarg (IVal 1), INarg v3_, RNarg l_]) END"
by (simp add: Fun_foneTwice)

text {*Here is what Steffen's analysis claims:
 \begin{verbatim}
  twice      : 0, iList[0|int,#,1] -> iList[0|int,#,0], 0;
 \end<verbatim} *}

text {*This corresponds to the following specifications, formalised from the viewpoint of the
       method bodies: the contexts (in second parameter of @{text DAss}) are the contexts in which
       the method bodies are typed*}
constdefs Twice_Spec::vdmassn
"Twice_Spec == DAss {l_} 0 (emptyfinmap(l_ \<mapsto>\<^sub>f(ListET 1))) (ListET 0) 0"

text {*In order to prove the body correct we define a context which contatwice an single entry for each method.*}
constdefs  TwiceContext:: vdmcontext
"TwiceContext \<equiv> {(DIAM\<bullet>Twice([RNarg l_]), Twice_Spec)}"

lemma Twice_DAss:
"\<lbrakk>G = TwiceContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable DIAM Twice) : Twice_Spec"
apply (simp add: Meth_Twice)
apply (simp add: Meth_Twice Twice_Spec_def, clarsimp)
apply (rule DA_Weak)
apply (rule DA_Call)
apply (simp add: Fun_fTwice)
apply (rule DA_Let_RPrim)
apply (rule DA_If)
apply (simp_all add: DOM_def)
(*first branch*)
apply (rule DA_Call)
apply (simp only: Fun_fzeroTwice)
apply (rule DA_Null) apply (simp, simp)
(*second branch*)
apply (rule DA_Call)
apply (simp only:  Fun_foneTwice)
apply (rule DA_MatchD) apply (simp add: GETr_def) apply simp 
apply (rule DA_Letr)
(*invocation of twice*)
apply (rule ADAPT)
  (*lookup from context*)
  apply (simp add: TwiceContext_def Twice_Spec_def) apply (rule,simp,simp) defer 1 defer 1
  (*calculation of renaming*)
  apply (rule getRenamingRVar)
  apply (rule getRenamingNIL)
  (*verify that context at applications site arises from context in
    specification via the renaming*)
  apply (rule RenContextCONS,fastsimp) 
    apply (simp add: GETr_def,simp)
    apply simp
    apply (simp add: GETr_def) 
  apply (rule RenContextNIL) 
  (*the last side condition of ADAPT*)
  apply simp 
(*invocation of twice now finished*) 
apply (rule DA_Letr)
(*invocation of make*)
apply (rule DA_Make_IID)
apply (simp add: GETr_def) 
apply simp defer 1
(*invocation of make*)
apply (rule DA_Make_IID)
apply (simp add: GETr_def) 
apply simp 
apply fastsimp+
done

text {*We require the specification table at method @{text Twice} to contain entries
       which relate to the assertion @{text Twice_Spec}.*}
constdefs TwiceTable::bool
"TwiceTable == 
  (MS DIAM Twice = (\<lambda> args E h hh v p . Twice_Spec (newframe_env Nullref (fst (methtable DIAM Twice)) args E) h hh v p))"

lemma Twice_Spec_Framecorrect: "TwiceTable \<Longrightarrow> MS DIAM Twice [RNarg l_] = Twice_Spec"
apply (simp add: TwiceTable_def Meth_Twice newframe_env_def evalARGS_def)
apply (rule, rule, rule, rule, rule, simp add: Twice_Spec_def)
apply (rule DAss_Envs_same_on_U)
apply (simp_all add: DOM_def)
done
text{*The proofs use lemma @{text DAss_Envs_same_on_U}*}

text {*For a specification table satisfying TwiceSortTable, \verb|TwiceSortContext| is a good context.*}
lemma TwiceContext_good: "TwiceTable \<Longrightarrow> goodContext TwiceContext"
apply (simp add: goodContext_def TwiceContext_def, safe)
(*Twice*)
apply (simp add:  Twice_Spec_Framecorrect)
apply (rule vdm_conseq)
apply (rule Twice_DAss)
apply (simp add: TwiceContext_def)
apply clarsimp
apply (simp add: TwiceTable_def Twice_Spec_def)
apply (rule DAss_PConst)
apply (simp add: Twice_Spec_def)
done

text {*Thus, we can prove that arbitrary invocations of @{text Twice} and  @{text Sort} honour
       their entries in the specification table, in the empty VDM context.*}
theorem "\<lbrakk>TwiceTable\<rbrakk> \<Longrightarrow> \<rhd> DIAM\<bullet>Twice([RNarg x]): MS DIAM Twice [RNarg x]"
apply (rule GCInvs)
apply (erule TwiceContext_good)
apply (simp_all add: TwiceContext_def)
apply (rule, simp)
apply (insert Twice_Spec_Framecorrect, fastsimp)
done 

(*An incorrect Spec*)
constdefs Twice_WrongSpec::vdmassn
"Twice_WrongSpec == DAss {l_} 0 (emptyfinmap(l_ \<mapsto>\<^sub>f(ListET 0))) (ListET 0) 0"

text {*In order to prove the body correct we define a context which contatwice an single entry for each method.*}
constdefs  TwiceWrongContext:: vdmcontext
"TwiceWrongContext \<equiv> {(DIAM\<bullet>Twice([RNarg l_]), Twice_WrongSpec)}"

lemma Twice_DAss:
"\<lbrakk>G = TwiceWrongContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable DIAM Twice) : Twice_WrongSpec"
apply (simp add: Meth_Twice)
apply (simp add: Meth_Twice Twice_WrongSpec_def, clarsimp)
apply (rule DA_Weak)
apply (rule DA_Call)
apply (simp add: Fun_fTwice)
apply (rule DA_Let_RPrim)
apply (rule DA_If)
apply (simp_all add: DOM_def)
(*first branch*)
apply (rule DA_Call)
apply (simp only: Fun_fzeroTwice)
apply (rule DA_Null) apply (simp, simp)
(*second branch*)
apply (rule DA_Call)
apply (simp only:  Fun_foneTwice)
apply (rule DA_MatchD) apply (simp add: GETr_def) apply simp 
apply (rule DA_Letr)
(*invocation of twice*)
apply (rule ADAPT)
  (*lookup from context*)
  apply (simp add: TwiceWrongContext_def Twice_WrongSpec_def) apply (rule,simp,simp) defer 1 defer 1
  (*calculation of renaming*)
  apply (rule getRenamingRVar)
  apply (rule getRenamingNIL)
  (*verify that context at applications site arises from context in
    specification via the renaming*)
  apply (rule RenContextCONS,fastsimp) 
    apply (simp add: GETr_def,simp)
    apply simp
    apply (simp add: GETr_def) 
  apply (rule RenContextNIL) 
  (*the last side condition of ADAPT*)
  apply simp 
(*invocation of twice now finished*) 
apply (rule DA_Letr)
(*invocation of make*)
apply (rule DA_Make_IID)
apply (simp add: GETr_def) 
apply simp defer 1
(*invocation of make*)
apply (rule DA_Make_IID)
apply (simp add: GETr_def) 
apply simp
apply fastsimp+
oops
(*last remaining condition: 1 = 2*)

(*Another incorrect Spec*)
constdefs Twice_Wrong2Spec::vdmassn
"Twice_Wrong2Spec == DAss {l_} 0 (emptyfinmap(l_ \<mapsto>\<^sub>f(ListET 1))) (ListET 1) 0"

text {*In order to prove the body correct we define a context which contatwice an single entry for each method.*}
constdefs  TwiceWrong2Context:: vdmcontext
"TwiceWrong2Context \<equiv> {(DIAM\<bullet>Twice([RNarg l_]), Twice_Wrong2Spec)}"

lemma Twice_DAss:
"\<lbrakk>G = TwiceWrong2Context\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable DIAM Twice) : Twice_Wrong2Spec"
apply (simp add: Meth_Twice)
apply (simp add: Meth_Twice Twice_Wrong2Spec_def, clarsimp)
apply (rule DA_Weak)
apply (rule DA_Call)
apply (simp add: Fun_fTwice)
apply (rule DA_Let_RPrim)
apply (rule DA_If)
apply (simp_all add: DOM_def)
(*first branch*)
apply (rule DA_Call)
apply (simp only: Fun_fzeroTwice)
apply (rule DA_Null) apply (simp, simp)
(*second branch*)
apply (rule DA_Call)
apply (simp only:  Fun_foneTwice)
apply (rule DA_MatchD) apply (simp add: GETr_def) apply simp 
apply (rule DA_Letr)
(*invocation of twice*)
apply (rule ADAPT)
  (*lookup from context*)
  apply (simp add: TwiceWrong2Context_def Twice_Wrong2Spec_def) apply (rule,simp,simp) defer 1 defer 1
  (*calculation of renaming*)
  apply (rule getRenamingRVar)
  apply (rule getRenamingNIL)
  (*verify that context at applications site arises from context in
    specification via the renaming*)
  apply (rule RenContextCONS,fastsimp) 
    apply (simp add: GETr_def,simp)
    apply simp
    apply (simp add: GETr_def) 
  apply (rule RenContextNIL) 
  (*the last side condition of ADAPT*)
  apply simp 
(*invocation of twice now finished*) 
apply (rule DA_Letr)
(*invocation of make*)
apply (rule DA_Make_IID)
apply (simp add: GETr_def) 
apply simp defer 1
(*invocation of make*)
apply (rule DA_Make_IID)
apply (simp add: GETr_def) 
apply simp
apply simp
apply fastsimp+
oops
(*last remaining condition: 2 = 3+1*)

end
