theory RevDAss = DAss_rulesU:

(*DAssAdaptU currently not needed (will  contain the proof of the ADAPT lemma below*)

subsection{*Reverse function*}

text {* Camelot code:
\begin{verbatim}
type ilist = !Nil | Cons of int * ilist
let rev l acc = match l with Nil => acc
                          | Cons(h,t) => rev t (Cons(h,acc))
\end{verbatim}

Grail code:
\begin{verbatim}
method public static TreeListNIL$dia_0 rev (TreeListNIL$dia_0 l, TreeListNIL$dia_0 acc) =
 let fun f:rev(TreeListNIL$dia_0 acc, TreeListNIL$dia_0 l) =
         if l = null[TreeListNIL$dia_0]
         then f:0(acc)
         else f:1(acc, l)

     fun f:1(TreeListNIL$dia_0 acc, TreeListNIL$dia_0 l) =
      let val v3 = getfield l <int TreeListNIL$dia_0.f0>
          val v2 = getfield l <TreeListNIL$dia_0 TreeListNIL$dia_0.f1>
          val l = invokestatic <TreeListNIL$dia_0 TreeListNIL$dia_0.make (int, int, TreeListNIL$dia_0)> (1, v3, acc)
      in invokestatic <TreeListNIL$dia_0 TreeListNIL.rev (TreeListNIL$dia_0, TreeListNIL$dia_0)> (v2, l)
      end

      fun f:0(TreeListNIL$dia_0 acc) = acc
   in f:rev(acc, l)
   end
\end{verbatim}
*}

syntax b_    :: iname
       v3_   :: iname
       v2_   :: rname
       l_    :: rname 
       acc_  :: rname 

       fRev :: funame
       fzeroRev :: funame
       foneRev  :: funame
       Rev :: mname

translations
 "b_" == "(In ''b'') "
 "v3_" == "(In ''v3'') "
 "v2_" == "(RN ''v2'') "
 "l_" == "(RN ''l'') "
 "acc_" == "(RN ''acc'') "
 "fRev" == "(FN ''fRev'') "
 "fzeroRev" == "(FN ''f_zeroRev'')"
 "foneRev" == "(FN ''f_oneRev'')"
 "Rev" == "(MN ''Rev'')"

axioms Meth_Rev: 
"methtable DIAM Rev = ([RNpar l_,RNpar acc_], CALL fRev)"
lemma "methtable DIAM Rev = ([RNpar l_,RNpar acc_], CALL fRev)" by (simp add: Meth_Rev)

axioms Fun_fRev:
"funtable fRev = LET b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) l_ l_
                    IN IF b_ THEN CALL fzeroRev ELSE CALL foneRev END"
lemma "funtable fRev = LET b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) l_ l_
                    IN IF b_ THEN CALL fzeroRev ELSE CALL foneRev END"
by (simp add: Fun_fRev)

axioms Fun_foneRev:
"funtable foneRev =
       LET v3_ = GetFi l_ F0;
        rf v2_ = GetFr l_ F1;
        rf l_ =  DIAM\<bullet>Make_IID ([VALarg (IVal 1),INarg v3_, RNarg acc_])
       IN DIAM\<bullet>Rev ([RNarg v2_, RNarg l_]) END"
lemma "funtable foneRev =
       LET v3_ = GetFi l_ F0;
        rf v2_ = GetFr l_ F1;
        rf l_ =  DIAM\<bullet>Make_IID ([VALarg (IVal 1),INarg v3_, RNarg acc_])
       IN DIAM\<bullet>Rev ([RNarg v2_, RNarg l_]) END"
by (simp add: Fun_foneRev)

axioms Fun_fzeroRev:
"funtable fzeroRev = RVar acc_"
lemma  "funtable fzeroRev = RVar acc_"
by (simp add: Fun_fzeroRev)

text {*Here is what Steffen's analysis claims:
 \begin{verbatim}
  rev           : <0>, ilist[Nil(<0>)|Cons(int,#,<1>)] -> ilist[Nil(<0>)|Cons(int,#,<0>)] 
                    -> ilist[Nil(<0>)|Cons(int,#,<0>)], <0>
 \end<verbatim} *}

text {*This corresponds to the following specification, formalised from the viewpoint of the
       method body: the context (in second parameter of @{text DAss}) is the context in which
       the method body may be typed*}
constdefs Reverse_Spec::vdmassn
"Reverse_Spec == DAss {l_,acc_} 0 (emptyfinmap(l_ \<mapsto>\<^sub>f(ListET 1))(acc_ \<mapsto>\<^sub>f(ListET 0))) (ListET 0) 0"

text {*In order to prove the body correct we define a context which contains an single entry.*}
constdefs  ReverseContext:: vdmcontext
"ReverseContext \<equiv> {(DIAM\<bullet>Rev([RNarg l_,RNarg acc_]), Reverse_Spec)}"

lemma Reverse_DAss:
"\<lbrakk>G = ReverseContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable DIAM Rev) : Reverse_Spec"
apply (simp add: Meth_Rev)
apply (simp add: Meth_Rev Reverse_Spec_def, clarsimp)
apply (rule DA_Weak)
apply (rule DA_Call)
apply (simp add: Fun_fRev)
apply (rule DA_Let_RPrim)
apply (rule DA_If)
apply (simp_all add: DOM_def)
(*first branch*)
apply (rule DA_Call)
apply (simp only: Fun_fzeroRev)
apply (rule DA_RVar)
apply (simp add: GETr_def)
apply simp
(*second branch*)
apply (rule DA_Call)
apply (simp only:  Fun_foneRev)
apply (rule DA_Let_HD)
apply (rule DA_Let_TL) apply (rule GETr_Update2) apply (simp add: GETr_def) apply simp apply simp
apply (rule DA_Letr)
(*invocation of make*)
apply (rule DA_Make_IID)
apply (subgoal_tac "GETr (emptyfinmap(l_\<mapsto>\<^sub>fListET (Suc 0))(acc_\<mapsto>\<^sub>fListET 0)(v2_\<mapsto>\<^sub>fListET (Suc 0))) acc_ = GETr (emptyfinmap(l_\<mapsto>\<^sub>fListET (Suc 0))(acc_\<mapsto>\<^sub>fListET 0)) acc_ ")
apply (simp add: DOM_def GETr_def) apply (rule GETr_Update1, simp)
apply (simp add: DOM_def GETr_def)
apply (simp add: DOM_def GETr_def)
(*invocation of rev*)
apply (rule ADAPT)
  (*lookup from context*)
  apply (simp add: ReverseContext_def Reverse_Spec_def) apply (rule,simp,simp)
  apply simp apply simp
  (*calculation of renaming*)
  apply (rule getRenamingRVar)
  apply (rule getRenamingRVar)
  apply (rule getRenamingNIL)
  (*verify that context at applications site arises from context in
    specification via the renaming*)
  apply (rule RenContextCONS,fastsimp) 
    apply (rule GETr_Update2, simp add: GETr_def,simp)
    apply simp
    apply (rule GETr_Update2, simp add: GETr_def,simp) 
  apply (rule RenContextCONS,fastsimp) apply (simp add: GETr_def)
    apply simp apply (simp add: GETr_def)
  apply (rule RenContextNIL) 
  (*the last side condition of ADAPT*)
  apply simp 
(*invocation of reverse now finished*)
apply fastsimp
apply simp
apply fastsimp
apply (simp add: DOM_def GETr_def)
apply (simp add: DOM_def GETr_def)
apply fastsimp
apply fastsimp
done

text {*We require the specification table at method @{text Rev} to contain entries
       which relate to the assertion @{text Reverse_Spec}.*}
constdefs RevTable::bool
"RevTable == (MS DIAM Rev = (\<lambda> args E h hh v p . Reverse_Spec (newframe_env Nullref (fst (methtable DIAM Rev)) args E) h hh v p))"

text {*In particular, for the standrd arguments (i.e.~the formal parameters, taken
       as arguments, the specification table entry amounts to the specification
       for the body*}
lemma Reverse_Spec_Framecorrect: "RevTable \<Longrightarrow> MS DIAM Rev [RNarg l_, RNarg acc_] = Reverse_Spec"
apply (simp add: RevTable_def Meth_Rev newframe_env_def evalARGS_def)
apply (rule, rule, rule, rule, rule, simp add: Reverse_Spec_def)
apply (rule DAss_Envs_same_on_U)
apply (simp_all add: DOM_def)
apply auto 
done
text{*The proof uses lemma @{text DAss_Envs_same_on_U}*}

text {*For a specification table satisfying RevTable, \verb|ReverseContext| is a good context.*}
lemma ReverseContext_good: "RevTable \<Longrightarrow> goodContext ReverseContext"
apply (simp add: goodContext_def ReverseContext_def, rule)
apply (simp add:  Reverse_Spec_Framecorrect)
apply clarsimp
apply (rule vdm_conseq)
apply (rule Reverse_DAss)
apply (simp add: ReverseContext_def)
apply clarsimp
apply (simp add: RevTable_def Reverse_Spec_def)
apply (rule DAss_PConst)
apply (simp add: Reverse_Spec_def)
done


text {*Thus, we can prove that an arbitrary invocation of @{text Rev} honours
       its entry in the specification table, in the empty VDM context.*}
theorem "\<lbrakk>RevTable\<rbrakk> \<Longrightarrow> \<rhd> DIAM\<bullet>Rev([RNarg x, RNarg y]): MS DIAM Rev [RNarg x, RNarg y]"
apply (rule GCInvs)
apply (erule ReverseContext_good)
apply (simp_all add: ReverseContext_def)
apply (rule, simp)
apply (insert Reverse_Spec_Framecorrect, fastsimp)
done 

end
