theory Test = Semantics + Lemmas:

consts FRAME :: "(ref \<times> PARAMTYPE \<times> ARGTYPE \<times> env \<times> env) set"
inductive FRAME intros
FRAME_NIL: "(r,[],[],E,\<lparr>ienv = emptyi, renv = emptyr(self :=r)\<rparr>):FRAME"
FRAME_RN: "\<lbrakk>(r,pars,args,E,EE):FRAME; EEE=EE\<lfloor>x:=E\<lfloor>y\<rfloor>\<rfloor>\<rbrakk>
          \<Longrightarrow> (r, (RNpar x) # pars, (RNarg y) # args, E,EEE):FRAME"
FRAME_IN: "\<lbrakk>(r,pars,args,E,EE):FRAME;EEE=EE<x:=E<y>>\<rbrakk> \<Longrightarrow> (r, (INpar x) # pars, (INarg y) # args,E,EEE):FRAME"
FRAME_IV: "\<lbrakk>(r,pars,args,E,EE):FRAME;EEE=EE<x:=v>\<rbrakk> \<Longrightarrow> (r, (INpar x) # pars, VALarg (IVal v) # args,E,EEE):FRAME"

consts newFRAME::"(PARAMTYPE \<times> ARGTYPE \<times> env \<times> env) set"
inductive newFRAME intros
nFR: "(Nullref, pars,args,E, EE): FRAME
       \<Longrightarrow> (pars,args,E, EE): newFRAME"

lemma "([INpar u, INpar v], [VALarg (IVal 1),VALarg(IVal 2)], E,\<lparr>ienv = emptyi, renv = emptyr(self := Nullref)\<rparr><v:=2><u:=1>):newFRAME"
apply (rule nFR)
apply (rule FRAME.intros)+
apply simp
apply simp
done
lemma "([INpar u, INpar v], [INarg x,INarg y], E,\<lparr>ienv = emptyi, renv = emptyr(self := Nullref)\<rparr><v:=E<y>><u:=E<x>>):newFRAME"
apply (rule nFR)
apply (rule FRAME.intros)+
apply simp
apply simp
done

lemma "(r,pars,args,E,EE):FRAME \<Longrightarrow> length pars = length args"
apply (erule FRAME.induct)
apply simp
apply fastsimp+
done

subsubsection{*Renaming*}
typedecl Type
types Context = "(rname \<leadsto>\<^sub>f Type)"
constdefs GETr :: "Context \<Rightarrow> rname \<Rightarrow> (Type option)"
"GETr G x \<equiv> fmap_lookup G x"

types CONTEXT = "(rname \<times> Type) list"
consts gett ::"CONTEXT \<Rightarrow> rname \<Rightarrow> Type option"
primrec
"gett [] x = None"
"gett (h # t) x = (if x=(fst h) then Some(snd h) else gett t x)"
(*
consts x :: rname
       y :: rname
       A :: Type
       B :: Type
       C :: Type
lemma "gett [(x,A),(y,B),(x,C)] y = Some C"
apply simp
*)

constdefs DOM::"CONTEXT \<Rightarrow> (rname set)"
"DOM C == {x . \<exists> T . gett C x = Some T}"

lemma "gett C x = Some T \<longrightarrow> x : DOM C"
by (simp add: DOM_def)

lemma "finite (DOM C)"
apply (induct C)
apply (simp add: DOM_def)
apply (subgoal_tac "DOM (a # list) = {fst a} \<union> DOM list")
apply simp 
apply (simp add: DOM_def)
apply auto
done

constdefs RenameCond1::"(rname set) \<Rightarrow> (rname \<leadsto>\<^sub>f rname) \<Rightarrow> (rname set) \<Rightarrow> bool"
"RenameCond1 U f UU == (\<forall> x . x:U \<longrightarrow> (\<exists> y. fmap_lookup f x = Some y \<and> y:UU))"

constdefs RenameCond2::"(rname set) \<Rightarrow> (rname \<leadsto>\<^sub>f rname) \<Rightarrow> (rname set) \<Rightarrow> bool"
"RenameCond2 U f UU == (\<forall> y . y:UU \<longrightarrow> (\<exists> x. fmap_lookup f x = Some y \<and> x:U))"

constdefs RenameCond3::"(rname set) \<Rightarrow> (rname \<leadsto>\<^sub>f rname) \<Rightarrow> (rname set) \<Rightarrow> env \<Rightarrow> env \<Rightarrow> CONTEXT \<Rightarrow> CONTEXT \<Rightarrow> bool"
"RenameCond3 U f UU E EE G GG == (\<forall> x y . (x:U \<and> fmap_lookup f x = Some y) \<longrightarrow> (y : UU \<and> E\<lfloor>x\<rfloor> = EE\<lfloor>y\<rfloor> \<and> gett G x = gett GG y))"

constdefs RenameCond4::"(rname set) \<Rightarrow> (rname \<leadsto>\<^sub>f rname) \<Rightarrow> (rname set) \<Rightarrow> bool"
"RenameCond4 U f UU == (\<forall> x1 x2 y1 y2 . (x1:U \<and> x2:U \<and> x1\<noteq>x2 \<and> fmap_lookup f x1 = y1 \<and> fmap_lookup f x2 = y2) \<longrightarrow> y1 \<noteq> y2)"

constdefs RenameCond5:: "rname list \<Rightarrow> bool"
"RenameCond5 P == (\<forall> x . x:set P \<longrightarrow> x \<noteq> self)"

consts REN::"(ARGTYPE \<times> PARAMTYPE \<times> (rname \<leadsto>\<^sub>f rname)) set"
inductive REN intros
REN_NIL: "([], [], emptyfinmap):REN"
REN_IN: "(args, pars, f):REN \<Longrightarrow> ((INarg x) # args, (INpar y) # pars, f):REN"
REN_RN: "\<lbrakk>(args, pars, f):REN\<rbrakk>\<Longrightarrow> ((RNarg x) # args, (RNpar y) # pars, f(x\<mapsto>\<^sub>fy)):REN"

consts ParList2RnameList:: "PARAMTYPE \<Rightarrow> rname list"
primrec
"ParList2RnameList [] = []"
"ParList2RnameList (h # t) = (case h of 
                                (INpar x) \<Rightarrow> (ParList2RnameList t)
                              | (RNpar x) \<Rightarrow> x#(ParList2RnameList t))"

lemma PL2RL_p1:"y \<in> set (ParList2RnameList pars) \<Longrightarrow> RNpar y : set pars"
by (induct pars, auto, case_tac a, auto)

consts ArgList2RnameList:: "ARGTYPE \<Rightarrow> rname list"
primrec
"ArgList2RnameList [] = []"
"ArgList2RnameList (h # t) = (case h of 
                                (INarg x) \<Rightarrow> (ArgList2RnameList t)
                              | (RNarg x) \<Rightarrow> x#(ArgList2RnameList t)
                              | (VALarg v) \<Rightarrow> (ArgList2RnameList t))"

lemma AL2RL_p1:"y \<in> set (ArgList2RnameList args) \<Longrightarrow> RNarg y : set args"
by (induct args, auto, case_tac a, auto)

lemma REN_property1[rule_format]:
"\<lbrakk>(A, P, f) \<in> REN\<rbrakk> \<Longrightarrow> distinct A \<longrightarrow>
 RenameCond1 (set (ArgList2RnameList A)) f (set (ParList2RnameList P))"
apply (erule REN.induct)
apply (simp add: RenameCond1_def)
apply (simp add: RenameCond1_def)
apply (simp add: RenameCond1_def, clarsimp)
apply (erule_tac x=xa in allE, clarsimp)
apply (rule_tac x=ya in exI, simp)
apply (subgoal_tac "xa \<noteq> x")
apply (simp add: FMAPlookup2)
apply (drule AL2RL_p1, fastsimp)
done

lemma REN_property2[rule_format]:
"\<lbrakk>(A, P, f) \<in> REN\<rbrakk> \<Longrightarrow> distinct A \<longrightarrow>
 RenameCond2 (set (ArgList2RnameList A)) f (set (ParList2RnameList P))"
apply (simp add: RenameCond2_def)
apply (erule REN.induct)
apply simp
apply simp
apply clarsimp
apply (rule, clarsimp)
apply (rule_tac x=x in exI, clarsimp)
apply clarsimp
apply (erule_tac x=ya in allE, clarsimp)
apply (rule_tac x=xa in exI, clarsimp)
apply (subgoal_tac "xa \<noteq> x")
apply (simp add: FMAPlookup2)
apply (drule AL2RL_p1, fastsimp)
done

lemma REN_property4a:
"\<lbrakk>(A, P, f) \<in> REN\<rbrakk> \<Longrightarrow> distinct P \<longrightarrow> (\<forall> x y . fmap_lookup f x = Some y \<longrightarrow> x:set (ArgList2RnameList A) \<and> y :set (ParList2RnameList P))"
apply (erule REN.induct)
apply simp
apply simp
apply clarsimp
apply (rule, clarsimp)
apply (case_tac "xa=x", simp)
apply (erule_tac x=xa in allE, erule_tac x=ya in allE, erule impE)
apply (subgoal_tac "fmap_lookup (f(x\<mapsto>\<^sub>fy)) xa = fmap_lookup f xa", clarsimp) apply (rule FMAPlookup1,fast)
apply simp
apply (case_tac "xa=x", simp)
apply (erule_tac x=xa in allE, erule_tac x=ya in allE, erule impE)
apply (subgoal_tac "fmap_lookup (f(x\<mapsto>\<^sub>fy)) xa = fmap_lookup f xa", clarsimp) apply (rule FMAPlookup1,fast)
apply simp
done

(*declare GETr_def[simp]*)
declare FMAPlookup1[simp]

lemma REN_property4[rule_format]:
"\<lbrakk>(A, P, f) \<in> REN\<rbrakk> \<Longrightarrow> distinct P \<longrightarrow>
 RenameCond4 (set (ArgList2RnameList A)) f (set (ParList2RnameList P))"
apply (simp add: RenameCond4_def)
apply (erule REN.induct)
apply simp
apply simp
apply clarsimp
apply (case_tac "x1=x", clarsimp)
(*1*) apply (case_tac "x2=x")
  (*1*) apply clarsimp
  (*2*) apply clarsimp
    apply (subgoal_tac "fmap_lookup f x2 = Some y")
    prefer 2 apply simp 
    apply (drule REN_property4a, erule impE, simp) 
    apply (rotate_tac -1, erule_tac x=x2 in allE, rotate_tac -1,erule_tac x=y in allE, erule impE, simp)
    apply (erule conjE)
    apply (drule PL2RL_p1, simp)
(*2*) apply (case_tac "x2=x")
  (*1*) apply clarsimp
        apply (drule REN_property4a, clarsimp) 
        apply (rotate_tac -1, erule_tac x=x1 in allE, rotate_tac -1,erule_tac x=y in allE, clarsimp)
        apply (drule PL2RL_p1, simp)
  (*2*) apply clarsimp 
done

lemma "(ARGS, PARS,f):REN \<Longrightarrow> distinct PARS \<longrightarrow> distinct ARGS \<longrightarrow> (\<forall> E EE. (Nullref,PARS,ARGS,E,EE):FRAME \<longrightarrow>
(\<forall> x. x : fmap_dom f \<longrightarrow> (\<forall> y . (fmap_lookup f x = Some y) \<longrightarrow> E\<lfloor>x\<rfloor> = EE\<lfloor>y\<rfloor>)))"
apply (erule REN.induct)
apply simp
apply clarsimp 
  apply (erule FRAME.elims, simp_all)
apply clarsimp
  apply (erule FRAME.elims, simp_all, clarsimp)
  apply (erule_tac x=Ea in allE)
  apply (erule_tac x=EEa in allE) apply (simp)
  apply (erule_tac x=xa in allE) apply simp
  apply (subgoal_tac "\<exists> z . fmap_lookup f xa = Some z", clarsimp)
  prefer 2 apply (simp add: fmap_dom_def dom_def fmap_lookup_def)
  apply (drule REN_property4a, simp)
  apply (erule_tac x=xa in allE, clarsimp)
    apply (subgoal_tac "(fmap_lookup (f(ya \<mapsto>\<^sub>f xb)) xa) = (fmap_lookup f xa)", clarsimp)
    apply (subgoal_tac "yb \<noteq> xb", simp)
    apply (drule PL2RL_p1) apply fast
  apply (subgoal_tac "xa \<noteq> ya", clarsimp) 
    apply (drule AL2RL_p1) apply fast
done
lemma "(ARGS, PARS,f):REN \<Longrightarrow> distinct PARS \<longrightarrow> distinct (ArgList2RnameList ARGS) \<longrightarrow> (\<forall> E EE. (Nullref,PARS,ARGS,E,EE):FRAME \<longrightarrow>
(\<forall> x. x : fmap_dom f \<longrightarrow> (\<forall> y . (fmap_lookup f x = Some y) \<longrightarrow> E\<lfloor>x\<rfloor> = EE\<lfloor>y\<rfloor>)))"
apply (erule REN.induct)
apply simp
apply clarsimp 
  apply (erule FRAME.elims, simp_all)
apply clarsimp
  apply (erule FRAME.elims, simp_all, clarsimp)
  apply (erule_tac x=Ea in allE)
  apply (erule_tac x=EEa in allE, simp) 
  apply (erule_tac x=xa in allE, simp)
  apply (subgoal_tac "\<exists> z . fmap_lookup f xa = Some z", clarsimp)
  prefer 2 apply (simp add: fmap_dom_def dom_def fmap_lookup_def)
  apply (drule REN_property4a, simp)
  apply (erule_tac x=xa in allE, clarsimp)
  apply (drule PL2RL_p1)
    apply (subgoal_tac "(fmap_lookup (f(ya \<mapsto>\<^sub>f xb)) xa) = (fmap_lookup f xa)", clarsimp)
    apply (subgoal_tac "yb \<noteq> xb", simp)
    apply fast 
  apply (subgoal_tac "xa \<noteq> ya", clarsimp) apply fast
done
done

end
