(* 				 
   File:	$RCSfile: Lemmas.thy,v $
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: Lemmas.thy,v 1.1.2.1 2005/07/18 21:51:13 a1hloidl Exp $

   Useful lemmas mainly over components of FunMachine.
   Most of them to be used by simplifier.
*)

header {* Simplification lemmas *}
(*<*)
theory Lemmas = Semantics:
(*>*)

text {* 
The following lemmas provide additional knowledge about the machine model and
are added to the simplifier so that we can make good use of Isabelle's default
simplification mechanism. Most of the lemmas in here are rather trivial, such
as non-interference of I- and R-environment etc.
*}

lemma SubsetTransitive: "\<lbrakk>R \<subseteq> S; S \<subseteq> T\<rbrakk> \<Longrightarrow> R \<subseteq> T" (*<*)by fast(*>*)

subsection {* Lemmas over environments *}

lemma ivarUpdSame [simp]: "(E<x:=v>)<x> = v"
(*<*)by (simp add: ivarupdate_def)(*>*)

lemma ivarUpdOther [simp]: "x \<noteq> y \<Longrightarrow> (E<y:=v>)<x> = E<x>"
(*<*)by (simp add: ivarupdate_def)(*>*)

lemma rvarUpdSame [simp]: "(E\<lfloor>x:=v\<rfloor>)\<lfloor>x\<rfloor> = v"
(*<*)by (simp add: rvarupdate_def)(*>*)

lemma rvarUpdOther [simp]: "x \<noteq> y \<Longrightarrow> (E\<lfloor>y:=v\<rfloor>)\<lfloor>x\<rfloor> = E\<lfloor>x\<rfloor>"
(*<*)by (simp add: rvarupdate_def)(*>*)

lemma rvarIupdTriv [simp]: "(E<x:=v>)\<lfloor>y\<rfloor> = E\<lfloor>y\<rfloor>"
(*<*)by (simp add: ivarupdate_def)(*>*)

lemma ivarRupdTriv [simp]: "(E\<lfloor>x:=v\<rfloor>)<y> = E<y>"
(*<*)by (simp add: rvarupdate_def)(*>*)

lemma ivarUpdIdemp [simp]: "(E<y:=v>)<y:=w> = E<y:=w>"
(*<*)by (simp add: ivarupdate_def)(*>*)

lemma rvarUpdIdemp [simp]: "(E\<lfloor>y:=v\<rfloor>)\<lfloor>y:=w\<rfloor> = E\<lfloor>y:=w\<rfloor>"
(*<*)by (simp add: rvarupdate_def)(*>*)

lemma Iupd[simp]: "\<lbrakk>x \<noteq> y\<rbrakk> \<Longrightarrow> E<x:=v><y> = E<y>"
(*<*)by (insert ivarupdate_def, fastsimp)(*>*)

lemma Rupd[simp]: "\<lbrakk>x \<noteq> y\<rbrakk> \<Longrightarrow> E\<lfloor>x:=v\<rfloor>\<lfloor>y\<rfloor> = E\<lfloor>y\<rfloor>"
(*<*)by (insert rvarupdate_def, fastsimp)(*>*)

subsection {* Lemmas over heaps *}
lemma ifldUpdTriv [simp]: "h<a\<bullet>F:=i> = h\<lparr>iheap := (iheap h)(F := (iheap h F)(a := i))\<rparr>"
(*<*)by (simp add: obj_ifieldupdate_def)(*>*)

lemma rfldUpdTriv [simp]: "h\<lfloor>a\<diamondsuit>F:=r\<rfloor> = h\<lparr>rheap := (rheap h)(F := (rheap h F)(a := r))\<rparr>"
(*<*)by (simp add: obj_rfieldupdate_def)(*>*)

lemma statUpdTriv [simp]: "h\<lbrace>c\<struct>F:=r\<rbrace> = h\<lparr>sheap := (sheap h)(c := (sheap h c)(F := r))\<rparr>"
(*<*)by (simp add: stat_update_def)(*>*)

lemma ifldUpdOTriv [simp]: "heap.oheap h<a\<bullet>f:=n> = heap.oheap h"
(*<*)by simp (*>*)

lemma rfldUpdOTriv [simp]: "heap.oheap h\<lfloor>a\<diamondsuit>f:=r\<rfloor> = heap.oheap h"
(*<*)by simp (*>*)

lemma statUpdOTriv [simp]: "heap.oheap h\<lbrace>c\<struct>f:=r\<rbrace> = heap.oheap h"
(*<*)by simp (*>*)

lemma ifldUpdSame[simp]: "h<a\<bullet>f:=n><a\<bullet>f> = n"
(*<*)by simp (*>*)

lemma rfldUpdSame[simp]: "h\<lfloor>a\<diamondsuit>f:=r\<rfloor>\<lfloor>a\<diamondsuit>f\<rfloor> = r"
(*<*)by simp (*>*)

lemma statUpdSame[simp]: "h\<lbrace>c\<struct>f:=r\<rbrace>\<lbrace>c\<struct>f\<rbrace> = r"
(*<*)by simp (*>*)

lemma ifldUpdOther[simp]: "f \<noteq> f' \<Longrightarrow> h<a\<bullet>f:=n><a\<bullet>f'> = h<a\<bullet>f'>"
(*<*)by (simp, rule impI, simp)(*>*)

lemma rfldUpdOther[simp]: "f \<noteq> f' \<Longrightarrow> h\<lfloor>a\<diamondsuit>f:=r\<rfloor>\<lfloor>a\<diamondsuit>f'\<rfloor> = h\<lfloor>a\<diamondsuit>f'\<rfloor>"
(*<*)by (simp, rule impI, simp) (*>*)

lemma statUpdOther[simp]: "f \<noteq> f' \<Longrightarrow> h\<lbrace>c\<struct>f:=r\<rbrace>\<lbrace>c\<struct>f'\<rbrace> = h\<lbrace>c\<struct>f'\<rbrace>"
(*<*)by (simp, rule impI, simp) (*>*)

lemma ifldUpdElsewhere[simp]: "a \<noteq> a' \<Longrightarrow> h<a\<bullet>f:=n><a'\<bullet>f> = h<a'\<bullet>f>"
(*<*)by simp (*>*)

lemma rfldUpdElsewhere[simp]: "a \<noteq> a' \<Longrightarrow> h\<lfloor>a\<diamondsuit>f:=r\<rfloor>\<lfloor>a'\<diamondsuit>f\<rfloor> = h\<lfloor>a'\<diamondsuit>f\<rfloor>"
(*<*)by simp (*>*)

lemma statUpdElsewhere[simp]: "c \<noteq> c' \<Longrightarrow> h\<lbrace>c\<struct>f:=r\<rbrace>\<lbrace>c'\<struct>f\<rbrace> = h\<lbrace>c'\<struct>f\<rbrace>"
(*<*)by clarsimp (*>*)


lemma FreshlocDom[simp]: "freshloc (Dom h) \<notin> Dom h"
(*<*)by (rule freshloc, fast)(*>*)

subsection {* Lemmas for representation of booleans *}
lemma ifElimT[simp]: "((if t then 1 else 0) = (1:: int)) = t"
(*<*)by (case_tac t, clarsimp+)(*>*)

lemma ifElimF[simp]: "((if t then 1 else 0) = (0:: int)) = (\<not> t)"
(*<*)by (case_tac t, clarsimp+)(*>*)

(* Nominee for the most pathetic proof within MRG *)
lemma fun_same_upd: "\<And> f f' x . [| ((fun_upd f x v) = (fun_upd f' x v)) |] ==> \<forall> y. x\<noteq>y --> f y = f' y"
(*<*)
apply clarify
apply (subgoal_tac "\<forall> z. (fun_upd f x v) z = (fun_upd f' x v) z")
  prefer 2
  (* prove subgoal *)
  apply clarsimp
  apply (tactic {* all_tac *})
  (* use subgoal *)
  apply (erule_tac x=y in allE)
  apply (subgoal_tac "(fun_upd f x v) y = f y")
   prefer 2
   (* prove subgoal *)
   apply (rule fun_upd_other)
   apply simp
   defer 1
   apply (tactic {* all_tac *})
   (* use subgoal *)
   apply (simp)
   apply (subgoal_tac "(fun_upd f' x v) y = f' y")
    prefer 2
    (* prove subgoal *)
    apply (rule fun_upd_other)
    apply clarsimp
    apply (tactic {* all_tac *})
    (* use subgoal *)
    apply clarsimp
   apply clarsimp   
done
(*>*)

(* useful in a backward proof, if fun_upds are in the assumption set already *)
lemma fun_same_upd_bwd: "[| ((fun_upd f x v) = (fun_upd f' x v)) ; x\<noteq>y |] ==> f y = f' y"
(*<*)
  apply (subgoal_tac "\<forall> z. (fun_upd f x v) z = (fun_upd f' x v) z")
  prefer 2
  (* prove subgoal *)
  apply clarsimp
  apply (tactic {* all_tac *})
  (* use subgoal *)
  apply (erule_tac x=y in allE)
  (* subgoal in the form of the consequent of fun_upd_other *)
  apply (subgoal_tac "(fun_upd f x v) y = f y")
   prefer 2
   (* prove subgoal *)
   apply (rule fun_upd_other)
   apply simp
   defer 1
   apply (tactic {* all_tac *})
   (* use subgoal *)
   apply (simp)
  (* subgoal in the form of the consequent of fun_upd_other *)
   apply (subgoal_tac "(fun_upd f' x v) y = f' y")
    prefer 2
    (* prove subgoal *)
    apply (rule fun_upd_other)
    apply clarsimp
    apply (tactic {* all_tac *})
    (* use subgoal *)
    apply clarsimp
   apply clarsimp   
done
(*>*)

(* fun_upd_other applied to environments *)
lemma env_upd_otherI[simp]: "z~=x ==> (E<x:=y>)<z> = E<z>"
(*<*)by simp(*>*)

lemma env_upd_otherR[simp]: "z~=x ==> (E\<lfloor>x:=y\<rfloor>)\<lfloor>z\<rfloor> = E\<lfloor>z\<rfloor>"
(*<*)by simp(*>*)

(* useful for reasoning over environments updated in invoke, i.e. E\<lfloor>self:=Ref a\<rfloor> etc *)
lemma env_upd_same_bwd: "\<And> E E' x y v. \<lbrakk> E\<lfloor>x:=v\<rfloor> = E'\<lfloor>x:=v\<rfloor> ; x \<noteq> y \<rbrakk> \<Longrightarrow> E\<lfloor>y\<rfloor>=E'\<lfloor>y\<rfloor>"
(*<*)
apply (subgoal_tac "\<forall> z. (E\<lfloor>x := v\<rfloor>)\<lfloor>z\<rfloor> = (E'\<lfloor>x := v\<rfloor>)\<lfloor>z\<rfloor>")
  prefer 2
  (* prove subgoal *)
  apply clarsimp
  apply (tactic {* all_tac *})
  (* use subgoal *)
  apply (erule_tac x=y in allE)
  (* subgoal in the form of the consequent of rvarUpdOther *)
  apply (subgoal_tac "E\<lfloor>x := v\<rfloor>\<lfloor>y\<rfloor> = E\<lfloor>y\<rfloor>")
  apply (subgoal_tac "E'\<lfloor>x := v\<rfloor>\<lfloor>y\<rfloor> = E'\<lfloor>y\<rfloor>")
   apply (simp)
  (* now prove the 2 subgoals above; in each need to apply rvarUpdOther as main step *)
  (* 1st subgoal *)
  apply (rule env_upd_otherR)
  apply clarsimp
  (* 2nd subgoal (same as above) *)
  apply (rule env_upd_otherR)
  apply clarsimp
done
(*>*)

subsection {* Extensional environment equality *}
lemma funE: "f = f' \<Longrightarrow> \<forall> x . f x = f' x"
(*<*)by (insert expand_fun_eq, simp)(*>*)

lemma funI: "\<forall> x . f x = f' x \<Longrightarrow> f = f' "
(*<*)by (simp add:  expand_fun_eq)(*>*)

lemma EE: "(E::env) = (E'::env) ==> env.ienv E = env.ienv E' \<and> env.renv E = env.renv E'"
(*<*)by simp(*>*)

lemma EI: "\<lbrakk> env.ienv E = env.ienv E' ; env.renv E = env.renv E' \<rbrakk> \<Longrightarrow> (E::env) = (E'::env)"
(*<*)by simp(*>*)

lemma IEI: "\<lbrakk> (\<forall> n. E<n> = E'<n>) \<rbrakk> \<Longrightarrow> env.ienv E = env.ienv E'"
(*<*)by (erule funI)(*>*)

lemma REI: "\<lbrakk> (\<forall> x. E\<lfloor>x\<rfloor> = E'\<lfloor>x\<rfloor>) \<rbrakk> \<Longrightarrow> env.renv E = env.renv E'"
(*<*)by (erule funI)(*>*)

lemma IEE: "env.ienv E = env.ienv E' \<Longrightarrow> \<forall> n. E<n> = E'<n>"
(*<*)by simp(*>*)

(*<*)lemmas IE_ext = IEE(*>*)
lemma REE: "env.renv E = env.renv E' \<Longrightarrow> \<forall> x. E\<lfloor>x\<rfloor> = E'\<lfloor>x\<rfloor>"
(*<*)by simp(*>*)

(*<*)lemmas RE_ext = REE(*>*)
lemma E_ext: "\<lbrakk> (\<forall> n. E<n> = E'<n>) ; (\<forall> x. E\<lfloor>x\<rfloor> = E'\<lfloor>x\<rfloor>)  \<rbrakk> \<Longrightarrow> (E::env) = (E'::env)"
(*<*)
apply (rule EI)
apply (rule IEI) apply clarsimp
apply (rule REI) apply clarsimp
done
(*>*)

(*
subsection {* Lemmas on frames *}

lemma newframeSelf[simp]: "self \<notin> set params \<Longrightarrow> (newframe_env slf params args E)\<lfloor>self\<rfloor> = slf"
apply (induct params)
apply (simp add: newframe_env_def emptyr_def makeFrame_def, auto)
done

lemma newframeParam[simp]: "(newframe_env slf prm)\<lfloor>param\<rfloor> = prm"
apply (simp add: newframe_env_def emptyr_def)
done

lemma newframeOther[simp]: "[| x \<noteq> self ; x \<noteq> param |] ==> (newframe_env r slf)\<lfloor>x\<rfloor> = Nullref"
apply (simp add: newframe_env_def emptyr_def)
done
*)

(* before the switch to multiparams we had this:
lemma newframeSelf[simp]: "(newframe_env slf prm)\<lfloor>self\<rfloor> = slf"
apply (simp add: newframe_env_def emptyr_def constdistinct)
done

lemma newframeParam[simp]: "(newframe_env slf prm)\<lfloor>param\<rfloor> = prm"
apply (simp add: newframe_env_def emptyr_def)
done

lemma newframeOther[simp]: "[| x \<noteq> self ; x \<noteq> param |] ==> (newframe_env r slf)\<lfloor>x\<rfloor> = Nullref"
apply (simp add: newframe_env_def emptyr_def)
done
*)

subsection {*Lemmas about the same predicate over heaps*}
lemma SameOHTriv[simp]: "sameOH (Dom h) h h" (*<*)by (simp add: sameOH_def)(*>*)

lemma sameOHCommutative: "sameOH X h hh \<Longrightarrow> sameOH X hh h"
(*<*)by (simp add: sameOH_def)(*>*)

lemma SameOHSubset: "\<lbrakk>sameOH X h hh; Y \<subseteq> X\<rbrakk> \<Longrightarrow> sameOH Y h hh" (*<*)by (simp add: sameOH_def, fast)(*>*)

lemma SameOHTransitive: "\<lbrakk>sameOH X h h1; sameOH Y h1 h2; X \<subseteq> Y\<rbrakk> \<Longrightarrow> sameOH X h h2"
(*<*)by (simp add: sameOH_def , fast)(*>*)

lemma HpMinusSameOH: "\<lbrakk>HpMinus h l hh; X \<subseteq> Dom h; l \<notin> X\<rbrakk> \<Longrightarrow> sameOH X h hh"
(*<*)
apply (simp add: HpMinus_def sameOH_def same_def)
apply clarsimp
apply (erule_tac x=la in allE, erule impE)
apply fast
apply simp
done
(*>*)

lemma SameOHNewObj:"\<lbrakk>X \<subseteq> Dom h; l \<notin> Dom h\<rbrakk> \<Longrightarrow> sameOH X h (newObj h l E c [] [])"
(*<*)
apply (simp add: newObj_def)
apply (rule sameOHCommutative)
apply (rule HpMinusSameOH)
defer 1
apply fastsimp
apply (subgoal_tac "l \<notin> X", assumption) apply fast
apply (simp add: HpMinus_def sameOH_def same_def)
apply clarsimp
apply (subgoal_tac "la \<noteq> l", simp add: FMAPlookup1)
apply fast
done
(*>*)

lemma SameOHImpliesDomsubset: "sameOH (Dom h) h hh \<Longrightarrow> (Dom h) \<subseteq> (Dom hh)"
(*<*)by (simp add: sameOH_def fmap_lookup_def fmap_dom_def,fastsimp)(*>*)

text {*Similar lemmas hold for @{text same}.*}
lemma SameTriv[simp]: "same (Dom h) h h" (*<*)by (simp add: same_def)(*>*)

lemma sameCommutative: "same X h hh \<Longrightarrow> same X hh h"
(*<*)
by (subgoal_tac "sameOH X hh h", simp add: same_def, rule sameOHCommutative, simp add: same_def)(*>*)

lemma SameSubset: "\<lbrakk>same X h hh; Y \<subseteq> X\<rbrakk> \<Longrightarrow> same Y h hh" 
(*<*)
by (subgoal_tac "sameOH Y h hh", simp_all add: same_def, clarsimp,erule SameOHSubset, assumption)(*>*)

lemma SameTransitive: "\<lbrakk>same X h h1; same Y h1 h2; X \<subseteq> Y\<rbrakk> \<Longrightarrow> same X h h2"
(*<*)by (simp add: same_def, clarsimp, erule SameOHTransitive, assumption+)(*>*)

lemma HpMinusSame: "\<lbrakk>HpMinus h l hh; X \<subseteq> Dom h; l \<notin> X\<rbrakk> \<Longrightarrow> same X h hh"
(*<*)by (simp add: same_def HpMinusSameOH, simp add: HpMinus_def same_def)(*>*)

lemma SameNewObj:"\<lbrakk>X \<subseteq> Dom h; l \<notin> Dom h\<rbrakk> \<Longrightarrow> same X h (newObj h l E c [] [])"
(*<*)by (simp add: same_def SameOHNewObj, simp add: newObj_def)(*>*)

lemma SameImpliesDomsubset: "same (Dom h) h hh \<Longrightarrow> (Dom h) \<subseteq> (Dom hh)"
(*<*)by (simp add: same_def SameOHImpliesDomsubset)(*>*)
(*<*)
end
(*>*)
