theory NILList = VDMderivedPC:

syntax DIAM :: cname
       DOLLAR_F :: rfldname
       DOLLAR_N :: rfldname
       DOLLAR :: ifldname
       F0 :: ifldname
       F1 :: rfldname
       F2 :: rfldname

       Free :: mname
       Make_IID  :: mname
       Fill_DIID :: mname

       Alloc :: mname
       freelist_ :: rname
       alloc_b :: iname
       Alloc_q :: funame
       alloc_tl :: rname

       tag_ :: iname
       x_   :: rname 
       v0_  :: iname  
       v1_  :: rname 

translations
 "DIAM" == "(CN ''dia_0'') "
 "DOLLAR_F" == "(RFN ''$f'')"
 "DOLLAR_N" == "(RFN ''$n'')"
 "DOLLAR" == "(IFN ''$'')"
 "F0" == "(IFN ''f0'')"
 "F1" == "(RFN ''f1'')"
 "F2" == "(RFN ''f2'')"

 "Free" == "(MN ''Free'')"
 "Make_IID" == "(MN ''Make_IID'')"
 "Fill_DIID" == "(MN ''Fill_DIID'')"

 "tag_" == "(In ''tag'') "
 "x_" == "(RN ''?x'') "
 "v0_" == "(In ''v0'') "
 "v1_" == "(RN ''v1'') "

 "Alloc " == "(MN ''alloc'')"
 "freelist_ " == "(RN ''freelist'')"
 "alloc_b " == "(In ''b'')"
 "Alloc_q " == "(FN ''q'')"
 "alloc_tl " == "(RN ''tl'')"

axioms Meth_Make_IID:
"methtable DIAM Make_IID = ([INpar tag_, INpar v0_, RNpar v1_],
                            LET rf x_ = DIAM\<bullet>Alloc([])
                            IN DIAM\<bullet>Fill_DIID ([RNarg x_, INarg tag_, INarg v0_, RNarg v1_]) END)"

axioms Meth_Fill_DIID:
"methtable DIAM Fill_DIID = ([RNpar x_, INpar tag_, INpar v0_, RNpar v1_],
                             LET _ = PutFi x_ DOLLAR tag_;
                                 _ = PutFi x_ F0 v0_;
                                 _ = PutFr x_ F1 v1_
                             IN RVar x_ END)"

axioms Meth_Alloc:
"methtable DIAM Alloc = ([], LET rf freelist_ = DIAM\<struct>DOLLAR_F;
                                 alloc_b = RPrimop (\<lambda> x y . if x = Nullref then 1 else 0) freelist_ freelist_
                             IN IF alloc_b THEN NEW <DIAM> ([],[]) ELSE CALL Alloc_q END)"
(*Isabelle problem: why must we not use the pretty GetStat/PutStat syntax in the lemma 
  ''Illegal reference to implicit structure #1''??*)
lemma 
"methtable DIAM Alloc = ([], LET rf freelist_ = GetStat DIAM DOLLAR_F;
                                      alloc_b = RPrimop (\<lambda> x y . if x = Nullref then 1 else 0) freelist_ freelist_
                                   IN IF alloc_b THEN NEW <DIAM> ([],[]) ELSE CALL Alloc_q END)"
by (simp add: Meth_Alloc)

axioms Fun_AllocQ:
"funtable Alloc_q = LET rf alloc_tl = freelist_\<diamondsuit>DOLLAR_N;
                             _ = DIAM\<struct>DOLLAR_F := alloc_tl
                    IN RVar freelist_ END"
lemma "funtable Alloc_q = LET rf alloc_tl = freelist_\<diamondsuit>DOLLAR_N;
                             _ = DIAM\<struct>DOLLAR_F := alloc_tl
                    IN RVar freelist_ END"
by (simp add: Fun_AllocQ)

(*representation predicates*)
consts mLIST::"(nat \<times> ref \<times> (locn set) \<times> heap) set"
inductive mLIST intros
mLIST_NIL: "(0,Nullref,{},h) : mLIST"
mLIST_CONS:"\<lbrakk>h@@a = Some DIAM; h<a\<bullet>DOLLAR> \<noteq> 2; h\<lfloor>a\<diamondsuit>F1\<rfloor> = r; a \<notin> X; (n,r,X,h):mLIST\<rbrakk>
          \<Longrightarrow> (Suc n, Ref a, X \<union> {a}, h): mLIST"

lemma mLIST_Unique[rule_format]: "\<forall> r F h. (N, r, F, h) \<in> mLIST \<longrightarrow> (\<forall> M FF . (M, r, FF, h) \<in> mLIST \<longrightarrow> (N=M \<and> F=FF))"
apply clarsimp
apply (induct N)
apply (erule mLIST.elims, simp_all)
apply (erule mLIST.elims, simp_all)
apply (erule mLIST.elims, simp_all)
apply (erule mLIST.elims, simp_all)
apply clarsimp
apply fast
done

lemma mLIST_Preserved[rule_format]:
"\<forall> r R h . (n, r, R, h) \<in> mLIST \<longrightarrow> (\<forall> h1. (\<forall> l. l \<in> R \<longrightarrow> sameOH {l} h h1) \<longrightarrow> (n, r, R, h1) \<in> mLIST)"
apply safe
apply (induct n)
apply (erule mLIST.elims, safe)
apply (rule mLIST_NIL)
apply (erule mLIST.elims, safe)
apply (rule mLIST_CONS) 
apply (erule thin_rl) apply (simp add: sameOH_def)
apply (erule thin_rl) apply (simp add: sameOH_def)
apply (erule thin_rl) apply (simp add: sameOH_def)
apply (erule thin_rl) apply (simp add: sameOH_def)
apply (subgoal_tac "(na, ha\<lfloor>a\<diamondsuit>F1\<rfloor>, X, h1) \<in> mLIST")
  apply (erule thin_rl)
  apply (subgoal_tac "h1\<lfloor>a\<diamondsuit>F1\<rfloor> = ha\<lfloor>a\<diamondsuit>F1\<rfloor>", clarsimp)
  apply (erule_tac x=a in allE, clarsimp, simp add: sameOH_def)
apply (subgoal_tac "\<forall>l. l \<in> X \<longrightarrow> sameOH {l} ha h1")
apply (rotate_tac 1, erule thin_rl)
apply fast
apply fast
done

consts FL::"(nat \<times> ref \<times> (locn set) \<times> heap) set"
inductive FL intros
FL_NIL: "(0, Nullref, {},h) : FL"
FL_SUC: "\<lbrakk>h@@a = Some DIAM; a \<notin> X; (n, h\<lfloor>a\<diamondsuit>DOLLAR_N\<rfloor>,X,h):FL\<rbrakk>
        \<Longrightarrow> (Suc n, Ref a,  X \<union> {a}, h) : FL"

lemma FL_Unique[rule_format]: "\<forall> r F h. (N, r, F, h) \<in> FL \<longrightarrow> (\<forall> M FF . (M, r, FF, h) \<in> FL \<longrightarrow> (N=M \<and> F=FF))"
apply clarsimp
apply (induct N)
apply (erule FL.elims, simp_all)
apply (erule FL.elims, simp_all)
apply (erule FL.elims, simp_all)
apply (erule FL.elims, simp_all)
apply fast
done

end
