
header {*The Machine model*}
(*<*)
theory MachineBasic = Finmap:
(*>*)
subsection {*Basic names and types*}

text {*We distinguish between variables holding integer values
       and variables pointing to heap objects.*}

datatype  iname	= In string --  {* names of integer variables *}
datatype  rname = RN string  --  {* names of object variables *}	 

text {* The special object variable which refers to the parent object
        in (virtual) methods.*}
constdefs self     :: rname "self == (RN ''self'') "

text {*Now the categories for naming functions, fields, classes and methods.*}
datatype funame = FN string  -- {* names of functions *}
datatype  cname = CN string -- {* names of classes *}		
datatype  ifldname = IFN string -- {* names of integer fields *}
datatype  rfldname = RFN string	-- {* names of reference fields *}
datatype mname = MN string -- {* names of methods *}

(*<*)
lemma cl: "(In ''a'') = (In ''b'') \<Longrightarrow> P" 
apply simp
done
(*>*)

subsection {* Locations and references *}
text {*
  We model locations as natural numbers.  This is somewhat concrete, but 
  avoids constructing an abstract type or assuming the properties we expect.
  References are either null or locations. *}

types locn = nat
datatype ref = Nullref | Ref locn  

text {* We define a partial projection on non-null locations. *}
consts theloc :: "ref \<Rightarrow> locn"
primrec "theloc (Ref a) = a"

text {* Given a finite set of locations, we can always find a new fresh one.*}
constdefs freshloc  :: "locn set \<Rightarrow> locn"         
 "freshloc L == Suc (Max (insert 0 L))" 

lemma freshloc: "finite L \<Longrightarrow> freshloc L \<notin> L"
(*<*)
  apply (simp add: freshloc_def)
  apply (subgoal_tac "finite (insert 0 L)")
  apply (erule thin_rl)
  apply (drule Max)
  apply (auto)
  done
(*>*)
(*<*)
end
(*>*)
