theory TestVCG2 = TreeVCG + InsSortDestrProg:
ML_setup {*
  val basicsimpset_tac = simp_tac HOL_basic_ss
  fun sym_basicsimp i = FIRST [CHANGED (simp_tac HOL_basic_ss i), rtac add_commute i]

  fun localsimp_tac ctxt i = simp_tac (Simplifier.get_local_simpset ctxt) i
  fun localsimp_tac_thms ctxt thms = 
     simp_tac ((Simplifier.get_local_simpset ctxt) addsimps thms)
  fun simpset_tac_thms t i = simp_tac (HOL_basic_ss addsimps ([fst_conv,snd_conv]@t)) i

  fun repeat 0 tac = all_tac
    | repeat n tac = tac THEN (repeat (n-1) tac)

  val mrg_int = thm "MRG_Int"
  val mrg_ivar = thm "MRG_IVar"
  val mrg_rvar = thm "MRG_RVar"
  val mrg_prim = thm "MRG_Prim"
  val mrg_rprim = thm "MRG_RPrim"
  val mrg_nulllist = thm "MRG_NullList"
  val mrg_nullres = thm "MRG_NullRes"
  val mrg_nulltree = thm "MRG_NullTree"
  val mrg_makelist = thm "MRG_MakeList"
  val mrg_maketree = thm "MRG_MakeTree"
  val mrg_makeresult = thm "MRG_MakeResultSome"
  val mrg_invstat = thm "MRG_InvStat"
  val mrg_letv = thm "MRG_Letv"
  val mrg_leti = thm "MRG_Leti"
  val mrg_letr = thm "MRG_Letr"
  val mrg_letrnull = thm "MRG_LetrNull"
  val mrg_listmatch = thm "MRG_ListMatch"
  val mrg_listmatchd = thm "MRG_ListMatchD"
  val mrg_treematch = thm "MRG_TreeMatch"
  val mrg_treematchd = thm "MRG_TreeMatchD"
  val mrg_resultmatch = thm "MRG_ResultMatch"
  val mrg_resultmatchd = thm "MRG_ResultMatchD"
  val mrg_if = thm "MRG_If"
  val mrg_weak = thm "MRG_Weak"

  val mrg_call = thm "MRG_Call"
  val mrg_domcallnil = thm "DOM_CallNIL"
  val mrg_domcallcons = thm "DOM_CallCONS"

  val rena_nil = thm "RENA_NIL"
  val rena_in = thm "RENA_IN"
  val rena_rn = thm "RENA_RN"

  val mrg_sound = thm "MRG_sound"

  fun getr_tac ctxt i = localsimp_tac ctxt i
  fun getr_clar_tac ctxt i = EVERY [localsimp_tac ctxt i, clarify_tac HOL_cs i]
  fun getr_fast ctxt i = SELECT_GOAL (FIRST [SOLVE (getr_tac ctxt i), EVERY [getr_tac ctxt i, fast_tac (claset()) i]]) i

  fun bsf i = SELECT_GOAL (FIRST [SOLVE (basicsimpset_tac i), EVERY [basicsimpset_tac i, fast_tac (claset()) i]]) i
  fun lsf ctxt i = SELECT_GOAL (FIRST [SOLVE (localsimp_tac ctxt i), EVERY [localsimp_tac ctxt i, fast_tac (claset()) i]]) i

  fun type_tac i = basicsimpset_tac i
  fun context_tac ctxt thms i = localsimp_tac_thms ctxt thms i

  fun stop ctxt thms i = all_tac

  fun ast i = asm_simp_tac (simpset()) i 

  fun ast_thms thms i = 
     asm_simp_tac ((simpset()) addsimps thms) i

  fun ast_fast i =
         SELECT_GOAL (FIRST[SOLVE (ast i),
                            EVERY [ast i,fast_tac (claset()) i]]) i
  fun ast_thms_fast thms i = 
         SELECT_GOAL (FIRST[SOLVE (ast_thms thms i), 
                            EVERY [ast_thms thms i,fast_tac (claset()) i]]) i

  fun RENA_tac i state = state |> 
    FIRST [EVERY [rtac rena_in i, RENA_tac i],
           EVERY [rtac rena_rn i, RENA_tac i],
           rtac rena_nil i]

  fun null_tac ctxt i =
    FIRST [EVERY [rtac mrg_nulllist i, localsimp_tac ctxt i],
           EVERY [rtac mrg_nullres i, localsimp_tac ctxt i],
           EVERY [rtac mrg_nulltree i, localsimp_tac ctxt i]]

  fun null_tac_simp ctxt i = 
     EVERY [SELECT_GOAL (FIRST [null_tac ctxt i, EVERY[localsimp_tac ctxt i, null_tac ctxt i]]) i]

  fun leaf_tac ctxt (thms  as (d_defs,m_defs,f_defs,c_defs)) i =
   FIRST [EVERY [rtac mrg_int i, localsimp_tac ctxt i],
          EVERY [rtac mrg_ivar i, localsimp_tac ctxt i],
          EVERY [rtac mrg_rvar i, getr_fast ctxt i, localsimp_tac ctxt i],
          EVERY [rtac mrg_prim i, localsimp_tac ctxt i],
          EVERY [rtac mrg_rprim i, repeat 2 (getr_fast ctxt i), localsimp_tac ctxt i],
          EVERY [rtac mrg_maketree i, getr_fast ctxt i, getr_fast ctxt i,
                 localsimp_tac ctxt i, localsimp_tac ctxt i],
          EVERY [rtac mrg_makelist i, getr_fast ctxt i, localsimp_tac ctxt i],
          EVERY [rtac mrg_makeresult i, getr_fast ctxt i, localsimp_tac ctxt i],
          EVERY [rtac mrg_invstat i,
                 localsimp_tac_thms ctxt c_defs i, 
                 localsimp_tac_thms ctxt m_defs i, 
                 ast_thms m_defs i,
                 ast i,
                 ast_thms_fast m_defs i, ast_fast i, 
                 repeat 2 (localsimp_tac_thms ctxt [thm "DOM_def"] i),
                 repeat 2 (localsimp_tac ctxt i),
                 ast_thms m_defs i,
                 RENA_tac i,
                 localsimp_tac ctxt i],
          null_tac_simp ctxt i
         ]

  fun let_tac ctxt thms rectac i = 
      FIRST [EVERY [rtac mrg_letv i, leaf_tac ctxt thms i, rectac i, bsf i],
             EVERY [rtac mrg_leti i, leaf_tac ctxt thms i, rectac i, bsf i],
(*             EVERY [rtac mrg_letrnull i, rectac i, leaf_tac ctxt thms i, lsf ctxt i, bsf i],*)
             EVERY [rtac mrg_letrnull i, rectac i, null_tac_simp ctxt i, lsf ctxt i, bsf i],
             EVERY [rtac mrg_letr i, leaf_tac ctxt thms i, rectac i, lsf ctxt i, bsf i]]

  fun match_tac ctxt rectac i = 
    FIRST [EVERY [rtac mrg_listmatchd i, getr_fast ctxt i, 
                  basicsimpset_tac i, localsimp_tac ctxt i, rectac i, lsf ctxt i],
           EVERY [rtac mrg_resultmatchd i, getr_fast ctxt i, 
                  basicsimpset_tac i, localsimp_tac ctxt i, rectac i, lsf ctxt i],
           EVERY [rtac mrg_treematchd i, (getr_fast ctxt i),
                  basicsimpset_tac i, localsimp_tac ctxt i, rectac i, lsf ctxt i],
           EVERY [rtac mrg_listmatch i, (getr_fast ctxt i),
                  basicsimpset_tac i, rectac i, lsf ctxt i],
           EVERY [rtac mrg_resultmatch i, (getr_fast ctxt i),
                  basicsimpset_tac i, rectac i, lsf ctxt i],
           EVERY [rtac mrg_treematch i, (getr_fast ctxt i),
                  basicsimpset_tac i, localsimp_tac ctxt i, localsimp_tac ctxt i, rectac i, lsf ctxt i]]
  
  fun call_tac ctxt thms tac i =
   EVERY [rtac mrg_call i, 
	  localsimp_tac_thms ctxt thms i,
          tac i]

  fun asm_localsimp_tac ctxt = asm_simp_tac (Simplifier.get_local_simpset ctxt)
  fun funsimp_tac_thms t = simp_tac (HOL_basic_ss addsimps (snd_conv :: t))
  fun domm_tac ctxt thms tac1 tac2 i =
    FIRST [EVERY [rtac mrg_domcallnil i, asm_localsimp_tac ctxt i,
                  funsimp_tac_thms thms i, rtac mrg_sound i,
                  tac1 i],
           EVERY [rtac mrg_domcallcons i, tac1 i,
                  localsimp_tac_thms ctxt thms i,tac2 i],
           EVERY [rtac conjI i,  (* leaves subgoal of form ?U = X *)
                  localsimp_tac_thms ctxt thms i,
	          rtac disjI1 i,
                  localsimp_tac_thms ctxt thms i]]

     (* here: solve a subgoal of the same form, then simplify with MFS_defs to expand method body
        in other subgoals (for each of the dominators?)
	We want to do this to maintain invariant for VCG.
        asm_localsimp_tac_thms ctxt thms 2
     *)
  (* rec_tac : ctxt \<rightarrow> thms \<rightarrow> int \<rightarrow> tactic \<rightarrow> tactic \<rightarrow> int \<rightarrow> tactic*)
  fun dom_tac ctxt thms rec_tac tac2 i =
    let fun domcall n state = state |> 
       ((((rtac mrg_domcallcons i) THEN domcall (n+1))
	 ORELSE
	 (EVERY 
	  ([(rtac mrg_domcallnil i),
	    asm_localsimp_tac ctxt i,
	   (* asm_localsimp_tac_thms ctxt thms i,*)
	    funsimp_tac_thms thms i,
            rtac mrg_sound i,
	    rec_tac i] @
	   (map tac2 (rev (i upto (i+n-1)))))))
	 ORELSE
	 (* solve for a merge point by projecting on the context, 
	    solving a set-equality subgoal *)
	 (EVERY
	  [rtac conjI i,  (* leaves subgoal of form ?U = X *)
           localsimp_tac_thms ctxt thms i,
	   rtac disjI1 i,
	   localsimp_tac_thms ctxt thms i]))
      in domcall 0 end

  fun if_tac rec_tacTHEN rec_tacELSE i =
   EVERY [rtac mrg_if i,
          rec_tacTHEN i,
	  rec_tacELSE i]

  fun w_tac ctxt thms tac i = 
    EVERY
      [TRY(localsimp_tac_thms ctxt thms i),  (* expand SPEC, methtable *)
       rtac mrg_sound i,
       rtac mrg_weak i,
       tac i,
       fast_tac (claset()) i]

  fun main_stop ctxt (thms  as (d_defs,m_defs,f_defs,c_defs)) i state = state |> 
    FIRST [if_tac (stop ctxt thms) (stop ctxt thms) i,
           call_tac ctxt d_defs (stop ctxt thms) i,
(*           dom_tac ctxt f_defs (stop ctxt thms) (w_tac ctxt f_defs (stop ctxt thms)) i,*)
           domm_tac ctxt f_defs (stop ctxt thms) (w_tac ctxt f_defs (stop ctxt thms)) i,
           leaf_tac ctxt thms i,
           match_tac ctxt (stop ctxt thms) i,
           let_tac ctxt thms (stop ctxt thms) i]

   fun main_tac ctxt (thms  as (d_defs,m_defs,f_defs,c_defs)) i state = state |> 
    FIRST [if_tac (main_tac ctxt thms) (main_tac ctxt thms) i,
           call_tac ctxt d_defs (main_tac ctxt thms) i,
(*           dom_tac ctxt f_defs (main_tac ctxt thms) (w_tac ctxt f_defs (main_tac ctxt thms)) i,*)
           domm_tac ctxt f_defs (main_tac ctxt thms) (w_tac ctxt f_defs (main_tac ctxt thms)) i,
           leaf_tac ctxt thms i,
           match_tac ctxt (main_tac ctxt thms) i,
           let_tac ctxt thms (main_tac ctxt thms) i]
*}

defs
isMergePoint_def: "isMergePoint f == False"

dominates_def:
"dominates f == []"

defs SPEC_def:"SPEC M == 
  (if M = Ins then \<lbrace> {l_}, 1, [(l_,ListET 0 0)] \<ggreater> ListET 0 0, 0\<rbrace> else
  if M = Sort then \<lbrace> {l_}, 0, [(l_,ListET 0 0)] \<ggreater> ListET 0 0, 0\<rbrace> else
  (\<lambda> E h hh v p . False))"
text{*FST and vMST remain unspecified.*}

text {*In order to prove the body correct we define a 
       context which contains an one entry for each syntactic method invocation.*}
constdefs  InsSortContext:: vdmcontext
"InsSortContext \<equiv> {(InsSort\<bullet>Ins([INarg a_,RNarg v2_]), sMST InsSort Ins [INarg a_, RNarg v2_]),
                   (InsSort\<bullet>Ins([INarg v3_,RNarg l_]), sMST InsSort Ins [INarg v3_, RNarg l_]),
                   (InsSort\<bullet>Sort([RNarg v2_]), sMST InsSort Sort [RNarg v2_])}"
lemmas context_simp = InsSortContext_def

lemma InsContext_finite[simp]: "finite InsSortContext"
by (simp add: InsSortContext_def)

lemmas dmp_defs = dominates_def isMergePoint_def 
lemmas meth_defs = Meth_Ins Meth_Sort SPEC_def
lemmas ins_pdefs = Meth_Ins Fun_fIns Fun_fzeroIns Fun_foneIns Fun_ftwoIns Fun_fthreeIns SPEC_def
lemmas sort_pdefs = Meth_Sort Fun_fSort Fun_fzeroSort Fun_foneSort Meth_Ins SPEC_def
lemmas ctxt_def  = InsSortContext_def

method_setup AST_THMS = {* Method.thms_ctxt_args (fn thms => fn ctxt => 
  Method.METHOD (fn facts => (ast_thms thms 1)))*}
  "Method for asm_simp_tac"
method_setup AST_THMS_FAST = {* Method.thms_ctxt_args (fn thms => fn ctxt => 
  Method.METHOD (fn facts => (ast_thms_fast thms 1)))*}
  "Method for asm_simp_tac"
method_setup LEAF = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => leaf_tac ctxt ([],thms "meth_defs",[],thms "ctxt_def") 1))*}
  "Method for leaf rules"
method_setup BS = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => basicsimpset_tac 1))*}
  "Method for basic simpset"
method_setup BSF = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => bsf 1))*}
  "Method for basic simpset + fast"
method_setup SB = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => sym_basicsimp 1))*}
  "Method for symmetric basic simpset"
method_setup GT = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => getr_tac ctxt 1))*}
  "Method for GETr"
method_setup GTC = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => getr_clar_tac ctxt 1))*}
  "Method for GETr with clarify"
method_setup GTF = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => getr_fast ctxt 1))*}
  "Method for GETr with fast"
method_setup STT = {* Method.thms_ctxt_args (fn thms => fn ctxt => 
  Method.METHOD (fn facts => simpset_tac_thms thms 1))*}
  "Method for basic simpset"
method_setup LS = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => localsimp_tac ctxt 1))*}
  "Method for local simpset"
method_setup LSF = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => lsf ctxt 1))*}
  "Method for local simpset + fast"
method_setup LSTT = {* Method.thms_ctxt_args (fn thms => fn ctxt => 
  Method.METHOD (fn facts => localsimp_tac_thms ctxt thms 1))*}
  "Method for local_simpset_thms"
method_setup LET = {* Method.thms_ctxt_args (fn t => fn ctxt => 
  Method.METHOD (fn facts => let_tac ctxt ([],thms "meth_defs",t,thms "ctxt_def") (stop ctxt ([],thms "meth_defs",[],thms "ctxt_def")) 1))*}
  "Method for local_simpset_thms"
method_setup MATCH = {* Method.thms_ctxt_args (fn t => fn ctxt => 
  Method.METHOD (fn facts => match_tac ctxt (stop ctxt ([],thms "meth_defs",[],thms "ctxt_def")) 1))*}
  "Method for matches"
method_setup SBS = {* Method.thms_ctxt_args (fn thms => fn ctxt => 
  Method.METHOD (fn facts => (sym_basicsimp 1)))*}
  "Method for symbasicsimp"
method_setup ASM_LOC = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => 
    asm_simp_tac (Simplifier.get_local_simpset ctxt) 1))*}
"asm_local_simpset"
method_setup MS = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => main_stop ctxt (thms "dmp_defs",thms "meth_defs",pdefs,thms "ctxt_def") 1)) *}
  "main Method with stop continuation, simplification with args" 
method_setup M = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => main_tac ctxt (thms "dmp_defs",thms "meth_defs",pdefs,thms "ctxt_def") 1)) *}
  "main Method: simplification with args" 
 
method_setup W = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => w_tac ctxt (thms "meth_defs") (main_tac ctxt (thms "dmp_defs",thms "meth_defs",pdefs,thms "ctxt_def")) 1)) *}
  "parametric Method for starting: use weakening, simplification with args, fast" 
method_setup WS = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => w_tac ctxt (thms "meth_defs") (main_stop ctxt (thms "dmp_defs",thms "meth_defs",pdefs,thms "ctxt_def")) 1)) *}
  "parametric Method for starting: use weakening, simplification with args, fast"
(*
lemma Sort_DAss:
"InsSortContext \<rhd> snd (methtable InsSort Sort) : SPEC Sort"
apply (simp add: meth_defs)
apply (rule MRG_sound)
apply (rule MRG_Weak)
apply (rule MRG_Call)
  apply (simp add: dmp_defs)
  apply (rule DOM_CallNIL) apply simp
  apply (simp add: sort_pdefs)
  apply (rule MRG_sound)
  apply (rule MRG_Leti)
    apply LEAF
    apply (rule MRG_If)
      apply (rule MRG_Call)
        apply (simp add: dmp_defs)
        apply (rule DOM_CallNIL) apply simp
        apply (simp add: sort_pdefs)
        apply (rule MRG_sound)
        apply LEAF
      apply (rule MRG_Call)
        apply (simp add: dmp_defs)
        apply (rule DOM_CallNIL) apply simp
        apply (simp add: sort_pdefs)
        apply (rule MRG_sound)
        apply (rule MRG_ListMatchD)
          apply LSF
          apply BS
          apply LS
          apply LS apply (rule MRG_Letr) 
                     apply (rule MRG_InvStat)
                      apply (simp add: ctxt_def)
                      apply (simp add: meth_defs)
                      apply (simp add: meth_defs)
                      apply (simp add: meth_defs)
                      apply (simp add: meth_defs)
                      apply BS
                      apply (simp add: DOM_def)
                      apply (simp add: DOM_def)
                      apply LS
                      apply LS
                      apply (simp add: meth_defs) apply (rule RENA.intros)+
                      apply LS
                     apply (rule MRG_InvStat)
                      apply (simp add: ctxt_def)
                      apply (simp add: meth_defs)
                      apply (simp add: meth_defs)
                      apply (simp add: meth_defs)
                      apply (simp add: meth_defs)
                      apply BS
                      apply (simp add: DOM_def)
                      apply (simp add: DOM_def)
                      apply LS
                      apply LS
                      apply (simp add: meth_defs) apply (rule RENA.intros)+
                      apply LS
                     apply LS
                   apply LS
         apply LS
  apply LS
apply LS
done
*)
method_setup IF_TAC = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => if_tac (main_tac ctxt (thms "dmp_defs",thms "meth_defs",pdefs,thms "ctxt_def")) (main_tac ctxt (thms "dmp_defs",thms "meth_defs",pdefs,thms "ctxt_def"))  1)) *}
  "method for if" 
method_setup IF_TAC1 = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => if_tac (main_tac ctxt (thms "dmp_defs",thms "meth_defs",pdefs,thms "ctxt_def")) (stop ctxt ([],thms "meth_defs",[],thms "ctxt_def")) 1)) *}
  "method for if, stop in else" 
method_setup IF_TAC2 = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => if_tac  (stop ctxt ([],thms "meth_defs",[],thms "ctxt_def")) (main_tac ctxt (thms "dmp_defs",thms "meth_defs",pdefs,thms "ctxt_def")) 1)) *}
  "method for if, stop in then" 
method_setup IF_TAC3 = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => if_tac  (stop ctxt ([],thms "meth_defs",[],thms "ctxt_def")) (stop ctxt ([],thms "meth_defs",[],thms "ctxt_def"))  1)) *}
  "method for if, stop in both branches"

lemma Sort_DAss:
"InsSortContext \<rhd> snd (methtable InsSort Sort) : SPEC Sort"
by (W sort_pdefs)

lemma Ins_DAss:
"InsSortContext \<rhd> snd (methtable InsSort Ins) : SPEC Ins"
by (W ins_pdefs)

end
(*
ML_setup {&
  val basicsimpset_tac = simp_tac HOL_basic_ss
  fun sym_basicsimp i = FIRST [CHANGED (simp_tac HOL_basic_ss i), rtac add_commute i]

  fun localsimp_tac ctxt i = simp_tac (Simplifier.get_local_simpset ctxt) i
  fun localsimp_tac_thms ctxt thms = 
     simp_tac ((Simplifier.get_local_simpset ctxt) addsimps thms)
  fun simpset_tac_thms t i = simp_tac (HOL_basic_ss addsimps ([fst_conv,snd_conv]@t)) i

  fun repeat 0 tac = all_tac
    | repeat n tac = tac THEN (repeat (n-1) tac)

  val mrg_int = thm "MRG_Int"
  val mrg_ivar = thm "MRG_IVar"
  val mrg_rvar = thm "MRG_RVar"
  val mrg_prim = thm "MRG_Prim"
  val mrg_rprim = thm "MRG_RPrim"
  val mrg_nulllist = thm "MRG_NullList"
  val mrg_nullres = thm "MRG_NullRes"
  val mrg_nulltree = thm "MRG_NullTree"
  val mrg_makelist = thm "MRG_MakeList"
  val mrg_maketree = thm "MRG_MakeTree"
  val mrg_makeresult = thm "MRG_MakeResultSome"
  val mrg_invstat = thm "MRG_InvStat"
  val mrg_letv = thm "MRG_Letv"
  val mrg_leti = thm "MRG_Leti"
  val mrg_letr = thm "MRG_Letr"
  val mrg_letrnull = thm "MRG_LetrNull"
  val mrg_listmatch = thm "MRG_ListMatch"
  val mrg_listmatchd = thm "MRG_ListMatchD"
  val mrg_treematch = thm "MRG_TreeMatch"
  val mrg_treematchd = thm "MRG_TreeMatchD"
  val mrg_resultmatch = thm "MRG_ResultMatch"
  val mrg_resultmatchd = thm "MRG_ResultMatchD"
  val mrg_if = thm "MRG_If"
  val mrg_weak = thm "MRG_Weak"

  val mrg_call = thm "MRG_Call"
  val mrg_domcallnil = thm "DOM_CallNIL"
  val mrg_domcallcons = thm "DOM_CallCONS"

  val rena_nil = thm "RENA_NIL"
  val rena_in = thm "RENA_IN"
  val rena_rn = thm "RENA_RN"

  val mrg_sound = thm "MRG_sound"

  fun getr_tac ctxt i = localsimp_tac ctxt i
  fun getr_clar_tac ctxt i = EVERY [localsimp_tac ctxt i, clarify_tac HOL_cs i]
  fun getr_fast ctxt i = SELECT_GOAL (FIRST [SOLVE (getr_tac ctxt i), EVERY [getr_tac ctxt i, fast_tac (claset()) i]]) i

  fun bsf i = SELECT_GOAL (FIRST [SOLVE (basicsimpset_tac i), EVERY [basicsimpset_tac i, fast_tac (claset()) i]]) i
  fun lsf ctxt i = SELECT_GOAL (FIRST [SOLVE (localsimp_tac ctxt i), EVERY [localsimp_tac ctxt i, fast_tac (claset()) i]]) i

  fun type_tac i = basicsimpset_tac i
  fun context_tac ctxt thms i = localsimp_tac_thms ctxt thms i

  fun stop ctxt thms i = all_tac

  fun ast i = asm_simp_tac (simpset()) i 

  fun ast_thms thms i = 
     asm_simp_tac ((simpset()) addsimps thms) i

  fun ast_fast i =
         SELECT_GOAL (FIRST[SOLVE (ast i),
                            EVERY [ast i,fast_tac (claset()) i]]) i
  fun ast_thms_fast thms i = 
         SELECT_GOAL (FIRST[SOLVE (ast_thms thms i), 
                            EVERY [ast_thms thms i,fast_tac (claset()) i]]) i

  fun RENA_tac i state = state |> 
    FIRST [EVERY [rtac rena_in i, RENA_tac i],
           EVERY [rtac rena_rn i, RENA_tac i],
           rtac rena_nil i]

  fun leaf_tac ctxt (thms  as (d_defs,m_defs,f_defs,c_defs)) i =
   FIRST [EVERY [rtac mrg_int i, localsimp_tac ctxt i],
          EVERY [rtac mrg_ivar i, localsimp_tac ctxt i],
          EVERY [rtac mrg_rvar i, getr_fast ctxt i, localsimp_tac ctxt i],
          EVERY [rtac mrg_prim i, localsimp_tac ctxt i],
          EVERY [rtac mrg_rprim i, repeat 2 (getr_fast ctxt i), localsimp_tac ctxt i],
          EVERY [rtac mrg_nulllist i, localsimp_tac ctxt i],
          EVERY [rtac mrg_nullres i, localsimp_tac ctxt i],
          EVERY [rtac mrg_nulltree i, localsimp_tac ctxt i],
          EVERY [rtac mrg_maketree i, getr_fast ctxt i, getr_fast ctxt i,
                 localsimp_tac ctxt i, localsimp_tac ctxt i],
          EVERY [rtac mrg_makelist i, getr_fast ctxt i, localsimp_tac ctxt i],
          EVERY [rtac mrg_makeresult i, getr_fast ctxt i, localsimp_tac ctxt i],
          EVERY [rtac mrg_invstat i,
                 localsimp_tac_thms ctxt c_defs i, 
                 localsimp_tac_thms ctxt m_defs i, 
                 ast_thms m_defs i,
                 ast i,
                 ast_thms_fast m_defs i, ast_fast i, 
                 repeat 2 (localsimp_tac_thms ctxt [thm "DOM_def"] i),
                 repeat 2 (localsimp_tac ctxt i),
                 ast_thms m_defs i,
                 RENA_tac i,
                 localsimp_tac ctxt i]
         ]
  fun let_tac ctxt thms rectac i = 
      FIRST [EVERY [rtac mrg_letv i, leaf_tac ctxt thms i, rectac i, bsf i],
             EVERY [rtac mrg_leti i, leaf_tac ctxt thms i, rectac i, bsf i],
             EVERY [rtac mrg_letrnull i, rectac i, leaf_tac ctxt thms i, lsf ctxt i, bsf i],
             EVERY [rtac mrg_letr i, leaf_tac ctxt thms i, rectac i, lsf ctxt i, bsf i]]

  fun match_tac ctxt rectac i = 
    FIRST [EVERY [rtac mrg_listmatchd i, getr_fast ctxt i, 
                  basicsimpset_tac i, localsimp_tac ctxt i, rectac i, lsf ctxt i],
           EVERY [rtac mrg_resultmatchd i, getr_fast ctxt i, 
                  basicsimpset_tac i, localsimp_tac ctxt i, rectac i, lsf ctxt i],
           EVERY [rtac mrg_treematchd i, (getr_fast ctxt i),
                  basicsimpset_tac i, localsimp_tac ctxt i, rectac i, lsf ctxt i],
           EVERY [rtac mrg_listmatch i, (getr_fast ctxt i),
                  basicsimpset_tac i, rectac i, lsf ctxt i],
           EVERY [rtac mrg_resultmatch i, (getr_fast ctxt i),
                  basicsimpset_tac i, rectac i, lsf ctxt i],
           EVERY [rtac mrg_treematch i, (getr_fast ctxt i),
                  basicsimpset_tac i, localsimp_tac ctxt i, localsimp_tac ctxt i, rectac i, lsf ctxt i]]
             

  fun call_tac ctxt thms tac i =
   EVERY [rtac mrg_call i, 
	  localsimp_tac_thms ctxt thms i,
          tac i]

     (& here: solve a subgoal of the same form, then simplify with MFS_defs to expand method body
        in other subgoals (for each of the dominators?)
	We want to do this to maintain invariant for VCG.
        asm_localsimp_tac_thms ctxt thms 2
     &)
  fun asm_localsimp_tac ctxt = asm_simp_tac (Simplifier.get_local_simpset ctxt)
  fun funsimp_tac_thms t = simp_tac (HOL_basic_ss addsimps (snd_conv :: t))
  (& rec_tac : ctxt \<rightarrow> thms \<rightarrow> int \<rightarrow> tactic \<rightarrow> tactic \<rightarrow> int \<rightarrow> tactic&)
  fun dom_tac ctxt thms rec_tac tac2 i =
    let fun domcall n state = state |> 
       ((((rtac mrg_domcallcons i) THEN domcall (n+1))
	 ORELSE
	 (EVERY 
	  ([(rtac mrg_domcallnil i),
	    asm_localsimp_tac ctxt i,
	   (& asm_localsimp_tac_thms ctxt thms i,&)
	    funsimp_tac_thms thms i,
            rtac mrg_sound i,
	    rec_tac i] @
	   (map tac2 (rev (i upto (i+n-1)))))))
	 ORELSE
	 (& solve for a merge point by projecting on the context, 
	    solving a set-equality subgoal &)
	 (EVERY
	  [rtac conjI i,  (& leaves subgoal of form ?U = X &)
           localsimp_tac_thms ctxt thms i,
	   rtac disjI1 i,
	   localsimp_tac_thms ctxt thms i]))
      in domcall 0 end

  fun if_tac rec_tacTHEN rec_tacELSE i =
   EVERY [rtac mrg_if i,
          rec_tacTHEN i,
	  rec_tacELSE i]

  fun w_tac ctxt thms tac i = 
    EVERY
      [TRY(localsimp_tac_thms ctxt thms i),  (& expand SPEC, methtable &)
       rtac mrg_sound i,
       rtac mrg_weak i,
       tac i,
       fast_tac (claset()) i]

  fun main_stop ctxt (thms  as (d_defs,m_defs,f_defs,c_defs)) i state = state |> 
    FIRST [if_tac (stop ctxt thms) (stop ctxt thms) i,
           match_tac ctxt (stop ctxt thms) i,
           let_tac ctxt thms (stop ctxt thms) i,
           call_tac ctxt d_defs (stop ctxt thms) i,
           dom_tac ctxt f_defs (stop ctxt thms) (w_tac ctxt f_defs (stop ctxt thms)) i,
           leaf_tac ctxt thms i]

   fun main_tac ctxt (thms  as (d_defs,m_defs,f_defs,c_defs)) i state = state |> 
    FIRST [if_tac (main_tac ctxt thms) (main_tac ctxt thms) i,
           match_tac ctxt (main_tac ctxt thms) i,
           let_tac ctxt thms (main_tac ctxt thms) i,
           call_tac ctxt d_defs (main_tac ctxt thms) i,
           dom_tac ctxt f_defs (main_tac ctxt thms) (w_tac ctxt f_defs (main_tac ctxt thms)) i,
           leaf_tac ctxt thms i]
&}
*)
