(*  
   File:	Finmap.thy
   Authors:	David Aspinall, Lennart Beringer, Hans-Wolfgang Loidl
   Id:		$Id: Finmap.thy,v 1.1.2.1 2005/08/02 11:00:36 a1hloidl Exp $
   
    A type definition for finite maps

  Olha's comment: guys, see also "A theory of finite maps" 
                  by Graham Collins and Donald Syme,
                  www.collins-peak.net/academic/fmap.ps
*)

header {*Preliminaries: finite maps*}

theory Finmap = Main:

typedef (Finmap)
  ('a,'b) finmap = "{F::'a \<leadsto> 'b| F. finite (dom F)}" 
proof
  show "empty : ?Finmap"
  by simp
qed

syntax 
 "finmap"  :: "[type,type] => type"  (infixr "~=>f" 0)

syntax (xsymbols)
  "finmap"     :: "[type, type] => type"      (infixr "\<leadsto>\<^sub>f" 0)

constdefs
  fimap :: "('a \<leadsto> 'b) \<Rightarrow> ('a \<leadsto>\<^sub>f 'b)"
  "fimap S \<equiv> Abs_Finmap(S)"

  themap :: "('a \<leadsto>\<^sub>f 'b) \<Rightarrow> ('a \<leadsto> 'b)" 
  "themap F \<equiv> Rep_Finmap(F)"

lemma finmap [simp]: "finite (dom F) \<Longrightarrow> themap(fimap F) = F"
  by (simp add: fimap_def themap_def Finmap_def Abs_Finmap_inverse)

lemma finmap2 [simp]: "fimap(themap F) = F"
 by (simp add: fimap_def themap_def Finmap_def Rep_Finmap_inverse)

lemma finmap_cases [case_names finmap, cases type: finmap]: 
  "(!!M. \<lbrakk> F = fimap M; finite (dom M) \<rbrakk> \<Longrightarrow> R) \<Longrightarrow> R"
proof -
  assume r: "!!M. \<lbrakk> F = fimap M; finite (dom M) \<rbrakk> \<Longrightarrow> R"
  obtain M where "F = fimap M" and "finite (dom M)"
  by (cases F) (auto simp add: fimap_def Finmap_def)
  thus R by (rule r)
qed

lemma finmap_induct [case_names finmap, induct type: finmap]:
    "(!!M. finite (dom M) ==> P (fimap M)) ==> P f"
by (cases f, simp)

constdefs
 fmap_upd	:: "('a ~=>f 'b) => 'a => 'b => ('a ~=>f 'b)"
					         ("_/'(_/|->f_')"   [900,0,0]900)
 "fmap_upd f a b == fimap(themap(f)(a\<mapsto>b))"

syntax
  fmap_upd   :: "('a \<leadsto>\<^sub>f 'b) => 'a      => 'b      => ('a \<leadsto>\<^sub>f 'b)"
					  ("_/'(_/\<mapsto>\<^sub>f/_')"  [900,0,0]900)

constdefs
 fmap_lookup	:: "('a ~=>f 'b) => 'a => 'b option"
 "fmap_lookup f a == themap(f) a"

constdefs
 emptyfinmap :: "'a \<leadsto>\<^sub>f 'b"
 "emptyfinmap == fimap(empty)"

lemma lookupEmptyfinmap[simp]: "fmap_lookup emptyfinmap k  = None"
by (simp add: emptyfinmap_def fmap_lookup_def)

lemma lookupUpdatefinmap[simp]: "fmap_lookup (f(a \<mapsto>\<^sub>f b)) a= Some b"
by (induct f, simp add: fmap_upd_def fmap_lookup_def)

subsection {* Domains of finite maps *}
constdefs
 fmap_dom  :: "('a ~=>f 'b) => 'a set"
 "fmap_dom f == dom(themap f)"

lemma finite_dom_fmap [intro]:  "finite (fmap_dom f)"
by (induct f, simp add: fmap_dom_def)

lemma fmap_dom_emptymap [simp]: "fmap_dom emptyfinmap = {}"
by (simp add: emptyfinmap_def fmap_dom_def)

lemma fmap_dom_update [simp]: "fmap_dom (f(a\<mapsto>\<^sub>fb)) = (fmap_dom f) \<union> {a}"
by (induct f, simp add: fmap_dom_def fmap_upd_def)

lemma FMAPlookup1:"(\<not> c = a) \<Longrightarrow> ((fmap_lookup (f(a \<mapsto>\<^sub>f b)) c) = (fmap_lookup f c))"
by (induct f, simp add: fmap_dom_def fmap_upd_def fmap_lookup_def)

lemma FMAPlookup2: "(((\<not> c = a) \<and> (fmap_lookup f c = d)) \<longrightarrow> (fmap_lookup (f(a \<mapsto>\<^sub>f b)) c = d))"
by (induct f, simp add: fmap_dom_def fmap_upd_def fmap_lookup_def)

lemma FMAPlookup3:"\<And>   a b c d f . (((\<not> c = a) \<and> (fmap_lookup f c = d)) \<longrightarrow> (fmap_lookup (f(a \<mapsto>\<^sub>f b)) c = d))"
by(simp add:FMAPlookup1)

end 

(*
lemma finmap_upd_nonempty: "t(k \<mapsto>\<^sub>f x) ~= emptyfinmap"
sorry

lemma finmap_domempty:"fmap_dom B = {} \<Longrightarrow> B = emptyfinmap"
sorry

consts FMAP_DisjUnion::"(('a \<leadsto>\<^sub>f 'b) \<times> ('a \<leadsto>\<^sub>f 'b) \<times> ('a \<leadsto>\<^sub>f 'b)) set"
inductive FMAP_DisjUnion intros
FMAP_DisjUnionEmpty:"(A,emptyfinmap,A):FMAP_DisjUnion"
FMAP_DisjUnionUpd:"\<lbrakk>x \<notin> fmap_dom B; x \<notin> fmap_dom A; (A,B,C):FMAP_DisjUnion\<rbrakk> \<Longrightarrow> (A,B(x\<mapsto>\<^sub>fa),C(x\<mapsto>\<^sub>fa)):FMAP_DisjUnion"

lemma DisjUnionExistsAux[rule_format]:
"\<forall> B . card (fmap_dom B) = n \<longrightarrow> (\<forall> A . fmap_dom A \<inter> fmap_dom B = {} \<longrightarrow> (\<exists> C . (A,B,C):FMAP_DisjUnion))"
apply (induct n)
apply clarsimp
apply (subgoal_tac "B= emptyfinmap",clarsimp) apply (rule_tac x=A in exI, rule FMAP_DisjUnionEmpty) defer 1
apply clarsimp
apply (subgoal_tac "\<exists> BB x a . B = BB(x\<mapsto>\<^sub>fa) \<and> x \<notin> fmap_dom BB \<and> card (fmap_dom BB) = n",clarsimp)
apply (erule_tac x=BB in allE, erule impE, simp)
apply (erule_tac x=A in allE, erule impE, simp,clarsimp)
apply (rule_tac x="C(x\<mapsto>\<^sub>fa)" in exI)
apply (erule FMAP_DisjUnionUpd, assumption, assumption)
sorry

lemma DisjUnionExists: "fmap_dom A \<inter> fmap_dom B = {} \<Longrightarrow> (\<exists> C . (A,B,C):FMAP_DisjUnion)"
by (rule DisjUnionExistsAux, simp_all)

lemma DisjUnion_lookup1[rule_format]:"(A,B,C):FMAP_DisjUnion \<Longrightarrow> (x: fmap_dom A \<longrightarrow> fmap_lookup C x = fmap_lookup A x)"
apply (erule FMAP_DisjUnion.induct,clarsimp, clarsimp)
apply (subgoal_tac "fmap_lookup (C(xa\<mapsto>\<^sub>fa)) x = fmap_lookup C x", clarsimp)
apply (rule FMAPlookup1)
apply fast
done

lemma DisjUnion_lookup2[rule_format]:"(A,B,C):FMAP_DisjUnion \<Longrightarrow> (x: fmap_dom B \<longrightarrow> fmap_lookup C x = fmap_lookup B x)"
apply (erule FMAP_DisjUnion.induct,clarsimp, clarsimp)
apply (subgoal_tac "fmap_lookup (C(xa\<mapsto>\<^sub>fa)) x = fmap_lookup C x", clarsimp)
apply (subgoal_tac "fmap_lookup (B(xa\<mapsto>\<^sub>fa)) x = fmap_lookup B x", clarsimp)
apply (rule FMAPlookup1)
apply fast
apply (rule FMAPlookup1)
apply fast
done

lemma DisjUnion_doms_distinct:"(A,B,C):FMAP_DisjUnion \<Longrightarrow> (fmap_dom A) \<inter> (fmap_dom B) = {}"
by (erule FMAP_DisjUnion.induct,clarsimp, clarsimp)

lemma DisjUnion_doms_union:"(A,B,C):FMAP_DisjUnion \<Longrightarrow> fmap_dom C = (fmap_dom A) \<union> (fmap_dom B)"
by (erule FMAP_DisjUnion.induct,clarsimp, clarsimp)
*)

(* Missing: 
   empty_upd_none
   sum_case_empty_empty, etc,etc. *)


