(*<*)
theory DAss_ResultrulesT2 = DAss_rulesT2:
(*>*)

(*<*)

(*Auxiliary rules using DAssComplex*)
lemma DA_C_Let_ResL: 
  "\<lbrakk>G \<rhd> e : \<lbrace>U, n, C \<guillemotright> T, m\<rbrace>; GETr C x = Some(ResultET kN TT kS)
   \<rbrakk> \<Longrightarrow> G \<rhd> (LET y = GetFi x V0 IN e END): \<lbrace>{x} \<union> U, n, C \<guillemotright> T, m\<rbrace>"
apply (rule vdm_conseq, rule vdm_leti, rule vdm_getfi)
apply assumption
apply (erule thin_rl, clarsimp)
apply (simp add: DAssComplex_def, safe)
apply (subgoal_tac "\<exists> n1 n2 . (E, h, U, C, n1):ContextSize \<and> (E, h, (insert x U)-U, C, n2):ContextSize \<and> n1+n2=CS", clarsimp)
prefer 2 apply (erule ContextSize_SPLIT, fast, fast)
apply (erule_tac x=q in allE, erule_tac x=n1 in allE, erule_tac x=F in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (rule regionsExist1) apply (erule regionsExist_antimonotone) apply(fast, fast, simp, rule, simp)
apply (rule regionsDistinct1, erule regionsDistinct_antimonotone)  apply(fast, fast, simp, rule, simp)
apply (rule distinctFrom1, erule distinctFrom_antimonotone) apply(fast, fast, simp, rule, simp)
apply (erule ContextSizePreserved, simp)
apply simp
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (rule modified1)  apply(erule modified_monotone) apply(fast, fast, simp, rule, simp)
apply (rule Bounded1) apply(erule Bounded_monotone) apply(simp, simp, fast, fast, rule, simp)
apply (rule Bounded1) apply (rotate_tac -3) apply(erule Bounded_monotone) apply(simp, simp, fast, fast, rule, simp)
done
lemma DA_C_Let_resL: 
  "\<lbrakk>G \<rhd> e : \<lbrace>U, n, C \<guillemotright> T, m\<rbrace>;
    UU=({x} \<union> U); GETr C x = Some (ResultET kN TT kS)
   \<rbrakk> \<Longrightarrow> G \<rhd> (LET y = GetFi x V0 IN e END): \<lbrace>UU, n, C \<guillemotright> T, m\<rbrace>"
by (rule vdm_conseq, rule DA_C_Let_ResL, auto)

lemma regionsExist_ResR:
"\<lbrakk>GETr C y = Some (ResultET kM T kS); renv E y = Ref a; regionsExist (insert y (U - {x})) C h E\<rbrakk> 
  \<Longrightarrow> regionsExist U ((x,T)#C) h E\<lfloor>x:=h\<lfloor>a\<diamondsuit>R1\<rfloor>\<rfloor>"
apply (simp add: regionsExist_def, clarsimp)
apply (case_tac "xa = x", clarsimp) 
apply (erule_tac x=y in allE, erule impE, clarsimp) apply (erule GETrSome_DOM)
apply clarsimp apply (erule reg.elims, simp_all, clarsimp)
  apply fast
apply clarsimp
apply (erule_tac x=xa in allE, erule impE, clarsimp)
apply (simp add: DOM_def)
apply fast 
done

lemma regionsDistinct_ResR:
"\<lbrakk>GETr C y = Some (ResultET kM T kS); y \<notin> U; renv E y = Ref a; regionsExist (insert y (U - {x})) C h E;
  regionsDistinct (insert y (U - {x})) C h E\<rbrakk> 
  \<Longrightarrow> regionsDistinct U ((x,T)#C) h E\<lfloor>x:=h\<lfloor>a\<diamondsuit>R1\<rfloor>\<rfloor>"
apply (simp add: regionsDistinct_def regionsExist_def, safe)
apply (case_tac "xa = x", clarsimp) 
apply (case_tac "xx = x", clarsimp)
apply (subgoal_tac "y:DOM C")
prefer 2  apply (erule GETrSome_DOM)
apply (erule_tac x=y in allE, erule impE, clarsimp)
apply clarsimp
apply (erule_tac x=y in allE, erule_tac x=xx in allE, erule_tac x=Rxa in allE, erule_tac x=Rxx in allE, erule impE, clarsimp)
apply (rule, simp add: DOM_def)
apply (rule, fast)
apply (rule, fast)
apply fast
apply (subgoal_tac "Rx \<subseteq> Rxa - {a}", fast)
apply (erule mRESULT_SOMEregion, assumption)
(*xa \<noteq> x*)
apply (case_tac "xx = x", clarsimp)
apply (subgoal_tac "y:DOM C")
prefer 2  apply (erule GETrSome_DOM)
apply (erule_tac x=y in allE, erule impE, clarsimp)
apply clarsimp
apply (erule_tac x=xx in allE, erule_tac x=y in allE, erule_tac x=Rxx in allE, erule_tac x=Rxa in allE, erule impE, clarsimp)
apply (rule, simp add: DOM_def)
apply fast
apply (subgoal_tac "Rx \<subseteq> Rxa - {a}", fast)
apply (erule mRESULT_SOMEregion, assumption)
(* xa \<noteq> x, xx \<noteq> x*)
apply (erule_tac x=y in allE, erule impE, clarsimp)  apply (erule GETrSome_DOM) apply clarsimp
apply (erule_tac x=xa in allE, erule_tac x=y in allE, erule_tac x=Rx in allE, erule_tac x=Rxa in allE, erule impE, clarsimp)
apply (rule, erule reg_DOM) 
apply (rule, erule GETrSome_DOM)
apply (rule, fast)
apply (rule, fast)
apply fast
apply (subgoal_tac "Rxx \<subseteq> Rxa - {a}", fast)
apply (erule mRESULT_SOMEregion, assumption)
apply (erule_tac x=xa in allE, erule_tac x=xx in allE, erule_tac x=Rx in allE, erule_tac x=Rxx in allE, erule impE, clarsimp)
apply (rule, erule reg_DOM) 
apply (rule, erule reg_DOM)
apply (rule, fast)
apply (rule, fast)
apply fast
done

lemma distinctFrom_ResR:
"\<lbrakk>GETr C y = Some (ResultET kN T rS); y \<notin> U; renv E y = Ref a; regionsExist (insert y (U - {x})) C h E;
  distinctFrom (insert y (U - {x})) C h E F\<rbrakk>
  \<Longrightarrow> distinctFrom U ((x,T)#C) h E\<lfloor>x:=h\<lfloor>a\<diamondsuit>R1\<rfloor>\<rfloor> F"
apply (simp add: distinctFrom_def regionsExist_def)
apply clarsimp
apply (case_tac "xa = x", clarsimp) 
apply (subgoal_tac "y:DOM C")
prefer 2  apply (erule GETrSome_DOM)
apply (erule_tac x=y in allE, erule impE, clarsimp)
apply clarsimp
apply (erule_tac x=y in allE, erule impE, clarsimp)
apply (erule_tac x=Rxa in allE, clarsimp)
apply (erule impE, rule, fast)
apply (subgoal_tac "Rx \<subseteq> Rxa - {a}", fast)
apply (erule mRESULT_SOMEregion, assumption)
apply clarsimp
apply (erule_tac x=xa in allE, erule impE, clarsimp)
apply (erule reg_DOM)
apply clarsimp
apply (erule_tac x=xa in allE, erule impE, clarsimp)
apply (erule reg_DOM)
apply fast
done

lemma modified_ResR:
"\<lbrakk>GETr C y = Some (ResultET kN T kS); y \<notin> U; renv E y = Ref a; regionsExist (insert y (U - {x})) C h E;
  modified F U ((x,T)#C) h E\<lfloor>x:=h\<lfloor>a\<diamondsuit>R1\<rfloor>\<rfloor> hh\<rbrakk>
  \<Longrightarrow> modified F (insert y (U - {x})) C h E hh"
apply (simp add: modified_def regionsExist_def, safe)
apply (subgoal_tac "y:DOM C")
prefer 2  apply (erule GETrSome_DOM)
apply (erule_tac x=l in allE, erule impE, safe)
apply (case_tac "z=x", clarsimp)
apply (erule_tac x=y in allE, erule impE, clarsimp)
apply clarsimp
apply (erule_tac x=y in allE, erule_tac x=Rx in allE, erule impE, clarsimp)
apply (rule, assumption)
apply (subgoal_tac "Rz \<subseteq> Rx - {a}", fast)
apply (erule mRESULT_SOMEregion, assumption)
(*z \<noteq> x*)
apply clarsimp
apply (erule_tac x=z in allE,erule_tac x=Rz in allE, erule impE, clarsimp)
apply (rule,erule reg_DOM)
apply fast
apply fast
done

lemma Bounded_ResR:
"\<lbrakk>GETr C y = Some (ResultET kN T kS); y \<notin> U; renv E y = Ref a; regionsExist (insert y (U - {x})) C h E;
  Bounded R F U ((x,T)#C) h E\<lfloor>x:=h\<lfloor>a\<diamondsuit>R1\<rfloor>\<rfloor>\<rbrakk>
  \<Longrightarrow> Bounded R F (insert y (U - {x})) C h E"
apply (simp add: Bounded_def regionsExist_def)
apply (rule, rule)
apply (subgoal_tac "y:DOM C")
prefer 2  apply (erule GETrSome_DOM)
apply (erule_tac x=l in allE, erule impE, clarsimp)
apply (erule disjE, simp)
apply (rule disjI2, clarsimp)
apply (case_tac "xa=x")
apply (erule_tac x=y in allE, erule impE, clarsimp)
apply (rule_tac x=y in exI)
apply clarsimp
apply (rule_tac x=Rxa in exI,rule, rule_tac x=Sxa in exI, simp)
apply (subgoal_tac "Rx \<subseteq> Rxa - {a}", fast)
apply (erule mRESULT_SOMEregion, assumption)
(*xa \<noteq> x*)
apply (rule_tac x=xa in exI, simp add: DOM_def)
apply clarsimp
apply fast
done

lemma regionsExist_ResR2:
"\<lbrakk>GETr C x = Some (ResultET kN T kS); renv E x = Ref a; x \<in> U; regionsExist U C h E\<rbrakk>
       \<Longrightarrow> regionsExist U ((x,T)#C) h E\<lfloor>x:=h\<lfloor>a\<diamondsuit>R1\<rfloor>\<rfloor>"
apply (simp add: regionsExist_def,clarsimp)
apply (subgoal_tac "x: DOM C")
prefer 2 apply (erule GETrSome_DOM) 
apply (case_tac "xa = x",clarsimp)
    (*x = xa*) apply (erule_tac x=x in allE, clarsimp)
             apply (erule reg.elims, clarsimp+) apply fast
             apply (clarsimp+)
    (*x \<noteq> xa*) 
             apply (subgoal_tac "xa:DOM C",fast)
             apply (simp add: DOM_def)
done

lemma regionsDistinct_ResR2:
"\<lbrakk>GETr C x = Some (ResultET kN T kS); renv E x = Ref a; x \<in> U;regionsExist U C h E; regionsDistinct U C h E\<rbrakk>
 \<Longrightarrow> regionsDistinct U ((x,T)#C) h E\<lfloor>x:=h\<lfloor>a\<diamondsuit>R1\<rfloor>\<rfloor>"
apply (subgoal_tac "x: DOM C") prefer 2 apply (erule GETrSome_DOM)
apply (simp add: regionsDistinct_def, clarsimp) 
apply (case_tac "xa = x", clarsimp)
(*xa = x*) 
  apply (subgoal_tac "\<exists> R S . (RVal (renv E x), h, GETr C x, R, S) \<in> reg", clarsimp)
  prefer 2 apply (simp only: regionsExist_def) apply (erule_tac x=x in allE, erule impE,clarsimp,fastsimp)
  apply (erule_tac x=x in allE, rotate_tac -1, erule_tac x=xx in allE, rotate_tac -1, 
       erule_tac x=R in allE, rotate_tac -1, erule_tac x=Rxx in allE, erule impE, safe)
   apply (simp add: DOM_def)
   apply fastsimp
   apply fastsimp
   apply (subgoal_tac "Rx \<subseteq> R - {a}", fast)
   apply (erule mRESULT_SOMEregion, assumption)
(*xa \<noteq> x*) 
apply clarsimp
  apply (case_tac "xx=x",clarsimp)
  (*xx=x*)
  apply (subgoal_tac "\<exists> R S . (RVal (renv E x), h, GETr C x, R, S) \<in> reg", clarsimp)
  prefer 2 apply (simp only: regionsExist_def) apply (erule_tac x=x in allE, erule impE,clarsimp,fastsimp)
  apply (erule_tac x=xa in allE, rotate_tac -1, erule_tac x=x in allE, rotate_tac -1, 
       erule_tac x=Rx in allE, rotate_tac -1, erule_tac x=R in allE, erule impE, safe)
  apply (simp add: DOM_def)
  apply fastsimp
  apply fastsimp
  apply (subgoal_tac "Rxx \<subseteq> R - {a}", fast)
  apply (erule mRESULT_SOMEregion, assumption)
  (*xx=x*)
  apply (subgoal_tac "\<exists> R S . (RVal (renv E x), h, GETr C x, R, S) \<in> reg", clarsimp)
  prefer 2 apply (simp only: regionsExist_def) apply (erule_tac x=x in allE, erule impE,clarsimp,fastsimp)
  apply (erule_tac x=xa in allE, rotate_tac -1, erule_tac x=x in allE, rotate_tac -1, 
       erule_tac x=Rx in allE, rotate_tac -1, erule_tac x=R in allE, erule impE, safe)
  apply (simp add: DOM_def)
  apply fastsimp
  apply fastsimp
  apply (subgoal_tac "Rxx \<subseteq> R - {a}", fast)
  apply (erule mRESULT_SOMEregion, assumption)
  apply (erule_tac x=xa in allE, rotate_tac -1, erule_tac x=xx in allE, rotate_tac -1, 
       erule_tac x=Rx in allE, rotate_tac -1, erule_tac x=Rxx in allE, erule impE, safe)
   apply (simp add: DOM_def) 
   apply (erule reg_DOM)
   apply fastsimp
   apply fastsimp
   apply fast
done

lemma distinctFrom_ResR2:
"\<lbrakk>GETr C x = Some (ResultET kN T kS); renv E x = Ref a; x \<in> U; regionsExist U C h E; distinctFrom U C h E F\<rbrakk>
\<Longrightarrow> distinctFrom U ((x,T)#C) h E\<lfloor>x:=h\<lfloor>a\<diamondsuit>R1\<rfloor>\<rfloor> F"
apply (subgoal_tac "x:DOM C") prefer 2 apply (erule GETrSome_DOM)
apply (simp add: distinctFrom_def,clarsimp) 
apply (case_tac "xa = x",clarsimp)
(*x = xa*) 
  apply (subgoal_tac "\<exists> R S . (RVal (renv E x), h, GETr C x, R, S) \<in> reg", clarsimp)
  prefer 2 apply (simp only: regionsExist_def) apply (erule_tac x=x in allE, erule impE,clarsimp,fastsimp)
  apply (erule_tac x=x in allE, clarsimp)
  apply (erule_tac x=R in allE, erule impE,fast)
  apply (subgoal_tac "Rx \<subseteq> R - {a}", fast)
  apply (erule mRESULT_SOMEregion, assumption)
(*x \<noteq> xa*) 
  apply clarsimp
  apply (subgoal_tac "xa:DOM C",fast)
  apply (simp add: DOM_def)
done 

lemma modified_ResR2:
"\<lbrakk>GETr C x = Some (ResultET kN T kS); renv E x = Ref a; x \<in> U; regionsExist U C h E;
          modified F U ((x,T)#C) h E\<lfloor>x:=h\<lfloor>a\<diamondsuit>R1\<rfloor>\<rfloor> hh; R \<inter> FF = {}\<rbrakk>
       \<Longrightarrow> modified F U C h E hh"
apply (subgoal_tac "x:DOM C") prefer 2 apply (erule GETrSome_DOM)
apply (simp add: modified_def,clarsimp) 
apply (erule_tac x=l in allE, erule impE, safe)
apply (case_tac "z = x",clarsimp)
(*z = x*) 
  apply (subgoal_tac "\<exists> R S . (RVal (renv E x), h, GETr C x, R, S) \<in> reg", clarsimp)
  prefer 2 apply (simp only: regionsExist_def) apply (erule_tac x=x in allE, erule impE,clarsimp,fastsimp)
  apply (erule_tac x=x in allE, clarsimp)
  apply (erule_tac x=Ra in allE, erule impE,fast)
  apply (subgoal_tac "Rz \<subseteq> Ra - {a}", fast)
  apply (erule mRESULT_SOMEregion, assumption)
(*z \<noteq> x*) 
  apply clarsimp
  apply (subgoal_tac "z:DOM C",fast)
  apply (simp add: DOM_def)
done 

lemma Bounded_ResR2:
"\<lbrakk>GETr C x = Some (ResultET kN T kS); renv E x = Ref a; x \<in> U; regionsExist U C h E;
  Bounded R F U ((x,T)#C) h E\<lfloor>x:=h\<lfloor>a\<diamondsuit>R1\<rfloor>\<rfloor>\<rbrakk>
\<Longrightarrow> Bounded R F U C h E"
apply (subgoal_tac "x \<in> DOM C") prefer 2 apply (erule GETrSome_DOM)
apply (simp add: Bounded_def) 
apply (rule, rule)
apply (erule_tac x=l in allE, erule impE, clarsimp)
apply (erule disjE, simp)
apply (rule disjI2, clarsimp)
apply (case_tac "xa = x",clarsimp)
(*xa = x*) 
  apply (subgoal_tac "\<exists> R S . (RVal (renv E x), h, GETr C x, R, S) \<in> reg", clarsimp)
  prefer 2 apply (simp only: regionsExist_def) apply (erule_tac x=x in allE, erule impE,clarsimp,fastsimp)
  apply (rule_tac x=x in exI,clarsimp)
  apply (rule_tac x=Ra in exI)
  apply (rule, fast)
  apply (subgoal_tac "Rx \<subseteq> Ra - {a}", fast)
  apply (erule mRESULT_SOMEregion, assumption)
(*xa \<noteq> x*) 
  apply clarsimp 
  apply (subgoal_tac "xa:DOM C",fast)
  apply (simp add: DOM_def)
done 

lemma DA_C_Let_ResR: 
  "\<lbrakk>GETr C y = Some (ResultET kN T kS); nk = n+kS; 
    G \<rhd> e : \<lbrace>U, nk, (x,T)#C \<guillemotright> A, m\<rbrace>;
    y \<notin> U - {x}\<rbrakk>
 \<Longrightarrow> G \<rhd> (LET rf x = GetFr y R1 IN e END) : \<lbrace>(U-{x}) \<union> {y}, n, C \<guillemotright> A, m\<rbrace>"
apply (clarsimp,rule vdm_conseq, rule vdm_letr, rule vdm_getfr)
apply assumption
apply (rotate_tac 1, erule thin_rl, clarsimp)
apply (subgoal_tac "y:DOM C") prefer 2 apply (erule GETrSome_DOM)
apply (case_tac "y:U",clarsimp)
prefer 2 
(* y \<notin> U*)
  apply (simp add: DAssComplex_def, safe)
  apply (subgoal_tac "\<exists> R mm . (RVal (E\<lfloor>y\<rfloor>), h, Some (ResultET kN T kS), R, mm):reg", clarsimp) 
  prefer 2 apply (erule regionsExist_Lookup, fast, assumption)
  apply (subgoal_tac "\<exists> nn . (E, h, (insert y (U-{x}))-{y}, C, nn):ContextSize \<and> CS=mm+nn", clarsimp)
  prefer 2 apply (erule ContextSize_split, fast, simp add: GETr_def)
  apply (case_tac "x:U")
  (*x:U*) apply (subgoal_tac "(E\<lfloor>x:=h\<lfloor>a\<diamondsuit>R1\<rfloor>\<rfloor>, h, U-{x}, (x,T)#C, nn):ContextSize")
     prefer 2 apply (erule ContextSizePreservedU, simp)
              apply simp
     apply (erule_tac x=q in allE, erule_tac x="nn+(mm-kS)" in allE, erule_tac x=F in allE, erule impE, simp)
       apply (rule_tac x=N in exI, simp)
         apply (rule, erule regionsExist_ResR, assumption+)
         apply (rule, erule regionsDistinct_ResR, assumption+)
         apply (rule, erule distinctFrom_ResR, assumption+)
         apply (rule, erule ContextSizeCONS) apply simp apply (erule reg_R1_mRESULT)
           apply assumption apply simp
         apply (subgoal_tac "kS \<le> mm", clarsimp) apply (erule reg_ResultsizeSome)
       apply clarsimp 
    apply (rule_tac x=Ra in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
    apply (erule modified_ResR, assumption+)
    apply (erule Bounded_ResR, assumption+)
    apply (erule Bounded_ResR, assumption+)
  (*x\<notin>U*) apply (subgoal_tac "(E\<lfloor>x:=h\<lfloor>a\<diamondsuit>R1\<rfloor>\<rfloor>, h, U-{x}, (x,T)#C, nn) \<in> ContextSize")
          prefer 2 apply (erule ContextSizePreservedU) apply fastsimp
            apply fastsimp
          apply (erule_tac x=q in allE, erule_tac x=nn in allE, erule_tac x=F in allE, erule impE, simp)
            apply (rule_tac x=N in exI, simp) apply (rule, erule regionsExist_ResR,assumption+)
                                                apply (subgoal_tac "U-{x}=U",clarsimp,fast)
                                              apply (rule, erule regionsDistinct_ResR,assumption+)
                                                apply (subgoal_tac "U-{x}=U",clarsimp,fast)
                                                apply (subgoal_tac "U-{x}=U",clarsimp,fast)
                                              apply (rule, erule distinctFrom_ResR,assumption+)
                                                apply (subgoal_tac "U-{x}=U",clarsimp,fast)
                                                apply (subgoal_tac "U-{x}=U",clarsimp,fast)
                                              apply (subgoal_tac "kS \<le> mm",clarsimp)  apply (erule reg_ResultsizeSome)
          apply clarify
          apply (rule_tac x=Ra in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
          apply (erule modified_ResR, assumption+) 
          apply (erule Bounded_ResR, assumption+)
          apply (erule Bounded_ResR, assumption+)
(*y:U*)
apply (subgoal_tac "insert x (U - {x}) = U", clarsimp) prefer 2 apply fast
apply (subgoal_tac "x: DOM C")
prefer 2 apply (erule GETrSome_DOM)
apply (simp add: DAssComplex_def, safe)
apply (subgoal_tac "(\<exists> R S . (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, R, S) \<in> reg)", clarsimp) 
prefer 2 apply (erule ContextSize_regionsExist,fast)
apply (subgoal_tac "kS \<le> S") 
prefer 2  apply (erule reg_ResultsizeSome) 
apply (subgoal_tac "S \<le> CS")  
prefer 2 apply (rotate_tac 1, erule thin_rl, erule ContextSize_contains_region, assumption,simp add: GETr_def)
apply (subgoal_tac "(E\<lfloor>x:=h\<lfloor>a\<diamondsuit>R1\<rfloor>\<rfloor>, h, U, (x,T)#C, CS-kS) \<in> ContextSize")
prefer 2 apply (subgoal_tac "(E,h,U-{x},C,CS-S):ContextSize") prefer 2 apply(erule ContextSize_delete_Used) apply (assumption,simp)
         apply (rule ContextSizeCONS,assumption) apply (simp add: GETr_def) apply (erule reg_R1_mRESULT)
           apply (erule ContextSizePreservedU) apply simp
             apply (erule GETr_Update2,fast)
         apply simp
apply (erule_tac x=q in allE, erule_tac x="CS-kS" in allE, erule_tac x=F in allE, erule impE, clarsimp)
     apply (rule_tac x=N in exI, safe)
       apply (rule regionsExist_ResR2, assumption+)
       apply (rule regionsDistinct_ResR2, assumption+)
       apply (rule distinctFrom_ResR2, assumption+)
apply (rule_tac x=Ra in exI, rule_tac x=Sa in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
          apply (erule modified_ResR2, assumption+)
          apply (erule Bounded_ResR2, assumption+)
          apply (erule Bounded_ResR2, assumption+)
done
lemma DA_C_Let_resr: 
  "\<lbrakk>GETr C y = Some (ResultET kN T kS); nk = n+kS; y \<notin> U; 
    G \<rhd> e : \<lbrace>U, nk, (x,T)#C \<guillemotright> A, m\<rbrace>; UU=((U-{x}) \<union> {y})\<rbrakk>
 \<Longrightarrow> G \<rhd> (LET rf x = GetFr y R1 IN e END) : \<lbrace>UU, n, C \<guillemotright> A, m\<rbrace>"
by (rule vdm_conseq, rule DA_C_Let_ResR, auto)

lemma DA_C_ResultMatch: 
  "\<lbrakk>GETr C l = Some (ResultET kN TT kS); nk = n+kS; 
    G \<rhd> e : \<lbrace>U, nk, (t,TT)#C \<guillemotright> T, m\<rbrace>;
    l \<notin> U - {t}\<rbrakk>
 \<Longrightarrow> G \<rhd> (LET y = GetFi l V0; rf t = GetFr l R1 IN e END) : \<lbrace>(U-{t}) \<union> {l}, n, C \<guillemotright> T, m\<rbrace>"
apply (rule vdm_conseq)
apply (rule vdm_leti, rule vdm_getfi)
apply (rule DA_C_Let_ResR)
apply assumption+
apply (rotate_tac 2, erule thin_rl, clarsimp)
apply (simp add: DAssComplex_def, safe)
(*case l \<noteq> t*)
apply (erule_tac x=q in allE, erule_tac x=CS in allE, erule_tac x=F in allE, erule impE, clarsimp)
apply (rule_tac x=N in exI, safe)
apply (rule regionsExist1) apply (erule regionsExist_antimonotone) apply(fast, fast, simp, rule, simp)
apply (rule regionsDistinct1, erule regionsDistinct_antimonotone)  apply(fast, fast, simp, rule, simp)
apply (rule distinctFrom1, erule distinctFrom_antimonotone) apply(fast, fast, simp, rule, simp)
apply (erule ContextSizePreserved,simp) 
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (rule modified1)  apply(erule modified_monotone) apply(fast, fast, simp, rule, simp)
apply (rule Bounded1) apply(erule Bounded_monotone) apply(simp, simp, fast, fast, rule, simp)
apply (rule Bounded1) apply (rotate_tac -3) apply(erule Bounded_monotone) apply(simp, simp, fast, fast, rule, simp)
(*case l = t*)
apply (erule_tac x=q in allE, erule_tac x=CS in allE, erule_tac x=F in allE, erule impE, clarsimp)
apply (rule_tac x=N in exI, safe)
apply (erule regionsExist1) apply clarsimp+ apply (rule, simp)
apply (erule regionsDistinct1) apply clarsimp+ apply (rule, simp)
apply (erule distinctFrom1) apply clarsimp+ apply (rule, simp)
apply (erule ContextSizePreserved,simp) 
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (erule modified1) apply clarsimp+ apply (rule, simp) 
apply (erule Bounded1) apply clarsimp+ apply (rule, simp)
apply (erule Bounded1) apply clarsimp+ apply (rule, simp)
done

lemma DA_C_ResultMatchD: 
  "\<lbrakk>GETr C l = Some (ResultET kN TT kS); nk = n+kS+1; 
    G \<rhd> e : \<lbrace>U, nk, (t,TT)#C \<guillemotright> T, m\<rbrace>;
    l \<notin> U; l \<noteq> t\<rbrakk>
 \<Longrightarrow> G \<rhd> (LET y = GetFi l V0; rf t = GetFr l R1; _ = DIAM\<bullet>Free ([RNarg l]) IN e END) : \<lbrace>(U-{t}) \<union> {l}, n, C \<guillemotright> T, m\<rbrace>"
apply (rule vdm_conseq)
apply (rule vdm_leti, rule vdm_getfi)
apply (rule vdm_letr, rule vdm_getfr)
apply (rule vdm_letv)
apply (rule DA_Free1)
apply assumption
apply clarsimp 
  apply (rotate_tac 1, erule thin_rl)
  apply (subgoal_tac "l: DOM C")
  prefer 2 apply (erule GETrSome_DOM)
  apply (simp add: DAssComplex_def, safe)  
  apply (subgoal_tac "a \<notin> F")
  prefer 2  apply (rotate_tac 2, erule thin_rl) apply (simp add: distinctFrom_def) apply (erule_tac x=l in allE, erule impE, clarsimp)
                      apply (simp add: regionsExist_def) apply (erule_tac x=l in allE, erule impE, clarsimp)
                      apply clarsimp apply (erule_tac x=Rx in allE, erule impE,fast) 
                      apply (subgoal_tac "a:Rx", fast) apply(erule  Ref_reg, simp)
  apply (subgoal_tac "\<exists> n1 n2 . (E, h, {l}, C, n1) \<in> ContextSize \<and> (E, h, U-{t}, C, n2) \<in> ContextSize \<and> n1 + n2 = CS", clarsimp)
  prefer 2 apply (rotate_tac 2, erule thin_rl, erule ContextSize_SPLIT,fast,fast)
  apply (rotate_tac -2, erule ContextSize.elims) apply clarsimp apply clarsimp
  apply (rotate_tac -1, erule ContextSize.elims) apply clarsimp prefer 2 apply clarify
  apply (subgoal_tac "(RVal (h\<lfloor>a\<diamondsuit>R1\<rfloor>),h,Some TT, R-{a},na-kS):reg")
  prefer 2 apply (erule reg_R1_mRESULT)
  apply (subgoal_tac "freelist
                         (h\<lparr>rheap := (rheap h)(DOLLAR_N := (rheap h DOLLAR_N)(a := h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>)),
                               sheap := (sheap h)(DIAM := (sheap h DIAM)(DOLLAR_F := Ref a))\<rparr>)
                         (F \<union> {a}) (Suc N) \<and>
                        regionsExist U ((t,TT)#C)
                         (h\<lparr>rheap := (rheap h)(DOLLAR_N := (rheap h DOLLAR_N)(a := h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>)),
                               sheap := (sheap h)(DIAM := (sheap h DIAM)(DOLLAR_F := Ref a))\<rparr>)
                         E<y:=h<a\<bullet>V0>>\<lfloor>t:=h\<lfloor>a\<diamondsuit>R1\<rfloor>\<rfloor> \<and>
                        regionsDistinct U ((t,TT)#C)
                         (h\<lparr>rheap := (rheap h)(DOLLAR_N := (rheap h DOLLAR_N)(a := h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>)),
                               sheap := (sheap h)(DIAM := (sheap h DIAM)(DOLLAR_F := Ref a))\<rparr>)
                         E<y:=h<a\<bullet>V0>>\<lfloor>t:=h\<lfloor>a\<diamondsuit>R1\<rfloor>\<rfloor> \<and>
                        distinctFrom U ((t,TT)#C)
                         (h\<lparr>rheap := (rheap h)(DOLLAR_N := (rheap h DOLLAR_N)(a := h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>)),
                               sheap := (sheap h)(DIAM := (sheap h DIAM)(DOLLAR_F := Ref a))\<rparr>)
                         E<y:=h<a\<bullet>V0>>\<lfloor>t:=h\<lfloor>a\<diamondsuit>R1\<rfloor>\<rfloor> (F \<union> {a})")
  prefer 2  apply (rotate_tac 3, erule thin_rl, safe)
      apply (simp add: freelist_def) 
        apply (subgoal_tac "(Suc N, Ref a, F \<union> {a}, 
                             h\<lparr>rheap := (rheap h)(DOLLAR_N := (rheap h DOLLAR_N)(a := h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>)), 
                               sheap := (sheap h)(DIAM := (sheap h DIAM)(DOLLAR_F := Ref a))\<rparr>) \<in> FL", simp) 
        apply(rule FL_SUC) apply simp apply (erule Class_is_DIAM, simp+) apply (erule regionsExist_antimonotone,fast) apply simp+
             apply (erule FL_UpdateOutside) apply assumption
        apply (simp add: regionsExist_def, clarsimp)
             apply (case_tac "x=t")
             (*x=t*) apply clarsimp 
                     apply (rule, rule, rule reg_Preserved) apply simp
                     apply clarsimp apply (simp add: sameOH_def)
             (*x \<noteq> t*) apply clarsimp
                        apply (subgoal_tac "x:DOM C") prefer 2 apply (simp add: DOM_def) 
                        apply (erule_tac x=x in allE, clarsimp) 
                        apply (rule, rule, rule reg_Preserved, assumption) 
                        apply (subgoal_tac "la \<noteq> a", simp add: sameOH_def) 
                        apply (subgoal_tac "R \<inter> Rx = {}")
                        apply (subgoal_tac "a:R", fast) apply (erule Ref_reg, simp)
                        apply (simp add: regionsDistinct_def) 
                         apply (erule_tac x=l in allE, erule_tac x=x in allE, erule_tac x=R in allE, erule_tac x=Rx in allE, erule impE, clarsimp) 
                         apply (rule, fast) apply fastsimp apply simp 
        apply (simp add: regionsDistinct_def, clarsimp)
             apply (subgoal_tac "a:R") prefer 2 apply (erule Ref_reg, simp)
             apply (erule thin_rl)
             apply (case_tac "x=t")
             (*x=t*) apply clarsimp apply (subgoal_tac "xx: DOM C") prefer 2 apply (simp add: DOM_def) 
                     apply (subgoal_tac "\<exists> RR SS . (RVal (renv E xx), h, GETr C xx, RR, SS) \<in> reg ", clarsimp)
                     prefer 2 apply (simp add: regionsExist_def) 
                     apply (subgoal_tac "Rxx=RR \<and> Sxx=SS", clarsimp)
                     prefer 2 apply (erule reg_Unique) apply (rule reg_Preserved, assumption)
                              apply clarsimp apply (subgoal_tac "la \<noteq> a", simp add: sameOH_def)
                              apply (erule_tac x=l in allE, erule_tac x=xx in allE, erule_tac x=R in allE, erule_tac x=RR in allE, erule impE, clarsimp) 
                              apply(rule, fast) apply (rule, fast) apply fast
                              apply fast
                     apply (erule_tac x=l in allE, erule_tac x=xx in allE, erule_tac x=R in allE, erule_tac x=RR in allE, erule impE, clarsimp) 
                       apply(rule, fast) apply (rule, fast) apply fast
                       apply (subgoal_tac "Rx \<subseteq> R", fast)
                       apply (subgoal_tac "Rx = R-{a} \<and> Sx = na-kS", fast)
                       apply (erule reg_Unique) apply (rule reg_Preserved) apply simp apply clarsimp apply (simp add: sameOH_def)
             (*x\<noteq>t*) apply clarsimp 
                     apply (case_tac "xx=t")
                     (*xx=t*) apply clarsimp apply (subgoal_tac "x: DOM C") prefer 2 apply (simp add: DOM_def) 
                     apply (subgoal_tac "\<exists> RR SS . (RVal (renv E x), h, GETr C x, RR, SS) \<in> reg ", clarsimp)
                     prefer 2 apply (simp add: regionsExist_def) 
                     apply (subgoal_tac "Rx=RR \<and> Sx=SS", clarsimp)
                     prefer 2 apply (erule reg_Unique) apply (rule reg_Preserved, assumption)
                              apply clarsimp apply (subgoal_tac "la \<noteq> a", simp add: sameOH_def)
                              apply (erule_tac x=l in allE, erule_tac x=x in allE, erule_tac x=R in allE, erule_tac x=RR in allE, erule impE, clarsimp) 
                              apply(rule, fast) apply (rule, fast) apply fast
                              apply fast
                              apply (erule_tac x=l in allE, erule_tac x=x in allE, erule_tac x=R in allE, erule_tac x=RR in allE, erule impE, clarsimp) 
                       apply(rule, fast) apply (rule, fast) apply fast
                       apply (subgoal_tac "Rxx \<subseteq> R", fast)
                       apply (subgoal_tac "Rxx = R-{a} \<and> Sxx = na-kS", fast)
                       apply (erule reg_Unique) apply (rule reg_Preserved) apply simp apply clarsimp apply (simp add: sameOH_def)
                     (*xx\<noteq>t*) apply clarsimp
                       apply (subgoal_tac "xx:DOM C") prefer 2 apply (simp add: DOM_def)
                       apply (subgoal_tac "\<exists> RRR SSS . (RVal (renv E xx), h, GETr C xx, RRR, SSS) \<in> reg", clarsimp)
                       prefer 2 apply (simp add: regionsExist_def) 
                       apply (subgoal_tac "Rxx=RRR \<and> Sxx=SSS", clarsimp) 
                       apply (subgoal_tac "\<exists> RR SS . (RVal (renv E x), h, GETr C x, RR, SS) \<in> reg", clarsimp)
                       prefer 2 apply (simp add: regionsExist_def) apply (erule_tac x=x in allE, erule impE, simp add: DOM_def) apply fast
                       apply (subgoal_tac "Rx=RR \<and> Sx=SS", clarsimp) 
                       apply (erule_tac x=x in allE, erule_tac x=xx in allE, erule_tac x=RR in allE, erule_tac x=RRR in allE, erule impE)
                          apply simp apply (simp add: DOM_def) apply fastsimp
                          apply assumption
                       apply (erule reg_Unique) apply (rule reg_Preserved, assumption) apply clarsimp apply (subgoal_tac "la \<noteq> a", simp add: sameOH_def)    
                       apply (erule_tac x=x in allE, erule_tac x=l in allE, erule_tac x=RR in allE, erule_tac x=R in allE, erule impE)
                         apply (simp add: DOM_def) apply fastsimp 
                         apply fast
                       apply (erule reg_Unique) apply (rule reg_Preserved, assumption) apply clarsimp apply (subgoal_tac "la \<noteq> a", simp add: sameOH_def)    
                       apply (erule_tac x=xx in allE, erule_tac x=l in allE, erule_tac x=RRR in allE, erule_tac x=R in allE, erule impE)
                         apply (simp add: DOM_def) apply fastsimp 
                         apply fast
        apply (simp add: distinctFrom_def, clarsimp)
          apply (erule thin_rl)
             apply (subgoal_tac "a:R") prefer 2 apply (erule Ref_reg, simp)
             apply (case_tac "x=t")
             (*x=t*) apply clarsimp 
                     apply (subgoal_tac "Rx=R-{a} \<and> Sx=na-kS", clarsimp)
                     prefer 2 apply (erule reg_Unique) apply (rule reg_Preserved, assumption)
                              apply clarsimp apply (simp add: sameOH_def)
                     apply (erule_tac x=l in allE, clarsimp) apply fast
             (*x\<noteq>t*) apply clarsimp 
                     apply (subgoal_tac "x:DOM C") prefer 2 apply (simp add: DOM_def)
                     apply (subgoal_tac "\<exists> RRR SSS . (RVal (renv E x), h, GETr C x, RRR, SSS) \<in> reg", clarsimp)
                     prefer 2 apply (simp add: regionsExist_def) 
                     apply (subgoal_tac "R \<inter> RRR = {}")
                     prefer 2 apply (simp add: regionsDistinct_def) 
                              apply (erule_tac x=l in allE, erule_tac x=x in allE, erule_tac x=R in allE, erule_tac x=RRR in allE,erule impE,clarsimp,simp add: DOM_def,fastsimp)
                              apply assumption
                     apply (subgoal_tac "Rx=RRR \<and> Sx=SSS", fastsimp)
                     apply (erule reg_Unique) apply (rule reg_Preserved, assumption)
                       apply clarsimp apply (subgoal_tac "la \<noteq> a", simp add: sameOH_def) apply fast
  apply (subgoal_tac "a:R") prefer 2 apply (erule Ref_reg, simp)
  apply (case_tac "t:U")
  (*t:U*) 
    apply (subgoal_tac "kS \<le> na") prefer 2 apply (erule reg_ResultsizeSome)
    apply (erule_tac x=q in allE, erule_tac x="n2+na-kS" in allE, erule_tac x="F \<union> {a}"in allE, erule impE, clarsimp)
    apply (rule_tac x="Suc N" in exI, safe)
    apply (rotate_tac -7, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl) 
    apply (rule ContextSizeCONS, assumption) apply (simp add: GETr_def) apply (erule reg_Preserved) apply (clarsimp, simp add: sameOH_def)
      apply (rule ContextSizePreservedU) apply (erule SizePreserved_h_h1) apply (subgoal_tac "la \<noteq> a", simp add: sameOH_def)
        apply(simp add: regionsDistinct_def)
        apply (erule_tac x=l in allE, erule_tac x=x in allE, erule_tac x=R in allE, erule_tac x=Ra in allE, erule impE, clarsimp)
        apply (rule, erule reg_DOM) apply fastsimp apply fast
      apply simp
      apply clarsimp
      apply arith
    apply simp
  apply (rule_tac x=Ra in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)  
    apply (simp add: modified_def, clarsimp)
   apply (erule_tac x=la in allE, erule impE,clarsimp) 
     apply rule apply (erule_tac x=l in allE, erule_tac x=R in allE, clarsimp)
     apply clarsimp apply (case_tac "z=t")
                    (*z=t*) apply clarsimp apply (subgoal_tac "la \<notin> R") prefer 2 apply (erule_tac x=l in allE, erule_tac x=R in allE, erule impE,fastsimp) 
                            apply assumption
                            apply (subgoal_tac "Rz=R-{a} \<and> Sz = na-kS", fast)
                            apply (erule reg_Unique) apply (rule reg_Preserved) apply (simp add: GETr_def)
                            apply clarsimp apply (simp add: sameOH_def)
                    (*z\<noteq>t*) apply clarsimp apply (subgoal_tac "z:DOM C") prefer 2 apply (simp add: DOM_def)
                             apply (subgoal_tac "\<exists> RR SS . (RVal (renv E z), h, GETr C z,RR,SS):reg", clarsimp) 
                             prefer 2 apply (simp add: regionsExist_def) 
                             apply (subgoal_tac "la \<notin> RR") prefer 2 apply (erule_tac x=z in allE, erule_tac x=RR in allE, fastsimp)
                             apply (rotate_tac 15) apply( erule thin_rl , erule thin_rl , erule thin_rl , erule thin_rl) 
                             apply (subgoal_tac "Rz=RR \<and> Sz = SS", fast)
                             apply (rule reg_Unique, assumption) apply (rule reg_Preserved, assumption) 
                             apply (subgoal_tac "laa \<noteq> a", simp add: sameOH_def) 
                                 apply (simp add: regionsDistinct_def)
                                 apply (erule_tac x=l in allE, erule_tac x=z in allE, erule_tac x=R in allE, erule_tac x=RR in allE,erule impE,clarsimp, fast)
                                 apply fast
                             apply (rotate_tac 15) apply( erule thin_rl , erule thin_rl , erule thin_rl , erule thin_rl)
                             apply (subgoal_tac "la \<noteq> a", simp add: sameOH_def, safe)
                             apply (erule_tac x=rfield in allE) apply (case_tac "rfield = DOLLAR_N", clarsimp, clarsimp)
                             apply (subgoal_tac "a \<notin> R", fast)
                             apply (erule_tac x=l in allE, erule_tac x=R in allE, erule impE, clarsimp) apply fast apply assumption
    apply (simp add: Bounded_def,rule, rule) apply (erule_tac x=la in allE, erule impE, simp) 
     apply (erule disjE) apply (rotate_tac -5, erule thin_rl) apply (rule disjI2) 
       apply (rule_tac x=l in exI, simp)
       apply (rule_tac x=R in exI, rule, rule_tac x=na in exI, assumption+)
     apply (erule disjE,simp)
     apply (rule disjI2)
     apply clarsimp
     apply (case_tac "x=t")
     (*x=t*) apply (rotate_tac -9, erule thin_rl) apply (rotate_tac -11) apply(erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
             apply clarsimp apply (rule_tac x=l in exI, clarsimp)  
             apply (rule_tac x=R in exI, rule, fast)   
             apply (subgoal_tac "Rx=R-{a} \<and> Sx = na-kS", fast)
             apply (erule reg_Unique) apply (rule reg_Preserved) apply simp
             apply clarsimp apply (simp add: sameOH_def)
     (*x\<noteq>t*) apply (rotate_tac -9, erule thin_rl) apply (rotate_tac -11) apply(erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
             apply clarsimp apply (subgoal_tac "x:DOM C") prefer 2 apply (simp add: DOM_def)
             apply (subgoal_tac "\<exists> RR SS . (RVal (renv E x), h, GETr C x,RR,SS):reg", clarsimp) 
             prefer 2 apply (simp add: regionsExist_def)
             apply (subgoal_tac "Rx=RR \<and> Sx = SS", fast)
             apply (erule reg_Unique) apply (rule reg_Preserved, assumption) 
             apply clarsimp apply (subgoal_tac "laa \<noteq> a", simp add: sameOH_def) 
             apply (simp add: regionsDistinct_def)
             apply (erule_tac x=l in allE, erule_tac x=x in allE, erule_tac x=R in allE, erule_tac x=RR in allE,erule impE,clarsimp, fast)
             apply fast
    apply (simp add: Bounded_def,rule, rule) apply (rotate_tac -5, erule thin_rl)
      apply (rotate_tac -11, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl) 
      apply (erule_tac x=la in allE, erule impE, simp) 
      apply (erule disjE) apply (rule disjI2) 
        apply (rule_tac x=l in exI, simp, rule_tac x=R in exI, rule, rule_tac x=na in exI, assumption+) 
      apply (erule disjE,simp)
      apply (rule disjI2)
      apply clarsimp
      apply (case_tac "x=t")
      (*x=t*) apply clarsimp apply (rule_tac x=l in exI, clarsimp)  
              apply (rule_tac x=R in exI, rule, fast)   
              apply (subgoal_tac "Rx=R-{a} \<and> Sx = na-kS", fast)
              apply (erule reg_Unique) apply (rule reg_Preserved) apply simp
              apply clarsimp apply (simp add: sameOH_def)
     (*x\<noteq>t*) apply clarsimp apply (subgoal_tac "x:DOM C") prefer 2 apply (simp add: DOM_def)
             apply (subgoal_tac "\<exists> RR SS . (RVal (renv E x), h, GETr C x,RR,SS):reg", clarsimp) 
             prefer 2 apply (simp add: regionsExist_def)
             apply (subgoal_tac "Rx=RR \<and> Sx = SS", fast)
             apply (erule reg_Unique) apply (rule reg_Preserved, assumption) 
             apply clarsimp apply (subgoal_tac "laa \<noteq> a", simp add: sameOH_def)
             apply (simp add: regionsDistinct_def)
             apply (erule_tac x=l in allE, erule_tac x=x in allE, erule_tac x=R in allE, erule_tac x=RR in allE,erule impE,clarsimp, fast)
             apply fast
  (*t\<notin>U*) 
    apply (subgoal_tac "kS \<le> na") prefer 2 apply (erule reg_ResultsizeSome)
    apply (erule_tac x=q in allE, erule_tac x=n2 in allE, erule_tac x="F \<union> {a}"in allE, erule impE, clarsimp)
    apply (rule_tac x="Suc N" in exI, safe)
    apply (rotate_tac -7, erule thin_rl, erule thin_rl, erule thin_rl) 
      apply (rule ContextSizePreservedU) apply (erule SizePreserved_h_h1) apply (subgoal_tac "la \<noteq> a", simp add: sameOH_def)
        apply(simp add: regionsDistinct_def)
        apply (erule_tac x=l in allE, erule_tac x=x in allE, erule_tac x=R in allE, erule_tac x=Ra in allE, erule impE, clarsimp)
        apply (rule, erule reg_DOM) apply fastsimp apply fast 
      apply (subgoal_tac "x\<noteq> t",simp,fast)
      apply clarsimp
      apply arith
  apply (rule_tac x=Ra in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)  
    apply (simp add: modified_def, clarsimp) 
      apply (erule_tac x=la in allE, erule impE,clarsimp) 
     apply rule apply (erule_tac x=l in allE, erule_tac x=R in allE, clarsimp)
     apply clarsimp apply (case_tac "z=t")
                    (*z=t*) apply clarsimp apply (subgoal_tac "la \<notin> R") prefer 2 apply (erule_tac x=l in allE, erule_tac x=R in allE, erule impE,fastsimp) 
                            apply assumption
                    (*z\<noteq>t*) apply clarsimp apply (subgoal_tac "z:DOM C") prefer 2 apply (simp add: DOM_def)
                             apply (subgoal_tac "\<exists> RR SS . (RVal (renv E z), h, GETr C z, RR, SS) \<in> reg", clarsimp)
                             apply (erule_tac x=z in allE, erule_tac x=RR in allE, erule impE, clarsimp) apply fast
                             apply (subgoal_tac "Rz = RR \<and> Sz = SS",fast)
                             apply (erule reg_Unique)
                             apply (rule reg_Preserved, assumption)
                             apply clarsimp apply (subgoal_tac "laa \<noteq> a", simp add: sameOH_def)
                                 apply (simp add: regionsDistinct_def)
                                 apply (erule_tac x=l in allE, erule_tac x=z in allE, erule_tac x=R in allE, erule_tac x=RR in allE,erule impE,clarsimp)
                                 apply (rule, fast) apply fast
                                 apply fast
                             apply (simp add: regionsExist_def)
                             apply (subgoal_tac "la \<noteq> a", simp add: sameOH_def) apply clarsimp
                             apply (erule_tac x=rfield in allE) apply (case_tac "rfield = DOLLAR_N", clarsimp, clarsimp)
                             apply (subgoal_tac "la \<notin> R", fast)
                             apply (erule_tac x=l in allE, erule_tac x=R in allE, erule impE, clarsimp) apply fast apply assumption
    apply (simp add: Bounded_def,rule, rule) apply (erule_tac x=la in allE, erule impE, simp) 
     apply (erule disjE) apply (rotate_tac -5, erule thin_rl) apply (rule disjI2) 
       apply (rule_tac x=l in exI, simp)
       apply (rule_tac x=R in exI, rule, rule_tac x=na in exI, assumption+) 
     apply (erule disjE,simp)
     apply (rule disjI2)
     apply clarsimp
     apply (case_tac "x=t")
     (*x=t*) apply (rotate_tac -9, erule thin_rl) 
             apply (rotate_tac -11) apply(erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
             apply clarsimp 
     (*x\<noteq>t*) apply (rotate_tac -9, erule thin_rl) 
             apply (rotate_tac -11) apply(erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
             apply clarsimp apply (subgoal_tac "x:DOM C") prefer 2 apply (simp add: DOM_def)
             apply (subgoal_tac "\<exists> RR SS . (RVal (renv E x), h, GETr C x,RR,SS):reg", clarsimp) 
             prefer 2 apply (simp add: regionsExist_def)
             apply (subgoal_tac "Rx=RR \<and> Sx = SS", fast)
             apply (erule reg_Unique) apply (rule reg_Preserved, assumption) 
             apply clarsimp apply (subgoal_tac "laa \<noteq> a", simp add: sameOH_def) 
             apply (simp add: regionsDistinct_def)
             apply (erule_tac x=l in allE, erule_tac x=x in allE, erule_tac x=R in allE, erule_tac x=RR in allE,erule impE,clarsimp, fast)
             apply fast
    apply (simp add: Bounded_def,rule, rule) apply (rotate_tac -5, erule thin_rl)
      apply (rotate_tac -11, erule thin_rl, erule thin_rl, erule thin_rl)
      apply (erule_tac x=la in allE, erule impE, simp) 
      apply (erule disjE) apply (rule disjI2, clarsimp) 
        apply (rule_tac x=l in exI, simp, rule_tac x=R in exI, rule, rule_tac x=na in exI, assumption+) 
      apply (erule disjE,simp)
      apply (rule disjI2)
      apply clarsimp
      apply (subgoal_tac "x\<noteq>t")
        apply (subgoal_tac "x:DOM C") prefer 2 apply (simp add: DOM_def)
        apply (subgoal_tac "\<exists> RR SS . (RVal (renv E x), h, GETr C x,RR,SS):reg", clarsimp) 
        prefer 2 apply (simp add: regionsExist_def)
        apply (rule_tac x=x in exI, simp) apply(rule_tac x=RR in exI, rule, fast)
        apply (subgoal_tac "Rx=RR \<and> Sx = SS", fast)
        apply (erule reg_Unique) apply (rule reg_Preserved, assumption) 
        apply clarsimp apply (subgoal_tac "laa \<noteq> a", simp add: sameOH_def)
        apply (simp add: regionsDistinct_def)
        apply (erule_tac x=l in allE, erule_tac x=x in allE, erule_tac x=R in allE, erule_tac x=RR in allE,erule impE,clarsimp, fast)
        apply fast
      apply fast
done

lemma DA_C_MakeResultSome: 
"\<lbrakk>GETr C y = Some TT; TT = TreeET kL kN; T = (ResultET kN TT kS); n=(Suc m + kS)\<rbrakk> \<Longrightarrow>
  G \<rhd> (DIAM\<bullet>Make_IID ([VALarg (IVal 1), INarg x, RNarg y])) : \<lbrace>{y}, n, C \<guillemotright> T, m\<rbrace>"
apply (rule vdm_invokestatic, simp) 
apply (rule CtxtWeakSingleton)
apply (simp add: Meth_Make_IID DAssComplex_def, clarsimp)
apply (rule vdm_conseq, rule vdm_letr)
apply (rule DA_Alloc)
apply (rule DA_Fill_DIID)
apply clarsimp
apply (subgoal_tac "y:DOM C") prefer 2 apply (erule GETrSome_DOM)
apply (case_tac "h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>")
(*h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace> = Nullref*) apply clarsimp
  apply (simp add: freelist_def)
  apply (erule FL.elims, clarsimp)
  apply clarsimp
(*h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace> \<noteq> Nullref*) 
  apply clarsimp
  apply (simp add: freelist_def)
  apply (erule FL.elims, clarify, clarsimp)
  apply (simp add: regionsExist_def,clarsimp) 
  apply (rule_tac x="Rx \<union> {a}" in exI, rule_tac x="Sx+kS" in exI, rule_tac x=n in exI, rule_tac x="X" in exI, clarsimp)
  apply (rule, erule FL_Preserved) apply (simp add: sameOH_def) 
  apply (erule FRAME.elims, clarsimp+)
  apply (erule FRAME.elims, clarsimp+)
  apply (erule FRAME.elims, clarsimp+)
  apply (erule FRAME.elims, clarsimp+)
  apply (rule, simp add: distinctFrom_def) apply (erule_tac x=Rx in allE,erule impE,fast) apply clarsimp
    apply (erule reg.elims, simp_all, clarsimp) 
    apply (rule regResultSOME) apply (simp, simp, simp)
                               prefer 2 apply (rule regTree) apply (erule mTREE_Preserved) apply (subgoal_tac "l \<noteq> a", simp add: sameOH_def,fast)
                               apply simp apply simp apply simp apply simp 
  apply (rule, simp add: modified_def, clarsimp) apply (subgoal_tac "l \<noteq> a", simp add: sameOH_def,fast)
  apply (rule, simp add: distinctFrom_def) apply (erule_tac x=Rx in allE,erule impE,fast) apply clarsimp
  apply (rule,simp add: Bounded_def,rule, rule) apply (rule disjI2, rule disjI2) apply (rule, fast) 
  apply (rule,simp add: Bounded_def) 
  apply (subgoal_tac "Sx \<le> CS", clarsimp) apply (erule ContextSize_contains_region) apply simp apply fastsimp 
done

lemma DA_C_makeResultSome: 
"\<lbrakk>GETr C y = Some TT; TT = TreeET kL kN; T = (ResultET kN TT kS); n=(Suc m + kS); U={y}\<rbrakk> \<Longrightarrow>
  G \<rhd> (DIAM\<bullet>Make_IID ([VALarg (IVal 1), INarg x, RNarg y])) : \<lbrace>U, n, C \<guillemotright> T, m\<rbrace>"
by (rule vdm_conseq, rule DA_C_MakeResultSome,auto)
(*>*)

(*The rules for DAss are in TreeVCG*)

(*<*)
end
(*>*)
