theory Cachera = VDMSoundRecPC + TREELIST:

text {* Derived assertions implementing the Cachera analysis *}

section {* A logic on Grail level formalising the Cachera analysis *}

consts costtable :: "(funame \<Rightarrow> nat)"

subsection {* Semantic definition *}

constdefs DAssCachera :: "nat \<Rightarrow> vdmassn" ("\<lbrace> _ \<rbrace>C" 1000)
"DAssCachera m == (\<lambda> E h hh v p. HSize hh \<le> HSize h + (int m))"

subsection {* Logic *}

consts Cach :: "((expr \<times> nat) set \<times>  expr \<times> nat) set"
inductive Cach intros
C_Weak: "\<lbrakk> (G,e,n) \<in> Cach ; n \<le> m\<rbrakk> \<Longrightarrow> (G,e,m) \<in> Cach"
C_Ax: "(e, n) \<in> G \<Longrightarrow> (G, e, n) \<in> Cach" 
C_Int: "(G, expr.Int i, 0) \<in> Cach" 
C_IVar: "(G, IVar iname, 0) \<in> Cach"
C_RVar: "(G, RVar rname, 0) \<in> Cach" 
C_Primop: "(G, Primop f x y, 0) \<in> Cach"
C_RPrimop: "(G, RPrimop f x y, 0) \<in> Cach"
C_Getfi: "(G, GetFi rn fn, 0) \<in> Cach"
C_Getfr: "(G, GetFr rn fn, 0) \<in> Cach"
C_Getstat: "(G, GetStat cn fn, 0) \<in> Cach"
C_Putfi: "(G, PutFi x f y, 0) \<in> Cach"
C_Putfr: "(G, PutFr x f y, 0) \<in> Cach"
C_Putstat: "(G, PutStat cn fn rn, 0) \<in> Cach"
C_New: "(G, NEW <cn> (l1,l2), 1) \<in> Cach"
C_Letv: "\<lbrakk> (G,e1,m) \<in> Cach ; (G,e2,n) \<in> Cach; m' = m + n \<rbrakk> \<Longrightarrow> (G,Letv e1 e2, m') \<in> Cach"
C_Leti: "\<lbrakk> (G,e1,m) \<in> Cach ; (G,e2,n) \<in> Cach; m' = m + n \<rbrakk> \<Longrightarrow> (G, Leti x e1 e2, m') \<in> Cach"
C_Letr: "\<lbrakk> (G,e1,m) \<in> Cach ; (G,e2,n) \<in> Cach; m' = m + n \<rbrakk> \<Longrightarrow> (G, Letr x e1 e2, m') \<in> Cach"
C_If: "\<lbrakk> (G,e1,n) \<in> Cach ; (G,e2,n) \<in> Cach \<rbrakk> \<Longrightarrow> (G, IF x THEN e1 ELSE e2, n)\<in> Cach"
C_Call: "\<lbrakk> (G \<union> {(Call f, n)}, snd (funtable f), n) \<in> Cach \<rbrakk> \<Longrightarrow> (G, Call f, n) \<in> Cach"
C_Invs: "\<lbrakk> (G \<union> {(c\<bullet>mn(args), n)}, snd (methtable c mn), n) \<in> Cach \<rbrakk> \<Longrightarrow>
   (G, (c\<bullet>mn(args)), n) \<in> Cach"

subsection {* Soundness *}

constdefs mungeC :: "(expr \<times> nat) set \<Rightarrow> vdmcontext"
"mungeC G == { z . \<exists> e n . (e,n):G & z = (e,\<lbrace> n \<rbrace>C) }"

lemma D_Weak: "\<lbrakk>Ga \<rhd>  ea : \<lbrace> na \<rbrace>C ; na \<le> m\<rbrakk> \<Longrightarrow> Ga \<rhd> ea : \<lbrace> m \<rbrace>C"
apply (simp add: DAssCachera_def)
apply (rule vdm_conseq)
apply simp
apply clarsimp
done

lemma mungeC_hom_un: "mungeC (Ga \<union> {(CALL f, m)}) = (mungeC Ga) \<union> {(Call f, \<lbrace> m \<rbrace>C)}"
apply (simp add: mungeC_def DAssCachera_def)
apply (rule subset_antisym)
apply clarsimp
apply (rule_tac x="n" in exI)
apply clarsimp
apply clarsimp
apply (rule conjI)
apply (rule_tac x="m" in exI)
apply clarsimp
apply clarsimp
apply (rule_tac x="n" in exI)
apply clarsimp
done

lemma mungeC_hom_ins: "mungeC (insert (c\<bullet>mn(args), n) G) = insert (c\<bullet>mn(args), \<lbrace> n \<rbrace>C) (mungeC G) "
apply (simp add: mungeC_def DAssCachera_def)
apply (rule subset_antisym)
apply clarsimp
apply (rule_tac x="na" in exI)
apply clarsimp
apply clarsimp
apply (rule conjI)
apply (rule_tac x="n" in exI)
apply clarsimp
apply clarsimp
apply (rule_tac x="na" in exI)
apply clarsimp
done


(* ( \<forall> f.  \<rhd> Call f : \<lbrace> costtable f \<rbrace>C ) *)
lemma Cach_sound[rule_format]: "(G, e, n) \<in> Cach \<Longrightarrow> ( mungeC G \<rhd> e : \<lbrace> n \<rbrace>C )"
apply (rule Cach.induct) (* induct e) *)
apply simp
apply (drule D_Weak)
apply simp
apply simp
apply (simp add: mungeC_def DAssCachera_def) 
apply (rule vdm_ax)
apply clarsimp
apply (rule_tac x="na" in exI)
apply (clarsimp) 
apply (simp add: mungeC_def DAssCachera_def) apply (rule vdm_conseq) apply (rule vdm_basics) apply clarsimp
apply (simp add: mungeC_def DAssCachera_def) apply (rule vdm_conseq) apply (rule vdm_basics) apply clarsimp
apply (simp add: mungeC_def DAssCachera_def) apply (rule vdm_conseq) apply (rule vdm_basics) apply clarsimp
apply (simp add: mungeC_def DAssCachera_def) apply (rule vdm_conseq) apply (rule vdm_basics) apply clarsimp
apply (simp add: mungeC_def DAssCachera_def) apply (rule vdm_conseq) apply (rule vdm_basics) apply clarsimp
apply (simp add: mungeC_def DAssCachera_def) apply (rule vdm_conseq) apply (rule vdm_basics) apply clarsimp
apply (simp add: mungeC_def DAssCachera_def) apply (rule vdm_conseq) apply (rule vdm_basics) apply clarsimp
apply (simp add: mungeC_def DAssCachera_def) apply (rule vdm_conseq) apply (rule vdm_basics) apply clarsimp
apply (simp add: mungeC_def DAssCachera_def) apply (rule vdm_conseq) apply (rule vdm_basics) apply clarsimp
apply (simp add: mungeC_def DAssCachera_def) apply (rule vdm_conseq) apply (rule vdm_basics) apply clarsimp
apply (simp add: mungeC_def DAssCachera_def) apply (rule vdm_conseq) apply (rule vdm_basics) apply clarsimp
apply (simp add: mungeC_def DAssCachera_def) apply (rule vdm_conseq) apply (rule vdm_basics) apply clarsimp
apply (simp add: newObj_def)
prefer 2
(* Leti *)
apply (clarsimp)?
apply (rule vdm_conseq)
apply (rule vdm_leti)
(* apply (erule_tac x="Ga" in allE) *)
(* apply (erule_tac x="m" in allE) *)
apply simp
apply simp
apply clarify
apply (drule vdm_sound_ctxt)
apply (drule vdm_sound_ctxt)
apply (simp add: vdm_valid_def vdm_validn_def)
apply (simp add: DAssCachera_def)
(* Letv *)
(* Leti *)
apply (clarsimp)?
apply (rule vdm_conseq)
apply (rule vdm_letv)
(* apply (erule_tac x="Ga" in allE) *)
(* apply (erule_tac x="m" in allE) *)
apply simp
apply simp
apply clarify
apply (drule vdm_sound_ctxt)
apply (drule vdm_sound_ctxt)
apply (simp add: vdm_valid_def vdm_validn_def)
apply (simp add: DAssCachera_def)
(* Leti *)
apply (clarsimp)?
apply (rule vdm_conseq)
apply (rule vdm_letr)
(* apply (erule_tac x="Ga" in allE) *)
(* apply (erule_tac x="m" in allE) *)
apply simp
apply simp
apply clarify
apply (drule vdm_sound_ctxt)
apply (drule vdm_sound_ctxt)
apply (simp add: vdm_valid_def vdm_validn_def)
apply (simp add: DAssCachera_def)
(* If *)
apply (clarsimp)?
apply (rule vdm_conseq)
apply (rule vdm_if)
(* apply (erule_tac x="Ga" in allE) *)
(* apply (erule_tac x="m" in allE) *)
apply simp
apply simp
apply clarify
apply (drule vdm_sound_ctxt)
apply (drule vdm_sound_ctxt)
apply (simp add: vdm_valid_def vdm_validn_def)
apply (simp add: DAssCachera_def)
apply (case_tac "E<x>=1")
 apply clarsimp
 apply clarsimp
(* Call *)
apply (rule vdm_conseq)
apply (rule vdm_call)
apply (subgoal_tac "({(CALL f, \<lbrace> na \<rbrace>C)} \<union> mungeC Ga) \<rhd> snd (funtable f) : \<lbrace> na \<rbrace>C")
apply clarsimp
apply (rotate_tac -1)
apply (drule vdm_conseq)
prefer 2
apply simp
apply clarsimp
apply (simp add: DAssCachera_def)
apply (insert mungeC_hom_un)
apply simp
apply (simp add: DAssCachera_def)
(* InvokeStatic *)
apply (rule vdm_conseq)
apply (rule vdm_invokestatic)
apply (subgoal_tac "({(c\<bullet>mn(args), \<lbrace> na \<rbrace>C)} \<union> mungeC Ga) \<rhd>  snd (methtable c mn) : \<lbrace> na \<rbrace>C")
apply clarsimp
apply (rotate_tac -1)
apply (drule vdm_conseq)
prefer 2
apply simp
apply clarsimp
apply (simp add: DAssCachera_def)
apply simp
apply (simp add: DAssCachera_def)
apply (rotate_tac -1)
apply (insert mungeC_hom_ins)
apply simp
apply (simp add: DAssCachera_def)
apply (simp add: DAssCachera_def)
done

lemma C_Alloc: "G \<rhd> (DIAM\<bullet>Alloc([])) : \<lbrace> 1 \<rbrace>C"
apply (rule vdm_invokestatic, simp) 
(* apply (rule CtxtWeakSingleton) *)
apply (simp add: Meth_Alloc)
apply (rule vdm_conseq, rule vdm_letr, rule vdm_getstat)
apply (rule vdm_leti,rule vdm_rprim)
apply (rule vdm_if, rule vdm_new)
apply (rule Call1, simp add: Fun_AllocQ)
apply (rule vdm_letr, rule vdm_getfr)
apply (rule vdm_letv, rule vdm_putstat, rule vdm_rvar)
apply clarsimp 
(*apply (simp only: newObj_def newframe_env_def evalARGS_def) apply (simp add:self_def) apply clarsimp*)
apply (simp only: newObj_def) apply clarsimp 
apply (simp add: DAssCachera_def)
apply (case_tac "h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace> \<noteq> Nullref")
apply clarsimp
apply clarsimp
done

lemma C_Fill_DIID : "G \<rhd>  (DIAM\<bullet>Fill_DIID([RNarg x_, INarg tag_, INarg v0_, RNarg r1_])) : 
\<lbrace> 0 \<rbrace>C"
apply (rule vdm_invokestatic)
apply (simp add: Meth_Fill_DIID)
apply (rule CtxtWeakSingleton)
apply (rule vdm_conseq)
apply (rule vdm_letv, rule vdm_putfi)
apply (rule vdm_letv, rule vdm_putfi)
apply (rule vdm_letv, rule vdm_putfr)
apply (rule vdm_rvar,clarsimp)
apply (erule FRAME.elims, simp_all) apply clarsimp
apply (erule FRAME.elims, simp_all) apply clarsimp
apply (erule FRAME.elims, simp_all) apply clarsimp
apply (erule FRAME.elims, simp_all) apply clarsimp
apply (simp add: DAssCachera_def)
done

lemma C_MakeList:
" G \<rhd> (DIAM\<bullet>Make_IID ([VALarg (IVal 5), INarg x, RNarg y])) : \<lbrace> 1 \<rbrace>C"
apply (rule vdm_invokestatic, simp) 
(* apply (rule CtxtWeakSingleton) *)
apply (simp add: Meth_Make_IID)
apply (rule vdm_conseq, rule vdm_letr)
apply (insert C_Alloc)
apply fastsimp
apply (insert C_Fill_DIID)
apply fastsimp
apply clarify
apply (simp add: DAssCachera_def)
done

lemma C_sound[rule_format]: "\<lbrakk> G' = mungeC G ; (G, e, n) \<in> Cach\<rbrakk> \<Longrightarrow> ( G' \<rhd> e : \<lbrace> n \<rbrace>C )"
apply (drule Cach_sound)
apply clarsimp
done

lemmas C_leaf = C_Int C_IVar C_RVar C_Primop C_RPrimop C_Getfi C_Getfr C_Getstat C_Putfi C_Putfr C_Putstat C_New 
lemmas C_basics = C_Int C_IVar C_RVar C_Primop C_RPrimop C_Getfi C_Getfr C_Getstat C_Putfi C_Putfr C_Putstat C_New C_Letv C_Leti C_Letr C_If 
lemmas C_struct = C_Weak C_Ax 
lemmas C_all = C_Weak C_Ax C_Int C_IVar C_RVar C_Primop C_RPrimop C_Getfi C_Getfr C_Getstat C_Putfi C_Putfr C_Putstat C_New C_Letv C_Leti C_Letr C_If C_Call C_Invs 

end