(*<*)
theory LengthNIL = DerivedAssertions:
(*>*)

subsection{*Two list-length functions using the space-saving list representation*}

text {* Camelot code:
\begin{verbatim}
type ilist = !Nil | Cons of int * ilist
let len l = match l with Nil => 0 | Cons(h,t) => (len t) + 1
let length l n = match l with Nil => n | Cons(h,t) => length t (n+1)
\end{verbatim}

Grail code:
\begin{verbatim}
method public static int length (TreeListNIL$dia_0 l, int n) =
   let fun f:length(TreeListNIL$dia_0 l, int n) =
          if l = null[TreeListNIL$dia_0]
          then f:0(n)
          else f:1(l, n)
       fun f:1(TreeListNIL$dia_0 l, int n) =
       let val v2 = getfield l <int TreeListNIL$dia_0.f0>
           val v3 = getfield l <TreeListNIL$dia_0 TreeListNIL$dia_0.f1>
           val v2 = add n 1
       in invokestatic <int TreeListNIL.length (TreeListNIL$dia_0, int)> (v3, v2)
       end

       fun f:0(int n) = n
   in f:length(l, n)
   end

method public static int len (TreeListNIL$dia_0 l) =
   let fun f:len(TreeListNIL$dia_0 l) =
         if l = null[TreeListNIL$dia_0]
         then f:0()
         else f:1(l)

       fun f:1(TreeListNIL$dia_0 l) =
       let val v1 = getfield l <int TreeListNIL$dia_0.f0>
           val v2 = getfield l <TreeListNIL$dia_0 TreeListNIL$dia_0.f1>
           val v1 = invokestatic <int TreeListNIL.len (TreeListNIL$dia_0)> (v2)
       in add v1 1
       end

       fun f:0() = 0
   in f:len(l)
   end
\end{verbatim}
*}

syntax b_  :: iname
       v2_  :: iname 
       v3_  :: rname
       one_ :: iname
       l_  :: rname 
       n_  :: iname 

       fLength :: funame
       fzeroLength :: funame
       foneLength  :: funame
       Length :: mname


translations
 "b_" == "(In ''b'') "
 "v2_" == "(In ''v2'') "
 "v3_" == "(RN ''v3'') "
 "l_" == "(RN ''l'') "
 "n_" == "(In ''n'') "
 "one_" == "(In ''one'') "
 "fLength" == "(FN ''fLength'') "
 "fzeroLength" == "(FN ''f_zeroLength'')"
 "foneLength" == "(FN ''f_oneLength'')"
 "Length" == "(MN ''Length'')"

axioms Meth_Length: 
"methtable DIAM Length = ([RNpar l_, INpar n_], CALL fLength)"
lemma "methtable DIAM Length = ([RNpar l_, INpar n_], CALL fLength)" by (simp add: Meth_Length)

axioms Fun_fLength:
"funtable fLength = LET b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) l_ l_
                    IN IF b_ THEN CALL fzeroLength ELSE CALL foneLength END"
lemma "funtable fLength = LET b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) l_ l_
                    IN IF b_ THEN CALL fzeroLength ELSE CALL foneLength END"
by (simp add: Fun_fLength)

axioms Fun_foneLength:
"funtable foneLength =
       LET v2_ = GetFi l_ F0;
        rf v3_ = GetFr l_ F1;
          one_ = expr.Int 1;
           v2_ = Primop (\<lambda> x y . x + y) n_ one_
       IN DIAM\<bullet>Length ([RNarg v3_, INarg v2_]) END"
lemma "funtable foneLength =
       LET v2_ = GetFi l_ F0;
        rf v3_ = GetFr l_ F1;
          one_ = expr.Int 1;
           v2_ = Primop (\<lambda> x y . x + y) n_ one_
       IN DIAM\<bullet>Length ([RNarg v3_, INarg v2_]) END"
by (simp add: Fun_foneLength)

axioms Fun_fzeroLength:
"funtable fzeroLength = IVar n_"
lemma  "funtable fzeroLength = IVar n_"
by (simp add: Fun_fzeroLength)


text {*Here is what Steffen's analysis claims for the function length:
 \begin{verbatim}
   length : <0>, ilist[Nil(<0>)|Cons(int,#,<0>)] -> int -> int, <0>
 \end<verbatim} *}

text {*This corresponds to the following specification.
       Note that the context (second parameter of @{text DAss} is the context in which
       the method body may be typed, while the universally quantified actual arguments
       @{text l} and @{text n} are passed by value.*}
constdefs LengthSpec::bool
"LengthSpec == 
(MS DIAM Length = 
  (\<lambda> args E h hh v p. \<forall> l n . args = [l, n] \<longrightarrow> 
     (DAss 0 ([n_],[(l_,0)]) {l_} IntET 0 {} {l_}) (newframe_env Nullref [RNpar l_, INpar n_] [l,n] E) h hh v p))"

(*"\<forall>q CS. (\<lparr>ienv = emptyi, renv = emptyr(self := Nullref)\<rparr>\<lfloor>l_:=renv E v3_\<rfloor><n_:=ienv E v2_>, h, ([n_], [(l_, 0)]), CS)
                 \<in> ContextSize \<longrightarrow>
                 CS + q \<le> N \<longrightarrow> S + q \<le> M;
          (E, h, ([v2_], [(v3_, 0)]), CS) \<in> ContextSize; CS + q \<le> N\<rbrakk>
       \<Longrightarrow> S + q \<le> M*)

consts AdaptEnv :: "(env \<times> env \<times> PARAMTYPE \<times> ARGTYPE) set"
inductive AdaptEnv intros
AdaptEnv_NIL: "(E,EE,[],[]):AdaptEnv"
AdaptEnv_IN_IN: "\<lbrakk>E<x> = EE<y>; (E,EE,pars,args) : AdaptEnv\<rbrakk> \<Longrightarrow> (E, EE, (INpar x) # pars, (INarg y) # args): AdaptEnv"
AdaptEnv_IN_Val: "\<lbrakk>E<x> = i; (E,EE,pars,args) : AdaptEnv\<rbrakk> \<Longrightarrow> (E, EE, (INpar x) # pars, (VALarg (IVal i)) # args): AdaptEnv"
AdaptEnv_RN_RN: "\<lbrakk>E\<lfloor>x\<rfloor> = EE\<lfloor>y\<rfloor>; (E,EE,pars,args) : AdaptEnv\<rbrakk> \<Longrightarrow> (E, EE, (RNpar x) # pars, (RNarg y) # args): AdaptEnv"
AdaptEnv_RN_Val: "\<lbrakk>E\<lfloor>x\<rfloor> = r; (E,EE,pars,args) : AdaptEnv\<rbrakk> \<Longrightarrow> (E, EE, (RNpar x) # pars, (VALarg (RVal r)) # args): AdaptEnv"

lemma "(\<lparr>ienv = emptyi, renv = emptyr(self := Nullref)\<rparr>\<lfloor>l_:=renv E v3_\<rfloor><n_:=ienv E v2_>, 
         E, [RNpar l_,INpar n_],[RNarg v3_,INarg v2_]):AdaptEnv"
apply (rule AdaptEnv_RN_RN) apply simp
apply (rule AdaptEnv_IN_IN) apply simp
apply (rule AdaptEnv_NIL) 
done
 
consts RenameInContext:: "((iname \<Rightarrow> iname) \<times> (rname \<Rightarrow> rname) \<times> extContext \<times> extContext) set"
inductive RenameInContext intros
RenameInContextNIL:"(f, g, ([],[]), ([],[])):RenameInContext"
RenameInContextIn:"\<lbrakk>(f, g, (t,[]), (ts,R)):RenameInContext; D1 = (h # t,[]); D2 = ((f h) # ts,R)\<rbrakk> \<Longrightarrow> (f, g, D1 , D2) : RenameInContext"
RenameInContextRn:"\<lbrakk>(f, g, (C,t), (CC,ts)):RenameInContext; 
                    D1 = (C, (h,i) # t); 
                    D2 = (CC, (g h,i) # ts)\<rbrakk> \<Longrightarrow> (f, g, D1, D2) : RenameInContext"

lemma "(\<lambda> x . if x = v2_ then n_ else x, \<lambda> x. if x = v3_ then l_ else x, ( ([v2_],[(v3_,i)]), [n_],[(l_,i)])) : RenameInContext"
apply (rule RenameInContextRn) defer 1 apply fast apply fastsimp
apply (rule RenameInContextIn) defer 1 apply fast apply fastsimp
apply (rule RenameInContextNIL)
done

lemma RenameInContextEMPTY[rule_format]:"\<forall> f g a b . (f, g, (IC, []), a, b) \<in> RenameInContext \<longrightarrow> b = []"
by (clarsimp, induct IC, erule RenameInContext.elims, clarsimp+, erule RenameInContext.elims, clarsimp+)


lemma ContextSizeAdapt[rule_format]:
"\<forall> E EE h S IC f g. (E,h,(IC,RC),S):ContextSize \<longrightarrow> 
                  (\<forall> x . x : set IC \<longrightarrow> (EE<(f x)> = E<x> ) ) \<longrightarrow>
                  (\<forall> x . x : ContextRDom (IC,RC) \<longrightarrow> (E\<lfloor>x\<rfloor> = EE\<lfloor>(g x)\<rfloor> )) \<longrightarrow>
              (\<forall> D . (f,g,(IC,RC),D) : RenameInContext \<longrightarrow> (EE, h, D, S):ContextSize)"
apply clarsimp
apply (induct RC)
apply (erule ContextSize.elims, clarsimp) prefer 2 apply simp
  apply (subgoal_tac "b=[]", clarsimp) apply (rule ContextSizeNIL)
  apply (erule RenameInContextEMPTY)
apply (erule ContextSize.elims)
apply clarify
apply clarify
 apply (erule RenameInContext.elims)
 apply clarify
 apply clarify
 apply clarify
 apply (rule ContextSizeCONS)
  apply (erule thin_rl, erule thin_rl) apply (erule_tac x=hb in allE, erule impE) apply (simp add: ContextRDom_def)
  apply clarsimp apply assumption
apply (subgoal_tac "\<forall>x. x \<in> ContextRDom (C, ta) \<longrightarrow> renv Ea x = renv EE (ga x)", rotate_tac 2, erule thin_rl, erule thin_rl) 
prefer 2 apply (erule thin_rl, erule thin_rl, clarsimp) apply (erule_tac x=x in allE, erule impE) apply (simp add: ContextRDom_def)
  apply simp
apply blast
done

lemma RenameInContextEMPTY2[rule_format]:"\<forall> f g a b . (f, g, (a, b), IC, []) \<in> RenameInContext \<longrightarrow> b = []"
by (clarsimp, induct IC, erule RenameInContext.elims, clarsimp+, erule RenameInContext.elims, clarsimp+)

lemma ContextSizeAdapt2Aux[rule_format]:
"\<forall> E EE h CS IC D f g. (EE,h,(IC,RC),CS):ContextSize \<longrightarrow> 
                  (\<forall> x . x : set (fst D) \<longrightarrow> (EE<(f x)> = E<x> ) ) \<longrightarrow>
                  (\<forall> x . x : ContextRDom D \<longrightarrow> (E\<lfloor>x\<rfloor> = EE\<lfloor>(g x)\<rfloor> )) \<longrightarrow>
                  (f,g,D,(IC,RC)) : RenameInContext \<longrightarrow> (E, h, D, CS):ContextSize"
apply clarsimp
apply (induct RC)
apply (erule ContextSize.elims, clarify)
  apply (subgoal_tac "b=[]", clarsimp) apply (rule ContextSizeNIL)
  apply (erule RenameInContextEMPTY2)
apply clarify
apply clarify
apply (erule ContextSize.elims, clarify, clarify)
 apply (erule RenameInContext.elims, clarify)
apply clarify apply (subgoal_tac "(x, k) # t = []", clarify) apply (erule RenameInContextEMPTY)
apply clarify
apply (rule ContextSizeCONS)
apply (erule thin_rl, erule thin_rl) apply (erule_tac x=hb in allE, erule impE) apply (simp add: ContextRDom_def)
  apply clarsimp apply assumption
apply (subgoal_tac "(Ea, ha, (CC, ts), m) \<in> ContextSize \<and>  (\<forall>x. x \<in> set C \<longrightarrow> ienv Ea (fa x) = ienv E x) \<and> (\<forall>x. x \<in> ContextRDom (C, ta) \<longrightarrow> renv E x = renv Ea (ga x)) \<and> 
              (fa, ga, (C, ta), CC, ts) \<in> RenameInContext")
apply (rotate_tac 1, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl)
apply blast
apply (erule thin_rl, clarsimp)
apply (erule_tac x=x in allE, erule impE, simp add: ContextRDom_def, simp)
done

lemma ContextSizeAdapt2[rule_format]:
"\<forall> E EE h CS D f g. (EE,h,C,CS):ContextSize \<longrightarrow> 
                  (\<forall> x . x : set (fst D) \<longrightarrow> (EE<(f x)> = E<x> ) ) \<longrightarrow>
                  (\<forall> x . x : ContextRDom D \<longrightarrow> (E\<lfloor>x\<rfloor> = EE\<lfloor>(g x)\<rfloor> )) \<longrightarrow>
                 (f,g,D,C) : RenameInContext \<longrightarrow> (E, h, D, CS):ContextSize"
apply (rule allI)+
apply (rule impI)+
apply (rule ContextSizeAdapt2Aux)
apply (subgoal_tac "(EE, h, (fst C, snd C), CS) \<in> ContextSize", assumption) apply clarsimp
apply fast+
apply clarsimp
done


lemma ContextRDomMapAux[rule_format]:
"\<forall> D C f g x. x: ContextRDom D \<longrightarrow> D=(D1,D2) \<longrightarrow> (f, g, D, C) \<in> RenameInContext \<longrightarrow> z = g x \<longrightarrow> z : ContextRDom C"
apply (induct D2)
apply clarsimp
  apply (erule RenameInContext.elims, simp_all, clarsimp) apply (simp add: ContextRDom_def) 
  apply clarsimp apply (subgoal_tac "R=[]", simp add: ContextRDom_def) apply(erule RenameInContextEMPTY)
apply clarsimp
  apply (erule RenameInContext.elims, simp_all, clarsimp) 
  apply (simp add: ContextRDom_def) 
  apply (erule disjE) apply simp apply fast
done

lemma ContextRDomMap:
"\<lbrakk>X \<subseteq> ContextRDom D; (f, g, D, C) \<in> RenameInContext\<rbrakk> \<Longrightarrow>  g ` X \<subseteq> ContextRDom C"
apply rule
apply (subgoal_tac "\<exists> z . x = g z", clarsimp)
apply (rule ContextRDomMapAux) apply (subgoal_tac "xa : ContextRDom D", assumption) apply fast
apply (subgoal_tac "D = (fst D, snd D)", fastsimp+)
done

lemma ContextRDom_Triv: "xa \<in> ContextRDom (C, t) \<Longrightarrow> xa \<in> ContextRDom (C, (h, i) # t)"
by (simp add: ContextRDom_def)

text{*Is it better to require injectivity or typecorrectness???*}
constdefs RenamingInjective::"(rname set) \<Rightarrow> (rname \<Rightarrow> rname) \<Rightarrow> bool"
"RenamingInjective X g == (\<forall> x y . x:X \<longrightarrow> y:X \<longrightarrow> g x = g y \<longrightarrow> x = y)"
lemma RenamingTypeCorrectAux[rule_format]:
  "\<forall> f g x D1 C. (f,g,(D1,D2),C) : RenameInContext \<longrightarrow> x : ContextRDom (D1,D2) \<longrightarrow> RenamingInjective (ContextRDom (D1,D2)) g \<longrightarrow> GETr C (g x) = GETr (D1,D2) x"
apply clarsimp
apply (induct D2)
  apply (erule RenameInContext.elims, simp_all, clarsimp) apply (simp add: ContextRDom_def GETr_def)
  apply clarsimp apply (subgoal_tac "R=[]", simp add: ContextRDom_def) apply(erule RenameInContextEMPTY)
apply clarsimp
  apply (erule RenameInContext.elims, simp_all, clarsimp)
  apply (case_tac "x=h", clarsimp) 
    apply (simp add: ContextRDom_def GETr_def) 
  apply (subgoal_tac "x : ContextRDom (C,t)")
    apply (simp add: GETr_def)
    apply (subgoal_tac "ga x \<noteq> ga h", clarsimp) apply (rotate_tac 1, erule thin_rl) 
    apply (subgoal_tac "RenamingInjective (ContextRDom (C, t)) ga", erule thin_rl) apply fast
     apply (rotate_tac 5, erule thin_rl)
     apply (simp add: RenamingInjective_def, clarsimp) apply (erule_tac x=xa in allE, erule impE) apply (erule ContextRDom_Triv)
     apply (erule_tac x=y in allE, erule impE) apply (erule ContextRDom_Triv)
     apply clarsimp
    apply (simp add: RenamingInjective_def) apply (erule_tac x=x in allE, erule impE) apply (erule ContextRDom_Triv)
     apply (erule_tac x=h in allE, erule impE) apply ((erule thin_rl)+, simp add: ContextRDom_def)
     apply clarsimp
   apply (erule thin_rl, rotate_tac 1, erule thin_rl, erule thin_rl) apply (simp add: ContextRDom_def)
done

lemma RenamingTypeCorrect[rule_format]:
  "\<lbrakk>(f,g,D,C) : RenameInContext; x : ContextRDom D; RenamingInjective (ContextRDom D) g; a = g x \<rbrakk> \<Longrightarrow> GETr C a = GETr D x"
apply clarsimp
apply (subgoal_tac "GETr C (g x) = GETr (fst D,snd D) x", clarsimp)
apply (rule RenamingTypeCorrectAux)
apply (clarsimp, assumption)
apply clarsimp
apply clarsimp
done

lemma RenamingDomAux[rule_format]:
  "\<forall> f g x D1 C. ((f,g,(D1,D2),C) : RenameInContext \<longrightarrow> x : ContextRDom (D1,D2) \<longrightarrow> g x : ContextRDom C)"
apply clarsimp
apply (induct D2)
  apply (erule RenameInContext.elims, simp_all, clarsimp) apply (simp add: ContextRDom_def)
  apply clarsimp apply (subgoal_tac "R=[]", simp add: ContextRDom_def) apply(erule RenameInContextEMPTY)
apply clarsimp
  apply (erule RenameInContext.elims, simp_all, clarsimp) 
  apply (simp add: ContextRDom_def) 
  apply (erule disjE) apply auto
done

lemma RenamingDom:
  "\<lbrakk>(f,g,D,C) : RenameInContext; x : ContextRDom D; g x = a\<rbrakk> \<Longrightarrow> a : ContextRDom C"
apply clarsimp
apply (subgoal_tac "(f, g, (fst D, snd D), C) \<in> RenameInContext \<and> x : ContextRDom (fst D, snd D)")
apply (erule thin_rl, erule thin_rl, erule conjE)
apply (insert RenamingDomAux, fast) 
apply (rotate_tac 2, erule thin_rl, auto)
done

lemma RenamingInjective_Triv1:"\<lbrakk>RenamingInjective X g; x:X; y:X; g x \<noteq> g y\<rbrakk> \<Longrightarrow> x \<noteq> y"
by (unfold RenamingInjective_def, fast) 

lemma RenamingInjective_Triv2:"\<lbrakk>RenamingInjective X g; x:X; y:X; x \<noteq> y\<rbrakk> \<Longrightarrow> g x \<noteq> g y"
by (unfold RenamingInjective_def, fast) 

lemma DAss_Adapt: "\<lbrakk>DAss n D X T m Y Z E h hh v p; (f,g,D,C) : RenameInContext; gX = g`X; gY = g`Y; gZ = g`Z;
       (\<forall> x . x : set (fst D) \<longrightarrow> (EE<(f x)> = E<x> ) );
       (\<forall> x . x : ContextRDom D \<longrightarrow> (E\<lfloor>x\<rfloor> = EE\<lfloor>(g x)\<rfloor> ));
       RenamingInjective (ContextRDom D) g\<rbrakk>
      \<Longrightarrow> DAss n C gX T m gY gZ EE h hh v p"
apply (simp add: DAss_def, clarsimp)
apply (rule, rotate_tac 7, erule thin_rl) apply (erule ContextRDomMap, assumption)
apply (rule, rotate_tac 7, erule thin_rl) apply (erule ContextRDomMap, assumption)
apply (rule, rotate_tac 7, erule thin_rl) apply (erule ContextRDomMap, assumption)
apply (clarsimp)
apply (erule_tac x=F in allE, erule_tac x=N in allE, clarsimp)
apply (erule impE)
  apply (rule, clarsimp) apply (rotate_tac 2, erule_tac x=x in allE, clarsimp) apply (erule_tac x="g x" in allE) 
    apply (erule impE) apply (erule RenamingDom, assumption, simp) 
    apply (subgoal_tac "GETr C (g x) = GETr D x", clarsimp)
    apply (erule RenamingTypeCorrect, assumption, assumption, simp)
  apply (rule, clarsimp) apply (rotate_tac 9, erule_tac x="g x" in allE) apply (rotate_tac -1, erule_tac x="g xx" in allE) 
    apply (erule_tac x="Rx" in allE, erule_tac x="Rxx" in allE) 
    apply (erule impE) apply (erule thin_rl) apply (rotate_tac 6, erule thin_rl) 
      apply (subgoal_tac "renv E x = renv EE (g x)") prefer 2 apply (erule_tac x=x in allE, erule impE) apply (rotate_tac 5, erule thin_rl, fast) apply simp
      apply (subgoal_tac "renv E xx = renv EE (g xx)") prefer 2 apply (erule_tac x=xx in allE, erule impE) apply (rotate_tac 5, erule thin_rl, fast) apply simp
      apply rule apply fast
      apply rule apply fast
      apply rule apply (erule RenamingInjective_Triv2) apply fast apply fastapply assumption
      apply rule apply (rule_tac x=Sx in exI)
        apply (subgoal_tac "GETr C (g x) = GETr D x") apply (erule thin_rl, erule thin_rl) apply (rotate_tac 4, erule thin_rl) apply clarsimp
        apply (erule RenamingTypeCorrect, fast, assumption, simp)
      apply (rule_tac x=Sxx in exI)
        apply (subgoal_tac "GETr C (g xx) = GETr D xx") apply (erule thin_rl, erule thin_rl) apply (rotate_tac 4, erule thin_rl) apply clarsimp
        apply (erule RenamingTypeCorrect, fast, assumption, simp)
      apply simp
   apply clarsimp apply (rotate_tac 10, erule_tac x="g x" in allE) apply (rotate_tac -1, erule_tac x="Rx" in allE) 
    apply (erule impE) apply (rotate_tac -1, erule thin_rl)  apply (rotate_tac 3, erule thin_rl) 
      apply (subgoal_tac "renv E x = renv EE (g x)") prefer 2 apply (erule_tac x=x in allE, erule impE) apply (rotate_tac 5, erule thin_rl, fast) apply simp
      apply rule apply (erule RenamingDom, assumption, fast)
      apply (rule_tac x=Sx in exI)
        apply (subgoal_tac "GETr C (g x) = GETr D x") apply (erule thin_rl, erule thin_rl) apply (rotate_tac 4, erule thin_rl) apply clarsimp
        apply (erule RenamingTypeCorrect, fast, assumption, simp)
    apply simp
apply clarsimp
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, clarsimp)

apply rule apply (rotate_tac 9, erule thin_rl, erule thin_rl, clarsimp) apply (erule_tac x="x" in allE, rotate_tac -1, erule_tac x=Ry in allE)
  apply (erule impE, clarsimp) apply (rule_tac x= Sy in exI) apply (rotate_tac 2, erule thin_rl, rotate_tac 2, erule thin_rl, rotate_tac 2, erule thin_rl)
      apply (erule_tac x=x in allE, erule impE) apply (rotate_tac 5, erule thin_rl, fast)
      apply (subgoal_tac "GETr C (g x) = GETr D x") apply (rotate_tac 5, erule thin_rl) apply clarsimp
        apply (erule RenamingTypeCorrect, fast, assumption, simp) apply simp
apply rule apply (rotate_tac 8, erule thin_rl, erule thin_rl, erule thin_rl, clarsimp) apply (erule_tac x=l in allE, erule impE)
  apply rule apply simp apply clarsimp apply (rotate_tac -4, erule_tac x="g z" in allE, rotate_tac -1, erule_tac x=Rz in allE, erule impE)
  apply (rule, clarsimp) apply (rule_tac x= Sz in exI) apply (rotate_tac 5, erule thin_rl, rotate_tac 2, erule thin_rl, rotate_tac 2, erule thin_rl)
      apply (erule_tac x=z in allE, erule impE) apply (fast)
      apply (subgoal_tac "GETr C (g z) = GETr D z") apply clarsimp
        apply (erule RenamingTypeCorrect, fast, assumption, simp) apply simp
  apply simp
apply rule apply (rotate_tac 1, erule thin_rl, rotate_tac 6, erule thin_rl, erule thin_rl, erule thin_rl, clarsimp) 
           apply (rotate_tac 2, erule thin_rl, erule thin_rl) apply (rotate_tac 2, erule thin_rl) 
           apply (subgoal_tac "x :{l. \<exists>z. z \<in> Z \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr D z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)} ") 
           prefer 2 apply (rotate_tac 2, erule thin_rl, fast)
           apply clarsimp apply (rule_tac x="g z" in exI, rule) apply (rotate_tac 2, erule thin_rl, fast)
           apply(rule_tac x=Rz in exI, simp) apply (rule_tac x= Sz in exI) apply (erule_tac x=z in allE, erule impE) apply (fast)
           apply (subgoal_tac "GETr C (g z) = GETr D z") apply clarsimp
           apply (erule RenamingTypeCorrect, fast, assumption, simp) 
apply clarsimp
apply (rotate_tac -4, erule_tac x=q in allE, rotate_tac -1, erule_tac x=CS in allE, erule impE)
apply (erule ContextSizeAdapt2) apply (erule_tac x=x in allE, clarsimp) apply fast 
  apply (rotate_tac 4, erule_tac x=x in allE, clarsimp) apply fast 
  apply assumption 
apply simp 
done

text{*The following lemma is a form of adaptation, for the specific assertion needed in the lemma @{text LengthAux}.
  Probably the statement may be proven more generally for any two envoronments which agree on the domain of the context.
  The proof uses a similar property of ContextSize, which again can cries for a generalisation.*}
lemma LengthAdapt:
"DAss 0 ([n_], [(l_, 0)]) {l_} IntET 0 {} {l_} 
      \<lparr>ienv = emptyi, renv = emptyr(self := Nullref)\<rparr>\<lfloor>l_:=renv E v3_\<rfloor><n_:=ienv E v2_> h hh v p \<Longrightarrow>
 DAss 0 ([v2_], [(v3_, 0)]) {v3_} IntET 0 {} {v3_} E h hh v p"
apply (erule DAss_Adapt)
apply (subgoal_tac "(\<lambda> x . if x=n_ then v2_ else x, \<lambda> x . if x=l_ then v3_ else x, ([n_], [(l_, 0)]), [v2_], [(v3_, 0)]) \<in> RenameInContext", assumption)
apply (rule RenameInContextRn) prefer 2 apply simp apply (rule, simp) apply (rule, simp) apply (rule, simp) apply simp
                               prefer 2 apply simp apply (rule, simp) apply simp
apply (rule RenameInContextIn) prefer 2 apply simp apply (rule, simp) apply simp
                               prefer 2 apply simp apply (rule, simp) apply simp
apply (rule RenameInContextNIL) 
apply fastsimp
apply fastsimp
apply fastsimp
apply fastsimp
apply (simp add: ContextRDom_def)
apply (simp add: RenamingInjective_def ContextRDom_def)
done

(*This is an explicit proof of LengthAdapt which does not use injectivity)
lemma LengthAdapt:
"DAss 0 ([n_], [(l_, 0)]) {l_} IntET 0 {} {l_} 
      \<lparr>ienv = emptyi, renv = emptyr(self := Nullref)\<rparr>\<lfloor>l_:=renv E v3_\<rfloor><n_:=ienv E v2_> h hh v p \<Longrightarrow>
 DAss 0 ([v2_], [(v3_, 0)]) {v3_} IntET 0 {} {v3_} E h hh v p"
apply (simp add: DAss_def, clarsimp)
apply (rule, simp add: ContextRDom_def)
apply (rule, clarsimp)
apply (erule_tac x=F in allE, erule_tac x=N in allE, clarsimp)
apply (erule impE)
  apply (rule, clarsimp) apply (simp add: ContextRDom_def GETr_def)
  apply (simp add: ContextRDom_def GETr_def, clarsimp) 
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, clarsimp)
apply (simp add: GETr_def)
apply clarsimp
apply (rotate_tac -4, erule_tac x=q in allE, rotate_tac -1, erule_tac x=CS in allE, erule impE)
apply (erule ContextSizeAdapt)
apply (subgoal_tac "ienv \<lparr>ienv = emptyi, renv = emptyr(self := Nullref)\<rparr>\<lfloor>l_:=renv E v3_\<rfloor><n_:=ienv E v2_> ((\<lambda> x . if x = v2_ then n_ else x)x) = ienv E x", assumption) apply simp
apply (subgoal_tac "renv E x = renv \<lparr>ienv = emptyi, renv = emptyr(self := Nullref)\<rparr>\<lfloor>l_:=renv E v3_\<rfloor><n_:=ienv E v2_> ((\<lambda> x. if x = v3_ then l_ else x) x)", assumption) apply (simp add: ContextRDom_def)
apply (rule RenameInContextRn) prefer 2 apply (rule,simp)apply (rule,simp)apply (rule,simp)apply (rule,simp)apply (simp)
                               prefer 2 apply simp apply (rule,simp) apply simp
apply (rule RenameInContextIn) prefer 2 apply (rule,simp)apply (rule,simp)apply (simp)
                               prefer 2 apply simp apply (rule,simp) apply simp
apply (rule RenameInContextNIL) 
apply auto
  apply (erule ContextSize.elims, simp_all, clarsimp)
  apply (rule ContextSizeCONS, simp)
  apply (erule ContextSize.elims, simp_all, clarsimp)
  apply (rule ContextSizeNIL)
done
*)

text {*In order to prove the body correct we define a context which contains an assumption
       on the only syntactically occurring method call in the body.*}
constdefs LengthContext:: vdmcontext
"LengthContext \<equiv> {(DIAM\<bullet>Length([RNarg v3_, INarg v2_]), MS DIAM Length [RNarg v3_, INarg v2_])}"

text {*In this context, the body of @{text Length} may indeed be shown to satisfy its specification.*}
lemma Length_Aux:
"\<lbrakk>LengthSpec; G = LengthContext\<rbrakk> \<Longrightarrow>
  G \<rhd> snd (methtable DIAM Length) : 
                    (\<lambda>E h hh v p. \<forall>E'. E = newframe_env Nullref (fst (methtable DIAM Length)) x E' \<longrightarrow>
                                       MS DIAM Length x E' h hh v
                                          (mkRescomp (3 + clock p) (callc p) (1 + invkc p) (Suc (invkdpth p))))"
apply (simp add: Meth_Length)
apply (rule vdm_conseq)
apply (rule Call1)
apply (simp add: Fun_fLength)
apply (rule DA_Let_RPrim)
prefer 2 apply (subgoal_tac "GETr ([n_],[(l_,0)]) l_ = Some (ListET 0)", assumption) apply (simp add: GETr_def)
apply (rule ContextUNION) apply simp apply (simp add: ContextRDom_def) apply (simp add: GETr_def)
apply (rule vdm_conseq)
apply (rule vdm_if)
apply (rule Call1)
apply (rule DA_Weaken)
apply (simp only: Fun_fzeroLength)
apply (rule DA_IVar)
apply (subgoal_tac "(([n_],[]),([b_],[(l_,0)]),?C9): ContextUnion", assumption)
apply (rule ContextUNION) apply simp apply (simp add: ContextRDom_def)
apply (rule Call1)
apply (rule DA_Weaken)
apply (simp only:  Fun_foneLength)
apply (rule DA_Let_HD)
prefer 2 apply (subgoal_tac "GETr ([n_],[(l_,0)]) l_ = Some (ListET 0)", assumption) apply (simp add: GETr_def)
apply (rule ContextUNION) apply simp apply (simp add: ContextRDom_def) 
apply (rule DA_Weaken) prefer 2 apply (rule ContextUNION) apply simp apply (simp add: ContextRDom_def)
apply (rule DA_Let_TL) 
apply (subgoal_tac "(([n_],[]), ([], [(l_, 0)]), (fst ([n_],[]) @ fst ([],[(l_, 0)]), snd ([n_],[]) @ snd ([],[(l_, 0)]))) \<in> ContextUnion", simp)
apply (rule ContextUNION) apply simp apply (simp add: ContextRDom_def) 
apply (rule ContextUNION) apply simp apply (simp add: ContextRDom_def) apply (simp add: GETr_def)
apply (rule DA_Leti)
prefer 6 apply simp apply (rule DA_Int)
apply (subgoal_tac "(([n_],[(v3_,0)]), ([one_], []), ?C25) \<in> ContextUnion", simp)
apply (rule ContextUNION) apply simp apply (simp add: ContextRDom_def) 
apply simp apply (subgoal_tac "(([], []), ([n_], [(v3_, 0)]), ?X) \<in> ContextUnion")
           prefer 2 apply (rule ContextUNION) apply simp apply (simp add: ContextRDom_def) 
           apply simp
apply (simp add: ContextRDom_def)
apply (simp add: ContextRDom_def)
apply (simp add: ContextRDom_def)
apply (rule DA_Leti)
prefer 6 apply simp apply (rule DA_Prim)
apply (subgoal_tac "(([],[(v3_,0)]), ([v2_], []), ?C60) \<in> ContextUnion")
prefer 2 apply (rule ContextUNION) apply simp apply (simp add: ContextRDom_def)
apply simp
apply simp 
apply (subgoal_tac "(([n_, one_], []), ([], [(v3_, 0)]), ?X) \<in> ContextUnion")
prefer 2 apply (rule ContextUNION) apply simp apply (simp add: ContextRDom_def)
apply simp 
apply (simp add: ContextRDom_def)
apply (simp add: ContextRDom_def)
apply (simp add: ContextRDom_def)
apply (rule vdm_conseq)
apply (rule vdm_ax, simp)
apply (simp add: LengthContext_def)
apply (simp add: LengthSpec_def, clarsimp, erule thin_rl) (*1*) apply (simp add: newframe_env_def evalARGS_def) defer 1
apply (subgoal_tac "(([n_], [(l_, 0)]), ([b_],[]), ?C24) \<in> ContextUnion", assumption)
apply (rule ContextUNION) apply simp apply (simp add: ContextRDom_def)
apply clarsimp
apply (erule disjE)
apply clarsimp apply (rule DAss_PConst)
prefer 2 apply clarsimp apply (rule DAss_PConst) apply (simp add: ContextRDom_def)
apply (erule DAss_Generalise) apply (simp, simp, simp, simp, simp add: ContextRDom_def, simp)
apply (simp add: LengthSpec_def newframe_env_def evalARGS_def) apply clarsimp apply (erule thin_rl) apply (erule DAss_PConst) 
apply (erule LengthAdapt)
done

text {*Hence, \verb|LengthContext| is good.*}
lemma LengthContext_good: 
"LengthSpec \<Longrightarrow> goodContext LengthContext"
apply (simp add: goodContext_def LengthContext_def) apply safe
apply (erule Length_Aux)
apply (simp add: LengthContext_def)
done

text {*Consequently, a invocation with arbitrary parameters satisfies its 
       specification in the empty context.*}
theorem "LengthSpec \<Longrightarrow> \<rhd> DIAM\<bullet>Length([RNarg l, INarg n]): MS DIAM Length [RNarg l, INarg n]"
apply (rule GC)
apply (erule LengthContext_good)
apply (simp_all add: InvContext_def LengthContext_def, auto)
done 
end
