theory InsSortProof = InsSort:

text {*Result of lfg-infer -olhs 4:
 \begin{verbatim}
  ins        : 1, int -> iList[0|int,#,0] -> iList[0|int,#,0], 0
  sort       : 0, iList[0|int,#,0] -> iList[0|int,#,0], 0
 \end<verbatim} *}


(* should be sowhere else *)

lemmas get_dom_defs = GETr_def DOM_def
declare get_dom_defs [simp]

lemma DA_Call2:
"\<lbrakk>G \<rhd> (funtable f) : DAss U n C T m\<rbrakk> \<Longrightarrow>
           G \<rhd> (CALL f) : DAss U n C T m"
apply (rule DA_Call)
apply(drule  CtxtWeakSingleton)
apply (auto)
done 


lemmas DA_intros =  DA_Null DA_Int  DA_Call2 DA_Let_RPrim DA_Let_Prim DA_If  
                   DA_Make_IID DA_MatchD  DA_Letr



constdefs Ins_Spec::vdmassn
"Ins_Spec == DAss {l_} 1 (emptyfinmap(l_ \<mapsto>\<^sub>f(ListET 0))) (ListET 0) 0"
constdefs Sort_Spec::vdmassn
"Sort_Spec == DAss {l_} 0 (emptyfinmap(l_ \<mapsto>\<^sub>f(ListET 0))) (ListET 0) 0"


lemmas daspec_simp =  Ins_Spec_def  Sort_Spec_def

text {*In order to prove the body correct we define a context which contains an single entry for each method.*}
constdefs  InsSortContext:: vdmcontext
"InsSortContext \<equiv> {(DIAM\<bullet>Ins([INarg a_,RNarg l_]), Ins_Spec), (DIAM\<bullet>Sort([RNarg l_]), Sort_Spec)}"


lemmas context_simp = InsSortContext_def

lemma Ins_DAss:
"\<lbrakk>G = InsSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable DIAM Ins) : Ins_Spec"
apply (simp only: meth_simp daspec_simp, clarify)
apply (rule DA_Weak)
apply ((rule DA_intros) | simp)+
apply (simp_all (no_asm) )
(*first branch*)
defer 1
(*invocation of make*)
apply ((rule DA_intros) | simp)+
(*invocation of ins*)
apply (rule ADAPT)
  (*lookup from context*)
  apply (simp add: context_simp daspec_simp) apply (rule,simp+)
  (*calculation of renaming*)
 apply (fast intro:getRenaming.intros)
  (*verify that context at applications site arises from context in
    specification via the renaming*)
  apply (rule RenContextCONS,fastsimp) 
    apply (simp)+
  apply (rule RenContextNIL) 
  (*the last side condition of ADAPT*)
  apply simp 
(*invocation of ins now finished*) 
(*invocation of make*)
apply ((rule DA_intros) | simp)+
apply auto
done

lemma Sort_DAss:
"\<lbrakk>G = InsSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable DIAM Sort) : Sort_Spec"
apply (simp only: meth_simp daspec_simp, clarsimp)
apply (rule DA_Weak)
apply ((rule DA_intros) | simp)+
(*invocation of sort*)
apply (rule ADAPT)
  (*lookup from context*)
  apply (simp add: context_simp daspec_simp) 
apply (rule,simp+)
  (*calculation of renaming*)
 apply (fast intro:getRenaming.intros)
  (*verify that context at applications site arises from context in
    specification via the renaming*)
  apply (rule RenContextCONS,fastsimp) 
    apply (simp)+
  apply (rule RenContextNIL) 
  (*the last side condition of ADAPT*)
  apply simp 
(*invocation of sort now finished*) 
(*invocation of ins*)
apply (rule ADAPT)
  (*lookup from context*)

  apply (simp add: context_simp daspec_simp) 
apply (rule,simp+)
  (*calculation of renaming*)
 apply (fast intro:getRenaming.intros)
  (*verify that context at applications site arises from context in
    specification via the renaming*)
  apply (rule RenContextCONS,fastsimp) 
    apply (simp)+
  apply (rule RenContextNIL) 
  (*the last side condition of ADAPT*)
  apply auto

done

text {*We require the specification table at method @{text Ins} to
contain entries
       which relate to the assertion @{text Ins_Spec}, and at method
       @{text Sort} to contain entries
       which relate to the assertion @{text Sort_Spec}.*}
constdefs InsSortTable::bool
"InsSortTable == 
  (MS DIAM Ins = (\<lambda> args E h hh v p . Ins_Spec (newframe_env Nullref (fst (methtable DIAM Ins)) args E) h hh v p)) \<and> 
  (MS DIAM Sort = (\<lambda> args E h hh v p . Sort_Spec (newframe_env Nullref (fst (methtable DIAM Sort)) args E) h hh v p))"


lemmas table_simp = InsSortTable_def

lemma Ins_Spec_Framecorrect: "InsSortTable \<Longrightarrow> MS DIAM Ins [INarg a_, RNarg l_] = Ins_Spec"
apply (simp add: table_simp meth_simp newframe_env_def evalARGS_def daspec_simp)
apply (force intro!: DAss_Envs_same_on_U intro:ext)
done

lemma Sort_Spec_Framecorrect: "InsSortTable \<Longrightarrow> MS DIAM Sort [RNarg l_] = Sort_Spec"
apply (simp add: table_simp meth_simp newframe_env_def evalARGS_def daspec_simp)
apply (force intro!: DAss_Envs_same_on_U intro:ext)
done

text{*The proofs use lemma @{text DAss_Envs_same_on_U}*}

text {*For a specification table satisfying InsSortTable, \verb|InsSortContext| is a good context.*}
lemma InsSortContext_good: "InsSortTable \<Longrightarrow> goodContext InsSortContext"
apply (simp add: goodContext_def context_simp)
(*Ins*)
apply safe
apply (simp add:  Ins_Spec_Framecorrect)+
apply (rule vdm_conseq)
apply (rule Ins_DAss)
apply (simp add: context_simp  table_simp daspec_simp)+
apply (blast intro:DAss_PConst)
apply (simp add: daspec_simp)
(*Sort*)
apply (simp add:  Sort_Spec_Framecorrect daspec_simp)
apply (rule vdm_conseq)
apply (rule Sort_DAss)
apply (simp add: context_simp)
apply clarify
apply (simp add: table_simp daspec_simp)
apply (blast intro:DAss_PConst)
done


text {*Thus, we can prove that arbitrary invocations of @{text Ins} and  @{text Sort} honour
       their entries in the specification table, in the empty VDM context.*}
theorem "\<lbrakk>InsSortTable\<rbrakk> \<Longrightarrow> \<rhd> DIAM\<bullet>Ins([RNarg x, RNarg y]): MS DIAM Ins [RNarg x, RNarg y]"
apply (rule GCInvs)
apply (erule InsSortContext_good)
apply (simp_all add: context_simp)
apply (auto)
apply (simp only:Ins_Spec_Framecorrect)
done 
theorem "\<lbrakk>InsSortTable\<rbrakk> \<Longrightarrow> \<rhd> DIAM\<bullet>Sort([RNarg x]): MS DIAM Sort [RNarg x]"
apply (rule GCInvs)
apply (erule InsSortContext_good)
apply (simp_all add: context_simp)
apply (auto)
apply (simp only: Sort_Spec_Framecorrect)
done 


declare fun_simp [simp del]
declare get_dom_defs [simp del]
end
