header {*Axiomatic semantics*}
(*<*)
theory VDMpc = Lemmas:
(*>*)

(*consts all_classes :: "cname set"

axioms finclasses: "\<forall> (C::cname). C \<in> all_classes \<and> finite all_classes"
*)

subsection {* The derivation system*}

types "vdmassn" = "[env,  heap,  heap,  val,  rescomp] \<Rightarrow> bool"

types vdmtuple = " expr \<times> vdmassn"

types vdmcontext = " vdmtuple set"

consts vdm_proof :: "( vdmcontext \<times>  vdmtuple) set"

syntax vdm_deriv :: " vdmcontext \<Rightarrow>  expr \<Rightarrow> vdmassn \<Rightarrow> bool"
		  ("_ \<rhd>  _ : _ " [900,100,100] 50)

translations "G \<rhd> e : P" == "(G,e,P) \<in> vdm_proof"

syntax vdm_emptyctx :: " expr \<Rightarrow> vdmassn \<Rightarrow> bool" ("\<rhd> _ : _ " 40)
translations "\<rhd> e : P " == "{} \<rhd> e : P"

text {*Dynamic class lookup for objects*}

constdefs classOf :: "env \<Rightarrow> heap \<Rightarrow> rname \<Rightarrow> cname \<Rightarrow> bool"
 "classOf E h x C == (\<exists> a . E\<lfloor>x\<rfloor> = Ref a \<and> h @@ a = Some C)"

text {*The derivation system.*}
inductive vdm_proof intros
vdm_null: "G \<rhd> NULL : (\<lambda>  E h  hh  v  p . hh = h \<and> v = RVal Nullref \<and> p = tickRo)"

vdm_int: "G \<rhd> expr.Int i : (\<lambda>  E h hh v p . hh = h \<and> v = IVal i \<and> p = tickRo)"

vdm_ivar: "G \<rhd> IVar x : (\<lambda> E h hh v p . hh = h \<and> v = IVal (E<x>) \<and> p = tickRo)"

vdm_rvar: "G \<rhd> RVar x : (\<lambda> E h hh v p . hh = h \<and> v = RVal (E\<lfloor>x\<rfloor>) \<and> p = tickRo)"

vdm_prim: "G \<rhd> Primop f x y : 
               (\<lambda> E h hh v p  . hh = h \<and> v = IVal (f (E<x>) (E<y>)) \<and> p = \<langle>3 0 0 0\<rangle>)"

vdm_rprim: "G \<rhd> RPrimop f x y : 
                (\<lambda> E h hh v p  . hh = h \<and> v = IVal (f (E\<lfloor>x\<rfloor>) (E\<lfloor>y\<rfloor>)) \<and> p = \<langle>3 0 0 0\<rangle>)"

vdm_getfi: "G \<rhd> GetFi x f : 
                (\<lambda> E h hh v p  . \<exists> a . E\<lfloor>x\<rfloor> = Ref a \<and> hh = h \<and>  
                                       v = IVal (h<a\<bullet>f>) \<and> p = \<langle>2 0 0 0\<rangle> )"

vdm_getfr: "G \<rhd> GetFr x f :
                (\<lambda> E h hh v p  . \<exists> a . E\<lfloor>x\<rfloor> = Ref a \<and> hh = h \<and>
                                       v = RVal (h\<lfloor>a\<diamondsuit>f\<rfloor>) \<and> p = \<langle>2 0 0 0\<rangle>)"

vdm_putfi: "G \<rhd> PutFi x f y : 
                (\<lambda> E h hh v p  . \<exists> a . E\<lfloor>x\<rfloor> = Ref a \<and> hh = h<a\<bullet>f:=E<y>> \<and>
                                       v = arbitrary \<and>  p = \<langle>3 0 0 0\<rangle>)"

vdm_putfr: "G \<rhd> PutFr x f y : 
                (\<lambda> E h hh v p  . \<exists> a . E\<lfloor>x\<rfloor> = Ref a \<and> hh = h\<lfloor>a\<diamondsuit>f:=E\<lfloor>y\<rfloor>\<rfloor> \<and>
                                       v = arbitrary \<and> p = \<langle>3 0 0 0\<rangle>)"

vdm_getstat: "G \<rhd> GetStat c f : (\<lambda> E h hh v p . h = hh \<and> v = RVal (h\<lbrace>c\<struct>f\<rbrace>) \<and> p = \<langle>2 0 0 0\<rangle>)"

vdm_putstat: "G \<rhd> PutStat c f y :
                  (\<lambda> E h hh v p . hh = h\<lbrace>c\<struct>f:=E\<lfloor>y\<rfloor>\<rbrace> \<and> v=arbitrary \<and> p = \<langle>3 0 0 0\<rangle>)"

vdm_new: "G \<rhd> New c ifldvals rfldvals :
              (\<lambda> E h hh v p  . \<exists> l . l = freshloc (fmap_dom (heap.oheap h)) \<and> 
                                    hh = newObj h l E c ifldvals rfldvals \<and>
                                    v = RVal (Ref l) \<and> p = tickRo)"

vdm_if: "\<lbrakk>G \<rhd> e1 : P1; G \<rhd> e2 : P2\<rbrakk> \<Longrightarrow> 
         G \<rhd> (IF x THEN e1 ELSE e2) :
          (\<lambda> E h hh v p . \<exists> pp. p = tkn 2 pp \<and> 
                               (E<x> = grailbool True \<longrightarrow> (P1  E h hh v pp  )) \<and> 
                               (E<x> = grailbool False \<longrightarrow> (P2  E h hh v pp  )) \<and>
                               (E<x> = grailbool True \<or> E<x> = grailbool False))"

vdm_leti: "\<lbrakk>G \<rhd> e1 : P1; G \<rhd> e2 : P2\<rbrakk> \<Longrightarrow>
           G \<rhd> (Leti x e1 e2) :
                (\<lambda> E h hh v p  . \<exists> p1 p2 h1 i . (P1  E h h1 (IVal i) p1) \<and>
                                                (P2 (E<x:=i>) h1 hh v p2) \<and>
                                                 p = tk (p1 \<smile> p2))"

vdm_letr: "\<lbrakk>G \<rhd> e1 : P1; G \<rhd> e2 : P2\<rbrakk> \<Longrightarrow>
           G \<rhd> (Letr x e1 e2) :
                (\<lambda> E h hh v p  . \<exists> p1 p2 h1 r . (P1 E h h1 (RVal r) p1) \<and>
                                                (P2 (E\<lfloor>x:=r\<rfloor>) h1 hh v p2) \<and>
                                                 p = tk (p1 \<smile> p2))"

vdm_letv: "\<lbrakk>G \<rhd> e1 : P1; G \<rhd> e2 : P2\<rbrakk> \<Longrightarrow>
           G \<rhd> (Letv e1 e2) :
                (\<lambda> E h hh v p  . \<exists> p1 p2 h1 w . (P1 E h h1 w p1) \<and>
                                                (P2  E h1 hh v p2) \<and>
                                                 p = (p1 \<smile> p2))"

vdm_call: "\<lbrakk> ({(Call f, P)} \<union> G) \<rhd> (funtable f) : (\<lambda> E h hh v p  . (P  E h hh v (tkcall p)))\<rbrakk>
          \<Longrightarrow>  G \<rhd> (Call f) : P"

vdm_invokestatic:
  "\<lbrakk>({(C\<bullet>mn(args),P)} \<union> G) \<rhd> (snd (methtable C mn)) :  
    (\<lambda> E h hh v p  . \<forall> E'. E = newframe_env ((fst (methtable C mn)) @ [RNpar self]) (args @ [VALarg (RVal Nullref)]) E'  \<longrightarrow>
                           (P E' h hh v (\<langle>3 0 1 1\<rangle> \<oplus> p) )) \<rbrakk> \<Longrightarrow>
   G \<rhd> (C\<bullet>mn(args)) : P"

vdm_invoke:
  "\<lbrakk> \<forall> C .
     ({(x\<diamondsuit>mn(args),P)} \<union> G) \<rhd> (snd (methtable C mn)) :
     (\<lambda> E h hh v p  . \<forall> E' . classOf E' h  x C \<and> 
                              E = newframe_env ((fst (methtable C mn)) @ [RNpar self]) (args @ [RNarg x]) E' \<longrightarrow> 
                             (P E' h hh v (\<langle>5 0 1 1\<rangle> \<oplus> p) )) \<rbrakk> \<Longrightarrow>
   G \<rhd> (x\<diamondsuit>mn(args)) : P"

(*before the switch to multiparame methods we had:
vdm_invokestatic:
  "\<lbrakk> ({(InvokeStatic C mn y,P)} \<union> G) \<rhd> 
    (methtable C mn) :  
    (\<lambda> E h hh v p  . \<forall> E'. E = newframe_env Nullref (E'\<lfloor>y\<rfloor>)  \<longrightarrow> (P E' h hh v (\<langle>3 0 1 1\<rangle> \<oplus> p) )) \<rbrakk> \<Longrightarrow>
   G \<rhd> (InvokeStatic C mn y) : P"

vdm_invoke:
  "\<lbrakk> \<forall> C. 
     ({(Invoke x mn y,P)} \<union> G) \<rhd> 
     (methtable C mn) :  
      (\<lambda> E h hh v p  . \<forall> E' . classOf E' h  x C \<and> E = newframe_env (E'\<lfloor>x\<rfloor>) (E'\<lfloor>y\<rfloor>) \<longrightarrow> 
          (P E' h hh v (\<langle>5 0 1 1\<rangle> \<oplus> p) )) \<rbrakk> \<Longrightarrow>
   G \<rhd> (Invoke x mn y) : P"
*)
vdm_ax: "\<lbrakk> (e,P) : G \<rbrakk> \<Longrightarrow> G \<rhd> e : P"

vdm_conseq: "\<lbrakk>G \<rhd> e : P; (\<forall> E h hh v p . (P  E h hh v p ) \<longrightarrow> (Q  E h hh v p ))\<rbrakk>
            \<Longrightarrow> G \<rhd> e : Q"

subsection {*Semantic validity*}
constdefs  vdm_validn :: "nat \<Rightarrow>  expr \<Rightarrow> vdmassn \<Rightarrow> bool"  ("\<Turnstile>\<^sub>_ _ : _" 50)
"\<Turnstile>\<^sub>n e : P \<equiv> (\<forall> m . m \<le> n \<longrightarrow> (\<forall> E h hh v p . ((E \<turnstile> h,e \<Down>m (hh,v,p)) \<longrightarrow> P E h hh v p)))"
(*
constdefs  vdm_validn :: "nat \<Rightarrow>  expr \<Rightarrow> vdmassn \<Rightarrow> bool"  ("\<Turnstile>\<^sub>_ _ : _" 50)
"\<Turnstile>\<^sub>n e : P \<equiv> (\<forall> E h hh v p . ((E \<turnstile> h,e \<Down> hh,v,p) \<and> (reccount p = n) \<longrightarrow> (E,h,hh,v,p) \<in> P))"
*)
constdefs  vdm_valid :: " expr \<Rightarrow> vdmassn \<Rightarrow> bool"  ("\<Turnstile> _ : _" 50)
"\<Turnstile> e : P \<equiv> (\<forall> E h hh v p . ((E \<turnstile> h,e \<Down> hh,v,p) \<longrightarrow> P E h hh v p))"

constdefs vdm_context_validn::"nat \<Rightarrow>  vdmcontext \<Rightarrow> bool"  ("|\<Turnstile>\<^sub>_ _" 60)
"|\<Turnstile>\<^sub>n G \<equiv> (\<forall> (e,P) \<in> G . \<Turnstile>\<^sub>n e : P)"

constdefs vdm_context_valid::" vdmcontext \<Rightarrow> bool"  ("|\<Turnstile> _" 60)
"|\<Turnstile> G \<equiv> (\<forall> (e,P) \<in> G . \<Turnstile> e : P)"

lemma valid_validn: "\<Turnstile> e : P \<Longrightarrow>  \<Turnstile>\<^sub>n e : P"
(*<*)by (simp add: vdm_valid_def vdm_validn_def sem_def, fastsimp)(*>*)

lemma validn_valid: "(\<forall> n . \<Turnstile>\<^sub>n e : P) \<Longrightarrow> \<Turnstile> e : P"
(*<*)by (simp add: vdm_valid_def vdm_validn_def sem_def, fastsimp)(*>*)

lemma ctxt_valid_validn: "( |\<Turnstile> G) \<Longrightarrow> (\<forall> n.( |\<Turnstile>\<^sub>n G))"
(*<*)
apply (simp add: vdm_context_validn_def vdm_context_valid_def)
apply clarsimp
apply (auto elim: valid_validn)
done
(*>*)

lemma emptyctxn [simp]: "|\<Turnstile>\<^sub>n {}"
(*<*)by (simp add: vdm_context_validn_def)(*>*)

lemma ctx_projn[rule_format]: "(e,P) \<in> G \<and> |\<Turnstile>\<^sub>n G \<Longrightarrow> (\<Turnstile>\<^sub>n e : P)"
(*<*)by (simp add: vdm_context_validn_def, fastsimp)(*>*)

lemma ctxt_drop: "( |\<Turnstile> {(e,P)} \<union> G) \<Longrightarrow> |\<Turnstile> G"
(*<*)by (simp add: vdm_context_valid_def)(*>*)

lemma ctxt_ext[simp]: "( |\<Turnstile> {(e,P)} \<union> G) = ((\<Turnstile> e : P ) \<and> ( |\<Turnstile> G))"
(*<*)by (simp add: vdm_context_valid_def)(*>*)

lemma emptyctx [simp]: "|\<Turnstile> {}"
(*<*)by (simp add: vdm_context_valid_def)(*>*)

lemma ctx_subn[rule_format]:  "H \<subseteq> G \<and> |\<Turnstile>\<^sub>n G \<Longrightarrow> |\<Turnstile>\<^sub>n H"
(*<*)by (simp add: vdm_context_validn_def vdm_validn_def, fast)(*>*)

lemma ctxt_cons: "\<lbrakk> |\<Turnstile> G; \<Turnstile> e : P\<rbrakk> \<Longrightarrow> |\<Turnstile> G \<union> {(e,P)}"
(*<*)by (simp add: vdm_context_valid_def)(*>*)

lemma contxt_validn_valid[rule_format]: "(\<forall> n. |\<Turnstile>\<^sub>n G) \<Longrightarrow> |\<Turnstile> G"
(*<*)by (simp add: vdm_context_validn_def vdm_context_valid_def 
              vdm_valid_def vdm_validn_def sem_def,
    fastsimp)(*>*)

lemma contxt_valid_validn: "|\<Turnstile> G \<Longrightarrow> (\<forall> n. |\<Turnstile>\<^sub>n G)"
(*<*)by (simp add: vdm_context_validn_def vdm_context_valid_def 
              vdm_valid_def vdm_validn_def sem_def,
    fastsimp)(*>*)

lemma lowerm: "\<lbrakk>  m < n; \<Turnstile>\<^sub>n e:P \<rbrakk> \<Longrightarrow> \<Turnstile>\<^sub>m e : P"
(*<*)
apply (simp add: vdm_validn_def)
apply clarsimp
apply (subgoal_tac "ma < n")
prefer 2 apply simp
apply (erule_tac thin_rl)
apply (erule_tac x="ma" in allE)
apply simp
done
(*>*)
 
lemma lowerm_suc: "\<lbrakk>  \<Turnstile>\<^sub>(Suc n) e:P \<rbrakk> \<Longrightarrow> \<Turnstile>\<^sub>n e : P"
(*<*)
apply (simp add: vdm_validn_def)
apply clarsimp
apply (erule_tac x="m" in allE)
apply simp
done
(*>*)

lemma ctxt_lower: "\<lbrakk> |\<Turnstile>\<^sub>n G; m<n \<rbrakk> \<Longrightarrow> |\<Turnstile>\<^sub>m G"
(*<*)
apply (simp add: vdm_context_validn_def)
apply clarsimp
apply (rule lowerm)
apply fastsimp+
done
(*>*)

(* lemmas ctxt_lower_suc = ctxt_lower [of "Suc n" G n]; *)

lemma ctxt_lower_suc: "\<lbrakk> |\<Turnstile>\<^sub>(Suc n) G \<rbrakk> \<Longrightarrow> |\<Turnstile>\<^sub>n G"
(*<*)
apply (simp add: vdm_context_validn_def)
apply clarsimp
apply (rule lowerm)
apply fastsimp+
done
(*>*)

lemma ctxt_consn: "\<lbrakk> |\<Turnstile>\<^sub>n G; \<Turnstile>\<^sub>n e:P \<rbrakk> \<Longrightarrow> ( |\<Turnstile>\<^sub>n {(e,P)} \<union> G)"
(*<*)by (simp add: vdm_context_validn_def)(*>*)

lemma ctxt_insertn: "\<lbrakk> |\<Turnstile>\<^sub>n G; \<Turnstile>\<^sub>n e:P \<rbrakk> \<Longrightarrow> ( |\<Turnstile>\<^sub>n (insert (e,P) G))"
(*<*)by (simp add: vdm_context_validn_def)(*>*)


constdefs 
vdm_valid_in_ctxt :: " vdmtuple set \<Rightarrow>  expr \<Rightarrow> vdmassn \<Rightarrow> bool" ("_ \<Turnstile> _ : _" 75)
  "G \<Turnstile> e : P \<equiv>  ( |\<Turnstile> G ) \<longrightarrow> (\<Turnstile> e:P)"

vdm_valid_in_ctxt_n :: " vdmtuple set \<Rightarrow> nat \<Rightarrow>  expr \<Rightarrow> vdmassn \<Rightarrow> bool" ("_ \<Turnstile>\<^sub> _ _ : _" 75)
  "G \<Turnstile>\<^sub>n e : P \<equiv>  ( |\<Turnstile>\<^sub>n G ) \<longrightarrow> ( \<Turnstile>\<^sub>n e:P)"
(*  "G \<Turnstile>\<^sub>n e : P \<equiv>  \<forall> m . m \<le> n \<longrightarrow> ( |\<Turnstile>\<^sub>m G ) \<longrightarrow> ( \<Turnstile>\<^sub>m e:P)"*)

(*<*)
lemmas vdm_basics = vdm_null vdm_int vdm_ivar vdm_rvar vdm_prim vdm_rprim 
                    vdm_getfi vdm_getfr vdm_putfi vdm_putfr vdm_getstat vdm_putstat
                    vdm_new vdm_if vdm_leti vdm_letr vdm_letv 

lemmas vdm_calls = vdm_call vdm_invokestatic vdm_invoke 

lemmas vdm_pathetic = vdm_null vdm_int vdm_ivar vdm_rvar vdm_prim vdm_rprim
                      vdm_getfi vdm_getfr vdm_putfi vdm_putfr vdm_getstat vdm_putstat
                      vdm_new 
(*>*)
(*<*)
end
(*>*)
