theory HeapSort23 = HPSortProg:

text {*This corresponds to the following specifications, formalised from the viewpoint of the
       method bodies: the contexts (in second parameter of @{text DAss}) are the contexts in which
       the method bodies are typed*}
consts Insert_Spec::"ARGTYPE => vdmassn"
recdef Insert_Spec "measure (\<lambda> args. size args)"
"Insert_Spec [INarg x, RNarg y, VALarg (RVal Nullref)] = \<lbrace> {y}, 1, (emptyfinmap(y \<mapsto>\<^sub>f(TreeET 0))) \<ggreater> (TreeET 0), 0\<rbrace>"
"Insert_Spec L = (\<lambda> E h hh v p. False)"

constdefs MST :: MS_T
"MST == (\<lambda> M args E h hh v p.
         if M = Insert then Insert_Spec [INarg x_, RNarg t_, VALarg (RVal Nullref)] (newframe_env ((fst (methtable HS Insert)) @ [RNpar self]) args E) h hh v p else False)"

lemma Insert_Invoke:
"MST Insert [INarg x, RNarg y, VALarg (RVal Nullref)] E h hh v p \<Longrightarrow> \<lbrace> {y} , 1 , (emptyfinmap(y \<mapsto>\<^sub>f(TreeET 0))) \<ggreater>  (TreeET 0), 0 \<rbrace> E h hh v p"apply (simp add: MST_def)
apply (simp add: Meth_Insert Insert_Spec_def newframe_env_def evalARGS_def self_def)
apply (simp add: DAss_def, safe)
lemma "Insert_Spec [INarg x, RNarg y, VALarg (RVal Nullref)] = \<lbrace> {y}, 1, (emptyfinmap(y \<mapsto>\<^sub>f(TreeET 0))) \<ggreater> (TreeET 0), 0\<rbrace>"
apply simp
constdefs Removesome_Spec::"ARGTYPE \<Rightarrow> vdmassn"
"Removesome_Spec args E h hh v p == 
  (case args of [] \<Rightarrow> False |
        (h # t) \<Rightarrow> (case x of RNarg x \<Rightarrow> (case t of [] \<Rightarrow> False
                                          | (hh # tt) \<Rightarrow> 
                                             (case hh of (VALarg r) => (RVal Nullref) \<Rightarrow> 
                                             \<lbrace> {x}, 0, (emptyfinmap(t_ \<mapsto>\<^sub>f(TreeET 0))) \<ggreater> (ResultET 0 (TreeET 0) 0), 0\<rbrace> E h hh v p
                                           | _ \<Rightarrow> False)
                            | _ \<Rightarrow> False))"
constdefs Removetop_Spec::vdmassn
"Removetop_Spec == \<lbrace> {t_}, 0, (emptyfinmap(t_ \<mapsto>\<^sub>f(TreeET 0))) \<ggreater> (ResultET 0 (TreeET 0) 0), 0\<rbrace>"
constdefs Make_heap_Spec::vdmassn
"Make_heap_Spec == \<lbrace> {l_}, 0, (emptyfinmap(l_ \<mapsto>\<^sub>f(ListET 0))) \<ggreater> (TreeET 0), 0\<rbrace>"
constdefs Extract_Spec::vdmassn
"Extract_Spec == \<lbrace> {h_}, 0, (emptyfinmap(h_ \<mapsto>\<^sub>f(TreeET 0))) \<ggreater> (ListET 0), 0\<rbrace>"
constdefs Siftdown_Spec::vdmassn
"Siftdown_Spec == \<lbrace> {t1_, t2_}, 1, (emptyfinmap(t1_ \<mapsto>\<^sub>f(TreeET 0))(t2_ \<mapsto>\<^sub>f(TreeET 0))) \<ggreater> (TreeET 0), 0\<rbrace>"
constdefs Sort_Spec::vdmassn
"Sort_Spec == \<lbrace> {l_}, 0, (emptyfinmap(l_ \<mapsto>\<^sub>f(ListET 0))) \<ggreater> (ListET 0), 0\<rbrace>"

constdefs FST :: FS_T
 "FST == (\<lambda> f E h hh v p . False)"

constdefs MST :: MS_T
"MST == (\<lambda> M args E h hh v p.
         if M = Insert then Insert_Spec (newframe_env ((fst (methtable HS Insert)) @ [RNpar self]) args E) h hh v p else
         if M = Removesome then Removesome_Spec (newframe_env ((fst (methtable HS Removesome)) @ [RNpar self]) args E) h hh v p else
         if M = Removetop then Removetop_Spec (newframe_env ((fst (methtable HS Removetop)) @ [RNpar self]) args E) h hh v p else
         if M = Extract then Extract_Spec (newframe_env ((fst (methtable HS Extract)) @ [RNpar self]) args E) h hh v p else
         if M = Make_heap then Make_heap_Spec (newframe_env ((fst (methtable HS Make_heap)) @ [RNpar self]) args E) h hh v p else
         if M = Siftdown then Siftdown_Spec (newframe_env ((fst (methtable HS Siftdown)) @ [RNpar self]) args E) h hh v p else
         if M = Sort then Sort_Spec (newframe_env ((fst (methtable HS Sort)) @ [RNpar self]) args E) h hh v p else
         False)"

lemma Make_heap_Invoke:
"MST Make_heap [RNarg x, VALarg (RVal Nullref)] E h hh v p 
 \<Longrightarrow> \<lbrace> {x}, 0 , (emptyfinmap(x \<mapsto>\<^sub>f(ListET 0)))  \<ggreater> (TreeET 0) , 0 \<rbrace> E h hh v p"
apply (simp add: MST_def)
apply (simp add: Meth_Make_heap Make_heap_Spec_def newframe_env_def evalARGS_def self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=CS in allE, erule_tac x=F in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (simp add: regionsExist_def DOM_def GETr_def)
apply (simp add: regionsDistinct_def DOM_def GETr_def)
apply (simp add: distinctFrom_def DOM_def GETr_def)
apply (erule ContextSize.elims, clarsimp+)
  apply (erule ContextSize.elims, clarsimp+)
  apply (rule ContextSizeCONS) apply simp apply (simp add: GETr_def) apply simp
  apply (rule ContextSizeNIL) apply simp+
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (simp add: modified_def DOM_def GETr_def)
apply (simp add: Bounded_def DOM_def GETr_def)
apply (simp add: Bounded_def DOM_def GETr_def)
done

lemma Extract_Invoke:
"MST Extract [RNarg x, VALarg (RVal Nullref)] E h hh v p 
\<Longrightarrow> \<lbrace> {x}, 0 , (emptyfinmap(x \<mapsto>\<^sub>f(TreeET 0)))  \<ggreater> (ListET 0) , 0 \<rbrace> E h hh v p"
apply (simp add: MST_def)
apply (simp add: Meth_Extract Extract_Spec_def newframe_env_def evalARGS_def self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=CS in allE, erule_tac x=F in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (simp add: regionsExist_def DOM_def GETr_def)
apply (simp add: regionsDistinct_def DOM_def GETr_def)
apply (simp add: distinctFrom_def DOM_def GETr_def)
apply (erule ContextSize.elims, clarsimp+)
  apply (erule ContextSize.elims, clarsimp+)
  apply (rule ContextSizeCONS) apply simp apply (simp add: GETr_def) apply simp
  apply (rule ContextSizeNIL) apply simp+
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (simp add: modified_def DOM_def GETr_def)
apply (simp add: Bounded_def DOM_def GETr_def)
apply (simp add: Bounded_def DOM_def GETr_def)
done

lemma Insert_Invoke:
"MST Insert [INarg x, RNarg y, VALarg (RVal Nullref)] E h hh v p \<Longrightarrow> \<lbrace> {y} , 1 , (emptyfinmap(y \<mapsto>\<^sub>f(TreeET 0))) \<ggreater>  (TreeET 0), 0 \<rbrace> E h hh v p"apply (simp add: MST_def)
apply (simp add: Meth_Insert Insert_Spec_def newframe_env_def evalARGS_def self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=CS in allE, erule_tac x=F in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (simp add: regionsExist_def DOM_def GETr_def)
apply (simp add: regionsDistinct_def DOM_def GETr_def)
apply (simp add: distinctFrom_def DOM_def GETr_def)
apply (erule ContextSize.elims, clarsimp+)
  apply (erule ContextSize.elims, clarsimp+)
  apply (rule ContextSizeCONS) apply simp apply (simp add: GETr_def) apply simp
  apply (rule ContextSizeNIL) apply simp+
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (simp add: modified_def DOM_def GETr_def)
apply (simp add: Bounded_def DOM_def GETr_def)
apply (simp add: Bounded_def DOM_def GETr_def)
done

lemma Removetop_Invoke:
"MST Removetop [RNarg x, VALarg (RVal Nullref)] E h hh v p \<Longrightarrow> \<lbrace> {x} , 0 , (emptyfinmap(x \<mapsto>\<^sub>f(TreeET 0))) \<ggreater>  (ResultET 0 (TreeET 0) 0), 0 \<rbrace> E h hh v p"apply (simp add: MST_def)
apply (simp add: Meth_Removetop Removetop_Spec_def newframe_env_def evalARGS_def self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=CS in allE, erule_tac x=F in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (simp add: regionsExist_def DOM_def GETr_def)
apply (simp add: regionsDistinct_def DOM_def GETr_def)
apply (simp add: distinctFrom_def DOM_def GETr_def)
apply (erule ContextSize.elims, clarsimp+)
  apply (erule ContextSize.elims, clarsimp+)
  apply (rule ContextSizeCONS) apply simp apply (simp add: GETr_def) apply simp
  apply (rule ContextSizeNIL) apply simp+
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (simp add: modified_def DOM_def GETr_def)
apply (simp add: Bounded_def DOM_def GETr_def)
apply (simp add: Bounded_def DOM_def GETr_def)
done

lemma Removesome_Invoke:
"MST Removesome [RNarg x, VALarg (RVal Nullref)] E h hh v p \<Longrightarrow> \<lbrace> {x} , 0 , (emptyfinmap(x \<mapsto>\<^sub>f(TreeET 0))) \<ggreater>  (ResultET 0 (TreeET 0) 0), 0 \<rbrace> E h hh v p"apply (simp add: MST_def)
apply (simp add: Meth_Removesome Removesome_Spec_def newframe_env_def evalARGS_def self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=CS in allE, erule_tac x=F in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (simp add: regionsExist_def DOM_def GETr_def)
apply (simp add: regionsDistinct_def DOM_def GETr_def)
apply (simp add: distinctFrom_def DOM_def GETr_def)
apply (erule ContextSize.elims, clarsimp+)
  apply (erule ContextSize.elims, clarsimp+)
  apply (rule ContextSizeCONS) apply simp apply (simp add: GETr_def) apply simp
  apply (rule ContextSizeNIL) apply simp+
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (simp add: modified_def DOM_def GETr_def)
apply (simp add: Bounded_def DOM_def GETr_def)
apply (simp add: Bounded_def DOM_def GETr_def)
done

lemma Siftdown_Invoke:
"\<lbrakk>MST Siftdown [INarg x, RNarg y, RNarg z, VALarg (RVal Nullref)] E h hh v p; y \<noteq> z\<rbrakk> \<Longrightarrow>
  \<lbrace> {y,z} , 1 , (emptyfinmap(y \<mapsto>\<^sub>f(TreeET 0))(z \<mapsto>\<^sub>f(TreeET 0))) \<ggreater>  (TreeET 0), 0 \<rbrace> E h hh v p"
apply (simp add: MST_def)
apply (simp add: Meth_Siftdown Siftdown_Spec_def newframe_env_def evalARGS_def self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=CS in allE, erule_tac x=F in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (simp add: regionsExist_def DOM_def)
  apply clarsimp apply (erule disjE)
    apply clarsimp apply (erule_tac x=z in allE, simp add: GETr_def)
    apply clarsimp apply (erule_tac x=y in allE, clarsimp)
      apply (subgoal_tac "GETr (emptyfinmap(y\<mapsto>\<^sub>fTreeET 0)(z\<mapsto>\<^sub>fTreeET 0)) y = GETr (emptyfinmap(y\<mapsto>\<^sub>fTreeET 0)) y", clarsimp)
      apply (subgoal_tac "GETr (emptyfinmap(t1_\<mapsto>\<^sub>fTreeET 0)(t2_\<mapsto>\<^sub>fTreeET 0)) t1_ = GETr (emptyfinmap(t1_\<mapsto>\<^sub>fTreeET 0)) t1_", simp add: GETr_def, fast)
      apply (rule GETr_Update1, simp)
      apply (rule GETr_Update1, fastsimp)
apply (simp add: regionsDistinct_def DOM_def, clarsimp)
  apply (erule disjE, clarsimp+)
  apply (erule disjE, clarsimp+)
  apply (subgoal_tac "GETr (emptyfinmap(t1_\<mapsto>\<^sub>fTreeET 0)(t2_\<mapsto>\<^sub>fTreeET 0)) t1_ = Some (TreeET 0)", clarsimp)
  apply (erule_tac x=y in allE, erule_tac x=z in allE, erule_tac x=Rx in allE, erule_tac x=Rxx in allE, erule impE, clarsimp)
   apply rule apply (subgoal_tac "GETr (emptyfinmap(y\<mapsto>\<^sub>fTreeET 0)(z\<mapsto>\<^sub>fTreeET 0)) y = Some (TreeET 0)", fastsimp)
     apply (rule GETr_Update2, simp add: GETr_def, fast)
   apply (simp add: GETr_def, fast)
   apply simp
   apply (rule GETr_Update2, simp add: GETr_def, simp)
   apply clarsimp
  apply (erule disjE, clarsimp+)
  apply (subgoal_tac "GETr (emptyfinmap(t1_\<mapsto>\<^sub>fTreeET 0)(t2_\<mapsto>\<^sub>fTreeET 0)) t1_ = Some (TreeET 0)", clarsimp)
  apply (erule_tac x=y in allE, erule_tac x=z in allE, erule_tac x=Rxx in allE, erule_tac x=Rx in allE, erule impE, clarsimp)
   apply rule apply (subgoal_tac "GETr (emptyfinmap(y\<mapsto>\<^sub>fTreeET 0)(z\<mapsto>\<^sub>fTreeET 0)) y = Some (TreeET 0)", fastsimp)
     apply (rule GETr_Update2, simp add: GETr_def, fast)
   apply (simp add: GETr_def, fast)
   apply fastsimp
   apply (rule GETr_Update2, simp add: GETr_def, simp)
   apply clarsimp
apply (simp add: distinctFrom_def DOM_def, clarsimp)
  apply (erule disjE, clarsimp+)
  apply (subgoal_tac "GETr (emptyfinmap(t1_\<mapsto>\<^sub>fTreeET 0)(t2_\<mapsto>\<^sub>fTreeET 0)) t1_ = Some (TreeET 0)", clarsimp)
    apply (erule_tac x=y in allE, clarsimp) apply (subgoal_tac "GETr (emptyfinmap(y\<mapsto>\<^sub>fTreeET 0)(z\<mapsto>\<^sub>fTreeET 0)) y = Some (TreeET 0)", fastsimp)
     apply (rule GETr_Update2, simp add: GETr_def, fast)
  apply (rule GETr_Update2, simp add: GETr_def, simp)
  apply (clarsimp+)
    apply (erule_tac x=z in allE, clarsimp) apply (simp add: GETr_def) apply fast 
apply (erule ContextSize.elims, clarsimp+)
  apply (erule disjE)
  apply clarsimp apply (erule ContextSize.elims, clarsimp+) apply (erule ContextSize.elims, clarsimp+)
    apply (rule ContextSizeCONS) apply (subgoal_tac "t1_: {t1_,t2_}", assumption,fast)
     apply (subgoal_tac "GETr (emptyfinmap(t1_\<mapsto>\<^sub>fTreeET 0)(t2_\<mapsto>\<^sub>fTreeET 0)) t1_ = Some (TreeET 0)", clarsimp)
     apply (subgoal_tac "GETr (emptyfinmap(y\<mapsto>\<^sub>fTreeET 0)(z\<mapsto>\<^sub>fTreeET 0)) y = Some (TreeET 0)", clarsimp, simp)
     apply (rule GETr_Update2, simp add: GETr_def, fast)  apply (rule GETr_Update2, simp add: GETr_def, simp)
     apply simp 
    apply (rule ContextSizeCONS) apply simp apply (simp add: GETr_def) apply simp
    apply (rule ContextSizeNIL) apply simp+
  apply clarsimp apply (subgoal_tac "{y,z} - {z} = {y}", clarsimp) apply (erule ContextSize.elims, clarsimp, clarify) 
                 apply (subgoal_tac "{y} - {y} = {}", clarsimp) apply (erule ContextSize.elims, clarsimp) 
    apply (rule ContextSizeCONS) apply (subgoal_tac "t1_: {t1_,t2_}", assumption,fast)
     apply (subgoal_tac "GETr (emptyfinmap(t1_\<mapsto>\<^sub>fTreeET 0)(t2_\<mapsto>\<^sub>fTreeET 0)) t1_ = Some (TreeET 0)", clarsimp)
     apply (subgoal_tac "GETr (emptyfinmap(y\<mapsto>\<^sub>fTreeET 0)(z\<mapsto>\<^sub>fTreeET 0)) y = Some (TreeET 0)", clarsimp, simp)
     apply (rule GETr_Update2, simp add: GETr_def, fast)  apply (rule GETr_Update2, simp add: GETr_def, simp)
     apply simp 
    apply (rule ContextSizeCONS) apply simp apply (simp add: GETr_def) apply simp
    apply (rule ContextSizeNIL) apply simp+
  apply fast
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (simp add: modified_def DOM_def, clarsimp)
  apply (erule_tac x=l in allE, erule impE, clarsimp)
  apply (erule disjE)
  apply clarsimp apply (erule_tac x=y in allE, erule_tac x=Rz in allE, erule impE, clarsimp)
    apply (subgoal_tac "GETr (emptyfinmap(t1_\<mapsto>\<^sub>fTreeET 0)(t2_\<mapsto>\<^sub>fTreeET 0)) t1_ = Some (TreeET 0)", clarsimp)
    apply (subgoal_tac "GETr (emptyfinmap(y\<mapsto>\<^sub>fTreeET 0)(z\<mapsto>\<^sub>fTreeET 0)) y = Some (TreeET 0)", clarsimp, fast)
     apply (rule GETr_Update2, simp add: GETr_def, fast)  apply (rule GETr_Update2, simp add: GETr_def, simp)
    apply fast
  apply clarsimp apply (erule_tac x=z in allE, erule_tac x=Rz in allE, erule impE, clarsimp)
    apply (simp add: GETr_def, fast)
    apply fast
  apply assumption
apply (simp add: Bounded_def DOM_def, rule, rule)
  apply (rotate_tac -4, erule thin_rl) apply (erule_tac x=l in allE, erule impE, assumption)
  apply (erule disjE, erule disjI1) apply (rule disjI2, clarsimp)
  apply (erule disjE)
  apply clarsimp apply (rule_tac x=y in exI, clarsimp)
    apply (subgoal_tac "GETr (emptyfinmap(t1_\<mapsto>\<^sub>fTreeET 0)(t2_\<mapsto>\<^sub>fTreeET 0)) t1_ = Some (TreeET 0)", clarsimp)
    apply (subgoal_tac "GETr (emptyfinmap(y\<mapsto>\<^sub>fTreeET 0)(z\<mapsto>\<^sub>fTreeET 0)) y = Some (TreeET 0)", clarsimp, fast)
     apply (rule GETr_Update2, simp add: GETr_def, fast)  apply (rule GETr_Update2, simp add: GETr_def, simp)
  apply clarsimp apply (rule_tac x=z in exI, clarsimp) apply (simp add: GETr_def, fast)
apply (simp add: Bounded_def DOM_def, rule, rule)
  apply (rotate_tac -5, erule thin_rl) apply (erule_tac x=l in allE, erule impE, assumption)
  apply (erule disjE, erule disjI1) apply (rule disjI2, clarsimp)
  apply (erule disjE)
  apply clarsimp apply (rule_tac x=y in exI, clarsimp)
    apply (subgoal_tac "GETr (emptyfinmap(t1_\<mapsto>\<^sub>fTreeET 0)(t2_\<mapsto>\<^sub>fTreeET 0)) t1_ = Some (TreeET 0)", clarsimp)
    apply (subgoal_tac "GETr (emptyfinmap(y\<mapsto>\<^sub>fTreeET 0)(z\<mapsto>\<^sub>fTreeET 0)) y = Some (TreeET 0)", clarsimp, fast)
     apply (rule GETr_Update2, simp add: GETr_def, fast)  apply (rule GETr_Update2, simp add: GETr_def, simp)
  apply clarsimp apply (rule_tac x=z in exI, clarsimp) apply (simp add: GETr_def, fast)
done


text {*In order to prove the body correct we define a 
       context which contains an one entry for each syntactic method invocation.*}
constdefs  HeapSortContext:: vdmcontext
"HeapSortContext \<equiv> {(HS\<bullet>Insert([INarg x_,RNarg r2_]), MST Insert [INarg x_,RNarg r2_,VALarg (RVal Nullref)]),
                    (HS\<bullet>Insert([INarg v4_,RNarg r2_]), MST Insert [INarg v4_,RNarg r2_,VALarg (RVal Nullref)]),
                    (HS\<bullet>Insert([INarg v2_,RNarg l_]), MST Insert [INarg v2_,RNarg l_,VALarg (RVal Nullref)]),
                    (HS\<bullet>Removesome([RNarg r1_]), MST Removesome [RNarg r1_,VALarg (RVal Nullref)]),
                    (HS\<bullet>Removetop([RNarg h_]), MST Removetop [RNarg h_,VALarg (RVal Nullref)]),
                    (HS\<bullet>Extract([RNarg r1_]), MST Extract [RNarg r1_,VALarg (RVal Nullref)]),
                    (HS\<bullet>Make_heap([RNarg l_]), MST Make_heap [RNarg l_,VALarg (RVal Nullref)]),
                    (HS\<bullet>Make_heap([RNarg r1_]), MST Make_heap [RNarg r1_,VALarg (RVal Nullref)]),
                    (HS\<bullet>Siftdown([INarg v2_, RNarg r3_, RNarg r1_]), MST Siftdown [INarg v2_, RNarg r3_, RNarg r1_,VALarg (RVal Nullref)]),
                    (HS\<bullet>Siftdown([INarg w_, RNarg r5_, RNarg r4_]), MST Siftdown [INarg w_, RNarg r5_, RNarg r4_,VALarg (RVal Nullref)]),
                    (HS\<bullet>Siftdown([INarg w_, RNarg r8_, RNarg r7_]), MST Siftdown [INarg w_, RNarg r8_, RNarg r7_,VALarg (RVal Nullref)]),
                    (HS\<bullet>Sort([RNarg l_]), MST Sort [RNarg l_,VALarg (RVal Nullref)])}"

lemma Sort_DAss:
"\<lbrakk>G = HeapSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable HS Sort) : Sort_Spec"
apply (simp add: Meth_Sort)
apply (simp add: Meth_Sort Sort_Spec_def, clarsimp)
apply (rule DA_Weak)
apply (rule DA_Call2)
apply (simp add: Fun_fSort)
apply (rule DA_Letr)
(*invocation of Make_heap*)
apply (rule vdm_conseq, rule vdm_ax) apply (simp add: HeapSortContext_def) apply clarsimp apply (erule Make_heap_Invoke) 
(*invocation of Make_heap*)
apply (rule vdm_conseq, rule vdm_ax) apply (simp add: HeapSortContext_def) apply clarsimp apply (rule DAss_ContextsU) apply (erule Extract_Invoke) 
  apply (simp add: GETr_def)
apply fastsimp+
done

lemma Insert_DAss:
"\<lbrakk>G = HeapSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable HS Insert) : Insert_Spec"
apply (simp add: Meth_Insert)
apply (simp add: Meth_Insert Insert_Spec_def, clarsimp)
apply (rule DA_Weak)
apply (rule DA_Call2)
apply (simp add: Fun_fInsert)
apply (rule DA_Let_RPrim)
apply (rule DA_If)
apply (simp_all add: DOM_def)
(*first branch*)
apply (rule DA_Call2)
apply (simp only: Fun_fzeroInsert)
apply (rule DA_Letr, rule DA_Null) defer 1 defer 1 defer 1 defer 1 
apply (rule DA_Letr, rule DA_Null) defer 1 defer 1 defer 1 defer 1 
(*invocation of make*)
apply (rule DA_MakeTree)
apply (rule GETr_Update2) apply (simp add: GETr_def) apply simp apply simp
apply (simp add: GETr_def)
apply (simp_all (no_asm))
apply fastsimp
(*second branch*)
apply (rule DA_Call2)
apply (simp only:  Fun_foneInsert)
apply (rule DA_TreeMatchD) apply (simp add: GETr_def) apply simp 
apply (rule DA_Let_Prim)
apply (rule DA_If)
apply (simp_all (no_asm))
(*f2-branch*)
apply (rule DA_Call2)
apply (simp only: Fun_ftwoInsert)
apply (rule DA_Letr)
(*invocation of Insert*)
apply (rule vdm_conseq, rule vdm_ax) apply (simp add: HeapSortContext_def) apply clarsimp
  apply (rule DAss_ContextsU) apply (rule DAss_Const) apply (erule Insert_Invoke) apply simp apply simp
  apply (simp add: GETr_def)
(*invocation of make*)
apply (rule DA_MakeTree)
apply (simp add: GETr_def) 
apply simp
apply (rule GETr_Update2,rule GETr_Update2, simp add: GETr_def, simp, simp)
apply (simp_all (no_asm))
(*f3-branch*)
apply (rule DA_Call2)
apply (simp only:  Fun_fthreeInsert)
apply (rule DA_Letr)
(*invocation of Insert*)
apply (rule vdm_conseq, rule vdm_ax) apply (simp add: HeapSortContext_def) apply clarsimp
  apply (rule DAss_ContextsU) apply (rule DAss_Const) apply (erule Insert_Invoke) apply simp apply simp
  apply (simp add: GETr_def)
(*invocation of make*)
apply (rule DA_MakeTree)
apply (simp add: GETr_def) 
apply simp
apply (rule GETr_Update2,rule GETr_Update2, simp add: GETr_def, simp, simp)
apply (simp_all (no_asm))
apply fastsimp
done

lemma Extract_DAss:
"\<lbrakk>G = HeapSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable HS Extract) : Extract_Spec"
apply (simp add: Meth_Extract)
apply (simp add: Meth_Extract Extract_Spec_def, clarsimp)
apply (rule DA_Weak)
apply (rule DA_Call2)
apply (simp add: Fun_fExtract)
apply (rule DA_Letr)
(*invocation of Removetop*)
apply (rule vdm_conseq, rule vdm_ax) apply (simp add: HeapSortContext_def) apply clarsimp
  apply (rule DAss_ContextsU) apply (rule DAss_Const) apply (erule Removetop_Invoke) apply simp apply simp
  apply (simp add: GETr_def)
apply (rule DA_Let_RPrim)
apply (rule DA_If)
apply (simp_all add: DOM_def)
(*fzero*)
apply (rule DA_Call2)
apply (simp only: Fun_fzeroExtract)
apply (rule DA_Null) apply simp apply simp apply simp apply simp
(*fone*)
apply (rule DA_Call2)
apply (simp only:  Fun_foneExtract)
apply (rule DA_ResultMatchD) apply (simp add: GETr_def) apply fastsimp apply simp
apply (rule DA_Letr)
(*invocation of Extract*)
apply (rule vdm_conseq, rule vdm_ax) apply (simp add: HeapSortContext_def) apply clarsimp
  apply (rule DAss_ContextsU) apply (rule DAss_Const) apply (erule Extract_Invoke) apply simp apply simp
  apply (simp add: GETr_def)
(*invocation of Make*)
apply (rule DA_MakeList)
apply (simp add: GETr_def) 
apply fastsimp+
done

lemma Make_heap_DAss:
"\<lbrakk>G = HeapSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable HS Make_heap) : Make_heap_Spec"
apply (simp add: Meth_Make_heap)
apply (simp add: Meth_Make_heap Make_heap_Spec_def, clarsimp)
apply (rule DA_Weak)
apply (rule DA_Call)
apply (simp add: Fun_fMake_heap)
apply (rule DA_Let_RPrim)
apply (rule DA_If)
apply (simp_all add: DOM_def)
(*fzero*)
apply (rule DA_Call2)
apply (simp only: Fun_fzeroMake_heap)
apply (rule DA_Null) apply simp apply simp apply simp apply simp
(*fone*)
apply (rule DA_Call2)
apply (simp only:  Fun_foneMake_heap)
apply (rule DA_ListMatchD) apply (simp add: GETr_def) apply simp 
apply (rule DA_Letr)
(*invocation of Make_heap*)
apply (rule vdm_conseq, rule vdm_ax) apply (simp add: HeapSortContext_def) apply clarsimp
  apply (rule DAss_ContextsU) apply (rule DAss_Const) apply (erule Make_heap_Invoke) apply simp apply simp
  apply (simp add: GETr_def)
(*invocation of Insert*)
apply (rule vdm_conseq, rule vdm_ax) apply (simp add: HeapSortContext_def) apply clarsimp
  apply (rule DAss_ContextsU) apply (rule DAss_Const) apply (erule Insert_Invoke) apply simp apply simp
  apply (simp add: GETr_def)
apply fastsimp+
done

lemma Removesome_DAss:
"\<lbrakk>G = HeapSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable HS Removesome) : Removesome_Spec"
apply (simp add: Meth_Removesome)
apply (simp add: Meth_Removesome Removesome_Spec_def, clarsimp)
apply (rule DA_Weak)
apply (rule DA_Call2)
apply (simp add: Fun_fRemovesome)
apply (rule DA_Let_RPrim)
apply (rule DA_If)
apply (simp_all add: DOM_def)
(*fzero*)
apply (rule DA_Call2)
apply (simp only: Fun_fzeroRemovesome)
apply (rule DA_Null) apply simp apply simp apply simp apply simp
(*fone*)
apply (rule DA_Call2)
apply (simp only:  Fun_foneRemovesome)
apply (rule DA_TreeMatchD) apply (simp add: GETr_def) apply simp 
apply (rule DA_Letr)
(*invocation of Removesome*)
apply (rule vdm_conseq, rule vdm_ax) apply (simp add: HeapSortContext_def) apply clarsimp
  apply (rule DAss_ContextsU) apply (rule DAss_Const) apply (erule Removesome_Invoke) apply simp apply simp
  apply clarsimp 
  apply (rule GETr_Trans1) apply (simp add: GETr_def) apply (simp add: GETr_def)
  apply simp
apply (rule DA_Let_RPrim)
apply (rule DA_If)
(*ftwo*)
apply (rule DA_Call2)
apply (simp only: Fun_ftwoRemovesome)
(*invocation of make*)
apply (rule DA_MakeResultSome)
apply (rule GETr_Update2,simp add: GETr_def) apply simp apply simp apply simp
apply (rule, simp+)
(*fthree*)
apply (rule DA_Call2)
apply (simp only: Fun_fthreeRemovesome)
apply (rule DA_ResultMatchD) apply (simp add: GETr_def) apply fastsimp apply simp
apply (rule DA_Letr)
(*invocation of make*)
apply (rule DA_MakeTree)
apply (rule GETr_Update2,rule GETr_Update2,simp add: GETr_def) apply simp apply simp apply simp
apply (simp add: GETr_def, simp+)
(*invocation of make*)
apply (rule DA_MakeResultSome)
apply (simp add: GETr_def, simp+)
apply (rule, simp+)
apply (simp_all add: DOM_def)
apply fastsimp+
done

lemma Removetop_DAss:
"\<lbrakk>G = HeapSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable HS Removetop) : Removetop_Spec"
apply (simp add: Meth_Removetop)
apply (simp add: Meth_Removetop Removetop_Spec_def, clarsimp)
apply (rule DA_Weak)
apply (rule DA_Call2)
apply (simp add: Fun_fRemovetop)
apply (rule DA_Let_RPrim)
apply (rule DA_If)
apply (simp_all add: DOM_def)
(*fzero*)
apply (rule DA_Call2)
apply (simp only: Fun_fzeroRemovetop)
apply (rule DA_Null) apply simp apply simp apply simp apply simp
(*fone*)
apply (rule DA_Call2)
apply (simp only:  Fun_foneRemovetop)
apply (rule DA_TreeMatchD) apply (simp add: GETr_def) apply simp 
apply (rule DA_Letr)
(*invocation of Removesome*)
apply (rule vdm_conseq, rule vdm_ax) apply (simp add: HeapSortContext_def) apply clarsimp
  apply (rule DAss_ContextsU) apply (rule DAss_Const) apply (erule Removesome_Invoke) apply simp apply simp
  apply clarsimp 
  apply (rule GETr_Trans1) apply (simp add: GETr_def) apply (simp add: GETr_def)
  apply simp
apply (rule DA_Let_RPrim)
apply (rule DA_If)
(*ftwo*)
apply (rule DA_Call2)
apply (simp only: Fun_ftwoRemovetop)
(*invocation of make*)
apply (rule DA_MakeResultSome)
apply (rule GETr_Update2,simp add: GETr_def) apply simp apply simp apply simp
apply (rule, simp+)
(*fthree*)
apply (rule DA_Call2)
apply (simp only: Fun_fthreeRemovetop)
apply (rule DA_ResultMatchD) apply (simp add: GETr_def) apply fastsimp apply simp
apply (rule DA_Letr)
(*invocation of Siftdown*)
apply (rule vdm_conseq, rule vdm_ax) apply (simp add: HeapSortContext_def) apply clarsimp
  apply (rule DAss_ContextsU) apply (rule DAss_Const) apply (erule Siftdown_Invoke) apply simp apply simp apply simp
  apply clarsimp apply rule
  apply clarsimp apply (rule GETr_Trans1) apply (rule GETr_Trans1) apply (simp add: GETr_def) apply simp+
    apply (rule GETr_Trans2) apply (simp add: GETr_def) apply simp+
  apply clarsimp apply (simp add: GETr_def)
(*invocation of make*)
apply (rule DA_MakeResultSome)
apply (simp add: GETr_def, simp+)
apply (rule, simp+)
apply (simp_all add: DOM_def)
apply fast
done

text {*The definition of the formal parameters of functions.
       Used in rule DA\_CutCall, i.e. only necessary for
       functions which are merge points. params could be made
       part of the function table, similar to the first components
       in the entries in the method table.*}
defs params_def:
"params f == (if f = felevenSiftdown then [r8_,r7_,r5_,r4_] else 
              if f = ffourSiftdown then [r8_,r7_,r5_,r4_] else [])"


lemma ContextF4:
"GETr (restr (emptyfinmap(t1_\<mapsto>\<^sub>fTreeET 0)(t2_\<mapsto>\<^sub>fTreeET 0)(r8_\<mapsto>\<^sub>fTreeET 0)(r7_\<mapsto>\<^sub>fTreeET 0)(r5_\<mapsto>\<^sub>fTreeET 0)(r4_\<mapsto>\<^sub>fTreeET 0))
                                     (params ffourSiftdown)) x =
       GETr (emptyfinmap(r8_\<mapsto>\<^sub>fTreeET 0)(r7_\<mapsto>\<^sub>fTreeET 0)(r5_\<mapsto>\<^sub>fTreeET 0)(r4_\<mapsto>\<^sub>fTreeET 0)) x"
apply (case_tac "x=r8_", clarsimp)
apply (simp add: params_def GETr_def FMAPlookup1)
apply (case_tac "x=r7_", clarsimp)
apply (simp add: params_def GETr_def FMAPlookup1)
apply (case_tac "x=r5_", clarsimp)
apply (simp add: params_def GETr_def FMAPlookup1)
apply (case_tac "x=r4_", clarsimp)
apply (simp add: params_def GETr_def FMAPlookup1)+
done

lemma ContextF11:
"GETr (restr (restr (emptyfinmap(t1_\<mapsto>\<^sub>fTreeET 0)(t2_\<mapsto>\<^sub>fTreeET 0)(r8_\<mapsto>\<^sub>fTreeET 0)(r7_\<mapsto>\<^sub>fTreeET 0)(r5_\<mapsto>\<^sub>f
                                                   TreeET 0)(r4_\<mapsto>\<^sub>fTreeET 0))
                                             (params ffourSiftdown))
                                      (params felevenSiftdown)) x =
  GETr (emptyfinmap(r8_\<mapsto>\<^sub>fTreeET 0)(r7_\<mapsto>\<^sub>fTreeET 0)(r5_\<mapsto>\<^sub>fTreeET 0)(r4_\<mapsto>\<^sub>fTreeET 0)) x"
apply (case_tac "x=r8_", clarsimp)
apply (simp add: params_def GETr_def FMAPlookup1)
apply (case_tac "x=r7_", clarsimp)
apply (simp add: params_def GETr_def FMAPlookup1)
apply (case_tac "x=r5_", clarsimp)
apply (simp add: params_def GETr_def FMAPlookup1)
apply (case_tac "x=r4_", clarsimp)
apply (simp add: params_def GETr_def FMAPlookup1)+
done

lemma Siftdown_DAss:
"\<lbrakk>G = HeapSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable HS Siftdown) : Siftdown_Spec"
apply (simp add: Meth_Siftdown Siftdown_Spec_def, clarsimp)
apply (rule DA_Weak)
apply (rule Cut2Call) 
apply (rule DA_Call2)
apply (simp add: Fun_fSiftdown)
apply (rule DA_Let_RPrim)
apply (rule DA_If)
apply (simp_all add: DOM_def)
(*fzero*)
  apply (rule DA_Call2)
  apply (simp only: Fun_fzeroSiftdown)
  apply (rule DA_Letr, rule DA_Null) prefer 5 
  apply (rule DA_Letr, rule DA_Null) prefer 5
  (*invocation of make*)
  apply (rule DA_MakeTree)
  apply (rule GETr_Update2) apply (simp add: GETr_def) apply simp+
  apply (simp add: GETr_def) apply simp apply simp apply simp apply simp 
    prefer 2 apply simp apply simp apply simp apply simp apply simp apply simp
    prefer 2 apply simp apply simp apply simp apply simp apply simp
(*fone*)
  apply (rule DA_Call2)
  apply (simp only:  Fun_foneSiftdown)
  apply (rule DA_TreeMatchD) 
  apply (rule GETr_Update2) apply (simp add: GETr_def) apply simp apply simp prefer 2 apply simp
  apply (rule DA_Let_RPrim) prefer 2 apply (simp add: DOM_def) prefer 2 apply (simp add: DOM_def)
  apply (rule DA_If)
(*fwo*)
  apply (rule DA_Call2)
  apply (simp only: Fun_ftwoSiftdown)
  apply (rule DA_Let_Prim)
  apply (rule DA_If)
(*feighteen*)
  apply (rule DA_Call2)
  apply (simp only: Fun_feighteenSiftdown)
  apply (rule DA_Letr, rule DA_Null) prefer 5
  apply (rule DA_Letr, rule DA_Null) prefer 5
  apply (rule DA_Letr)
  (*invocation of make*)
  apply (rule DA_MakeTree) 
  apply (rule GETr_Update2) apply (simp add: GETr_def) apply simp apply simp
  apply (simp add: GETr_def) apply simp apply simp prefer 2
  apply (rule DA_Letr, rule DA_Null) prefer 5
  (*invocation of make*)
  apply (rule DA_MakeTree)
  apply (rule GETr_Update2) apply (simp add: GETr_def) apply simp apply simp
  apply (simp add: GETr_def) 
  apply (simp, simp, simp, simp)
  prefer 2 apply fastsimp apply simp
  apply fastsimp
  apply fastsimp
  apply (simp, simp, fastsimp, simp, simp) prefer 2 apply fastsimp apply simp apply fastsimp apply fastsimp apply (simp, simp, simp) apply fastsimp 
     apply fastsimp apply fastsimp
    apply simp 
(*fnineteen*)
  apply (rule DA_Call2)
  apply (simp only: Fun_fnineteenSiftdown)
  apply (rule DA_Letr, rule DA_Null) prefer 5
  apply (rule DA_Letr, rule DA_Null) prefer 5
  apply (rule DA_Letr)
  (*invocation of make*)
  apply (rule DA_MakeTree)
  apply (rule GETr_Update2) apply (simp add: GETr_def) apply simp apply simp
  apply (simp add: GETr_def) apply simp apply simp 
  prefer 7 apply fastsimp prefer 7 apply fastsimp prefer 2
  apply (rule DA_Letr, rule DA_Null) prefer 5
  (*invocation of make*)
  apply (rule DA_MakeTree)
  apply (rule GETr_Update2) apply (simp add: GETr_def) apply simp apply simp
  apply (simp add: GETr_def) 
  apply (simp, simp, simp, simp)
  prefer 2 apply fastsimp apply simp apply fastsimp apply fastsimp apply (simp, simp, fastsimp, simp, simp, simp, fastsimp, simp, simp, simp)
  apply (fastsimp, fastsimp, fastsimp, simp)
(*fthree*)
  apply (rule DA_Call2)
  apply (simp only: Fun_fthreeSiftdown)
  apply (rule DA_TreeMatchD) apply (rule GETr_Update2) apply (rule GETr_Update2) apply (simp add: GETr_def, simp, simp)
  apply simp
  apply (rule DA_Let_Prim)
  apply (rule DA_If)
(*ffive*)
  apply (rule DA_Call2)
  apply (simp only: Fun_ffiveSiftdown)
  apply (rule DA_Let_Prim)
  apply (rule DA_If)
(*fseven*)
  apply (rule DA_Call2)
  apply (simp only: Fun_fsevenSiftdown)
  apply (rule DA_Let_Int)
  apply (rule DA_CutCall) apply (simp add: ContextF4) apply (simp add: HeapSortContext_def) 
    apply (rule, simp, simp)? 
  defer 1 
(*feight*)
  apply (rule DA_Call2)
  apply (simp only: Fun_feightSiftdown)
  apply (rule DA_Let_Int)
  apply (rule DA_CutCall) apply (simp add: ContextF4) apply (simp add: HeapSortContext_def) 
  defer 1 
(*fsix*)
  apply (rule DA_Call2)
  apply (simp only: Fun_fsixSiftdown)
  apply (rule DA_Let_Int)
  apply (rule DA_CutCall) apply (simp add: ContextF4) apply (simp add: HeapSortContext_def) 
  defer 1
apply simp
defer 1 defer 1 
apply (simp add: HeapSortContext_def)
(*Verification of f4*)
  apply (simp add: contextProvable_def, clarsimp)
  apply rule prefer 2 apply clarsimp apply (erule vdm_ax)
  (*ffour*)
    apply clarsimp
    apply (rule DA_Call2)
    apply (simp only: Fun_ffourSiftdown)
    apply (rule DA_Let_Prim)
    apply (rule DA_If)
  (*fnine*)
    apply (rule DA_Call2)
    apply (simp only: Fun_fnineSiftdown)
    apply (rule DA_Letr)
    (*invocation of make*) 
    apply (rule DA_MakeTree) apply (simp add: ContextF4)
    apply (rule GETr_Update2) apply (rule GETr_Update2) apply (rule GETr_Update2) apply (simp add: GETr_def) apply simp+
    apply (simp add: ContextF4) apply (rule GETr_Update2) apply (rule GETr_Update2) apply (simp add: GETr_def) 
    apply simp+
    apply (rule DA_Letr)
    (*invocation of make*)
    apply (rule DA_MakeTree)
    apply (rule GETr_Update2)  apply (simp add: ContextF4) apply (rule GETr_Update2) apply (simp add: GETr_def) apply simp+
    apply (rule GETr_Update2) apply (simp add: ContextF4) apply (simp add: GETr_def) 
    apply simp+
    (*invocation of make*)
    apply (rule DA_MakeTree)
    apply (rule GETr_Update2) apply (simp add: GETr_def) apply simp+
    apply (simp add: GETr_def) 
    apply simp+
  (*ften*)
  apply (rule Cut2Call) 
    apply (rule DA_Call2)
    apply (simp only: Fun_ftenSiftdown)
    apply (rule DA_Let_Prim)
    apply (rule DA_If)
  (*twelve*)
    apply (rule DA_Call2)
    apply (simp only: Fun_ftwelveSiftdown)
    apply (rule DA_Let_Prim)
    apply (rule DA_If)
  (*ffourteen*)
    apply (rule DA_Call2)
    apply (simp only: Fun_ffourteenSiftdown)
    apply (rule DA_Let_Int)
    apply (rule DA_CutCall) apply (simp add: HeapSortContext_def) 
    apply (rule, simp, simp)? 
    defer 1  
  (*ffifteen*)
    apply (rule DA_Call2)
    apply (simp only: Fun_ffifteenSiftdown)
    apply (rule DA_Let_Int)
    apply (rule DA_CutCall) apply (simp add: HeapSortContext_def) 
    defer 1
  (*fthirteen*)
    apply (rule DA_Call2)
    apply (simp only: Fun_fthirteenSiftdown)
    apply (rule DA_Let_Int)
    apply (rule DA_CutCall) apply (simp add: HeapSortContext_def) 
    defer 1
apply (simp add: HeapSortContext_def)
(*Verification of f11*)
  apply (simp add: contextProvable_def, clarsimp)
  apply rule apply clarsimp prefer 2 apply clarsimp apply (erule vdm_ax) 
  (*feleven*)
    apply (rule DA_Call2)
    apply (simp only: Fun_felevenSiftdown)
    apply (rule DA_Let_Prim)
    apply (rule DA_If)
    (*fsixteen*)
      apply (rule DA_Call2)
      apply (simp only: Fun_fsixteenSiftdown)
      apply (rule DA_Letr)
      (*invocation of make*)
        apply (rule DA_MakeTree) apply (simp add: ContextF11) 
          apply (rule GETr_Update2) apply (rule GETr_Update2) apply (rule GETr_Update2) apply (simp add: GETr_def) apply simp+
          apply (simp add: ContextF11) 
          apply (rule GETr_Update2) apply (rule GETr_Update2) apply (simp add: GETr_def) apply simp+
      (*invocation of Siftdown*)
      apply (rule DA_Letr) apply (rule vdm_conseq, rule vdm_ax) apply (simp add: HeapSortContext_def)
          apply clarsimp apply (rule DAss_ContextsU) apply (rule DAss_Const) apply (erule Siftdown_Invoke) apply simp apply simp apply simp
          apply clarsimp apply rule
          apply clarsimp apply (rule GETr_Trans1) apply (simp add: ContextF11) 
                         apply (rule GETr_Trans1) apply (simp add: GETr_def)
                         apply (rule GETr_Trans2) apply (simp add: GETr_def)
            apply simp+
          apply clarsimp apply (rule GETr_Trans1) apply (simp add: ContextF11)
            apply (simp add: GETr_def)
            apply simp+
      (*invocation of make*)
      apply (rule DA_MakeTree)
          apply (rule GETr_Update2) apply (simp add: GETr_def) apply simp+
          apply (simp add: GETr_def) apply simp+
    (*fseventeen*)
      apply (rule DA_Call2)
      apply (simp only: Fun_fseventeenSiftdown)
      (*invocation of Siftdown*)
        apply (rule DA_Letr) apply (rule vdm_conseq, rule vdm_ax) apply (simp add: HeapSortContext_def)
          apply clarsimp apply (rule DAss_ContextsU) apply (rule DAss_Const) apply (erule Siftdown_Invoke) apply simp apply simp apply simp
          apply clarsimp apply rule
          apply clarsimp apply (simp add: ContextF11) 
            apply (rule GETr_Trans1) apply (rule GETr_Update2) apply (rule GETr_Update2) apply (simp add: GETr_def) apply simp+
            apply (rule GETr_Trans2) apply (simp add: GETr_def) apply simp+
          apply clarsimp apply (simp add: ContextF11)
            apply (rule GETr_Trans1) apply (rule GETr_Update2) apply (simp add: GETr_def) apply simp+
            apply (simp add: GETr_def) apply simp+
      (*invocation of make*)
        apply (rule DA_Letr)
        apply (rule DA_MakeTree)
          apply (rule GETr_Update2) apply (simp add: ContextF11) apply (rule GETr_Update2) apply (simp add: GETr_def, simp+)
          apply (rule GETr_Update2) apply (simp add: ContextF11) apply (simp add: GETr_def, simp+)
      (*invocation of make*)
        apply (rule DA_MakeTree)
        apply (rule GETr_Update2) apply (simp add: GETr_def) apply simp+
        apply (simp add: GETr_def)  apply simp+
  apply fastsimp
  apply clarsimp apply (simp add: ContextF4) apply rule
    apply clarsimp apply (rule GETr_Trans1) apply (rule GETr_Trans1) apply (rule GETr_Trans1) apply (simp add: GETr_def) apply simp+
                   apply (rule GETr_Trans2) apply (rule GETr_Trans2) apply (rule GETr_Trans2) apply (simp add: GETr_def) apply simp+
    apply rule
    apply clarsimp apply (rule GETr_Trans1) apply (rule GETr_Trans1) apply (simp add: GETr_def) apply simp+
                   apply (rule GETr_Trans2) apply (rule GETr_Trans2) apply (simp add: GETr_def) apply simp+ 
    apply clarsimp apply (erule disjE) 
      apply clarsimp apply (rule GETr_Trans1) apply (simp add: GETr_def) 
        apply (rule GETr_Trans2) apply (simp add: GETr_def) apply simp+
      apply clarsimp apply (simp add: GETr_def)
  apply clarsimp apply (simp add: ContextF4) apply rule
    apply clarsimp apply (rule GETr_Trans1) apply (rule GETr_Trans1) apply (rule GETr_Trans1) apply (simp add: GETr_def) apply simp+
                   apply (rule GETr_Trans2) apply (rule GETr_Trans2) apply (rule GETr_Trans2) apply (simp add: GETr_def) apply simp+
    apply (rule, clarsimp) 
      apply (rule GETr_Trans1) apply (rule GETr_Trans1) apply (simp add: GETr_def) apply simp+
      apply (rule GETr_Trans2) apply (rule GETr_Trans2) apply (simp add: GETr_def) apply simp+ 
    apply clarsimp apply (erule disjE) 
     apply clarsimp 
       apply (rule GETr_Trans1) apply (simp add: GETr_def) 
       apply (rule GETr_Trans2) apply (simp add: GETr_def) apply simp+
     apply clarsimp apply (simp add: GETr_def)
   apply clarsimp apply (simp add: ContextF4) apply rule
     apply clarsimp apply (rule GETr_Trans1) apply (rule GETr_Trans1) apply (rule GETr_Trans1) apply (simp add: GETr_def) apply simp+
                    apply (rule GETr_Trans2) apply (rule GETr_Trans2) apply (rule GETr_Trans2) apply (simp add: GETr_def) apply simp+
     apply (rule, clarsimp) 
       apply (rule GETr_Trans1) apply (rule GETr_Trans1) apply (simp add: GETr_def) apply simp+
       apply (rule GETr_Trans2) apply (rule GETr_Trans2) apply (simp add: GETr_def) apply simp+ 
    apply clarsimp apply (erule disjE) 
      apply clarsimp 
        apply (rule GETr_Trans1) apply (simp add: GETr_def) 
        apply (rule GETr_Trans2) apply (simp add: GETr_def) apply simp+
    apply clarsimp apply (simp add: GETr_def)
  apply clarsimp
  apply clarsimp
  apply clarsimp apply (simp add: ContextF4 ContextF11)
  apply clarsimp apply (simp add: ContextF4 ContextF11)
  apply clarsimp apply (simp add: ContextF4 ContextF11)
done

lemma HeapSortContext_good: "goodContext FST MST HeapSortContext"
apply (simp add: goodContext_def)
apply (simp only: HeapSortContext_def)
apply (rule, rule, rule)
apply (rule disjI2, rule disjI2)
apply safe
(*Insert*)
    apply clarsimp
    apply (rule vdm_conseq, rule Insert_DAss)
    apply (simp add: HeapSortContext_def)
    apply clarsimp
    apply (simp add: MST_def Meth_Insert Insert_Spec_def newframe_env_def evalARGS_def self_def) 
    apply (erule DAss_PConst) 
(*Insert*)
    apply clarsimp
    apply (rule vdm_conseq, rule Insert_DAss)
    apply (simp add: HeapSortContext_def)
    apply clarsimp
    apply (simp add: MST_def Meth_Insert Insert_Spec_def newframe_env_def evalARGS_def self_def) 
    apply (erule DAss_PConst) 
(*Insert*)
    apply clarsimp
    apply (rule vdm_conseq, rule Insert_DAss)
    apply (simp add: HeapSortContext_def)
    apply clarsimp
    apply (simp add: MST_def Meth_Insert Insert_Spec_def newframe_env_def evalARGS_def self_def) 
    apply (erule DAss_PConst)
(*Removesome*)
    apply clarsimp
    apply (rule vdm_conseq, rule Removesome_DAss)
    apply (simp add: HeapSortContext_def)
    apply clarsimp
    apply (simp add: MST_def Meth_Removesome Removesome_Spec_def newframe_env_def evalARGS_def self_def) 
    apply (erule DAss_PConst)  
(*Removetop*)
    apply clarsimp
    apply (rule vdm_conseq, rule Removetop_DAss)
    apply (simp add: HeapSortContext_def)
    apply clarsimp
    apply (simp add: MST_def Meth_Removetop Removetop_Spec_def newframe_env_def evalARGS_def self_def) 
    apply (erule DAss_PConst) 
(*Extract*)
    apply clarsimp
    apply (rule vdm_conseq, rule Extract_DAss)
    apply (simp add: HeapSortContext_def)
    apply clarsimp
    apply (simp add: MST_def Meth_Extract Extract_Spec_def newframe_env_def evalARGS_def self_def) 
    apply (erule DAss_PConst) 
(*Make_heap*)
    apply clarsimp
    apply (rule vdm_conseq, rule Make_heap_DAss)
    apply (simp add: HeapSortContext_def)
    apply clarsimp
    apply (simp add: MST_def Meth_Make_heap Make_heap_Spec_def newframe_env_def evalARGS_def self_def) 
    apply (erule DAss_PConst)
 (*Make_heap*)
    apply clarsimp
    apply (rule vdm_conseq, rule Make_heap_DAss)
    apply (simp add: HeapSortContext_def)
    apply clarsimp
    apply (simp add: MST_def Meth_Make_heap Make_heap_Spec_def newframe_env_def evalARGS_def self_def) 
    apply (erule DAss_PConst)
(*Siftdown*)
    apply clarsimp
    apply (rule vdm_conseq, rule Siftdown_DAss)
    apply (simp add: HeapSortContext_def)
    apply clarsimp
    apply (simp add: MST_def Meth_Siftdown Siftdown_Spec_def newframe_env_def evalARGS_def self_def) 
    apply (erule DAss_PConst)  
(*Siftdown*)
    apply clarsimp
    apply (rule vdm_conseq, rule Siftdown_DAss)
    apply (simp add: HeapSortContext_def)
    apply clarsimp
    apply (simp add: MST_def Meth_Siftdown Siftdown_Spec_def newframe_env_def evalARGS_def self_def) 
    apply (erule DAss_PConst)
(*Siftdown*)
    apply clarsimp
    apply (rule vdm_conseq, rule Siftdown_DAss)
    apply (simp add: HeapSortContext_def)
    apply clarsimp
    apply (simp add: MST_def Meth_Siftdown Siftdown_Spec_def newframe_env_def evalARGS_def self_def) 
    apply (erule DAss_PConst)
(*Sort*)
    apply clarsimp
    apply (rule vdm_conseq, rule Sort_DAss)
    apply (simp add: HeapSortContext_def)
    apply clarsimp
    apply (simp add: MST_def Meth_Sort Sort_Spec_def newframe_env_def evalARGS_def self_def) 
    apply (erule DAss_PConst)
done

text {*Thus, we can prove that arbitrary invocations of @{text Sort} honour
       the entry in the specification table, in the empty VDM context.*}
theorem "\<rhd> HS\<bullet>Sort([RNarg x]): MST Sort ([RNarg x] @ [VALarg (RVal Nullref)])"
apply (rule GCInvs)
apply (rule HeapSortContext_good)
apply (simp_all add: HeapSortContext_def)
apply fastsimp
done 

end

