theory HeapSort21 = HPSortProg:

text {*This corresponds to the following specifications, formalised from the viewpoint of the
       method bodies: the contexts (in second parameter of @{text DAss}) are the contexts in which
       the method bodies are typed*}
constdefs SPEC::"mname \<Rightarrow> vdmassn"
"SPEC M == (if M = Insert then \<lbrace> {t_}, 1, (emptyfinmap(t_ \<mapsto>\<^sub>f(TreeET 0))) \<ggreater> (TreeET 0), 0\<rbrace> else
            if M = Removesome then \<lbrace> {t_}, 0, (emptyfinmap(t_ \<mapsto>\<^sub>f(TreeET 0))) \<ggreater> (ResultET 0 (TreeET 0) 0), 0\<rbrace> else
            if M = Removetop then \<lbrace> {t_}, 0, (emptyfinmap(t_ \<mapsto>\<^sub>f(TreeET 0))) \<ggreater> (ResultET 0 (TreeET 0) 0), 0\<rbrace> else
            if M = Make_heap then \<lbrace> {l_}, 0, (emptyfinmap(l_ \<mapsto>\<^sub>f(ListET 0))) \<ggreater> (TreeET 0), 0\<rbrace> else
            if M = Extract then \<lbrace> {h_}, 0, (emptyfinmap(h_ \<mapsto>\<^sub>f(TreeET 0))) \<ggreater> (ListET 0), 0\<rbrace> else
            if M = Siftdown then \<lbrace> {t1_, t2_}, 1, (emptyfinmap(t1_ \<mapsto>\<^sub>f(TreeET 0))(t2_ \<mapsto>\<^sub>f(TreeET 0))) \<ggreater> (TreeET 0), 0\<rbrace> else
            if M = Sort then \<lbrace> {l_}, 0, (emptyfinmap(l_ \<mapsto>\<^sub>f(ListET 0))) \<ggreater> (ListET 0), 0\<rbrace> else 
            (\<lambda> E h hh v p . False))"

constdefs FST :: FS_T
 "FST == (\<lambda> f E h hh v p . False)"

constdefs MST :: MS_T
"MST == (\<lambda> M args E h hh v p. SPEC M (newframe_env ((fst (methtable HS M)) @ [RNpar self]) args E) h hh v p)"

declare DOM_def[simp]
declare GETr_def[simp]
declare FMAPlookup1[simp]

lemma Sort_Invoke:
"MST Sort [RNarg x, VALarg (RVal Nullref)] E h hh v p 
 \<Longrightarrow> \<lbrace> {x}, 0 , (emptyfinmap(x \<mapsto>\<^sub>f(ListET 0)))  \<ggreater> (ListET 0) , 0 \<rbrace> E h hh v p"
apply (simp add: MST_def SPEC_def Meth_Sort newframe_env_def evalARGS_def self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=CS in allE, erule_tac x=F in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (simp add: regionsExist_def) 
apply (simp add: regionsDistinct_def)
apply (simp add: distinctFrom_def)
apply (erule ContextSize.elims, clarsimp+)
  apply (erule ContextSize.elims, clarsimp+)
  apply (rule ContextSizeCONS) apply simp+
  apply (rule ContextSizeNIL) apply simp+
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (simp add: modified_def Bounded_def)+
done

(*lemma CS_NIL:"(E,h,{},C, 0) : ContextSize"
by (rule ContextSizeNIL, auto)
lemma CS_CONS: "\<lbrakk>x \<in> U;  (RVal (E\<lfloor>x\<rfloor>), h, fmap_lookup C x, R,n): reg; U = V \<union> {x}; x \<notin> V; (E,h,V,C,m):ContextSize\<rbrakk>
                  \<Longrightarrow> (E,h,U,C,n+m) : ContextSize"
apply (erule ContextSizeCONS) apply simp apply fastsimp apply simp 
done
lemmas A = CS_CONS[elim_format]

inductive_cases CS_elim:
"(E,h,{},C, 0) : ContextSize"
"(E,h,U \<union> {x},C,n+m) : ContextSize"

lemma CS_ELIM:
"\<lbrakk>(E, h, U, C, nm) : ContextSize; 
         \<lbrakk>U={};nm=0\<rbrakk> \<Longrightarrow> P;
         !! V x R n m. \<lbrakk>U = V \<union> {x}; x \<notin> V; (RVal (E\<lfloor>x\<rfloor>),h,fmap_lookup C x,R,n):reg; (E,h,V,C,m):ContextSize;
                      nm = n+m\<rbrakk> \<Longrightarrow> P\<rbrakk> \<Longrightarrow> P"
apply (erule ContextSize.elims) apply fast apply clarsimp
apply (subgoal_tac "U = insert x (U-{x})", auto)
done

lemma CS_distr:"(E, h, U, C, nm) : ContextSize \<Longrightarrow>
       (U={} \<and> nm=0) \<or> 
       (\<exists> x V m n R. U = V \<union> {x} \<and> x \<notin> V \<and> (RVal (E\<lfloor>x\<rfloor>),h,fmap_lookup C x,R,n):reg \<and> (E,h,V,C,m):ContextSize \<and> nm = n+m)"
apply (erule ContextSize.elims,fast)
apply (rule disjI2)
apply clarsimp
apply (rule_tac x=x in exI, rule_tac x="U-{x}" in exI, clarsimp)
apply fast
done
*)

(*lemma Siftdown_Invoke:
"\<lbrakk>MST Siftdown [INarg x, RNarg y, RNarg z, VALarg (RVal Nullref)] E h hh v p; y \<noteq> z\<rbrakk> \<Longrightarrow>
  \<lbrace> {y,z} , 1 , (emptyfinmap(y \<mapsto>\<^sub>f(TreeET 0))(z \<mapsto>\<^sub>f(TreeET 0))) \<ggreater>  (TreeET 0), 0 \<rbrace> E h hh v p"
apply (simp add: MST_def SPEC_def Meth_Siftdown newframe_env_def evalARGS_def self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=CS in allE, erule_tac x=F in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (simp add: regionsExist_def)
  apply clarsimp apply (erule disjE)
    apply clarsimp apply (erule_tac x=z in allE, simp)
    apply clarsimp apply (erule_tac x=y in allE, clarsimp)
apply (simp add: regionsDistinct_def, clarsimp)
 apply (erule disjE, clarsimp)
  apply (erule disjE, clarsimp)
  apply (erule_tac x=y in allE, erule_tac x=z in allE, erule_tac x=Rx in allE, erule_tac x=Rxx in allE, erule impE, clarsimp)
   apply fast apply fast
   apply clarsimp
  apply (erule disjE, clarsimp)
  apply (erule_tac x=y in allE, erule_tac x=z in allE, erule_tac x=Rxx in allE, erule_tac x=Rx in allE, erule impE, clarsimp)
   apply (fast, fast) 
   apply clarsimp 
apply (simp add: distinctFrom_def, clarsimp)
  apply (erule disjE, clarsimp)
    apply (erule_tac x=y in allE, clarsimp) 
  apply fastsimp
  apply fastsimp
apply (drule CS_distr, clarsimp)
apply (drule CS_distr, clarsimp)
apply (erule disjE, clarsimp)
apply (rule CS_CONS) prefer 3 apply simp apply simp apply simp apply clarsimp
apply (erule ContextSize.elims, safe) 
  apply fast
  apply (rule ) defer 1 defer 1 apply simp apply (rule ContextSizeCONS) apply assumption
   apply (erule ContextSize.elims, clarsimp+) apply (erule ContextSize.elims, clarsimp+)
   apply (rule ContextSizeCONS) apply (subgoal_tac "t1_: {t1_,t2_}", assumption,fast) 
   apply simp 
   apply (rule ContextSizeCONS) apply simp+
   apply (rule ContextSizeNIL) apply simp+
  apply (subgoal_tac "{y,z} - {z} = {y}", clarsimp) apply (erule ContextSize.elims, safe) apply fast
  apply simp apply (erule ContextSize.elims, safe) 
    apply (rule ContextSizeCONS) apply (subgoal_tac "t1_: {t1_,t2_}", assumption,fast)  apply fastsimp
    apply (rule ContextSizeCONS) apply simp+ 
    apply (rule ContextSizeNIL) apply simp+
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (simp add: modified_def, clarsimp)
  apply (erule_tac x=l in allE, erule impE, clarsimp)
  apply (erule disjE)
  apply clarsimp apply (erule_tac x=y in allE, erule_tac x=Rz in allE, erule impE, clarsimp)
    apply fast
    apply fast
  apply clarsimp apply (erule_tac x=z in allE, erule_tac x=Rz in allE, erule impE, clarsimp)
    apply fast
    apply fast
  apply assumption
apply (simp add: Bounded_def, rule, rule)
  apply (rotate_tac -4, erule thin_rl) apply (erule_tac x=l in allE, erule impE, assumption)
  apply (erule disjE, erule disjI1) apply (rule disjI2, clarsimp)
  apply (erule disjE)
  apply clarsimp apply (rule_tac x=y in exI, clarsimp) apply fast
  apply clarsimp apply (rule_tac x=z in exI, clarsimp) apply fast
apply (simp add: Bounded_def, rule, rule)
  apply (rotate_tac -5, erule thin_rl) apply (erule_tac x=l in allE, erule impE, assumption)
  apply (erule disjE, erule disjI1) apply (rule disjI2, clarsimp)
  apply (erule disjE)
  apply clarsimp apply (rule_tac x=y in exI, clarsimp) apply fast
  apply clarsimp apply (rule_tac x=z in exI, clarsimp) apply fast
done
*)
lemma Siftdown_Invoke:
"\<lbrakk>MST Siftdown [INarg x, RNarg y, RNarg z, VALarg (RVal Nullref)] E h hh v p; y \<noteq> z\<rbrakk> \<Longrightarrow>
  \<lbrace> {y,z} , 1 , (emptyfinmap(y \<mapsto>\<^sub>f(TreeET 0))(z \<mapsto>\<^sub>f(TreeET 0))) \<ggreater>  (TreeET 0), 0 \<rbrace> E h hh v p"
apply (simp add: MST_def SPEC_def Meth_Siftdown newframe_env_def evalARGS_def self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=CS in allE, erule_tac x=F in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (simp add: regionsExist_def, fastsimp)
apply (simp add: regionsDistinct_def, fastsimp)
apply (simp add: distinctFrom_def, fastsimp)
apply (erule ContextSize.elims, safe, clarsimp+) 
   apply (erule ContextSize.elims, safe, clarsimp+) apply (erule ContextSize.elims, safe, clarsimp+)
   apply (rule ContextSizeCONS) apply fastsimp apply simp+
   apply (rule ContextSizeCONS) apply fastsimp apply simp+ 
   apply (rule ContextSizeNIL) apply fastsimp apply simp+
   apply (subgoal_tac "{y,z} - {z} = {y}", clarsimp)
 apply (erule ContextSize.elims, safe, clarsimp+) 
   apply (erule ContextSize.elims, safe, clarsimp+) 
   apply (rule ContextSizeCONS) apply fastsimp apply simp+ 
   apply (rule ContextSizeCONS) apply fastsimp apply simp+ 
   apply (rule ContextSizeNIL) apply fastsimp apply simp+
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (simp add: modified_def, fastsimp)
apply (simp add: Bounded_def, fastsimp)
  (*simp add: Bounded_def, rule, rule)
  apply (rotate_tac -4, erule thin_rl) apply (erule_tac x=l in allE, erule impE, assumption)
  apply (erule disjE, erule disjI1) apply (rule disjI2, clarsimp)
  apply (erule disjE)
  apply clarsimp apply (rule_tac x=y in exI, clarsimp) apply fast
  apply clarsimp apply (rule_tac x=z in exI, clarsimp) apply fast*)
apply (simp add: Bounded_def, fastsimp)
  (*apply (simp add: Bounded_def, rule, rule)
  apply (rotate_tac -5, erule thin_rl) apply (erule_tac x=l in allE, erule impE, assumption)
  apply (erule disjE, erule disjI1) apply (rule disjI2, clarsimp)
  apply (erule disjE)
  apply clarsimp apply (rule_tac x=y in exI, clarsimp) apply fast
  apply clarsimp apply (rule_tac x=z in exI, clarsimp) apply fast*)
done

lemma Sort_Invoke:
"MST Sort [RNarg x, VALarg (RVal Nullref)] E h hh v p 
 \<Longrightarrow> \<lbrace> {x}, 0 , (emptyfinmap(x \<mapsto>\<^sub>f(ListET 0)))  \<ggreater> (ListET 0) , 0 \<rbrace> E h hh v p"
apply (simp add: MST_def SPEC_def Meth_Sort newframe_env_def evalARGS_def self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=CS in allE, erule_tac x=F in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (simp add: regionsExist_def)
apply (simp add: regionsDistinct_def)
apply (simp add: distinctFrom_def)
apply (erule ContextSize.elims, clarsimp+)
  apply (erule ContextSize.elims, clarsimp+)
  apply (rule ContextSizeCONS) apply simp+ 
  apply (rule ContextSizeNIL) apply simp+
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (simp add: modified_def)
apply (simp add: Bounded_def)
apply (simp add: Bounded_def)
done

lemma Make_heap_Invoke:
"MST Make_heap [RNarg x, VALarg (RVal Nullref)] E h hh v p 
 \<Longrightarrow> \<lbrace> {x}, 0 , (emptyfinmap(x \<mapsto>\<^sub>f(ListET 0)))  \<ggreater> (TreeET 0) , 0 \<rbrace> E h hh v p"
apply (simp add: MST_def SPEC_def Meth_Make_heap newframe_env_def evalARGS_def self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=CS in allE, erule_tac x=F in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (simp add: regionsExist_def)
apply (simp add: regionsDistinct_def)
apply (simp add: distinctFrom_def)
apply (erule ContextSize.elims, clarsimp+)
  apply (erule ContextSize.elims, clarsimp+)
  apply (rule ContextSizeCONS) apply simp+
  apply (rule ContextSizeNIL) apply simp+
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (simp add: modified_def)
apply (simp add: Bounded_def)
apply (simp add: Bounded_def)
done

lemma Extract_Invoke:
"MST Extract [RNarg x, VALarg (RVal Nullref)] E h hh v p 
\<Longrightarrow> \<lbrace> {x}, 0 , (emptyfinmap(x \<mapsto>\<^sub>f(TreeET 0)))  \<ggreater> (ListET 0) , 0 \<rbrace> E h hh v p"
apply (simp add: MST_def SPEC_def Meth_Extract newframe_env_def evalARGS_def self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=CS in allE, erule_tac x=F in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (simp add: regionsExist_def)
apply (simp add: regionsDistinct_def)
apply (simp add: distinctFrom_def)
apply (erule ContextSize.elims, clarsimp+)
  apply (erule ContextSize.elims, clarsimp+)
  apply (rule ContextSizeCONS) apply simp+
  apply (rule ContextSizeNIL) apply simp+
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (simp add: modified_def)
apply (simp add: Bounded_def)
apply (simp add: Bounded_def)
done

lemma Insert_Invoke:
"MST Insert [INarg x, RNarg y, VALarg (RVal Nullref)] E h hh v p 
\<Longrightarrow> \<lbrace> {y} , 1 , (emptyfinmap(y \<mapsto>\<^sub>f(TreeET 0))) \<ggreater>  (TreeET 0), 0 \<rbrace> E h hh v p"
apply (simp add: MST_def SPEC_def Meth_Insert newframe_env_def evalARGS_def self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=CS in allE, erule_tac x=F in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (simp add: regionsExist_def)
apply (simp add: regionsDistinct_def)
apply (simp add: distinctFrom_def)
apply (erule ContextSize.elims, clarsimp+)
  apply (erule ContextSize.elims, clarsimp+)
  apply (rule ContextSizeCONS) apply simp+
  apply (rule ContextSizeNIL) apply simp+
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (simp add: modified_def)
apply (simp add: Bounded_def)
apply (simp add: Bounded_def)
done

lemma Removetop_Invoke:
"MST Removetop [RNarg x, VALarg (RVal Nullref)] E h hh v p 
\<Longrightarrow> \<lbrace> {x} , 0 , (emptyfinmap(x \<mapsto>\<^sub>f(TreeET 0))) \<ggreater>  (ResultET 0 (TreeET 0) 0), 0 \<rbrace> E h hh v p"
apply (simp add: MST_def SPEC_def Meth_Removetop newframe_env_def evalARGS_def self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=CS in allE, erule_tac x=F in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (simp add: regionsExist_def)
apply (simp add: regionsDistinct_def)
apply (simp add: distinctFrom_def)
apply (erule ContextSize.elims, clarsimp+)
  apply (erule ContextSize.elims, clarsimp+)
  apply (rule ContextSizeCONS) apply simp+
  apply (rule ContextSizeNIL) apply simp+
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (simp add: modified_def)
apply (simp add: Bounded_def)
apply (simp add: Bounded_def)
done

lemma Removesome_Invoke:
"MST Removesome [RNarg x, VALarg (RVal Nullref)] E h hh v p 
\<Longrightarrow> \<lbrace> {x} , 0 , (emptyfinmap(x \<mapsto>\<^sub>f(TreeET 0))) \<ggreater>  (ResultET 0 (TreeET 0) 0), 0 \<rbrace> E h hh v p"
apply (simp add: MST_def SPEC_def Meth_Removesome newframe_env_def evalARGS_def self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=CS in allE, erule_tac x=F in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (simp add: regionsExist_def)
apply (simp add: regionsDistinct_def)
apply (simp add: distinctFrom_def)
apply (erule ContextSize.elims, clarsimp+)
  apply (erule ContextSize.elims, clarsimp+)
  apply (rule ContextSizeCONS) apply simp+
  apply (rule ContextSizeNIL) apply simp+
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (simp add: modified_def)
apply (simp add: Bounded_def)
apply (simp add: Bounded_def)
done

text {*The definition of the formal parameters of functions.
       Used in rule DA\_CutCall, i.e. only necessary for
       functions which are merge points. params could be made
       part of the function table, similar to the first components
       in the entries in the method table.*}
defs params_def:
"params f == (if f = felevenSiftdown then [r8_,r7_,r5_,r4_] else 
              if f = ffourSiftdown then [r8_,r7_,r5_,r4_] else [])"

text {*In order to prove the body correct we define a 
       context which contains an one entry for each syntactic method invocation.*}
constdefs  HeapSortContext:: vdmcontext
"HeapSortContext \<equiv> {(HS\<bullet>Insert([INarg x_,RNarg r2_]), MST Insert [INarg x_,RNarg r2_,VALarg (RVal Nullref)]),
                    (HS\<bullet>Insert([INarg v4_,RNarg r2_]), MST Insert [INarg v4_,RNarg r2_,VALarg (RVal Nullref)]),
                    (HS\<bullet>Insert([INarg v2_,RNarg l_]), MST Insert [INarg v2_,RNarg l_,VALarg (RVal Nullref)]),
                    (HS\<bullet>Removesome([RNarg r1_]), MST Removesome [RNarg r1_,VALarg (RVal Nullref)]),
                    (HS\<bullet>Removetop([RNarg h_]), MST Removetop [RNarg h_,VALarg (RVal Nullref)]),
                    (HS\<bullet>Extract([RNarg r1_]), MST Extract [RNarg r1_,VALarg (RVal Nullref)]),
                    (HS\<bullet>Make_heap([RNarg l_]), MST Make_heap [RNarg l_,VALarg (RVal Nullref)]),
                    (HS\<bullet>Make_heap([RNarg r1_]), MST Make_heap [RNarg r1_,VALarg (RVal Nullref)]),
                    (HS\<bullet>Siftdown([INarg v2_, RNarg r3_, RNarg r1_]), MST Siftdown [INarg v2_, RNarg r3_, RNarg r1_,VALarg (RVal Nullref)]),
                    (HS\<bullet>Siftdown([INarg w_, RNarg r5_, RNarg r4_]), MST Siftdown [INarg w_, RNarg r5_, RNarg r4_,VALarg (RVal Nullref)]),
                    (HS\<bullet>Siftdown([INarg w_, RNarg r8_, RNarg r7_]), MST Siftdown [INarg w_, RNarg r8_, RNarg r7_,VALarg (RVal Nullref)]),
                    (HS\<bullet>Sort([RNarg l_]), MST Sort [RNarg l_,VALarg (RVal Nullref)])}"

lemma Invoke: "\<lbrakk>(HS\<bullet>M(L), MST M (L @ [VALarg (RVal Nullref)])): G;
                 \<forall> E h hh v p. MST M (L @ [VALarg (RVal Nullref)]) E h hh v p \<longrightarrow> \<lbrace> U , n , C \<ggreater> T , m \<rbrace> E h hh v p;
                \<forall> x. x:U \<longrightarrow> GETr D x = GETr C x\<rbrakk>
      \<Longrightarrow> G \<rhd>  (HS\<bullet>M(L)) : \<lbrace> U , n , D \<ggreater> T , m \<rbrace> "
apply (rule vdm_conseq)  apply(rule vdm_ax) apply simp apply clarsimp apply (rule DAss_Contexts_same_on_U) apply fast apply fastsimp done

lemma DA_InvokeConst: "\<lbrakk>(HS\<bullet>M(L), MST M (L @ [VALarg (RVal Nullref)])): G;
                 \<forall> E h hh v p. MST M (L @ [VALarg (RVal Nullref)]) E h hh v p \<longrightarrow> \<lbrace> U , n , C \<ggreater> T , m \<rbrace> E h hh v p;
                \<forall> x. x:U \<longrightarrow> GETr D x = GETr C x;
                   nk = n+k; mk = m+ k\<rbrakk>
      \<Longrightarrow> G \<rhd>  (HS\<bullet>M(L)) : \<lbrace> U , nk , D \<ggreater> T , mk \<rbrace> "
by (rule DA_Const, erule Invoke, fastsimp+)

lemma DA_Letr_InvokeConst: 
  "\<lbrakk>(HS\<bullet>M(L), MST M (L @ [VALarg (RVal Nullref)])): G;
     \<forall> E h hh v p. MST M (L @ [VALarg (RVal Nullref)]) E h hh v p \<longrightarrow> \<lbrace> U , n , C \<ggreater> T1 , m \<rbrace> E h hh v p;
     \<forall> x. x:U \<longrightarrow> GETr D x = GETr C x;
     nk = n+k; mk = m+ k; T1 \<notin> {IntET, UnitET};
     G \<rhd> e : \<lbrace> V , mk , D(x\<mapsto>\<^sub>fT1) \<ggreater> T , l \<rbrace>;
     U \<inter> (V-{x})={};
     W = U \<union> (V-{x}) \<rbrakk>
   \<Longrightarrow> G \<rhd>  (LET rf x = HS\<bullet>M(L) IN e END) : \<lbrace> W , nk , D \<ggreater> T , l \<rbrace> "
by (rule DA_letr, erule DA_InvokeConst, assumption+)

lemma DA_NullResult: "\<lbrakk>n=m+kN\<rbrakk> \<Longrightarrow> GG \<rhd> Null: DAss {} n G (ResultET kN TT kS) m"
by (rule DA_NullRes, fastsimp+)

lemma DA_NullList: "GG \<rhd> Null: DAss {} n G (ListET k) n"
by (rule DA_NullNoRes, fastsimp+)

lemma DA_NullTree: "GG \<rhd> Null: DAss {} n G (TreeET k) n"
by (rule DA_NullNoRes, fastsimp+)

lemma DA_LetrNull: 
  "\<lbrakk>G \<rhd> e : DAss U m (C(x\<mapsto>\<^sub>fT1)) T2 k;
   G \<rhd> Null : DAss {} n C T1 m; T1 \<notin> {IntET, UnitET}\<rbrakk>
 \<Longrightarrow> G \<rhd> (LET rf x = Null IN e END): DAss (U-{x}) n C T2 k"
by (erule DA_letr, simp+)

lemma DA_LetrMakeTree:
     "\<lbrakk>GETr C y = Some (TreeET k);GETr C z = Some (TreeET k); y\<noteq>z; n=(Suc m + k);
        G \<rhd> e : DAss U m (C(x\<mapsto>\<^sub>fTreeET(k))) T l;
        {y,z} \<inter> (U-{x}) = {}; UU=({y,z} \<union> (U-{x}))\<rbrakk>
     \<Longrightarrow> G \<rhd> (LET rf x = DIAM\<bullet>Make_IIDD ([VALarg (IVal 3), INarg v, RNarg y, RNarg z]) IN e END): DAss UU n C T l"
by (rule DA_letr, erule DA_MakeTree, simp+)

lemma DA_MakeResultSome1: 
"\<lbrakk>GETr C y = Some (TreeET k); n=(Suc m + kS)\<rbrakk> \<Longrightarrow>
  G \<rhd> (DIAM\<bullet>Make_IID ([VALarg (IVal 1), INarg x, RNarg y])) :  DAss {y} n C (ResultET kN (TreeET k) kS) m"
(*<*)
by(rule DA_MakeResultSome, fastsimp+)
(*
consts rest :: "(Context \<times> (rname set) \<times> Context) set"
inductive rest intros
restEMP:"(C,{},emptyfinmap):rest"
restNONE:"\<lbrakk>(C,S,D):rest; SS = S \<union> {x}; x \<notin> S; GETr C x = None\<rbrakk> \<Longrightarrow> (C,SS,D):rest"
restSOME:"\<lbrakk>(C,S,D):rest; SS = S \<union> {x}; x \<notin> S; GETr C x = Some T\<rbrakk> \<Longrightarrow> (C,SS,D(x\<mapsto>\<^sub>fT)):rest"

lemma "(C,S,D):rest \<Longrightarrow> (\<forall> x . (x: S  \<longrightarrow> fmap_lookup C x = fmap_lookup D x) \<and> (x \<notin> S \<longrightarrow> fmap_lookup D x = None))"
apply (erule rest.induct)
apply clarsimp
apply clarsimp
apply clarsimp
apply (subgoal_tac "fmap_lookup (D(x\<mapsto>\<^sub>fT)) xa =  fmap_lookup D xa", simp)
apply (rule FMAPlookup1)
apply fast
done
*)

lemma RestrNotIn[rule_format]: "x \<notin> set S \<Longrightarrow> (\<forall> C . GETr (restr C S) x = None)"
apply (induct S)
apply clarsimp
apply clarify
apply (case_tac "GETr C a", clarsimp)
apply clarsimp
done

lemma RestrIn[rule_format]: "x:set S \<Longrightarrow> (\<forall> C . GETr C x = GETr (restr C S) x)"
apply (induct S) apply clarsimp
apply (case_tac "x=a")
(*x=a*)
apply clarify
  apply (case_tac "GETr C x")
  (*GETr C x = None*)
    apply (case_tac "x: set list")
    apply clarsimp 
    apply (subgoal_tac "GETr (restr C (x # list)) x = GETr (restr C list) x")
    apply (subgoal_tac "GETr (restr C list) x = None", clarsimp, erule RestrNotIn) 
    apply clarsimp
  (*GETr C x = Some aa*)
    apply clarsimp
(*x \<noteq>a*)
apply clarify
  apply (subgoal_tac "\<forall>C. GETr C x = GETr (restr C list) x ") prefer 2 apply simp
  apply (erule_tac x=C in allE) 
  apply (erule thin_rl)
  apply (subgoal_tac "GETr (restr C list) x = GETr (restr C (a # list)) x", clarsimp)
  apply (case_tac "GETr C a")
  apply clarsimp apply clarsimp
done

lemma DA_CutCall1:
  "\<lbrakk>U \<subseteq> set (params f); (CALL f, DAss U n (restr C (params f)) T m) : G\<rbrakk>
   \<Longrightarrow> G \<rhd> (CALL f): DAss U n C T m"
apply (rule DA_Contexts_same_on_U,erule vdm_ax)
apply clarify
apply (rule RestrIn,fast)
done

constdefs isMergePoint :: "funame \<Rightarrow> bool"
"isMergePoint f == f \<in> {ffourSiftdown, felevenSiftdown}"

lemma DA_Call2_MP:"\<lbrakk>\<not> isMergePoint f; G \<rhd> (funtable f) : DAss U n C T m\<rbrakk> \<Longrightarrow> G \<rhd> (CALL f) : DAss U n C T m"
by (rule DA_Call2)

lemma DA_CutCall1_MP[rule_format]:
  "\<lbrakk>isMergePoint f; (CALL f, DAss U n (restr C (params f)) T m) : G; U \<subseteq> set (params f)\<rbrakk>
  \<Longrightarrow> G \<rhd> (CALL f): DAss U n C T m"
by (erule DA_CutCall1, assumption)


lemma DA_Call1_MP:
  "\<lbrakk>(\<not> isMergePoint f \<and> G \<rhd> (funtable f) : DAss U n C T m) \<or>
    (isMergePoint f \<and>  (CALL f, DAss U n (restr C (params f)) T m) : G \<and> U \<subseteq> set (params f))\<rbrakk>
  \<Longrightarrow> G \<rhd> (CALL f): DAss U n C T m"
apply (erule disjE)
apply clarsimp apply (erule DA_Call2_MP, assumption)
apply clarsimp apply (erule DA_CutCall1_MP, assumption+)
done

lemma Cutt2Call:"\<lbrakk>({(Call f, Q)} \<union> D) \<rhd> e : P; finite D; contextProvable (D \<union> {(Call f,Q)}) D\<rbrakk> \<Longrightarrow> D \<rhd> e : P"
(*<*)
apply (rule cut2) prefer 2 apply assumption apply fastsimp+ 
done

lemmas MFS_defs = isMergePoint_def
                  Meth_Sort Fun_fSort 
                  Meth_Extract Fun_fExtract Fun_fzeroExtract Fun_foneExtract
                  Meth_Insert Fun_fInsert Fun_fzeroInsert Fun_foneInsert Fun_ftwoInsert Fun_fthreeInsert
                  Meth_Make_heap  Fun_fMake_heap  Fun_fzeroMake_heap Fun_foneMake_heap
                  Meth_Removesome Fun_fRemovesome Fun_fzeroRemovesome Fun_foneRemovesome Fun_ftwoRemovesome  Fun_fthreeRemovesome
                  Meth_Removetop Fun_fRemovetop Fun_fzeroRemovetop Fun_foneRemovetop Fun_ftwoRemovetop  Fun_fthreeRemovetop
                  Meth_Siftdown Fun_fSiftdown Fun_fzeroSiftdown Fun_foneSiftdown Fun_ftwoSiftdown Fun_fthreeSiftdown
                    Fun_ffourSiftdown Fun_ffiveSiftdown Fun_fsixSiftdown Fun_fsevenSiftdown Fun_feightSiftdown
                    Fun_fnineSiftdown Fun_ftenSiftdown Fun_felevenSiftdown Fun_ftwelveSiftdown Fun_fthirteenSiftdown
                    Fun_ffourteenSiftdown Fun_ffifteenSiftdown Fun_fsixteenSiftdown Fun_fseventeenSiftdown 
                    Fun_feighteenSiftdown Fun_fnineteenSiftdown

lemmas DA_rules = DA_Call1_MP DA_Let_Prim DA_Let_RPrim DA_Let_Int DA_Int DA_if DA_LetrMakeTree DA_MakeTree
                  DA_MakeResultSome1 DA_MakeList DA_Letr_InvokeConst DA_InvokeConst

lemmas DA_Nullrules = DA_NullList DA_NullTree DA_NullResult 

text {*The applications of rule Cut2Call occur at the beginning 
       of the immediate dominator of the merge point:
       in f3 for f4, and in f10 for f11*}
lemma Siftdown_DAss:
"\<lbrakk>G = HeapSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable HS Siftdown) : SPEC Siftdown"
apply (simp add: SPEC_def)
apply (rule DA_Weak)
apply (rule Cutt2Call [of ffourSiftdown])
apply ((rule DA_rules) | simp add: MFS_defs)+
apply (rule DA_LetrNull)
apply (rule DA_LetrNull)
apply ((rule DA_rules) | simp add: MFS_defs)+ 
apply (rule DA_Nullrules, simp)
apply (rule DA_Nullrules, simp)
apply ((rule DA_rules) | simp add: MFS_defs)+

apply (rule DA_TreeMatchD, fastsimp, simp) 

apply ((rule DA_rules) | simp add: MFS_defs)+ 
apply (rule DA_LetrNull)
apply (rule DA_LetrNull)

apply ((rule DA_rules) | simp add: MFS_defs)+ 
apply (rule DA_LetrNull)

apply ((rule DA_rules) | simp add: MFS_defs)+ 
apply (rule DA_Nullrules, simp)
apply ((rule DA_rules) | simp add: MFS_defs)+ 
apply (rule DA_Nullrules, simp)
apply (rule DA_Nullrules, simp)
apply ((rule DA_rules) | simp add: MFS_defs)+ 
apply (rule DA_LetrNull)
apply (rule DA_LetrNull)

apply ((rule DA_rules) | simp add: MFS_defs)+ 
apply (rule DA_LetrNull)

apply ((rule DA_rules) | simp add: MFS_defs)+ 
apply (rule DA_Nullrules, simp)
apply ((rule DA_rules) | simp add: MFS_defs)+ 
apply (rule DA_Nullrules, simp)
apply (rule DA_Nullrules, simp)
apply ((rule DA_rules) | simp add: MFS_defs)+ 

apply (rule DA_TreeMatchD, fastsimp, simp)

apply ((rule DA_rules) | simp add: MFS_defs)+

apply (simp add: params_def) apply rule apply fastsimp defer 1

apply ((rule DA_rules) | simp add: MFS_defs)+
apply (simp add: params_def) apply rule apply fastsimp defer 1

apply ((rule DA_rules) | simp add: MFS_defs)+
apply (simp add: params_def)  apply rule apply fastsimp defer 1

apply ((rule DA_rules) | simp add: MFS_defs)+ defer 1
apply ((rule DA_rules) | simp add: MFS_defs)+ defer 1
apply ((rule DA_rules) | simp add: MFS_defs)+ 
apply (simp add: HeapSortContext_def)
apply (simp add: contextProvable_def, clarsimp)
  apply rule prefer 2 apply clarsimp apply (rule vdm_ax) apply simp
apply clarsimp
apply (rule DA_Call2) (* here we don't want to follow the merge-point route !!*)

apply (rule Cutt2Call [of felevenSiftdown])
apply ((rule DA_rules) | simp add: MFS_defs)+
apply (simp add: params_def) apply rule apply fastsimp defer 1
apply ((rule DA_rules) | simp add: MFS_defs)+
apply (simp add: params_def) apply rule apply fastsimp defer 1

apply ((rule DA_rules) | simp add: MFS_defs)+
apply (simp add: params_def) apply rule apply fastsimp defer 1

apply ((rule DA_rules) | simp add: MFS_defs)+
apply (simp add: HeapSortContext_def)
apply (simp add: contextProvable_def, clarsimp)
  apply rule prefer 2 apply clarsimp apply (rule vdm_ax) apply simp
apply clarsimp
apply (rule DA_Call2) (* here we don't want to follow the merge-point route !!*)

apply ((rule DA_rules) | simp add: MFS_defs)+

(*invocation of Siftdown*)
apply (simp add: HeapSortContext_def) apply clarsimp apply (erule Siftdown_Invoke, fastsimp, simp+)
apply ((rule DA_rules) | simp add: MFS_defs)+
(*invocation of Siftdown*)
apply (simp add: HeapSortContext_def) apply clarsimp apply (erule Siftdown_Invoke, fastsimp, simp+)
apply ((rule DA_rules) | simp add: MFS_defs)+

apply fastsimp+
done

(*Here is an alternative proof where the two applications of
  Cut2Call are at the beginning - in order to be able to
  instantiate the function name "f", we use rule Cutt2Call*)
lemma Siftdown_DAss:
"\<lbrakk>G = HeapSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable HS Siftdown) : SPEC Siftdown"
apply (simp add: SPEC_def)
apply (rule DA_Weak)
apply (rule Cutt2Call [of felevenSiftdown])
apply (rule Cutt2Call [of ffourSiftdown])
apply ((rule DA_rules) | simp add: MFS_defs)+
apply (rule DA_LetrNull)
apply (rule DA_LetrNull)
apply ((rule DA_rules) | simp add: MFS_defs)+ 
apply (rule DA_Nullrules, simp)
apply (rule DA_Nullrules, simp)
apply ((rule DA_rules) | simp add: MFS_defs)+

apply (rule DA_TreeMatchD, fastsimp, simp) 

apply ((rule DA_rules) | simp add: MFS_defs)+ 
apply (rule DA_LetrNull)
apply (rule DA_LetrNull)

apply ((rule DA_rules) | simp add: MFS_defs)+ 
apply (rule DA_LetrNull)

apply ((rule DA_rules) | simp add: MFS_defs)+ 
apply (rule DA_Nullrules, simp)
apply ((rule DA_rules) | simp add: MFS_defs)+ 
apply (rule DA_Nullrules, simp)
apply (rule DA_Nullrules, simp)
apply ((rule DA_rules) | simp add: MFS_defs)+ 
apply (rule DA_LetrNull)
apply (rule DA_LetrNull)

apply ((rule DA_rules) | simp add: MFS_defs)+ 
apply (rule DA_LetrNull)

apply ((rule DA_rules) | simp add: MFS_defs)+ 
apply (rule DA_Nullrules, simp)
apply ((rule DA_rules) | simp add: MFS_defs)+ 
apply (rule DA_Nullrules, simp)
apply (rule DA_Nullrules, simp)
apply ((rule DA_rules) | simp add: MFS_defs)+ 

apply (rule DA_TreeMatchD, fastsimp, simp)

apply ((rule DA_rules) | simp add: MFS_defs)+

apply (simp add: params_def) apply rule apply fastsimp defer 1

apply ((rule DA_rules) | simp add: MFS_defs)+
apply (simp add: params_def) apply rule apply fastsimp defer 1

apply ((rule DA_rules) | simp add: MFS_defs)+
apply (simp add: params_def)  apply rule apply fastsimp defer 1

apply ((rule DA_rules) | simp add: MFS_defs)+ defer 1
apply ((rule DA_rules) | simp add: MFS_defs)+ defer 1
apply ((rule DA_rules) | simp add: MFS_defs)+ 
apply (simp add: HeapSortContext_def)
apply (simp add: contextProvable_def, clarsimp)
  apply rule prefer 2 apply rule prefer 2 apply clarsimp apply (rule vdm_ax) apply simp
apply clarsimp
(*In order to fill Q1 we first have to verify f4, since the body of f4 calls f11*)
prefer 2
(*Verification of f4*)
  apply clarsimp
  apply (rule DA_Call2) (* we don't want to follow the merge-point route !!*)
  apply ((rule DA_rules) | simp add: MFS_defs)+
  apply (simp add: params_def) apply rule apply fastsimp defer 1
  apply ((rule DA_rules) | simp add: MFS_defs)+
  apply (simp add: params_def) apply rule apply fastsimp defer 1

  apply ((rule DA_rules) | simp add: MFS_defs)+
  apply (simp add: params_def) apply rule apply fastsimp defer 1

  apply ((rule DA_rules) | simp add: MFS_defs)+
  apply (simp add: params_def) defer 1
  apply (simp add: HeapSortContext_def)
  apply (simp add: contextProvable_def, clarsimp)
    apply rule prefer 2 apply clarsimp apply (rule vdm_ax) apply simp
  apply clarsimp
  (* now the verification of f11*)
  apply (rule DA_Call2) (* we don't want to follow the merge-point route !!*)
  apply ((rule DA_rules) | simp add: MFS_defs)+

  (*invocation of Siftdown*)
  apply (simp add: HeapSortContext_def) apply clarsimp apply (erule Siftdown_Invoke, fastsimp, simp+)
  apply ((rule DA_rules) | simp add: MFS_defs)+
  (*invocation of Siftdown*)
  apply (simp add: HeapSortContext_def) apply clarsimp apply (erule Siftdown_Invoke, fastsimp, simp+)
  apply ((rule DA_rules) | simp add: MFS_defs)+
apply fastsimp+
done

lemma Removesome_DAss:
"\<lbrakk>G = HeapSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable HS Removesome) : SPEC Removesome"
apply (simp add: SPEC_def)
apply (rule DA_Weak)
apply ((rule DA_rules) | simp add: MFS_defs)+

apply (rule DA_Nullrules)
apply ((rule DA_rules) | simp add: MFS_defs)+

apply (rule DA_TreeMatchD, fastsimp, simp) 

apply ((rule DA_rules) | simp add: MFS_defs)+
(*invocation of Removesome*)
apply (simp add: HeapSortContext_def) apply clarsimp apply (erule Removesome_Invoke, fastsimp, simp+)
apply ((rule DA_rules) | simp add: MFS_defs)+

apply (rule DA_ResultMatchD, fastsimp, simp) 

apply ((rule DA_rules) | simp add: MFS_defs)+
apply fast
done

lemma Removetop_DAss:
"\<lbrakk>G = HeapSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable HS Removetop) : SPEC Removetop"
apply (simp add: SPEC_def)
apply (rule DA_Weak)
apply ((rule DA_rules) | simp add: MFS_defs)+

apply (rule DA_Nullrules)
apply ((rule DA_rules) | simp add: MFS_defs)+

apply (rule DA_TreeMatchD, fastsimp, simp) 

apply ((rule DA_rules) | simp add: MFS_defs)+
(*invocation of Removesome*)
apply (simp add: HeapSortContext_def) apply clarsimp apply (erule Removesome_Invoke, fastsimp, simp+)
apply ((rule DA_rules) | simp add: MFS_defs)+

apply (rule DA_ResultMatchD, fastsimp, simp) 

apply ((rule DA_rules) | simp add: MFS_defs)+
(*invocation of Siftdown*)
apply (simp add: HeapSortContext_def) apply clarsimp apply (erule Siftdown_Invoke, fastsimp, simp+)
apply ((rule DA_rules) | simp add: MFS_defs)+
apply fast
done

lemma Make_heap_DAss:
"\<lbrakk>G = HeapSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable HS Make_heap) : SPEC Make_heap"
apply (simp add: SPEC_def)
apply (rule DA_Weak)
apply ((rule DA_rules) | simp add: MFS_defs)+

apply (rule DA_Nullrules)
apply ((rule DA_rules) | simp add: MFS_defs)+

apply (rule DA_ListMatchD) apply (fastsimp, simp)

apply ((rule DA_rules) | simp add: MFS_defs)+
(*invocation of Make_heap*)
apply (simp add: HeapSortContext_def) apply clarsimp apply (erule Make_heap_Invoke, fastsimp, simp+)
apply ((rule DA_rules) | simp add: MFS_defs)+
(*invocation of Insert*)
apply (simp add: HeapSortContext_def) apply clarsimp apply (erule Insert_Invoke) apply(fastsimp, simp+)
done

lemma Extract_DAss:
"\<lbrakk>G = HeapSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable HS Extract) : SPEC Extract"
apply (simp add: SPEC_def)
apply (rule DA_Weak)
apply ((rule DA_rules) | simp add: MFS_defs)+
(*invocation of Removetop*)
apply (simp add: HeapSortContext_def) apply clarsimp apply (erule Removetop_Invoke, fastsimp, simp+)
apply ((rule DA_rules) | simp add: MFS_defs)+

apply (rule DA_Nullrules)
apply ((rule DA_rules) | simp add: MFS_defs)+

apply (rule DA_ResultMatchD) apply (fastsimp, simp)

apply ((rule DA_rules) | simp add: MFS_defs)+ 
(*invocation of Extract*)
apply (simp add: HeapSortContext_def) apply clarsimp apply (erule Extract_Invoke, fastsimp, simp+)
apply ((rule DA_rules) | simp add: MFS_defs)+
done

lemma Insert_DAss:
"\<lbrakk>G = HeapSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable HS Insert) : SPEC Insert"
apply (simp add: SPEC_def)
apply (rule DA_Weak)
apply ((rule DA_rules) | simp add: MFS_defs)+ 
apply (rule DA_LetrNull)
apply (rule DA_LetrNull)
apply ((rule DA_rules) | simp add: MFS_defs)+ 
apply (rule DA_Nullrules)
apply ((rule DA_rules) | simp add: MFS_defs)+
apply (rule DA_Nullrules)
apply ((rule DA_rules) | simp add: MFS_defs)+

apply (rule DA_TreeMatchD, fastsimp, simp) 

apply ((rule DA_rules) | simp add: MFS_defs)+
(*invocation of Insert*)
apply (simp add: HeapSortContext_def) apply clarsimp apply (erule Insert_Invoke, fastsimp, simp+)
apply ((rule DA_rules) | simp add: MFS_defs)+
(*invocation of Insert*)
apply (simp add: HeapSortContext_def) apply clarsimp apply (erule Insert_Invoke, fastsimp, simp+)
apply ((rule DA_rules) | simp add: MFS_defs)+
apply fast
done

lemma Sort_DAss:
"\<lbrakk>G = HeapSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable HS Sort) : SPEC Sort"
apply (simp add: SPEC_def)
apply (rule DA_Weak)
apply ((rule DA_rules) | simp add: MFS_defs)+
(*invocation of Make_heap*)
apply (simp add: HeapSortContext_def) apply clarsimp apply (erule Make_heap_Invoke, fastsimp, simp+)
apply ((rule DA_rules) | simp add: MFS_defs)+
(*invocation of Extract*)
apply (simp add: HeapSortContext_def) apply clarsimp apply (erule Extract_Invoke, fastsimp, simp+) 
done

lemma HeapSortContext_good: "goodContext FST MST HeapSortContext"
apply (simp add: goodContext_def)
apply (simp only: HeapSortContext_def)
apply (rule, rule, rule)
apply (rule disjI2, rule disjI2)
apply safe
(*Insert*)
    apply clarsimp
    apply (rule vdm_conseq, rule Insert_DAss)
    apply (simp add: HeapSortContext_def)
    apply clarify
    apply (simp add: MST_def Meth_Insert SPEC_def newframe_env_def evalARGS_def self_def) 
    apply (erule DAss_PConst) 
(*Insert*)
    apply clarsimp
    apply (rule vdm_conseq, rule Insert_DAss)
    apply (simp add: HeapSortContext_def)
    apply clarify
    apply (simp add: MST_def Meth_Insert SPEC_def newframe_env_def evalARGS_def self_def) 
    apply (erule DAss_PConst) 
(*Insert*)
    apply clarsimp
    apply (rule vdm_conseq, rule Insert_DAss)
    apply (simp add: HeapSortContext_def)
    apply clarify
    apply (simp add: MST_def Meth_Insert SPEC_def newframe_env_def evalARGS_def self_def) 
    apply (erule DAss_PConst)
(*Removesome*)
    apply clarsimp
    apply (rule vdm_conseq, rule Removesome_DAss)
    apply (simp add: HeapSortContext_def)
    apply clarify
    apply (simp add: MST_def Meth_Removesome SPEC_def newframe_env_def evalARGS_def self_def) 
    apply (erule DAss_PConst)  
(*Removetop*)
    apply clarsimp
    apply (rule vdm_conseq, rule Removetop_DAss)
    apply (simp add: HeapSortContext_def)
    apply clarify
    apply (simp add: MST_def Meth_Removetop SPEC_def newframe_env_def evalARGS_def self_def) 
    apply (erule DAss_PConst) 
(*Extract*)
    apply clarsimp
    apply (rule vdm_conseq, rule Extract_DAss)
    apply (simp add: HeapSortContext_def)
    apply clarify
    apply (simp add: MST_def Meth_Extract SPEC_def newframe_env_def evalARGS_def self_def) 
    apply (erule DAss_PConst) 
(*Make_heap*)
    apply clarsimp
    apply (rule vdm_conseq, rule Make_heap_DAss)
    apply (simp add: HeapSortContext_def)
    apply clarify
    apply (simp add: MST_def Meth_Make_heap SPEC_def newframe_env_def evalARGS_def self_def) 
    apply (erule DAss_PConst)
 (*Make_heap*)
    apply clarsimp
    apply (rule vdm_conseq, rule Make_heap_DAss)
    apply (simp add: HeapSortContext_def)
    apply clarify
    apply (simp add: MST_def Meth_Make_heap SPEC_def newframe_env_def evalARGS_def self_def) 
    apply (erule DAss_PConst)
(*Siftdown*)
    apply clarsimp
    apply (rule vdm_conseq, rule Siftdown_DAss)
    apply (simp add: HeapSortContext_def)
    apply clarify
    apply (simp add: MST_def Meth_Siftdown SPEC_def newframe_env_def evalARGS_def self_def) 
    apply (erule DAss_PConst)  
(*Siftdown*)
    apply clarsimp
    apply (rule vdm_conseq, rule Siftdown_DAss)
    apply (simp add: HeapSortContext_def)
    apply clarify
    apply (simp add: MST_def Meth_Siftdown SPEC_def newframe_env_def evalARGS_def self_def) 
    apply (erule DAss_PConst)
(*Siftdown*)
    apply clarsimp
    apply (rule vdm_conseq, rule Siftdown_DAss)
    apply (simp add: HeapSortContext_def)
    apply clarify
    apply (simp add: MST_def Meth_Siftdown SPEC_def newframe_env_def evalARGS_def self_def) 
    apply (erule DAss_PConst)
(*Sort*)
    apply clarsimp
    apply (rule vdm_conseq, rule Sort_DAss)
    apply (simp add: HeapSortContext_def)
    apply clarify
    apply (simp add: MST_def Meth_Sort SPEC_def newframe_env_def evalARGS_def self_def) 
    apply (erule DAss_PConst)
done

text {*Thus, we can prove that arbitrary invocations of @{text Sort} honour
       the entry in the specification table, in the empty VDM context.*}
theorem HSCorrect: "\<rhd> HS\<bullet>Sort([RNarg x]): MST Sort ([RNarg x] @ [VALarg (RVal Nullref)])"
apply (rule GCInvs)
apply (rule HeapSortContext_good)
apply (simp_all add: HeapSortContext_def)
apply fastsimp
done 
theorem "\<rhd> HS\<bullet>Sort([RNarg x]): \<lbrace> {x}, 0 , (emptyfinmap(x \<mapsto>\<^sub>f(ListET 0)))  \<ggreater> (ListET 0) , 0 \<rbrace>"
by (rule vdm_conseq, rule HSCorrect, simp add: Sort_Invoke)

end

(*lemma Sort_DAss:
"\<lbrakk>G = HeapSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable HS Sort) : SPEC Sort"
apply (simp add: Meth_Sort SPEC_def, clarsimp)
apply (rule DA_Weak)
apply (rule DA_Call2)
apply (simp add: Fun_fSort)
apply (rule DA_Letr)
(-invocation of Make_heap-)
apply (simp add: HeapSortContext_def) apply (rule vdm_conseq, rule vdm_ax, simp) apply clarsimp apply (rule DAss_Contexts_same_on_U)
   apply (erule Make_heap_Invoke, fastsimp) 
(-invocation of Extract-)
apply (simp add: HeapSortContext_def) apply (rule vdm_conseq, rule vdm_ax, simp) apply clarsimp apply (rule DAss_Contexts_same_on_U)
  apply (erule Extract_Invoke,fastsimp) 
apply fastsimp+
done

lemma Insert_DAss:
"\<lbrakk>G = HeapSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable HS Insert) : SPEC Insert"
apply (simp add: Meth_Insert SPEC_def, clarsimp)
apply (rule DA_Weak)
apply (rule DA_Call2)
apply (simp add: Fun_fInsert)
apply (rule DA_Let_RPrim)
apply (rule DA_If)
apply (simp_all)
(-first branch-)
apply (rule DA_Call2)
apply (simp only: Fun_fzeroInsert)
apply (rule DA_Letr, rule DA_Null) defer 1 defer 1 defer 1 defer 1 
apply (rule DA_Letr, rule DA_Null) defer 1 defer 1 defer 1 defer 1 
(-invocation of make-)
apply (rule DA_MakeTree, simp+)
(-second branch-)
apply (rule DA_Call2)
apply (simp only:  Fun_foneInsert)
apply (rule DA_TreeMatchD, simp+) 
apply (rule DA_Let_Prim)
apply (rule DA_If)
apply (simp_all (no_asm))
(-f2-branch-)
apply (rule DA_Call2)
apply (simp only: Fun_ftwoInsert)
apply (rule DA_Letr)
(-invocation of Insert-)
apply (rule vdm_conseq, rule vdm_ax) apply (simp add: HeapSortContext_def) apply clarsimp
  apply (rule DAss_Contexts_same_on_U) apply (rule DAss_Const) apply (erule Insert_Invoke) apply simp+ 
(-invocation of make-)
apply (rule DA_MakeTree, simp+)
(-f3-branch-)
apply (rule DA_Call2)
apply (simp only:  Fun_fthreeInsert)
apply (rule DA_Letr)
(-invocation of Insert-)
apply (rule vdm_conseq, rule vdm_ax) apply (simp add: HeapSortContext_def) apply clarsimp
  apply (rule DAss_Contexts_same_on_U) apply (rule DAss_Const) apply (erule Insert_Invoke) apply simp+
(-invocation of make-)
apply (rule DA_MakeTree, simp+)
apply fastsimp
done

lemma Extract_DAss:
"\<lbrakk>G = HeapSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable HS Extract) : SPEC Extract"
apply (simp add: Meth_Extract SPEC_def, clarsimp)
apply (rule DA_Weak)
apply (rule DA_Call2)
apply (simp add: Fun_fExtract)
apply (rule DA_Letr)
(-invocation of Removetop-)
apply (rule vdm_conseq, rule vdm_ax) apply (simp add: HeapSortContext_def) apply clarsimp
  apply (rule DAss_Contexts_same_on_U) apply (rule DAss_Const) apply (erule Removetop_Invoke) apply simp+
apply (rule DA_Let_RPrim)
apply (rule DA_If)
apply (simp_all)
(-fzero-)
apply (rule DA_Call2)
apply (simp only: Fun_fzeroExtract)
apply (rule DA_Null) apply simp+
(-fone-)
apply (rule DA_Call2)
apply (simp only:  Fun_foneExtract)
apply (rule DA_ResultMatchD, fastsimp+) 
apply (rule DA_Letr)
(-invocation of Extract-)
apply (rule vdm_conseq, rule vdm_ax) apply (simp add: HeapSortContext_def) apply clarsimp
  apply (rule DAss_Contexts_same_on_U) apply (rule DAss_Const) apply (erule Extract_Invoke) apply simp+
(-invocation of Make-)
apply (rule DA_MakeList, simp+)
done

lemma Make_heap_DAss:
"\<lbrakk>G = HeapSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable HS Make_heap) : SPEC Make_heap"
apply (simp add: Meth_Make_heap SPEC_def, clarsimp)
apply (rule DA_Weak)
apply (rule DA_Call)
apply (simp add: Fun_fMake_heap)
apply (rule DA_Let_RPrim)
apply (rule DA_If)
apply (simp_all)
(-fzero-)
apply (rule DA_Call2)
apply (simp only: Fun_fzeroMake_heap)
apply (rule DA_Null) apply simp+
(-fone-)
apply (rule DA_Call2)
apply (simp only:  Fun_foneMake_heap)
apply (rule DA_ListMatchD, simp+) 
apply (rule DA_Letr)
(-invocation of Make_heap-)
apply (rule vdm_conseq, rule vdm_ax) apply (simp add: HeapSortContext_def) apply clarsimp
  apply (rule DAss_Contexts_same_on_U) apply (rule DAss_Const) apply (erule Make_heap_Invoke) apply simp+ 
(-invocation of Insert-)
apply (rule vdm_conseq, rule vdm_ax) apply (simp add: HeapSortContext_def) apply clarsimp
  apply (rule DAss_Contexts_same_on_U) apply (rule DAss_Const) apply (erule Insert_Invoke) apply simp+
done

lemma Removesome_DAss:
"\<lbrakk>G = HeapSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable HS Removesome) : SPEC Removesome"
apply (simp add: Meth_Removesome SPEC_def, clarsimp)
apply (rule DA_Weak)
apply (rule DA_Call2)
apply (simp add: Fun_fRemovesome)
apply (rule DA_Let_RPrim)
apply (rule DA_If)
apply (simp_all)
(-fzero-)
apply (rule DA_Call2)
apply (simp only: Fun_fzeroRemovesome)
apply (rule DA_Null) apply simp+
(-fone-)
apply (rule DA_Call2)
apply (simp only:  Fun_foneRemovesome)
apply (rule DA_TreeMatchD, simp+) 
apply (rule DA_Letr)
(-invocation of Removesome-)
apply (rule vdm_conseq, rule vdm_ax) apply (simp add: HeapSortContext_def) apply clarsimp
  apply (rule DAss_Contexts_same_on_U) apply (rule DAss_Const) apply (erule Removesome_Invoke) apply simp+
apply (rule DA_Let_RPrim)
apply (rule DA_If)
(-ftwo-)
apply (rule DA_Call2)
apply (simp only: Fun_ftwoRemovesome)
(-invocation of make-)
apply (rule DA_MakeResultSome, fastsimp+)
(-fthree-)
apply (rule DA_Call2)
apply (simp only: Fun_fthreeRemovesome)
apply (rule DA_ResultMatchD, fastsimp+) 
apply (rule DA_Letr)
(-invocation of make-)
apply (rule DA_MakeTree, fastsimp+)
(-invocation of make-)
apply (rule DA_MakeResultSome, fastsimp+)
done

lemma Removetop_DAss:
"\<lbrakk>G = HeapSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable HS Removetop) : SPEC Removetop"
apply (simp add: Meth_Removetop SPEC_def, clarsimp)
apply (rule DA_Weak)
apply (rule DA_Call2)
apply (simp add: Fun_fRemovetop)
apply (rule DA_Let_RPrim)
apply (rule DA_If)
apply (simp_all)
(-fzero-)
apply (rule DA_Call2)
apply (simp only: Fun_fzeroRemovetop)
apply (rule DA_Null) apply simp+ 
(-fone-)
apply (rule DA_Call2)
apply (simp only:  Fun_foneRemovetop)
apply (rule DA_TreeMatchD, fastsimp+) 
apply (rule DA_Letr)
(-invocation of Removesome-)
apply (rule vdm_conseq, rule vdm_ax) apply (simp add: HeapSortContext_def) apply clarsimp
  apply (rule DAss_Contexts_same_on_U) apply (rule DAss_Const) apply (erule Removesome_Invoke) apply simp+ 
apply (rule DA_Let_RPrim)
apply (rule DA_If)
(-ftwo-)
apply (rule DA_Call2)
apply (simp only: Fun_ftwoRemovetop)
(-invocation of make-)
apply (rule DA_MakeResultSome, fastsimp+)
(-fthree-)
apply (rule DA_Call2)
apply (simp only: Fun_fthreeRemovetop)
apply (rule DA_ResultMatchD, fastsimp+) 
apply (rule DA_Letr)
(-invocation of Siftdown-)
apply (rule vdm_conseq, rule vdm_ax) apply (simp add: HeapSortContext_def) apply clarsimp
  apply (rule DAss_Contexts_same_on_U) apply (rule DAss_Const) apply (erule Siftdown_Invoke) apply simp+
(-invocation of make-)
apply (rule DA_MakeResultSome, fastsimp+)
done
*)

lemma ContextF4:
"GETr (restr (emptyfinmap(t1_\<mapsto>\<^sub>fTreeET 0)(t2_\<mapsto>\<^sub>fTreeET 0)(r8_\<mapsto>\<^sub>fTreeET 0)(r7_\<mapsto>\<^sub>fTreeET 0)(r5_\<mapsto>\<^sub>fTreeET 0)(r4_\<mapsto>\<^sub>fTreeET 0))
                                     (params ffourSiftdown)) x =
       GETr (emptyfinmap(r8_\<mapsto>\<^sub>fTreeET 0)(r7_\<mapsto>\<^sub>fTreeET 0)(r5_\<mapsto>\<^sub>fTreeET 0)(r4_\<mapsto>\<^sub>fTreeET 0)) x"
apply (simp add: params_def)
apply (case_tac "x=r8_", auto)
apply (case_tac "x=r7_", auto)
apply (case_tac "x=r5_", auto)
apply (case_tac "x=r4_", auto)
done

lemma ContextF11:
"GETr (restr (restr (emptyfinmap(t1_\<mapsto>\<^sub>fTreeET 0)(t2_\<mapsto>\<^sub>fTreeET 0)(r8_\<mapsto>\<^sub>fTreeET 0)(r7_\<mapsto>\<^sub>fTreeET 0)(r5_\<mapsto>\<^sub>f
                                                   TreeET 0)(r4_\<mapsto>\<^sub>fTreeET 0))
                                             (params ffourSiftdown))
                                      (params felevenSiftdown)) x =
  GETr (emptyfinmap(r8_\<mapsto>\<^sub>fTreeET 0)(r7_\<mapsto>\<^sub>fTreeET 0)(r5_\<mapsto>\<^sub>fTreeET 0)(r4_\<mapsto>\<^sub>fTreeET 0)) x"
apply (simp add: params_def)
apply (case_tac "x=r8_", auto)
apply (case_tac "x=r7_", auto)
apply (case_tac "x=r5_", auto)
apply (case_tac "x=r4_", auto)
done



text {*The applications of rule Cut2Call occur at the beginning 
       of the immediate dominator of the merge point:
       in f3 for f4, and in f10 for f11*}
lemma Siftdown_DAss:
"\<lbrakk>G = HeapSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable HS Siftdown) : SPEC Siftdown"
apply (simp add: Meth_Siftdown SPEC_def, clarsimp)
apply (rule DA_Weak)
apply (rule DA_Call2)
apply (simp add: Fun_fSiftdown)
apply (rule DA_Let_RPrim)
apply (rule DA_If)
apply (simp_all)
(*fzero*)
  apply (rule DA_Call2)
  apply (simp only: Fun_fzeroSiftdown)
  apply (rule DA_Letr, rule DA_Null) prefer 5 
  apply (rule DA_Letr, rule DA_Null) prefer 5
  (*invocation of make*)
  apply (rule DA_MakeTree, fastsimp+)
(*fone*)
  apply (rule DA_Call2)
  apply (simp only:  Fun_foneSiftdown)
  apply (rule DA_TreeMatchD, fastsimp+) 
  apply (rule DA_Let_RPrim) 
  apply (rule DA_If)
(*fwo*)
  apply (rule DA_Call2)
  apply (simp only: Fun_ftwoSiftdown)
  apply (rule DA_Let_Prim)
  apply (rule DA_If)
(*feighteen*)
  apply (rule DA_Call2)
  apply (simp only: Fun_feighteenSiftdown)
  apply (rule DA_Letr, rule DA_Null) prefer 5
  apply (rule DA_Letr, rule DA_Null) prefer 5
  apply (rule DA_Letr)
  (*invocation of make*)
  apply (rule DA_MakeTree, fastsimp+)
  apply (rule DA_Letr, rule DA_Null) prefer 5
  (*invocation of make*)
  apply (rule DA_MakeTree, fastsimp+)
(*fnineteen*)
  apply (rule DA_Call2)
  apply (simp only: Fun_fnineteenSiftdown)
  apply (rule DA_Letr, rule DA_Null) prefer 5
  apply (rule DA_Letr, rule DA_Null) prefer 5
  apply (rule DA_Letr)
  (*invocation of make*)
  apply (rule DA_MakeTree, fastsimp+)
  apply (rule DA_Letr, rule DA_Null) prefer 5
  (*invocation of make*)
  apply (rule DA_MakeTree, fastsimp+)
(*fthree*)
  apply (rule Cut2Call) 
  apply (rule DA_Call2)
  apply (simp only: Fun_fthreeSiftdown)
  apply (rule DA_TreeMatchD, fastsimp+) 
  apply (rule DA_Let_Prim)
  apply (rule DA_If)
(*ffive*)
  apply (rule DA_Call2)
  apply (simp only: Fun_ffiveSiftdown)
  apply (rule DA_Let_Prim)
  apply (rule DA_If)
(*fseven*)
  apply (rule DA_Call2)
  apply (simp only: Fun_fsevenSiftdown)
  apply (rule DA_Let_Int)
  apply (rule DA_CutCall1) defer 1 (*apply (simp add: ContextF4[simplified])*) apply (simp add: HeapSortContext_def) 
    apply (rule, simp, simp)? 
(*feight*)
  apply (rule DA_Call2)
  apply (simp only: Fun_feightSiftdown)
  apply (rule DA_Let_Int)
  apply (rule DA_CutCall1) defer 1 (*apply (simp add: ContextF4[simplified])*) apply (simp add: HeapSortContext_def) 
(*fsix*)
  apply (rule DA_Call2)
  apply (simp only: Fun_fsixSiftdown)
  apply (rule DA_Let_Int)
  apply (rule DA_CutCall1) defer 1 (*apply (simp add: ContextF4[simplified])*) apply (simp add: HeapSortContext_def) 
apply simp
defer 1 
apply (simp add: HeapSortContext_def)
(*Verification of f4*)
  apply (simp add: contextProvable_def, clarsimp)
  apply rule prefer 2 apply clarsimp apply (erule vdm_ax)
  (*ffour*)
    apply clarsimp
    apply (rule DA_Call2)
    apply (simp only: Fun_ffourSiftdown)
    apply (rule DA_Let_Prim)
    apply (rule DA_If)
  (*fnine*)
    apply (rule DA_Call2)
    apply (simp only: Fun_fnineSiftdown)
    apply (rule DA_Letr)
    (*invocation of make*) 
    apply (rule DA_MakeTree) apply (simp add: params_def)+ (*apply (simp add: ContextF4[simplified])+*)
    apply (rule DA_Letr)
    (*invocation of make*)
    apply (rule DA_MakeTree) apply (simp add: params_def)+ (*apply (simp add: ContextF4[simplified])+*)
    (*invocation of make*)
    apply (rule DA_MakeTree, simp+)
  (*ften*)
    apply (rule Cut2Call) 
    apply (rule DA_Call2)
    apply (simp only: Fun_ftenSiftdown)
    apply (rule DA_Let_Prim)
    apply (rule DA_If)
  (*twelve*)
    apply (rule DA_Call2)
    apply (simp only: Fun_ftwelveSiftdown)
    apply (rule DA_Let_Prim)
    apply (rule DA_If)
  (*ffourteen*)
    apply (rule DA_Call2)
    apply (simp only: Fun_ffourteenSiftdown)
    apply (rule DA_Let_Int)
    apply (rule DA_CutCall1) defer 1 apply (simp add: HeapSortContext_def) 
    apply (rule, simp, simp)? 
  (*ffifteen*)
    apply (rule DA_Call2)
    apply (simp only: Fun_ffifteenSiftdown)
    apply (rule DA_Let_Int)
    apply (rule DA_CutCall1) defer 1 apply (simp add: HeapSortContext_def) 
  (*fthirteen*)
    apply (rule DA_Call2)
    apply (simp only: Fun_fthirteenSiftdown)
    apply (rule DA_Let_Int)
    apply (rule DA_CutCall1) defer 1 apply (simp add: HeapSortContext_def) 
apply (simp add: HeapSortContext_def)
(*Verification of f11*)
  apply (simp add: contextProvable_def, clarsimp)
  apply rule apply clarsimp prefer 2 apply clarsimp apply (erule vdm_ax) 
  (*feleven*)
    apply (rule DA_Call2)
    apply (simp only: Fun_felevenSiftdown)
    apply (rule DA_Let_Prim)
    apply (rule DA_If)
    (*fsixteen*)
      apply (rule DA_Call2)
      apply (simp only: Fun_fsixteenSiftdown)
      apply (rule DA_Letr)
      (*invocation of make*)
        apply (rule DA_MakeTree) apply (simp add: params_def)+ (*apply (simp add: ContextF11[simplified])+ *)
      (*invocation of Siftdown*)
      apply (rule DA_Letr) apply (rule vdm_conseq, rule vdm_ax) apply (simp add: HeapSortContext_def)
          apply clarsimp apply (rule DAss_Contexts_same_on_U) apply (rule DAss_Const) apply (erule Siftdown_Invoke)
            apply (simp add: params_def)+ (*apply (simp add: ContextF11[simplified])+*)
      (*invocation of make*)
      apply (rule DA_MakeTree, simp+) 
    (*fseventeen*)
      apply (rule DA_Call2)
      apply (simp only: Fun_fseventeenSiftdown)
      (*invocation of Siftdown*)
        apply (rule DA_Letr) apply (rule vdm_conseq, rule vdm_ax) apply (simp add: HeapSortContext_def)
          apply clarsimp apply (rule DAss_Contexts_same_on_U) apply (rule DAss_Const) apply (erule Siftdown_Invoke) 
            apply (simp add: params_def)+ (*apply (simp add: ContextF11[simplified])+*)
      (*invocation of make*)
        apply (rule DA_Letr)
        apply (rule DA_MakeTree) apply (simp add: params_def)+ (*apply (simp add: ContextF11[simplified])+*)
      (*invocation of make*)
        apply (rule DA_MakeTree) apply (simp add: params_def)+
apply (simp_all add: params_def) apply fastsimp+ 
done

lemma Siftdown_DAss:
"\<lbrakk>G = HeapSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable HS Siftdown) : SPEC Siftdown"
apply (simp add: Meth_Siftdown SPEC_def, clarsimp)
apply (rule DA_Weak)
apply (rule DA_Call2)
apply (simp add: Fun_fSiftdown)
apply (rule DA_Let_RPrim)
apply (rule DA_If)
apply (simp_all)
(*fzero*)
  apply (rule DA_Call2)
  apply (simp only: Fun_fzeroSiftdown)
  apply (rule DA_Letr, rule DA_Null) prefer 5 
  apply (rule DA_Letr, rule DA_Null) prefer 5
  (*invocation of make*)
  apply (rule DA_MakeTree, fastsimp+)
(*fone*)
  apply (rule DA_Call2)
  apply (simp only:  Fun_foneSiftdown)
  apply (rule DA_TreeMatchD, fastsimp+) 
  apply (rule DA_Let_RPrim) 
  apply (rule DA_If)
(*fwo*)
  apply (rule DA_Call2)
  apply (simp only: Fun_ftwoSiftdown)
  apply (rule DA_Let_Prim)
  apply (rule DA_If)
(*feighteen*)
  apply (rule DA_Call2)
  apply (simp only: Fun_feighteenSiftdown)
  apply (rule DA_Letr, rule DA_Null) prefer 5
  apply (rule DA_Letr, rule DA_Null) prefer 5
  apply (rule DA_Letr)
  (*invocation of make*)
  apply (rule DA_MakeTree, fastsimp+)
  apply (rule DA_Letr, rule DA_Null) prefer 5
  (*invocation of make*)
  apply (rule DA_MakeTree, fastsimp+)
(*fnineteen*)
  apply (rule DA_Call2)
  apply (simp only: Fun_fnineteenSiftdown)
  apply (rule DA_Letr, rule DA_Null) prefer 5
  apply (rule DA_Letr, rule DA_Null) prefer 5
  apply (rule DA_Letr)
  (*invocation of make*)
  apply (rule DA_MakeTree, fastsimp+)
  apply (rule DA_Letr, rule DA_Null) prefer 5
  (*invocation of make*)
  apply (rule DA_MakeTree, fastsimp+)
(*fthree*)
  apply (rule Cut2Call) 
  apply (rule DA_Call2)
  apply (simp only: Fun_fthreeSiftdown)
  apply (rule DA_TreeMatchD, fastsimp+) 
  apply (rule DA_Let_Prim)
  apply (rule DA_If)
(*ffive*)
  apply (rule DA_Call2)
  apply (simp only: Fun_ffiveSiftdown)
  apply (rule DA_Let_Prim)
  apply (rule DA_If)
(*fseven*)
  apply (rule DA_Call2)
  apply (simp only: Fun_fsevenSiftdown)
  apply (rule DA_Let_Int)
  apply (rule DA_CutCall) apply (simp add: ContextF4[simplified]) apply (simp add: HeapSortContext_def) 
    apply (rule, simp, simp)? 
  defer 1 
(*feight*)
  apply (rule DA_Call2)
  apply (simp only: Fun_feightSiftdown)
  apply (rule DA_Let_Int)
  apply (rule DA_CutCall) apply (simp add: ContextF4[simplified]) apply (simp add: HeapSortContext_def) 
  defer 1 
(*fsix*)
  apply (rule DA_Call2)
  apply (simp only: Fun_fsixSiftdown)
  apply (rule DA_Let_Int)
  apply (rule DA_CutCall) apply (simp add: ContextF4[simplified]) apply (simp add: HeapSortContext_def) 
  defer 1
apply simp
defer 1 
apply (simp add: HeapSortContext_def)
(*Verification of f4*)
  apply (simp add: contextProvable_def, clarsimp)
  apply rule prefer 2 apply clarsimp apply (erule vdm_ax)
  (*ffour*)
    apply clarsimp
    apply (rule DA_Call2)
    apply (simp only: Fun_ffourSiftdown)
    apply (rule DA_Let_Prim)
    apply (rule DA_If)
  (*fnine*)
    apply (rule DA_Call2)
    apply (simp only: Fun_fnineSiftdown)
    apply (rule DA_Letr)
    (*invocation of make*) 
    apply (rule DA_MakeTree) apply (simp add: ContextF4[simplified])+
    apply (rule DA_Letr)
    (*invocation of make*)
    apply (rule DA_MakeTree) apply (simp add: ContextF4[simplified])+
    (*invocation of make*)
    apply (rule DA_MakeTree, simp+)
  (*ften*)
    apply (rule Cut2Call) 
    apply (rule DA_Call2)
    apply (simp only: Fun_ftenSiftdown)
    apply (rule DA_Let_Prim)
    apply (rule DA_If)
  (*twelve*)
    apply (rule DA_Call2)
    apply (simp only: Fun_ftwelveSiftdown)
    apply (rule DA_Let_Prim)
    apply (rule DA_If)
  (*ffourteen*)
    apply (rule DA_Call2)
    apply (simp only: Fun_ffourteenSiftdown)
    apply (rule DA_Let_Int)
    apply (rule DA_CutCall) apply (simp add: HeapSortContext_def) 
    apply (rule, simp, simp)? 
    defer 1  
  (*ffifteen*)
    apply (rule DA_Call2)
    apply (simp only: Fun_ffifteenSiftdown)
    apply (rule DA_Let_Int)
    apply (rule DA_CutCall) apply (simp add: HeapSortContext_def) 
    defer 1
  (*fthirteen*)
    apply (rule DA_Call2)
    apply (simp only: Fun_fthirteenSiftdown)
    apply (rule DA_Let_Int)
    apply (rule DA_CutCall) apply (simp add: HeapSortContext_def) 
    defer 1
apply (simp add: HeapSortContext_def)
(*Verification of f11*)
  apply (simp add: contextProvable_def, clarsimp)
  apply rule apply clarsimp prefer 2 apply clarsimp apply (erule vdm_ax) 
  (*feleven*)
    apply (rule DA_Call2)
    apply (simp only: Fun_felevenSiftdown)
    apply (rule DA_Let_Prim)
    apply (rule DA_If)
    (*fsixteen*)
      apply (rule DA_Call2)
      apply (simp only: Fun_fsixteenSiftdown)
      apply (rule DA_Letr)
      (*invocation of make*)
        apply (rule DA_MakeTree) apply (simp add: ContextF11[simplified])+ 
      (*invocation of Siftdown*)
      apply (rule DA_Letr) apply (rule vdm_conseq, rule vdm_ax) apply (simp add: HeapSortContext_def)
          apply clarsimp apply (rule DAss_Contexts_same_on_U) apply (rule DAss_Const) apply (erule Siftdown_Invoke) 
            apply (simp add: ContextF11[simplified])+
      (*invocation of make*)
      apply (rule DA_MakeTree, simp+) 
    (*fseventeen*)
      apply (rule DA_Call2)
      apply (simp only: Fun_fseventeenSiftdown)
      (*invocation of Siftdown*)
        apply (rule DA_Letr) apply (rule vdm_conseq, rule vdm_ax) apply (simp add: HeapSortContext_def)
          apply clarsimp apply (rule DAss_Contexts_same_on_U) apply (rule DAss_Const) apply (erule Siftdown_Invoke) 
          apply (simp add: ContextF11[simplified])+
      (*invocation of make*)
        apply (rule DA_Letr)
        apply (rule DA_MakeTree) apply (simp add: ContextF11[simplified])+
      (*invocation of make*)
        apply (rule DA_MakeTree) apply simp+
  apply fastsimp
  apply (simp add: ContextF4[simplified]) apply (rule, clarsimp)+
    apply (erule disjE, clarsimp+) 
  apply (simp add: ContextF4[simplified])+ apply (rule, clarsimp)+
    apply (erule disjE, clarsimp+) 
  apply (simp add: ContextF4[simplified])+ apply (rule, clarsimp)+
    apply (erule disjE, clarsimp+) 
  apply (simp add: ContextF4[simplified] ContextF11[simplified])+
done
