theory HPSortProg = DAss_ListrulesT2 + DAss_TreerulesT2 + DAss_ResultrulesT2:
subsection{*Heapsort for integers*}

text{*Camelot code in progs/Camelot/examples/HeapSort.cmlt*}
text {*Grail code in progs/Camelot/examples/HeapSort.gr*}

syntax HS    :: cname
       x_    :: iname
       b_    :: iname
       v4_   :: iname
       t_    :: rname
       r3_    :: rname

       fInsert :: funame
       fzeroInsert :: funame
       foneInsert :: funame
       ftwoInsert :: funame
       fthreeInsert :: funame
       Insert :: mname


translations
 "HS" == "(CN ''HeapSort'') "
 "x_" == "(In ''x'') "
 "b_" == "(In ''b'') "
 "v4_" == "(In ''v4'') "
 "t_" == "(RN ''t'') "
 "r3_" == "(RN ''r3'') "
 "fInsert" == "(FN ''fInsert'') "
 "fzeroInsert" == "(FN ''f_zeroInsert'')"
 "foneInsert" == "(FN ''f_oneInsert'')"
 "ftwoInsert" == "(FN ''f_twoInsert'')"
 "fthreeInsert" == "(FN ''f_threeInsert'')"
 "Insert" == "(MN ''Insert'')"

axioms Meth_Insert: 
"methtable HS Insert = ([INpar x_,RNpar t_], CALL fInsert)"
lemma "methtable HS Insert = ([INpar x_,RNpar t_], CALL fInsert)" by (simp add: Meth_Insert)

axioms Fun_fInsert:
"funtable fInsert = LET b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) t_ t_
                    IN IF b_ THEN CALL fzeroInsert ELSE CALL foneInsert END"
lemma "funtable fInsert = LET b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) t_ t_
                    IN IF b_ THEN CALL fzeroInsert ELSE CALL foneInsert END"
by (simp add: Fun_fInsert)
axioms Fun_fzeroInsert:
"funtable fzeroInsert = LET rf r2_ = Null;
                            rf t_ = Null 
                        IN DIAM\<bullet>Make_IIDD ([VALarg (IVal 3),INarg x_, RNarg r2_, RNarg t_]) END"
lemma  "funtable fzeroInsert = LET rf r2_ = Null;
                            rf t_ = Null 
                        IN DIAM\<bullet>Make_IIDD ([VALarg (IVal 3),INarg x_, RNarg r2_, RNarg t_]) END"
by (simp add: Fun_fzeroInsert)

axioms Fun_foneInsert:
"funtable foneInsert =
       LET v4_ = GetFi t_ V0;
        rf r3_ = GetFr t_ R1;
        rf r2_ = GetFr t_ R2;
             _ = DIAM\<bullet>Free ([RNarg t_]);
            b_ = Primop (\<lambda> x y . if x < y then 1 else 0) x_ v4_
       IN IF b_ THEN CALL ftwoInsert ELSE CALL fthreeInsert END"
lemma "funtable foneInsert =
       LET v4_ = GetFi t_ V0;
        rf r3_ = GetFr t_ R1;
        rf r2_ = GetFr t_ R2;
             _ = DIAM\<bullet>Free ([RNarg t_]);
            b_ = Primop (\<lambda> x y . if x < y then 1 else 0) x_ v4_
       IN IF b_ THEN CALL ftwoInsert ELSE CALL fthreeInsert END"
by (simp add: Fun_foneInsert)     

axioms Fun_ftwoInsert:
"funtable ftwoInsert =
       LET rf t_ = HS\<bullet>Insert ([INarg v4_, RNarg r2_])
       IN DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg x_, RNarg t_, RNarg r3_]) END"
lemma "funtable ftwoInsert =
       LET rf t_ = HS\<bullet>Insert ([INarg v4_, RNarg r2_])
       IN DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg x_, RNarg t_, RNarg r3_]) END"
by (simp add: Fun_ftwoInsert)

axioms Fun_fthreeInsert:
"funtable fthreeInsert =
       LET rf t_ = HS\<bullet>Insert ([INarg x_, RNarg r2_])
       IN DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg v4_, RNarg t_, RNarg r3_]) END"

lemma "funtable fthreeInsert =
       LET rf t_ = HS\<bullet>Insert ([INarg x_, RNarg r2_])
       IN DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg v4_, RNarg t_, RNarg r3_]) END"
by (simp add: Fun_fthreeInsert)

syntax
       w_     :: iname
       v3_    :: iname
       v6_    :: iname
       v9_     :: iname
       r4_    :: rname
       r5_    :: rname
       r7_    :: rname
       r8_    :: rname
       t1_    :: rname
       t2_    :: rname
       fSiftdown :: funame
       fzeroSiftdown :: funame
       foneSiftdown :: funame
       ftwoSiftdown :: funame
       fthreeSiftdown :: funame
       ffourSiftdown :: funame
       ffiveSiftdown :: funame
       fsixSiftdown :: funame
       fsevenSiftdown :: funame
       feightSiftdown :: funame
       fnineSiftdown :: funame
       ftenSiftdown :: funame
       felevenSiftdown :: funame
       ftwelveSiftdown :: funame
       fthirteenSiftdown :: funame
       ffourteenSiftdown :: funame
       ffifteenSiftdown :: funame
       fsixteenSiftdown :: funame
       fseventeenSiftdown :: funame
       feighteenSiftdown :: funame
       fnineteenSiftdown :: funame
       Siftdown :: mname

translations
 "w_" == "(In ''w'') "
 "v3_" == "(In ''v3'') "
 "v6_" == "(In ''v6'') "
 "v9_" == "(In ''v9'') "
 "r4_" == "(RN ''r4'') "
 "r5_" == "(RN ''r5'') "
 "r7_" == "(RN ''r7'') "
 "r8_" == "(RN ''r8'') "
 "t1_" == "(RN ''t1'') "
 "t2_" == "(RN ''t2'') "
 "fSiftdown" == "(FN ''f_Siftdown'') "
 "fzeroSiftdown" == "(FN ''f0_Siftdown'')"
 "foneSiftdown" == "(FN ''f1_Siftdown'')"
 "ftwoSiftdown" == "(FN ''f2_Siftdown'')"
 "fthreeSiftdown" == "(FN ''f3_Siftdown'')"
 "ffourSiftdown" == "(FN ''f4_Siftdown'')"
 "ffiveSiftdown" == "(FN ''f5_Siftdown'')"
 "fsixSiftdown" == "(FN ''f6_Siftdown'')"
 "fsevenSiftdown" == "(FN ''f7_Siftdown'')"
 "feightSiftdown" == "(FN ''f8_Siftdown'')"
 "fnineSiftdown" == "(FN ''f9_Siftdown'')"
 "ftenSiftdown" == "(FN ''f10_Siftdown'')"
 "felevenSiftdown" == "(FN ''f11_Siftdown'')"
 "ftwelveSiftdown" == "(FN ''f12_Siftdown'')"
 "fthirteenSiftdown" == "(FN ''f13_Siftdown'')"
 "ffourteenSiftdown" == "(FN ''f14_Siftdown'')"
 "ffifteenSiftdown" == "(FN ''f15_Siftdown'')"
 "fsixteenSiftdown" == "(FN ''f16_Siftdown'')"
 "fseventeenSiftdown" == "(FN ''f17_Siftdown'')"
 "feighteenSiftdown" == "(FN ''f18_Siftdown'')"
 "fnineteenSiftdown" == "(FN ''f19_Siftdown'')"
 "Siftdown" == "(MN ''Siftdown'')"

axioms Meth_Siftdown: 
"methtable HS Siftdown = ([INpar w_, RNpar t1_, RNpar t2_], CALL fSiftdown)"
lemma "methtable HS Siftdown = ([INpar w_, RNpar t1_, RNpar t2_], CALL fSiftdown)" by (simp add: Meth_Siftdown)

axioms Fun_fSiftdown:
"funtable fSiftdown = LET b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) t1_ t1_
                      IN IF b_ THEN CALL fzeroSiftdown ELSE CALL foneSiftdown END"
lemma "funtable fSiftdown = LET b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) t1_ t1_
                    IN IF b_ THEN CALL fzeroSiftdown ELSE CALL foneSiftdown END"
by (simp add: Fun_fSiftdown)

axioms Fun_fzeroSiftdown:
"funtable fzeroSiftdown = LET rf t2_ = Null;
                              rf t1_ = Null 
                          IN DIAM\<bullet>Make_IIDD ([VALarg (IVal 3),INarg w_, RNarg t2_, RNarg t1_]) END"
lemma  "funtable fzeroSiftdown = 
                          LET rf t2_ = Null;
                              rf t1_ = Null 
                          IN DIAM\<bullet>Make_IIDD ([VALarg (IVal 3),INarg w_, RNarg t2_, RNarg t1_]) END"
by (simp add: Fun_fzeroSiftdown)

axioms Fun_foneSiftdown:
"funtable foneSiftdown = LET v9_ = GetFi t1_ V0;
                          rf r8_ = GetFr t1_ R1;
                          rf r7_ = GetFr t1_ R2;
                               _ = DIAM\<bullet>Free ([RNarg t1_]);
                              b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) t2_ t2_
                         IN IF b_ THEN CALL ftwoSiftdown ELSE CALL fthreeSiftdown END"
lemma  "funtable foneSiftdown = 
                         LET v9_ = GetFi t1_ V0;
                          rf r8_ = GetFr t1_ R1;
                          rf r7_ = GetFr t1_ R2;
                               _ = DIAM\<bullet>Free ([RNarg t1_]);
                              b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) t2_ t2_
                         IN IF b_ THEN CALL ftwoSiftdown ELSE CALL fthreeSiftdown END"
by (simp add: Fun_foneSiftdown)

axioms Fun_ftwoSiftdown:
"funtable ftwoSiftdown = LET b_ = Primop (\<lambda> z y. if z < y then 1 else 0) w_ v9_
                         IN IF b_ THEN CALL feighteenSiftdown ELSE CALL fnineteenSiftdown END"
lemma  "funtable ftwoSiftdown = LET b_ = Primop (\<lambda> z y. if z < y then 1 else 0) w_ v9_
                         IN IF b_ THEN CALL feighteenSiftdown ELSE CALL fnineteenSiftdown END"
by (simp add: Fun_ftwoSiftdown)

axioms Fun_fthreeSiftdown:
"funtable fthreeSiftdown = LET v6_ = GetFi t2_ V0;
                            rf r5_ = GetFr t2_ R1;
                            rf r4_ = GetFr t2_ R2;
                                 _ = DIAM\<bullet>Free ([RNarg t2_]);
                                b_ = Primop (\<lambda> z y. if z < y then 1 else 0) w_ v6_
                          IN IF b_ THEN CALL ffiveSiftdown ELSE CALL fsixSiftdown END"
lemma  "funtable fthreeSiftdown = LET v6_ = GetFi t2_ V0;
                                   rf r5_ = GetFr t2_ R1;
                                   rf r4_ = GetFr t2_ R2;
                                        _ = DIAM\<bullet>Free ([RNarg t2_]);
                                       b_ = Primop (\<lambda> z y. if z < y then 1 else 0) w_ v6_
                                  IN IF b_ THEN CALL ffiveSiftdown ELSE CALL fsixSiftdown END"
by (simp add: Fun_fthreeSiftdown)

axioms Fun_ffourSiftdown:
"funtable ffourSiftdown = LET b_ = Primop (\<lambda> z y. if z = 1 then 1 else 0) v3_ v3_
                          IN IF b_ THEN CALL fnineSiftdown ELSE CALL ftenSiftdown END"
lemma  "funtable ffourSiftdown = LET b_ = Primop (\<lambda> z y. if z = 1 then 1 else 0) v3_ v3_
                                 IN IF b_ THEN CALL fnineSiftdown ELSE CALL ftenSiftdown END"
by (simp add: Fun_ffourSiftdown)

axioms Fun_ffiveSiftdown:
"funtable ffiveSiftdown = LET b_ = Primop (\<lambda> z y. if z < y then 1 else 0) w_ v9_
                          IN IF b_ THEN CALL fsevenSiftdown ELSE CALL feightSiftdown END"
lemma  "funtable ffiveSiftdown = LET b_ = Primop (\<lambda> z y. if z < y then 1 else 0) w_ v9_
                                 IN IF b_ THEN CALL fsevenSiftdown ELSE CALL feightSiftdown END"
by (simp add: Fun_ffiveSiftdown)

axioms Fun_fsixSiftdown:
"funtable fsixSiftdown = LET v3_ = expr.Int 0 IN CALL ffourSiftdown END"
lemma  "funtable fsixSiftdown = LET v3_ = expr.Int 0 IN CALL ffourSiftdown END"
by (simp add: Fun_fsixSiftdown)

axioms Fun_fsevenSiftdown:
"funtable fsevenSiftdown = LET v3_ = expr.Int 1 IN CALL ffourSiftdown END"
lemma  "funtable fsevenSiftdown = LET v3_ = expr.Int 1 IN CALL ffourSiftdown END"
by (simp add: Fun_fsevenSiftdown)

axioms Fun_feightSiftdown:
"funtable feightSiftdown = LET v3_ = expr.Int 0 IN CALL ffourSiftdown END"
lemma  "funtable feightSiftdown = LET v3_ = expr.Int 0 IN CALL ffourSiftdown END"
by (simp add: Fun_feightSiftdown)

axioms Fun_fnineSiftdown:
"funtable fnineSiftdown = LET rf t2_ = DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg v9_, RNarg r8_, RNarg r7_]);
                              rf t1_ = DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg v6_, RNarg r5_, RNarg r4_])
                          IN DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg w_, RNarg t2_, RNarg t1_]) END"
lemma  "funtable fnineSiftdown = 
                          LET rf t2_ = DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg v9_, RNarg r8_, RNarg r7_]);
                              rf t1_ = DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg v6_, RNarg r5_, RNarg r4_])
                          IN DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg w_, RNarg t2_, RNarg t1_]) END"
by (simp add: Fun_fnineSiftdown)

axioms Fun_ftenSiftdown:
"funtable ftenSiftdown = LET b_ = Primop (\<lambda> z y. if z < y then 1 else 0) v6_ w_
                         IN IF b_ THEN CALL ftwelveSiftdown ELSE CALL fthirteenSiftdown END"
lemma  "funtable ftenSiftdown = LET b_ = Primop (\<lambda> z y. if z < y then 1 else 0) v6_ w_
                                IN IF b_ THEN CALL ftwelveSiftdown ELSE CALL fthirteenSiftdown END"
by (simp add: Fun_ftenSiftdown)

axioms Fun_felevenSiftdown:
"funtable felevenSiftdown = LET b_ = Primop (\<lambda> z y. if z = 1 then 1 else 0) v3_ v3_
                          IN IF b_ THEN CALL fsixteenSiftdown ELSE CALL fseventeenSiftdown END"
lemma  "funtable felevenSiftdown = LET b_ = Primop (\<lambda> z y. if z = 1 then 1 else 0) v3_ v3_
                                 IN IF b_ THEN CALL fsixteenSiftdown ELSE CALL fseventeenSiftdown END"
by (simp add: Fun_felevenSiftdown)

axioms Fun_ftwelveSiftdown:
"funtable ftwelveSiftdown = LET b_ = Primop (\<lambda> z y. if z < y then 1 else 0) v6_ v9_
                         IN IF b_ THEN CALL ffourteenSiftdown ELSE CALL ffifteenSiftdown END"
lemma  "funtable ftwelveSiftdown = LET b_ = Primop (\<lambda> z y. if z < y then 1 else 0) v6_ v9_
                                IN IF b_ THEN CALL ffourteenSiftdown ELSE CALL ffifteenSiftdown END"
by (simp add: Fun_ftwelveSiftdown)

axioms Fun_fthirteenSiftdown:
"funtable fthirteenSiftdown = LET v3_ = expr.Int 0 IN CALL felevenSiftdown END"
lemma  "funtable fthirteenSiftdown = LET v3_ = expr.Int 0 IN CALL felevenSiftdown END"
by (simp add: Fun_fthirteenSiftdown)

axioms Fun_ffourteenSiftdown:
"funtable ffourteenSiftdown = LET v3_ = expr.Int 1 IN CALL felevenSiftdown END"
lemma  "funtable ffourteenSiftdown = LET v3_ = expr.Int 1 IN CALL felevenSiftdown END"
by (simp add: Fun_ffourteenSiftdown)

axioms Fun_ffifteenSiftdown:
"funtable ffifteenSiftdown = LET v3_ = expr.Int 0 IN CALL felevenSiftdown END"
lemma  "funtable ffifteenSiftdown = LET v3_ = expr.Int 0 IN CALL felevenSiftdown END"
by (simp add: Fun_ffifteenSiftdown)

axioms Fun_fsixteenSiftdown:
"funtable fsixteenSiftdown = LET rf t2_ = DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg v9_, RNarg r8_, RNarg r7_]);
                                 rf t1_ = HS\<bullet>Siftdown([INarg w_, RNarg r5_, RNarg r4_])
                             IN DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg v6_, RNarg t2_, RNarg t1_]) END"
lemma  "funtable fsixteenSiftdown = LET rf t2_ = DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg v9_, RNarg r8_, RNarg r7_]);
                                        rf t1_ = HS\<bullet>Siftdown([INarg w_, RNarg r5_, RNarg r4_])
                                    IN DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg v6_, RNarg t2_, RNarg t1_]) END"
by (simp add: Fun_fsixteenSiftdown)

axioms Fun_fseventeenSiftdown:
"funtable fseventeenSiftdown = LET rf t2_ = HS\<bullet>Siftdown([INarg w_, RNarg r8_, RNarg r7_]);
                                   rf t1_ = DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg v6_, RNarg r5_, RNarg r4_])
                               IN DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg v9_, RNarg t2_, RNarg t1_]) END"
lemma  "funtable fseventeenSiftdown = LET rf t2_ = HS\<bullet>Siftdown([INarg w_, RNarg r8_, RNarg r7_]);
                                   rf t1_ = DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg v6_, RNarg r5_, RNarg r4_])
                               IN DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg v9_, RNarg t2_, RNarg t1_]) END"
by (simp add: Fun_fseventeenSiftdown)

axioms Fun_feighteenSiftdown:
"funtable feighteenSiftdown = LET rf r4_ = Null;
                                   rf t1_ = Null;
                                   rf t2_ = DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg v9_, RNarg r4_, RNarg t1_]);
                                   rf t1_ = Null
                               IN DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg w_, RNarg t2_, RNarg t1_]) END"
lemma  "funtable feighteenSiftdown = LET rf r4_ = Null;
                                          rf t1_ = Null;
                                          rf t2_ = DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg v9_, RNarg r4_, RNarg t1_]);
                                          rf t1_ = Null
                                      IN DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg w_, RNarg t2_, RNarg t1_]) END"
by (simp add: Fun_feighteenSiftdown)
axioms Fun_fnineteenSiftdown:
"funtable fnineteenSiftdown = LET rf r4_ = Null;
                                  rf t1_ = Null;
                                  rf t2_ = DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg w_, RNarg r4_, RNarg t1_]);
                                  rf t1_ = Null
                              IN DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg v9_, RNarg t2_, RNarg t1_]) END"
lemma  "funtable fnineteenSiftdown = LET rf r4_ = Null;
                                         rf t1_ = Null;
                                         rf t2_ = DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg w_, RNarg r4_, RNarg t1_]);
                                         rf t1_ = Null
                                     IN DIAM\<bullet>Make_IIDD([VALarg (IVal 3), INarg v9_, RNarg t2_, RNarg t1_]) END"
by (simp add: Fun_fnineteenSiftdown)

syntax 
       v2_    :: iname
       fRemovesome :: funame
       fzeroRemovesome :: funame
       foneRemovesome :: funame
       ftwoRemovesome :: funame
       fthreeRemovesome :: funame
       Removesome :: cname

translations
 "v2_" == "(In ''v2'') "
 "fRemovesome" == "(FN ''fRemovesome'') "
 "fzeroRemovesome" == "(FN ''f_zeroRemovesome'')"
 "foneRemovesome" == "(FN ''f_oneRemovesome'')"
 "ftwoRemovesome" == "(FN ''f_twoRemovesome'')"
 "fthreeRemovesome" == "(FN ''f_threeRemovesome'')"
 "Removesome" == "(MN ''Removesome'')"

axioms Meth_Removesome: 
"methtable HS Removesome = ([RNpar t_], CALL fRemovesome)"
lemma "methtable HS Removesome = ([RNpar t_], CALL fRemovesome)" by (simp add: Meth_Removesome)

axioms Fun_fRemovesome:
"funtable fRemovesome = LET b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) t_ t_
                    IN IF b_ THEN CALL fzeroRemovesome ELSE CALL foneRemovesome END"
lemma "funtable fRemovesome = LET b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) t_ t_
                    IN IF b_ THEN CALL fzeroRemovesome ELSE CALL foneRemovesome END"
by (simp add: Fun_fRemovesome)

axioms Fun_fzeroRemovesome: "funtable fzeroRemovesome = Null"
lemma  "funtable fzeroRemovesome = Null" by (simp add: Fun_fzeroRemovesome)

axioms Fun_foneRemovesome:
"funtable foneRemovesome =
       LET v4_ = GetFi t_ V0;
        rf r1_ = GetFr t_ R1;
        rf r3_ = GetFr t_ R2;
             _ = DIAM\<bullet>Free ([RNarg t_]);
         rf t_ = HS\<bullet>Removesome ([RNarg r1_]);
            b_ = RPrimop (\<lambda> z y . if z = Nullref then 1 else 0) t_ t_
       IN IF b_ THEN CALL ftwoRemovesome ELSE CALL fthreeRemovesome END"
lemma "funtable foneRemovesome =
       LET v4_ = GetFi t_ V0;
        rf r1_ = GetFr t_ R1;
        rf r3_ = GetFr t_ R2;
             _ = DIAM\<bullet>Free ([RNarg t_]);
         rf t_ = HS\<bullet>Removesome ([RNarg r1_]);
            b_ = RPrimop (\<lambda> z y . if z = Nullref then 1 else 0) t_ t_
       IN IF b_ THEN CALL ftwoRemovesome ELSE CALL fthreeRemovesome END"
by (simp add: Fun_foneRemovesome)     

axioms Fun_ftwoRemovesome:
"funtable ftwoRemovesome = DIAM\<bullet>Make_IID ([VALarg (IVal 1), INarg v4_, RNarg r3_])"
lemma "funtable ftwoRemovesome = DIAM\<bullet>Make_IID ([VALarg (IVal 1), INarg v4_, RNarg r3_])"
by (simp add: Fun_ftwoRemovesome)

axioms Fun_fthreeRemovesome:
"funtable fthreeRemovesome =
       LET v2_ = GetFi t_ V0;
        rf r1_ = GetFr t_ R1;
             _ = DIAM\<bullet>Free ([RNarg t_]);
         rf t_ = DIAM\<bullet>Make_IIDD ([VALarg (IVal 3), INarg v4_, RNarg r3_, RNarg r1_])
       IN DIAM\<bullet>Make_IID ([VALarg (IVal 1), INarg v2_, RNarg t_]) END"
lemma "funtable fthreeRemovesome =
       LET v2_ = GetFi t_ V0;
        rf r1_ = GetFr t_ R1;
             _ = DIAM\<bullet>Free ([RNarg t_]);
         rf t_ = DIAM\<bullet>Make_IIDD ([VALarg (IVal 3), INarg v4_, RNarg r3_, RNarg r1_])
       IN DIAM\<bullet>Make_IID ([VALarg (IVal 1), INarg v2_, RNarg t_]) END"
by (simp add: Fun_fthreeRemovesome)


syntax 
       fRemovetop :: funame
       fzeroRemovetop :: funame
       foneRemovetop :: funame
       ftwoRemovetop :: funame
       fthreeRemovetop :: funame
       Removetop :: cname

translations
 "fRemovetop" == "(FN ''fRemovetop'') "
 "fzeroRemovetop" == "(FN ''f_zeroRemovetop'')"
 "foneRemovetop" == "(FN ''f_oneRemovetop'')"
 "ftwoRemovetop" == "(FN ''f_twoRemovetop'')"
 "fthreeRemovetop" == "(FN ''f_threeRemovetop'')"
 "Removetop" == "(MN ''Removetop'')"

axioms Meth_Removetop: 
"methtable HS Removetop = ([RNpar t_], CALL fRemovetop)"
lemma "methtable HS Removetop = ([RNpar t_], CALL fRemovetop)" by (simp add: Meth_Removetop)

axioms Fun_fRemovetop:
"funtable fRemovetop = LET b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) t_ t_
                    IN IF b_ THEN CALL fzeroRemovetop ELSE CALL foneRemovetop END"
lemma "funtable fRemovetop = LET b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) t_ t_
                    IN IF b_ THEN CALL fzeroRemovetop ELSE CALL foneRemovetop END"
by (simp add: Fun_fRemovetop)

axioms Fun_fzeroRemovetop: "funtable fzeroRemovetop = Null"
lemma  "funtable fzeroRemovetop = Null" by (simp add: Fun_fzeroRemovetop)

axioms Fun_foneRemovetop:
"funtable foneRemovetop =
       LET v4_ = GetFi t_ V0;
        rf r1_ = GetFr t_ R1;
        rf r3_ = GetFr t_ R2;
             _ = DIAM\<bullet>Free ([RNarg t_]);
         rf t_ = HS\<bullet>Removesome ([RNarg r1_]);
            b_ = RPrimop (\<lambda> z y . if z = Nullref then 1 else 0) t_ t_
       IN IF b_ THEN CALL ftwoRemovetop ELSE CALL fthreeRemovetop END"
lemma "funtable foneRemovetop =
       LET v4_ = GetFi t_ V0;
        rf r1_ = GetFr t_ R1;
        rf r3_ = GetFr t_ R2;
             _ = DIAM\<bullet>Free ([RNarg t_]);
         rf t_ = HS\<bullet>Removesome ([RNarg r1_]);
            b_ = RPrimop (\<lambda> z y . if z = Nullref then 1 else 0) t_ t_
       IN IF b_ THEN CALL ftwoRemovetop ELSE CALL fthreeRemovetop END"
by (simp add: Fun_foneRemovetop)     

axioms Fun_ftwoRemovetop:
"funtable ftwoRemovetop = DIAM\<bullet>Make_IID ([VALarg (IVal 1), INarg v4_, RNarg r3_])"
lemma "funtable ftwoRemovetop = DIAM\<bullet>Make_IID ([VALarg (IVal 1), INarg v4_, RNarg r3_])"
by (simp add: Fun_ftwoRemovetop)

axioms Fun_fthreeRemovetop:
"funtable fthreeRemovetop =
       LET v2_ = GetFi t_ V0;
        rf r1_ = GetFr t_ R1;
             _ = DIAM\<bullet>Free ([RNarg t_]);
         rf t_ = HS\<bullet>Siftdown ([INarg v2_, RNarg r3_, RNarg r1_])
       IN DIAM\<bullet>Make_IID ([VALarg (IVal 1), INarg v4_, RNarg t_]) END"
lemma "funtable fthreeRemovetop =
       LET v2_ = GetFi t_ V0;
        rf r1_ = GetFr t_ R1;
             _ = DIAM\<bullet>Free ([RNarg t_]);
         rf t_ = HS\<bullet>Siftdown ([INarg v2_, RNarg r3_, RNarg r1_])
       IN DIAM\<bullet>Make_IID ([VALarg (IVal 1), INarg v4_, RNarg t_]) END"
by (simp add: Fun_fthreeRemovetop)

syntax l_ :: rname
       fMake_heap :: funame
       fzeroMake_heap :: funame
       foneMake_heap :: funame
       Make_heap :: cname

translations
 "l_" == "(RN ''l'')"
 "fMake_heap" == "(FN ''fMake_heap'') "
 "fzeroMake_heap" == "(FN ''f_zeroMake_heap'')"
 "foneMake_heap" == "(FN ''f_oneMake_heap'')"
 "Make_heap" == "(MN ''Make_heap'')"

axioms Meth_Make_heap: 
"methtable HS Make_heap = ([RNpar l_], CALL fMake_heap)"
lemma "methtable HS Make_heap = ([RNpar l_], CALL fMake_heap)" by (simp add: Meth_Make_heap)

axioms Fun_fMake_heap:
"funtable fMake_heap = LET b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) l_ l_
                       IN IF b_ THEN CALL fzeroMake_heap ELSE CALL foneMake_heap END"
lemma "funtable fMake_heap = LET b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) l_ l_
                    IN IF b_ THEN CALL fzeroMake_heap ELSE CALL foneMake_heap END"
by (simp add: Fun_fMake_heap)

axioms Fun_fzeroMake_heap: "funtable fzeroMake_heap = Null"
lemma  "funtable fzeroMake_heap = Null" by (simp add: Fun_fzeroMake_heap)

axioms Fun_foneMake_heap:
"funtable foneMake_heap =
       LET v2_ = GetFi l_ V0;
        rf r1_ = GetFr l_ R1;
             _ = DIAM\<bullet>Free ([RNarg l_]);
         rf l_ = HS\<bullet>Make_heap ([RNarg r1_])
       IN HS\<bullet>Insert([INarg v2_, RNarg l_]) END"
lemma "funtable foneMake_heap =
       LET v2_ = GetFi l_ V0;
        rf r1_ = GetFr l_ R1;
             _ = DIAM\<bullet>Free ([RNarg l_]);
         rf l_ = HS\<bullet>Make_heap ([RNarg r1_])
       IN HS\<bullet>Insert([INarg v2_, RNarg l_]) END"
by (simp add: Fun_foneMake_heap)     

syntax h_ :: rname
       fExtract :: funame
       fzeroExtract :: funame
       foneExtract :: funame
       Extract :: cname

translations
 "h_" == "(RN ''h'')"
 "fExtract" == "(FN ''fExtract'') "
 "fzeroExtract" == "(FN ''f_zeroExtract'')"
 "foneExtract" == "(FN ''f_oneExtract'')"
 "Extract" == "(MN ''Extract'')"

axioms Meth_Extract: 
"methtable HS Extract = ([RNpar h_], CALL fExtract)"
lemma "methtable HS Extract = ([RNpar h_], CALL fExtract)" by (simp add: Meth_Extract)

axioms Fun_fExtract:
"funtable fExtract = LET rf r3_ = HS\<bullet>Removetop ([RNarg h_]);
                             b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) r3_ r3_
                     IN IF b_ THEN CALL fzeroExtract ELSE CALL foneExtract END"
lemma "funtable fExtract = LET rf r3_ = HS\<bullet>Removetop ([RNarg h_]);
                             b_ = RPrimop (\<lambda> z y. if z = Nullref then 1 else 0) r3_ r3_
                           IN IF b_ THEN CALL fzeroExtract ELSE CALL foneExtract END"
by (simp add: Fun_fExtract)

axioms Fun_fzeroExtract: "funtable fzeroExtract = Null"
lemma  "funtable fzeroExtract = Null" by (simp add: Fun_fzeroExtract)

axioms Fun_foneExtract:
"funtable foneExtract =
       LET v2_ = GetFi r3_ V0;
        rf r1_ = GetFr r3_ R1;
             _ = DIAM\<bullet>Free ([RNarg r3_]);
         rf h_ = HS\<bullet>Extract ([RNarg r1_])
       IN DIAM\<bullet>Make_IID([VALarg (IVal 5), INarg v2_, RNarg h_]) END"
lemma "funtable foneExtract =
       LET v2_ = GetFi r3_ V0;
        rf r1_ = GetFr r3_ R1;
             _ = DIAM\<bullet>Free ([RNarg r3_]);
         rf h_ = HS\<bullet>Extract ([RNarg r1_])
       IN DIAM\<bullet>Make_IID([VALarg (IVal 5), INarg v2_, RNarg h_]) END"
by (simp add: Fun_foneExtract)     

syntax fSort :: funame
       Sort :: cname

translations
 "fSort" == "(FN ''fSort'') "
 "Sort" == "(MN ''Sort'')"

axioms Meth_Sort: 
"methtable HS Sort = ([RNpar l_], CALL fSort)"
lemma "methtable HS Sort = ([RNpar l_], CALL fSort)" by (simp add: Meth_Sort)

axioms Fun_fSort:
"funtable fSort = LET rf r1_ = HS\<bullet>Make_heap ([RNarg l_])
                  IN HS\<bullet>Extract ([RNarg r1_]) END"
lemma "funtable fSort =  LET rf r1_ = HS\<bullet>Make_heap ([RNarg l_])
                         IN HS\<bullet>Extract ([RNarg r1_]) END"
by (simp add: Fun_fSort)

text {*Here is what Steffen's analysis claims, using -olhs 4:
 \begin{verbatim}
  insert     : 1, int -> iTree[0|int,#,#,0] -> iTree[0|int,#,#,0], 0;
  siftdown   : 1, int -> iTree[0|int,#,#,0] -> iTree[0|int,#,#,0] -> iTree[0|int,#,#,0], 0;
  removesome : 0, iTree[0|int,#,#,0] -> iresult[0|int,iTree[0|int,#,#,0],0], 0;
  removetop  : 0, iTree[0|int,#,#,0] -> iresult[0|int,iTree[0|int,#,#,0],0], 0;
  make_heap  : 0, iList[0|int,#,0] -> iTree[0|int,#,#,0], 0;
  extract    : 0, iTree[0|int,#,#,0] -> iList[0|int,#,0], 0;
  sort       : 0, iList[0|int,#,0] -> iList[0|int,#,0], 0;
\end<verbatim} *}

text {*The outcome -olhs 3 is   
  removesome : 1, iTree[0|int,#,#,0] -> iresult[1|int,iTree[0|int,#,#,0],1], 0;
    This spec cannot be verified!*}

end
