(*<*)
theory DAss_rulesU2 = DAssU2:
(*>*)

subsection {*Rules*}

subsubsection {* Logical rules*}
lemma DAss_monotone_in_U:
"\<lbrakk>DAss U n C T m E h hh v p; U \<subseteq> UU\<rbrakk> \<Longrightarrow> DAss UU n C T m E h hh v p"
(*<*)
apply (simp add: DAss_def,clarsimp)
apply (subgoal_tac "(\<exists> n1 n2 . (E, h, U, C, n1) \<in> ContextSize \<and> (E, h, UU-U, C, n2) \<in> ContextSize \<and> n1 + n2 = CS)",clarsimp)
prefer 2 apply (erule ContextSize_SPLIT,fast,fast) 
apply (erule_tac x=q in allE, erule_tac x=n1 in allE, erule_tac x=F in allE)
apply (erule impE, safe)
apply (rule_tac x=N in exI,simp)
apply (rule, erule regionsExist_antimonotone, assumption)
apply (rule, erule regionsDistinct_antimonotone, assumption)
apply (erule distinctFrom_antimonotone, assumption)
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (erule modified_monotone,assumption) 
apply (erule Bounded_monotone, simp, simp,simp)
apply (erule Bounded_monotone, simp, simp,simp)
done
(*>*)

lemma DAss_Contexts_same_on_U:
"\<lbrakk>G \<rhd> e: DAss U n C T m; \<forall> x. x:U \<longrightarrow> GETr D x = GETr C x\<rbrakk> \<Longrightarrow> G \<rhd> e: DAss U n D T m"
(*<*)
apply (erule vdm_conseq, clarsimp)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=CS in allE, erule_tac x=F in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (erule regionsExist2, assumption)
apply (erule regionsDistinct2, assumption)
apply (erule distinctFrom2, assumption)
apply (erule ContextSize2,fast)
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (erule modified2, assumption)
apply (erule Bounded2, fastsimp)+
done
(*>*)

lemma DA_Weak: "\<lbrakk>G \<rhd> e : \<lbrace> U , n , C \<ggreater> T , m\<rbrace>; U \<subseteq> UU\<rbrakk> \<Longrightarrow> G \<rhd> e : DAss UU n C T m"
(*<*)
by (erule vdm_conseq, clarsimp, erule DAss_monotone_in_U,fast) 
(*>*)

lemma DAss_Generalise:
 "\<lbrakk>DAss U n C T m E h hh v p;  n \<le> nn; mm \<le> m; U \<subseteq> UU\<rbrakk>  \<Longrightarrow> DAss UU nn C T mm E h hh v p"
(*<*)
apply (simp add: DAss_def, clarsimp)
apply (subgoal_tac "(\<exists> n1 n2 . (E, h, U, C, n1) \<in> ContextSize \<and> (E, h, UU-U, C, n2) \<in> ContextSize \<and> n1 + n2 = CS)",clarsimp)
prefer 2 apply (erule ContextSize_SPLIT,fast,fast) 
apply (erule_tac x=q in allE, erule_tac x=n1 in allE, erule_tac x=F in allE)
apply (erule impE, safe)
apply (rule_tac x=N in exI,simp)
apply (rule, erule regionsExist_antimonotone, assumption)
apply (rule, erule regionsDistinct_antimonotone, assumption)
apply (erule distinctFrom_antimonotone, assumption)
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (erule modified_monotone,assumption) 
apply (erule Bounded_monotone, simp, simp,simp)
apply (erule Bounded_monotone, simp, simp,simp)
apply simp
done
(*>*)

lemma DA_Generalise: 
"\<lbrakk>G \<rhd> e:DAss U n C T m; n \<le> nn; mm \<le> m; U \<subseteq> UU\<rbrakk>
 \<Longrightarrow> G \<rhd> e:  DAss UU nn C T mm"
(*<*)
by (erule vdm_conseq, clarsimp, erule DAss_Generalise, assumption+)
(*>*)
(*
lemma DAss_Weaken: 
"\<lbrakk>DAss n C1 X T nn Y Z E h hh v p; (C1,C2,C):Union\<rbrakk> \<Longrightarrow> DAss n C X T nn Y Z E h hh v p"
apply (simp add: DAss_def, safe)
apply (rule Union_DOM1) apply (erule SubsetTriv, assumption, assumption)
apply (rule Union_DOM1) apply (erule SubsetTriv, assumption, assumption)
apply (rule Union_DOM1) apply (erule SubsetTriv, assumption, assumption)
apply (erule_tac x=F in allE, erule_tac x=N in allE, clarsimp)
apply (erule impE, safe)
  apply (erule Union_regionsExist_CC1, assumption)
  apply (erule Union_regionsDistinct_CC1, assumption, assumption)
  apply (erule Union_distinctFrom_CC1, assumption)
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
  apply (erule Union_distinctFrom_C1C, assumption, assumption)
  apply (erule Union_unmodified_C1C, assumption, assumption)
  apply (erule Union_Bounded_C1C, assumption, assumption)
  apply (erule Union_Size_restricted_C1C, assumption)
done

lemma DA_Weaken: 
"\<lbrakk>G \<rhd> e: DAss n C1 X T nn Y Z; (C1,C2,C):Union\<rbrakk> \<Longrightarrow> G \<rhd> e: DAss n C X T nn Y Z"
by (erule vdm_conseq, clarsimp, erule DAss_Weaken, assumption)
*)

lemma DAss_Const: "\<lbrakk>DAss U n G T nn E h hh v p; m = n + k; mm = nn + k\<rbrakk> \<Longrightarrow> DAss U m G T mm E h hh v p"
(*<*)
apply (simp add: DAss_def, clarsimp)
apply (erule_tac x="q+k" in allE, erule_tac x=CS in allE, erule_tac x=F in allE, clarsimp)
apply (erule impE,safe) apply(rule_tac x=N in exI, simp)
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, clarsimp)
done
(*>*)

lemma DA_Const: "\<lbrakk>G \<rhd> e: DAss U n C T nn; m = n + k; mm = nn + k\<rbrakk> \<Longrightarrow> G \<rhd> e: DAss U m C T mm"
(*<*)
by (erule vdm_conseq, insert DAss_Const, fast)
(*>*)

(*<*)
lemma DAss_PConst0: "DAss n U G A nn E h hh v p = DAss n U G A nn E h hh v pp"
by (simp add: DAss_def)
(*>*)

lemma DAss_PConst: "DAss n U G A nn E h hh v p \<Longrightarrow> DAss n U G A nn E h hh v pp"
(*<*)
by (simp add: DAss_def)
(*>*)

subsubsection {*Rules for primitive operations*}
text {*These rules come in weak and strong forms. Using the former ones should reduce the need
to apply DA\_Weaken, for the price of obtaining more verification conditions.*}

lemma DA_Null: "\<lbrakk>n \<le> m; T=ListET k\<rbrakk> \<Longrightarrow> GG \<rhd> Null: DAss {} m G T n"
(*<*)
apply (rule vdm_conseq, rule vdm_null)
apply (simp add: DAss_def,clarsimp)
apply (rule_tac x="{}" in exI, rule_tac x=0 in exI, rule_tac x="N" in exI, rule_tac x=F in exI, safe)
apply (rule regList) apply(rule mLIST_NIL, simp)
apply (rule modified_Sameheap)
apply (rule Bounded_Empty)
apply (rule Bounded_SameF)
apply simp
done
lemma DA_null: "\<lbrakk>n \<le> m; T=ListET k;U={}\<rbrakk> \<Longrightarrow> GG \<rhd> Null: DAss U m G T n"
by (clarsimp,rule DA_Null,auto)
(*>*)

lemma DA_Int: "\<lbrakk>n \<le> m; T = IntET\<rbrakk> \<Longrightarrow> GG \<rhd> expr.Int i: DAss {} m G T n"
(*<*)
apply (rule vdm_conseq, rule vdm_int)
apply (simp add: DAss_def,clarsimp)
apply (rule_tac x="{}" in exI, rule_tac x=0 in exI, rule_tac x="N" in exI, rule_tac x=F in exI, safe) 
apply (rule regInt)
apply (rule modified_Sameheap)
apply (rule Bounded_Empty)
apply (rule Bounded_SameF)
apply simp
done
lemma DA_int: "\<lbrakk>n \<le> m; T = IntET;U={}\<rbrakk> \<Longrightarrow> GG \<rhd> expr.Int i: DAss U m G T n"
by (clarsimp,rule DA_Int,auto)
(*>*)

lemma DA_IVar: "\<lbrakk>n \<le> m; T = IntET\<rbrakk> \<Longrightarrow> GG \<rhd> IVar x: DAss {} m G T n"
(*<*)
apply (rule vdm_conseq, rule vdm_ivar, clarsimp)
apply (simp add: DAss_def, clarsimp)
apply (rule_tac x="{}" in exI, rule_tac x=0 in exI, rule_tac x="N" in exI, rule_tac x=F in exI, safe) 
apply (rule regInt)
apply (rule modified_Sameheap)
apply (rule Bounded_Empty)
apply (rule Bounded_SameF)
apply simp
done
lemma DA_ivar: "\<lbrakk>n \<le> m; T = IntET;U={}\<rbrakk> \<Longrightarrow> GG \<rhd> IVar x: DAss U m G T n"
by (clarsimp,rule DA_IVar,auto)
(*>*)

lemma DA_RVar: "\<lbrakk>GETr G x = Some T; n \<le> m\<rbrakk> \<Longrightarrow> GG \<rhd> RVar x: DAss {x} m G T n"
(*<*)
apply (rule vdm_conseq, rule vdm_rvar)
apply (simp add: DAss_def, safe)
apply (subgoal_tac "\<exists> R S . (RVal (E\<lfloor>x\<rfloor>),h,Some T,R,S):reg", safe) prefer 2 apply (erule regionsExist_Lookup, simp, assumption)
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=N in exI, rule_tac x=F in exI, safe)
apply (rule modified_Sameheap)
apply (erule distinctFrom_Lookup)
  apply(subgoal_tac "(RVal (renv E x), h, GETr G x, R, S) \<in> reg", assumption, clarsimp, simp,assumption, assumption)
apply (erule Bounded_lookup) apply (subgoal_tac "x:{x}", assumption, simp) 
  apply (subgoal_tac "(RVal (renv E x), h, GETr G x, R, S) \<in> reg",assumption,clarsimp)
apply (rule Bounded_SameF) 
apply (subgoal_tac "S \<le> CS", clarsimp)
apply (erule ContextSize_contains_region)
apply (subgoal_tac "x:{x}", assumption, simp)
apply (simp add: GETr_def)
done
lemma DA_rvar: "\<lbrakk>GETr G x = Some T; n \<le> m;U={x}\<rbrakk> \<Longrightarrow> GG \<rhd> RVar x: DAss U m G T n"
by (clarsimp,rule DA_RVar,auto)
(*>*)

lemma DA_Prim: "\<lbrakk>n \<le> m; T = IntET\<rbrakk> \<Longrightarrow> GG \<rhd> Primop f x y: DAss {} m G T n"
(*<*)
apply (rule vdm_conseq, rule vdm_prim, simp add: DAss_def, safe)
apply (rule_tac x="{}" in exI, rule_tac x="0" in exI, rule_tac x=N in exI, rule_tac x=F in exI, safe)
apply (rule regInt)
apply (rule modified_Sameheap)
apply (rule Bounded_Empty)
apply (rule Bounded_SameF)
apply simp
done
lemma DA_prim: "\<lbrakk>n \<le> m; T = IntET;U={}\<rbrakk> \<Longrightarrow> GG \<rhd> Primop f x y: DAss U m G T n"
by (clarsimp,rule DA_Prim,auto)
(*>*)

lemma DA_Rprim: "\<lbrakk>x: DOM G; y:DOM G; n \<le> m; T = IntET\<rbrakk> \<Longrightarrow> GG \<rhd> RPrimop f x y: DAss {x,y} m G T n"
(*<*)
apply (rule vdm_conseq, rule vdm_rprim, simp add: DAss_def, safe)
apply (rule_tac x="{}" in exI, rule_tac x="0" in exI, rule_tac x=N in exI, rule_tac x=F in exI, safe)
apply (rule regInt)
apply (rule modified_Sameheap)
apply (rule Bounded_Empty)
apply (rule Bounded_SameF)
apply simp
done
lemma DA_rprim:
"\<lbrakk>x: DOM G; y:DOM G; n \<le> m; T = IntET;U={x,y}\<rbrakk> \<Longrightarrow> GG \<rhd> RPrimop f x y: DAss U m G T n"
by (clarsimp,rule DA_Rprim,auto)
(*>*)

subsubsection {* Rules for let-primop combinations *}
lemma DA_Let_Int:
  "\<lbrakk>G \<rhd> e : DAss U n C T m\<rbrakk> \<Longrightarrow> G \<rhd> (LET z = expr.Int i IN e END): DAss U n C T m"
(*<*)
apply (rule vdm_conseq, rule vdm_leti, rule vdm_int)
apply assumption
apply (clarsimp)
apply (rule DAss_PConst)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=CS in allE, erule_tac x=F in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (erule regionsExist1,fast, simp,simp,rule, simp) 
apply (erule regionsDistinct1, fast, simp, simp, rule, simp)
apply (erule distinctFrom1,fast, simp, simp, rule, simp)
apply (erule ContextSizePreserved, simp)
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (erule modified1, fast, simp, rule, simp)
apply (erule Bounded1,  fast, rule, simp)
apply (erule Bounded1, fast, rule, simp)
done
(*>*)

lemma DA_Let_Prim:
  "\<lbrakk>G \<rhd> e : DAss U n C T m\<rbrakk> \<Longrightarrow> G \<rhd> (LET z = Primop f x y IN e END): DAss U n C T m"
(*<*)
apply (rule vdm_conseq, rule vdm_leti, rule vdm_prim)
apply assumption
apply (clarsimp)
apply (rule DAss_PConst)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=CS in allE, erule_tac x=F in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (erule regionsExist1,fast, simp,simp,rule, simp) 
apply (erule regionsDistinct1, fast, simp, simp, rule, simp)
apply (erule distinctFrom1,fast, simp, simp, rule, simp)
apply (erule ContextSizePreserved, simp)
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (erule modified1, fast, simp, rule, simp)
apply (erule Bounded1,  fast, rule, simp)
apply (erule Bounded1, fast, rule, simp)
done
(*>*)

lemma DA_Let_RPrim:
  "\<lbrakk>G \<rhd> e : DAss U n C T m; x : DOM C; y : DOM C
   \<rbrakk> \<Longrightarrow> G \<rhd> (LET z = RPrimop f x y IN e END): DAss ({x,y} \<union> U) n C T m"
(*<*)
apply (rule vdm_conseq, rule vdm_leti, rule vdm_rprim)
apply assumption
apply (clarsimp)
apply (rule DAss_PConst)
apply (simp add: DAss_def, safe)
apply (subgoal_tac "\<exists> n1 n2 . (E, h, U, C, n1) \<in> ContextSize \<and> (E, h, (insert x (insert y U)) - U, C, n2) \<in> ContextSize \<and> n1 + n2 = CS", clarsimp)
prefer 2 apply (erule ContextSize_SPLIT, fast, fast)
apply (erule_tac x=q in allE, erule_tac x=n1 in allE,erule_tac x=F in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (rule regionsExist1) apply (erule regionsExist_antimonotone,fast) apply(fast, simp,rule, simp) 
apply (rule regionsDistinct1) apply(erule regionsDistinct_antimonotone) apply(fast, simp, simp,rule, simp)
apply (rule distinctFrom1) apply(erule distinctFrom_antimonotone) apply(fast, fast, simp, rule, simp)
apply (erule ContextSizePreserved) apply simp
apply simp
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (rule modified1) apply(erule modified_monotone) apply(fast, fast, simp, rule, simp)
apply (rule Bounded1) apply(erule Bounded_monotone) apply(simp, simp, fast, fast, rule, simp)
apply (rule Bounded1) apply (rotate_tac -3) apply(erule Bounded_monotone) apply(simp, simp, fast, fast, rule, simp)
done
lemma DA_Let_rprim:
  "\<lbrakk>G \<rhd> e : DAss U n C T m; x : DOM C; y : DOM C; UU = ({x,y} \<union> U)
   \<rbrakk> \<Longrightarrow> G \<rhd> (LET z = RPrimop f x y IN e END): DAss UU n C T m"
by (rule vdm_conseq, erule DA_Let_RPrim,auto)
(*>*)

lemma DA_Let_HD: 
  "\<lbrakk>G \<rhd> e : DAss U n C T m;
    x: DOM C
   \<rbrakk> \<Longrightarrow> G \<rhd> (LET h = GetFi x F0 IN e END): DAss ({x} \<union> U) n C T m"
(*<*)
apply (rule vdm_conseq, rule vdm_leti, rule vdm_getfi)
apply assumption
apply (erule thin_rl, clarsimp)
apply (rule DAss_PConst)
apply (simp add: DAss_def, safe)
apply (subgoal_tac "\<exists> n1 n2 . (E, ha, U, C, n1) \<in> ContextSize \<and> (E, ha, (insert x U) - U, C, n2) \<in> ContextSize \<and> n1 + n2 = CS", clarsimp)
prefer 2 apply (erule ContextSize_SPLIT, fast, fast)
apply (erule_tac x=q in allE, erule_tac x=n1 in allE, erule_tac x=F in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (rule regionsExist1) apply (erule regionsExist_antimonotone) apply(fast, fast, simp, rule, simp)
apply (rule regionsDistinct1, erule regionsDistinct_antimonotone)  apply(fast, fast, simp, rule, simp)
apply (rule distinctFrom1, erule distinctFrom_antimonotone) apply(fast, fast, simp, rule, simp)
apply (erule ContextSizePreserved) apply simp
apply simp
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (rule modified1)  apply(erule modified_monotone) apply(fast, fast, simp, rule, simp)
apply (rule Bounded1) apply(erule Bounded_monotone) apply(simp, simp, fast, fast, rule, simp)
apply (rule Bounded1) apply (rotate_tac -3) apply(erule Bounded_monotone) apply(simp, simp, fast, fast, rule, simp)
done
lemma DA_Let_hd: 
  "\<lbrakk>G \<rhd> e : DAss U n C T m;
    UU=({x} \<union> U); x: DOM C
   \<rbrakk> \<Longrightarrow> G \<rhd> (LET h = GetFi x F0 IN e END): DAss UU n C T m"
by (rule vdm_conseq, rule DA_Let_HD, auto)
(*>*)

(*<*)
lemma regionsExist_TL:
"\<lbrakk>GETr C y = Some (ListET k); renv E y = Ref a; regionsExist (insert y (U - {x})) C h E\<rbrakk> 
  \<Longrightarrow> regionsExist U (C(x\<mapsto>\<^sub>fListET k)) h E\<lfloor>x:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor>"
apply (simp add: regionsExist_def, safe)
apply (case_tac "xa = x", clarsimp) 
apply (erule_tac x=y in allE, erule impE, clarsimp) apply (erule GETrSome_DOM)
apply clarsimp apply (erule reg.elims, simp_all, clarsimp)
  apply (erule mLIST.elims, simp_all, clarsimp)
  apply (simp add: GETr_def) apply (rule, rule, erule regList)
  apply simp
apply (erule_tac x=xa in allE, erule impE, clarsimp)
apply (simp add: DOM_def)
apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET k)) xa = GETr C xa", clarsimp)
apply (rule GETr_Update1, fast)
done

lemma regionsDistinct_TL:
"\<lbrakk>GETr C y = Some (ListET k); y \<notin> U; renv E y = Ref a; regionsExist (insert y (U - {x})) C h E;
  regionsDistinct (insert y (U - {x})) C h E\<rbrakk> 
  \<Longrightarrow> regionsDistinct U (C(x\<mapsto>\<^sub>fListET k)) h E\<lfloor>x:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor>"
apply (simp add: regionsDistinct_def regionsExist_def, safe)
apply (case_tac "xa = x", clarsimp) 
apply (case_tac "xx = x", clarsimp)
apply (subgoal_tac "y:DOM C")
prefer 2  apply (erule GETrSome_DOM)
apply (erule_tac x=y in allE, erule impE, clarsimp)
apply clarsimp
apply (erule_tac x=y in allE, erule_tac x=xx in allE, erule_tac x=Rxa in allE, erule_tac x=Rxx in allE, erule impE, clarsimp)
apply (rule, simp add: DOM_def)
apply (rule, fast)
apply (rule, fast)
apply (rule,subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET k)) xx = GETr C xx", clarsimp, assumption)
apply (erule GETr_Update1)
apply (simp add: GETr_def)
apply (erule reg.elims, simp_all, clarsimp)
apply (rotate_tac -3, erule reg.elims, simp_all, clarsimp)
apply (rotate_tac -2, erule mLIST.elims, simp_all, clarsimp)
apply (subgoal_tac "n=nb \<and> R=X", clarsimp)
prefer 2 apply (erule mLIST_Unique, assumption)
apply fast
(*xa \<noteq> x*)
apply (case_tac "xx = x", clarsimp)
apply (subgoal_tac "y:DOM C")
prefer 2  apply (erule GETrSome_DOM)
apply (erule_tac x=y in allE, erule impE, clarsimp)
apply clarsimp
apply (erule_tac x=xa in allE, erule_tac x=y in allE, erule_tac x=Rx in allE, erule_tac x=Rxa in allE, erule impE, clarsimp)
apply (rule, simp add: DOM_def)
apply (rule, fast)
apply (rule,rule, subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET k)) xa = GETr C xa", clarsimp, assumption)
apply (rule GETr_Update1, fast)
apply (rule,fast)
apply (simp add: GETr_def)
apply (rotate_tac 8)
apply (erule reg.elims, simp_all, clarsimp)
apply (erule reg.elims, simp_all, clarsimp)
apply (rotate_tac -2, erule mLIST.elims, simp_all, clarsimp)
apply (subgoal_tac "n=nb \<and> R=X", clarsimp)
prefer 2 apply (erule mLIST_Unique, assumption)
apply fast
(* xx \<noteq> x*)
apply (erule_tac x=xa in allE, erule_tac x=xx in allE, erule_tac x=Rx in allE, erule_tac x=Rxx in allE, erule impE, clarsimp)
apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET k)) xa = GETr C xa", clarsimp)
apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET k)) xx = GETr C xx", clarsimp)
apply (rule, erule reg_DOM)
apply (rule, erule reg_DOM)
apply (rule, rule, fast)
apply (rule, fast)
apply (rule GETr_Update1, fast)
apply (rule GETr_Update1, fast)
apply fast
done

lemma distinctFrom_TL:
"\<lbrakk>GETr C y = Some (ListET k); y \<notin> U; renv E y = Ref a; regionsExist (insert y (U - {x})) C h E;
  distinctFrom (insert y (U - {x})) C h E F\<rbrakk>
  \<Longrightarrow> distinctFrom U (C(x\<mapsto>\<^sub>fListET k)) h E\<lfloor>x:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor> F"
apply (simp add: distinctFrom_def regionsExist_def, safe)
apply (case_tac "xa = x", clarsimp) 
apply (subgoal_tac "y:DOM C")
prefer 2  apply (erule GETrSome_DOM)
apply (erule_tac x=y in allE, erule impE, clarsimp)
apply clarsimp
apply (erule_tac x=y in allE, erule impE, clarsimp)
apply (erule_tac x=Rxa in allE, clarsimp)
apply (erule impE, rule, fast)
apply (erule reg.elims, simp_all, clarsimp)
apply (erule reg.elims, simp_all, clarsimp)
apply (rotate_tac -2, erule mLIST.elims, simp_all, clarsimp)
apply (subgoal_tac "n=nb \<and> R=X", clarsimp)
prefer 2 apply (erule mLIST_Unique, assumption)
apply fast
apply (rotate_tac 3, erule thin_rl)
apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET k)) xa = GETr C xa", clarsimp)
apply (erule_tac x=xa in allE, erule impE, clarsimp)
apply (erule reg_DOM)
apply fast
apply (rule GETr_Update1,fast)
done

lemma modified_TL:
"\<lbrakk>GETr C y = Some (ListET k); y \<notin> U; renv E y = Ref a; regionsExist (insert y (U - {x})) C h E;
  modified F U (C(x\<mapsto>\<^sub>fListET k)) h E\<lfloor>x:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor> hh\<rbrakk>
  \<Longrightarrow> modified F (insert y (U - {x})) C h E hh"
apply (simp add: modified_def regionsExist_def, safe)
apply (subgoal_tac "y:DOM C")
prefer 2  apply (erule GETrSome_DOM)
apply (erule_tac x=l in allE, erule impE, clarsimp)
apply (case_tac "z=x", clarsimp)
apply (erule_tac x=y in allE, erule impE, clarsimp)
apply clarsimp
apply (erule_tac x=y in allE, erule_tac x=Rx in allE, erule impE, clarsimp)
apply (rule, assumption)
apply (simp add: GETr_def)
apply (erule reg.elims, simp_all, clarsimp)
apply (erule reg.elims, simp_all, clarsimp)
apply (rotate_tac -2, erule mLIST.elims, simp_all, clarsimp)
apply (subgoal_tac "n=nb \<and> R=X", clarsimp)
apply (erule mLIST_Unique, assumption)
(*z \<noteq> x*)
apply (rotate_tac 3, erule thin_rl)
apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET k)) z = GETr C z", clarsimp)
apply (erule_tac x=z in allE,erule_tac x=Rz in allE, erule impE, clarsimp)
apply (rule,erule reg_DOM)
apply fast
apply fast
apply (rule GETr_Update1,fast)
done

lemma Bounded_TL:
"\<lbrakk>GETr C y = Some (ListET k); y \<notin> U; renv E y = Ref a; regionsExist (insert y (U - {x})) C h E;
  Bounded R F U (C(x\<mapsto>\<^sub>fListET k)) h E\<lfloor>x:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor>\<rbrakk>
  \<Longrightarrow> Bounded R F (insert y (U - {x})) C h E"
apply (simp add: Bounded_def regionsExist_def)
apply (rule, rule)
apply (subgoal_tac "y:DOM C")
prefer 2  apply (erule GETrSome_DOM)
apply (erule_tac x=l in allE, erule impE, clarsimp)
apply (erule disjE, simp)
apply (subgoal_tac "\<exists>xa. (xa = y \<or> xa \<in> U \<and> xa \<noteq> x) \<and> xa \<in> DOM C \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E xa), h, GETr C xa, Rx, Sx) \<in> reg) \<and> l \<in> Rx)", simp)
apply clarsimp
apply (case_tac "xa=x")
apply (erule_tac x=y in allE, erule impE, clarsimp)
apply (rule_tac x=y in exI)
apply clarsimp
apply (rule_tac x=Rxa in exI,rule, rule_tac x=Sxa in exI, simp)
apply (simp add: GETr_def)
apply (erule reg.elims, simp_all, clarsimp)
apply (erule reg.elims, simp_all, clarsimp)
apply (rotate_tac -2, erule mLIST.elims, simp_all, clarsimp)
apply (subgoal_tac "n=nb \<and> Ra=X", clarsimp)
apply (erule mLIST_Unique, assumption)
(*xa \<noteq> x*)
apply (subgoal_tac "\<exists>xa. (xa = y \<or> xa \<in> U \<and> xa \<noteq> x) \<and> xa \<in> DOM C \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E xa), h, GETr C xa, Rx, Sx) \<in> reg) \<and> l \<in> Rx)", simp)
apply (rule_tac x=xa in exI, simp add: DOM_def)
apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET k)) xa = GETr C xa", clarsimp, fast)
apply (rule GETr_Update1,fast)
done

lemma ContextSize_UnusedU_ContextExtension[rule_format]:
"(E, h, U, C, nn) \<in> ContextSize \<Longrightarrow> (\<forall> x . x \<notin> U \<longrightarrow> (E, h, U, C(x\<mapsto>\<^sub>fT), nn) \<in> ContextSize)"
apply (erule ContextSize.induct)
(*1*) apply (clarsimp,rule ContextSizeNIL, simp,simp)
(*2*) apply clarsimp apply (subgoal_tac "xa \<noteq> x") prefer 2 apply fast
      apply (rule ContextSizeCONS,assumption) 
      apply (subgoal_tac "GETr (C(xa\<mapsto>\<^sub>fT)) x = GETr C x", clarsimp,assumption)
      apply (erule GETr_Update1)
      apply fast apply simp
(*3 apply clarsimp apply (subgoal_tac "xa \<noteq> x") prefer 2 apply fast
      apply (erule_tac x=xa in allE, clarsimp)
      apply (rule ContextSizeNotUsed,assumption) apply (simp add: DOM_def,fast)
      apply assumption*)
done

lemma regionsExist_TL2:
"\<lbrakk>GETr C x = Some (ListET k); renv E x = Ref a; x \<in> U; x \<in> DOM C; regionsExist U C h E\<rbrakk>
       \<Longrightarrow> regionsExist U (C(x\<mapsto>\<^sub>fListET k)) h E\<lfloor>x:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor>"
apply (simp add: regionsExist_def,clarsimp) 
    apply (case_tac "x = xa",clarsimp)
    (*x = xa*) apply (erule_tac x=x in allE, clarsimp, simp add: GETr_def)
             apply (erule reg.elims, clarsimp)
             apply (erule mLIST.elims, clarsimp,clarsimp)
             apply (rule, rule,erule regList) apply simp apply clarsimp apply clarsimp
    (*x \<noteq> xa*) apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET k)) xa = GETr C xa", clarsimp) 
             apply (subgoal_tac "xa:DOM C",fast)
             apply (erule DOM_Update1, assumption)
             apply (erule GETr_Update1)
done

lemma regionsDistinct_TL2:
"\<lbrakk>GETr C x = Some (ListET k); renv E x = Ref a; x \<in> U; x \<in> DOM C; regionsExist U C h E; regionsDistinct U C h E\<rbrakk>
 \<Longrightarrow> regionsDistinct U (C(x\<mapsto>\<^sub>fListET k)) h E\<lfloor>x:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor>"
apply (simp add: regionsDistinct_def, clarsimp) 
apply (case_tac "xa = x", clarsimp)
(*xa = x*) 
  apply (subgoal_tac "\<exists> R S . (RVal (renv E x), h, GETr C x, R, S) \<in> reg", clarsimp)
  prefer 2 apply (simp only: regionsExist_def) apply (erule_tac x=x in allE, erule impE,clarsimp,fastsimp)
  apply (erule_tac x=x in allE, rotate_tac -1, erule_tac x=xx in allE, rotate_tac -1, 
       erule_tac x=R in allE, rotate_tac -1, erule_tac x=Rxx in allE, erule impE, safe)
   apply (erule DOM_Update1, assumption)
   apply fastsimp
   apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET k)) xx = GETr C xx", clarsimp,fast) 
   apply (erule GETr_Update1)
   apply (rotate_tac -4, erule reg.elims, clarsimp) apply (erule mLIST.elims, clarsimp, clarsimp)
   apply (erule reg.elims, clarsimp)
   apply (subgoal_tac "n=na \<and> R=X", clarsimp,fast) 
   apply (erule mLIST_Unique, assumption)
   apply (clarsimp, clarsimp)
   apply (clarsimp, clarsimp)
(*xa \<noteq> x*) 
apply clarsimp
  apply (case_tac "xx=x",clarsimp)
  (*xx=x*)
  apply (subgoal_tac "\<exists> R S . (RVal (renv E x), h, GETr C x, R, S) \<in> reg", clarsimp)
  prefer 2 apply (simp only: regionsExist_def) apply (erule_tac x=x in allE, erule impE,clarsimp,fastsimp)
  apply (erule_tac x=xa in allE, rotate_tac -1, erule_tac x=x in allE, rotate_tac -1, 
       erule_tac x=Rx in allE, rotate_tac -1, erule_tac x=R in allE, erule impE, safe)
  apply (erule DOM_Update1,fast)
  apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET k)) xa = GETr C xa", clarsimp,fast) 
  apply (rule GETr_Update1,fast)
  apply fastsimp
  apply (rotate_tac -2, erule reg.elims, clarsimp) apply (erule mLIST.elims, clarsimp, clarsimp)
  apply (rotate_tac 8, erule reg.elims, clarsimp)
  apply (subgoal_tac "n=na \<and> R=X", clarsimp,fast) 
  apply (erule mLIST_Unique, assumption)
  apply (clarsimp, clarsimp)
  apply (clarsimp, clarsimp)
  (*xx=x*)
  apply (erule_tac x=xa in allE, rotate_tac -1, erule_tac x=xx in allE, rotate_tac -1, 
       erule_tac x=Rx in allE, rotate_tac -1, erule_tac x=Rxx in allE, erule impE, safe)
   apply (erule DOM_Update1,fast)
   apply (erule DOM_Update1,fast)
   apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET k)) xa = GETr C xa", clarsimp,fast) 
   apply (rule GETr_Update1,fast)
   apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET k)) xx = GETr C xx", clarsimp,fast) 
   apply (rule GETr_Update1,fast)
   apply fast
done

lemma distinctFrom_TL2:
"\<lbrakk>GETr C x = Some (ListET k); renv E x = Ref a; x \<in> U; x \<in> DOM C; regionsExist U C h E; distinctFrom U C h E F\<rbrakk>
\<Longrightarrow> distinctFrom U (C(x\<mapsto>\<^sub>fListET k)) h E\<lfloor>x:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor> F"
apply (simp add: distinctFrom_def,clarsimp) 
apply (case_tac "x = xa",clarsimp)
(*x = xa*) 
  apply (subgoal_tac "\<exists> R S . (RVal (renv E x), h, GETr C x, R, S) \<in> reg", clarsimp)
  prefer 2 apply (simp only: regionsExist_def) apply (erule_tac x=x in allE, erule impE,clarsimp,fastsimp)
  apply (erule_tac x=x in allE, clarsimp, simp add: GETr_def)
  apply (erule_tac x=R in allE, erule impE,fast)
  apply (erule reg.elims, clarsimp)
  apply (erule reg.elims, clarsimp)
  apply (rotate_tac -2, erule mLIST.elims, clarsimp,clarsimp)
  apply (subgoal_tac "n=nb \<and> Ra=X",clarsimp) 
  apply (erule mLIST_Unique, assumption)
  apply (clarsimp, clarsimp)
  apply (clarsimp, clarsimp)
(*x \<noteq> xa*) 
  apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET k)) xa = GETr C xa", clarsimp) 
  apply (subgoal_tac "xa:DOM C",fast)
  apply (erule DOM_Update1, assumption)
  apply (erule GETr_Update1)
done 

lemma modified_TL2:
"\<lbrakk>GETr C x = Some (ListET k); renv E x = Ref a; x \<in> U; x \<in> DOM C; regionsExist U C h E;
          modified F U (C(x\<mapsto>\<^sub>fListET k)) h E\<lfloor>x:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor> hh; R \<inter> FF = {}\<rbrakk>
       \<Longrightarrow> modified F U C h E hh"
apply (simp add: modified_def,clarsimp) 
apply (erule_tac x=l in allE, erule impE, clarsimp)
apply (case_tac "z = x",clarsimp)
(*z = x*) 
  apply (subgoal_tac "\<exists> R S . (RVal (renv E x), h, GETr C x, R, S) \<in> reg", clarsimp)
  prefer 2 apply (simp only: regionsExist_def) apply (erule_tac x=x in allE, erule impE,clarsimp,fastsimp)
  apply (erule_tac x=x in allE, clarsimp, simp add: GETr_def)
  apply (erule_tac x=Ra in allE, erule impE,fast)
  apply (erule reg.elims, clarsimp)
  apply (erule reg.elims, clarsimp)
  apply (rotate_tac -2, erule mLIST.elims, clarsimp,clarsimp)
  apply (subgoal_tac "n=nb \<and> Ra=X",clarsimp) 
  apply (erule mLIST_Unique, assumption)
  apply (clarsimp, clarsimp)
  apply (clarsimp, clarsimp)
(*z \<noteq> x*) 
  apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET k)) z = GETr C z", clarsimp) 
  apply (subgoal_tac "z:DOM C",fast)
  apply (erule DOM_Update1,fast)
  apply (rule GETr_Update1, fast)
apply assumption
done 

lemma Bounded_TL2:
"\<lbrakk>GETr C x = Some (ListET k); renv E x = Ref a; x \<in> U;x \<in> DOM C; regionsExist U C h E;
  Bounded R F U (C(x\<mapsto>\<^sub>fListET k)) h E\<lfloor>x:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor>\<rbrakk>
\<Longrightarrow> Bounded R F U C h E"
apply (simp add: Bounded_def) 
apply (rule, rule)
apply (erule_tac x=l in allE, erule impE, clarsimp)
apply (erule disjE, simp)
apply (subgoal_tac "\<exists>x. x \<in> U \<and> x \<in> DOM C \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E x), h, GETr C x, Rx, Sx) \<in> reg) \<and> l \<in> Rx)", simp, clarsimp)
apply (case_tac "xa = x",clarsimp)
(*xa = x*) 
  apply (subgoal_tac "\<exists> R S . (RVal (renv E x), h, GETr C x, R, S) \<in> reg", clarsimp)
  prefer 2 apply (simp only: regionsExist_def) apply (erule_tac x=x in allE, erule impE,clarsimp,fastsimp)
  apply (rule_tac x=x in exI,clarsimp, simp add: GETr_def)
  apply (rule_tac x=Ra in exI)
  apply (rule, fast)
  apply (erule reg.elims, clarsimp)
  apply (erule reg.elims, clarsimp)
  apply (rotate_tac -2, erule mLIST.elims, clarsimp,clarsimp)
  apply (subgoal_tac "n=nb \<and> Ra=X",clarsimp) 
  apply (erule mLIST_Unique, assumption)
  apply (clarsimp, clarsimp)
  apply (clarsimp, clarsimp)
(*xa \<noteq> x*) 
  apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET k)) xa = GETr C xa", clarsimp) 
  apply (subgoal_tac "xa:DOM C",fast)
  apply (erule DOM_Update1,fast)
  apply (rule GETr_Update1, fast)
done 
(*>*)

lemma DA_Let_TL: 
  "\<lbrakk>GETr C y = Some (ListET k); nk = n+k; 
    G \<rhd> e : DAss U nk (C(x\<mapsto>\<^sub>f(ListET k))) A m;
    y \<notin> U - {x}\<rbrakk>
 \<Longrightarrow> G \<rhd> (LET rf x = GetFr y F1 IN e END) : DAss ((U-{x}) \<union> {y}) n C A m"
(*<*)
apply (clarsimp,rule vdm_conseq, rule vdm_letr, rule vdm_getfr)
apply assumption
apply (rotate_tac 1, erule thin_rl, clarsimp)
apply (rule DAss_PConst)
apply (subgoal_tac "y:DOM C")
prefer 2  apply (erule GETrSome_DOM)
apply (case_tac "y:U",clarsimp)
prefer 2 
(* y \<notin> U*)
  apply (simp add: DAss_def, safe)
  apply (subgoal_tac "\<exists> R mm .(RVal (E\<lfloor>y\<rfloor>), h,Some (ListET k), R, mm) \<in> reg",clarsimp)
  prefer 2 apply (erule regionsExist_Lookup,fast,assumption)
  apply (subgoal_tac "\<exists> nn . (E,h,(insert y (U - {x}))-{y},C,nn):ContextSize \<and> CS = mm + nn",clarsimp)
  prefer 2 apply (erule ContextSize_split,fast, simp add: GETr_def)
  apply (case_tac "x:U")
  (*x:U*) apply (subgoal_tac "(E\<lfloor>x:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor>, h, U - {x}, C(x\<mapsto>\<^sub>fListET k), nn) \<in> ContextSize")
          prefer 2 apply (erule ContextSizePreservedU, simp)
                   apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET k)) xa = GETr C xa", clarsimp) apply (rule GETr_Update1, fast)
          apply (erule_tac x=q in allE, erule_tac x="nn+(mm-k)" in allE, erule_tac x=F in allE, erule impE, simp)
            apply (rule_tac x=N in exI, simp) apply (rule, erule regionsExist_TL,assumption+)
                                              apply (rule, erule regionsDistinct_TL,assumption+)
                                              apply (rule, erule distinctFrom_TL,assumption+)
                                              apply (rule, erule ContextSizeCONS) apply (simp add: GETr_def) apply (erule reg_F1)
                                                apply assumption apply simp apply (subgoal_tac "k \<le> mm",clarsimp)
                                              apply (erule reg.elims, clarsimp) apply (erule mLIST.elims, clarsimp, clarsimp)
                                                apply clarify+
          apply (rule_tac x=Ra in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, simp)
          apply (rule, erule modified_TL, assumption+)
          apply (rule, erule Bounded_TL, assumption+)
          apply (erule Bounded_TL, assumption+)
  (*x\<notin>U*) apply (subgoal_tac "(E\<lfloor>x:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor>, h, U-{x}, C(x\<mapsto>\<^sub>fListET k), nn) \<in> ContextSize")
           prefer 2 apply (erule ContextSizePreservedU) apply (subgoal_tac "x \<noteq> xa", simp,fast)
          apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET k)) xa = GETr C xa", simp) 
          apply (rule GETr_Update1, fast)
          apply (erule_tac x=q in allE, erule_tac x=nn in allE, erule_tac x=F in allE, erule impE, simp)
            apply (rule_tac x=N in exI, simp) apply (rule, erule regionsExist_TL,assumption+)
                                                apply (subgoal_tac "U-{x}=U",clarsimp,fast)
                                              apply (rule, erule regionsDistinct_TL,assumption+)
                                                apply (subgoal_tac "U-{x}=U",clarsimp,fast)
                                                apply (subgoal_tac "U-{x}=U",clarsimp,fast)
                                              apply (rule, erule distinctFrom_TL,assumption+)
                                                apply (subgoal_tac "U-{x}=U",clarsimp,fast)
                                                apply (subgoal_tac "U-{x}=U",clarsimp,fast)
                                              apply (subgoal_tac "k \<le> mm",clarsimp)
                                              apply (erule reg.elims, clarsimp) apply (erule mLIST.elims, clarsimp, clarsimp)
                                                apply clarify+
          apply (rule_tac x=Ra in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI)
          apply (rule,simp)      
          apply (rule, simp)
          apply (rule, erule modified_TL, assumption+)
          apply (rule, simp)
          apply (rule, erule Bounded_TL, assumption+)
          apply (rule, erule Bounded_TL, assumption+)
          apply simp
(*y:U*)
apply (subgoal_tac "insert x (U - {x}) = U", clarsimp) prefer 2 apply fast
apply (subgoal_tac "x: DOM C")
prefer 2 apply (erule GETrSome_DOM)
apply (simp add: DAss_def, safe)
apply (subgoal_tac "(\<exists> R S . (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, R, S) \<in> reg)", clarsimp) 
prefer 2 apply (erule ContextSize_regionsExist,fast)
apply (subgoal_tac "k \<le> S") 
prefer 2 apply (rotate_tac 1, erule thin_rl, erule reg.elims, clarsimp) 
         apply (erule mLIST.elims, clarsimp, clarsimp, clarify+)
apply (subgoal_tac "S \<le> CS")  
prefer 2 apply (rotate_tac 1, erule thin_rl, erule ContextSize_contains_region, assumption,simp add: GETr_def)
apply (subgoal_tac "(E\<lfloor>x:=h\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor>, h, U, C(x\<mapsto>\<^sub>fListET k), CS-k) \<in> ContextSize")
prefer 2 apply (subgoal_tac "(E,h,U-{x},C,CS-S):ContextSize") prefer 2 apply(erule ContextSize_delete_Used) apply (assumption,simp)
         apply (rule ContextSizeCONS,assumption) apply (simp add: GETr_def) apply (erule reg_F1)
           apply (erule ContextSizePreservedU) apply simp
             apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET k)) xa = GETr C xa",simp) apply (rule GETr_Update1,fast)
         apply simp
apply (erule_tac x=q in allE, erule_tac x="CS-k" in allE, erule_tac x=F in allE, erule impE, clarsimp)
     apply (rule_tac x=N in exI, safe)
       apply (rule regionsExist_TL2, assumption+)
       apply (rule regionsDistinct_TL2, assumption+)
       apply (rule distinctFrom_TL2, assumption+)
apply (rule_tac x=Ra in exI, rule_tac x=Sa in exI, rule_tac x=M in exI, rule_tac x=FF in exI)
          apply (rule,simp)      
          apply (rule, simp)
          apply (rule, erule modified_TL2, assumption+)
          apply (rule, simp)
          apply (rule, erule Bounded_TL2, assumption+)
          apply (rule, erule Bounded_TL2, assumption+)
          apply simp
done
lemma DA_Let_tl: 
  "\<lbrakk>GETr C y = Some (ListET k); nk = n+k; y \<notin> U; 
    G \<rhd> e : DAss U nk (C(x\<mapsto>\<^sub>f(ListET k))) A m; UU=((U-{x}) \<union> {y})\<rbrakk>
 \<Longrightarrow> G \<rhd> (LET rf x = GetFr y F1 IN e END) : DAss UU n C A m"
by (rule vdm_conseq, rule DA_Let_TL, auto)
(*>*)

subsubsection {*General let-rules*}
(*<*)
lemma reg_h_h1_letv:
"\<lbrakk>U1 \<inter> U2 = {}; regionsExist (U1 \<union> U2) C h E; regionsDistinct (U1 \<union> U2) C h E;
  distinctFrom (U1 \<union> U2) C h E F; modified F U1 C h E h1; x:DOM C; x:U2;
 (RVal E\<lfloor>x\<rfloor>, h, GETr C x, R, S) \<in> reg\<rbrakk>
 \<Longrightarrow> (RVal E\<lfloor>x\<rfloor>, h1, GETr C x, R, S) \<in> reg"
apply (rule reg_Preserved,assumption,clarsimp)
apply (simp add: modified_def, erule_tac x=l in allE, erule impE, safe)
apply (simp add: distinctFrom_def)
apply (erule_tac x=x in allE,clarsimp,fast) 
apply (erule reg_region_in_heap1, assumption)
apply (subgoal_tac "x \<noteq> z")
apply (simp add: regionsDistinct_def,fast)
apply fast
done

lemma reg_h1_h_letv:
"\<lbrakk>U1 \<inter> U2 = {}; regionsExist (U1 \<union> U2) C h E; regionsDistinct (U1 \<union> U2) C h E;
  distinctFrom (U1 \<union> U2) C h E F; modified F U1 C h E h1; x:DOM C; x:U2;
  (RVal E\<lfloor>x\<rfloor>, h1, GETr C x, R, S) \<in> reg\<rbrakk>
 \<Longrightarrow> (RVal E\<lfloor>x\<rfloor>, h, GETr C x, R, S) \<in> reg"
apply (subgoal_tac "\<exists> RR SS . (RVal E\<lfloor>x\<rfloor>, h, GETr C x, RR, SS) \<in> reg", clarsimp)
apply (subgoal_tac "(RVal (renv E x), h1, GETr C x, RR, SS) \<in> reg")
apply (subgoal_tac "R=RR \<and> S=SS", clarsimp)
apply (erule reg_Unique, assumption)
apply (erule reg_h_h1_letv, assumption+)
apply (simp add: regionsExist_def)
done

lemma regEx_Letv:
"\<lbrakk>U1 \<inter> U2 = {}; regionsExist (U1 \<union> U2) C h E; regionsDistinct (U1 \<union> U2) C h E; 
  distinctFrom (U1 \<union> U2) C h E F; modified F U1 C h E h1; \<forall> x . x:U2 \<longrightarrow> renv EE = renv E\<rbrakk>
 \<Longrightarrow> regionsExist U2 C h1 EE"
apply (simp (no_asm) add: regionsExist_def, clarsimp)
apply (erule impE,fast)
apply (subgoal_tac "\<exists>Rx Sx. (RVal (renv E x), h, GETr C x, Rx, Sx) \<in> reg", clarsimp)
apply (rule_tac x=Rx in exI, rule_tac x=Sx in exI)
apply (erule reg_h_h1_letv, assumption+)
apply (simp add: regionsExist_def)
done

lemma regsDist_Letv:
"\<lbrakk>U1 \<inter> U2 = {}; regionsExist (U1 \<union> U2) C h E; regionsDistinct (U1 \<union> U2) C h E;
  distinctFrom (U1 \<union> U2) C h E F; modified F U1 C h E h1; \<forall> x . x:U2 \<longrightarrow> renv EE = renv E\<rbrakk>
 \<Longrightarrow> regionsDistinct U2 C h1 EE"
apply (simp (no_asm) add: regionsDistinct_def, clarsimp)
apply (erule impE,fast)
apply (subgoal_tac "(RVal (renv E x), h, GETr C x, Rx, Sx) \<in> reg")
apply (subgoal_tac "(RVal (renv E xx), h, GETr C xx, Rxx, Sxx) \<in> reg")
apply (simp add: regionsDistinct_def,fast)
apply (erule reg_h1_h_letv, assumption+, simp)
apply (erule reg_h1_h_letv, assumption+, simp)
done

lemma distFr_Letv:
"\<lbrakk>U1 \<inter> U2 = {}; regionsExist (U1 \<union> U2) C h E; regionsDistinct (U1 \<union> U2) C h E;
  distinctFrom (U1 \<union> U2) C h E F; modified F U1 C h E h1;
  Bounded FF F U1 C h E; \<forall> x . x:U2 \<longrightarrow> renv EE = renv E\<rbrakk>
 \<Longrightarrow> distinctFrom U2 C h1 EE FF"
apply (simp (no_asm)add: distinctFrom_def, clarsimp)
apply (erule impE,fast)
apply (simp add: Bounded_def)
apply (subgoal_tac "Rx \<inter> (F \<union> {l. \<exists>z. z \<in> U1 \<and> z \<in> DOM C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)})={}")
apply fast
apply (subgoal_tac "(RVal (renv E x), h, GETr C x, Rx, Sx) \<in> reg")
apply (subgoal_tac "Rx \<inter> F \<subseteq> {}")
apply (subgoal_tac "Rx \<inter> {l. \<exists>z. z \<in> U1 \<and> z \<in> DOM C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)} \<subseteq>  {}",fast)
apply (rule, clarsimp)
apply (subgoal_tac "x \<noteq> z", simp add: regionsDistinct_def) apply fast
apply fast
apply (simp add: distinctFrom_def,fast)
apply (erule reg_h1_h_letv, assumption+)
done

lemma mod_Letv:
"\<lbrakk>U1 \<inter> U2 = {}; regionsExist (U1 \<union> U2) C h E; regionsDistinct (U1 \<union> U2) C h E; 
  distinctFrom (U1 \<union> U2) C h E F; modified F U1 C h E h1;
  Bounded FF F U1 C h E; modified FF U2 C h1 EE hh; \<forall> x . x:(U1 \<union> U2) \<longrightarrow> renv EE = renv E\<rbrakk>
 \<Longrightarrow> modified F (U1 \<union> U2) C h E hh"
apply (simp add: modified_def, clarsimp)
apply (subgoal_tac "modified F U1 C h E h1")
prefer 2 apply (simp add: modified_def)
apply (erule_tac x=l in allE, erule impE,clarsimp) apply fast
apply (erule SameOHTransitive)
apply (erule_tac x=l in allE, erule impE) apply rule
apply (simp add: Bounded_def)
apply (subgoal_tac "l \<notin> {l. \<exists>z. z \<in> U1 \<and> z \<in> DOM C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}",fast)
apply clarsimp
apply fast
apply rule apply (simp add: modified_def) apply (erule_tac x=l in allE, erule impE,fast) apply (simp add: sameOH_def)
  apply (simp add: fmap_lookup_def fmap_dom_def dom_def)
apply clarsimp
apply (subgoal_tac "(RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg",fast)
apply (erule reg_h1_h_letv, assumption+)
apply fast
done

lemma Bnd_Letv:
"\<lbrakk>U1 \<inter> U2 = {}; regionsExist (U1 \<union> U2) C h E; regionsDistinct (U1 \<union> U2) C h E; 
  distinctFrom (U1 \<union> U2) C h E F; modified F U1 C h E h1; Bounded FF F U1 C h E;
  Bounded Ra FF U2 C h1 EE; \<forall> x . x:(U1 \<union> U2) \<longrightarrow> renv EE = renv E\<rbrakk>
 \<Longrightarrow> Bounded Ra F (U1 \<union> U2) C h E"
apply (simp add: Bounded_def)
apply (rule, rule)
apply (rotate_tac -3, erule_tac x=l in allE, erule impE,simp, erule disjE)
apply (subgoal_tac "l : F \<union> {l. \<exists>z. z \<in> U1 \<and> z \<in> DOM C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}")
prefer 2 apply fast
apply (subgoal_tac "l : F \<or> l: {l. \<exists>z. z \<in> U1 \<and> z \<in> DOM C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}")
prefer 2 apply fast
apply (erule disjE,simp)
apply (subgoal_tac "\<exists>x. (x \<in> U1 \<or> x \<in> U2) \<and> x \<in> DOM C \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E x), h, GETr C x, Rx, Sx) \<in> reg) \<and> l \<in> Rx)",simp)
apply clarsimp
apply fast
apply (subgoal_tac "\<exists>x. (x \<in> U1 \<or> x \<in> U2) \<and> x \<in> DOM C \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E x), h, GETr C x, Rx, Sx) \<in> reg) \<and> l \<in> Rx)",simp)
apply clarsimp
apply (subgoal_tac "(RVal (renv E x), h, GETr C x, Rx, Sx) \<in> reg",fast)
apply (erule reg_h1_h_letv, assumption+)
done
(*>*)

lemma DA_Letv:
      "\<lbrakk>G \<rhd> e : DAss U1 n C T1 m;
        G \<rhd> ee : DAss U2 m C T2 k; T1 = UnitET;
        U1 \<inter> U2 = {}\<rbrakk>
     \<Longrightarrow> G \<rhd> (LET _ = e IN ee END): DAss (U1 \<union> U2) n C T2 k"
(*<*)
apply (rule vdm_conseq,erule vdm_letv, assumption)
apply (erule thin_rl, erule thin_rl, clarsimp)
apply (simp add: DAss_def, safe)
apply (subgoal_tac "(\<exists> n1 n2 . (E, h, U1, C, n1) \<in> ContextSize \<and> (E, h, U2, C, n2) \<in> ContextSize \<and> n1 + n2 = CS)", clarsimp)
prefer 2 apply (erule ContextSize_SPLIT, simp, assumption)
apply (erule_tac x="n2+q" in allE, erule_tac x=n1 in allE, erule_tac x=F in allE, erule impE, clarsimp)
apply (rule_tac x=N in exI, clarsimp)
  apply(rotate_tac 1, erule thin_rl,safe)
  apply (erule regionsExist_antimonotone,fast)
  apply (erule regionsDistinct_antimonotone,fast)
  apply (erule distinctFrom_antimonotone,fast)
  
  apply (erule_tac x=q in allE, erule_tac x=n2 in allE,erule_tac x=FF in allE, erule impE, clarsimp)
  apply (rule_tac x=M in exI, safe)
  apply (erule regEx_Letv, assumption+,simp)
  apply (erule regsDist_Letv, assumption+, simp)
  apply (erule distFr_Letv, assumption+, simp)

  apply (rule SizePreserved_h_h1)
  apply (erule ContextSizePreserved,fastsimp) apply (simp add: modified_def)
  apply (erule_tac x=l in allE, erule impE)
  (*1*) apply rule apply (simp add: distinctFrom_def) apply (subgoal_tac "x:DOM C",fast) apply (erule reg_DOM)
  (*2*) apply (rule, subgoal_tac "l:Dom h", simp add: dom_def) apply(erule reg_region_in_heap1, assumption) 
      apply (simp add: regionsDistinct_def,clarsimp) 
      apply (subgoal_tac "z \<noteq> x")
      apply (subgoal_tac "x:DOM C",fast) apply (erule reg_DOM)
      apply fast
  apply simp
  apply (erule reg.elims, clarsimp+)

  apply (rule_tac x=Ra in exI, rule_tac x=Sa in exI, rule_tac x=Ma in exI, rule_tac x=FFa in exI, safe)
  apply (erule mod_Letv,assumption+,simp) 
  apply (erule Bnd_Letv, assumption+,simp)
  apply (erule Bnd_Letv, assumption+,simp) 
done
lemma DA_letv:
      "\<lbrakk>G \<rhd> e : DAss U1 n C T1 m;
        G \<rhd> ee : DAss U2 m C T2 k; T1 = UnitET;
        U1 \<inter> U2 = {}; UU=(U1 \<union> U2)\<rbrakk>
     \<Longrightarrow> G \<rhd> (LET _ = e IN ee END): DAss UU n C T2 k"
by (rule vdm_conseq, rule DA_Letv, auto)
(*>*)

lemma DA_Leti:
      "\<lbrakk>G \<rhd> e : DAss U1 n C T1 m;
        G \<rhd> ee : DAss U2 m C T2 k;
        U1 \<inter> U2 = {}; T1 = IntET\<rbrakk>
     \<Longrightarrow> G \<rhd> (LET x = e IN ee END): DAss (U1 \<union> U2) n C T2 k"
(*<*)
apply (rule vdm_conseq,erule vdm_leti, assumption)
apply (erule thin_rl, erule thin_rl, clarsimp)
apply (simp add: DAss_def, safe)
apply (subgoal_tac "(\<exists> n1 n2 . (E, h, U1, C, n1) \<in> ContextSize \<and> (E, h, U2, C, n2) \<in> ContextSize \<and> n1 + n2 = CS)", clarsimp)
prefer 2 apply (erule ContextSize_SPLIT, simp, assumption)
apply (erule_tac x="n2+q" in allE, erule_tac x=n1 in allE, erule_tac x=F in allE, erule impE, clarsimp)
apply (rule_tac x=N in exI, clarsimp)
  apply(rotate_tac 1, erule thin_rl,safe)
  apply (erule regionsExist_antimonotone,fast)
  apply (erule regionsDistinct_antimonotone,fast)
  apply (erule distinctFrom_antimonotone,fast)
  
  apply (erule_tac x=q in allE, erule_tac x=n2 in allE,erule_tac x=FF in allE, erule impE, clarsimp)
  apply (rule_tac x=M in exI, safe)
  apply (erule regEx_Letv, assumption+,clarsimp,rule, simp)
  apply (erule regsDist_Letv, assumption+,clarsimp,rule, simp)
  apply (erule distFr_Letv, assumption+,clarsimp,rule, simp)

  apply (rule SizePreserved_h_h1)
  apply (erule ContextSizePreserved,fastsimp) apply (simp add: modified_def)
  apply (erule_tac x=l in allE, erule impE)
  (*1*) apply rule apply (simp add: distinctFrom_def) apply (subgoal_tac "x:DOM C",fast) apply (erule reg_DOM)
  (*2*) apply (rule, subgoal_tac "l:Dom h", simp add: dom_def) apply(erule reg_region_in_heap1, assumption) 
      apply (simp add: regionsDistinct_def,clarsimp) 
      apply (subgoal_tac "z \<noteq> x")
      apply (subgoal_tac "x:DOM C",fast) apply (erule reg_DOM)
      apply fast
  apply simp
  apply (erule reg.elims, clarsimp+)

  apply (rule_tac x=Ra in exI, rule_tac x=Sa in exI, rule_tac x=Ma in exI, rule_tac x=FFa in exI, safe)
  apply (erule mod_Letv,assumption+,safe, (rule, simp)+) 
  apply (erule Bnd_Letv, assumption+,safe, (rule, simp)+)
  apply (erule Bnd_Letv, assumption+,safe, (rule, simp)+) 
done
lemma DA_leti:
      "\<lbrakk>G \<rhd> e : DAss U1 n C T1 m;
        G \<rhd> ee : DAss U2 m C T2 k;
        U1 \<inter> U2 = {}; T1 = IntET; UU=(U1 \<union> U2)\<rbrakk>
     \<Longrightarrow> G \<rhd> (LET x = e IN ee END): DAss UU n C T2 k"
by (rule vdm_conseq, rule DA_Leti, auto)
(*>*)

(*<*)
lemma regEx_Letr:
"\<lbrakk>U1 \<inter> (U2 - {x}) = {}; regionsExist (U1 \<union> (U2 - {x})) C h E; regionsDistinct (U1 \<union> (U2 - {x})) C h E;
          distinctFrom (U1 \<union> (U2 - {x})) C h E F; modified F U1 C h E h1; (RVal r, h1, Some (ListET K), R, S) \<in> reg\<rbrakk>
 \<Longrightarrow> regionsExist U2 (C(x\<mapsto>\<^sub>fListET K)) h1 E\<lfloor>x:=r\<rfloor>"
apply (simp (no_asm) add: regionsExist_def, clarsimp)
apply (case_tac "xa=x",simp add: GETr_def,fast)
apply (subgoal_tac "xa : DOM C")
apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET K)) xa = GETr C xa", clarsimp)
apply (subgoal_tac "\<exists>Rx Sx. (RVal (renv E xa), h, GETr C xa, Rx, Sx) \<in> reg", clarsimp)
apply (rule_tac x=Rx in exI, rule_tac x=Sx in exI)
apply (erule reg_h_h1_letv, assumption+)
apply fast
apply assumption
apply (simp add: regionsExist_def) 
apply (rule GETr_Update1, fast)
apply (insert DOM_Update,fast)
done

lemma regsDist_Letr:
"\<lbrakk>U1 \<inter> (U2 - {x}) = {}; regionsExist (U1 \<union> (U2 - {x})) C h E; regionsDistinct (U1 \<union> (U2 - {x})) C h E;
  distinctFrom (U1 \<union> (U2 - {x})) C h E F; (RVal r, h1, Some (ListET K), R, S) \<in> reg; modified F U1 C h E h1;
  R \<inter> FF = {}; Bounded R F U1 C h E\<rbrakk>
 \<Longrightarrow> regionsDistinct U2 (C(x\<mapsto>\<^sub>fListET K)) h1 E\<lfloor>x:=r\<rfloor>"
apply (simp add: regionsDistinct_def, clarsimp)
apply (subgoal_tac " regionsDistinct (U1 \<union> (U2 - {x})) C h E")
prefer 2 apply (simp add: regionsDistinct_def)
apply (case_tac "xa = x", clarsimp)
(*xa=x*)
  apply (case_tac "xx=x")
  (*xx=x*) apply clarsimp
  (*xx\<noteq>x*) apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET K)) xx = GETr C xx", clarsimp)
    apply (subgoal_tac "xx:DOM C")
    apply (subgoal_tac "R=Rx \<and> S=Sx", clarsimp)
    apply (simp add: Bounded_def, rule, rule)
    apply (subgoal_tac "(RVal (renv E xx), h, GETr C xx, Rxx, Sxx) \<in> reg")
    prefer 2 apply(erule reg_h1_h_letv, assumption+, fast, assumption+)
    apply (erule_tac x=xa in allE, erule impE,clarsimp)
    apply (erule disjE)
    (*1*) apply (rotate_tac 2, erule thin_rl, simp add: distinctFrom_def)
          apply (erule_tac x=xx in allE, erule impE, clarsimp) apply fast
    (*2*) apply clarsimp apply (subgoal_tac "xx \<noteq> xaa")
          apply (erule_tac x=xaa in allE, erule_tac x=xx in allE)
          apply (erule_tac x=Rx in allE, erule_tac x=Rxx in allE, erule impE, clarsimp) apply fast 
          apply fast apply (rotate_tac 2, erule thin_rl, fast)
    apply simp 
    apply (erule reg_Unique) apply (simp add: GETr_def)
    apply (erule DOM_Update1, fast)
    apply (rule GETr_Update1, fast)
(* xa \<noteq> x*)
  apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET K)) xa = GETr C xa", clarsimp)
  apply (subgoal_tac "xa:DOM C")
  apply (case_tac "xx=x")
    (* xx=x*)
    apply clarsimp
    apply (subgoal_tac "R=Rxx \<and> S=Sxx", clarsimp)
    apply (simp add: Bounded_def, rule, rule)
    apply (subgoal_tac "(RVal (renv E xa), h, GETr C xa, Rx, Sx) \<in> reg")
    prefer 2 apply(erule reg_h1_h_letv, assumption+, fast, assumption+)
    apply (erule_tac x=xaa in allE, erule impE,clarsimp)
    apply (erule disjE)
    (*1*) apply (rotate_tac 2, erule thin_rl, simp add: distinctFrom_def)
          apply (erule_tac x=xa in allE, erule impE, clarsimp) apply fast
    (*2*) apply clarsimp apply (subgoal_tac "xa \<noteq> xb")
          apply (erule_tac x=xa in allE, erule_tac x=xb in allE)
          apply (erule_tac x=Rx in allE, erule_tac x=Rxa in allE, erule impE, clarsimp) apply fast 
          apply fast apply (rotate_tac 2, erule thin_rl, fast)
    apply simp 
    apply (erule reg_Unique) apply (simp add: GETr_def)
    (* xx \<noteq> x*)
    apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET K)) xx = GETr C xx", clarsimp)
    apply (subgoal_tac "xx:DOM C")
    apply (erule_tac x=xa in allE, erule_tac x=xx in allE)
    apply (erule_tac x=Rx in allE, erule_tac x=Rxx in allE, erule impE, clarsimp)
    apply (rule, rule) apply (erule  reg_h1_h_letv, assumption+, fast, assumption)
    apply (rule) apply (erule  reg_h1_h_letv, assumption+, fast, assumption)
    apply simp
    apply (erule DOM_Update1, fast)
    apply (rule GETr_Update1, fast)
  apply (erule DOM_Update1, fast)
  apply (rule GETr_Update1, fast)
done

lemma distFrom_Letr:
"\<lbrakk>U1 \<inter> (U2 - {x}) = {};regionsExist (U1 \<union> (U2 - {x})) C h E; regionsDistinct (U1 \<union> (U2 - {x})) C h E;
          distinctFrom (U1 \<union> (U2 - {x})) C h E F; (RVal r, h1, Some (ListET K), R, S) \<in> reg; modified F U1 C h E h1;
          R \<inter> FF = {}; Bounded R F U1 C h E; Bounded FF F U1 C h E\<rbrakk>
       \<Longrightarrow> distinctFrom U2 (C(x\<mapsto>\<^sub>fListET K)) h1 E\<lfloor>x:=r\<rfloor> FF"
apply (simp add: distinctFrom_def, clarsimp)
apply (subgoal_tac "distinctFrom (U1 \<union> (U2 - {x})) C h E F")
prefer 2 apply (simp add: distinctFrom_def)
apply (case_tac "xa=x", clarsimp)
(*xa=x*)
    apply (subgoal_tac "R=Rx \<and> S=Sx", clarsimp)
    apply (erule reg_Unique) apply (simp add: GETr_def)
(*xa\<noteq>x*)
    apply (subgoal_tac "(RVal (renv E xa), h, GETr C xa, Rx, Sx) \<in> reg")
    prefer 2 apply(erule reg_h1_h_letv, assumption+)
             apply (erule DOM_Update1, fast)
             apply fast
             apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET K)) xa = GETr C xa", clarsimp)
             apply (rule GETr_Update1, fast)
    apply (subgoal_tac "\<forall>l. l \<in> FF \<longrightarrow> l \<in> F \<or> (\<exists>x. x \<in> U1 \<and> x \<in> DOM C \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E x), h, GETr C x, Rx, Sx) \<in> reg) \<and> l \<in> Rx))")
    prefer 2 apply (simp add: Bounded_def)
    apply (subgoal_tac "Rx \<inter> (F \<union> {l. \<exists>z. z \<in> U1 \<and> z \<in> DOM C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}) = {}", fast)
    apply (subgoal_tac "Rx \<inter> F = {} \<and>
                        Rx \<inter> {l. \<exists>z. z \<in> U1 \<and> z \<in> DOM C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)} = {}",fast)
    apply rule
    (*1*) apply (erule_tac x=xa in allE, erule impE,clarsimp)
          apply (erule DOM_Update1, fast) apply fast
    (*2*) apply (rule,rule, clarsimp)
          apply (subgoal_tac "xa\<noteq>z")
          apply (simp add: regionsDistinct_def) 
          apply (erule_tac x=xa in allE, erule_tac x=z in allE, erule_tac x=Rx in allE, erule_tac x=Rz in allE, erule impE,clarsimp)
          apply (rule, erule DOM_Update1, fast) apply (rule,fast,fast)
          apply fast
          apply fast
   apply simp
done

lemma mod_Letr:
"\<lbrakk>U1 \<inter> (U2-{x}) = {}; regionsExist (U1 \<union> (U2-{x})) C h E; regionsDistinct (U1 \<union> (U2-{x})) C h E; 
  modified F U1 C h E h1; distinctFrom (U1 \<union> (U2-{x})) C h E F; Bounded FF F U1 C h E;
  modified FF U2 (C(x\<mapsto>\<^sub>fListET K)) h1 E\<lfloor>x:=r\<rfloor> hh; 
  (RVal r, h1, Some (ListET K), R, S) \<in> reg; Bounded R F U1 C h E\<rbrakk>
 \<Longrightarrow> modified F (U1 \<union> (U2-{x})) C h E hh"
apply (simp add: modified_def, clarsimp)
apply (subgoal_tac "modified F U1 C h E h1")
prefer 2 apply (simp add: modified_def)
apply (subgoal_tac "modified FF U2 (C(x\<mapsto>\<^sub>fListET K)) h1 E\<lfloor>x:=r\<rfloor> hh")
prefer 2 apply (simp add: modified_def)
apply (erule_tac x=l in allE, erule impE,clarsimp) apply (rotate_tac -6, erule_tac x=z in allE) apply fast
apply (erule SameOHTransitive)
apply (erule_tac x=l in allE, erule impE) apply rule
apply (subgoal_tac "\<forall>l. l \<in> FF \<longrightarrow> l \<in> F \<or> (\<exists>x. x \<in> U1 \<and> x \<in> DOM C \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E x), h, GETr C x, Rx, Sx) \<in> reg) \<and> l \<in> Rx))")
prefer 2 apply (simp add: Bounded_def)
apply (rotate_tac 5, erule thin_rl)
apply (subgoal_tac "l \<notin> {l. \<exists>z. z \<in> U1 \<and> z \<in> DOM C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}", fast)
apply clarsimp
apply fast
apply (rule, simp add: modified_def) apply (erule_tac x=l in allE, erule impE, fastsimp) apply (simp add: sameOH_def) apply (simp add: fmap_dom_def fmap_lookup_def dom_def) 
  apply clarsimp
apply (case_tac "z = x", clarsimp)
(*z=x*) apply (subgoal_tac "R=Rz \<and> S=Sz", clarsimp)
  apply (simp add: Bounded_def)
  apply (erule_tac x=l in allE, clarsimp)
  apply fast
  apply (erule reg_Unique) apply (simp add: GETr_def)
(* z \<noteq> x*) apply (subgoal_tac "z : DOM C")
  apply (erule_tac x=z in allE, erule_tac x=Rz in allE, erule impE, clarsimp)
  apply (subgoal_tac "(RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg",fast)
  apply (erule reg_h1_h_letv, assumption+)
  apply fast
  apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET K)) z = GETr C z", clarsimp)
  apply (rule GETr_Update1, fast)
  apply fast
  apply (erule DOM_Update1, fast)
apply assumption
apply fast
done

lemma Bnd_Letr:
"\<lbrakk>U1 \<inter> (U2 - {x}) = {};  regionsExist (U1 \<union> (U2 - {x})) C h E; regionsDistinct (U1 \<union> (U2 - {x})) C h E;
          distinctFrom (U1 \<union> (U2 - {x})) C h E F; (RVal r, h1, Some (ListET K), R, S) \<in> reg; modified F U1 C h E h1;
          R \<inter> FF = {}; Bounded R F U1 C h E; Bounded FF F U1 C h E; 
           modified FF U2 (C(x\<mapsto>\<^sub>fListET K)) h1 E\<lfloor>x:=r\<rfloor> hh;
          Bounded Ra FF U2 (C(x\<mapsto>\<^sub>fListET K)) h1 E\<lfloor>x:=r\<rfloor>\<rbrakk>
       \<Longrightarrow> Bounded Ra F (U1 \<union> (U2 - {x})) C h E"
apply (simp add: Bounded_def)
apply (rule, rule)
apply (rotate_tac -2, erule_tac x=l in allE, erule impE,simp, erule disjE)
apply (subgoal_tac "l : F \<union> {l. \<exists>z. z \<in> U1 \<and> z \<in> DOM C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}")
prefer 2 apply fast
apply (subgoal_tac "l : F \<or> l: {l. \<exists>z. z \<in> U1 \<and> z \<in> DOM C \<and> (\<exists>Rz. (\<exists>Sz. (RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg) \<and> l \<in> Rz)}")
prefer 2 apply fast
apply (erule disjE, simp)
apply (subgoal_tac "\<exists>xa. (xa \<in> U1 \<or> xa \<in> U2 \<and> xa \<noteq> x) \<and> xa \<in> DOM C \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E xa), h, GETr C xa, Rx, Sx) \<in> reg) \<and> l \<in> Rx)", simp)
apply clarsimp
apply (rotate_tac 8, erule thin_rl)
apply fast
apply (erule exE, (erule conjE)+)+ apply (erule exE)
apply (case_tac "xa=x")
(*xa=x*)
  apply (subgoal_tac "R=Rx \<and> S=Sx")
  apply (erule_tac x=l in allE, erule impE, clarsimp)
  apply (erule disjE, simp)
  apply (subgoal_tac "\<exists>xa. (xa \<in> U1 \<or> xa \<in> U2 \<and> xa \<noteq> x) \<and> xa \<in> DOM C \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E xa), h, GETr C xa, Rx, Sx) \<in> reg) \<and> l \<in> Rx)", simp)
  apply clarsimp apply fast
  apply (erule reg_Unique) apply (simp add: GETr_def)
(*xa\<noteq>x*)
apply (subgoal_tac "\<exists>xa. (xa \<in> U1 \<or> xa \<in> U2 \<and> xa \<noteq> x) \<and> xa \<in> DOM C \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E xa), h, GETr C xa, Rx, Sx) \<in> reg) \<and> l \<in> Rx)", simp)
apply clarsimp
apply (subgoal_tac "xa : DOM C")
apply (rotate_tac 8, erule thin_rl)
apply (subgoal_tac "(RVal (renv E xa), h, GETr C xa, Rx, Sx) \<in> reg",fast)
apply (erule reg_h1_h_letv, assumption+)
apply fast
apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET K)) xa = GETr C xa", clarsimp)
apply (rule GETr_Update1, fast)
apply (erule DOM_Update1, fast)
done
(*>*)

lemma DA_Letr:
     "\<lbrakk> G \<rhd> e : DAss U1 n C T1 m;
        G \<rhd> ee : DAss U2 m (C(x\<mapsto>\<^sub>fT1)) T2 k;
        U1 \<inter> (U2-{x}) = {}; T1 = ListET K\<rbrakk>
     \<Longrightarrow> G \<rhd> (LET rf x = e IN ee END): DAss (U1 \<union> (U2-{x})) n C T2 k"
(*<*)
apply (rule vdm_conseq,erule vdm_letr, assumption)
apply (erule thin_rl, erule thin_rl, clarsimp)
apply (simp add: DAss_def, safe)
apply (subgoal_tac "(\<exists> n1 n2 . (E, h, U1, C, n1) \<in> ContextSize \<and> (E, h, U2 - {x}, C, n2) \<in> ContextSize \<and> n1 + n2 = CS)", clarsimp)
prefer 2 apply (erule ContextSize_SPLIT, simp, assumption)
apply (erule_tac x="n2+q" in allE, erule_tac x=n1 in allE, erule_tac x=F in allE, erule impE, clarsimp)
apply (rule_tac x=N in exI, clarsimp)
  apply(rotate_tac 1, erule thin_rl,safe)
  apply (erule regionsExist_antimonotone,fast)
  apply (erule regionsDistinct_antimonotone,fast)
  apply (erule distinctFrom_antimonotone,fast)

  apply (case_tac "x:U2")
  (*x:U2*) apply (erule_tac x=q in allE, erule_tac x="n2+S" in allE,erule_tac x=FF in allE, erule impE, clarsimp)
    apply (rule_tac x=M in exI, safe)
      apply (erule regEx_Letr, assumption+)
      apply (erule regsDist_Letr, assumption+)
      apply (erule distFrom_Letr, assumption+)
      apply (erule ContextSizeCONS, simp add: GETr_def) apply (rule SizePreserved_h_h1)
          apply(erule ContextSizePreservedU) apply simp 
          apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET K)) xa = GETr C xa ", simp) apply (rule GETr_Update1,fast)
          apply (simp add: modified_def) apply (subgoal_tac "modified F U1 C h E h1") prefer 2 apply (simp add: modified_def)
            apply (erule_tac x=l in allE, erule impE)
            apply (rule, simp add: distinctFrom_def) apply (erule_tac x=xa in allE, erule impE)
              apply (rule, rule disjI2, simp) apply (rule DOM_Update1) apply (erule reg_DOM,fast) 
              apply (erule_tac x=Ra in allE, erule impE) 
              apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET K)) xa = GETr C xa ", fastsimp) apply (rule GETr_Update1,fast)
            apply fast
          apply (rule, rule reg_region_in_heap1) apply (erule reg_h_h1_letv, assumption+)
            apply (subgoal_tac "xa:DOM C", assumption) apply (subgoal_tac "xa:DOM (C(x\<mapsto>\<^sub>fListET K))", erule DOM_Update1,fast) apply (erule reg_DOM)
            apply fast 
            apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET K)) xa = GETr C xa ", simp) apply (rule GETr_Update1,fast)
            apply assumption
            apply clarsimp apply (simp add: regionsDistinct_def) 
              apply (erule_tac x=xa in allE, erule_tac x=z in allE, erule_tac x=Ra in allE, erule_tac x=Rz in allE, erule impE, clarsimp)
               apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET K)) xa = GETr C xa ",clarsimp)
               apply (rule, erule reg_DOM) 
               apply (rule,fast)
               apply fastsimp
               apply (rule GETr_Update1,fast)
            apply fast apply simp 
        apply simp apply simp
  apply (rule_tac x=Ra in exI, rule_tac x=Sa in exI, rule_tac x=Ma in exI, rule_tac x=FFa in exI, safe)
  apply (rule mod_Letr, auto)
  apply (erule Bnd_Letr, assumption+)
  apply (erule Bnd_Letr, assumption+)

  (*x\<notin>U2*) apply (erule_tac x="S+q" in allE, erule_tac x=n2 in allE,erule_tac x=FF in allE, erule impE, clarsimp)
    apply (rule_tac x=M in exI, safe)
      apply (rule regEx_Letr) apply (subgoal_tac "(U2 - {x}) = U2", clarsimp, assumption,fast) apply (subgoal_tac "(U2 - {x}) = U2", clarsimp,fast)+
      apply (rule regsDist_Letr) apply (subgoal_tac "(U2 - {x}) = U2", clarsimp, assumption,fast) apply (subgoal_tac "(U2 - {x}) = U2", clarsimp,fast)+
      apply (rule distFrom_Letr) apply (subgoal_tac "(U2 - {x}) = U2", clarsimp, assumption,fast) apply (subgoal_tac "(U2 - {x}) = U2", clarsimp,fast)+
      apply (rule SizePreserved_h_h1)
          apply(erule ContextSizePreservedU) apply (subgoal_tac "xa \<noteq> x", fastsimp,fast )
          apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET K)) xa = GETr C xa ", simp) apply (rule GETr_Update1,fast)
          apply (subgoal_tac "xa \<noteq> x") prefer 2 apply fast
          apply (simp add: modified_def) apply (subgoal_tac "modified F U1 C h E h1") prefer 2 apply (simp add: modified_def)
            apply (erule_tac x=l in allE, erule impE)
            apply (rule, simp add: distinctFrom_def) apply (erule_tac x=xa in allE, erule impE)
              apply (rule, rule disjI2, simp) apply (rule DOM_Update1) apply (erule reg_DOM,fast) 
              apply (erule_tac x=Ra in allE, erule impE) 
              apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET K)) xa = GETr C xa ", fastsimp) apply (rule GETr_Update1,fast)
            apply fast
          apply (rule, rule reg_region_in_heap1) apply (erule reg_h_h1_letv, assumption+)
            apply (subgoal_tac "xa:DOM C", assumption) apply (subgoal_tac "xa:DOM (C(x\<mapsto>\<^sub>fListET K))", erule DOM_Update1,fast) apply (erule reg_DOM)
            apply assumption
            apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET K)) xa = GETr C xa ", simp) apply (rule GETr_Update1,fast)
            apply assumption
            apply clarsimp apply (simp add: regionsDistinct_def) 
              apply (erule_tac x=xa in allE, erule_tac x=z in allE, erule_tac x=Ra in allE, erule_tac x=Rz in allE, erule impE, clarsimp)
               apply (subgoal_tac "GETr (C(x\<mapsto>\<^sub>fListET K)) xa = GETr C xa ",clarsimp)
               apply (rule, erule reg_DOM) 
               apply (rule,fast)
               apply fastsimp
               apply (rule GETr_Update1,fast)
            apply fast apply simp 
        apply simp
  apply (rule_tac x=Ra in exI, rule_tac x=Sa in exI, rule_tac x=Ma in exI, rule_tac x=FFa in exI, safe)
  apply (subgoal_tac "modified F (U1 \<union> (U2-{x})) C h E hh",fastsimp)
  apply (rule mod_Letr,fast) apply (subgoal_tac "(U2 - {x}) = U2", clarsimp,fast)
       apply (subgoal_tac "(U2 - {x}) = U2", clarsimp,fast) apply assumption
       apply (subgoal_tac "(U2 - {x}) = U2", clarsimp,fast) prefer 2 apply assumption+
  apply (subgoal_tac "Bounded Ra F (U1 \<union> (U2-{x})) C h E",fastsimp) 
    apply(rule Bnd_Letr,fast) apply (subgoal_tac "(U2 - {x}) = U2", clarsimp,fast)
       apply (subgoal_tac "(U2 - {x}) = U2", clarsimp,fast)
       apply (subgoal_tac "(U2 - {x}) = U2", clarsimp,fast) prefer 2 apply assumption+
  apply (subgoal_tac "Bounded FFa F (U1 \<union> (U2-{x})) C h E",fastsimp) 
    apply(rule Bnd_Letr,fast) apply (subgoal_tac "(U2 - {x}) = U2", clarsimp,fast)
       apply (subgoal_tac "(U2 - {x}) = U2", clarsimp,fast)
       apply (subgoal_tac "(U2 - {x}) = U2", clarsimp,fast) prefer 2 apply assumption+
apply simp
done
lemma DA_letr:
     "\<lbrakk> G \<rhd> e : DAss U1 n C T1 m;
        G \<rhd> ee : DAss U2 m (C(x\<mapsto>\<^sub>fT1)) T2 k;
        U1 \<inter> (U2-{x}) = {}; T1 = ListET K;UU=(U1 \<union> (U2-{x}))\<rbrakk>
     \<Longrightarrow> G \<rhd> (LET rf x = e IN ee END): DAss UU n C T2 k"
by (rule vdm_conseq, rule DA_Letr, auto)
(*>*)

lemma DA_If: 
     "\<lbrakk> G \<rhd> e1 : DAss U1 n C T m; 
        G \<rhd> e2 : DAss U2 n C T m\<rbrakk>
     \<Longrightarrow> G \<rhd> (IF b THEN e1 ELSE e2): DAss (U1 \<union> U2) n C T m"
(*<*)
apply (rule vdm_conseq, erule vdm_if, assumption, erule thin_rl, erule thin_rl, safe)
apply (rule DAss_PConst)
apply (erule DAss_monotone_in_U,fast)
apply clarsimp 
apply (rule DAss_PConst)
apply (erule DAss_monotone_in_U,fast)
apply (rule DAss_PConst)
apply (erule DAss_monotone_in_U,fast)
apply clarsimp 
apply (rule DAss_PConst)
apply (erule DAss_monotone_in_U,fast)
done
lemma DA_if: 
     "\<lbrakk> G \<rhd> e1 : DAss U1 n C T m; 
        G \<rhd> e2 : DAss U2 n C T m;UU=(U1 \<union> U2)\<rbrakk>
     \<Longrightarrow> G \<rhd> (IF b THEN e1 ELSE e2): DAss UU n C T m"
by (rule vdm_conseq, rule DA_If, auto)
(*>*)

lemma DA_Call0:
"\<lbrakk>(G \<union> {(CALL f, \<lambda> E h hh v p . \<exists> pp. tkcall pp = p \<and> DAss U n C T m E h hh v pp)}) \<rhd> (funtable f) : DAss U n C T m\<rbrakk> \<Longrightarrow>
           G \<rhd> (CALL f) : DAss U n C T m"
(*<*)
apply (rule vdm_conseq)
apply (erule Call1)
apply clarsimp
apply (erule DAss_PConst) 
done
(*>*)

lemma DA_Call:
"\<lbrakk>(G \<union> {(CALL f, DAss U n C T m)}) \<rhd> (funtable f) : DAss U n C T m\<rbrakk> \<Longrightarrow>
           G \<rhd> (CALL f) : DAss U n C T m"
(*<*)
apply (rule vdm_conseq)
apply (rule vdm_call)
apply (rule vdm_conseq)
apply (subgoal_tac "(G \<union> {(CALL f, DAss U n C T m)}) = ({(CALL f, \<lambda>u ua ub uc ud. DAss U n C T m u ua ub uc ud)} \<union> G)",clarsimp)
apply assumption
apply simp
apply clarsimp apply (erule DAss_PConst)
apply clarsimp 
done
(*>*)

lemma DA_Call2:
"\<lbrakk>G \<rhd> (funtable f) : DAss U n C T m\<rbrakk> \<Longrightarrow> G \<rhd> (CALL f) : DAss U n C T m"
(*<*)
apply (rule vdm_call)
apply (subgoal_tac "(G \<union> {(CALL f, ?P)}) \<rhd>  funtable f : (\<lambda>E h hh v p. ?P E h hh v (tkcall p)) ", simp)
apply (rule CtxtWeak)
apply (erule vdm_conseq)
apply clarsimp
apply (erule DAss_PConst)
done
(*>*)

lemma Cut2Call:"\<lbrakk>(D \<union> {(Call f, Q)}) \<rhd> e : P; finite D; contextProvable (D \<union> {(Call f,Q)}) D\<rbrakk> \<Longrightarrow> D \<rhd> e : P"
(*<*)
apply (rule cut2) prefer 2 apply assumption apply fast+
done
(*>*)

lemma DA_Invs:
"\<lbrakk>({(c\<bullet>mn(args),DAss U n C T m)} \<union> G) \<rhd> (snd (methtable c mn)) :  
    (\<lambda> E h hh v p  . \<forall> E'. E = newframe_env ((fst (methtable c mn)) @ [RNpar self]) (args @ [VALarg (RVal Nullref)]) (E')  \<longrightarrow> 
                     (DAss U n C T m E' h hh v (\<langle>3 0 1 1\<rangle> \<oplus> p) )) \<rbrakk> \<Longrightarrow>
   G \<rhd> (c\<bullet>mn(args)) : DAss U n C T m" 
(*<*)
by (rule vdm_conseq, erule vdm_invokestatic, clarsimp)
(*>*)

lemma DA_Free: "\<lbrakk>GETr C x = Some T; T=(ListET k);m=n+1\<rbrakk> \<Longrightarrow> G \<rhd> (DIAM\<bullet>Free ([RNarg x])) :  DAss {x} n C UnitET m"
(*<*)
apply (rule vdm_invokestatic)
apply (simp add: Meth_Free) 
apply (rule vdm_conseq) 
apply (rule vdm_letr) apply (rule vdm_getstat)
apply (rule vdm_letv) apply (rule vdm_putfr)
apply (rule vdm_putstat)
apply (subgoal_tac "x: DOM C")
prefer 2 apply (erule GETrSome_DOM)
apply (simp add: DAss_def, clarsimp)
apply (subgoal_tac "E'\<lfloor>x\<rfloor> = Ref a")
prefer 2 apply (simp add: newframe_env_def evalARGS_def self_def)
apply (rule_tac x="{}" in exI, rule_tac x=0 in exI)
apply (rule_tac x="Suc N" in exI, rule_tac x="F \<union> {a}" in exI, safe)
apply (subgoal_tac "a \<notin> F")
prefer 2 apply (simp add: distinctFrom_def) apply (simp add: regionsExist_def, clarsimp)
  apply (erule_tac x=Rx in allE, erule impE, fast)
  apply (subgoal_tac "a:Rx", fast) apply (erule Ref_reg)
apply (simp add: freelist_def)
  apply (subgoal_tac "(Suc N, Ref a, F \<union> {a}, h
           \<lparr>rheap := (rheap h)(DOLLAR_N := (rheap h DOLLAR_N)(a := h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>)),
              sheap := (sheap h)(DIAM := (sheap h DIAM)(DOLLAR_F := Ref a))\<rparr>)
          \<in> FL", simp)
  apply (rule FL_SUC)
  apply simp apply (simp add: regionsExist_def, clarsimp)
             apply (erule reg.elims, simp_all, clarsimp)
             apply (simp add: newframe_env_def evalARGS_def self_def) 
             apply (erule mLIST.elims, simp_all) 
  apply (erule FL_UpdateOutside) apply assumption apply (rule regUnit)
apply (simp add: modified_def, clarsimp)
  apply (simp add: sameOH_def)
  apply (simp add: regionsExist_def, clarsimp)
  apply (erule_tac x=Rx in allE, erule impE, fast)
  apply (subgoal_tac "a: Rx", fast) apply (erule Ref_reg)
apply (simp add: Bounded_def)
apply (simp add: Bounded_def)
  apply (rule disjI2)
  apply (simp add: regionsExist_def, clarsimp)
  apply (rule_tac x=Rx in exI, rule, fast)
  apply (erule Ref_reg)
done
lemma DA_free: "\<lbrakk>GETr C x = Some T; T=(ListET k);U={x};m=n+1\<rbrakk> \<Longrightarrow> G \<rhd> (DIAM\<bullet>Free ([RNarg x])) :  DAss U n C UnitET m"
by (rule vdm_conseq,rule DA_Free, auto)
(*>*)

lemma DA_ListMatch: 
  "\<lbrakk>GETr C l = Some (ListET k); nk = n+k; 
    G \<rhd> e : DAss U nk (C(t\<mapsto>\<^sub>f(ListET k))) T m;
    l \<notin> U - {t}\<rbrakk>
 \<Longrightarrow> G \<rhd> (LET h = GetFi l F0; rf t = GetFr l F1 IN e END) : DAss ((U-{t}) \<union> {l}) n C T m"
(*<*)
apply (rule vdm_conseq)
apply (rule vdm_leti, rule vdm_getfi)
apply (rule DA_Let_TL,assumption+)
apply (rotate_tac 2, erule thin_rl, clarsimp)
apply (rule DAss_PConst)
apply (simp add: DAss_def, safe)
(*case l \<noteq> t*)
apply (erule_tac x=q in allE, erule_tac x=CS in allE, erule_tac x=F in allE, erule impE, clarsimp)
apply (rule_tac x=N in exI, safe)
apply (rule regionsExist1) apply (erule regionsExist_antimonotone) apply(fast, fast, simp, rule, simp)
apply (rule regionsDistinct1, erule regionsDistinct_antimonotone)  apply(fast, fast, simp, rule, simp)
apply (rule distinctFrom1, erule distinctFrom_antimonotone) apply(fast, fast, simp, rule, simp)
apply (erule ContextSizePreserved,simp) 
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (rule modified1)  apply(erule modified_monotone) apply(fast, fast, simp, rule, simp)
apply (rule Bounded1) apply(erule Bounded_monotone) apply(simp, simp, fast, fast, rule, simp)
apply (rule Bounded1) apply (rotate_tac -3) apply(erule Bounded_monotone) apply(simp, simp, fast, fast, rule, simp)
(*case l = t*)
apply (erule_tac x=q in allE, erule_tac x=CS in allE, erule_tac x=F in allE, erule impE, clarsimp)
apply (rule_tac x=N in exI, safe)
apply (erule regionsExist1) apply clarsimp+ apply (rule, simp)
apply (erule regionsDistinct1) apply clarsimp+ apply (rule, simp)
apply (erule distinctFrom1) apply clarsimp+ apply (rule, simp)
apply (erule ContextSizePreserved,simp) 
apply (rule_tac x=R in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)
apply (erule modified1) apply clarsimp+ apply (rule, simp) 
apply (erule Bounded1) apply clarsimp+ apply (rule, simp)
apply (erule Bounded1) apply clarsimp+ apply (rule, simp)
done
(*>*)

lemma DA_ListMatchD: 
  "\<lbrakk>GETr C l = Some (ListET k); nk = n+k+1; 
    G \<rhd> e : DAss U nk (C(t\<mapsto>\<^sub>f(ListET k))) T m;
    l \<notin> U; l \<noteq> t\<rbrakk>
 \<Longrightarrow> G \<rhd> (LET h = GetFi l F0; rf t = GetFr l F1; _ = DIAM\<bullet>Free ([RNarg l]) IN e END) : DAss ((U-{t}) \<union> {l}) n C T m"
(*<*)
apply (rule vdm_conseq)
apply (rule vdm_leti, rule vdm_getfi)
apply (rule vdm_letr, rule vdm_getfr)
apply (rule vdm_letv)
prefer 2 apply assumption
apply (subgoal_tac "G \<rhd>  (DIAM\<bullet>Free([RNarg l])) : (\<lambda> E h hh v p . \<exists> a . E\<lfloor>l\<rfloor> = Ref a \<and>
                                                                          hh = h\<lparr>rheap := (rheap h)(DOLLAR_N := (rheap h DOLLAR_N)(a := h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>)),
                                                                             sheap := (sheap h)(DIAM := (sheap h DIAM)(DOLLAR_F := Ref a))\<rparr> \<and> 
                                                                          v = arbitrary \<and> p = (mkRescomp 12 0 1 (Suc 0)))", assumption)
apply (rule vdm_invokestatic)
apply (simp, rule CtxtWeakSingleton)
apply (simp add: Meth_Free) 
apply (rule vdm_conseq) 
apply (rule vdm_letr) apply (rule vdm_getstat)
apply (rule vdm_letv) apply (rule vdm_putfr)
apply (rule vdm_putstat)
apply clarsimp
apply (simp add: self_def newframe_env_def evalARGS_def)

apply clarsimp apply (rule DAss_PConst) 
  apply (rotate_tac 1, erule thin_rl)
  apply (subgoal_tac "l: DOM C")
  prefer 2 apply (erule GETrSome_DOM)
  apply (simp add: DAss_def, safe)  
  apply (subgoal_tac "a \<notin> F")
  prefer 2  apply (rotate_tac 2, erule thin_rl) apply (simp add: distinctFrom_def) apply (erule_tac x=l in allE, erule impE, clarsimp)
                      apply (simp add: regionsExist_def) apply (erule_tac x=l in allE, erule impE, clarsimp)
                      apply clarsimp apply (erule_tac x=Rx in allE, erule impE,fast) 
                      apply (subgoal_tac "a:Rx", fast) apply(erule  Ref_reg)
(*  apply (subgoal_tac "\<exists> R S . (RVal (Ref a), ha, Some (ListET k),R,S):reg") 
  prefer 2 apply (rotate_tac 2, erule thin_rl,simp add: regionsExist_def) apply fastsimp*)
  apply (subgoal_tac "\<exists> n1 n2 . (E, ha, {l}, C, n1) \<in> ContextSize \<and> (E, ha, U-{t}, C, n2) \<in> ContextSize \<and> n1 + n2 = CS", clarsimp)
  prefer 2 apply (rotate_tac 2, erule thin_rl, erule ContextSize_SPLIT,fast,fast)
  apply (rotate_tac -2, erule ContextSize.elims) apply clarsimp apply clarsimp
  apply (rotate_tac -1, erule ContextSize.elims) apply clarsimp prefer 2 apply clarify
  apply (subgoal_tac "(RVal (ha\<lfloor>a\<diamondsuit>F1\<rfloor>),ha,Some(ListET k), R-{a},na-k):reg")
  prefer 2 apply (erule reg_F1)
  apply (subgoal_tac "freelist
                         (ha\<lparr>rheap := (rheap ha)(DOLLAR_N := (rheap ha DOLLAR_N)(a := ha\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>)),
                               sheap := (sheap ha)(DIAM := (sheap ha DIAM)(DOLLAR_F := Ref a))\<rparr>)
                         (F \<union> {a}) (Suc N) \<and>
                        regionsExist U (C(t\<mapsto>\<^sub>fListET k))
                         (ha\<lparr>rheap := (rheap ha)(DOLLAR_N := (rheap ha DOLLAR_N)(a := ha\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>)),
                               sheap := (sheap ha)(DIAM := (sheap ha DIAM)(DOLLAR_F := Ref a))\<rparr>)
                         E<h:=ha<a\<bullet>F0>>\<lfloor>t:=ha\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor> \<and>
                        regionsDistinct U (C(t\<mapsto>\<^sub>fListET k))
                         (ha\<lparr>rheap := (rheap ha)(DOLLAR_N := (rheap ha DOLLAR_N)(a := ha\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>)),
                               sheap := (sheap ha)(DIAM := (sheap ha DIAM)(DOLLAR_F := Ref a))\<rparr>)
                         E<h:=ha<a\<bullet>F0>>\<lfloor>t:=ha\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor> \<and>
                        distinctFrom U (C(t\<mapsto>\<^sub>fListET k))
                         (ha\<lparr>rheap := (rheap ha)(DOLLAR_N := (rheap ha DOLLAR_N)(a := ha\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>)),
                               sheap := (sheap ha)(DIAM := (sheap ha DIAM)(DOLLAR_F := Ref a))\<rparr>)
                         E<h:=ha<a\<bullet>F0>>\<lfloor>t:=ha\<lfloor>a\<diamondsuit>F1\<rfloor>\<rfloor> (F \<union> {a})")
  prefer 2  apply (rotate_tac 3, erule thin_rl, safe)
      apply (simp add: freelist_def) 
        apply (subgoal_tac "(Suc N, Ref a, F \<union> {a}, 
                             h\<lparr>rheap := (rheap h)(DOLLAR_N := (rheap h DOLLAR_N)(a := h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>)), 
                               sheap := (sheap h)(DIAM := (sheap h DIAM)(DOLLAR_F := Ref a))\<rparr>) \<in> FL", simp) 
        apply(rule FL_SUC) apply simp
             apply (erule reg.elims, simp_all)
             apply (erule mLIST.elims, simp_all) 
             apply (erule FL_UpdateOutside) apply assumption
        apply (simp add: regionsExist_def, clarsimp)
             apply (case_tac "x=t")
             (*x=t*) apply (rule, rule, rule reg_Preserved) apply (simp add: GETr_def) 
                     apply clarsimp apply (simp add: sameOH_def)
             (*x \<noteq> t*) apply (subgoal_tac "x:DOM C") prefer 2 apply (simp add: DOM_def) 
                        apply clarsimp apply (erule_tac x=x in allE, clarsimp) 
                        apply (subgoal_tac "GETr (C(t\<mapsto>\<^sub>fListET k)) x = GETr C x", clarsimp) apply (rule, rule, rule reg_Preserved, assumption) 
                        apply clarsimp apply (subgoal_tac "la \<noteq> a", simp add: sameOH_def) 
                        apply (subgoal_tac "R \<inter> Rx = {}")
                        apply (subgoal_tac "a:R", fast) apply (erule Ref_reg)
                        apply (simp add: regionsDistinct_def) 
                         apply (erule_tac x=l in allE, erule_tac x=x in allE, erule_tac x=R in allE, erule_tac x=Rx in allE, erule impE, clarsimp) 
                         apply (rule, fast) apply fastsimp apply simp apply (rule GETr_Update1,fast)
        apply (simp add: regionsDistinct_def, clarsimp)
             apply (subgoal_tac "a:R") prefer 2 apply (erule Ref_reg)
             apply (case_tac "x=t")
             (*x=t*) apply clarsimp apply (subgoal_tac "xx: DOM C") prefer 2 apply (simp add: DOM_def,fast) 
                     apply (subgoal_tac "GETr (C(t\<mapsto>\<^sub>fListET k)) xx = GETr C xx", clarsimp) prefer 2 apply (rule GETr_Update1,fast)
                     apply (subgoal_tac "\<exists> RR SS . (RVal (renv E xx), h, GETr C xx, RR, SS) \<in> reg ", clarsimp)
                     prefer 2 apply (simp add: regionsExist_def) apply (erule_tac x=xx in allE, erule impE, fastsimp) apply assumption
                     apply (subgoal_tac "Rxx=RR \<and> Sxx=SS", clarsimp)
                     prefer 2 apply (erule reg_Unique) apply (rule reg_Preserved, assumption)
                              apply clarsimp apply (subgoal_tac "la \<noteq> a", simp add: sameOH_def)
                              apply (erule_tac x=l in allE, erule_tac x=xx in allE, erule_tac x=R in allE, erule_tac x=RR in allE, erule impE, clarsimp) 
                              apply (rule, rule disjI2,fast) apply(rule, fast) apply (rule, fast) apply fast
                              apply fast
                     apply (erule_tac x=l in allE, erule_tac x=xx in allE, erule_tac x=R in allE, erule_tac x=RR in allE, erule impE, clarsimp) 
                       apply (rule, rule disjI2,fast) apply(rule, fast) apply (rule, fast) apply fast
                       apply (subgoal_tac "Rx \<subseteq> R", fast)
                       apply (subgoal_tac "Rx = R-{a} \<and> Sx = na-k", fast)
                       apply (erule reg_Unique) apply (rule reg_Preserved) apply (simp add: GETr_def) apply clarsimp apply (simp add: sameOH_def)
             (*x\<noteq>t*) apply clarsimp apply (subgoal_tac "x: DOM C") prefer 2 apply (simp add: DOM_def) 
                     apply (subgoal_tac "GETr (C(t\<mapsto>\<^sub>fListET k)) x = GETr C x", clarsimp) prefer 2 apply (rule GETr_Update1,fast)
                     apply (subgoal_tac "\<exists> RR SS . (RVal (renv E x), ha, GETr C x, RR, SS) \<in> reg ", clarsimp)
                     prefer 2 apply (simp add: regionsExist_def) 
                     apply (subgoal_tac "Rx=RR \<and> Sx=SS", clarsimp)
                     prefer 2 apply (erule reg_Unique) apply (rule reg_Preserved, assumption)
                              apply clarsimp apply (subgoal_tac "la \<noteq> a", simp add: sameOH_def)
                              apply (erule_tac x=l in allE, erule_tac x=x in allE, erule_tac x=R in allE, erule_tac x=RR in allE, erule impE, clarsimp) 
                              apply(rule, fast) apply (rule, fast) apply fast
                              apply fast
                     apply (case_tac "xx=t")
                     (*xx=t*) apply clarsimp 
                       apply (erule_tac x=l in allE, erule_tac x=x in allE, erule_tac x=R in allE, erule_tac x=RR in allE, erule impE, clarsimp) 
                       apply(rule, fast) apply (rule, fast) apply fast
                       apply (subgoal_tac "Rxx \<subseteq> R", fast)
                       apply (subgoal_tac "Rxx = R-{a} \<and> Sxx = na-k", fast)
                       apply (erule reg_Unique) apply (rule reg_Preserved) apply (simp add: GETr_def) apply clarsimp apply (simp add: sameOH_def)
                     (*x\<noteq>t*) apply clarsimp
                       apply (subgoal_tac "xx:DOM C") prefer 2 apply (simp add: DOM_def)
                       apply (subgoal_tac "\<exists> RRR SSS . (RVal (renv E xx), h, GETr C xx, RRR, SSS) \<in> reg", clarsimp)
                       prefer 2 apply (simp add: regionsExist_def) 
                       apply (subgoal_tac "GETr (C(t\<mapsto>\<^sub>fListET k)) xx = GETr C xx", clarsimp) prefer 2 apply (rule GETr_Update1,fast)
                       apply (subgoal_tac "Rxx=RRR \<and> Sxx=SSS", clarsimp) 
                       apply (erule_tac x=x in allE, erule_tac x=xx in allE, erule_tac x=RR in allE, erule_tac x=RRR in allE, erule impE, fastsimp)
                          apply assumption
                       apply (erule reg_Unique) apply (rule reg_Preserved, assumption) apply clarsimp apply (subgoal_tac "la \<noteq> a", simp add: sameOH_def)    
                       apply (erule_tac x=l in allE, erule_tac x=xx in allE, erule_tac x=R in allE, erule_tac x=RRR in allE, erule impE, fastsimp)
                         apply fast
        apply (simp add: distinctFrom_def, clarsimp)
             apply (subgoal_tac "a:R") prefer 2 apply (erule Ref_reg)
             apply (case_tac "x=t")
             (*x=t*) apply clarsimp 
                     apply (simp add: GETr_def)
                     apply (subgoal_tac "Rx=R-{a} \<and> Sx=na-k", clarsimp)
                     prefer 2 apply (erule reg_Unique) apply (rule reg_Preserved, assumption)
                              apply clarsimp apply (simp add: sameOH_def)
                     apply (erule_tac x=l in allE, clarsimp) apply fast
             (*x\<noteq>t*) apply clarsimp apply (subgoal_tac "GETr (C(t\<mapsto>\<^sub>fListET k)) x = GETr C x", clarsimp) prefer 2 apply (rule GETr_Update1,fast) 
                     apply (subgoal_tac "x:DOM C") prefer 2 apply (simp add: DOM_def)
                     apply (subgoal_tac "\<exists> RRR SSS . (RVal (renv E x), h, GETr C x, RRR, SSS) \<in> reg", clarsimp)
                     prefer 2 apply (simp add: regionsExist_def) 
                     apply (subgoal_tac "R \<inter> RRR = {}")
                     prefer 2 apply (simp add: regionsDistinct_def) 
                              apply (erule_tac x=l in allE, erule_tac x=x in allE, erule_tac x=R in allE, erule_tac x=RRR in allE,erule impE,clarsimp,fastsimp)
                              apply assumption
                     apply (subgoal_tac "Rx=RRR \<and> Sx=SSS", fastsimp)
                     apply (erule reg_Unique) apply (rule reg_Preserved, assumption)
                       apply clarsimp apply (subgoal_tac "la \<noteq> a", simp add: sameOH_def) apply fast
  apply (case_tac "t:U")
  (*t:U*) 
    apply (subgoal_tac "k \<le> na") prefer 2 apply (rotate_tac -5, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, rotate_tac 4, erule thin_rl) 
                                           apply (erule reg.elims, clarsimp) apply (erule mLIST.elims, clarsimp+)
    apply (erule_tac x=q in allE, erule_tac x="n2+na-k" in allE, erule_tac x="F \<union> {a}"in allE, erule impE, clarsimp)
    apply (rule_tac x="Suc N" in exI, safe)
    apply (rotate_tac -6, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl) 
    apply (erule ContextSizeCONS) apply (simp add: GETr_def) apply (erule reg_Preserved) apply (clarsimp, simp add: sameOH_def)
      apply (rule ContextSizePreservedU) apply (erule SizePreserved_h_h1) apply (subgoal_tac "la \<noteq> a", simp add: sameOH_def)
        apply(simp add: regionsDistinct_def)
        apply (erule_tac x=l in allE, erule_tac x=x in allE, erule_tac x=R in allE, erule_tac x=Ra in allE, erule impE, clarsimp)
        apply (rule, erule reg_DOM) apply fastsimp apply (subgoal_tac "a:R", fast) apply (erule Ref_reg)
      apply simp
      apply (subgoal_tac "GETr (C(t\<mapsto>\<^sub>fListET k)) x = GETr C x", simp) apply (rule GETr_Update1, fast)
      apply arith
    apply simp
  apply (rule_tac x=Ra in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)  
    apply (simp add: modified_def, clarsimp)
   apply (erule_tac x=la in allE, erule impE,clarsimp) 
     apply rule apply (erule_tac x=l in allE, erule_tac x=R in allE, clarsimp) apply (subgoal_tac "a:R",fast) apply (erule Ref_reg) 
     apply clarsimp apply (case_tac "z=t")
                    (*z=t*) apply clarsimp apply (subgoal_tac "la \<notin> R") prefer 2 apply (erule_tac x=l in allE, erule_tac x=R in allE, erule impE,fastsimp) 
                            apply assumption
                            apply (subgoal_tac "Rz=R-{a} \<and> Sz = na-k", fast)
                            apply (erule reg_Unique) apply (rule reg_Preserved) apply (simp add: GETr_def)
                            apply clarsimp apply (simp add: sameOH_def)
                    (*z\<noteq>t*) apply clarsimp apply (subgoal_tac "z:DOM C") prefer 2 apply (simp add: DOM_def)
                             apply (subgoal_tac "\<exists> RR SS . (RVal (renv E z), ha, GETr C z,RR,SS):reg", clarsimp) 
                             prefer 2 apply (simp add: regionsExist_def) 
                             apply (subgoal_tac "la \<notin> RR") prefer 2 apply (erule_tac x=z in allE, erule_tac x=RR in allE, fastsimp)
                             apply (subgoal_tac "GETr (C(t\<mapsto>\<^sub>fListET k)) z = GETr C z",clarsimp) prefer 2 apply (rule GETr_Update1,fast)
                             apply (rotate_tac 15) apply( erule thin_rl , erule thin_rl , erule thin_rl , erule thin_rl , erule thin_rl,
                                                             erule thin_rl, erule thin_rl , erule thin_rl)
                             apply (subgoal_tac "Rz=RR \<and> Sz = SS", fast)
                             apply (rule reg_Unique, assumption) apply (rule reg_Preserved, assumption) 
                             apply (rotate_tac 1, erule thin_rl, erule thin_rl)
                             apply clarsimp apply (subgoal_tac "laa \<noteq> a", simp add: sameOH_def) 
                                 apply (subgoal_tac "a:R") prefer 2 apply (erule Ref_reg)
                                 apply (rotate_tac 2, erule thin_rl)
                                 apply (simp add: regionsDistinct_def)
                                 apply (erule_tac x=l in allE, erule_tac x=z in allE, erule_tac x=R in allE, erule_tac x=RR in allE,erule impE,clarsimp, fast)
                                 apply fast
                             apply (rotate_tac 15) apply( erule thin_rl , erule thin_rl , erule thin_rl , erule thin_rl , erule thin_rl,
                                                             erule thin_rl, erule thin_rl , erule thin_rl)
                             apply (subgoal_tac "la \<noteq> a", simp add: sameOH_def, safe)
                             apply (erule_tac x=rfield in allE) apply (case_tac "rfield = DOLLAR_N", clarsimp, clarsimp)
                             apply (subgoal_tac "a \<notin> R")
                             apply (subgoal_tac "a : R",fast) apply (erule Ref_reg)
                             apply (erule_tac x=l in allE, erule_tac x=R in allE, erule impE, clarsimp) apply fast apply assumption
    apply (simp add: Bounded_def,rule, rule) apply (erule_tac x=la in allE, erule impE, simp) 
     apply (erule disjE) apply (rotate_tac -5, erule thin_rl) apply (rule disjI2) 
       apply (rule_tac x=l in exI, simp)
       apply (rule_tac x=R in exI, rule, rule_tac x=na in exI, assumption) apply (erule Ref_reg)
     apply (erule disjE,simp)
     apply (rule disjI2)
     apply clarsimp
     apply (case_tac "x=t")
     (*x=t*) apply (rotate_tac -9, erule thin_rl) apply (rotate_tac -10) apply(erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl) 
             apply clarsimp apply (rule_tac x=l in exI, clarsimp)  
             apply (rule_tac x=R in exI, rule, fast)   
             apply (subgoal_tac "Rx=R-{a} \<and> Sx = na-k", fast)
             apply (erule reg_Unique) apply (rule reg_Preserved) apply (simp add: GETr_def)
             apply clarsimp apply (simp add: sameOH_def)
     (*x\<noteq>t*) apply (rotate_tac -9, erule thin_rl) apply (rotate_tac -10) apply(erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl) 
             apply clarsimp apply (subgoal_tac "x:DOM C") prefer 2 apply (simp add: DOM_def)
             apply (subgoal_tac "\<exists> RR SS . (RVal (renv E x), ha, GETr C x,RR,SS):reg", clarsimp) 
             prefer 2 apply (simp add: regionsExist_def)
             apply (subgoal_tac "GETr (C(t\<mapsto>\<^sub>fListET k)) x = GETr C x",clarsimp) prefer 2 apply (rule GETr_Update1,fast)
             apply (subgoal_tac "Rx=RR \<and> Sx = SS", fast)
             apply (erule reg_Unique) apply (rule reg_Preserved, assumption) 
             apply clarsimp apply (subgoal_tac "laa \<noteq> a", simp add: sameOH_def) 
             apply (subgoal_tac "a:R") prefer 2 apply (erule Ref_reg)
             apply (simp add: regionsDistinct_def)
             apply (erule_tac x=l in allE, erule_tac x=x in allE, erule_tac x=R in allE, erule_tac x=RR in allE,erule impE,clarsimp, fast)
             apply fast
    apply (simp add: Bounded_def,rule, rule) apply (rotate_tac -5, erule thin_rl)
      apply (rotate_tac -10, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl) 
      apply (erule_tac x=la in allE, erule impE, simp) 
      apply (erule disjE) apply (rule disjI2) 
        apply (rule_tac x=l in exI, simp, rule_tac x=R in exI, rule, rule_tac x=na in exI, assumption) apply (erule Ref_reg)
      apply (erule disjE,simp)
      apply (rule disjI2)
      apply clarsimp
      apply (case_tac "x=t")
      (*x=t*) apply clarsimp apply (rule_tac x=l in exI, clarsimp)  
              apply (rule_tac x=R in exI, rule, fast)   
              apply (subgoal_tac "Rx=R-{a} \<and> Sx = na-k", fast)
              apply (erule reg_Unique) apply (rule reg_Preserved) apply (simp add: GETr_def)
              apply clarsimp apply (simp add: sameOH_def)
     (*x\<noteq>t*) apply clarsimp apply (subgoal_tac "x:DOM C") prefer 2 apply (simp add: DOM_def)
             apply (subgoal_tac "\<exists> RR SS . (RVal (renv E x), ha, GETr C x,RR,SS):reg", clarsimp) 
             prefer 2 apply (simp add: regionsExist_def)
             apply (subgoal_tac "GETr (C(t\<mapsto>\<^sub>fListET k)) x = GETr C x",clarsimp) prefer 2 apply (rule GETr_Update1,fast)
             apply (subgoal_tac "Rx=RR \<and> Sx = SS", fast)
             apply (erule reg_Unique) apply (rule reg_Preserved, assumption) 
             apply clarsimp apply (subgoal_tac "laa \<noteq> a", simp add: sameOH_def) 
             apply (subgoal_tac "a:R") prefer 2 apply (erule Ref_reg)
             apply (simp add: regionsDistinct_def)
             apply (erule_tac x=l in allE, erule_tac x=x in allE, erule_tac x=R in allE, erule_tac x=RR in allE,erule impE,clarsimp, fast)
             apply fast
  (*t\<notin>U*) 
    apply (subgoal_tac "k \<le> na") prefer 2 apply (rotate_tac -5, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, rotate_tac 4, erule thin_rl) 
                                           apply (erule reg.elims, clarsimp) apply (erule mLIST.elims, clarsimp+)
    apply (erule_tac x=q in allE, erule_tac x=n2 in allE, erule_tac x="F \<union> {a}"in allE, erule impE, clarsimp)
    apply (rule_tac x="Suc N" in exI, safe)
    apply (rotate_tac -5, erule thin_rl, erule thin_rl, erule thin_rl) 
      apply (rule ContextSizePreservedU) apply (erule SizePreserved_h_h1) apply (subgoal_tac "la \<noteq> a", simp add: sameOH_def)
        apply(simp add: regionsDistinct_def)
        apply (erule_tac x=l in allE, erule_tac x=x in allE, erule_tac x=R in allE, erule_tac x=Ra in allE, erule impE, clarsimp)
        apply (rule, erule reg_DOM) apply fastsimp apply (subgoal_tac "a:R", fast) apply (erule Ref_reg)
      apply (subgoal_tac "x\<noteq> t",simp,fast)
      apply (subgoal_tac "GETr (C(t\<mapsto>\<^sub>fListET k)) x = GETr C x", simp) apply (rule GETr_Update1, fast)
      apply arith
  apply (rule_tac x=Ra in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, safe)  
    apply (simp add: modified_def, clarsimp) 
      apply (erule_tac x=la in allE, erule impE,clarsimp) 
     apply rule apply (erule_tac x=l in allE, erule_tac x=R in allE, clarsimp) apply (subgoal_tac "a:R",fast) apply (erule Ref_reg) 
     apply clarsimp apply (case_tac "z=t")
                    (*z=t*) apply clarsimp apply (subgoal_tac "la \<notin> R") prefer 2 apply (erule_tac x=l in allE, erule_tac x=R in allE, erule impE,fastsimp) 
                            apply assumption
                    (*z\<noteq>t*) apply clarsimp apply (subgoal_tac "z:DOM C") prefer 2 apply (simp add: DOM_def)
                             apply (subgoal_tac "GETr (C(t\<mapsto>\<^sub>fListET k)) z = GETr C z",clarsimp) prefer 2 apply (rule GETr_Update1,fast)
                             apply (subgoal_tac "\<exists> RR SS . (RVal (renv E z), ha, GETr C z, RR, SS) \<in> reg", clarsimp)
                             apply (erule_tac x=z in allE, erule_tac x=RR in allE, erule impE, clarsimp) apply fast
                             apply (subgoal_tac "Rz = RR \<and> Sz = SS",fast)
                             apply (erule reg_Unique)
                             apply (rule reg_Preserved, assumption)
                             apply clarsimp apply (subgoal_tac "laa \<noteq> a", simp add: sameOH_def) 
                                 apply (subgoal_tac "a:R") prefer 2 apply (erule Ref_reg)
                                 apply (simp add: regionsDistinct_def)
                                 apply (erule_tac x=l in allE, erule_tac x=z in allE, erule_tac x=R in allE, erule_tac x=RR in allE,erule impE,clarsimp)
                                 apply (rule, fast) apply fast
                                 apply fast
                             apply (simp add: regionsExist_def)
                             apply (subgoal_tac "la \<noteq> a", simp add: sameOH_def) apply clarsimp
                             apply (erule_tac x=rfield in allE) apply (case_tac "rfield = DOLLAR_N", clarsimp, clarsimp)
                             apply (subgoal_tac "la \<notin> R")
                             apply (subgoal_tac "a : R",fast) apply (erule Ref_reg)
                             apply (erule_tac x=l in allE, erule_tac x=R in allE, erule impE, clarsimp) apply fast apply assumption
    apply (simp add: Bounded_def,rule, rule) apply (erule_tac x=la in allE, erule impE, simp) 
     apply (erule disjE) apply (rotate_tac -5, erule thin_rl) apply (rule disjI2) 
       apply (rule_tac x=l in exI, simp)
       apply (rule_tac x=R in exI, rule, rule_tac x=na in exI, assumption) apply (erule Ref_reg)
     apply (erule disjE,simp)
     apply (rule disjI2)
     apply clarsimp
     apply (case_tac "x=t")
     (*x=t*) apply (rotate_tac -9, erule thin_rl) apply (rotate_tac -10) apply(erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl) 
             apply clarsimp apply (rule_tac x=l in exI, clarsimp)  
             apply (rule_tac x=R in exI, rule, fast)   
             apply (subgoal_tac "Rx=R-{a} \<and> Sx = na-k", fast)
             apply (erule reg_Unique) apply (rule reg_Preserved) apply (simp add: GETr_def)
             apply clarsimp apply (simp add: sameOH_def)
     (*x\<noteq>t*) apply (rotate_tac -9, erule thin_rl) apply (rotate_tac -10) apply(erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl) 
             apply clarsimp apply (subgoal_tac "x:DOM C") prefer 2 apply (simp add: DOM_def)
             apply (subgoal_tac "\<exists> RR SS . (RVal (renv E x), ha, GETr C x,RR,SS):reg", clarsimp) 
             prefer 2 apply (simp add: regionsExist_def)
             apply (subgoal_tac "GETr (C(t\<mapsto>\<^sub>fListET k)) x = GETr C x",clarsimp) prefer 2 apply (rule GETr_Update1,fast)
             apply (subgoal_tac "Rx=RR \<and> Sx = SS", fast)
             apply (erule reg_Unique) apply (rule reg_Preserved, assumption) 
             apply clarsimp apply (subgoal_tac "laa \<noteq> a", simp add: sameOH_def) 
             apply (subgoal_tac "a:R") prefer 2 apply (erule Ref_reg)
             apply (simp add: regionsDistinct_def)
             apply (erule_tac x=l in allE, erule_tac x=x in allE, erule_tac x=R in allE, erule_tac x=RR in allE,erule impE,clarsimp, fast)
             apply fast
    apply (simp add: Bounded_def,rule, rule) apply (rotate_tac -5, erule thin_rl)
      apply (rotate_tac -10, erule thin_rl, erule thin_rl, erule thin_rl, erule thin_rl) 
      apply (erule_tac x=la in allE, erule impE, simp) 
      apply (erule disjE) apply (rule disjI2, clarsimp) 
        apply (rule_tac x=l in exI, simp, rule_tac x=R in exI, rule, rule_tac x=na in exI, assumption) apply (erule Ref_reg)
      apply (erule disjE,simp)
      apply (rule disjI2)
      apply clarsimp
      apply (subgoal_tac "x\<noteq>t")
        apply (subgoal_tac "x:DOM C") prefer 2 apply (simp add: DOM_def)
        apply (subgoal_tac "\<exists> RR SS . (RVal (renv E x), ha, GETr C x,RR,SS):reg", clarsimp) 
        prefer 2 apply (simp add: regionsExist_def)
        apply (rule_tac x=x in exI, simp) apply(rule_tac x=RR in exI, rule, fast)
        apply (subgoal_tac "GETr (C(t\<mapsto>\<^sub>fListET k)) x = GETr C x",clarsimp) prefer 2 apply (rule GETr_Update1,fast)  
        apply (subgoal_tac "Rx=RR \<and> Sx = SS", fast)
        apply (erule reg_Unique) apply (rule reg_Preserved, assumption) 
        apply clarsimp apply (subgoal_tac "laa \<noteq> a", simp add: sameOH_def)
        apply (subgoal_tac "a:R") prefer 2 apply (erule Ref_reg)
        apply (simp add: regionsDistinct_def)
        apply (erule_tac x=l in allE, erule_tac x=x in allE, erule_tac x=R in allE, erule_tac x=RR in allE,erule impE,clarsimp, fast)
        apply fast
      apply fast
done
(*>*)
        
lemma DA_Make_IID: 
"\<lbrakk>GETr C y = Some T; T = (ListET k);n=(Suc m + k)\<rbrakk> \<Longrightarrow>
  G \<rhd> (DIAM\<bullet>Make_IID ([VALarg (IVal 1), INarg x, RNarg y])) :  DAss {y} n C T m"
(*<*)
apply (rule vdm_invokestatic, simp) 
apply (rule CtxtWeakSingleton)
apply (simp add: Meth_Make_IID DAss_def, clarsimp)
apply (rule vdm_conseq, rule vdm_letr)
apply (subgoal_tac "G \<rhd>  (DIAM\<bullet>Alloc([])) : (\<lambda> E h hh v p . (h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace> = Nullref \<longrightarrow>
          hh = \<lparr>oheap = oheap h(freshloc (Dom h)\<mapsto>\<^sub>fDIAM), iheap = iheap h, rheap = rheap h, sheap = sheap h\<rparr> \<and> v = RVal (Ref (freshloc (Dom h)))) \<and> (h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace> \<noteq> Nullref \<longrightarrow> (\<exists> h1 r. (\<exists>a. h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace> = Ref a \<and> h1 = h \<and> r = h\<lfloor>a\<diamondsuit>DOLLAR_N\<rfloor>) \<and>
                           hh = h1\<lparr>sheap := (sheap h1)(DIAM := (sheap h1 DIAM)(DOLLAR_F := r))\<rparr> \<and>
                           v = RVal h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>)))",assumption)
apply (rule vdm_invokestatic)
apply (simp add: Meth_Alloc)
apply (rule CtxtWeakSingleton)
apply (rule vdm_conseq)
apply (rule vdm_letr)
apply (rule vdm_getstat)
apply (rule vdm_leti)
apply (rule vdm_rprim)
apply (rule vdm_if)
apply (rule vdm_new)
apply (rule Call1, simp add: Fun_AllocQ)
apply (rule CtxtWeakSingleton)
apply (rule vdm_letr)
apply (rule vdm_getfr)
apply (rule vdm_letv)
apply (rule vdm_putstat)
apply (rule vdm_rvar)
apply clarsimp 
apply (simp only: newObj_def newframe_env_def evalARGS_def) apply (simp add:self_def) apply clarsimp

apply (subgoal_tac "G \<rhd>  (DIAM\<bullet>Fill_DIID([RNarg x_, INarg tag_, INarg v0_, RNarg v1_])) : 
       (\<lambda> E h hh v p . \<forall> a . (E\<lfloor>x_\<rfloor> = Ref a \<longrightarrow>  hh=(h\<lparr>iheap := (iheap h)
                      (DOLLAR := (iheap h DOLLAR)
                         (a := ienv (newframe_env [RNpar x_, INpar tag_, INpar v0_, RNpar v1_, RNpar self]
                                      [RNarg x_, INarg tag_, INarg v0_, RNarg v1_, VALarg (RVal Nullref)] E)
                                tag_)),
                      iheap := (iheap h)
                        (DOLLAR := (iheap h DOLLAR)
                           (a := ienv (newframe_env [RNpar x_, INpar tag_, INpar v0_, RNpar v1_, RNpar self]
                                        [RNarg x_, INarg tag_, INarg v0_, RNarg v1_, VALarg (RVal Nullref)] E)
                                  tag_),
                         F0 := (iheap h F0)
                           (a := ienv (newframe_env [RNpar x_, INpar tag_, INpar v0_, RNpar v1_, RNpar self]
                                        [RNarg x_, INarg tag_, INarg v0_, RNarg v1_, VALarg (RVal Nullref)] E)
                                  v0_)),
                      rheap := (rheap h)
                        (F1 := (rheap h F1)
                           (a := renv (newframe_env [RNpar x_, INpar tag_, INpar v0_, RNpar v1_, RNpar self]
                                        [RNarg x_, INarg tag_, INarg v0_, RNarg v1_, VALarg (RVal Nullref)] E)
                                  v1_))\<rparr>) \<and>  v = (RVal (Ref a))))", assumption)
apply (rule vdm_invokestatic)
apply (simp add: Meth_Fill_DIID)
apply (rule CtxtWeakSingleton)
apply (rule vdm_conseq)
apply (rule vdm_letv, rule vdm_putfi)
apply (rule vdm_letv, rule vdm_putfi)
apply (rule vdm_letv, rule vdm_putfr)
apply (rule vdm_rvar,clarsimp)
apply (simp only: newObj_def newframe_env_def evalARGS_def) apply (simp add:self_def) 

apply clarsimp
apply (simp add: newObj_def newframe_env_def evalARGS_def self_def)
apply (subgoal_tac "y:DOM C") prefer 2 apply (erule GETrSome_DOM)
apply (case_tac "h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>")
prefer 2 
(*h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace> \<noteq> Nullref*) 
  apply clarsimp
  apply (simp add: freelist_def)
  apply (erule FL.elims, clarify, clarsimp)
  apply (simp add: regionsExist_def,clarsimp) 
  apply (rule_tac x="Rx \<union> {a}" in exI, rule_tac x="Sx+k" in exI, rule_tac x=n in exI, rule_tac x="X" in exI, clarsimp)
  apply (rule,erule FL_Preserved) apply (simp add: sameOH_def) 
  apply rule apply (simp add: distinctFrom_def) apply (erule_tac x=Rx in allE,erule impE,fast) apply clarsimp
    apply (erule reg.elims, clarify) apply (rule regList) apply (subgoal_tac "(Suc na,Ref a, R \<union> {a}, h
          \<lparr>sheap := (sheap h)(DIAM := (sheap h DIAM)(DOLLAR_F := h\<lfloor>a\<diamondsuit>DOLLAR_N\<rfloor>)), iheap := (iheap h)(DOLLAR := (iheap h DOLLAR)(a := 1)),
              iheap := (iheap h)(DOLLAR := (iheap h DOLLAR)(a := 1), F0 := (iheap h F0)(a := ienv E' x)),
              rheap := (rheap h)(F1 := (rheap h F1)(a := renv E' y))\<rparr>) \<in> mLIST", simp)
     apply (rule mLIST_CONS) apply simp apply simp apply simp 
        apply assumption apply (erule mLIST_Preserved) apply (subgoal_tac "l \<noteq> a", simp add: sameOH_def,fast)
     apply simp apply (clarify, clarify)
  apply rule apply (simp add: distinctFrom_def) apply (erule_tac x=Rx in allE,erule impE,fast) apply clarsimp
    apply (simp add: modified_def, clarsimp) apply (subgoal_tac "l \<noteq> a", simp add: sameOH_def,fast)
  apply (simp add: distinctFrom_def) apply (erule_tac x=Rx in allE,erule impE,fast) apply clarsimp
  apply (rule,simp add: Bounded_def,rule, rule) apply (rule disjI2, rule disjI2) apply (rule, fast) 
  apply (rule,simp add: Bounded_def) 
  apply (subgoal_tac "Sx \<le> CS", clarsimp) apply (erule ContextSize_contains_region) apply simp apply clarsimp apply assumption

(*h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace> = Nullref*) apply clarsimp
  apply (simp add: freelist_def)
  apply (erule FL.elims, clarsimp)
  apply clarsimp
done

lemma DA_make_IID: 
"\<lbrakk>GETr C y = Some T; T = (ListET k);nk=(Suc n + k);U={y}\<rbrakk> \<Longrightarrow>
  G \<rhd> (DIAM\<bullet>Make_IID ([VALarg (IVal 1), INarg x, RNarg y])) :  DAss U nk C T n"
by (rule vdm_conseq, rule DA_Make_IID,auto)
(*>*)

(*<*)
end
(*>*)
